// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/engine/enginepb/mvcc.proto

package enginepb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import bytes "bytes"

import encoding_binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// MVCCMetadata holds MVCC metadata for a key. Used by storage/engine/mvcc.go.
// An MVCCMetadata is stored for a versioned key while there is an intent on
// that key.
type MVCCMetadata struct {
	Txn *TxnMeta `protobuf:"bytes,1,opt,name=txn" json:"txn,omitempty"`
	// The timestamp of the most recent versioned value if this is a
	// value that may have multiple versions. For values which may have
	// only one version, the data is stored inline (via raw_bytes), and
	// timestamp is set to zero.
	Timestamp hlc.LegacyTimestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
	// Is the most recent value a deletion tombstone?
	Deleted bool `protobuf:"varint,3,opt,name=deleted" json:"deleted"`
	// The size in bytes of the most recent encoded key.
	KeyBytes int64 `protobuf:"varint,4,opt,name=key_bytes,json=keyBytes" json:"key_bytes"`
	// The size in bytes of the most recent versioned value.
	ValBytes int64 `protobuf:"varint,5,opt,name=val_bytes,json=valBytes" json:"val_bytes"`
	// Inline value, used for non-versioned values with zero
	// timestamp. This provides an efficient short circuit of the normal
	// MVCC metadata sentinel and subsequent version rows. If timestamp
	// == (0, 0), then there is only a single MVCC metadata row with
	// value inlined, and with empty timestamp, key_bytes, and
	// val_bytes.
	RawBytes []byte `protobuf:"bytes,6,opt,name=raw_bytes,json=rawBytes" json:"raw_bytes,omitempty"`
	// IntentHistory of the transaction stores the older values the txn wrote
	// for the key along with each values corresponding Sequence. It doesn't
	// contain the latest intent value but rather stores all the values that have
	// been overwritten by the transaction.
	// IntentHistory will be empty for non-transactional requests.
	IntentHistory []MVCCMetadata_SequencedIntent `protobuf:"bytes,8,rep,name=intent_history,json=intentHistory" json:"intent_history"`
	// This provides a measure of protection against replays caused by
	// Raft duplicating merge commands.
	MergeTimestamp       *hlc.LegacyTimestamp `protobuf:"bytes,7,opt,name=merge_timestamp,json=mergeTimestamp" json:"merge_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MVCCMetadata) Reset()         { *m = MVCCMetadata{} }
func (m *MVCCMetadata) String() string { return proto.CompactTextString(m) }
func (*MVCCMetadata) ProtoMessage()    {}
func (*MVCCMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc_09e838457798996e, []int{0}
}
func (m *MVCCMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCMetadata.Merge(dst, src)
}
func (m *MVCCMetadata) XXX_Size() int {
	return m.Size()
}
func (m *MVCCMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCMetadata proto.InternalMessageInfo

// SequencedIntent stores a value at a given key and the sequence number it was
// written at - to be stored in an IntentHistory of a key during a transaction.
type MVCCMetadata_SequencedIntent struct {
	// Sequence is a one-indexed number which is increased on each request
	// set as part of a transaction. It uniquely identifies a value from
	// the IntentHistory.
	Sequence int32 `protobuf:"varint,1,opt,name=sequence" json:"sequence"`
	// Value is the value written to the key as part of the transaction at
	// the above Sequence.
	Value                []byte   `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MVCCMetadata_SequencedIntent) Reset()         { *m = MVCCMetadata_SequencedIntent{} }
func (m *MVCCMetadata_SequencedIntent) String() string { return proto.CompactTextString(m) }
func (*MVCCMetadata_SequencedIntent) ProtoMessage()    {}
func (*MVCCMetadata_SequencedIntent) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc_09e838457798996e, []int{0, 0}
}
func (m *MVCCMetadata_SequencedIntent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCMetadata_SequencedIntent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCMetadata_SequencedIntent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCMetadata_SequencedIntent.Merge(dst, src)
}
func (m *MVCCMetadata_SequencedIntent) XXX_Size() int {
	return m.Size()
}
func (m *MVCCMetadata_SequencedIntent) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCMetadata_SequencedIntent.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCMetadata_SequencedIntent proto.InternalMessageInfo

// MVCCStats tracks byte and instance counts for various groups of keys,
// values, or key-value pairs; see the field comments for details.
//
// It also tracks two cumulative ages, namely that of intents and non-live
// (i.e. GC-able) bytes. This computation is intrinsically linked to
// last_update_nanos and is easy to get wrong. Updates happen only once every
// full second, as measured by last_update_nanos/1e9. That is, forward updates
// don't change last_update_nanos until an update at a timestamp which,
// truncated to the second, is ahead of last_update_nanos/1e9. Then, that
// difference in seconds times the base quantity (excluding the currently
// running update) is added to the age.
//
// To give an example, if an intent is around from `t=2.5s` to `t=4.1s` (the
// current time), then it contributes an intent age of two seconds (one second
// picked up when crossing `t=3s`, another one at `t=4s`). Similarly, if a
// GC'able kv pair is around for this amount of time, it contributes two seconds
// times its size in bytes.
//
// It gets more complicated when data is
// accounted for with a timestamp behind last_update_nanos. In this case, if
// more than a second has passed (computed via truncation above), the ages have
// to be adjusted to account for this late addition. This isn't hard: add the
// new data's base quantity times the (truncated) number of seconds behind.
// Important to keep in mind with those computations is that (x/1e9 - y/1e9)
// does not equal (x-y)/1e9 in most cases.
//
// Note that this struct must be kept at a fixed size by using fixed-size
// encodings for all fields and by making all fields non-nullable. This is
// so that it can predict its own impact on the size of the system-local
// kv-pairs.
type MVCCStats struct {
	// contains_estimates indicates that the MVCCStats object contains values
	// which have been estimated. This means that the stats should not be used
	// where complete accuracy is required, and instead should be recomputed
	// when necessary.
	ContainsEstimates bool `protobuf:"varint,14,opt,name=contains_estimates,json=containsEstimates" json:"contains_estimates"`
	// last_update_nanos is a timestamp at which the ages were last
	// updated. See the comment on MVCCStats.
	LastUpdateNanos int64 `protobuf:"fixed64,1,opt,name=last_update_nanos,json=lastUpdateNanos" json:"last_update_nanos"`
	// intent_age is the cumulative age of the tracked intents.
	// See the comment on MVCCStats.
	IntentAge int64 `protobuf:"fixed64,2,opt,name=intent_age,json=intentAge" json:"intent_age"`
	// gc_bytes_age is the cumulative age of the non-live data (i.e.
	// data included in key_bytes and val_bytes, but not live_bytes).
	// See the comment on MVCCStats.
	GCBytesAge int64 `protobuf:"fixed64,3,opt,name=gc_bytes_age,json=gcBytesAge" json:"gc_bytes_age"`
	// live_bytes is the number of bytes stored in keys and values which can in
	// principle be read by means of a Scan or Get in the far future, including
	// intents but not deletion tombstones (or their intents). Note that the
	// size of the meta kv pair (which could be explicit or implicit) is
	// included in this. Only the meta kv pair counts for the actual length of
	// the encoded key (regular pairs only count the timestamp suffix).
	LiveBytes int64 `protobuf:"fixed64,4,opt,name=live_bytes,json=liveBytes" json:"live_bytes"`
	// live_count is the number of meta keys tracked under live_bytes.
	LiveCount int64 `protobuf:"fixed64,5,opt,name=live_count,json=liveCount" json:"live_count"`
	// key_bytes is the number of bytes stored in all non-system
	// keys, including live, meta, old, and deleted keys.
	// Only meta keys really account for the "full" key; value
	// keys only for the timestamp suffix.
	KeyBytes int64 `protobuf:"fixed64,6,opt,name=key_bytes,json=keyBytes" json:"key_bytes"`
	// key_count is the number of meta keys tracked under key_bytes.
	KeyCount int64 `protobuf:"fixed64,7,opt,name=key_count,json=keyCount" json:"key_count"`
	// value_bytes is the number of bytes in all non-system version
	// values, including meta values.
	ValBytes int64 `protobuf:"fixed64,8,opt,name=val_bytes,json=valBytes" json:"val_bytes"`
	// val_count is the number of meta values tracked under val_bytes.
	ValCount int64 `protobuf:"fixed64,9,opt,name=val_count,json=valCount" json:"val_count"`
	// intent_bytes is the number of bytes in intent key-value
	// pairs (without their meta keys).
	IntentBytes int64 `protobuf:"fixed64,10,opt,name=intent_bytes,json=intentBytes" json:"intent_bytes"`
	// intent_count is the number of keys tracked under intent_bytes.
	// It is equal to the number of meta keys in the system with
	// a non-empty Transaction proto.
	IntentCount int64 `protobuf:"fixed64,11,opt,name=intent_count,json=intentCount" json:"intent_count"`
	// sys_bytes is the number of bytes stored in system-local kv-pairs.
	// This tracks the same quantity as (key_bytes + val_bytes), but
	// for system-local metadata keys (which aren't counted in either
	// key_bytes or val_bytes). Each of the keys falling into this group
	// is documented in keys/constants.go under the localPrefix constant
	// and is prefixed by either LocalRangeIDPrefix or LocalRangePrefix.
	SysBytes int64 `protobuf:"fixed64,12,opt,name=sys_bytes,json=sysBytes" json:"sys_bytes"`
	// sys_count is the number of meta keys tracked under sys_bytes.
	SysCount             int64    `protobuf:"fixed64,13,opt,name=sys_count,json=sysCount" json:"sys_count"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MVCCStats) Reset()         { *m = MVCCStats{} }
func (m *MVCCStats) String() string { return proto.CompactTextString(m) }
func (*MVCCStats) ProtoMessage()    {}
func (*MVCCStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc_09e838457798996e, []int{1}
}
func (m *MVCCStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCStats.Merge(dst, src)
}
func (m *MVCCStats) XXX_Size() int {
	return m.Size()
}
func (m *MVCCStats) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCStats.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCStats proto.InternalMessageInfo

func init() {
	proto.RegisterType((*MVCCMetadata)(nil), "cockroach.storage.engine.enginepb.MVCCMetadata")
	proto.RegisterType((*MVCCMetadata_SequencedIntent)(nil), "cockroach.storage.engine.enginepb.MVCCMetadata.SequencedIntent")
	proto.RegisterType((*MVCCStats)(nil), "cockroach.storage.engine.enginepb.MVCCStats")
}
func (this *MVCCMetadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MVCCMetadata)
	if !ok {
		that2, ok := that.(MVCCMetadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Txn.Equal(that1.Txn) {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	if this.Deleted != that1.Deleted {
		return false
	}
	if this.KeyBytes != that1.KeyBytes {
		return false
	}
	if this.ValBytes != that1.ValBytes {
		return false
	}
	if !bytes.Equal(this.RawBytes, that1.RawBytes) {
		return false
	}
	if len(this.IntentHistory) != len(that1.IntentHistory) {
		return false
	}
	for i := range this.IntentHistory {
		if !this.IntentHistory[i].Equal(&that1.IntentHistory[i]) {
			return false
		}
	}
	if !this.MergeTimestamp.Equal(that1.MergeTimestamp) {
		return false
	}
	return true
}
func (this *MVCCMetadata_SequencedIntent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MVCCMetadata_SequencedIntent)
	if !ok {
		that2, ok := that.(MVCCMetadata_SequencedIntent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Sequence != that1.Sequence {
		return false
	}
	if !bytes.Equal(this.Value, that1.Value) {
		return false
	}
	return true
}
func (this *MVCCStats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MVCCStats)
	if !ok {
		that2, ok := that.(MVCCStats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ContainsEstimates != that1.ContainsEstimates {
		return false
	}
	if this.LastUpdateNanos != that1.LastUpdateNanos {
		return false
	}
	if this.IntentAge != that1.IntentAge {
		return false
	}
	if this.GCBytesAge != that1.GCBytesAge {
		return false
	}
	if this.LiveBytes != that1.LiveBytes {
		return false
	}
	if this.LiveCount != that1.LiveCount {
		return false
	}
	if this.KeyBytes != that1.KeyBytes {
		return false
	}
	if this.KeyCount != that1.KeyCount {
		return false
	}
	if this.ValBytes != that1.ValBytes {
		return false
	}
	if this.ValCount != that1.ValCount {
		return false
	}
	if this.IntentBytes != that1.IntentBytes {
		return false
	}
	if this.IntentCount != that1.IntentCount {
		return false
	}
	if this.SysBytes != that1.SysBytes {
		return false
	}
	if this.SysCount != that1.SysCount {
		return false
	}
	return true
}
func (m *MVCCMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCMetadata) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txn != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(m.Txn.Size()))
		n1, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.Timestamp.Size()))
	n2, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x18
	i++
	if m.Deleted {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x20
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.KeyBytes))
	dAtA[i] = 0x28
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.ValBytes))
	if m.RawBytes != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(len(m.RawBytes)))
		i += copy(dAtA[i:], m.RawBytes)
	}
	if m.MergeTimestamp != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(m.MergeTimestamp.Size()))
		n3, err := m.MergeTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.IntentHistory) > 0 {
		for _, msg := range m.IntentHistory {
			dAtA[i] = 0x42
			i++
			i = encodeVarintMvcc(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *MVCCMetadata_SequencedIntent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCMetadata_SequencedIntent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.Sequence))
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *MVCCStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x9
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.LastUpdateNanos))
	i += 8
	dAtA[i] = 0x11
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.IntentAge))
	i += 8
	dAtA[i] = 0x19
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.GCBytesAge))
	i += 8
	dAtA[i] = 0x21
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.LiveBytes))
	i += 8
	dAtA[i] = 0x29
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.LiveCount))
	i += 8
	dAtA[i] = 0x31
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.KeyBytes))
	i += 8
	dAtA[i] = 0x39
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.KeyCount))
	i += 8
	dAtA[i] = 0x41
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.ValBytes))
	i += 8
	dAtA[i] = 0x49
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.ValCount))
	i += 8
	dAtA[i] = 0x51
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.IntentBytes))
	i += 8
	dAtA[i] = 0x59
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.IntentCount))
	i += 8
	dAtA[i] = 0x61
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.SysBytes))
	i += 8
	dAtA[i] = 0x69
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.SysCount))
	i += 8
	dAtA[i] = 0x70
	i++
	if m.ContainsEstimates {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func encodeVarintMvcc(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedMVCCMetadata(r randyMvcc, easy bool) *MVCCMetadata {
	this := &MVCCMetadata{}
	if r.Intn(10) != 0 {
		this.Txn = NewPopulatedTxnMeta(r, easy)
	}
	v1 := hlc.NewPopulatedLegacyTimestamp(r, easy)
	this.Timestamp = *v1
	this.Deleted = bool(bool(r.Intn(2) == 0))
	this.KeyBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyBytes *= -1
	}
	this.ValBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValBytes *= -1
	}
	if r.Intn(10) != 0 {
		v2 := r.Intn(100)
		this.RawBytes = make([]byte, v2)
		for i := 0; i < v2; i++ {
			this.RawBytes[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		this.MergeTimestamp = hlc.NewPopulatedLegacyTimestamp(r, easy)
	}
	if r.Intn(10) != 0 {
		v3 := r.Intn(5)
		this.IntentHistory = make([]MVCCMetadata_SequencedIntent, v3)
		for i := 0; i < v3; i++ {
			v4 := NewPopulatedMVCCMetadata_SequencedIntent(r, easy)
			this.IntentHistory[i] = *v4
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMVCCMetadata_SequencedIntent(r randyMvcc, easy bool) *MVCCMetadata_SequencedIntent {
	this := &MVCCMetadata_SequencedIntent{}
	this.Sequence = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Sequence *= -1
	}
	if r.Intn(10) != 0 {
		v5 := r.Intn(100)
		this.Value = make([]byte, v5)
		for i := 0; i < v5; i++ {
			this.Value[i] = byte(r.Intn(256))
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMVCCStats(r randyMvcc, easy bool) *MVCCStats {
	this := &MVCCStats{}
	this.LastUpdateNanos = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LastUpdateNanos *= -1
	}
	this.IntentAge = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentAge *= -1
	}
	this.GCBytesAge = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.GCBytesAge *= -1
	}
	this.LiveBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LiveBytes *= -1
	}
	this.LiveCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LiveCount *= -1
	}
	this.KeyBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyBytes *= -1
	}
	this.KeyCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyCount *= -1
	}
	this.ValBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValBytes *= -1
	}
	this.ValCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValCount *= -1
	}
	this.IntentBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentBytes *= -1
	}
	this.IntentCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentCount *= -1
	}
	this.SysBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.SysBytes *= -1
	}
	this.SysCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.SysCount *= -1
	}
	this.ContainsEstimates = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyMvcc interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMvcc(r randyMvcc) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMvcc(r randyMvcc) string {
	v6 := r.Intn(100)
	tmps := make([]rune, v6)
	for i := 0; i < v6; i++ {
		tmps[i] = randUTF8RuneMvcc(r)
	}
	return string(tmps)
}
func randUnrecognizedMvcc(r randyMvcc, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMvcc(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMvcc(dAtA []byte, r randyMvcc, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(key))
		v7 := r.Int63()
		if r.Intn(2) == 0 {
			v7 *= -1
		}
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(v7))
	case 1:
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMvcc(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *MVCCMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovMvcc(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc(uint64(l))
	n += 2
	n += 1 + sovMvcc(uint64(m.KeyBytes))
	n += 1 + sovMvcc(uint64(m.ValBytes))
	if m.RawBytes != nil {
		l = len(m.RawBytes)
		n += 1 + l + sovMvcc(uint64(l))
	}
	if m.MergeTimestamp != nil {
		l = m.MergeTimestamp.Size()
		n += 1 + l + sovMvcc(uint64(l))
	}
	if len(m.IntentHistory) > 0 {
		for _, e := range m.IntentHistory {
			l = e.Size()
			n += 1 + l + sovMvcc(uint64(l))
		}
	}
	return n
}

func (m *MVCCMetadata_SequencedIntent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovMvcc(uint64(m.Sequence))
	if m.Value != nil {
		l = len(m.Value)
		n += 1 + l + sovMvcc(uint64(l))
	}
	return n
}

func (m *MVCCStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 2
	return n
}

func sovMvcc(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMvcc(x uint64) (n int) {
	return sovMvcc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MVCCMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &TxnMeta{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Deleted = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyBytes", wireType)
			}
			m.KeyBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValBytes", wireType)
			}
			m.ValBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawBytes = append(m.RawBytes[:0], dAtA[iNdEx:postIndex]...)
			if m.RawBytes == nil {
				m.RawBytes = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeTimestamp == nil {
				m.MergeTimestamp = &hlc.LegacyTimestamp{}
			}
			if err := m.MergeTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentHistory = append(m.IntentHistory, MVCCMetadata_SequencedIntent{})
			if err := m.IntentHistory[len(m.IntentHistory)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCMetadata_SequencedIntent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SequencedIntent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SequencedIntent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateNanos", wireType)
			}
			m.LastUpdateNanos = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.LastUpdateNanos = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentAge", wireType)
			}
			m.IntentAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentAge = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCBytesAge", wireType)
			}
			m.GCBytesAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.GCBytesAge = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveBytes", wireType)
			}
			m.LiveBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.LiveBytes = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveCount", wireType)
			}
			m.LiveCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.LiveCount = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyBytes", wireType)
			}
			m.KeyBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyBytes = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 7:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyCount", wireType)
			}
			m.KeyCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyCount = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 8:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValBytes", wireType)
			}
			m.ValBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.ValBytes = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 9:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValCount", wireType)
			}
			m.ValCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.ValCount = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 10:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentBytes", wireType)
			}
			m.IntentBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentBytes = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 11:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentCount", wireType)
			}
			m.IntentCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentCount = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 12:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysBytes", wireType)
			}
			m.SysBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.SysBytes = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 13:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysCount", wireType)
			}
			m.SysCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.SysCount = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainsEstimates", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainsEstimates = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMvcc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMvcc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMvcc
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMvcc
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMvcc(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMvcc = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMvcc   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("storage/engine/enginepb/mvcc.proto", fileDescriptor_mvcc_09e838457798996e)
}

var fileDescriptor_mvcc_09e838457798996e = []byte{
	// 632 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x93, 0x4f, 0x4f, 0xd4, 0x40,
	0x14, 0xc0, 0xa9, 0xbb, 0x40, 0x77, 0xb6, 0x80, 0x4c, 0x38, 0x34, 0x98, 0x74, 0xcb, 0x72, 0x70,
	0xe3, 0xa1, 0x6b, 0xc0, 0x93, 0x31, 0x31, 0xb0, 0x31, 0x68, 0x02, 0x1e, 0x0a, 0x7a, 0xf0, 0xd2,
	0x0c, 0xb3, 0x93, 0x6e, 0x43, 0x77, 0xba, 0x76, 0x66, 0x17, 0xfa, 0x2d, 0xfc, 0x08, 0x7c, 0x07,
	0x2f, 0x7e, 0x01, 0x13, 0x8e, 0x1e, 0x3d, 0x11, 0x5d, 0x2f, 0x7e, 0x0c, 0x33, 0xff, 0xda, 0xb2,
	0x26, 0xca, 0x89, 0xd9, 0xf7, 0x7e, 0xf3, 0x9b, 0xd7, 0xf7, 0x1e, 0xa0, 0xcb, 0x78, 0x96, 0xa3,
	0x98, 0xf4, 0x09, 0x8d, 0x13, 0x6a, 0xfe, 0x4c, 0xce, 0xfb, 0xe3, 0x19, 0xc6, 0xc1, 0x24, 0xcf,
	0x78, 0x06, 0x77, 0x70, 0x86, 0x2f, 0xf2, 0x0c, 0xe1, 0x51, 0xa0, 0xe9, 0x40, 0x61, 0x81, 0xa1,
	0xb7, 0x77, 0xff, 0xa5, 0xd9, 0x57, 0x9e, 0xed, 0xce, 0x94, 0x27, 0x69, 0x7f, 0x94, 0xe2, 0x7e,
	0x4a, 0x62, 0x84, 0x8b, 0x88, 0x27, 0x63, 0xc2, 0x38, 0x1a, 0x4f, 0x34, 0xb0, 0x15, 0x67, 0x71,
	0x26, 0x8f, 0x7d, 0x71, 0x52, 0xd1, 0xee, 0xe7, 0x26, 0x70, 0x4e, 0xde, 0x0f, 0x06, 0x27, 0x84,
	0xa3, 0x21, 0xe2, 0x08, 0xbe, 0x00, 0x0d, 0x7e, 0x45, 0x5d, 0xcb, 0xb7, 0x7a, 0xed, 0xbd, 0x27,
	0xc1, 0x7f, 0xab, 0x0b, 0xce, 0xae, 0xa8, 0xb8, 0x1c, 0x8a, 0x6b, 0xf0, 0x08, 0xb4, 0xca, 0x77,
	0xdd, 0x07, 0xd2, 0xb1, 0x5b, 0x73, 0x88, 0x1a, 0x83, 0x51, 0x8a, 0x83, 0x63, 0x59, 0xe3, 0x99,
	0x41, 0x0f, 0x9b, 0x37, 0xb7, 0x9d, 0xa5, 0xb0, 0xba, 0x0b, 0x3d, 0xb0, 0x3a, 0x24, 0x29, 0xe1,
	0x64, 0xe8, 0x36, 0x7c, 0xab, 0x67, 0x6b, 0xc2, 0x04, 0xe1, 0x0e, 0x68, 0x5d, 0x90, 0x22, 0x3a,
	0x2f, 0x38, 0x61, 0x6e, 0xd3, 0xb7, 0x7a, 0x0d, 0x4d, 0xd8, 0x17, 0xa4, 0x38, 0x14, 0x51, 0x81,
	0xcc, 0x50, 0xaa, 0x91, 0xe5, 0x3a, 0x32, 0x43, 0xa9, 0x42, 0x1e, 0x81, 0x56, 0x8e, 0x2e, 0x35,
	0xb2, 0xe2, 0x5b, 0x3d, 0x27, 0xb4, 0x73, 0x74, 0xa9, 0x92, 0xc7, 0x60, 0x63, 0x4c, 0xf2, 0x98,
	0x54, 0x9d, 0x74, 0x57, 0xef, 0xfd, 0x45, 0xe1, 0xba, 0xbc, 0x5b, 0xfe, 0x86, 0x29, 0x58, 0x4f,
	0x28, 0x27, 0x94, 0x47, 0xa3, 0x44, 0xb4, 0xb2, 0x70, 0x6d, 0xbf, 0xd1, 0x6b, 0xef, 0xbd, 0xbc,
	0x47, 0x8b, 0xeb, 0x03, 0x0a, 0x4e, 0xc9, 0xc7, 0x29, 0xa1, 0x98, 0x0c, 0xdf, 0x48, 0x9d, 0xfe,
	0xa6, 0x35, 0x25, 0x7f, 0xad, 0xdc, 0xdb, 0xa7, 0x60, 0x63, 0x81, 0x83, 0x3e, 0xb0, 0x99, 0x0e,
	0xc9, 0xe9, 0x2e, 0x9b, 0x6e, 0x98, 0x28, 0xdc, 0x02, 0xcb, 0x33, 0x94, 0x4e, 0x89, 0x1c, 0x9c,
	0x13, 0xaa, 0x1f, 0xcf, 0xed, 0x2f, 0xd7, 0x1d, 0xeb, 0xf7, 0x75, 0xc7, 0xaa, 0x4e, 0xdd, 0xaf,
	0x4d, 0xd0, 0x12, 0x45, 0x9d, 0x72, 0xc4, 0x19, 0x7c, 0x0a, 0x36, 0x53, 0xc4, 0x78, 0x34, 0x9d,
	0x0c, 0x11, 0x27, 0x11, 0x45, 0x34, 0x63, 0xf2, 0x89, 0x87, 0xfa, 0x89, 0x0d, 0x91, 0x7e, 0x27,
	0xb3, 0x6f, 0x45, 0x12, 0xee, 0x02, 0xa0, 0x9b, 0x81, 0x62, 0xf5, 0x9c, 0x41, 0x5b, 0x2a, 0x7e,
	0x10, 0x13, 0xf8, 0x0c, 0x38, 0x31, 0x56, 0xb3, 0x91, 0x58, 0x43, 0x62, 0x50, 0x60, 0xf3, 0xdb,
	0x0e, 0x38, 0x1a, 0xc8, 0x31, 0x1d, 0xc4, 0x24, 0x04, 0x31, 0x36, 0x67, 0xa1, 0x4e, 0x93, 0x19,
	0xa9, 0x6d, 0x46, 0xa9, 0x16, 0x71, 0x35, 0x5a, 0x03, 0xe1, 0x6c, 0x4a, 0xb9, 0xdc, 0x8d, 0x3b,
	0xd0, 0x40, 0x84, 0xef, 0xae, 0xd8, 0x4a, 0x8d, 0xb9, 0xb3, 0x62, 0x02, 0x51, 0x9a, 0xd5, 0x05,
	0xa4, 0xb4, 0x54, 0x5b, 0x68, 0xd7, 0x91, 0x72, 0x0b, 0x35, 0xa2, 0x2c, 0xad, 0x05, 0x44, 0x59,
	0x1e, 0x03, 0x47, 0x37, 0x4c, 0x89, 0x40, 0x8d, 0x6a, 0xab, 0x8c, 0x72, 0x55, 0xa0, 0xd2, 0xb5,
	0xff, 0x06, 0xcb, 0xba, 0x58, 0xc1, 0xb4, 0xce, 0xa9, 0x3f, 0xca, 0x0a, 0x56, 0xd6, 0x25, 0x10,
	0x25, 0x5a, 0x5b, 0x40, 0x94, 0x65, 0x1f, 0x40, 0x9c, 0x51, 0x8e, 0x12, 0xca, 0x22, 0xc2, 0x78,
	0x32, 0x46, 0x42, 0xb7, 0x5e, 0xfb, 0x8f, 0xdd, 0x34, 0xf9, 0x57, 0x26, 0x5d, 0xed, 0xd1, 0x61,
	0xf7, 0xe6, 0xa7, 0xb7, 0x74, 0x33, 0xf7, 0xac, 0x6f, 0x73, 0xcf, 0xfa, 0x3e, 0xf7, 0xac, 0x1f,
	0x73, 0xcf, 0xfa, 0xf4, 0xcb, 0x5b, 0xfa, 0x60, 0x9b, 0xe5, 0xff, 0x13, 0x00, 0x00, 0xff, 0xff,
	0x10, 0xd3, 0xc3, 0xa8, 0x45, 0x05, 0x00, 0x00,
}
