// Code generated by go-bindata. DO NOT EDIT.
// sources:
// test_certs/ca.crt
// test_certs/ca.key
// test_certs/client.root.crt
// test_certs/client.root.key
// test_certs/client.testuser.crt
// test_certs/client.testuser.key
// test_certs/node.crt
// test_certs/node.key

package securitytest

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _test_certsCaCrt = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x94\xc9\xd2\xb2\x38\x14\x40\xf7\x3c\x45\xef\xa9\x2e\x34\x88\xc2\x32\x21\x01\x99\x82\x4c\x22\xee\x40\x24\x0c\x8a\xca\x60\x94\xa7\xef\xfa\xbe\xde\x74\xf5\x7f\x97\xb7\xee\xe2\x54\x9d\x5b\xe7\xef\x9f\x41\xc4\xb4\xe8\x5f\x3a\x09\x63\xcb\xb0\x74\x18\x93\xdf\xad\xe0\x59\x16\xd6\xb1\xae\xc3\x4a\x67\x90\x5b\x08\x32\x2b\x88\xe4\x77\xd3\x6a\xdb\x2d\x98\x1b\x1d\x9e\x9f\xb3\xf4\x15\xef\x22\x86\x14\xb1\xee\x55\x77\x8d\xa9\xf1\x15\x82\xc1\x68\x40\x0c\x07\xc1\x0b\x2d\x4e\x60\x86\x8f\x41\xe0\x10\x7e\xc3\x05\xa0\xc3\xe5\xae\xd5\x19\x60\x1f\x23\x86\x31\x62\xf4\x88\xa0\x17\x63\x42\xdf\x19\x98\xbe\x05\x30\xda\x5c\x47\x38\x88\x21\x33\xf8\xea\x23\xd0\x05\x2e\x5e\xdb\x7d\xe8\x12\xc8\x14\x87\xb9\x09\x55\xc5\x8f\x3b\xc5\xc3\x84\x7b\x31\xe4\x1e\x86\xdc\x33\x1e\xdc\x59\x48\xe4\x21\x68\xc2\x75\x42\xf4\xda\xb3\x03\xa0\xb5\xb9\x6c\xbf\x85\x2c\xa5\x0f\x2f\x4c\x38\xe1\xbf\x14\x98\xf0\xcf\x7f\x29\x58\xb0\x22\x9c\x31\xd2\x78\x70\x65\xea\xd1\xcb\x8c\xac\x42\xc6\x01\x41\x30\x48\x20\xdc\x58\x48\xc0\x1c\xfe\x1c\x38\xf0\x61\x21\x18\xe0\x2a\xdc\x1c\x2b\x0b\x56\xa0\xd5\xce\x9e\x5d\x8e\x31\x53\xdf\x7e\x39\x2e\x3b\xb7\x8e\xd8\x71\xf1\x1c\xd9\x5b\xe2\xf3\xb8\xbb\x87\x69\xec\x07\x52\x79\x16\x66\xf1\xf1\x1d\x71\xa1\x7f\x87\x35\x1a\x23\x62\x24\x4c\x0e\x64\xb4\xa8\x7c\xf0\x0b\x67\x5d\x42\x6f\xb3\xa2\x1e\xb9\x26\x37\xc7\xdf\x1f\x13\x71\x94\xe6\x2b\xbf\x4d\x13\x1a\xdc\x8d\xd4\xf3\xfd\x24\x80\x8d\x9f\x1e\x1e\xec\x1e\xd8\x9b\x1c\x95\xec\x81\xc3\x8b\x6a\xa7\x64\x88\x2a\xda\x96\xaf\x6c\x34\x3a\x32\x42\x15\x2a\x57\x6d\xdb\x3e\xe2\xfa\x73\x2e\xfa\x42\x6d\xc0\xfb\x95\x68\x13\xe8\xde\xba\xc0\xa2\x6f\xf3\x71\x92\xc7\x3d\x26\xf9\x59\x51\x8e\x8a\x94\xec\xcb\xf8\x72\xcb\x73\x97\xee\x9f\x20\x25\x59\x93\x9e\xbe\x71\x90\x14\x7a\x7e\x57\x76\xda\x8e\x6f\x69\x44\x8f\xdd\x92\xe4\xd8\xbe\x1d\x57\xc2\x13\x10\x39\x59\x7a\x7e\xb2\xb4\xb6\xdb\xf5\xbb\x8e\x9c\xdd\x77\xe8\x77\xd5\xfc\x7a\x81\x5a\x3e\xa9\xb1\x78\x0b\x77\xc0\x2d\x12\xe3\xa0\x00\xa9\x2b\x6d\x89\x3e\x0f\x26\x6e\x24\x37\x1d\xc9\xdd\x11\xe4\xdb\xd7\x33\xe2\x25\x7d\x3e\x8b\xbe\xd0\xc7\xf3\x7c\x9e\xee\x57\xfd\x8e\x5f\x27\x33\xdb\xee\x50\xa2\x31\x2e\x43\xe6\x21\x08\xcd\xd6\x6e\x61\xe7\xc1\xcd\x8f\xca\x12\x73\x82\x24\x1e\x10\x01\x72\x4b\x57\x30\x8c\x7e\x1e\x66\x1f\x7a\x08\x56\x2a\xd1\x31\x34\x61\xb0\x97\x20\x23\xe8\xff\xfa\x74\xfe\xaf\x3e\x18\xa0\xb9\x03\xb7\x83\xb0\x2f\xa5\x3d\x6b\x87\x81\x5e\x1a\x90\x24\xf4\x64\x22\x3a\xcb\xc3\xc1\xb7\x57\x9a\xcf\x9e\xe1\x7a\x06\x59\xe6\x2f\xf6\x2d\x71\xa9\xab\xaf\xf6\x80\xdb\xb9\xb9\xba\xbd\x1b\x45\x94\xc2\x47\x33\x5d\x84\x97\x7c\x49\xab\x25\xce\xed\x83\x16\x5a\x27\xc7\x0c\xdc\xce\x3a\x38\xe8\x9a\x6f\x97\xe8\x30\xce\x4a\xd6\x2b\xac\x12\x53\x51\xfb\xc8\x47\xe2\x9c\x49\xd6\xc4\xb9\xbe\x3b\x89\xc5\x46\xb2\x55\xe3\x65\x0a\xfd\x70\x6e\xbf\x15\x29\x27\x89\xd4\xeb\xeb\x48\xa8\x89\x72\x11\xcd\x0d\x9a\xb2\x7e\xf3\x75\x4b\x40\xe0\xd3\x45\x91\xf8\xc8\x8e\x2b\x5d\xdc\x16\x1b\x6d\xbf\xa5\x7b\xaf\xdf\xf5\x52\x68\xc4\xa3\x2a\x34\x49\xe3\xbc\x62\x63\xb3\x4e\xc9\x50\xba\x85\x81\xb7\x72\xa1\x92\xd9\xf5\xaf\x5f\xe7\xd4\x13\x33\x44\xd3\x25\x41\x45\x4b\x9f\x15\x63\x4a\x53\x57\x20\xfd\xf4\x87\xe6\x12\xdf\xdf\xf6\xad\x4d\x76\x82\xb7\xd9\x82\x5d\x62\x3f\xa5\xbb\xce\x7c\x6b\x41\x92\x49\x40\x28\x0e\xb2\x53\x5f\x70\xb9\x3e\x89\x0b\xe0\x99\x0c\xab\xbe\x8e\xcf\xe9\xa1\x56\x6b\xbf\xbc\x72\x7f\x7f\x9f\xad\x6f\xbd\x3a\x54\x91\x2b\x54\x2a\x7d\x7e\xd2\x08\xcc\x5c\x9f\x4a\xac\x4e\xc2\x6f\x26\x08\xc5\x7f\xa6\xe3\x9f\x00\x00\x00\xff\xff\x14\x79\x4e\xe2\x57\x04\x00\x00")

func test_certsCaCrtBytes() ([]byte, error) {
	return bindataRead(
		_test_certsCaCrt,
		"test_certs/ca.crt",
	)
}

func test_certsCaCrt() (*asset, error) {
	bytes, err := test_certsCaCrtBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "test_certs/ca.crt", size: 1111, mode: os.FileMode(384), modTime: time.Unix(1400000000, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _test_certsCaKey = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\x95\xb5\x12\xa4\x8a\x02\x05\x73\xbe\x62\x73\xea\x15\x6e\x21\xae\x83\x7b\x86\x3b\x0c\x32\xd8\xd7\xbf\xda\x8d\xef\x49\x4f\xd2\xd5\x49\xff\xef\xef\x38\x51\x56\xcd\x3f\xae\xc7\xfe\xb1\x5d\x35\x64\x7d\xf1\x8f\x2e\x26\xff\x1e\xe0\xa3\xaa\xe2\x72\xa9\x1c\xcb\xea\x3c\xeb\x88\x2c\x06\x57\x52\xfc\xb0\x0a\xb3\x40\x91\xcf\xc7\xb9\x88\xdb\xc6\x3b\xe7\x1f\xf0\xc1\x83\x45\x2a\x5e\xfe\x78\x3f\x30\x9a\x5b\xc4\x10\x0e\xef\x60\x63\x40\x94\x9f\xeb\x67\x63\xd1\x6b\x5f\x19\x27\x17\x5b\x2e\x54\x4d\xd8\xbc\x0a\xe8\xa3\xbf\xd3\x73\xc4\x8e\x60\x99\x82\xcf\x29\xa3\xe6\xf5\x2d\x12\xda\x9b\x4d\xcd\xbb\x96\xe7\x4e\xf6\x80\x36\x41\x73\x00\x55\xfe\x84\xb1\x27\x55\x6d\xe0\x2b\xb9\x89\x13\x9d\x85\x63\x9b\x0f\x5b\x1d\x9e\xdf\x04\xcb\x26\x83\x4b\x39\x83\xb5\x59\x2b\x3e\xab\x85\x14\xf1\x22\x8a\x08\x14\x52\x8f\x8d\x1c\xed\xbc\xfc\x1a\xc0\xb5\x88\xfb\xb2\x7b\xa3\xae\x0d\xb7\x3c\x55\x55\x58\xd5\x08\x87\x05\x98\x16\x4d\xdd\xeb\x92\xe5\xd8\xca\xea\x38\xd2\x03\x2c\xc9\xd7\xf4\xfd\x55\x50\x45\x5b\x7d\xd0\x87\xe9\x07\x91\x9b\x27\x0d\x81\x52\x2f\x5b\x13\xf9\x10\xb4\xf4\xd8\x09\x61\x11\x20\xc1\xc9\x1e\x05\xfb\x5f\x85\x5a\xd7\x63\x29\x11\x48\x84\xbe\x41\xc5\x74\x28\xc2\xf9\x60\x79\x12\x8a\x57\xbf\x99\x7f\x37\xf8\xf9\x20\x1b\xa7\x01\xdd\x41\x14\x3d\x17\xd0\xc8\x9a\x45\x04\x7a\x6d\x72\x3e\xe5\xe9\xdc\x7c\x1b\x72\xbc\x27\xeb\x77\x85\x76\xf2\x31\x2f\x55\x60\x1d\x96\x63\x97\xbf\xb2\xdd\xf4\x42\x57\x55\x16\xc0\x66\x65\x18\x13\x00\x93\x3a\x82\xb5\x3e\xf0\x8b\xe6\x35\xf4\x09\xd3\x03\xed\xa5\xec\xd8\x1c\x9a\x8e\x9d\xc9\x82\x70\x0a\x30\x79\xf7\xf4\x12\xbf\x62\xac\x08\x1b\x5c\xa6\x08\x47\x39\x2f\xf3\xda\x94\x81\xca\x78\x00\x4c\x2e\xda\xa9\xb8\x8b\xb9\x21\xa6\x3f\x64\xff\xcb\x48\x56\x0e\x70\x73\x89\xdd\x23\xad\x91\x4a\xe4\xf4\x2e\x43\x50\xcf\x14\x23\x36\x2c\x04\x1a\xeb\x41\xf0\x44\x53\xd8\xcc\xa2\xd6\x68\x89\xca\x06\x7a\xf8\xc8\x66\xb2\xc5\x89\xfe\xc5\x9b\x0a\x0e\xfc\x4e\x85\xda\x9e\x8f\x99\x39\xfe\x5d\x92\x48\x5a\x7a\x16\x8e\xf2\xf1\xa3\x26\x37\x1f\xaf\x2e\x72\xf6\xab\x57\xed\xa3\xa2\xfc\x79\xb1\x93\x5e\x00\xcc\xa4\xf1\x09\xf3\x5c\x7e\x05\x24\xa3\x7b\xe8\xd5\x52\xb4\x8f\xf2\x57\x97\xec\x7d\x5a\x17\x42\xcc\xe5\xe1\xac\xc2\x48\xe1\x7d\xe3\xe7\xd8\xd8\xf7\x78\x2d\x46\xc8\x2e\x3f\x87\xcd\x03\x3c\x3d\x1f\xb8\x92\xcf\x43\x90\x7b\x1c\x0d\x8c\x2d\x3d\x4d\xff\x3d\xf7\x1b\x02\x67\x16\xf5\x75\x63\x6c\xb5\xc5\xca\x88\x34\xb4\xd4\x46\x44\x38\xc8\x2f\x18\x3e\x08\x52\x89\xa2\x95\x03\x05\xb9\xdb\x84\xf6\x16\xa0\x89\x02\xa9\xb9\x81\x6f\x12\x91\xa5\x0a\xf0\x2e\xa5\x50\x38\x68\x8e\x5a\xc6\x77\x49\x4b\x87\x84\x03\xa9\xc3\xb6\x81\x3f\x2d\x88\xb3\xd2\x11\x66\x7b\x47\x42\xc6\x79\x43\x41\xfc\xb9\x65\x57\x00\x44\x95\x45\x5d\xd9\x4f\x49\xad\x65\xfd\x53\x44\x1b\x1d\x7e\x53\xc5\x7f\x29\x96\x17\xd7\x34\xc7\xa9\x8d\x77\x91\xfe\x81\x3e\xac\xba\xbc\x4f\x02\xed\x68\xc8\x41\x7b\x35\xc5\xe7\x4b\x86\xe7\x7d\x00\x77\x31\x2e\x23\x4d\xad\x63\xa4\x9b\xa1\x6b\xd5\xb3\xde\x89\x0a\x18\x78\x36\x0b\xf2\x32\x37\x4e\x9c\xe1\xb7\x42\x98\x4f\x59\xe2\x45\x86\x5b\xb1\xc8\x0a\xd6\x3b\x06\xff\x23\xa6\xa5\xc3\x00\x7a\x2e\xd7\xc7\xae\x57\xce\x0e\xf1\xf6\x7a\x65\x1c\xb8\x30\xc7\x00\x2b\xcd\xa0\xe1\xa8\x2d\xf7\xed\x81\xc4\x14\xc9\xa0\xcb\x61\x51\x98\x74\xf4\x67\xb7\x9e\xaa\x6f\x0f\x65\x66\x9d\xb2\x8e\x34\x01\x60\xb2\x77\x75\x03\xb5\x0e\xee\x4f\xf4\x7e\x16\xed\x2c\x04\x28\xc9\x24\xcb\x40\x0d\xb1\x37\x18\x98\xc7\x22\x9f\x4c\xa2\x3f\xd4\x28\x92\xad\x5b\x0e\x77\xa0\xa5\xb0\xa7\x0b\x73\x1d\xa7\xab\x16\x00\x26\xbc\x3f\xb2\x0e\xd3\x82\x82\x8e\x5d\x28\xe6\x12\xe9\x4c\xd4\x96\x47\xbd\x29\x3c\x87\x95\xb8\xb2\x74\xa7\xc4\xe7\xc3\x37\x09\x3b\x26\xb4\xc6\x3f\x7c\x50\xd6\xbf\xf8\x4e\xbc\x65\x41\x95\x70\x02\x68\x4f\xc8\x12\xea\xd6\x2b\xb9\x5a\x88\xad\x8a\x16\xb7\xd4\x30\x69\xc4\xc1\x6d\x65\xbf\x83\x31\x4a\x81\xf9\x40\x51\x2b\x65\xd9\xfa\x9c\xdb\xe2\xb3\x5e\xeb\x27\x17\x84\x3e\x37\xee\x74\xe0\x15\x03\xd3\x73\x78\x17\xf5\x35\x86\xe6\x48\xda\x69\x63\xba\x0c\x8f\x96\x0f\xa2\x2c\x35\x49\x1a\x73\xe2\xe3\x47\x6e\x73\xd8\x98\x35\xa8\x83\xd8\x3c\x5f\x38\x96\x2e\xa9\x3e\x45\xef\xb3\xc5\x21\xf3\xfd\x02\x97\xfd\xb4\xb1\xd8\x96\xef\xb6\x99\x18\xef\x8c\xb3\x5d\x40\xac\xa3\x73\x8d\xc3\x1f\xf2\x6d\x1e\x74\x7c\xa1\x59\xd4\x3e\x06\xa6\x42\xb5\x91\x79\x73\x3e\xeb\x5b\x37\x09\x52\x3f\x5a\x22\x41\x38\x40\x92\xf1\x50\x9a\x04\x3f\x43\x36\x6d\xe5\x24\x08\x37\x45\x12\xea\xdb\x88\xdd\xcc\xd5\xab\x63\x34\xcc\xe6\xb0\xc8\x4a\xcb\x41\x29\x0b\x3e\x0b\xce\x0e\x73\x69\x98\x04\xa6\x6d\xdd\x3c\x8b\x80\x18\x80\xf6\x29\x56\x04\x37\x68\x3b\x35\xc4\x86\x4c\x5b\x0d\x0c\x19\x74\xa6\xfd\x4d\xb9\x22\xe1\x36\x13\x1b\x85\x10\xa9\xa0\xb5\x0d\x72\x17\x38\x12\xdd\xbb\xa8\xc5\xd4\xfb\x36\x8d\x76\x7f\x72\x2b\xe9\x01\x2e\x62\xf1\xeb\x2f\xb2\xe4\x1d\x1b\xb2\x43\x87\x43\xbd\x89\xc1\xf7\xfb\xef\x2a\x24\x8e\x5f\x86\xc8\xf1\x30\xeb\x12\x68\xa5\xfc\xc6\x5b\xfd\xe6\x5a\xae\xfc\xc2\x5f\x3d\xc5\xab\xec\xde\xf7\x0c\x4c\xe2\xbb\x9c\xb9\x26\x0a\xd9\xfd\xcb\xe1\x05\xda\xb2\x76\xf3\x43\xf8\xec\x7c\x11\x9e\x33\xb8\x4c\x5b\xa6\x92\xef\x33\x4c\x89\xc9\x16\x55\x34\xcf\xf6\x09\xa2\x55\x24\xae\x63\x27\x9a\x34\x9f\x04\x7a\xd0\x84\x6c\x7b\x42\xc2\x13\xdd\x0d\xd3\x08\x6d\x6b\xa2\xf5\x51\x5b\xe5\x66\xe2\x6d\xc4\x49\xdc\x86\xcc\xad\x16\x7e\x87\xc2\x5a\x88\x78\x07\x25\x2d\x19\x81\x7f\x49\x11\x4d\xe1\xbf\x53\xf3\xff\x00\x00\x00\xff\xff\x3e\x98\x14\x6b\x8b\x06\x00\x00")

func test_certsCaKeyBytes() ([]byte, error) {
	return bindataRead(
		_test_certsCaKey,
		"test_certs/ca.key",
	)
}

func test_certsCaKey() (*asset, error) {
	bytes, err := test_certsCaKeyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "test_certs/ca.key", size: 1675, mode: os.FileMode(384), modTime: time.Unix(1400000000, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _test_certsClientRootCrt = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x94\xbd\xd6\xb2\x38\x00\x84\x7b\xae\x62\x7b\xce\x9e\x17\x41\x50\x8a\x2d\x92\x10\x24\x62\xc0\x28\xa0\xd8\x21\xff\x01\x7f\x40\x24\xc0\xd5\xef\xf9\xde\xf6\x9b\x72\xa6\x79\x8a\x39\xcf\xbf\x7f\x02\xf1\x8e\x78\xff\x20\x7c\x0a\x88\x4d\x10\x08\xf0\x6f\x2b\x51\x42\x2c\x10\x20\x04\xf2\x47\x09\x04\x81\xa0\x24\x2c\x5b\x8c\xda\x87\x55\xb4\x28\x8b\xe6\xbf\xcd\x3e\xcb\x57\x99\xc7\x81\x07\xcb\xa6\xab\x9a\x7a\x67\x0a\x05\x02\xf6\xb1\x81\x05\x7a\x89\x9e\x88\xc0\x20\xb6\x22\xc6\x5c\x2c\x5a\xeb\xae\x7a\x7d\xfa\x30\xab\x58\x2d\x27\x3b\x00\x01\x2c\xbd\x08\x02\x1a\x58\xd8\x1b\x63\x75\x98\xef\xaa\xcd\x13\x04\x2d\x16\x80\xd2\x16\xca\x24\x79\x0b\x58\x28\x6f\x26\x6f\x61\x9a\x67\xdd\x92\x1d\xd8\xea\x7e\xd0\xe8\xd4\xc2\x82\x06\x40\x50\x0b\x08\x6a\xbf\x04\x59\xf0\x99\x42\xb0\x03\xab\x10\xa3\x8a\xee\x99\x6a\xf2\x44\xdb\x8f\x52\x7c\xf1\x5e\x94\x29\x02\x89\x5f\x0a\x0b\x8b\xd3\x7c\x57\x4d\x85\x12\x02\xc9\x5f\xd8\xd8\x06\xc0\x47\x80\x6d\xc1\x9f\x1d\x95\x2e\x92\x00\xc3\x40\xd5\x86\x8f\x42\xed\xc6\x7a\x69\xe2\xe6\xb8\x97\x49\x2e\x0e\xdf\xa2\x1f\x30\x77\x65\xae\xa0\x0f\xff\x94\xc0\xd8\xf1\xfb\xc3\x95\xdf\x9d\xbd\xfc\x28\xea\xca\xbe\x39\x0e\xee\x12\x7e\x93\x6a\x50\x89\x9b\x5d\xc2\xc3\xb8\x4b\x36\x91\x62\xe0\x93\x1a\xc9\x72\xf9\xec\x3c\x97\xf1\xe8\x18\x5d\xac\x2f\x9f\x2e\x9c\xcf\xbc\x8a\xaf\xe3\xb4\x0e\xfa\x7a\xbe\xbf\xde\x17\x2a\xaf\xe5\xa8\xaa\x4c\xc9\x2b\x9a\xac\xac\x9c\x4f\x66\x98\xae\x67\xbe\xd3\x6b\x27\xfb\xe6\xab\x3c\x72\x95\xe0\xf5\xf2\xd6\x3e\x6f\x19\xb5\xcf\x6b\x69\xda\x8b\x1e\x4d\x5d\x87\xb8\xaf\x43\x28\xa0\x03\xa3\xda\x3b\xdb\xad\x34\xd4\x60\xa1\x87\x67\x1d\x35\x50\x13\x27\x75\x0c\x36\xcc\xab\x1c\x6d\xd8\xe8\x32\x67\xb2\xe3\xa9\xf2\x3a\x78\x9c\x0e\x9a\x91\xec\x3c\xf6\xde\x10\x63\xca\xa0\xdc\xc3\x50\xdd\x06\xa4\xc6\x3e\x92\x08\x7b\x20\x63\x88\x42\xa1\x6b\x1b\x3f\x8c\x57\xc0\x84\x63\xb2\x28\x80\xc6\x2e\x0d\x37\x9b\xdd\x6b\xce\xd1\x96\xc3\x1d\xa7\xd0\x49\x3f\x8f\xc9\x68\xf3\x9f\xa7\xad\xc7\x03\x38\xe3\xd0\x61\x96\x54\x7c\x5c\x7d\xad\x5f\x65\xa7\xb5\xcd\x64\xf1\xb7\x69\x81\xb3\x44\x4d\xbb\x8e\x11\x0b\x30\x00\x5f\x73\x2a\xf6\x01\xf0\xff\xfc\xc1\x61\x5b\x08\x8a\x2d\x86\x80\x22\x98\x00\x81\x45\x6c\x49\xd1\x49\x69\x21\x10\x02\x95\x31\x71\x45\x0c\x21\x0b\x1d\x20\x88\xb0\x58\xbc\x77\x5f\x37\x52\x8d\xa9\x07\x18\x3e\x40\x06\xac\xb2\xc4\x10\x90\xfb\xf6\xa8\x51\x54\x44\x60\x80\xc3\x94\x4b\xbc\x8b\xad\xb6\x97\x5d\x02\xcd\x42\x7b\x68\x3c\x32\xf4\x45\x51\x94\xa6\x51\xdf\xef\xe1\xe0\xe9\xc9\x14\x39\xa1\x91\x39\xd3\x70\x5a\xaf\xa0\xab\xec\xaf\x7a\x9d\x8e\xa1\x5c\xcb\xb9\xa6\x1d\xc6\xb3\x64\x5f\x83\x57\xcb\xa8\x47\xeb\xc5\x0c\xd2\xed\x67\x24\x17\x54\xa8\x6e\x79\x2d\xba\xef\x2a\x3e\x5a\x3f\xe3\xe7\xa2\xdf\x62\xb3\xbb\x7f\x87\xb5\x3f\x68\x43\x54\x8b\x26\x3d\x6a\xb3\x92\x19\x53\x8c\x8e\xd2\x67\xdf\x54\x2b\xd1\x18\xfd\x3e\x14\xa1\xef\xbd\xbe\xa5\x9f\xea\x4b\x40\x8d\x52\x1e\x8b\xc7\x79\x5e\x0b\x67\x57\xfc\x98\xdf\xbc\x1d\x9f\xab\x79\xb5\x0e\x00\x18\x34\x52\x53\x13\x45\xb9\x9f\x32\x2e\x95\x6d\x7a\xd4\xdd\xa6\xce\x5f\xfd\x3a\x7d\x4e\x40\xb1\xbf\x9c\x12\x2f\x53\x1f\x86\x1c\xb4\x34\x6c\xf3\xcc\x9f\x1f\xc6\xe4\x46\x78\x74\x94\xef\x4d\x8d\xc2\x05\x45\xdc\x75\xd6\x4b\xe9\x5c\xc6\xad\x94\x57\xce\x3a\xe1\xf3\xbb\x38\xd4\x3d\x4c\xfa\xea\xb8\xcc\x4e\x0e\xca\xd8\x30\x36\xf3\x79\x35\xa2\x9f\x46\xd8\xf7\x1c\x1a\xed\x06\x64\x7d\xb1\x49\xeb\x6b\x5d\x4d\xbd\x7c\x3b\x0d\xe4\xba\xb9\x3d\xaf\x12\x6a\x53\xa7\xed\xc0\x7f\xd2\xaf\x1e\xb0\x67\xfd\xad\x8c\xff\x03\x00\x00\xff\xff\x4f\x02\xfe\x8c\x4f\x04\x00\x00")

func test_certsClientRootCrtBytes() ([]byte, error) {
	return bindataRead(
		_test_certsClientRootCrt,
		"test_certs/client.root.crt",
	)
}

func test_certsClientRootCrt() (*asset, error) {
	bytes, err := test_certsClientRootCrtBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "test_certs/client.root.crt", size: 1103, mode: os.FileMode(384), modTime: time.Unix(1400000000, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _test_certsClientRootKey = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xd5\x37\x12\xab\x58\x02\x85\xe1\x9c\x55\xbc\x9c\x9a\x42\x78\x11\xde\x8b\xf0\xde\x9b\x0c\x84\x17\x1e\x04\x88\xd5\x4f\xf5\xeb\xb4\x4f\x7a\x92\x3f\xfb\xfe\xf7\xcf\xa0\x20\x29\xe6\x1f\xd7\x03\x7f\x6c\x57\x09\x81\x2f\xfc\xd1\x84\xe4\xef\x83\x18\x8a\x22\x4c\xa7\x02\x01\xd0\x78\xe0\x08\x80\x20\xf7\xed\x61\x88\x9f\xd7\x44\x9e\xa9\xac\x45\x17\x5a\xe9\xdf\x6a\xdd\x85\x4e\x43\xbb\x07\xbf\x75\x5b\x0d\x18\xa9\xcb\x07\x0d\x9d\x17\xf1\xc6\x90\x07\x81\x8b\xa9\x2c\x0b\x4b\xd6\xa5\x2d\x68\xce\x54\xac\xa1\x7e\x48\x19\x1b\x3e\x18\xc1\x25\x42\x14\xad\xc7\xc5\xd4\x9c\x2e\xb4\xc3\xe8\xf5\xed\xae\xa8\xeb\x7e\x5d\x93\xc4\xc7\x45\xf9\x6b\xfb\x43\xf2\x69\x8e\x0c\x94\x42\xc3\xa6\xe1\xcc\xea\x53\xd4\x8d\xbc\x15\x0c\xa7\x99\xdc\xfc\x8e\x17\xd4\xe2\xa6\xda\xee\x08\x45\xa0\xee\x99\xdc\x66\x94\xef\xc7\xb8\xe6\xc4\x9b\x0e\xaf\x65\xe1\x3b\x8b\x46\x20\x3c\xa1\x0c\xc3\xd6\xf4\xc4\x7e\x6f\xc1\x6d\xe8\x63\x1b\x7e\x20\x79\xba\xc4\xe1\xb3\x8e\xd9\xc8\xe4\xce\xd2\x68\xe7\xa0\xb2\x49\xa0\x94\x3f\xb8\x3a\xc9\x64\x92\xe9\xcc\xac\xc2\x5c\x05\x44\xd0\x15\x06\xc4\xd3\x57\x5a\xc1\xe2\x15\x67\xe0\x99\x3d\x0c\x4e\x9a\x64\xad\x20\xc1\x01\x07\x8f\xec\x7e\x00\x23\xd1\x8c\x80\x65\xa5\xe9\x57\xf2\xcf\x0e\x4a\x9d\x01\xe5\xf7\x36\x5c\x4c\x5f\x62\xc8\x28\xd2\xc9\x0e\x3c\x21\x90\x9d\x57\xb5\x69\x34\x45\xc7\xa8\xdc\x8b\x5c\x76\x5b\xcf\x77\x25\x14\x19\xf1\x5e\x16\x47\x79\x01\x07\x40\x30\x29\x10\x38\x3c\x1b\x16\x0e\x34\x56\x40\x34\xe0\x12\x91\x8f\x28\x48\x25\xca\xe3\x4f\xa2\xcf\x4a\x77\x70\x17\x01\xd4\xdc\x2a\x56\x6b\xc5\xbb\x83\x42\x05\xa8\x7a\xe6\x91\xf0\x7c\x16\x4b\x2e\x6f\x5e\xaf\xab\x76\x97\x76\xce\xd9\x37\xc4\x33\x8e\xf7\x70\x45\xac\xb1\x14\xcc\xa6\xbf\xef\x34\xa1\xb4\x03\x04\x6d\x62\xe0\x67\xbf\xb3\x8d\x0f\x93\xcf\x57\x09\xed\xdf\xc5\x7d\x62\x25\xea\xbc\xe1\x75\x9f\x1c\xa8\x84\xad\x2f\xf8\xed\x85\x3b\x4d\x6b\xa2\xb8\x8f\x8c\x82\xa8\xb8\xcf\xc4\xb1\xba\x12\x3f\xc9\x2a\xcf\x35\x56\x3e\x6b\x69\x09\xd2\x0f\x6d\xf0\x2a\xaa\x6f\x8c\x78\xfa\xd8\x91\x51\x9e\x32\x4c\x8a\xa1\xe9\x67\x6c\x91\x75\xca\xd9\xa0\x60\xbd\xf2\x87\x60\x40\x07\x89\x10\xbe\x71\x7c\xd3\xd9\xf0\xbd\x87\x4d\x48\xb4\x65\x44\x5c\xf5\xb3\x59\xad\x23\x36\xbc\x79\xbf\x12\x39\x24\xaa\x7b\x6e\x32\x2f\x2d\x26\xaa\x4f\x28\x92\x27\xda\x6e\x39\xd1\x1b\x45\x76\xd3\x07\x36\xa7\x3d\x9f\xaa\x96\x45\x19\xd5\x48\xbd\x3e\xe7\x96\xd9\x6b\xd2\x8c\xbd\xd7\x21\x09\xb7\xdf\xc4\xe2\x25\xe4\xbf\xa2\xa0\xe3\xac\xed\xec\xf8\xd7\xcc\xf6\x5c\x98\xc7\x7b\xb6\xcd\x0b\x49\xc0\xfe\xb9\x38\x45\x05\x93\x04\x81\xc5\xe6\x77\xa2\x12\x9a\xf0\x4e\xe7\x5a\x9b\x71\x54\xc5\x6b\xfd\x67\x88\xb8\x32\xa9\xc3\x2b\x21\xcc\x55\xb9\x5a\xc6\xf7\x4f\x0e\xf3\xbf\x38\x49\xdf\x14\x8a\x4c\xbb\x8b\x4f\x9f\x6c\x72\xbd\x7c\x15\x58\x39\xa5\x0b\xb3\x85\xe8\x29\xa0\xa1\xb0\x9b\x97\x6a\xea\xe7\xe3\xd3\x24\xd7\xc0\xc2\x3e\x2e\xc9\x91\xf1\xe2\x7d\x52\x12\x22\x3c\x66\x4b\x5f\xa2\xc2\x40\x58\x25\xa3\xdd\xe2\xec\x09\xb1\xd4\x76\x35\xba\x8f\xe4\x31\x45\x23\xd0\x60\x68\xb3\x50\xbc\x85\xd0\x63\x33\x31\x6f\x88\xc5\x1e\xcb\xef\xaf\xcc\xc2\xd1\x9d\xe4\xf9\x5a\xff\x2d\xde\x58\x64\x4e\xeb\xa1\xe4\x87\x96\xae\x1f\xe1\xc7\xcc\xe5\x4f\x4b\x2f\xa7\x95\x10\xc6\x6b\x3d\x7d\xcd\x3a\xa6\x8f\xf7\xe0\x99\xf5\x0b\xad\x2a\xe8\xb0\xe7\xb1\xe9\xce\x55\x98\x8e\x8b\x36\x5d\x36\x7a\x1f\x1d\xe1\xb3\xd0\x58\x3c\xaa\x56\xc8\x68\xfc\xdd\x2b\x2d\x8f\xb3\x4e\x2f\x86\xa7\xa5\x16\x73\x8e\x67\x6d\x26\x11\xb8\xe3\x5a\x82\x73\x5e\xd7\xea\x6e\x7e\xb1\x67\x85\x75\x11\x6e\xe3\x60\x0d\x54\x4d\x45\x6e\xf7\x72\xcc\x58\x7c\x7f\xf3\x53\x66\xed\x45\xde\x47\x49\x6b\xe6\xfc\xf7\x0b\x3c\x15\xd7\x85\x13\x24\x24\xf3\xdc\x27\x16\x4c\x12\xb0\x37\x4c\x4b\x3c\x3a\x34\x3d\x5c\xae\xd4\xca\xf5\xe9\x91\x41\xbe\xf3\x1c\xc4\x8c\x7b\x3b\x37\xff\x82\x5d\x94\xa2\x50\x02\xf7\x17\xd2\xdd\xe1\xb7\xa8\xdc\xbf\x4d\x29\x6b\x0f\x2e\xde\xb4\x68\x0c\xf8\x3a\x7f\x30\xc7\xfe\xab\x8a\x6b\x42\x59\x39\x33\x68\xfb\x8d\x14\x59\x6a\x83\x57\x3e\xb5\x78\x4f\x62\x8e\x14\xa5\x3e\xd7\x52\xc4\x32\xe6\x8e\xd8\x09\xd6\x67\x9c\x0a\x8a\x3f\x8f\xef\x74\x4e\xbf\x50\x95\x5f\xe9\xf1\x7e\x2a\xbf\x40\xa2\x23\x3b\xc1\xfa\x88\x78\x21\xa7\xd3\x04\x75\x59\xb6\x01\x6a\x80\xb7\x80\x76\xa7\xe2\x2b\x38\x16\xf0\x75\x02\x19\x67\x00\xca\xf7\x13\x9b\x6c\x33\x63\xee\x70\x8e\x62\x90\x4b\xb8\xff\xa1\xd8\x24\x88\x0f\xfb\x43\x39\xd5\x32\x20\xfd\x12\xba\x3f\x06\x13\x61\x5f\xcc\xb2\xa8\x1a\x9c\xcf\x5d\x41\xcc\xa4\x92\x98\xf1\xbd\x5c\x2b\x2c\x17\x0c\x49\x23\xeb\xd8\x86\xbd\x9e\x96\x26\x04\xe9\x32\x7e\x57\xbd\x08\x6e\x72\xa7\xd2\xf2\x40\xb6\xa4\x4e\x5f\x74\x7b\xa9\x9d\x7c\x35\x25\xd7\xd3\xfc\xbd\x4f\xde\xb9\x3d\xf5\x54\x7d\xe0\xa2\x38\x60\x9a\x46\xee\xde\x0f\xb0\x9e\x9a\x65\x87\xee\x11\xca\x23\x6d\xb9\x2b\x2f\x87\xfc\xaa\xa3\x09\x79\x90\x9b\xab\x3b\x1a\xac\x21\x0f\x63\x1f\x9b\xf4\x1b\x2f\x38\xbf\x11\x95\xe1\xee\x8a\x63\x01\x3a\xcb\x64\x80\x53\x79\x9b\xfb\x92\xa4\x57\x92\xf1\xd7\x21\xf2\xfb\x2d\x36\x1c\x60\x1f\xec\xca\x23\x0f\x36\x73\x2a\x76\x35\xde\x49\x63\x3f\xd4\x57\xb4\xcf\x46\x58\xc5\x02\xfc\x5a\x7e\x95\x42\xbb\xa1\xb2\x46\x55\xc2\x91\xb4\xe9\x5c\x24\xd7\x65\x70\xb6\xa5\x4b\xae\xc8\x5a\x54\x4e\x7a\xc1\xc8\x43\xfc\x09\x93\x7f\xa9\x56\x73\xfd\x52\x73\xe9\x9b\xdc\xf4\xfa\xa5\x64\x2d\xeb\x5a\x22\x30\x9f\xd2\x5d\x6d\x1a\x6c\x9d\x76\x06\xf9\x06\x52\x31\x4e\x86\x58\x61\x90\xbf\xa4\x08\xe6\xeb\xbf\xa9\xf9\x7f\x00\x00\x00\xff\xff\xc0\xc4\x93\x33\x8b\x06\x00\x00")

func test_certsClientRootKeyBytes() ([]byte, error) {
	return bindataRead(
		_test_certsClientRootKey,
		"test_certs/client.root.key",
	)
}

func test_certsClientRootKey() (*asset, error) {
	bytes, err := test_certsClientRootKeyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "test_certs/client.root.key", size: 1675, mode: os.FileMode(384), modTime: time.Unix(1400000000, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _test_certsClientTestuserCrt = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x94\x49\x13\x6b\xc0\x02\x46\xf7\x7e\xc5\xdb\xa7\x5e\x09\x32\x2e\xee\xa2\xd1\x68\x34\x69\x53\xb0\x33\x44\x13\x53\x90\xa4\xc3\xaf\x7f\x75\xef\xf6\x7d\xcb\x6f\x75\xaa\x4e\xd5\xf9\xef\xdf\xc9\x50\x47\xce\x7f\x14\xe8\x05\x48\x43\x0a\x08\xe0\xbf\x97\xc3\x08\xa9\xf2\x53\x51\xc0\xe3\x44\x01\x43\x32\xa0\xc8\x03\xe6\x43\x17\x8d\x69\x22\x15\x72\xcb\x05\x9d\xee\x43\xf9\x86\xb4\x60\x2a\x49\x4c\x6b\x4c\x51\xfd\x2d\x1c\x40\xa0\x2d\x13\xc0\x38\x6b\x83\x3e\x96\x81\x0e\x84\x10\x2a\x35\x36\x89\x78\x7d\x66\x92\xf9\x4d\xee\xce\x88\xbd\x90\x41\x96\xa8\x11\x21\x2a\x64\x3f\x35\x17\x9d\xb9\xe8\xaf\x75\x22\x52\x4a\xf6\x90\x21\xb9\x70\x38\x1c\x14\x0c\x6f\xe8\x88\x83\x62\xef\x6c\x44\xba\xd7\xf4\xe6\x06\xed\xd1\x0d\xc0\x0f\xab\x90\x61\x15\x30\xac\xca\x19\x56\x8a\x1f\x7c\x02\x22\x53\x27\x92\xc1\x18\x28\xa1\xf3\x4d\xc4\xf7\xca\xe5\xa2\xf6\xcc\x54\xe8\x61\x70\xf9\x47\x01\x7e\x18\x95\x7a\xb4\x95\x46\xb4\xa5\x31\x62\x94\xc2\x06\x83\xbd\xae\xf8\x93\xee\xa3\x5c\x52\x09\x94\x01\x09\x01\x38\x20\x59\x65\x80\x71\x94\x42\x0b\x8c\x48\x06\x44\xe9\x2b\x27\x38\xd7\x63\x8a\x3b\x90\xbb\x89\x49\x77\x99\x21\x54\x2b\x1f\x26\x8f\x77\xac\xaf\xd1\x97\xbe\x3e\xe2\xeb\x34\x9e\xad\xf7\x74\x75\xf3\xd0\x7b\xc6\xe7\x55\xe3\xc4\x54\x1f\x86\x5b\x72\xb6\x67\x76\x5c\xde\x9d\x84\x0f\x56\x02\xdf\x05\x3a\x1c\xd0\xb5\xfc\x38\x59\x51\xf8\xe3\xbb\xfa\xd4\x87\xfd\xf0\xe5\x63\x6f\xec\x1c\xaf\x0f\x76\xc3\x32\x88\x29\x79\xde\x04\x87\xbb\x9a\x4d\x6b\x7f\xfa\xf1\x73\x6a\x9c\x73\xec\x5e\x9a\xfe\x36\xad\x63\xf0\x79\x57\x8d\xf1\xda\xd9\xb9\x3f\x90\x53\xcb\x5f\xf8\xfc\x11\xfa\xeb\xf3\xd6\xce\xb6\xa3\xbe\x24\x6f\xe0\xcf\x52\xdb\x65\x50\xe3\x5a\xd2\x65\x85\xb5\xdc\x83\x41\xec\x7f\x66\xd1\x5a\xd2\x11\xfd\x7a\x4a\x77\x60\xcd\xad\x35\x7d\xec\x05\x26\x2d\xbb\x66\xb1\xd7\x0f\xcf\x6a\x3d\x01\x38\xc9\x6b\xc6\x67\x8a\x9e\x13\xfb\xd4\x0f\xdc\xd4\xee\x1e\xd9\x3d\x09\xcf\xc5\x15\xb9\x5b\xa6\xc7\x91\xeb\xf6\x01\x6e\xa8\x56\x6a\x7d\x96\xd0\x56\x81\xe5\xbc\xd9\xab\xa0\x8e\xec\xf2\x93\x66\x20\x63\xc5\x19\x71\x61\xf5\xdd\x05\xda\x51\xc4\x3d\x6e\x6e\xd6\x4e\x43\xdc\x4c\xb3\x10\x50\xc9\xd0\x05\x4b\x78\xd7\x47\xb8\xfc\x84\x87\x71\x9a\x78\x40\xb1\x0c\x80\xfe\x34\x37\xd0\x61\x70\xf8\x6b\xaa\x54\x19\x94\x79\x46\x20\x60\x48\xe3\x46\x15\x04\x7f\xdd\x1a\x7e\x08\x55\x15\x58\x32\xa5\xb3\x4c\xa1\x26\x93\x42\x05\x4f\xe0\xc8\xb4\x9d\xea\xb6\xd1\xaf\x6c\x2f\x03\xb2\x68\x00\xb8\x0a\x20\x10\xb4\x83\x17\x67\x8d\x13\x71\x63\x76\xd6\x5f\x2c\xd5\xb5\x68\xfc\x54\xbb\xce\x59\xcf\x7a\x20\xd6\x83\x75\xdf\xe6\xaa\x9b\x4f\x3b\x01\xf7\xd1\xf3\xac\x18\x2f\x54\xaa\x7b\x4b\x12\x4c\x51\x16\x93\xcb\x87\x5d\xc5\xed\xb8\xf7\x50\xcf\xdd\xfc\xf0\x55\xcd\xe5\xb7\x26\x99\xa6\xe5\x6b\x9a\x7b\xf6\x80\xca\x62\x12\x62\x2a\x91\xdc\xda\xaa\xb9\xe4\x9f\xa6\xaf\xdf\x8d\x82\x1d\x5b\x29\x7e\x9c\xc6\xa1\x2e\x93\xdd\xbc\x9b\x48\x9f\x7b\x12\xa7\x2d\x45\xe8\x99\x3f\xfa\xfd\xaa\xab\x18\x85\x56\x68\x35\x01\xae\x4b\x17\x84\xbf\xc1\x06\xa2\x7e\x55\xa6\x97\xa8\x68\x97\xfc\xd2\x06\x68\x56\xb4\xcd\x6e\x7c\x76\x50\xc3\x66\x88\xe2\x8b\x1e\x0d\xdc\xa7\xd2\x9d\xf4\x6a\x44\x38\x9a\xea\xce\x5d\xd1\xe9\xd5\xf0\x4c\xad\x92\xf5\x12\x2e\x03\xbb\xbd\x8e\x45\x03\xfb\x6d\x33\xce\x83\xc3\x78\x97\xad\x5e\x8b\x5b\x8d\x6f\x0d\x41\x7b\xdf\x1e\x0c\x54\x1c\x74\xbf\x20\x24\x53\x0a\x2d\x2d\xbe\x77\xb7\x87\xcf\xd2\xee\xb8\xe2\xb3\xbd\x4f\x6a\x77\xda\x2d\xf2\x56\x7d\x94\x42\x58\xc4\xd8\x60\xe9\xb5\xf6\x8b\x28\xd2\xb2\xfb\x8c\xb3\x45\xf3\x59\xff\x75\xb9\xf0\x90\x17\x14\x99\x17\xdf\xbc\x0c\x5f\xfa\xe7\x0f\xf7\x2f\x13\xd0\x51\xff\x3f\x1d\xff\x0b\x00\x00\xff\xff\xfe\xec\xa3\x2d\x57\x04\x00\x00")

func test_certsClientTestuserCrtBytes() ([]byte, error) {
	return bindataRead(
		_test_certsClientTestuserCrt,
		"test_certs/client.testuser.crt",
	)
}

func test_certsClientTestuserCrt() (*asset, error) {
	bytes, err := test_certsClientTestuserCrtBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "test_certs/client.testuser.crt", size: 1111, mode: os.FileMode(384), modTime: time.Unix(1400000000, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _test_certsClientTestuserKey = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xd5\xb7\x12\xab\xda\x01\x85\xe1\x9e\xa7\x38\x3d\xe3\x21\x8a\x50\xdc\x82\xb0\x45\x12\x19\x89\xd0\x81\xc8\x22\x6c\x72\x78\x7a\x8f\x8f\xdb\xbb\xda\xd5\xfc\xdd\xf7\x9f\xff\x4d\x04\x8a\x66\xfd\xf1\x7c\xe1\x8f\xe3\x69\x1f\x21\x00\x7f\x0c\x10\xff\x7d\x10\x53\xd3\x00\x14\x34\x51\x10\x0c\x49\x70\x81\x00\x87\xfb\x8d\xd2\xa9\x12\xe8\xae\x72\xf7\x52\xec\xf4\x35\x1f\x71\x3b\xa1\xa8\xf3\xe7\x5c\xba\x8c\x36\xb2\x75\x2a\x26\xfb\x9a\xd3\x3d\xe8\x09\x80\xc4\x04\xca\xd5\x79\xef\xc1\xc7\x4d\xda\x17\xc3\xd9\xd9\x2b\xc9\x6f\x5b\xea\xc5\x57\x24\xd9\xb6\xe4\x44\x59\x1b\x0e\x2a\x98\x5e\x11\x3b\x16\x96\xce\x62\x04\x9e\xea\xc1\x3b\xf9\x61\x90\xd5\xf9\x1e\x79\x6b\x37\x1f\x94\x7e\x0c\x25\x16\x4e\xaf\x6d\x6c\x0b\xe2\xde\x35\xd8\x32\xcb\x04\xd8\x39\xa2\x6b\xa6\x6c\x48\x1c\xe2\x36\x74\x30\x87\xa4\x3a\xb0\x8c\xf7\xc3\xb8\x6e\x97\xc9\xf1\x04\x43\x79\xe4\xa1\x87\xb5\x98\x00\x3d\x1c\xa4\xf9\xf9\x7b\xf0\x70\xf1\x23\x5d\x5a\x51\xdf\x4c\x46\xcd\xa9\xcc\xfe\x5a\xfa\x68\xb5\xbe\x16\xeb\x8c\xb3\xc4\xcd\x3b\xa7\x79\xbd\x20\x2b\x0a\xfd\x75\xc8\xaa\xee\x11\x5c\x42\x21\x64\xa0\x33\xf4\x5d\xff\xb4\x29\xc7\x97\x17\xb2\xee\x88\xa0\x85\xbf\x5b\x1b\xc5\xc8\x4b\xfa\x5e\xd3\x85\x5a\x4d\xb9\x8b\x5b\x5d\xc6\x74\xcc\x9c\x39\x84\x40\x68\x53\x59\x95\x20\x44\x4a\x51\x22\x3e\x51\x7b\xf7\xd0\x80\x04\x3d\x4d\xfc\x9b\xb6\xce\x73\xf5\xd7\x2c\x2e\xbc\x97\x99\x47\x35\x3a\xed\x87\x26\x0b\xae\x20\x0a\xa3\x26\x0a\xd2\x45\x96\x58\x5b\xc7\x77\x7c\x13\xb7\xfb\x45\xa4\x2b\x77\xe0\xe2\xb9\x63\x4c\xf6\x35\x4b\x1c\x83\xf9\x09\x58\x26\x29\x8f\xd0\xe6\xf9\x11\xd7\xfa\x58\x4f\x89\x2d\x8a\xee\x1c\x55\x5f\x77\x3c\xe3\x15\x3f\x72\xad\x34\x85\xfc\xca\x5f\xbc\xbf\x21\x41\xc8\x91\x05\xc7\x9e\xbd\x27\x32\x39\xcd\xf1\x94\x29\x55\x95\x22\x18\x82\xfe\xb1\xce\xd3\xdb\xe0\x36\xd7\xee\xac\x4f\x12\xdd\xfc\x56\x13\x3e\x5d\x6c\x92\x14\x20\xf0\x70\xd2\x5e\x06\xa6\xe3\x48\xb8\x08\xa6\xfa\xad\xe0\x3b\x2f\xf3\x31\x36\xfa\x4a\x38\x0e\x42\xf8\xe9\x8e\x59\xd6\x9e\x37\x79\x9c\x71\xe1\xbb\x55\xc7\xe6\xb9\xcc\x9a\x4d\x8d\xd2\x62\xa1\x2e\x9b\x9a\x23\xe9\xa0\xa4\x16\x9e\xc8\xf7\xed\xf7\xf0\x04\xcd\xdd\x54\xbf\xdc\xd4\x63\x7e\xc6\xc2\x3c\xe2\xe9\x50\x70\x2c\xed\xec\x50\x81\xdf\x3d\x9c\xd7\xbb\x85\xc1\xe3\xb3\xb5\xbf\x84\xd3\x78\x86\x4c\x29\x3a\xeb\xeb\x05\xb9\x42\xc4\x14\xdf\xb3\x2a\xcc\xb5\x12\xd3\x4b\x43\x2e\x0f\xbf\xb9\x83\x7b\xd9\xad\x5e\xdb\x1e\x5d\xb0\x62\xd1\x43\xf0\xb7\x63\x06\x42\x19\x0e\xdd\x55\xc7\xc7\xdc\xad\x87\xbb\xa1\xd1\x37\x70\xb3\xca\x25\x11\x88\xf1\xd5\xb0\xfc\xa4\x2a\x06\x02\x55\xa0\xb3\x5c\x4f\x92\xef\x40\x7f\x89\x02\xd8\x69\x91\x1c\x3d\x33\x7d\x7c\xd7\xc5\x27\xeb\xc8\x01\x86\xc3\xb0\x2a\xf7\x47\xfa\xa9\xe2\x04\x1e\xf6\x9d\xaa\xc8\x16\x3b\x3f\xf2\x27\xda\xa6\x73\x73\xc5\x80\x0f\xa9\x56\xb2\x8b\x44\x4b\xef\x82\x94\x5f\xa9\x59\xbb\x3f\x9f\x40\x59\xf1\xd4\x33\x9e\x7d\x3a\xad\x2d\x3e\xf5\xaf\x0b\xe2\x61\x38\xbe\xd9\x16\x7f\x4e\xc4\x06\xb7\xb3\xa0\x2e\x51\x74\x27\xfa\x34\x50\xba\xec\xcc\x66\x8b\x2f\xc1\x0b\x5c\xa5\xff\x19\x4a\x45\x08\x85\xca\x27\x69\xf8\xa8\x2b\x55\x1f\xeb\x4d\xb4\xe6\x37\xfd\xfe\x5b\x7c\x08\xf0\x81\x94\x2b\x65\x9c\xb9\x95\xc8\x4d\xf2\x5b\x00\x2e\xc7\x62\x25\xab\x05\xa3\x0e\x67\x96\xdb\xc5\x41\x8a\x32\xb0\x43\x67\x0f\xf9\x4e\xe3\x6f\x7c\xf1\xfd\x26\x8b\x9f\x94\xce\x6f\x8a\x65\x47\x8b\x6c\x22\xe5\xb4\xf2\x4e\x66\x0d\xc7\x12\xdb\x9a\xd2\x49\xe7\x88\x56\x95\xd3\x68\xb9\xdc\xe5\x52\x7e\x9c\x90\xd5\x9d\xf7\xd3\x51\xf9\x37\xa3\xaa\x55\x85\x25\x51\x02\xb6\x5a\xc3\xcc\x6a\xe5\x8e\x0f\x1b\x22\xee\x5a\xbe\x46\x43\x9c\xbb\x61\x7e\xfa\xd8\x7b\xdf\x87\xa3\x60\x28\x22\xaf\x14\x12\x54\x75\x2c\xb7\xe9\x6c\x67\x83\x29\x55\xb1\x28\x96\x51\x26\x36\xcc\x02\xbe\x98\x72\x70\xc5\x40\x65\x16\x71\x20\xee\x89\x6d\xfd\x9a\x07\xe5\x48\x11\x01\x46\x5b\xad\x4e\x25\xa9\x45\x2d\x34\x5a\x4f\x15\x1b\x65\x9f\xd8\x0a\x16\xc1\x6d\x2e\xe8\x1b\x89\xa1\x65\x31\x85\x6f\x97\x13\x54\x41\x0b\xc2\x84\xda\x21\x82\x05\x46\x13\x66\x45\x72\xee\x34\x86\x1e\x39\xad\xb8\x4a\xc7\x7c\x29\x3d\x30\xfc\xed\xb8\x82\x2f\x7e\x87\xac\x67\x12\xce\x33\x18\x03\x7f\x32\xe7\x86\xcb\xc0\x57\xf2\xd6\x93\xb4\x86\x98\xaf\x5a\x64\x4a\x95\x49\x0e\x77\xbb\x48\x9e\x13\x86\xfb\x1e\x2a\x02\x30\xbb\x86\x58\xb9\xd2\x97\x54\x01\xfa\x9b\x17\xcd\xa4\xed\x69\xb1\x03\x67\x09\xd2\xad\xbe\xe8\x77\xdd\x4e\x57\x30\x79\x60\xd2\x48\x1e\xa9\xa6\x75\xb6\xf2\x60\xdd\x43\xd5\x30\x3a\x81\xba\x78\x8a\x20\xb5\xb4\xc6\x41\x7f\xdf\x79\x41\xe9\xfe\x1d\xf2\x05\x3d\x0b\xc0\xb6\x52\x7f\xe9\x67\x7f\xbb\x99\x5f\x1b\xbf\xb1\xde\x01\xd5\xe3\x87\xa8\xb0\xc4\xef\x4f\xd3\x29\xf4\x7e\x77\x9f\xbb\x66\x48\x2f\xcd\xb4\x86\x3b\x1c\xf0\x81\xe5\x67\x15\x07\x56\xd6\x05\x9d\x7d\x4e\x8c\xee\xfb\x83\xfc\xc5\x44\x1c\xf5\x41\x73\xbc\xb1\xd0\x23\x24\x19\x81\xf5\xe6\xdc\xff\x4f\xb6\xe6\x80\x01\x2a\xcb\xbd\xa4\x52\x9d\x4b\xa2\x3a\xf7\x6d\x64\x55\x66\xda\x13\xc6\x54\xc7\x63\xd9\xd4\x69\x51\xb4\xe1\xfc\xcc\xd5\xb2\xdb\x5e\xaa\x26\xc4\x4b\x41\xea\x9d\xa4\xcf\x5c\xb9\x71\xa2\x0f\xdb\xc3\x2a\x59\xae\x2d\x25\xdc\x31\x7f\xf6\x0b\x5c\xed\x4b\x9b\xc1\x54\xbc\x9f\x4c\x55\x1b\x6b\x9d\xcf\xd1\xa3\x25\xfb\x52\xa0\xc7\xdd\x46\x67\xfd\x38\x7a\x16\xe9\x8b\x60\xb7\x07\x76\x82\xdb\x19\x34\x7c\x3f\xbf\x6a\xcb\xd4\x9e\x7d\x5a\xda\x9a\xc9\x5d\xa2\x6d\x98\xb4\xc2\xab\x4a\x19\x8d\xd1\x52\x95\x8c\x42\xbc\x18\x57\x16\xfe\xf9\x07\xf9\xcb\x0a\xb0\xe4\x7f\xe7\xe6\xbf\x01\x00\x00\xff\xff\xd1\x7d\xbd\x71\x8f\x06\x00\x00")

func test_certsClientTestuserKeyBytes() ([]byte, error) {
	return bindataRead(
		_test_certsClientTestuserKey,
		"test_certs/client.testuser.key",
	)
}

func test_certsClientTestuserKey() (*asset, error) {
	bytes, err := test_certsClientTestuserKeyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "test_certs/client.testuser.key", size: 1679, mode: os.FileMode(384), modTime: time.Unix(1400000000, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _test_certsNodeCrt = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\x94\xbb\xd2\xaa\x48\x14\x46\x73\x9e\x62\x72\x6a\x8a\x8b\x82\x12\x4c\xd0\x37\xa0\xd1\x46\x1b\x41\xc4\x4c\x10\x5b\x50\x04\x05\x41\xfb\xe9\xa7\xce\x5f\x13\xcd\x39\x5f\xb8\xa3\x55\xb5\x57\xad\xbf\x7f\x0d\x12\x8f\x86\x7f\x21\x12\xc5\xd4\xa5\x08\xc4\xe4\xe7\xaa\x30\x4a\x31\x97\x08\x81\xea\x2d\xc0\x44\x21\x10\x34\x02\x14\xf2\xa2\xb8\x7d\x4a\xd8\x8e\xd6\x61\xe6\xb0\x75\x65\x47\xa7\x64\xc2\x3c\x0b\x56\xed\x91\x5e\xc7\x22\x04\x9c\xac\x21\x07\x93\xb2\x92\x64\xc7\x20\xf0\x80\x91\x10\x74\x65\x01\x37\x9d\xfa\x34\x0b\xc6\x2c\x0d\x5b\x16\x25\x13\x99\x32\xbc\xe7\x1c\x93\xe9\x83\x73\x33\x7c\x15\x8d\x73\xcd\x4c\x21\xb8\x4e\x26\x0a\x8b\x50\x61\x71\x31\x31\x49\x2d\x16\x17\x7a\x28\xb9\x91\x5e\xc5\x76\x13\xdf\xac\x4d\x0c\x3e\x0c\x93\x89\x61\x30\x31\x0c\x4f\x0c\xb1\x0f\xa9\x01\x87\x22\xdc\x43\xd0\xc6\x28\x09\xc7\xcc\x1c\xbe\x4a\x6e\xba\xf5\x09\x93\x90\x81\xfe\x87\x02\x7c\x18\xc9\x1b\xe7\x76\x8c\x11\x02\x3b\xfa\x7f\x6c\x08\x39\xc0\x42\x90\x2d\xc0\x08\x01\xde\x22\x45\x08\x02\x01\x53\x77\xd2\x06\xe1\xbd\x25\xda\x33\x37\x6a\x9e\x23\x92\x7e\x16\xfb\x17\x3a\x8f\x8b\x43\xb3\xd1\x36\x81\x63\xcd\x9a\xf9\xdb\xf6\xb2\xda\xae\x37\xfc\xdb\x06\xda\x62\xb6\x70\x73\x17\x2b\xd7\x61\x34\x8d\x18\x18\x70\xe0\x85\xb3\xb6\xa8\x0f\x5b\x5d\xef\x8d\xe7\x9d\xcd\xf4\xc7\xe1\x18\xaf\xcb\x85\x25\xb2\x7a\x4a\x4e\xd3\xc5\x05\xfe\xf7\xed\xd3\xce\xc1\xb8\x6b\xa4\x07\x0b\xb6\x35\x95\xcf\x25\x50\x35\xd7\x4c\x0c\x3a\xed\xce\x06\xed\x4b\x4d\x3e\x67\x5b\x6b\x31\x7a\x59\x38\x0e\x43\x14\x14\xeb\xe4\x2d\xd5\xaa\xa4\x23\x37\x87\x4a\x36\x4e\xaa\x9e\xa3\x79\xda\xc2\x78\x75\x28\x97\xb6\x22\xab\x15\xeb\x4c\xeb\xc8\x0d\xf6\x26\x8b\x61\x5c\xc0\xb5\xde\xa2\xa6\x00\x58\xd6\xb4\xac\x41\xb7\x93\x5b\x97\xdc\x69\xd6\x68\xcf\x93\xdd\x86\x07\xd5\x0c\xee\xb7\x76\x39\xc4\xed\x56\xdb\xfa\xad\x72\x28\xc4\x6c\x3c\x2f\x2c\xb5\xa0\xf0\xb8\xcc\x35\xa2\xc1\x0e\xb0\x3e\x29\x92\x13\xc9\x3a\x27\x32\xd0\x56\x5b\x76\xfe\xcb\xae\xb2\xf9\xc7\x58\x8b\x4d\xd8\x85\xc9\xec\x96\x67\xfd\xd2\xbf\xac\x56\x47\x45\x24\xed\xed\x9c\xae\xf9\x5a\xfd\x3e\x86\x63\xba\xda\x8f\xe4\x4a\x76\xc5\x8a\xef\x08\x02\x13\x01\xe0\x14\xb6\xcc\xcb\x26\x2c\x32\xbc\x8f\xf4\x2d\xe0\xbe\x06\x01\xc7\x40\xa4\x82\x41\xdd\x53\x80\x91\x9c\x03\xce\x53\x06\xb9\x87\x50\xef\x01\x9e\xb8\x70\x62\x10\x0a\xf1\x82\x82\xb8\x90\x17\x18\xd4\xc0\xf8\xf5\x7f\x3f\x22\x64\x5d\x83\x5e\x88\x7b\x9f\x9b\xe1\x35\xf7\xae\xa3\x52\xcc\x76\x08\x7e\xdb\x77\xee\x39\x75\x96\x7e\x7d\xe8\x2f\x01\x00\x9e\x4f\xc0\x9f\x46\x7e\xd3\x59\xf9\x4f\x0c\x08\xdc\x36\x5a\xc2\x6a\xe8\xe4\x00\x63\x3b\xe4\xaf\xfb\x5c\xaa\x11\x8f\x6e\x70\xef\x55\x73\x29\x85\xcb\x66\x34\x2f\xf7\x25\x79\xa6\x7a\xe5\x74\x8f\xb3\x76\x01\x51\x69\x2a\xb6\x8c\xaa\xfc\x58\xd0\x23\xbb\xc8\x67\x93\xf5\x33\x33\xf7\x6b\xd3\x96\xaf\xda\x8a\xd4\xfa\x94\x87\x4f\x49\xdb\x08\x81\xa1\xd0\xde\x7c\x67\x4c\x75\x17\x35\x7e\x36\x9f\x19\x78\x09\xc2\xd4\xb9\x28\x22\x56\x97\x24\xf2\x82\xb3\x0c\xbe\x72\xef\xd8\xac\xd6\xef\xd7\xec\x30\xff\x14\xcd\x81\xef\x5a\xb9\x4c\xe6\xdb\xe2\xa1\x2f\x1b\x03\xd9\x95\xc5\xcf\xb8\x7f\xd4\x53\xf4\xa4\xd5\xa1\xb4\xc8\x9a\x5d\x15\xd7\xd5\x9b\x4d\xd5\x9c\x96\xf3\x8f\xac\xad\x0e\xf1\x4d\x89\xea\x7c\xa1\x85\xe1\x54\xbf\xa0\xdd\xd7\xe7\x61\x03\xb3\x4e\xe2\xc3\xa5\xb9\x6d\xef\x27\x1e\xeb\x2a\x7b\x34\x7b\x86\xf7\x81\x9a\xcf\x7b\x05\xd2\x31\xb3\xcc\x29\xbd\x44\xec\x8e\x2f\xf1\x7c\x48\x9e\xd1\xed\x6c\x5c\xf7\x1f\xa0\xa3\x14\x3f\xd8\x02\x36\x97\x62\x12\xcd\xd4\xbe\x83\x77\x03\x13\x81\x3a\xb5\x54\x75\x89\xa4\x97\xea\xab\xbb\x92\xb8\x2d\x6d\xda\xdd\x23\x39\x1b\xef\x40\x5c\xbd\x30\x7e\x94\x0b\xc9\xfa\x7e\x8a\xcc\x32\x11\xff\x28\x3f\xdd\x21\x21\xfe\xbd\x45\xff\x06\x00\x00\xff\xff\x8b\x40\xda\x8f\xa8\x04\x00\x00")

func test_certsNodeCrtBytes() ([]byte, error) {
	return bindataRead(
		_test_certsNodeCrt,
		"test_certs/node.crt",
	)
}

func test_certsNodeCrt() (*asset, error) {
	bytes, err := test_certsNodeCrtBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "test_certs/node.crt", size: 1192, mode: os.FileMode(384), modTime: time.Unix(1400000000, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _test_certsNodeKey = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xd5\xb9\x16\xaa\xc8\x02\x85\xe1\x9c\xa7\x38\xb9\xeb\xae\x62\x14\x08\x6e\x50\x0c\x32\x09\xc8\x3c\x64\x16\x02\x82\x8c\x02\x85\xf0\xf4\xbd\xfa\xc4\xbd\xd3\x9d\xfc\xd9\xf7\xbf\x7f\x27\xa9\x9a\xe1\xfc\xf1\x03\xf8\xe7\xe1\x1b\x31\x0c\xd5\x3f\x96\x9a\xfd\x7d\x08\xdb\x30\xd4\xc9\x33\x24\x08\x2d\x19\x7a\x2a\x3c\xb9\xfb\x63\x84\x74\x52\x87\x97\x09\x27\x8e\xb4\x18\x3e\xd2\xd7\x64\x31\x69\xb0\x96\x19\x2f\xb0\x03\x33\x94\xa8\xe1\xc7\xbc\x79\xcc\x36\xa7\x10\x56\x3d\x00\x5c\x2d\xf1\x12\xb9\x1a\x0d\x50\x6c\x2b\x91\x46\x49\x27\x89\x3f\x75\xa1\xb5\x61\x70\x26\x73\x74\x56\xc1\xeb\xd5\xd9\x2b\x8f\x7b\xa9\x79\x48\xfe\x57\x12\x22\x58\x59\x6c\xd1\x0c\x24\x61\xbb\x3d\xb2\xb3\xdb\xbe\x03\x74\x13\x06\x5e\x48\xf3\x30\x6a\x25\x93\x89\x9a\x1f\x0f\xdc\x6f\x01\x86\x4d\xc8\x6b\xfa\x42\x53\x6a\xb7\xaf\x01\xff\xb8\x9a\x6c\x23\x2a\x4f\xfa\xee\x22\x0a\x71\x14\xa1\xbf\x9f\xf5\xcd\x9e\x5e\xfc\xf9\x75\x8d\xf1\x18\x50\xd7\x29\xd1\xc1\x86\x1b\x0d\x16\x15\x07\xb5\x95\xef\xf0\xe1\xda\xef\xab\x2d\x77\x77\x5b\x88\x82\xe8\xdd\xa0\xcb\xf4\x9d\x6b\xaa\xe2\xb3\x3e\x21\x82\xf6\xa0\xdc\x1a\x08\x42\xf9\x7e\x1d\x4a\x29\x32\x78\xe0\xf6\xfa\x36\xfc\xb0\x10\x0a\xda\x07\x1e\x3f\xff\xe7\x8f\x7e\x33\x50\x7a\x64\x00\x70\x7c\x4a\x3c\x9b\x6d\xab\x47\x1b\x64\xe9\x0f\x15\x12\xa5\xbf\x36\xe7\xfe\x12\xc6\xa9\x97\x82\xc6\xa7\xb2\x15\x62\xde\x2a\xa9\x2e\x9b\x12\x21\x50\x7d\x73\x9f\x24\xc3\x33\x14\xe8\x41\x09\x8e\x86\x04\x3d\xb9\xf3\x2f\x1f\xde\x36\x9f\x25\x7b\x99\x16\xa2\xfc\xf9\x28\xca\x9a\xe2\x74\x10\x58\x60\xfd\xd8\x36\xe7\xb8\xa5\xd7\x33\x4e\x29\x5f\xdc\xe5\x55\x8d\x21\xb7\x04\x87\xe5\xbd\xb0\x0d\x3b\x65\xe0\x92\xf5\xfb\x25\x29\x76\xd6\xd3\x8c\x2f\x8d\x83\xe8\x05\xb2\x14\x78\xc4\x99\x42\x96\x5f\x91\xf6\x6b\x85\x79\xbd\xd1\xdc\x2e\xd2\x6c\x09\x30\xfb\xb0\xb2\xb6\x0a\x9e\x8f\x77\xcb\xd6\x21\xac\xbc\x25\x39\x94\x11\xfe\x0c\x14\x7f\xdb\x42\x47\x17\x81\x78\x5e\x90\x90\x88\xd3\x2e\x9b\xfa\x98\xe9\xa4\xc1\xd4\x0b\x7a\x6a\xab\x6a\xc5\x5a\x6e\xb5\x5b\xb3\x64\x96\x44\xa6\xf3\xc9\x97\xd8\x94\x51\xea\xfb\x64\x10\xbe\xc4\xad\xd4\xe3\x50\xfc\x99\x83\x4c\x80\x08\xe1\x43\xbc\x1e\xad\x17\x7d\xc9\x96\xbb\x44\xe3\x7c\x7b\x9b\x74\xa3\xcc\x89\x2f\x0e\x4f\x67\xe8\xc8\x1b\xe5\xad\x6e\x7c\x9f\x36\x6a\x8a\x66\x9d\x0f\xee\x91\x47\x85\xe9\x71\xd3\xbf\x20\x4e\x89\x49\x28\x2e\xdb\x0c\xf5\xad\xf1\x3f\xbe\x5b\x4a\xb3\xb6\x2f\xef\x29\x60\x66\x7f\x46\x38\x89\x67\xf9\x58\x11\xfc\x6d\x7c\x96\x31\xaf\xa3\xf4\xf5\xf7\xeb\xc6\x09\x4c\x48\xf3\xd4\xa6\x58\x0b\xc9\x12\x22\x9b\xb5\x64\xe8\xbc\xe1\xa8\x49\xd0\xe1\xcb\xa1\x80\x55\xdb\x91\x37\xfa\x32\x83\x50\x93\x8c\xb9\x94\x94\xc9\x4a\x1b\xf9\xd4\x7e\x3e\xf0\x3b\x3b\xf1\xb3\xa7\x2d\x96\x51\x44\xd5\x3f\xf4\xb9\x11\xe0\x88\x59\x5e\xe8\x0e\x4d\x84\x31\xc2\xd9\x7b\xe8\xa4\x66\x8a\xbb\xec\xc7\xba\xa6\xfd\x11\xcf\x4d\x79\x44\x91\x99\x42\x72\xe0\xf0\xd7\xe6\x06\x4d\x48\xc9\x70\x3c\xa5\x6d\x14\x9e\x3f\xd2\xbc\x10\x7c\xcc\x9e\x03\xbf\x76\x47\xab\x32\x9f\xaa\x5b\xe1\xbd\xf8\x94\x5b\x28\x07\xfb\x56\xdd\x1c\xba\x40\x3e\xe6\xc2\x37\xb3\xfb\xb8\x73\xc1\x4a\x4e\x31\x16\x6a\x7b\xc5\xfa\xdf\x62\x97\xdb\x08\x4d\x9f\xc7\xc9\xa4\x6c\xf9\x1e\xae\xa4\x51\x5a\x34\x48\x0e\x4e\x04\x48\xf9\xd0\xee\x69\x20\xa6\xb5\x8c\xee\x0e\x59\xce\x48\xae\x3a\xd4\xf1\xc0\x33\x2b\x9b\x8f\xb4\x00\xa7\x9d\xec\xa7\x39\x27\xcc\xe1\x16\x79\x56\x1b\xca\x49\xe1\x45\x87\x9d\xa0\x48\x7f\xf6\x0f\xcd\xa2\x4a\xf5\x29\x9a\xea\xc5\x3f\xd0\xc1\x04\x7a\x6e\x82\xb0\x79\x06\x88\x4f\x45\x67\x2a\xa5\x12\x2b\xe3\xc4\xc4\xed\xc5\x26\xcc\x3b\xc0\xaf\x74\xa7\xd1\x73\xb5\x61\x9e\x1f\x46\xa6\x3a\xf7\x6c\x72\x6c\xa0\xad\xae\x0a\x5a\x68\x4d\xfd\xe9\xe2\xf4\x6f\xf2\x9d\xc7\xa2\x22\xdb\x9a\xde\xb4\x0b\xed\x7f\xd3\x4a\x51\x88\x42\xe2\xc4\x57\xf4\x8d\x18\xef\xad\x61\x5b\x9b\x15\x2d\x75\x7f\x46\x50\xe4\x63\x34\x24\x1d\x6b\xec\x32\xab\xa3\xe8\xd2\x0d\x8d\x3f\xce\x3a\xaa\x35\x3d\x04\xa0\x17\xec\x92\xee\xaf\x7d\x31\xaf\x84\xd8\x2f\x39\xbc\x92\x2c\x75\xa3\x23\x2b\x8d\xf1\xbc\xc8\x1b\xba\x77\xe4\x08\x1c\x35\xd9\x60\xe3\x4b\xbe\x3e\x4a\x13\xb7\x31\xfc\x02\x40\x49\x9a\x2d\x90\xe2\xd6\x23\xef\x0f\x32\x63\x3a\xff\x4a\xc4\xd3\x83\xd9\x79\xb8\x7c\x52\x8d\x11\x37\xfc\x32\xab\xfc\x11\x5a\xf6\x09\x47\x0d\xe6\x76\xce\x5f\xdb\xbd\x7b\x5d\x9f\x8f\x17\xdb\x17\xb8\xa4\x2a\x15\xe7\x0f\xfb\x9c\x71\xf8\x90\x8f\xa4\xe8\x00\x41\x32\xad\x35\x37\xef\xb0\xf5\xab\x67\x63\xf8\xfc\xa8\x42\x50\x6a\x72\x73\x2d\x16\x59\xcf\x99\x6e\x45\xed\x73\x66\xe5\x21\xbe\xff\xc4\xe9\xbc\xe3\x62\x1f\x3b\x76\xd5\xc0\x60\x75\x3c\x48\x2b\x93\xb0\x7f\x9f\xef\xbb\x46\xb4\xa0\xe7\x3e\xcb\xec\x11\x34\x1d\x5c\x63\xbb\xc7\x6d\x79\x7d\x9a\x7d\x95\xae\x72\x9b\x5d\x15\x67\x41\xe4\x9c\xce\x52\xb2\xb8\x9f\xe8\x32\xba\xf8\xe6\xd8\x89\x5e\x33\x35\x11\x37\x49\x77\x67\x3e\x72\x9d\xa9\x10\xef\x13\xf7\x9d\x4a\xc9\x43\x46\x77\x05\x9d\xc3\xfa\xe6\x47\x95\xd3\x21\x61\xc5\xae\x9b\x20\xae\xe2\x0c\xfe\x0e\xd3\x74\x35\x01\xf2\x43\x7a\x15\xd7\xa6\x22\x96\x26\x4e\xda\x8e\x4f\xdf\x89\xad\x7b\x6c\xb8\x06\x45\x1f\xfb\xcc\x41\x65\x3b\x76\xd5\x8a\x6b\xaf\x6b\x3c\x80\xe7\x77\x1f\xd8\xfa\xab\xf0\x36\xd8\x3d\x65\xb7\x2e\xee\x35\x56\x3d\xbe\xfa\x78\x0e\x31\xe7\xbf\x3b\xbf\xac\x61\x28\x37\x7c\x06\xfa\xa4\x7f\x6d\x77\x73\x9c\x27\x53\x1d\x0a\x67\x91\x73\xc6\x38\x63\x73\x49\xee\xb5\x00\xd4\x7e\x4f\x11\x7f\x9b\x6a\xa1\x1a\xff\x4f\xfc\x65\x45\x75\x94\xff\xe6\xe6\x9f\x00\x00\x00\xff\xff\x8d\x0d\x57\x81\x8f\x06\x00\x00")

func test_certsNodeKeyBytes() ([]byte, error) {
	return bindataRead(
		_test_certsNodeKey,
		"test_certs/node.key",
	)
}

func test_certsNodeKey() (*asset, error) {
	bytes, err := test_certsNodeKeyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "test_certs/node.key", size: 1679, mode: os.FileMode(384), modTime: time.Unix(1400000000, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"test_certs/ca.crt":              test_certsCaCrt,
	"test_certs/ca.key":              test_certsCaKey,
	"test_certs/client.root.crt":     test_certsClientRootCrt,
	"test_certs/client.root.key":     test_certsClientRootKey,
	"test_certs/client.testuser.crt": test_certsClientTestuserCrt,
	"test_certs/client.testuser.key": test_certsClientTestuserKey,
	"test_certs/node.crt":            test_certsNodeCrt,
	"test_certs/node.key":            test_certsNodeKey,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"test_certs": {nil, map[string]*bintree{
		"ca.crt":              {test_certsCaCrt, map[string]*bintree{}},
		"ca.key":              {test_certsCaKey, map[string]*bintree{}},
		"client.root.crt":     {test_certsClientRootCrt, map[string]*bintree{}},
		"client.root.key":     {test_certsClientRootKey, map[string]*bintree{}},
		"client.testuser.crt": {test_certsClientTestuserCrt, map[string]*bintree{}},
		"client.testuser.key": {test_certsClientTestuserKey, map[string]*bintree{}},
		"node.crt":            {test_certsNodeCrt, map[string]*bintree{}},
		"node.key":            {test_certsNodeKey, map[string]*bintree{}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
