//
// $Id: LineManip.h 72 2005-07-12 00:46:02Z amackenz $
// 

#ifndef __LINEMANIP_H__
#define __LINEMANIP_H__
#include <stdio.h>
#include <string>
#include <vector>
#include <sys/types.h>
#include <regex.h>
#include <ncurses.h>
#include <string.h>

using namespace std;

#define KNRM  "\x1B[0m"
#define KRED  "\x1B[31m"
#define KGRN  "\x1B[32m"
#define KYEL  "\x1B[33m"
#define KBLU  "\x1B[34m"
#define KMAG  "\x1B[35m"
#define KCYN  "\x1B[36m"
#define KWHT  "\x1B[37m"
#define KNUL  ""

// foreground
#define C_BLACK         "\033[0;30m"
#define C_RED           "\033[0;31m"                
#define C_GREEN         "\033[0;32m"
#define C_YELLOW        "\033[0;33m"
#define C_BLUE          "\033[0;34m"
#define C_MAGENTA       "\033[0;35m"
#define C_CYAN          "\033[0;36m"
#define C_WHITE         "\033[0;37m"
#define C_BRIGHTBLACK   "\033[1;30m"
#define C_BRIGHTRED     "\033[1;31m"
#define C_BRIGHTGREEN   "\033[1;32m"
#define C_BRIGHTYELLOW  "\033[1;33m"
#define C_BRIGHTBLUE    "\033[1;34m"
#define C_BRIGHTMAGENTA "\033[1;35m"
#define C_BRIGHTCYAN    "\033[1;36m"
#define C_BRIGHTWHITE   "\033[1;37m"

#define NOCOLOR 99

#define MAXMATCHES 50
class LineManip
{
    private:
        vector<string> ignoreExp;
        vector<int> colorPairs;  // colorPairs[i] will be the color for 
        vector<string> colorExp; // colorExp[i].
        vector<regex_t> colorReg; // Compiled regex list
        string fileName;
        bool logOpen;
        bool colorOkay;

    public:
        LineManip();
        ~LineManip();

        // Both take filename, line
        bool ignore(char *,string);
        
        // Window to print to, string to print, right-scroll offset.
        string printColor (WINDOW*, string , long);

        // Return a string with colors in it.
        string addColor(string);

        void init(char*, string="");
        string findConf();

};

#endif // __LINEMANIP_H__
