﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudtrail/model/EventCategoryAggregation.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace CloudTrail {
namespace Model {
namespace EventCategoryAggregationMapper {

static const int Data_HASH = HashingUtils::HashString("Data");

EventCategoryAggregation GetEventCategoryAggregationForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == Data_HASH) {
    return EventCategoryAggregation::Data;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<EventCategoryAggregation>(hashCode);
  }

  return EventCategoryAggregation::NOT_SET;
}

Aws::String GetNameForEventCategoryAggregation(EventCategoryAggregation enumValue) {
  switch (enumValue) {
    case EventCategoryAggregation::NOT_SET:
      return {};
    case EventCategoryAggregation::Data:
      return "Data";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace EventCategoryAggregationMapper
}  // namespace Model
}  // namespace CloudTrail
}  // namespace Aws
