/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.yura.grasshopper.BugUIInfo;
import net.yura.grasshopper.ConsoleHandler;
import net.yura.grasshopper.LoggingOutputStream;
import net.yura.grasshopper.StdOutErrLevel;
import net.yura.grasshopper.TextHandler;

public abstract class BugManager {
    public static final String VER = "2.3";
    private Thread thread;
    private boolean happened;

    protected abstract void action(String var1);

    public boolean hasHappened() {
        return this.happened;
    }

    public static void interceptAndAlert(Writer a, BugManager b) {
        BugManager.intercept();
        Logger.getLogger("").addHandler(new TextHandler(a, Level.WARNING, b));
    }

    public static void intercept() {
        LogManager.getLogManager().reset();
        final Logger logger = Logger.getLogger("");
        logger.addHandler(new ConsoleHandler());
        System.setOut(new PrintStream(new LoggingOutputStream(StdOutErrLevel.STDOUT), true));
        System.setErr(new PrintStream(new LoggingOutputStream(StdOutErrLevel.STDERR), true));
        final Thread.UncaughtExceptionHandler system = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "Exception in thread \"" + t + "\"", e);
                BugUIInfo.uncaughtException(t, e, system);
            }
        });
    }

    public static PrintStream getSimplePrintStream(Writer sw) {
        return BugManager.getSimplePrintStream(sw, null, null);
    }

    private static PrintStream getSimplePrintStream(final Writer sw, FileDescriptor b, final BugManager ac) {
        final FileOutputStream file = b == null ? null : new FileOutputStream(b);
        return new PrintStream(new OutputStream(){
            private ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);

            public void write(byte[] bi) throws IOException {
                try {
                    if (file != null) {
                        file.write(bi);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.outputStream.write(bi);
            }

            public void write(byte[] bi, int off, int len) throws IOException {
                try {
                    if (file != null) {
                        file.write(bi, off, len);
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                this.outputStream.write(bi, off, len);
            }

            public void write(int bi) throws IOException {
                try {
                    if (file != null) {
                        file.write(bi);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.outputStream.write(bi);
            }

            public void flush() throws IOException {
                try {
                    if (file != null) {
                        file.flush();
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                String string = this.outputStream.toString();
                sw.write(string);
                this.outputStream.reset();
                if (ac != null) {
                    BugManager.action(ac, string);
                }
            }

            public void close() throws IOException {
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.outputStream = null;
            }
        }, true);
    }

    public static void action(final BugManager ac, final String errorSignature) {
        ac.happened = true;
        if (ac.thread == null) {
            ac.thread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    ac.thread = null;
                    try {
                        ac.action(errorSignature);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            ac.thread.start();
        }
    }
}

