/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.logging.Logger;

public class ImageUtil {
    public static ThumbnailLoader thumbLoader;
    public static int LARGESTBYTESTREAM;
    public static int THUMB_MAX_SIZE;

    public static Image makeImage(int w, int h, int color) {
        int[] rgbBuff = new int[w * h];
        for (int i = 0; i < rgbBuff.length; ++i) {
            rgbBuff[i] = color;
        }
        return Image.createRGBImage((int[])rgbBuff, (int)w, (int)h, (boolean)true);
    }

    public static void imageColor(int[] pixels, int color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = (color & 0xFF) >> 0;
        for (int i = 0; i < pixels.length; ++i) {
            int alpha = (pixels[i] & 0xFF000000) >> 24;
            int blue = (pixels[i] & 0xFF) >> 0;
            pixels[i] = alpha << 24 | blue * r / 255 << 16 | blue * g / 255 << 8 | blue * b / 255;
        }
    }

    public static Image imageColor(Image image, int i) {
        int[] ai = new int[image.getWidth() * image.getHeight()];
        image.getRGB(ai, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        ImageUtil.imageColor(ai, i);
        return Image.createRGBImage((int[])ai, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
    }

    public static Image colorize(Image original, int newColor) {
        int[] rgba = new int[original.getWidth() * original.getHeight()];
        original.getRGB(rgba, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        for (int i = 0; i < rgba.length; ++i) {
            int alpha = rgba[i] >> 24 & 0xFF;
            rgba[i] = newColor & 0xFFFFFF | alpha << 24;
        }
        return Image.createRGBImage((int[])rgba, (int)original.getWidth(), (int)original.getHeight(), (boolean)true);
    }

    public static Image scaleImage(Image img, int newW, int newH) {
        try {
            Class.forName("javax.microedition.m3g.Background");
            Image resImg = Image.createImage((int)newW, (int)newH);
            new Graphics2D(resImg.getGraphics()).drawScaledImage(img, 0, 0, newW, newH);
            return resImg;
        }
        catch (Throwable throwable) {
            return ImageUtil.getScaledImage(img, newW, newH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageFromFile(String filename) {
        InputStream is = null;
        try {
            is = FileUtil.getInputStreamFromFileConnector(filename);
            Image image = Image.createImage((InputStream)is);
            return image;
        }
        catch (Throwable err) {
            Logger.warn("failed to load image for: " + filename, err);
            Image image = null;
            return image;
        }
        finally {
            FileUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getThumbnailFromFile(String fileName) {
        Image img;
        if (thumbLoader != null && (img = thumbLoader.getThumbnailFromFile(fileName)) != null) {
            return img;
        }
        InputStream dis = null;
        try {
            dis = FileUtil.getInputStreamFromFileConnector(fileName);
            Image image = ImageUtil.getThumbFromFile(dis);
            return image;
        }
        catch (Throwable err) {
            Logger.warn("failed to load thumb for: " + fileName, err);
            Image image = null;
            return image;
        }
        finally {
            FileUtil.close(dis);
        }
    }

    public static Image getScaledImage(Image dispImage, int width, int height) {
        if (dispImage != null) {
            int imWidth = dispImage.getWidth();
            int imHeight = dispImage.getHeight();
            int widthScale = (imWidth << 9) * 4 / (width * 4);
            int heightScale = (imHeight << 9) * 1 / height;
            int chosenScale = Math.max(widthScale, heightScale);
            dispImage = ImageUtil.resize(dispImage, 0, chosenScale, 9);
        }
        return dispImage;
    }

    public static Image getJPEGthumb(byte[] fileBytes) {
        Image image = null;
        try {
            if (ImageUtil.isJPEG(fileBytes[0], fileBytes[1])) {
                int startIndex = 2;
                while (true) {
                    if (fileBytes[startIndex] != -1) {
                        ++startIndex;
                        continue;
                    }
                    if ((fileBytes[++startIndex] & 0xFF) == 216) break;
                }
                int endIndex = startIndex + 1;
                while (true) {
                    if (fileBytes[endIndex] != -1) {
                        ++endIndex;
                        continue;
                    }
                    if ((fileBytes[++endIndex] & 0xFF) == 217) break;
                }
                image = Image.createImage((byte[])fileBytes, (int)(startIndex - 1), (int)(endIndex - startIndex + 2));
            }
        }
        catch (Throwable e) {
            Logger.error(null, e);
        }
        return image;
    }

    private static byte[] readStream2(InputStream inStr, int no_of_filebytes) throws IOException {
        DataInputStream newStr = new DataInputStream(inStr);
        byte[] byteArray = new byte[no_of_filebytes];
        newStr.readFully(byteArray);
        newStr.close();
        return byteArray;
    }

    private static boolean isJPEG(byte b1, byte b2) {
        return (b1 & 0xFF) == 255 && (b2 & 0xFF) == 216;
    }

    public static Image getThumbFromFile(InputStream str) throws IOException {
        byte[] tempByteArray = new byte[THUMB_MAX_SIZE];
        byte[] bytefileReader = new byte[]{0};
        byte secondByte = 0;
        int currentIndex = 0;
        str.read(bytefileReader);
        byte firstByte = bytefileReader[0];
        str.read(bytefileReader);
        secondByte = bytefileReader[0];
        if (ImageUtil.isJPEG(firstByte, secondByte)) {
            int a;
            int rByte = 0;
            while (true) {
                if (rByte != -1) {
                    a = str.read(bytefileReader);
                    if (a == -1) {
                        return null;
                    }
                    rByte = bytefileReader[0];
                    continue;
                }
                a = str.read(bytefileReader);
                if (a == -1) {
                    return null;
                }
                rByte = bytefileReader[0];
                if ((rByte & 0xFF) == 216) break;
            }
            tempByteArray[currentIndex++] = -1;
            tempByteArray[currentIndex++] = rByte;
            rByte = 0;
            while (true) {
                if (rByte != -1) {
                    a = str.read(bytefileReader);
                    if (a == -1) {
                        return null;
                    }
                    rByte = bytefileReader[0];
                    tempByteArray[currentIndex++] = rByte;
                    continue;
                }
                a = str.read(bytefileReader);
                if (a == -1) {
                    return null;
                }
                rByte = bytefileReader[0];
                tempByteArray[currentIndex++] = rByte;
                if ((rByte & 0xFF) == 217) break;
            }
            tempByteArray[currentIndex++] = -1;
            Image im = Image.createImage((byte[])tempByteArray, (int)0, (int)(currentIndex - 1));
            tempByteArray = null;
            return im;
        }
        str.close();
        return null;
    }

    public static Image createImage(String filename, int cW, int cH) throws IOException, IOException {
        Image rImage = null;
        FileConnection fconn = (FileConnection)Connector.open((String)filename);
        InputStream inStream = fconn.openInputStream();
        if (fconn.fileSize() > (long)LARGESTBYTESTREAM) {
            rImage = ImageUtil.getThumbFromFile(inStream);
        } else {
            byte[] fileBytes = ImageUtil.readStream2(inStream, (int)fconn.fileSize());
            inStream.close();
            fconn.close();
            rImage = ImageUtil.createImage(fileBytes);
            fileBytes = null;
        }
        Image scaledImage = ImageUtil.getScaledImage(rImage, cW, cH);
        return scaledImage;
    }

    public static Image createImage(InputStream is, int cW, int cH) {
        try {
            return ImageUtil.getScaledImage(Image.createImage((InputStream)is), cW, cH);
        }
        catch (Exception ex) {
            Logger.warn(null, ex);
            return null;
        }
    }

    private static Image createImage(byte[] encodedImage) {
        try {
            Object dispImage = null;
            if (encodedImage.length > LARGESTBYTESTREAM) {
                return ImageUtil.getJPEGthumb(encodedImage);
            }
            if (dispImage == null) {
                return Image.createImage((byte[])encodedImage, (int)0, (int)encodedImage.length);
            }
        }
        catch (Exception e) {
            System.gc();
            try {
                return ImageUtil.getJPEGthumb(encodedImage);
            }
            catch (Exception e2) {
                Logger.warn(null, e2);
            }
        }
        return null;
    }

    public static Image resize(Image inImage, int rotation, int scaleFactor, int scalePwr) {
        if (inImage == null) {
            return null;
        }
        int inImWidth = inImage.getWidth();
        int inImHeight = inImage.getHeight();
        int[] rgbRowIn = new int[inImWidth];
        int outHeight = (inImHeight << scalePwr) / scaleFactor;
        int outWidth = (inImWidth << scalePwr) / scaleFactor;
        int inImStartW = 0;
        int inImStepW = 0;
        int inImStartH = 0;
        int inImStepH = scaleFactor;
        int rgbRowStartIndex = 0;
        int stepRgbRow = scaleFactor;
        int getRGBwidth = inImWidth;
        int getRGBheight = 1;
        int[] rgbRowOut = new int[outWidth];
        Image outImage = Image.createImage((int)outWidth, (int)outHeight);
        if (outImage == null) {
            return null;
        }
        Graphics imGraphic = outImage.getGraphics();
        if (imGraphic == null || rgbRowIn == null || rgbRowOut == null) {
            outImage = null;
            return null;
        }
        for (int h = 0; h < outHeight; ++h) {
            int currW = rgbRowStartIndex;
            int x = Math.max(0, Math.min(inImWidth - 1, inImStartW >> scalePwr));
            int y = Math.max(0, Math.min(inImHeight - 1, inImStartH >> scalePwr));
            inImage.getRGB(rgbRowIn, 0, getRGBwidth, x, y, getRGBwidth, getRGBheight);
            for (int w = 0; w < outWidth; ++w) {
                rgbRowOut[w] = rgbRowIn[Math.max(0, Math.min(rgbRowIn.length, currW >> scalePwr))];
                currW += stepRgbRow;
            }
            imGraphic.drawRGB(rgbRowOut, 0, outWidth, 0, h, outWidth, 1, false);
            inImStartW += inImStepW;
            inImStartH += inImStepH;
        }
        return outImage;
    }

    public static void saveImage(Image image, OutputStream outputStream, String format) throws Exception {
        MediaProcessor mediaProc = GlobalManager.createMediaProcessor((String)"image/raw");
        ImageFormatControl formatControl = (ImageFormatControl)mediaProc.getControl("javax.microedition.amms.control.ImageFormatControl");
        formatControl.setFormat("image/" + format);
        mediaProc.setInput((Object)image);
        mediaProc.setOutput(outputStream);
        mediaProc.complete();
    }

    public static void saveImage(Image image, OutputStream outputStream) {
        try {
            ImageUtil.saveImage(image, outputStream, "jpeg");
        }
        catch (Exception ex) {
            System.out.println("failed to save jpg, falling back to png");
            try {
                ImageUtil.saveImage(image, outputStream, "png");
            }
            catch (Exception ex2) {
                Logger.warn(null, ex);
                Logger.warn(null, ex2);
            }
        }
    }

    static {
        LARGESTBYTESTREAM = 170000;
        THUMB_MAX_SIZE = 30000;
    }

    public static interface ThumbnailLoader {
        public Image getThumbnailFromFile(String var1);
    }
}

