/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.plaf.nimbus;

import java.util.Vector;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.plaf.nimbus.NimbusBorderSetting;

public class NimbusBorder
implements Border {
    public static final int ORIENTATION_VERT = 0;
    public static final int ORIENTATION_HORI = 90;
    int marginX;
    int marginY;
    int paddingX;
    int paddingY;
    Vector borders;
    int[] borderSizes = new int[4];
    int gradientOrientation = 0;
    private static final int[] corner2 = new int[]{0, 2, 1};
    private static final int[] corner3 = new int[]{0, 3, 1, 1};
    private static final int[] corner4 = new int[]{0, 4, 2, 1, 1};

    public NimbusBorder(Vector borders, int marginX, int marginY, int paddingX, int paddingY) {
        this.borders = borders;
        this.marginX = marginX;
        this.marginY = marginY;
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        this.initialise();
    }

    NimbusBorder(Vector borderSettings) {
        this(borderSettings, 0, 0, 0, 0);
    }

    private void initialise() {
        this.borderSizes[0] = this.borderSize(0);
        this.borderSizes[2] = this.borderSize(2);
        this.borderSizes[1] = this.borderSize(1);
        this.borderSizes[3] = this.borderSize(3);
    }

    public void paintBorder(Component c, Graphics2D g, int width, int height) {
        if (this.borders == null) {
            return;
        }
        int x = -this.getLeft() + this.marginX;
        int y = -this.getTop() + this.marginY;
        int w = width + this.getLeft() + this.getRight() - this.marginX * 2;
        int h = height + this.getTop() + this.getBottom() - this.marginY * 2;
        NimbusBorder.paintBorders(this.borders, g, x, y, w, h);
    }

    public static void paintBorders(Vector borders, Graphics2D g, int x, int y, int w, int h) {
        if (borders == null || w <= 0 || h <= 0) {
            return;
        }
        int borderX = x;
        int borderY = y;
        int borderWidth = w;
        int borderHeight = h;
        for (int b = 0; b < borders.size(); ++b) {
            NimbusBorderSetting border = (NimbusBorderSetting)borders.elementAt(b);
            NimbusBorder.drawRoundedGradientRect(border.color1, border.color2, g, borderX, borderY, borderWidth, borderHeight, border.corner, border.reflection, border.gradientOrientation);
            borderX += border.thickness[3];
            borderY += border.thickness[0];
            borderWidth -= border.thickness[3] + border.thickness[1];
            borderHeight -= border.thickness[0] + border.thickness[2];
        }
    }

    private int borderSize(int position) {
        int size = 0;
        for (int i = 0; i < this.borders.size() - 1; ++i) {
            NimbusBorderSetting border = (NimbusBorderSetting)this.borders.elementAt(i);
            size += border.thickness[position];
        }
        return size;
    }

    public int getTop() {
        return this.marginY + this.borderSizes[0] + this.paddingY;
    }

    public int getBottom() {
        return this.marginY + this.borderSizes[2] + this.paddingY;
    }

    public int getRight() {
        return this.marginX + this.borderSizes[3] + this.paddingX;
    }

    public int getLeft() {
        return this.marginX + this.borderSizes[1] + this.paddingX;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb >> 0 & 0xFF;
    }

    public static int getRGB(int r, int b, int g) {
        r = (r & 0xFF) << 16;
        g = (g & 0xFF) << 8;
        b = (b & 0xFF) << 0;
        return r | g | b | 0xFF000000;
    }

    public static int[] getGradientColors(int c1, int c2, int total, double reflection) {
        double max = (int)((double)total * reflection);
        double r1 = NimbusBorder.getRed(c1);
        double g1 = NimbusBorder.getGreen(c1);
        double b1 = NimbusBorder.getBlue(c1);
        double r2 = NimbusBorder.getRed(c2);
        double g2 = NimbusBorder.getGreen(c2);
        double b2 = NimbusBorder.getBlue(c2);
        double incrR = (r1 - r2) / max;
        double incrG = (g1 - g2) / max;
        double incrB = (b1 - b2) / max;
        int[] gradient = new int[total];
        for (int i = 0; i < total; ++i) {
            int offset = (double)i <= max ? i : (int)(max - ((double)i - max));
            int r = (int)(r1 - incrR * (double)offset);
            int g = (int)(g1 - incrG * (double)offset);
            int b = (int)(b1 - incrB * (double)offset);
            gradient[i] = NimbusBorder.getRGB(r, b, g);
        }
        return gradient;
    }

    private static int getCornerLineWidth(int pos, int corner) {
        switch (corner) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return corner2[pos];
            }
            case 3: {
                return corner3[pos];
            }
            case 4: {
                return corner4[pos];
            }
        }
        return 0;
    }

    public static void drawRoundedGradientRect(int c1, int c2, Graphics2D g, int x, int y, int width, int height, int[] corners, double reflection, int gradientOrientation) {
        int br;
        int bl;
        int tr;
        int tl;
        int maxSize;
        int axis;
        if (c1 == 0 && c2 == 0) {
            return;
        }
        if (gradientOrientation == 0) {
            axis = height;
            maxSize = width;
            tl = 0;
            tr = 1;
            bl = 2;
            br = 3;
        } else {
            axis = width;
            maxSize = height;
            tl = 0;
            tr = 2;
            bl = 1;
            br = 3;
        }
        int maxCornerPre = corners[tl] > corners[tr] ? corners[tl] : corners[tr];
        int maxCornerPost = corners[bl] > corners[br] ? corners[bl] : corners[br];
        int[] gradient = NimbusBorder.getGradientColors(c1, c2, axis, reflection);
        for (int i = 0; i < axis; ++i) {
            boolean rounded = false;
            int w = maxSize;
            int offsetPre = 0;
            int offsetPost = 0;
            if (i < maxCornerPre) {
                offsetPre = NimbusBorder.getCornerLineWidth(i + 1, corners[tl]);
                offsetPost = NimbusBorder.getCornerLineWidth(i + 1, corners[tr]);
                rounded = true;
            }
            if (axis - i <= maxCornerPost) {
                offsetPre = NimbusBorder.getCornerLineWidth(axis - i, corners[bl]);
                offsetPost = NimbusBorder.getCornerLineWidth(axis - i, corners[br]);
                rounded = true;
            }
            w = maxSize - offsetPre - offsetPost;
            if (c1 == c2 && !rounded) {
                g.setColor(c1);
                int blockSize = axis - maxCornerPre - maxCornerPost;
                if (gradientOrientation == 0) {
                    g.fillRect(x, i + y, maxSize, blockSize);
                } else {
                    g.fillRect(x + i, y, blockSize, maxSize);
                }
                i = axis - maxCornerPost - 1;
                continue;
            }
            --w;
            g.setColor(gradient[i]);
            if (gradientOrientation == 0) {
                g.drawLine(x + offsetPre, y + i, x + offsetPre + w, i + y);
                continue;
            }
            g.drawLine(x + i, y + offsetPre, x + i, y + offsetPre + w);
        }
    }

    public static void drawRoundedGradientRect(int c1, int c2, Graphics2D g, int x, int y, int width, int height, int corner, double reflection, int gradientOrientation) {
        int[] corners = new int[]{corner, corner, corner, corner};
        NimbusBorder.drawRoundedGradientRect(c1, c2, g, x, y, width, height, corners, reflection, gradientOrientation);
    }

    public static void drawRoundedGradientRect(int c1, int c2, Graphics2D g, int x, int y, int width, int height, int corner, int gradientOrientation) {
        NimbusBorder.drawRoundedGradientRect(c1, c2, g, x, y, width, height, corner, 1.0, gradientOrientation);
    }
}

