/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScmDeviceComponent;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.lcdui.FontInfo;
import org.me4se.impl.lcdui.PhysicalFont;
import org.me4se.impl.lcdui.TextBlock;

public class ScmDeviceLabel
extends ScmDeviceComponent {
    protected String label;
    Font midpFont;
    Vector actionListeners;
    public boolean selected;
    public boolean selectOnFocus;
    public String actionCommand;
    public boolean compact;
    public boolean highlight;
    public boolean checkbox;
    public Vector group;
    public BufferedImage image;
    public Object object;
    TextBlock textBlock;

    public ScmDeviceLabel(String type, Item item, boolean focusable) {
        super(item, type, focusable);
    }

    public void action() {
        this.select(this.group != null | !this.selected);
        if (this.actionListeners != null) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ((ActionListener)this.actionListeners.elementAt(i)).actionPerformed(new ActionEvent(this, 1001, this.actionCommand == null ? this.label : this.actionCommand));
            }
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.addElement(l);
    }

    public boolean keyReleased(String s) {
        if (s.equals("SELECT")) {
            this.action();
            return true;
        }
        return super.keyReleased(s);
    }

    public void focusGained() {
        super.focusGained();
        if (this.selectOnFocus) {
            this.select(true);
        }
    }

    public boolean mouseClicked(int button, int x, int y, int modifiers, int clicks) {
        if (!super.mouseClicked(button, x, y, modifiers, clicks) || !this.selectOnFocus) {
            this.action();
        }
        return true;
    }

    public void paint(Graphics g) {
        super.paint(g);
        int x = this.getFocusable() ? 3 : 0;
        int w = this.getWidth();
        int h = this.getHeight();
        FontInfo fi = this.fontInfo[this.hasFocus() ? 1 : 0];
        g.setColor(fi.foreground);
        g.setColor(fi.foreground);
        if (this.textBlock != null) {
            this.textBlock.paint(g, x, 0);
            return;
        }
        PhysicalFont pf = fi.font;
        ApplicationManager manager = ApplicationManager.getInstance();
        int y = h / 2 - 1;
        if (this.checkbox) {
            if (this.group == null) {
                g.setColor(new Color(manager.getDeviceColor(0x808080)));
                g.drawRect(x, y - 4, 8, 8);
                g.setColor(Color.black);
                if (this.selected) {
                    g.drawLine(x, y, x + 4, y + 4);
                    g.drawLine(x + 1, y, x + 4, y + 4);
                    g.drawLine(x + 4, y + 4, x + 9, y - 5);
                    g.drawLine(x + 4, y + 4, x + 10, y - 5);
                }
            } else {
                g.drawOval(x, y - 4, 7, 7);
                if (this.selected) {
                    g.drawOval(x + 2, y - 2, 3, 3);
                    g.fillOval(x + 2, y - 2, 3, 3);
                }
            }
            x += 11;
        }
        if (this.label == null) {
            return;
        }
        if (x == 0) {
            switch (fi.align) {
                case 3: {
                    x = (w - pf.stringWidth(this.label)) / 2;
                    break;
                }
                case 15: {
                    if (this.getX() == 0) break;
                }
                case 2: {
                    x = w - pf.stringWidth(this.label);
                }
            }
            if (x < 0) {
                x = 0;
            }
        }
        if (this.image != null && fi.align == 1) {
            int imgH = this.image.getHeight();
            int imgW = this.image.getWidth();
            g.drawImage(this.image, x, y - imgH / 2, null);
            x += imgW + 3;
        }
        y = (h - pf.height) / 2;
        if (fi.background != null && (fi.decoration & 0x40) != 0) {
            g.setColor(fi.background);
            g.fillRect(x - 1, y, pf.stringWidth(this.label) + 2, pf.height);
            g.setColor(fi.foreground);
        }
        this.getFontInfo().drawString(g, this.label, x, y + pf.ascent);
    }

    public void setActionCommand(String cmd) {
        this.actionCommand = cmd;
    }

    public String getText() {
        return this.label;
    }

    public void setText(String l) {
        this.label = l;
        this.repaint();
    }

    public void doLayout() {
        if (this.compact && !this.getFocusable() && this.getParent() != null && !this.checkbox) {
            this.textBlock = new TextBlock(this.fontInfo[0].font, this.label, this.getParent().getWidth());
        } else {
            super.doLayout();
        }
    }

    public Dimension getMinimumSize() {
        if (this.compact && !this.getFocusable()) {
            if (this.label == null || this.label.length() == 0) {
                return new Dimension(0, 0);
            }
            if (!this.checkbox && this.getParent() != null) {
                return new Dimension(0, new TextBlock(this.fontInfo[0].font, this.label, this.getParent().getWidth()).getHeight());
            }
        }
        return super.getMinimumSize();
    }

    public boolean selected() {
        return this.selected;
    }

    public void select(boolean state) {
        if (this.group == null) {
            if (this.selected != state) {
                this.selected = state;
                this.repaint();
            }
        } else {
            for (int i = 0; i < this.group.size(); ++i) {
                ScmDeviceLabel dl = (ScmDeviceLabel)this.group.elementAt(i);
                if (dl.selected == (dl == this)) continue;
                dl.selected = !dl.selected;
                dl.repaint();
            }
        }
    }

    public String toString() {
        return "DeviceLabel type " + this.type + " text: " + this.label + " class " + this.getClass();
    }
}

