/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ScmDeviceLabel;
import javax.microedition.lcdui.ScmDeviceList;
import javax.microedition.lcdui.Screen;

public class List
extends Screen
implements Choice {
    public static final Command SELECT_COMMAND = new Command("Select", 4, 0);
    Command selectCommand = SELECT_COMMAND;
    int type;
    int fitPolicy;
    ScmDeviceList list = new ScmDeviceList(this);
    Vector group;
    ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            if (List.this.selectCommand != null) {
                List.this.handleCommand(List.this.selectCommand, null);
            }
        }
    };

    public List(String title, int listType) {
        super(title);
        this.type = listType;
        if (this.type != 2) {
            this.group = new Vector();
        }
        this.container.setMain(this.list, true);
        this.selectButtonRequired = true;
        this.container.updateButtons();
    }

    public List(String title, int listType, String[] stringElements, Image[] imageElements) {
        this(title, listType);
        for (int i = 0; i < stringElements.length; ++i) {
            this.append(stringElements[i], imageElements == null ? null : imageElements[i]);
        }
    }

    public int append(String s, Image i) {
        this.insert(this.size(), s, i);
        return this.size() - 1;
    }

    public void delete(int index) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.group != null) {
            this.group.removeElementAt(index);
        }
        this.list.remove(index);
        this._showNotify();
    }

    ScmDeviceLabel getLabel(int index) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return (ScmDeviceLabel)this.list.getComponent(index);
    }

    public Image getImage(int index) {
        return (Image)this.getLabel((int)index).object;
    }

    public int getSelectedFlags(boolean[] flags) {
        int i;
        int cnt = this.size();
        for (i = 0; i < cnt; ++i) {
            flags[i] = this.isSelected(i);
        }
        for (i = cnt; i < flags.length; ++i) {
            flags[i] = false;
        }
        return cnt;
    }

    public int getSelectedIndex() {
        if (this.type != 2) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.isSelected(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public String getString(int index) {
        return this.getLabel(index).getText();
    }

    public void insert(int index, String stringItem, Image imageItem) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ScmDeviceLabel label = new ScmDeviceLabel("item", null, true);
        label.selectButtonRequired = true;
        label.setText(stringItem);
        if (imageItem != null) {
            label.object = imageItem;
            label.image = imageItem._image;
        }
        label.highlight = true;
        boolean bl = label.checkbox = this.type != 3;
        if (this.type == 3) {
            label.selectOnFocus = true;
            label.addActionListener(this.listener);
        }
        if (this.group != null) {
            this.group.addElement(label);
            label.group = this.group;
        }
        this.list.add(label, index);
    }

    public boolean isSelected(int index) {
        return this.getLabel(index).selected();
    }

    public void set(int index, String str, Image img) {
        boolean sel = this.isSelected(index);
        this.delete(index);
        this.insert(index, str, img);
        this.setSelectedIndex(index, sel);
    }

    public void setSelectedFlags(boolean[] flags) {
        for (int i = 0; i < this.size(); ++i) {
            this.getLabel(i).select(flags[i]);
            if (this.group == null || !flags[i]) continue;
            return;
        }
    }

    public void setSelectedIndex(int i, boolean state) {
        this.getLabel(i).select(state);
    }

    public int size() {
        return this.list.getComponentCount();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass() + "(lcduiList)[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.getString(i));
        }
        buf.append(']');
        return buf.toString();
    }

    void _showNotify() {
        if (this.type == 3) {
            int i = this.getSelectedIndex();
            if (i == -1) {
                this.list.validateFocus();
            } else {
                this.getLabel(i).requestFocus();
            }
        } else {
            this.list.validateFocus();
        }
    }

    public void deleteAll() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.delete(i);
        }
    }

    public void setSelectCommand(Command command) {
        this.selectCommand = command;
    }

    public void setFitPolicy(int fitPolicy) {
        this.fitPolicy = fitPolicy;
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public void setFont(int elementNum, Font font) {
        this.getLabel((int)elementNum).midpFont = font;
    }

    public Font getFont(int elementNum) {
        Font value = this.getLabel((int)elementNum).midpFont;
        return value == null ? Font.getFont(0, 0, 0) : value;
    }
}

