// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
use ctypes::{c_float, c_int, c_long, c_void};
use shared::basetsd::{SIZE_T, UINT64, UINT8};
use shared::dxgi::{DXGI_SWAP_CHAIN_DESC, IDXGIAdapter, IDXGISwapChain};
use shared::dxgiformat::DXGI_FORMAT;
use shared::dxgitype::{DXGI_RATIONAL, DXGI_SAMPLE_DESC};
use shared::guiddef::{GUID, REFGUID, REFIID};
use shared::minwindef::{BOOL, BYTE, DWORD, FLOAT, HMODULE, INT, UINT, USHORT};
use shared::windef::{RECT, SIZE};
use um::d3dcommon::{
    D3D_DRIVER_TYPE, D3D_FEATURE_LEVEL, D3D_PRIMITIVE, D3D_PRIMITIVE_TOPOLOGY, D3D_SRV_DIMENSION,
};
use um::unknwnbase::{IUnknown, IUnknownVtbl};
use um::winnt::{HANDLE, HRESULT, LPCSTR, LPSTR, ULONGLONG};
pub const D3D11_16BIT_INDEX_STRIP_CUT_VALUE: DWORD = 0xffff;
pub const D3D11_32BIT_INDEX_STRIP_CUT_VALUE: DWORD = 0xffffffff;
pub const D3D11_8BIT_INDEX_STRIP_CUT_VALUE: DWORD = 0xff;
pub const D3D11_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT: DWORD = 9;
pub const D3D11_CLIP_OR_CULL_DISTANCE_COUNT: DWORD = 8;
pub const D3D11_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: DWORD = 2;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT: DWORD = 14;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS: DWORD = 4;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT: DWORD = 15;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT: DWORD = 16;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT: DWORD = 15;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT: DWORD = 64;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT: DWORD = 1;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT: DWORD = 128;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT: DWORD = 128;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_COUNT: DWORD = 16;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT: DWORD = 16;
pub const D3D11_COMMONSHADER_SUBROUTINE_NESTING_LIMIT: DWORD = 32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COUNT: DWORD = 4096;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_READS_PER_INST: DWORD = 3;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_READ_PORTS: DWORD = 3;
pub const D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX: DWORD = 10;
pub const D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN: c_long = -10;
pub const D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE: c_long = -8;
pub const D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE: DWORD = 7;
pub const D3D11_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 256;
pub const D3D11_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP: DWORD = 64;
pub const D3D11_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 240;
pub const D3D11_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP: DWORD = 68;
pub const D3D11_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 224;
pub const D3D11_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP: DWORD = 72;
pub const D3D11_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 208;
pub const D3D11_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP: DWORD = 76;
pub const D3D11_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 192;
pub const D3D11_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP: DWORD = 84;
pub const D3D11_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 176;
pub const D3D11_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP: DWORD = 92;
pub const D3D11_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 160;
pub const D3D11_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP: DWORD = 100;
pub const D3D11_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 144;
pub const D3D11_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP: DWORD = 112;
pub const D3D11_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 128;
pub const D3D11_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP: DWORD = 128;
pub const D3D11_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 112;
pub const D3D11_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP: DWORD = 144;
pub const D3D11_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 96;
pub const D3D11_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP: DWORD = 168;
pub const D3D11_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 80;
pub const D3D11_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP: DWORD = 204;
pub const D3D11_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 64;
pub const D3D11_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP: DWORD = 256;
pub const D3D11_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 48;
pub const D3D11_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP: DWORD = 340;
pub const D3D11_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 32;
pub const D3D11_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP: DWORD = 512;
pub const D3D11_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: DWORD = 16;
pub const D3D11_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP: DWORD = 768;
pub const D3D11_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION: DWORD = 1;
pub const D3D11_CS_4_X_RAW_UAV_BYTE_ALIGNMENT: DWORD = 256;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP: DWORD = 768;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_X: DWORD = 768;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_Y: DWORD = 768;
pub const D3D11_CS_4_X_UAV_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION: DWORD = 65535;
pub const D3D11_CS_TGSM_REGISTER_COUNT: DWORD = 8192;
pub const D3D11_CS_TGSM_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_CS_TGSM_RESOURCE_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_CS_TGSM_RESOURCE_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_CS_THREADGROUPID_REGISTER_COMPONENTS: DWORD = 3;
pub const D3D11_CS_THREADGROUPID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_THREADIDINGROUP_REGISTER_COMPONENTS: DWORD = 3;
pub const D3D11_CS_THREADIDINGROUP_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_THREADID_REGISTER_COMPONENTS: DWORD = 3;
pub const D3D11_CS_THREADID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP: DWORD = 1024;
pub const D3D11_CS_THREAD_GROUP_MAX_X: DWORD = 1024;
pub const D3D11_CS_THREAD_GROUP_MAX_Y: DWORD = 1024;
pub const D3D11_CS_THREAD_GROUP_MAX_Z: DWORD = 64;
pub const D3D11_CS_THREAD_GROUP_MIN_X: DWORD = 1;
pub const D3D11_CS_THREAD_GROUP_MIN_Y: DWORD = 1;
pub const D3D11_CS_THREAD_GROUP_MIN_Z: DWORD = 1;
pub const D3D11_CS_THREAD_LOCAL_TEMP_REGISTER_POOL: DWORD = 16384;
pub const D3D11_DEFAULT_BLEND_FACTOR_ALPHA: FLOAT = 1.0;
pub const D3D11_DEFAULT_BLEND_FACTOR_BLUE: FLOAT = 1.0;
pub const D3D11_DEFAULT_BLEND_FACTOR_GREEN: FLOAT = 1.0;
pub const D3D11_DEFAULT_BLEND_FACTOR_RED: FLOAT = 1.0;
pub const D3D11_DEFAULT_BORDER_COLOR_COMPONENT: FLOAT = 0.0;
pub const D3D11_DEFAULT_DEPTH_BIAS: DWORD = 0;
pub const D3D11_DEFAULT_DEPTH_BIAS_CLAMP: FLOAT = 0.0;
pub const D3D11_DEFAULT_MAX_ANISOTROPY: DWORD = 16;
pub const D3D11_DEFAULT_MIP_LOD_BIAS: FLOAT = 0.0;
pub const D3D11_DEFAULT_RENDER_TARGET_ARRAY_INDEX: DWORD = 0;
pub const D3D11_DEFAULT_SAMPLE_MASK: DWORD = 0xffffffff;
pub const D3D11_DEFAULT_SCISSOR_ENDX: DWORD = 0;
pub const D3D11_DEFAULT_SCISSOR_ENDY: DWORD = 0;
pub const D3D11_DEFAULT_SCISSOR_STARTX: DWORD = 0;
pub const D3D11_DEFAULT_SCISSOR_STARTY: DWORD = 0;
pub const D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS: FLOAT = 0.0;
pub const D3D11_DEFAULT_STENCIL_READ_MASK: DWORD = 0xff;
pub const D3D11_DEFAULT_STENCIL_REFERENCE: DWORD = 0;
pub const D3D11_DEFAULT_STENCIL_WRITE_MASK: DWORD = 0xff;
pub const D3D11_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX: DWORD = 0;
pub const D3D11_DEFAULT_VIEWPORT_HEIGHT: DWORD = 0;
pub const D3D11_DEFAULT_VIEWPORT_MAX_DEPTH: FLOAT = 0.0;
pub const D3D11_DEFAULT_VIEWPORT_MIN_DEPTH: FLOAT = 0.0;
pub const D3D11_DEFAULT_VIEWPORT_TOPLEFTX: DWORD = 0;
pub const D3D11_DEFAULT_VIEWPORT_TOPLEFTY: DWORD = 0;
pub const D3D11_DEFAULT_VIEWPORT_WIDTH: DWORD = 0;
pub const D3D11_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: DWORD = 3968;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS: DWORD = 3;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT: DWORD = 1;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_DS_OUTPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_DS_OUTPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_FLOAT16_FUSED_TOLERANCE_IN_ULP: FLOAT = 0.6;
pub const D3D11_FLOAT32_MAX: FLOAT = 3.402823466E+38;
pub const D3D11_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP: FLOAT = 0.6;
pub const D3D11_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR: FLOAT = 2.4;
pub const D3D11_FLOAT_TO_SRGB_EXPONENT_NUMERATOR: FLOAT = 1.0;
pub const D3D11_FLOAT_TO_SRGB_OFFSET: FLOAT = 0.055;
pub const D3D11_FLOAT_TO_SRGB_SCALE_1: FLOAT = 12.92;
pub const D3D11_FLOAT_TO_SRGB_SCALE_2: FLOAT = 1.055;
pub const D3D11_FLOAT_TO_SRGB_THRESHOLD: FLOAT = 0.0031308;
pub const D3D11_FTOI_INSTRUCTION_MAX_INPUT: FLOAT = 2147483647.999;
pub const D3D11_FTOI_INSTRUCTION_MIN_INPUT: FLOAT = -2147483648.999;
pub const D3D11_FTOU_INSTRUCTION_MAX_INPUT: FLOAT = 4294967295.999;
pub const D3D11_FTOU_INSTRUCTION_MIN_INPUT: FLOAT = 0.0;
pub const D3D11_GS_INPUT_INSTANCE_ID_READS_PER_INST: DWORD = 2;
pub const D3D11_GS_INPUT_INSTANCE_ID_READ_PORTS: DWORD = 1;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COUNT: DWORD = 1;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_GS_INPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_GS_INPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_GS_INPUT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_GS_INPUT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_GS_INPUT_REGISTER_VERTICES: DWORD = 32;
pub const D3D11_GS_MAX_INSTANCE_COUNT: DWORD = 32;
pub const D3D11_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES: DWORD = 1024;
pub const D3D11_GS_OUTPUT_ELEMENTS: DWORD = 32;
pub const D3D11_GS_OUTPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_GS_OUTPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_HS_CONTROL_POINT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_CONTROL_POINT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_CONTROL_POINT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND: DWORD = 0xffffffff;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND: DWORD = 0xffffffff;
pub const D3D11_HS_MAXTESSFACTOR_LOWER_BOUND: FLOAT = 1.0;
pub const D3D11_HS_MAXTESSFACTOR_UPPER_BOUND: FLOAT = 64.0;
pub const D3D11_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: DWORD = 3968;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT: DWORD = 1;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS: DWORD = 128;
pub const D3D11_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES: DWORD = 0;
pub const D3D11_IA_DEFAULT_PRIMITIVE_TOPOLOGY: DWORD = 0;
pub const D3D11_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES: DWORD = 0;
pub const D3D11_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT: DWORD = 1;
pub const D3D11_IA_INSTANCE_ID_BIT_COUNT: DWORD = 32;
pub const D3D11_IA_INTEGER_ARITHMETIC_BIT_COUNT: DWORD = 32;
pub const D3D11_IA_PATCH_MAX_CONTROL_POINT_COUNT: DWORD = 32;
pub const D3D11_IA_PRIMITIVE_ID_BIT_COUNT: DWORD = 32;
pub const D3D11_IA_VERTEX_ID_BIT_COUNT: DWORD = 32;
pub const D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT: DWORD = 32;
pub const D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS: DWORD = 128;
pub const D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT: DWORD = 32;
pub const D3D11_INTEGER_DIVIDE_BY_ZERO_QUOTIENT: DWORD = 0xffffffff;
pub const D3D11_INTEGER_DIVIDE_BY_ZERO_REMAINDER: DWORD = 0xffffffff;
pub const D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL: DWORD = 0xffffffff;
pub const D3D11_KEEP_UNORDERED_ACCESS_VIEWS: DWORD = 0xffffffff;
pub const D3D11_LINEAR_GAMMA: FLOAT = 1.0;
pub const D3D11_MAJOR_VERSION: DWORD = 11;
pub const D3D11_MAX_BORDER_COLOR_COMPONENT: FLOAT = 1.0;
pub const D3D11_MAX_DEPTH: FLOAT = 1.0;
pub const D3D11_MAX_MAXANISOTROPY: DWORD = 16;
pub const D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT: DWORD = 32;
pub const D3D11_MAX_POSITION_VALUE: FLOAT = 3.402823466E+34;
pub const D3D11_MAX_TEXTURE_DIMENSION_2_TO_EXP: DWORD = 17;
pub const D3D11_MINOR_VERSION: DWORD = 0;
pub const D3D11_MIN_BORDER_COLOR_COMPONENT: FLOAT = 0.0;
pub const D3D11_MIN_DEPTH: FLOAT = 0.0;
pub const D3D11_MIN_MAXANISOTROPY: DWORD = 0;
pub const D3D11_MIP_LOD_BIAS_MAX: FLOAT = 15.99;
pub const D3D11_MIP_LOD_BIAS_MIN: FLOAT = -16.0;
pub const D3D11_MIP_LOD_FRACTIONAL_BIT_COUNT: DWORD = 8;
pub const D3D11_MIP_LOD_RANGE_BIT_COUNT: DWORD = 8;
pub const D3D11_MULTISAMPLE_ANTIALIAS_LINE_WIDTH: FLOAT = 1.4;
pub const D3D11_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT: DWORD = 0;
pub const D3D11_PIXEL_ADDRESS_RANGE_BIT_COUNT: DWORD = 15;
pub const D3D11_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT: DWORD = 16;
pub const D3D11_PS_CS_UAV_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_PS_CS_UAV_REGISTER_COUNT: DWORD = 8;
pub const D3D11_PS_CS_UAV_REGISTER_READS_PER_INST: DWORD = 1;
pub const D3D11_PS_CS_UAV_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_PS_FRONTFACING_DEFAULT_VALUE: DWORD = 0xffffffff;
pub const D3D11_PS_FRONTFACING_FALSE_VALUE: DWORD = 0;
pub const D3D11_PS_FRONTFACING_TRUE_VALUE: DWORD = 0xffffffff;
pub const D3D11_PS_INPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_PS_INPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_PS_INPUT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_PS_INPUT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT: FLOAT = 0.0;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COUNT: DWORD = 1;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENTS: DWORD = 1;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COUNT: DWORD = 1;
pub const D3D11_PS_OUTPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_PS_OUTPUT_REGISTER_COUNT: DWORD = 8;
pub const D3D11_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT: FLOAT = 0.5;
pub const D3D11_RAW_UAV_SRV_BYTE_ALIGNMENT: DWORD = 16;
pub const D3D11_REQ_BLEND_OBJECT_COUNT_PER_DEVICE: DWORD = 4096;
pub const D3D11_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP: DWORD = 27;
pub const D3D11_REQ_CONSTANT_BUFFER_ELEMENT_COUNT: DWORD = 4096;
pub const D3D11_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE: DWORD = 4096;
pub const D3D11_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: DWORD = 32;
pub const D3D11_REQ_DRAW_VERTEX_COUNT_2_TO_EXP: DWORD = 32;
pub const D3D11_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION: DWORD = 16384;
pub const D3D11_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT: DWORD = 1024;
pub const D3D11_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT: DWORD = 4096;
pub const D3D11_REQ_MAXANISOTROPY: DWORD = 16;
pub const D3D11_REQ_MIP_LEVELS: DWORD = 15;
pub const D3D11_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES: DWORD = 2048;
pub const D3D11_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE: DWORD = 4096;
pub const D3D11_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH: DWORD = 16384;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM: DWORD = 128;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM: FLOAT = 0.25;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM: DWORD = 2048;
pub const D3D11_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP: DWORD = 20;
pub const D3D11_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE: DWORD = 4096;
pub const D3D11_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION: DWORD = 2048;
pub const D3D11_REQ_TEXTURE1D_U_DIMENSION: DWORD = 16384;
pub const D3D11_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION: DWORD = 2048;
pub const D3D11_REQ_TEXTURE2D_U_OR_V_DIMENSION: DWORD = 16384;
pub const D3D11_REQ_TEXTURE3D_U_V_OR_W_DIMENSION: DWORD = 2048;
pub const D3D11_REQ_TEXTURECUBE_DIMENSION: DWORD = 16384;
pub const D3D11_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL: DWORD = 0;
pub const D3D11_SHADER_MAJOR_VERSION: DWORD = 5;
pub const D3D11_SHADER_MAX_INSTANCES: DWORD = 65535;
pub const D3D11_SHADER_MAX_INTERFACES: DWORD = 253;
pub const D3D11_SHADER_MAX_INTERFACE_CALL_SITES: DWORD = 4096;
pub const D3D11_SHADER_MAX_TYPES: DWORD = 65535;
pub const D3D11_SHADER_MINOR_VERSION: DWORD = 0;
pub const D3D11_SHIFT_INSTRUCTION_PAD_VALUE: DWORD = 0;
pub const D3D11_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT: DWORD = 5;
pub const D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT: DWORD = 8;
pub const D3D11_SO_BUFFER_MAX_STRIDE_IN_BYTES: DWORD = 2048;
pub const D3D11_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES: DWORD = 512;
pub const D3D11_SO_BUFFER_SLOT_COUNT: DWORD = 4;
pub const D3D11_SO_DDI_REGISTER_INDEX_DENOTING_GAP: DWORD = 0xffffffff;
pub const D3D11_SO_NO_RASTERIZED_STREAM: DWORD = 0xffffffff;
pub const D3D11_SO_OUTPUT_COMPONENT_COUNT: DWORD = 128;
pub const D3D11_SO_STREAM_COUNT: DWORD = 4;
pub const D3D11_SPEC_DATE_DAY: DWORD = 16;
pub const D3D11_SPEC_DATE_MONTH: DWORD = 0o5;
pub const D3D11_SPEC_DATE_YEAR: DWORD = 2011;
pub const D3D11_SPEC_VERSION: FLOAT = 1.07;
pub const D3D11_SRGB_GAMMA: FLOAT = 2.2;
pub const D3D11_SRGB_TO_FLOAT_DENOMINATOR_1: FLOAT = 12.92;
pub const D3D11_SRGB_TO_FLOAT_DENOMINATOR_2: FLOAT = 1.055;
pub const D3D11_SRGB_TO_FLOAT_EXPONENT: FLOAT = 2.4;
pub const D3D11_SRGB_TO_FLOAT_OFFSET: FLOAT = 0.055;
pub const D3D11_SRGB_TO_FLOAT_THRESHOLD: FLOAT = 0.04045;
pub const D3D11_SRGB_TO_FLOAT_TOLERANCE_IN_ULP: FLOAT = 0.5;
pub const D3D11_STANDARD_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_STANDARD_COMPONENT_BIT_COUNT_DOUBLED: DWORD = 64;
pub const D3D11_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE: DWORD = 4;
pub const D3D11_STANDARD_PIXEL_COMPONENT_COUNT: DWORD = 128;
pub const D3D11_STANDARD_PIXEL_ELEMENT_COUNT: DWORD = 32;
pub const D3D11_STANDARD_VECTOR_SIZE: DWORD = 4;
pub const D3D11_STANDARD_VERTEX_ELEMENT_COUNT: DWORD = 32;
pub const D3D11_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT: DWORD = 64;
pub const D3D11_SUBPIXEL_FRACTIONAL_BIT_COUNT: DWORD = 8;
pub const D3D11_SUBTEXEL_FRACTIONAL_BIT_COUNT: DWORD = 8;
pub const D3D11_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR: DWORD = 64;
pub const D3D11_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR: DWORD = 64;
pub const D3D11_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR: DWORD = 63;
pub const D3D11_TESSELLATOR_MAX_TESSELLATION_FACTOR: DWORD = 64;
pub const D3D11_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR: DWORD = 2;
pub const D3D11_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR: DWORD = 1;
pub const D3D11_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR: DWORD = 1;
pub const D3D11_TEXEL_ADDRESS_RANGE_BIT_COUNT: DWORD = 16;
pub const D3D11_UNBOUND_MEMORY_ACCESS_RESULT: DWORD = 0;
pub const D3D11_VIEWPORT_AND_SCISSORRECT_MAX_INDEX: DWORD = 15;
pub const D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE: DWORD = 16;
pub const D3D11_VIEWPORT_BOUNDS_MAX: DWORD = 32767;
pub const D3D11_VIEWPORT_BOUNDS_MIN: c_long = -32768;
pub const D3D11_VS_INPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_VS_INPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_VS_INPUT_REGISTER_READS_PER_INST: DWORD = 2;
pub const D3D11_VS_INPUT_REGISTER_READ_PORTS: DWORD = 1;
pub const D3D11_VS_OUTPUT_REGISTER_COMPONENTS: DWORD = 4;
pub const D3D11_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: DWORD = 32;
pub const D3D11_VS_OUTPUT_REGISTER_COUNT: DWORD = 32;
pub const D3D11_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT: DWORD = 10;
pub const D3D11_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: DWORD = 25;
pub const D3D11_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP: DWORD = 25;
pub const D3D11_1_UAV_SLOT_COUNT: DWORD = 64;
pub const D3D11_2_TILED_RESOURCE_TILE_SIZE_IN_BYTES: DWORD = 65536;
ENUM!{enum D3D11_INPUT_CLASSIFICATION {
    D3D11_INPUT_PER_VERTEX_DATA = 0,
    D3D11_INPUT_PER_INSTANCE_DATA = 1,
}}
pub const D3D11_APPEND_ALIGNED_ELEMENT: DWORD = 0xffffffff;
STRUCT!{struct D3D11_INPUT_ELEMENT_DESC {
    SemanticName: LPCSTR,
    SemanticIndex: UINT,
    Format: DXGI_FORMAT,
    InputSlot: UINT,
    AlignedByteOffset: UINT,
    InputSlotClass: D3D11_INPUT_CLASSIFICATION,
    InstanceDataStepRate: UINT,
}}
ENUM!{enum D3D11_FILL_MODE {
    D3D11_FILL_WIREFRAME = 2,
    D3D11_FILL_SOLID = 3,
}}
pub type D3D11_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY;
pub type D3D11_PRIMITIVE = D3D_PRIMITIVE;
ENUM!{enum D3D11_CULL_MODE {
    D3D11_CULL_NONE = 1,
    D3D11_CULL_FRONT = 2,
    D3D11_CULL_BACK = 3,
}}
STRUCT!{struct D3D11_SO_DECLARATION_ENTRY {
    Stream: UINT,
    SemanticName: LPCSTR,
    SemanticIndex: UINT,
    StartComponent: BYTE,
    ComponentCount: BYTE,
    OutputSlot: BYTE,
}}
STRUCT!{struct D3D11_VIEWPORT {
    TopLeftX: FLOAT,
    TopLeftY: FLOAT,
    Width: FLOAT,
    Height: FLOAT,
    MinDepth: FLOAT,
    MaxDepth: FLOAT,
}}
STRUCT!{struct D3D11_DRAW_INSTANCED_INDIRECT_ARGS {
    VertexCountPerInstance: UINT,
    InstanceCount: UINT,
    StartVertexLocation: UINT,
    StartInstanceLocation: UINT,
}}
STRUCT!{struct D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {
    IndexCountPerInstance: UINT,
    InstanceCount: UINT,
    StartIndexLocation: UINT,
    BaseVertexLocation: INT,
    StartInstanceLocation: UINT,
}}
ENUM!{enum D3D11_RESOURCE_DIMENSION {
    D3D11_RESOURCE_DIMENSION_UNKNOWN = 0,
    D3D11_RESOURCE_DIMENSION_BUFFER = 1,
    D3D11_RESOURCE_DIMENSION_TEXTURE1D = 2,
    D3D11_RESOURCE_DIMENSION_TEXTURE2D = 3,
    D3D11_RESOURCE_DIMENSION_TEXTURE3D = 4,
}}
pub type D3D11_SRV_DIMENSION = D3D_SRV_DIMENSION;
ENUM!{enum D3D11_DSV_DIMENSION {
    D3D11_DSV_DIMENSION_UNKNOWN = 0,
    D3D11_DSV_DIMENSION_TEXTURE1D = 1,
    D3D11_DSV_DIMENSION_TEXTURE1DARRAY = 2,
    D3D11_DSV_DIMENSION_TEXTURE2D = 3,
    D3D11_DSV_DIMENSION_TEXTURE2DARRAY = 4,
    D3D11_DSV_DIMENSION_TEXTURE2DMS = 5,
    D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY = 6,
}}
ENUM!{enum D3D11_RTV_DIMENSION {
    D3D11_RTV_DIMENSION_UNKNOWN = 0,
    D3D11_RTV_DIMENSION_BUFFER = 1,
    D3D11_RTV_DIMENSION_TEXTURE1D = 2,
    D3D11_RTV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D11_RTV_DIMENSION_TEXTURE2D = 4,
    D3D11_RTV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D11_RTV_DIMENSION_TEXTURE2DMS = 6,
    D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D11_RTV_DIMENSION_TEXTURE3D = 8,
}}
ENUM!{enum D3D11_UAV_DIMENSION {
    D3D11_UAV_DIMENSION_UNKNOWN = 0,
    D3D11_UAV_DIMENSION_BUFFER = 1,
    D3D11_UAV_DIMENSION_TEXTURE1D = 2,
    D3D11_UAV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D11_UAV_DIMENSION_TEXTURE2D = 4,
    D3D11_UAV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D11_UAV_DIMENSION_TEXTURE3D = 8,
}}
ENUM!{enum D3D11_USAGE {
    D3D11_USAGE_DEFAULT = 0,
    D3D11_USAGE_IMMUTABLE = 1,
    D3D11_USAGE_DYNAMIC = 2,
    D3D11_USAGE_STAGING = 3,
}}
ENUM!{enum D3D11_BIND_FLAG {
    D3D11_BIND_VERTEX_BUFFER = 0x1,
    D3D11_BIND_INDEX_BUFFER = 0x2,
    D3D11_BIND_CONSTANT_BUFFER = 0x4,
    D3D11_BIND_SHADER_RESOURCE = 0x8,
    D3D11_BIND_STREAM_OUTPUT = 0x10,
    D3D11_BIND_RENDER_TARGET = 0x20,
    D3D11_BIND_DEPTH_STENCIL = 0x40,
    D3D11_BIND_UNORDERED_ACCESS = 0x80,
    D3D11_BIND_DECODER = 0x200,
    D3D11_BIND_VIDEO_ENCODER = 0x400,
}}
ENUM!{enum D3D11_CPU_ACCESS_FLAG {
    D3D11_CPU_ACCESS_WRITE = 0x10000,
    D3D11_CPU_ACCESS_READ = 0x20000,
}}
ENUM!{enum D3D11_RESOURCE_MISC_FLAG {
    D3D11_RESOURCE_MISC_GENERATE_MIPS = 0x1,
    D3D11_RESOURCE_MISC_SHARED = 0x2,
    D3D11_RESOURCE_MISC_TEXTURECUBE = 0x4,
    D3D11_RESOURCE_MISC_DRAWINDIRECT_ARGS = 0x10,
    D3D11_RESOURCE_MISC_BUFFER_ALLOW_RAW_VIEWS = 0x20,
    D3D11_RESOURCE_MISC_BUFFER_STRUCTURED = 0x40,
    D3D11_RESOURCE_MISC_RESOURCE_CLAMP = 0x80,
    D3D11_RESOURCE_MISC_SHARED_KEYEDMUTEX = 0x100,
    D3D11_RESOURCE_MISC_GDI_COMPATIBLE = 0x200,
    D3D11_RESOURCE_MISC_SHARED_NTHANDLE = 0x800,
    D3D11_RESOURCE_MISC_RESTRICTED_CONTENT = 0x1000,
    D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE = 0x2000,
    D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE_DRIVER = 0x4000,
    D3D11_RESOURCE_MISC_GUARDED = 0x8000,
    D3D11_RESOURCE_MISC_TILE_POOL = 0x20000,
    D3D11_RESOURCE_MISC_TILED = 0x40000,
    D3D11_RESOURCE_MISC_HW_PROTECTED = 0x80000,
}}
ENUM!{enum D3D11_MAP {
    D3D11_MAP_READ = 1,
    D3D11_MAP_WRITE = 2,
    D3D11_MAP_READ_WRITE = 3,
    D3D11_MAP_WRITE_DISCARD = 4,
    D3D11_MAP_WRITE_NO_OVERWRITE = 5,
}}
ENUM!{enum D3D11_MAP_FLAG {
    D3D11_MAP_FLAG_DO_NOT_WAIT = 0x100000,
}}
ENUM!{enum D3D11_RAISE_FLAG {
    D3D11_RAISE_FLAG_DRIVER_INTERNAL_ERROR = 0x1,
}}
ENUM!{enum D3D11_CLEAR_FLAG {
    D3D11_CLEAR_DEPTH = 0x1,
    D3D11_CLEAR_STENCIL = 0x2,
}}
pub type D3D11_RECT = RECT;
STRUCT!{struct D3D11_BOX {
    left: UINT,
    top: UINT,
    front: UINT,
    right: UINT,
    bottom: UINT,
    back: UINT,
}}
RIDL!{#[uuid(0x1841e5c8, 0x16b0, 0x489b, 0xbc, 0xc8, 0x44, 0xcf, 0xb0, 0xd5, 0xde, 0xae)]
interface ID3D11DeviceChild(ID3D11DeviceChildVtbl): IUnknown(IUnknownVtbl) {
    fn GetDevice(
        ppDevice: *mut *mut ID3D11Device,
    ) -> (),
    fn GetPrivateData(
        guid: REFGUID,
        pDataSize: *mut UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn SetPrivateData(
        guid: REFGUID,
        DataSize: UINT,
        pData: *const c_void,
    ) -> HRESULT,
    fn SetPrivateDataInterface(
        guid: REFGUID,
        pData: *const IUnknown,
    ) -> HRESULT,
}}
ENUM!{enum D3D11_COMPARISON_FUNC {
    D3D11_COMPARISON_NEVER = 1,
    D3D11_COMPARISON_LESS = 2,
    D3D11_COMPARISON_EQUAL = 3,
    D3D11_COMPARISON_LESS_EQUAL = 4,
    D3D11_COMPARISON_GREATER = 5,
    D3D11_COMPARISON_NOT_EQUAL = 6,
    D3D11_COMPARISON_GREATER_EQUAL = 7,
    D3D11_COMPARISON_ALWAYS = 8,
}}
ENUM!{enum D3D11_DEPTH_WRITE_MASK {
    D3D11_DEPTH_WRITE_MASK_ZERO = 0,
    D3D11_DEPTH_WRITE_MASK_ALL = 1,
}}
ENUM!{enum D3D11_STENCIL_OP {
    D3D11_STENCIL_OP_KEEP = 1,
    D3D11_STENCIL_OP_ZERO = 2,
    D3D11_STENCIL_OP_REPLACE = 3,
    D3D11_STENCIL_OP_INCR_SAT = 4,
    D3D11_STENCIL_OP_DECR_SAT = 5,
    D3D11_STENCIL_OP_INVERT = 6,
    D3D11_STENCIL_OP_INCR = 7,
    D3D11_STENCIL_OP_DECR = 8,
}}
STRUCT!{struct D3D11_DEPTH_STENCILOP_DESC {
    StencilFailOp: D3D11_STENCIL_OP,
    StencilDepthFailOp: D3D11_STENCIL_OP,
    StencilPassOp: D3D11_STENCIL_OP,
    StencilFunc: D3D11_COMPARISON_FUNC,
}}
STRUCT!{struct D3D11_DEPTH_STENCIL_DESC {
    DepthEnable: BOOL,
    DepthWriteMask: D3D11_DEPTH_WRITE_MASK,
    DepthFunc: D3D11_COMPARISON_FUNC,
    StencilEnable: BOOL,
    StencilReadMask: UINT8,
    StencilWriteMask: UINT8,
    FrontFace: D3D11_DEPTH_STENCILOP_DESC,
    BackFace: D3D11_DEPTH_STENCILOP_DESC,
}}
RIDL!{#[uuid(0x03823efb, 0x8d8f, 0x4e1c, 0x9a, 0xa2, 0xf6, 0x4b, 0xb2, 0xcb, 0xfd, 0xf1)]
interface ID3D11DepthStencilState(ID3D11DepthStencilStateVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_DEPTH_STENCIL_DESC,
    ) -> (),
}}
ENUM!{enum D3D11_BLEND {
    D3D11_BLEND_ZERO = 1,
    D3D11_BLEND_ONE = 2,
    D3D11_BLEND_SRC_COLOR = 3,
    D3D11_BLEND_INV_SRC_COLOR = 4,
    D3D11_BLEND_SRC_ALPHA = 5,
    D3D11_BLEND_INV_SRC_ALPHA = 6,
    D3D11_BLEND_DEST_ALPHA = 7,
    D3D11_BLEND_INV_DEST_ALPHA = 8,
    D3D11_BLEND_DEST_COLOR = 9,
    D3D11_BLEND_INV_DEST_COLOR = 10,
    D3D11_BLEND_SRC_ALPHA_SAT = 11,
    D3D11_BLEND_BLEND_FACTOR = 14,
    D3D11_BLEND_INV_BLEND_FACTOR = 15,
    D3D11_BLEND_SRC1_COLOR = 16,
    D3D11_BLEND_INV_SRC1_COLOR = 17,
    D3D11_BLEND_SRC1_ALPHA = 18,
    D3D11_BLEND_INV_SRC1_ALPHA = 19,
}}
ENUM!{enum D3D11_BLEND_OP {
    D3D11_BLEND_OP_ADD = 1,
    D3D11_BLEND_OP_SUBTRACT = 2,
    D3D11_BLEND_OP_REV_SUBTRACT = 3,
    D3D11_BLEND_OP_MIN = 4,
    D3D11_BLEND_OP_MAX = 5,
}}
ENUM!{enum D3D11_COLOR_WRITE_ENABLE {
    D3D11_COLOR_WRITE_ENABLE_RED = 1,
    D3D11_COLOR_WRITE_ENABLE_GREEN = 2,
    D3D11_COLOR_WRITE_ENABLE_BLUE = 4,
    D3D11_COLOR_WRITE_ENABLE_ALPHA = 8,
    D3D11_COLOR_WRITE_ENABLE_ALL = D3D11_COLOR_WRITE_ENABLE_RED | D3D11_COLOR_WRITE_ENABLE_GREEN
        | D3D11_COLOR_WRITE_ENABLE_BLUE | D3D11_COLOR_WRITE_ENABLE_ALPHA,
}}
STRUCT!{struct D3D11_RENDER_TARGET_BLEND_DESC {
    BlendEnable: BOOL,
    SrcBlend: D3D11_BLEND,
    DestBlend: D3D11_BLEND,
    BlendOp: D3D11_BLEND_OP,
    SrcBlendAlpha: D3D11_BLEND,
    DestBlendAlpha: D3D11_BLEND,
    BlendOpAlpha: D3D11_BLEND_OP,
    RenderTargetWriteMask: UINT8,
}}
STRUCT!{struct D3D11_BLEND_DESC {
    AlphaToCoverageEnable: BOOL,
    IndependentBlendEnable: BOOL,
    RenderTarget: [D3D11_RENDER_TARGET_BLEND_DESC; 8],
}}
RIDL!{#[uuid(0x75b68faa, 0x347d, 0x4159, 0x8f, 0x45, 0xa0, 0x64, 0x0f, 0x01, 0xcd, 0x9a)]
interface ID3D11BlendState(ID3D11BlendStateVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_BLEND_DESC,
    ) -> (),
}}
STRUCT!{struct D3D11_RASTERIZER_DESC {
    FillMode: D3D11_FILL_MODE,
    CullMode: D3D11_CULL_MODE,
    FrontCounterClockwise: BOOL,
    DepthBias: INT,
    DepthBiasClamp: FLOAT,
    SlopeScaledDepthBias: FLOAT,
    DepthClipEnable: BOOL,
    ScissorEnable: BOOL,
    MultisampleEnable: BOOL,
    AntialiasedLineEnable: BOOL,
}}
RIDL!{#[uuid(0x9bb4ab81, 0xab1a, 0x4d8f, 0xb5, 0x06, 0xfc, 0x04, 0x20, 0x0b, 0x6e, 0xe7)]
interface ID3D11RasterizerState(ID3D11RasterizerStateVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_RASTERIZER_DESC,
    ) -> (),
}}
STRUCT!{struct D3D11_SUBRESOURCE_DATA {
    pSysMem: *const c_void,
    SysMemPitch: UINT,
    SysMemSlicePitch: UINT,
}}
STRUCT!{struct D3D11_MAPPED_SUBRESOURCE {
    pData: *mut c_void,
    RowPitch: UINT,
    DepthPitch: UINT,
}}
RIDL!{#[uuid(0xdc8e63f3, 0xd12b, 0x4952, 0xb4, 0x7b, 0x5e, 0x45, 0x02, 0x6a, 0x86, 0x2d)]
interface ID3D11Resource(ID3D11ResourceVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetType(
        pResourceDimension: *mut D3D11_RESOURCE_DIMENSION,
    ) -> (),
    fn SetEvictionPriority(
        EvictionPriority: UINT,
    ) -> (),
    fn GetEvictionPriority() -> UINT,
}}
STRUCT!{struct D3D11_BUFFER_DESC {
    ByteWidth: UINT,
    Usage: D3D11_USAGE,
    BindFlags: UINT,
    CPUAccessFlags: UINT,
    MiscFlags: UINT,
    StructureByteStride: UINT,
}}
RIDL!{#[uuid(0x48570b85, 0xd1ee, 0x4fcd, 0xa2, 0x50, 0xeb, 0x35, 0x07, 0x22, 0xb0, 0x37)]
interface ID3D11Buffer(ID3D11BufferVtbl): ID3D11Resource(ID3D11ResourceVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_BUFFER_DESC,
    ) -> (),
}}
STRUCT!{struct D3D11_TEXTURE1D_DESC {
    Width: UINT,
    MipLevels: UINT,
    ArraySize: UINT,
    Format: DXGI_FORMAT,
    Usage: D3D11_USAGE,
    BindFlags: UINT,
    CPUAccessFlags: UINT,
    MiscFlags: UINT,
}}
RIDL!{#[uuid(0xf8fb5c27, 0xc6b3, 0x4f75, 0xa4, 0xc8, 0x43, 0x9a, 0xf2, 0xef, 0x56, 0x4c)]
interface ID3D11Texture1D(ID3D11Texture1DVtbl): ID3D11Resource(ID3D11ResourceVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_TEXTURE1D_DESC,
    ) -> (),
}}
STRUCT!{struct D3D11_TEXTURE2D_DESC {
    Width: UINT,
    Height: UINT,
    MipLevels: UINT,
    ArraySize: UINT,
    Format: DXGI_FORMAT,
    SampleDesc: DXGI_SAMPLE_DESC,
    Usage: D3D11_USAGE,
    BindFlags: UINT,
    CPUAccessFlags: UINT,
    MiscFlags: UINT,
}}
RIDL!{#[uuid(0x6f15aaf2, 0xd208, 0x4e89, 0x9a, 0xb4, 0x48, 0x95, 0x35, 0xd3, 0x4f, 0x9c)]
interface ID3D11Texture2D(ID3D11Texture2DVtbl): ID3D11Resource(ID3D11ResourceVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_TEXTURE2D_DESC,
    ) -> (),
}}
STRUCT!{struct D3D11_TEXTURE3D_DESC {
    Width: UINT,
    Height: UINT,
    Depth: UINT,
    MipLevels: UINT,
    Format: DXGI_FORMAT,
    Usage: D3D11_USAGE,
    BindFlags: UINT,
    CPUAccessFlags: UINT,
    MiscFlags: UINT,
}}
RIDL!{#[uuid(0x037e866e, 0xf56d, 0x4357, 0xa8, 0xaf, 0x9d, 0xab, 0xbe, 0x6e, 0x25, 0x0e)]
interface ID3D11Texture3D(ID3D11Texture3DVtbl): ID3D11Resource(ID3D11ResourceVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_TEXTURE3D_DESC,
    ) -> (),
}}
ENUM!{enum D3D11_TEXTURECUBE_FACE {
    D3D11_TEXTURECUBE_FACE_POSITIVE_X = 0,
    D3D11_TEXTURECUBE_FACE_NEGATIVE_X = 1,
    D3D11_TEXTURECUBE_FACE_POSITIVE_Y = 2,
    D3D11_TEXTURECUBE_FACE_NEGATIVE_Y = 3,
    D3D11_TEXTURECUBE_FACE_POSITIVE_Z = 4,
    D3D11_TEXTURECUBE_FACE_NEGATIVE_Z = 5,
}}
RIDL!{#[uuid(0x839d1216, 0xbb2e, 0x412b, 0xb7, 0xf4, 0xa9, 0xdb, 0xeb, 0xe0, 0x8e, 0xd1)]
interface ID3D11View(ID3D11ViewVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetResource(
        ppResource: *mut *mut ID3D11Resource,
    ) -> (),
}}
UNION!{union D3D11_BUFFER_SRV_u1 {
    [u32; 1],
    FirstElement FirstElement_mut: UINT,
    ElementOffset ElementOffset_mut: UINT,
}}
UNION!{union D3D11_BUFFER_SRV_u2 {
    [u32; 1],
    NumElements NumElements_mut: UINT,
    ElementWidth ElementWidth_mut: UINT,
}}
STRUCT!{struct D3D11_BUFFER_SRV {
    u1: D3D11_BUFFER_SRV_u1,
    u2: D3D11_BUFFER_SRV_u2,
}}
ENUM!{enum D3D11_BUFFEREX_SRV_FLAG {
    D3D11_BUFFEREX_SRV_FLAG_RAW = 0x1,
}}
STRUCT!{struct D3D11_BUFFEREX_SRV {
    FirstElement: UINT,
    NumElements: UINT,
    Flags: UINT,
}}
STRUCT!{struct D3D11_TEX1D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
}}
STRUCT!{struct D3D11_TEX1D_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX3D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
}}
STRUCT!{struct D3D11_TEXCUBE_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
}}
STRUCT!{struct D3D11_TEXCUBE_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    First2DArrayFace: UINT,
    NumCubes: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_SRV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_ARRAY_SRV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
UNION!{union D3D11_SHADER_RESOURCE_VIEW_DESC_u {
    [u32; 4],
    Buffer Buffer_mut: D3D11_BUFFER_SRV,
    Texture1D Texture1D_mut: D3D11_TEX1D_SRV,
    Texture1DArray Texture1DArray_mut: D3D11_TEX1D_ARRAY_SRV,
    Texture2D Texture2D_mut: D3D11_TEX2D_SRV,
    Texture2DArray Texture2DArray_mut: D3D11_TEX2D_ARRAY_SRV,
    Texture2DMS Texture2DMS_mut: D3D11_TEX2DMS_SRV,
    Texture2DMSArray Texture2DMSArray_mut: D3D11_TEX2DMS_ARRAY_SRV,
    Texture3D Texture3D_mut: D3D11_TEX3D_SRV,
    TextureCube TextureCube_mut: D3D11_TEXCUBE_SRV,
    TextureCubeArray TextureCubeArray_mut: D3D11_TEXCUBE_ARRAY_SRV,
    BufferEx BufferEx_mut: D3D11_BUFFEREX_SRV,
}}
STRUCT!{struct D3D11_SHADER_RESOURCE_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D11_SRV_DIMENSION,
    u: D3D11_SHADER_RESOURCE_VIEW_DESC_u,
}}
RIDL!{#[uuid(0xb0e06fe0, 0x8192, 0x4e1a, 0xb1, 0xca, 0x36, 0xd7, 0x41, 0x47, 0x10, 0xb2)]
interface ID3D11ShaderResourceView(ID3D11ShaderResourceViewVtbl): ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_SHADER_RESOURCE_VIEW_DESC,
    ) -> (),
}}
UNION!{union D3D11_BUFFER_RTV_u1 {
    [u32; 1],
    FirstElement FirstElement_mut: UINT,
    ElementOffset ElementOffset_mut: UINT,
}}
UNION!{union D3D11_BUFFER_RTV_u2 {
    [u32; 1],
    NumElements NumElements_mut: UINT,
    ElementWidth ElementWidth_mut: UINT,
}}
STRUCT!{struct D3D11_BUFFER_RTV {
    u1: D3D11_BUFFER_RTV_u1,
    u2: D3D11_BUFFER_RTV_u2,
}}
STRUCT!{struct D3D11_TEX1D_RTV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX1D_ARRAY_RTV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2D_RTV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_RTV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_RTV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_ARRAY_RTV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX3D_RTV {
    MipSlice: UINT,
    FirstWSlice: UINT,
    WSize: UINT,
}}
UNION!{union D3D11_RENDER_TARGET_VIEW_DESC_u {
    [u32; 3],
    Buffer Buffer_mut: D3D11_BUFFER_RTV,
    Texture1D Texture1D_mut: D3D11_TEX1D_RTV,
    Texture1DArray Texture1DArray_mut: D3D11_TEX1D_ARRAY_RTV,
    Texture2D Texture2D_mut: D3D11_TEX2D_RTV,
    Texture2DArray Texture2DArray_mut: D3D11_TEX2D_ARRAY_RTV,
    Texture2DMS Texture2DMS_mut: D3D11_TEX2DMS_RTV,
    Texture2DMSArray Texture2DMSArray_mut: D3D11_TEX2DMS_ARRAY_RTV,
    Texture3D Texture3D_mut: D3D11_TEX3D_RTV,
}}
STRUCT!{struct D3D11_RENDER_TARGET_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D11_RTV_DIMENSION,
    u: D3D11_RENDER_TARGET_VIEW_DESC_u,
}}
RIDL!{#[uuid(0xdfdba067, 0x0b8d, 0x4865, 0x87, 0x5b, 0xd7, 0xb4, 0x51, 0x6c, 0xc1, 0x64)]
interface ID3D11RenderTargetView(ID3D11RenderTargetViewVtbl): ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_RENDER_TARGET_VIEW_DESC,
    ) -> (),
}}
STRUCT!{struct D3D11_TEX1D_DSV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX1D_ARRAY_DSV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2D_DSV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_DSV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_DSV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D11_TEX2DMS_ARRAY_DSV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
ENUM!{enum D3D11_DSV_FLAG {
    D3D11_DSV_READ_ONLY_DEPTH = 0x1,
    D3D11_DSV_READ_ONLY_STENCIL = 0x2,
}}
UNION!{union D3D11_DEPTH_STENCIL_VIEW_DESC_u {
    [u32; 3],
    Texture1D Texture1D_mut: D3D11_TEX1D_DSV,
    Texture1DArray Texture1DArray_mut: D3D11_TEX1D_ARRAY_DSV,
    Texture2D Texture2D_mut: D3D11_TEX2D_DSV,
    Texture2DArray Texture2DArray_mut: D3D11_TEX2D_ARRAY_DSV,
    Texture2DMS Texture2DMS_mut: D3D11_TEX2DMS_DSV,
    Texture2DMSArray Texture2DMSArray_mut: D3D11_TEX2DMS_ARRAY_DSV,
}}
STRUCT!{struct D3D11_DEPTH_STENCIL_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D11_DSV_DIMENSION,
    Flags: UINT,
    u: D3D11_DEPTH_STENCIL_VIEW_DESC_u,
}}
RIDL!{#[uuid(0x9fdac92a, 0x1876, 0x48c3, 0xaf, 0xad, 0x25, 0xb9, 0x4f, 0x84, 0xa9, 0xb6)]
interface ID3D11DepthStencilView(ID3D11DepthStencilViewVtbl): ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_DEPTH_STENCIL_VIEW_DESC,
    ) -> (),
}}
ENUM!{enum D3D11_BUFFER_UAV_FLAG {
    D3D11_BUFFER_UAV_FLAG_RAW = 0x1,
    D3D11_BUFFER_UAV_FLAG_APPEND = 0x2,
    D3D11_BUFFER_UAV_FLAG_COUNTER = 0x4,
}}
STRUCT!{struct D3D11_BUFFER_UAV {
    FirstElement: UINT,
    NumElements: UINT,
    Flags: UINT,
}}
STRUCT!{struct D3D11_TEX1D_UAV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX1D_ARRAY_UAV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX2D_UAV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_UAV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D11_TEX3D_UAV {
    MipSlice: UINT,
    FirstWSlice: UINT,
    WSize: UINT,
}}
UNION!{union D3D11_UNORDERED_ACCESS_VIEW_DESC_u {
    [u32; 3],
    Buffer Buffer_mut: D3D11_BUFFER_UAV,
    Texture1D Texture1D_mut: D3D11_TEX1D_UAV,
    Texture1DArray Texture1DArray_mut: D3D11_TEX1D_ARRAY_UAV,
    Texture2D Texture2D_mut: D3D11_TEX2D_UAV,
    Texture2DArray Texture2DArray_mut: D3D11_TEX2D_ARRAY_UAV,
    Texture3D Texture3D_mut: D3D11_TEX3D_UAV,
}}
STRUCT!{struct D3D11_UNORDERED_ACCESS_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D11_UAV_DIMENSION,
    u: D3D11_UNORDERED_ACCESS_VIEW_DESC_u,
}}
RIDL!{#[uuid(0x28acf509, 0x7f5c, 0x48f6, 0x86, 0x11, 0xf3, 0x16, 0x01, 0x0a, 0x63, 0x80)]
interface ID3D11UnorderedAccessView(ID3D11UnorderedAccessViewVtbl): ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_UNORDERED_ACCESS_VIEW_DESC,
    ) -> (),
}}
RIDL!{#[uuid(0x3b301d64, 0xd678, 0x4289, 0x88, 0x97, 0x22, 0xf8, 0x92, 0x8b, 0x72, 0xf3)]
interface ID3D11VertexShader(ID3D11VertexShaderVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{#[uuid(0x8e5c6061, 0x628a, 0x4c8e, 0x82, 0x64, 0xbb, 0xe4, 0x5c, 0xb3, 0xd5, 0xdd)]
interface ID3D11HullShader(ID3D11HullShaderVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{#[uuid(0xf582c508, 0x0f36, 0x490c, 0x99, 0x77, 0x31, 0xee, 0xce, 0x26, 0x8c, 0xfa)]
interface ID3D11DomainShader(ID3D11DomainShaderVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{#[uuid(0x38325b96, 0xeffb, 0x4022, 0xba, 0x02, 0x2e, 0x79, 0x5b, 0x70, 0x27, 0x5c)]
interface ID3D11GeometryShader(ID3D11GeometryShaderVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{#[uuid(0xea82e40d, 0x51dc, 0x4f33, 0x93, 0xd4, 0xdb, 0x7c, 0x91, 0x25, 0xae, 0x8c)]
interface ID3D11PixelShader(ID3D11PixelShaderVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{#[uuid(0x4f5b196e, 0xc2bd, 0x495e, 0xbd, 0x01, 0x1f, 0xde, 0xd3, 0x8e, 0x49, 0x69)]
interface ID3D11ComputeShader(ID3D11ComputeShaderVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
RIDL!{#[uuid(0xe4819ddc, 0x4cf0, 0x4025, 0xbd, 0x26, 0x5d, 0xe8, 0x2a, 0x3e, 0x07, 0xb7)]
interface ID3D11InputLayout(ID3D11InputLayoutVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {}}
ENUM!{enum D3D11_FILTER {
    D3D11_FILTER_MIN_MAG_MIP_POINT = 0,
    D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR = 0x1,
    D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x4,
    D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR = 0x5,
    D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT = 0x10,
    D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x11,
    D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT = 0x14,
    D3D11_FILTER_MIN_MAG_MIP_LINEAR = 0x15,
    D3D11_FILTER_ANISOTROPIC = 0x55,
    D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT = 0x80,
    D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR = 0x81,
    D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x84,
    D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR = 0x85,
    D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT = 0x90,
    D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x91,
    D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT = 0x94,
    D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR = 0x95,
    D3D11_FILTER_COMPARISON_ANISOTROPIC = 0xd5,
    D3D11_FILTER_MINIMUM_MIN_MAG_MIP_POINT = 0x100,
    D3D11_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR = 0x101,
    D3D11_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x104,
    D3D11_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR = 0x105,
    D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT = 0x110,
    D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x111,
    D3D11_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT = 0x114,
    D3D11_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR = 0x115,
    D3D11_FILTER_MINIMUM_ANISOTROPIC = 0x155,
    D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_POINT = 0x180,
    D3D11_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR = 0x181,
    D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x184,
    D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR = 0x185,
    D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT = 0x190,
    D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x191,
    D3D11_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT = 0x194,
    D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR = 0x195,
    D3D11_FILTER_MAXIMUM_ANISOTROPIC = 0x1d5,
}}
ENUM!{enum D3D11_FILTER_TYPE {
    D3D11_FILTER_TYPE_POINT = 0,
    D3D11_FILTER_TYPE_LINEAR = 1,
}}
ENUM!{enum D3D11_FILTER_REDUCTION_TYPE {
    D3D11_FILTER_REDUCTION_TYPE_STANDARD = 0,
    D3D11_FILTER_REDUCTION_TYPE_COMPARISON = 1,
    D3D11_FILTER_REDUCTION_TYPE_MINIMUM = 2,
    D3D11_FILTER_REDUCTION_TYPE_MAXIMUM = 3,
}}
pub const D3D11_FILTER_REDUCTION_TYPE_MASK: DWORD = 0x3;
pub const D3D11_FILTER_REDUCTION_TYPE_SHIFT: DWORD = 7;
pub const D3D11_FILTER_TYPE_MASK: DWORD = 0x3;
pub const D3D11_MIN_FILTER_SHIFT: DWORD = 4;
pub const D3D11_MAG_FILTER_SHIFT: DWORD = 2;
pub const D3D11_MIP_FILTER_SHIFT: DWORD = 0;
pub const D3D11_COMPARISON_FILTERING_BIT: DWORD = 0x80;
pub const D3D11_ANISOTROPIC_FILTERING_BIT: DWORD = 0x40;
ENUM!{enum D3D11_TEXTURE_ADDRESS_MODE {
    D3D11_TEXTURE_ADDRESS_WRAP = 1,
    D3D11_TEXTURE_ADDRESS_MIRROR = 2,
    D3D11_TEXTURE_ADDRESS_CLAMP = 3,
    D3D11_TEXTURE_ADDRESS_BORDER = 4,
    D3D11_TEXTURE_ADDRESS_MIRROR_ONCE = 5,
}}
STRUCT!{struct D3D11_SAMPLER_DESC {
    Filter: D3D11_FILTER,
    AddressU: D3D11_TEXTURE_ADDRESS_MODE,
    AddressV: D3D11_TEXTURE_ADDRESS_MODE,
    AddressW: D3D11_TEXTURE_ADDRESS_MODE,
    MipLODBias: FLOAT,
    MaxAnisotropy: UINT,
    ComparisonFunc: D3D11_COMPARISON_FUNC,
    BorderColor: [FLOAT; 4],
    MinLOD: FLOAT,
    MaxLOD: FLOAT,
}}
RIDL!{#[uuid(0xda6fea51, 0x564c, 0x4487, 0x98, 0x10, 0xf0, 0xd0, 0xf9, 0xb4, 0xe3, 0xa5)]
interface ID3D11SamplerState(ID3D11SamplerStateVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_SAMPLER_DESC,
    ) -> (),
}}
ENUM!{enum D3D11_FORMAT_SUPPORT {
    D3D11_FORMAT_SUPPORT_BUFFER = 0x1,
    D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER = 0x2,
    D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER = 0x4,
    D3D11_FORMAT_SUPPORT_SO_BUFFER = 0x8,
    D3D11_FORMAT_SUPPORT_TEXTURE1D = 0x10,
    D3D11_FORMAT_SUPPORT_TEXTURE2D = 0x20,
    D3D11_FORMAT_SUPPORT_TEXTURE3D = 0x40,
    D3D11_FORMAT_SUPPORT_TEXTURECUBE = 0x80,
    D3D11_FORMAT_SUPPORT_SHADER_LOAD = 0x100,
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE = 0x200,
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON = 0x400,
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT = 0x800,
    D3D11_FORMAT_SUPPORT_MIP = 0x1000,
    D3D11_FORMAT_SUPPORT_MIP_AUTOGEN = 0x2000,
    D3D11_FORMAT_SUPPORT_RENDER_TARGET = 0x4000,
    D3D11_FORMAT_SUPPORT_BLENDABLE = 0x8000,
    D3D11_FORMAT_SUPPORT_DEPTH_STENCIL = 0x10000,
    D3D11_FORMAT_SUPPORT_CPU_LOCKABLE = 0x20000,
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE = 0x40000,
    D3D11_FORMAT_SUPPORT_DISPLAY = 0x80000,
    D3D11_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT = 0x100000,
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET = 0x200000,
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_LOAD = 0x400000,
    D3D11_FORMAT_SUPPORT_SHADER_GATHER = 0x800000,
    D3D11_FORMAT_SUPPORT_BACK_BUFFER_CAST = 0x1000000,
    D3D11_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW = 0x2000000,
    D3D11_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON = 0x4000000,
    D3D11_FORMAT_SUPPORT_DECODER_OUTPUT = 0x8000000,
    D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_OUTPUT = 0x10000000,
    D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_INPUT = 0x20000000,
    D3D11_FORMAT_SUPPORT_VIDEO_ENCODER = 0x40000000,
}}
ENUM!{enum D3D11_FORMAT_SUPPORT2 {
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_ADD = 0x1,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS = 0x2,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE = 0x4,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE = 0x8,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX = 0x10,
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX = 0x20,
    D3D11_FORMAT_SUPPORT2_UAV_TYPED_LOAD = 0x40,
    D3D11_FORMAT_SUPPORT2_UAV_TYPED_STORE = 0x80,
    D3D11_FORMAT_SUPPORT2_OUTPUT_MERGER_LOGIC_OP = 0x100,
    D3D11_FORMAT_SUPPORT2_TILED = 0x200,
    D3D11_FORMAT_SUPPORT2_SHAREABLE = 0x400,
    D3D11_FORMAT_SUPPORT2_MULTIPLANE_OVERLAY = 0x4000,
}}
RIDL!{#[uuid(0x4b35d0cd, 0x1e15, 0x4258, 0x9c, 0x98, 0x1b, 0x13, 0x33, 0xf6, 0xdd, 0x3b)]
interface ID3D11Asynchronous(ID3D11AsynchronousVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDataSize() -> UINT,
}}
ENUM!{enum D3D11_ASYNC_GETDATA_FLAG {
    D3D11_ASYNC_GETDATA_DONOTFLUSH = 0x1,
}}
ENUM!{enum D3D11_QUERY {
    D3D11_QUERY_EVENT = 0,
    D3D11_QUERY_OCCLUSION = D3D11_QUERY_EVENT + 1u32,
    D3D11_QUERY_TIMESTAMP = D3D11_QUERY_OCCLUSION + 1u32,
    D3D11_QUERY_TIMESTAMP_DISJOINT = D3D11_QUERY_TIMESTAMP + 1u32,
    D3D11_QUERY_PIPELINE_STATISTICS = D3D11_QUERY_TIMESTAMP_DISJOINT + 1u32,
    D3D11_QUERY_OCCLUSION_PREDICATE = D3D11_QUERY_PIPELINE_STATISTICS + 1u32,
    D3D11_QUERY_SO_STATISTICS = D3D11_QUERY_OCCLUSION_PREDICATE + 1u32,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE = D3D11_QUERY_SO_STATISTICS + 1u32,
    D3D11_QUERY_SO_STATISTICS_STREAM0 = D3D11_QUERY_SO_OVERFLOW_PREDICATE + 1u32,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0 = D3D11_QUERY_SO_STATISTICS_STREAM0 + 1u32,
    D3D11_QUERY_SO_STATISTICS_STREAM1 = D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0 + 1u32,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1 = D3D11_QUERY_SO_STATISTICS_STREAM1 + 1u32,
    D3D11_QUERY_SO_STATISTICS_STREAM2 = D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1 + 1u32,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2 = D3D11_QUERY_SO_STATISTICS_STREAM2 + 1u32,
    D3D11_QUERY_SO_STATISTICS_STREAM3 = D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2 + 1u32,
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3 = D3D11_QUERY_SO_STATISTICS_STREAM3 + 1u32,
}}
ENUM!{enum D3D11_QUERY_MISC_FLAG {
    D3D11_QUERY_MISC_PREDICATEHINT = 0x1,
}}
STRUCT!{struct D3D11_QUERY_DESC {
    Query: D3D11_QUERY,
    MiscFlags: UINT,
}}
RIDL!{#[uuid(0xd6c00747, 0x87b7, 0x425e, 0xb8, 0x4d, 0x44, 0xd1, 0x08, 0x56, 0x0a, 0xfd)]
interface ID3D11Query(ID3D11QueryVtbl): ID3D11Asynchronous(ID3D11AsynchronousVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_QUERY_DESC,
    ) -> (),
}}
RIDL!{#[uuid(0x9eb576dd, 0x9f77, 0x4d86, 0x81, 0xaa, 0x8b, 0xab, 0x5f, 0xe4, 0x90, 0xe2)]
interface ID3D11Predicate(ID3D11PredicateVtbl): ID3D11Query(ID3D11QueryVtbl) {}}
STRUCT!{struct D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {
    Frequency: UINT64,
    Disjoint: BOOL,
}}
STRUCT!{struct D3D11_QUERY_DATA_PIPELINE_STATISTICS {
    IAVertices: UINT64,
    IAPrimitives: UINT64,
    VSInvocations: UINT64,
    GSInvocations: UINT64,
    GSPrimitives: UINT64,
    CInvocations: UINT64,
    CPrimitives: UINT64,
    PSInvocations: UINT64,
    HSInvocations: UINT64,
    DSInvocations: UINT64,
    CSInvocations: UINT64,
}}
STRUCT!{struct D3D11_QUERY_DATA_SO_STATISTICS {
    NumPrimitivesWritten: UINT64,
    PrimitivesStorageNeeded: UINT64,
}}
ENUM!{enum D3D11_COUNTER {
    D3D11_COUNTER_DEVICE_DEPENDENT_0 = 0x40000000,
}}
ENUM!{enum D3D11_COUNTER_TYPE {
    D3D11_COUNTER_TYPE_FLOAT32 = 0,
    D3D11_COUNTER_TYPE_UINT16 = D3D11_COUNTER_TYPE_FLOAT32 + 1u32,
    D3D11_COUNTER_TYPE_UINT32 = D3D11_COUNTER_TYPE_UINT16 + 1u32,
    D3D11_COUNTER_TYPE_UINT64 = D3D11_COUNTER_TYPE_UINT32 + 1u32,
}}
STRUCT!{struct D3D11_COUNTER_DESC {
    Counter: D3D11_COUNTER,
    MiscFlags: UINT,
}}
STRUCT!{struct D3D11_COUNTER_INFO {
    LastDeviceDependentCounter: D3D11_COUNTER,
    NumSimultaneousCounters: UINT,
    NumDetectableParallelUnits: UINT8,
}}
RIDL!{#[uuid(0x6e8c49fb, 0xa371, 0x4770, 0xb4, 0x40, 0x29, 0x08, 0x60, 0x22, 0xb7, 0x41)]
interface ID3D11Counter(ID3D11CounterVtbl): ID3D11Asynchronous(ID3D11AsynchronousVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_COUNTER_DESC,
    ) -> (),
}}
ENUM!{enum D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS {
    D3D11_STANDARD_MULTISAMPLE_PATTERN = 0xffffffff,
    D3D11_CENTER_MULTISAMPLE_PATTERN = 0xfffffffe,
}}
ENUM!{enum D3D11_DEVICE_CONTEXT_TYPE {
    D3D11_DEVICE_CONTEXT_IMMEDIATE = 0,
    D3D11_DEVICE_CONTEXT_DEFERRED = D3D11_DEVICE_CONTEXT_IMMEDIATE + 1u32,
}}
STRUCT!{struct D3D11_CLASS_INSTANCE_DESC {
    InstanceId: UINT,
    InstanceIndex: UINT,
    TypeId: UINT,
    ConstantBuffer: UINT,
    BaseConstantBufferOffset: UINT,
    BaseTexture: UINT,
    BaseSampler: UINT,
    Created: BOOL,
}}
RIDL!{#[uuid(0xa6cd7faa, 0xb0b7, 0x4a2f, 0x94, 0x36, 0x86, 0x62, 0xa6, 0x57, 0x97, 0xcb)]
interface ID3D11ClassInstance(ID3D11ClassInstanceVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetClassLinkage(
        ppLinkage: *mut *mut ID3D11ClassLinkage,
    ) -> (),
    fn GetDesc(
        pDesc: *mut D3D11_CLASS_INSTANCE_DESC,
    ) -> (),
    fn GetInstanceName(
        pInstanceName: LPSTR,
        pBufferLength: *mut SIZE_T,
    ) -> (),
    fn GetTypeName(
        pTypeName: LPSTR,
        pBufferLength: *mut SIZE_T,
    ) -> (),
}}
RIDL!{#[uuid(0xddf57cba, 0x9543, 0x46e4, 0xa1, 0x2b, 0xf2, 0x07, 0xa0, 0xfe, 0x7f, 0xed)]
interface ID3D11ClassLinkage(ID3D11ClassLinkageVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetClassInstance(
        GetClassInstance: LPCSTR,
        InstanceIndex: UINT,
        ppInstance: *mut *mut ID3D11ClassInstance,
    ) -> HRESULT,
    fn CreateClassInstance(
        pClassTypeName: LPCSTR,
        ConstantBufferOffset: UINT,
        ConstantVectorOffset: UINT,
        TextureOffset: UINT,
        SamplerOffset: UINT,
        ppInstance: *mut *mut ID3D11ClassInstance,
    ) -> HRESULT,
}}
RIDL!{#[uuid(0xa24bc4d1, 0x769e, 0x43f7, 0x80, 0x13, 0x98, 0xff, 0x56, 0x6c, 0x18, 0xe2)]
interface ID3D11CommandList(ID3D11CommandListVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetContextFlags() -> UINT,
}}
ENUM!{enum D3D11_FEATURE {
    D3D11_FEATURE_THREADING = 0,
    D3D11_FEATURE_DOUBLES = D3D11_FEATURE_THREADING + 1u32,
    D3D11_FEATURE_FORMAT_SUPPORT = D3D11_FEATURE_DOUBLES + 1u32,
    D3D11_FEATURE_FORMAT_SUPPORT2 = D3D11_FEATURE_FORMAT_SUPPORT + 1u32,
    D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS = D3D11_FEATURE_FORMAT_SUPPORT2 + 1u32,
    D3D11_FEATURE_D3D11_OPTIONS = D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS + 1u32,
    D3D11_FEATURE_ARCHITECTURE_INFO = D3D11_FEATURE_D3D11_OPTIONS + 1u32,
    D3D11_FEATURE_D3D9_OPTIONS = D3D11_FEATURE_ARCHITECTURE_INFO + 1u32,
    D3D11_FEATURE_SHADER_MIN_PRECISION_SUPPORT = D3D11_FEATURE_D3D9_OPTIONS + 1u32,
    D3D11_FEATURE_D3D9_SHADOW_SUPPORT = D3D11_FEATURE_SHADER_MIN_PRECISION_SUPPORT + 1u32,
    D3D11_FEATURE_D3D11_OPTIONS1 = D3D11_FEATURE_D3D9_SHADOW_SUPPORT + 1u32,
    D3D11_FEATURE_D3D9_SIMPLE_INSTANCING_SUPPORT = D3D11_FEATURE_D3D11_OPTIONS1 + 1u32,
    D3D11_FEATURE_MARKER_SUPPORT = D3D11_FEATURE_D3D9_SIMPLE_INSTANCING_SUPPORT + 1u32,
    D3D11_FEATURE_D3D9_OPTIONS1 = D3D11_FEATURE_MARKER_SUPPORT + 1u32,
    D3D11_FEATURE_D3D11_OPTIONS2 = D3D11_FEATURE_D3D9_OPTIONS1 + 1u32,
    D3D11_FEATURE_D3D11_OPTIONS3 = D3D11_FEATURE_D3D11_OPTIONS2 + 1u32,
    D3D11_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT = D3D11_FEATURE_D3D11_OPTIONS3 + 1u32,
}}
STRUCT!{struct D3D11_FEATURE_DATA_THREADING {
    DriverConcurrentCreates: BOOL,
    DriverCommandLists: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_DOUBLES {
    DoublePrecisionFloatShaderOps: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_FORMAT_SUPPORT {
    InFormat: DXGI_FORMAT,
    OutFormatSupport: UINT,
}}
STRUCT!{struct D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {
    InFormat: DXGI_FORMAT,
    OutFormatSupport2: UINT,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D11_OPTIONS {
    OutputMergerLogicOp: BOOL,
    UAVOnlyRenderingForcedSampleCount: BOOL,
    DiscardAPIsSeenByDriver: BOOL,
    FlagsForUpdateAndCopySeenByDriver: BOOL,
    ClearView: BOOL,
    CopyWithOverlap: BOOL,
    ConstantBufferPartialUpdate: BOOL,
    ConstantBufferOffsetting: BOOL,
    MapNoOverwriteOnDynamicConstantBuffer: BOOL,
    MapNoOverwriteOnDynamicBufferSRV: BOOL,
    MultisampleRTVWithForcedSampleCountOne: BOOL,
    SAD4ShaderInstructions: BOOL,
    ExtendedDoublesShaderInstructions: BOOL,
    ExtendedResourceSharing: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_ARCHITECTURE_INFO {
    TileBasedDeferredRenderer: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D9_OPTIONS {
    FullNonPow2TextureSupport: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {
    SupportsDepthAsTextureWithLessEqualComparisonFilter: BOOL,
}}
ENUM!{enum D3D11_SHADER_MIN_PRECISION_SUPPORT {
    D3D11_SHADER_MIN_PRECISION_10_BIT = 0x1,
    D3D11_SHADER_MIN_PRECISION_16_BIT = 0x2,
}}
STRUCT!{struct D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {
    PixelShaderMinPrecision: UINT,
    AllOtherShaderStagesMinPrecision: UINT,
}}
ENUM!{enum D3D11_TILED_RESOURCES_TIER {
    D3D11_TILED_RESOURCES_NOT_SUPPORTED = 0,
    D3D11_TILED_RESOURCES_TIER_1 = 1,
    D3D11_TILED_RESOURCES_TIER_2 = 2,
    D3D11_TILED_RESOURCES_TIER_3 = 3,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D11_OPTIONS1 {
    TiledResourcesTier: D3D11_TILED_RESOURCES_TIER,
    MinMaxFiltering: BOOL,
    ClearViewAlsoSupportsDepthOnlyFormats: BOOL,
    MapOnDefaultBuffers: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {
    SimpleInstancingSupported: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_MARKER_SUPPORT {
    Profile: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D9_OPTIONS1 {
    FullNonPow2TextureSupported: BOOL,
    DepthAsTextureWithLessEqualComparisonFilterSupported: BOOL,
    SimpleInstancingSupported: BOOL,
    TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported: BOOL,
}}
ENUM!{enum D3D11_CONSERVATIVE_RASTERIZATION_TIER {
    D3D11_CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED = 0,
    D3D11_CONSERVATIVE_RASTERIZATION_TIER_1 = 1,
    D3D11_CONSERVATIVE_RASTERIZATION_TIER_2 = 2,
    D3D11_CONSERVATIVE_RASTERIZATION_TIER_3 = 3,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D11_OPTIONS2 {
    PSSpecifiedStencilRefSupported: BOOL,
    TypedUAVLoadAdditionalFormats: BOOL,
    ROVsSupported: BOOL,
    ConservativeRasterizationTier: D3D11_CONSERVATIVE_RASTERIZATION_TIER,
    TiledResourcesTier: D3D11_TILED_RESOURCES_TIER,
    MapOnDefaultTextures: BOOL,
    StandardSwizzle: BOOL,
    UnifiedMemoryArchitecture: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_D3D11_OPTIONS3 {
    VPAndRTArrayIndexFromAnyShaderFeedingRasterizer: BOOL,
}}
STRUCT!{struct D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    MaxGPUVirtualAddressBitsPerResource: UINT,
    MaxGPUVirtualAddressBitsPerProcess: UINT,
}}
RIDL!{#[uuid(0xc0bfa96c, 0xe089, 0x44fb, 0x8e, 0xaf, 0x26, 0xf8, 0x79, 0x61, 0x90, 0xda)]
interface ID3D11DeviceContext(ID3D11DeviceContextVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn VSSetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *const *mut ID3D11Buffer,
    ) -> (),
    fn PSSetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView,
    ) -> (),
    fn PSSetShader(
        pPixelShader: *mut ID3D11PixelShader,
        ppClassInstances: *const *mut ID3D11ClassInstance,
        NumClassInstances: UINT,
    ) -> (),
    fn PSSetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *const *mut ID3D11SamplerState,
    ) -> (),
    fn VSSetShader(
        pVertexShader: *mut ID3D11VertexShader,
        ppClassInstances: *const *mut ID3D11ClassInstance,
        NumClassInstances: UINT,
    ) -> (),
    fn DrawIndexed(
        IndexCount: UINT,
        StartIndexLocation: UINT,
        BaseVertexLocation: INT,
    ) -> (),
    fn Draw(
        VertexCount: UINT,
        StartVertexLocation: UINT,
    ) -> (),
    fn Map(
        pResource: *mut ID3D11Resource,
        Subresource: UINT,
        MapType: D3D11_MAP,
        MapFlags: UINT,
        pMappedResource: *mut D3D11_MAPPED_SUBRESOURCE,
    ) -> HRESULT,
    fn Unmap(
        pResource: *mut ID3D11Resource,
        Subresource: UINT,
    ) -> (),
    fn PSSetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *const *mut ID3D11Buffer,
    ) -> (),
    fn IASetInputLayout(
        pInputLayout: *mut ID3D11InputLayout,
    ) -> (),
    fn IASetVertexBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppVertexBuffers: *const *mut ID3D11Buffer,
        pStrides: *const UINT,
        pOffsets: *const UINT,
    ) -> (),
    fn IASetIndexBuffer(
        pIndexBuffer: *mut ID3D11Buffer,
        Format: DXGI_FORMAT,
        Offset: UINT,
    ) -> (),
    fn DrawIndexedInstanced(
        IndexCountPerInstance: UINT,
        InstanceCount: UINT,
        StartIndexLocation: UINT,
        BaseVertexLocation: INT,
        StartInstanceLocation: UINT,
    ) -> (),
    fn DrawInstanced(
        VertexCountPerInstance: UINT,
        InstanceCount: UINT,
        StartVertexLocation: UINT,
        StartInstanceLocation: UINT,
    ) -> (),
    fn GSSetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *const *mut ID3D11Buffer,
    ) -> (),
    fn GSSetShader(
        pShader: *mut ID3D11GeometryShader,
        ppClassInstances: *const *mut ID3D11ClassInstance,
        NumClassInstances: UINT,
    ) -> (),
    fn IASetPrimitiveTopology(
        Topology: D3D11_PRIMITIVE_TOPOLOGY,
    ) -> (),
    fn VSSetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView,
    ) -> (),
    fn VSSetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *const *mut ID3D11SamplerState,
    ) -> (),
    fn Begin(
        pAsync: *mut ID3D11Asynchronous,
    ) -> (),
    fn End(
        pAsync: *mut ID3D11Asynchronous,
    ) -> (),
    fn GetData(
        pAsync: *mut ID3D11Asynchronous,
        pData: *mut c_void,
        DataSize: UINT,
        GetDataFlags: UINT,
    ) -> HRESULT,
    fn SetPredication(
        pPredicate: *mut ID3D11Predicate,
        PredicateValue: BOOL,
    ) -> (),
    fn GSSetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView,
    ) -> (),
    fn GSSetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *const *mut ID3D11SamplerState,
    ) -> (),
    fn OMSetRenderTargets(
        NumViews: UINT,
        ppRenderTargetViews: *const *mut ID3D11RenderTargetView,
        pDepthStencilView: *mut ID3D11DepthStencilView,
    ) -> (),
    fn OMSetRenderTargetsAndUnorderedAccessViews(
        NumRTVs: UINT,
        ppRenderTargetViews: *const *mut ID3D11RenderTargetView,
        pDepthStencilView: *mut ID3D11DepthStencilView,
        UAVStartSlot: UINT,
        NumUAVs: UINT,
        ppUnorderedAccessViews: *const *mut ID3D11UnorderedAccessView,
        pUAVInitialCounts: *const UINT,
    ) -> (),
    fn OMSetBlendState(
        pBlendState: *mut ID3D11BlendState,
        BlendFactor: &[FLOAT; 4],
        SampleMask: UINT,
    ) -> (),
    fn OMSetDepthStencilState(
        pDepthStencilState: *mut ID3D11DepthStencilState,
        StencilRef: UINT,
    ) -> (),
    fn SOSetTargets(
        NumBuffers: UINT,
        ppSOTargets: *const *mut ID3D11Buffer,
        pOffsets: *const UINT,
    ) -> (),
    fn DrawAuto() -> (),
    fn DrawIndexedInstancedIndirect(
        pBufferForArgs: *mut ID3D11Buffer,
        AlignedByteOffsetForArgs: UINT,
    ) -> (),
    fn DrawInstancedIndirect(
        pBufferForArgs: *mut ID3D11Buffer,
        AlignedByteOffsetForArgs: UINT,
    ) -> (),
    fn Dispatch(
        ThreadGroupCountX: UINT,
        ThreadGroupCountY: UINT,
        ThreadGroupCountZ: UINT,
    ) -> (),
    fn DispatchIndirect(
        pBufferForArgs: *mut ID3D11Buffer,
        AlignedByteOffsetForArgs: UINT,
    ) -> (),
    fn RSSetState(
        pRasterizerState: *mut ID3D11RasterizerState,
    ) -> (),
    fn RSSetViewports(
        NumViewports: UINT,
        pViewports: *const D3D11_VIEWPORT,
    ) -> (),
    fn RSSetScissorRects(
        NumRects: UINT,
        pRects: *const D3D11_RECT,
    ) -> (),
    fn CopySubresourceRegion(
        pDstResource: *mut ID3D11Resource,
        DstSubresource: UINT,
        DstX: UINT,
        DstY: UINT,
        DstZ: UINT,
        pSrcResource: *mut ID3D11Resource,
        SrcSubresource: UINT,
        pSrcBox: *const D3D11_BOX,
    ) -> (),
    fn CopyResource(
        pDstResource: *mut ID3D11Resource,
        pSrcResource: *mut ID3D11Resource,
    ) -> (),
    fn UpdateSubresource(
        pDstResource: *mut ID3D11Resource,
        DstSubresource: UINT,
        pDstBox: *const D3D11_BOX,
        pSrcData: *const c_void,
        SrcRowPitch: UINT,
        SrcDepthPitch: UINT,
    ) -> (),
    fn CopyStructureCount(
        pDstBuffer: *mut ID3D11Buffer,
        DstAlignedByteOffset: UINT,
        pSrcView: *mut ID3D11UnorderedAccessView,
    ) -> (),
    fn ClearRenderTargetView(
        pRenderTargetView: *mut ID3D11RenderTargetView,
        ColorRGBA: &[FLOAT; 4],
    ) -> (),
    fn ClearUnorderedAccessViewUint(
        pUnorderedAccessView: *mut ID3D11UnorderedAccessView,
        Values: &[UINT; 4],
    ) -> (),
    fn ClearUnorderedAccessViewFloat(
        pUnorderedAccessView: *mut ID3D11UnorderedAccessView,
        Values: &[FLOAT; 4],
    ) -> (),
    fn ClearDepthStencilView(
        pDepthStencilView: *mut ID3D11DepthStencilView,
        ClearFlags: UINT,
        Depth: FLOAT,
        Stencil: UINT8,
    ) -> (),
    fn GenerateMips(
        pShaderResourceView: *mut ID3D11ShaderResourceView,
    ) -> (),
    fn SetResourceMinLOD(
        pResource: *mut ID3D11Resource,
        MinLOD: FLOAT,
    ) -> (),
    fn GetResourceMinLOD(
        pResource: *mut ID3D11Resource,
    ) -> FLOAT,
    fn ResolveSubresource(
        pDstResource: *mut ID3D11Resource,
        DstSubresource: UINT,
        pSrcResource: *mut ID3D11Resource,
        SrcSubresource: UINT,
        Format: DXGI_FORMAT,
    ) -> (),
    fn ExecuteCommandList(
        pCommandList: *mut ID3D11CommandList,
        RestoreContextState: BOOL,
    ) -> (),
    fn HSSetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView,
    ) -> (),
    fn HSSetShader(
        pHullShader: *mut ID3D11HullShader,
        ppClassInstances: *const *mut ID3D11ClassInstance,
        NumClassInstances: UINT,
    ) -> (),
    fn HSSetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *const *mut ID3D11SamplerState,
    ) -> (),
    fn HSSetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *const *mut ID3D11Buffer,
    ) -> (),
    fn DSSetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView,
    ) -> (),
    fn DSSetShader(
        pDomainShader: *mut ID3D11DomainShader,
        ppClassInstances: *const *mut ID3D11ClassInstance,
        NumClassInstances: UINT,
    ) -> (),
    fn DSSetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *const *mut ID3D11SamplerState,
    ) -> (),
    fn DSSetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *const *mut ID3D11Buffer,
    ) -> (),
    fn CSSetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *const *mut ID3D11ShaderResourceView,
    ) -> (),
    fn CSSetUnorderedAccessViews(
        StartSlot: UINT,
        NumUAVs: UINT,
        ppUnorderedAccessViews: *const *mut ID3D11UnorderedAccessView,
        pUAVInitialCounts: *const UINT,
    ) -> (),
    fn CSSetShader(
        pComputeShader: *mut ID3D11ComputeShader,
        ppClassInstances: *const *mut ID3D11ClassInstance,
        NumClassInstances: UINT,
    ) -> (),
    fn CSSetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *const *mut ID3D11SamplerState,
    ) -> (),
    fn CSSetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *const *mut ID3D11Buffer,
    ) -> (),
    fn VSGetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *mut *mut ID3D11Buffer,
    ) -> (),
    fn PSGetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView,
    ) -> (),
    fn PSGetShader(
        ppPixelShader: *mut *mut ID3D11PixelShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance,
        pNumClassInstances: *mut UINT,
    ) -> (),
    fn PSGetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *mut *mut ID3D11SamplerState,
    ) -> (),
    fn VSGetShader(
        ppVertexShader: *mut *mut ID3D11VertexShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance,
        pNumClassInstances: *mut UINT,
    ) -> (),
    fn PSGetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *mut *mut ID3D11Buffer,
    ) -> (),
    fn IAGetInputLayout(
        ppInputLayout: *mut *mut ID3D11InputLayout,
    ) -> (),
    fn IAGetVertexBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppVertexBuffers: *mut *mut ID3D11Buffer,
        pStrides: *mut UINT,
        pOffsets: *mut UINT,
    ) -> (),
    fn IAGetIndexBuffer(
        pIndexBuffer: *mut *mut ID3D11Buffer,
        Format: *mut DXGI_FORMAT,
        Offset: *mut UINT,
    ) -> (),
    fn GSGetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *mut *mut ID3D11Buffer,
    ) -> (),
    fn GSGetShader(
        ppGeometryShader: *mut *mut ID3D11GeometryShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance,
        pNumClassInstances: *mut UINT,
    ) -> (),
    fn IAGetPrimitiveTopology(
        pTopology: *mut D3D11_PRIMITIVE_TOPOLOGY,
    ) -> (),
    fn VSGetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView,
    ) -> (),
    fn VSGetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *mut *mut ID3D11SamplerState,
    ) -> (),
    fn GetPredication(
        ppPredicate: *mut *mut ID3D11Predicate,
        pPredicateValue: *mut BOOL,
    ) -> (),
    fn GSGetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView,
    ) -> (),
    fn GSGetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *mut *mut ID3D11SamplerState,
    ) -> (),
    fn OMGetRenderTargets(
        NumViews: UINT,
        ppRenderTargetViews: *mut *mut ID3D11RenderTargetView,
        ppDepthStencilView: *mut *mut ID3D11DepthStencilView,
    ) -> (),
    fn OMGetRenderTargetsAndUnorderedAccessViews(
        NumRTVs: UINT,
        ppRenderTargetViews: *mut *mut ID3D11RenderTargetView,
        ppDepthStencilView: *mut *mut ID3D11DepthStencilView,
        UAVStartSlot: UINT,
        ppUnorderedAccessViews: *mut *mut ID3D11UnorderedAccessView,
    ) -> (),
    fn OMGetBlendState(
        ppBlendState: *mut *mut ID3D11BlendState,
        BlendFactor: &mut [FLOAT; 4],
        pSampleMask: *mut UINT,
    ) -> (),
    fn OMGetDepthStencilState(
        ppDepthStencilState: *mut *mut ID3D11DepthStencilState,
        pStencilRef: *mut UINT,
    ) -> (),
    fn SOGetTargets(
        NumBuffers: UINT,
        ppSOTargets: *mut *mut ID3D11Buffer,
    ) -> (),
    fn RSGetState(
        ppRasterizerState: *mut *mut ID3D11RasterizerState,
    ) -> (),
    fn RSGetViewports(
        pNumViewports: *mut UINT,
        pViewports: *mut D3D11_VIEWPORT,
    ) -> (),
    fn RSGetScissorRects(
        pNumRects: *mut UINT,
        pRects: *mut D3D11_RECT,
    ) -> (),
    fn HSGetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView,
    ) -> (),
    fn HSGetShader(
        ppHullShader: *mut *mut ID3D11HullShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance,
        pNumClassInstances: *mut UINT,
    ) -> (),
    fn HSGetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *mut *mut ID3D11SamplerState,
    ) -> (),
    fn HSGetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *mut *mut ID3D11Buffer,
    ) -> (),
    fn DSGetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView,
    ) -> (),
    fn DSGetShader(
        ppDomainShader: *mut *mut ID3D11DomainShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance,
        pNumClassInstances: *mut UINT,
    ) -> (),
    fn DSGetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *mut *mut ID3D11SamplerState,
    ) -> (),
    fn DSGetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *mut *mut ID3D11Buffer,
    ) -> (),
    fn CSGetShaderResources(
        StartSlot: UINT,
        NumViews: UINT,
        ppShaderResourceViews: *mut *mut ID3D11ShaderResourceView,
    ) -> (),
    fn CSGetUnorderedAccessViews(
        StartSlot: UINT,
        NumUAVs: UINT,
        ppUnorderedAccessViews: *mut *mut ID3D11UnorderedAccessView,
    ) -> (),
    fn CSGetShader(
        ppComputeShader: *mut *mut ID3D11ComputeShader,
        ppClassInstances: *mut *mut ID3D11ClassInstance,
        pNumClassInstances: *mut UINT,
    ) -> (),
    fn CSGetSamplers(
        StartSlot: UINT,
        NumSamplers: UINT,
        ppSamplers: *mut *mut ID3D11SamplerState,
    ) -> (),
    fn CSGetConstantBuffers(
        StartSlot: UINT,
        NumBuffers: UINT,
        ppConstantBuffers: *mut *mut ID3D11Buffer,
    ) -> (),
    fn ClearState() -> (),
    fn Flush() -> (),
    fn GetType() -> D3D11_DEVICE_CONTEXT_TYPE,
    fn GetContextFlags() -> UINT,
    fn FinishCommandList(
        RestoreDeferredContextState: BOOL,
        ppCommandList: *mut *mut ID3D11CommandList,
    ) -> HRESULT,
}}
DEFINE_GUID!{D3D11_DECODER_PROFILE_MPEG2_MOCOMP,
    0xe6a9f44b, 0x61b0, 0x4563, 0x9e, 0xa4, 0x63, 0xd2, 0xa3, 0xc6, 0xfe, 0x66}
DEFINE_GUID!{D3D11_DECODER_PROFILE_MPEG2_IDCT,
    0xbf22ad00, 0x03ea, 0x4690, 0x80, 0x77, 0x47, 0x33, 0x46, 0x20, 0x9b, 0x7e}
DEFINE_GUID!{D3D11_DECODER_PROFILE_MPEG2_VLD,
    0xee27417f, 0x5e28, 0x4e65, 0xbe, 0xea, 0x1d, 0x26, 0xb5, 0x08, 0xad, 0xc9}
DEFINE_GUID!{D3D11_DECODER_PROFILE_MPEG1_VLD,
    0x6f3ec719, 0x3735, 0x42cc, 0x80, 0x63, 0x65, 0xcc, 0x3c, 0xb3, 0x66, 0x16}
DEFINE_GUID!{D3D11_DECODER_PROFILE_MPEG2and1_VLD,
    0x86695f12, 0x340e, 0x4f04, 0x9f, 0xd3, 0x92, 0x53, 0xdd, 0x32, 0x74, 0x60}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_MOCOMP_NOFGT,
    0x1b81be64, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_MOCOMP_FGT,
    0x1b81be65, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_IDCT_NOFGT,
    0x1b81be66, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_IDCT_FGT,
    0x1b81be67, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_VLD_NOFGT,
    0x1b81be68, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_VLD_FGT,
    0x1b81be69, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_VLD_WITHFMOASO_NOFGT,
    0xd5f04ff9, 0x3418, 0x45d8, 0x95, 0x61, 0x32, 0xa7, 0x6a, 0xae, 0x2d, 0xdd}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_VLD_STEREO_PROGRESSIVE_NOFGT,
    0xd79be8da, 0x0cf1, 0x4c81, 0xb8, 0x2a, 0x69, 0xa4, 0xe2, 0x36, 0xf4, 0x3d}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_VLD_STEREO_NOFGT,
    0xf9aaccbb, 0xc2b6, 0x4cfc, 0x87, 0x79, 0x57, 0x07, 0xb1, 0x76, 0x05, 0x52}
DEFINE_GUID!{D3D11_DECODER_PROFILE_H264_VLD_MULTIVIEW_NOFGT,
    0x705b9d82, 0x76cf, 0x49d6, 0xb7, 0xe6, 0xac, 0x88, 0x72, 0xdb, 0x01, 0x3c}
DEFINE_GUID!{D3D11_DECODER_PROFILE_WMV8_POSTPROC,
    0x1b81be80, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_WMV8_MOCOMP,
    0x1b81be81, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_WMV9_POSTPROC,
    0x1b81be90, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_WMV9_MOCOMP,
    0x1b81be91, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_WMV9_IDCT,
    0x1b81be94, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_VC1_POSTPROC,
    0x1b81bea0, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_VC1_MOCOMP,
    0x1b81bea1, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_VC1_IDCT,
    0x1b81bea2, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_VC1_VLD,
    0x1b81bea3, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_VC1_D2010,
    0x1b81bea4, 0xa0c7, 0x11d3, 0xb9, 0x84, 0x00, 0xc0, 0x4f, 0x2e, 0x73, 0xc5}
DEFINE_GUID!{D3D11_DECODER_PROFILE_MPEG4PT2_VLD_SIMPLE,
    0xefd64d74, 0xc9e8, 0x41d7, 0xa5, 0xe9, 0xe9, 0xb0, 0xe3, 0x9f, 0xa3, 0x19}
DEFINE_GUID!{D3D11_DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_NOGMC,
    0xed418a9f, 0x010d, 0x4eda, 0x9a, 0xe3, 0x9a, 0x65, 0x35, 0x8d, 0x8d, 0x2e}
DEFINE_GUID!{D3D11_DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_GMC,
    0xab998b5b, 0x4258, 0x44a9, 0x9f, 0xeb, 0x94, 0xe5, 0x97, 0xa6, 0xba, 0xae}
DEFINE_GUID!{D3D11_DECODER_PROFILE_HEVC_VLD_MAIN,
    0x5b11d51b, 0x2f4c, 0x4452, 0xbc, 0xc3, 0x09, 0xf2, 0xa1, 0x16, 0x0c, 0xc0}
DEFINE_GUID!{D3D11_DECODER_PROFILE_HEVC_VLD_MAIN10,
    0x107af0e0, 0xef1a, 0x4d19, 0xab, 0xa8, 0x67, 0xa1, 0x63, 0x07, 0x3d, 0x13}
DEFINE_GUID!{D3D11_DECODER_PROFILE_VP9_VLD_PROFILE0,
    0x463707f8, 0xa1d0, 0x4585, 0x87, 0x6d, 0x83, 0xaa, 0x6d, 0x60, 0xb8, 0x9e}
DEFINE_GUID!{D3D11_DECODER_PROFILE_VP8_VLD,
    0x90b899ea, 0x3a62, 0x4705, 0x88, 0xb3, 0x8d, 0xf0, 0x4b, 0x27, 0x44, 0xe7}
STRUCT!{struct D3D11_VIDEO_DECODER_DESC {
    Guid: GUID,
    SampleWidth: UINT,
    SampleHeight: UINT,
    OutputFormat: DXGI_FORMAT,
}}
STRUCT!{struct D3D11_VIDEO_DECODER_CONFIG {
    guidConfigBitstreamEncryption: GUID,
    guidConfigMBcontrolEncryption: GUID,
    guidConfigResidDiffEncryption: GUID,
    ConfigBitstreamRaw: UINT,
    ConfigMBcontrolRasterOrder: UINT,
    ConfigResidDiffHost: UINT,
    ConfigSpatialResid8: UINT,
    ConfigResid8Subtraction: UINT,
    ConfigSpatialHost8or9Clipping: UINT,
    ConfigSpatialResidInterleaved: UINT,
    ConfigIntraResidUnsigned: UINT,
    ConfigResidDiffAccelerator: UINT,
    ConfigHostInverseScan: UINT,
    ConfigSpecificIDCT: UINT,
    Config4GroupedCoefs: UINT,
    ConfigMinRenderTargetBuffCount: USHORT,
    ConfigDecoderSpecific: USHORT,
}}
ENUM!{enum D3D11_VIDEO_DECODER_BUFFER_TYPE {
    D3D11_VIDEO_DECODER_BUFFER_PICTURE_PARAMETERS = 0,
    D3D11_VIDEO_DECODER_BUFFER_MACROBLOCK_CONTROL = 1,
    D3D11_VIDEO_DECODER_BUFFER_RESIDUAL_DIFFERENCE = 2,
    D3D11_VIDEO_DECODER_BUFFER_DEBLOCKING_CONTROL = 3,
    D3D11_VIDEO_DECODER_BUFFER_INVERSE_QUANTIZATION_MATRIX = 4,
    D3D11_VIDEO_DECODER_BUFFER_SLICE_CONTROL = 5,
    D3D11_VIDEO_DECODER_BUFFER_BITSTREAM = 6,
    D3D11_VIDEO_DECODER_BUFFER_MOTION_VECTOR = 7,
    D3D11_VIDEO_DECODER_BUFFER_FILM_GRAIN = 8,
}}
STRUCT!{struct D3D11_AES_CTR_IV {
    IV: UINT64,
    Count: UINT64,
}}
STRUCT!{struct D3D11_ENCRYPTED_BLOCK_INFO {
    NumEncryptedBytesAtBeginning: UINT,
    NumBytesInSkipPattern: UINT,
    NumBytesInEncryptPattern: UINT,
}}
STRUCT!{struct D3D11_VIDEO_DECODER_BUFFER_DESC {
    BufferType: D3D11_VIDEO_DECODER_BUFFER_TYPE,
    BufferIndex: UINT,
    DataOffset: UINT,
    DataSize: UINT,
    FirstMBaddress: UINT,
    NumMBsInBuffer: UINT,
    Width: UINT,
    Height: UINT,
    Stride: UINT,
    ReservedBits: UINT,
    pIV: *mut c_void,
    IVSize: UINT,
    PartialEncryption: BOOL,
    EncryptedBlockInfo: D3D11_ENCRYPTED_BLOCK_INFO,
}}
STRUCT!{struct D3D11_VIDEO_DECODER_EXTENSION {
    Function: UINT,
    pPrivateInputData: *mut c_void,
    PrivateInputDataSize: UINT,
    pPrivateOutputData: *mut c_void,
    PrivateOutputDataSize: UINT,
    ResourceCount: UINT,
    ppResourceList: *mut *mut ID3D11Resource,
}}
RIDL!{#[uuid(0x3c9c5b51, 0x995d, 0x48d1, 0x9b, 0x8d, 0xfa, 0x5c, 0xae, 0xde, 0xd6, 0x5c)]
interface ID3D11VideoDecoder(ID3D11VideoDecoderVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetCreationParameters(
        pVideoDesc: *mut D3D11_VIDEO_DECODER_DESC,
        pConfig: *mut D3D11_VIDEO_DECODER_CONFIG,
    ) -> HRESULT,
    fn GetDriverHandle(
        pDriverHandle: *mut HANDLE,
    ) -> HRESULT,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT {
    D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT = 0x1,
    D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT = 0x2,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_DEVICE_CAPS {
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_LINEAR_SPACE = 0x1,
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_xvYCC = 0x2,
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_RGB_RANGE_CONVERSION = 0x4,
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_YCbCr_MATRIX_CONVERSION = 0x8,
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_NOMINAL_RANGE = 0x10,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_FEATURE_CAPS {
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_FILL = 0x1,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_CONSTRICTION = 0x2,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LUMA_KEY = 0x4,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_PALETTE = 0x8,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LEGACY = 0x10,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_STEREO = 0x20,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ROTATION = 0x40,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_STREAM = 0x80,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_PIXEL_ASPECT_RATIO = 0x100,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_MIRROR = 0x200,
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_SHADER_USAGE = 0x400,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_FILTER_CAPS {
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_BRIGHTNESS = 0x1,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_CONTRAST = 0x2,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_HUE = 0x4,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_SATURATION = 0x8,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_NOISE_REDUCTION = 0x10,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_EDGE_ENHANCEMENT = 0x20,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_ANAMORPHIC_SCALING = 0x40,
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS_STEREO_ADJUSTMENT = 0x80,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_FORMAT_CAPS {
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_INTERLACED = 0x1,
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_PROCAMP = 0x2,
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_LUMA_KEY = 0x4,
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_PALETTE_INTERLACED = 0x8,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS {
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DENOISE = 0x1,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DERINGING = 0x2,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_EDGE_ENHANCEMENT = 0x4,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_COLOR_CORRECTION = 0x8,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_FLESH_TONE_MAPPING = 0x10,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_IMAGE_STABILIZATION = 0x20,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_SUPER_RESOLUTION = 0x40,
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_ANAMORPHIC_SCALING = 0x80,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_STEREO_CAPS {
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_MONO_OFFSET = 0x1,
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_ROW_INTERLEAVED = 0x2,
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_COLUMN_INTERLEAVED = 0x4,
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_CHECKERBOARD = 0x8,
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS_FLIP_MODE = 0x10,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_CAPS {
    DeviceCaps: UINT,
    FeatureCaps: UINT,
    FilterCaps: UINT,
    InputFormatCaps: UINT,
    AutoStreamCaps: UINT,
    StereoCaps: UINT,
    RateConversionCapsCount: UINT,
    MaxInputStreams: UINT,
    MaxStreamStates: UINT,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS {
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BLEND = 0x1,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BOB = 0x2,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_ADAPTIVE = 0x4,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_MOTION_COMPENSATION = 0x8,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_INVERSE_TELECINE = 0x10,
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_FRAME_RATE_CONVERSION = 0x20,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS {
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32 = 0x1,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_22 = 0x2,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2224 = 0x4,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2332 = 0x8,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32322 = 0x10,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_55 = 0x20,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_64 = 0x40,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_87 = 0x80,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_222222222223 = 0x100,
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_OTHER = 0x80000000,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {
    PastFrames: UINT,
    FutureFrames: UINT,
    ProcessorCaps: UINT,
    ITelecineCaps: UINT,
    CustomRateCount: UINT,
}}
ENUM!{enum D3D11_CONTENT_PROTECTION_CAPS {
    D3D11_CONTENT_PROTECTION_CAPS_SOFTWARE = 0x1,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE = 0x2,
    D3D11_CONTENT_PROTECTION_CAPS_PROTECTION_ALWAYS_ON = 0x4,
    D3D11_CONTENT_PROTECTION_CAPS_PARTIAL_DECRYPTION = 0x8,
    D3D11_CONTENT_PROTECTION_CAPS_CONTENT_KEY = 0x10,
    D3D11_CONTENT_PROTECTION_CAPS_FRESHEN_SESSION_KEY = 0x20,
    D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK = 0x40,
    D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK_KEY = 0x80,
    D3D11_CONTENT_PROTECTION_CAPS_SEQUENTIAL_CTR_IV = 0x100,
    D3D11_CONTENT_PROTECTION_CAPS_ENCRYPT_SLICEDATA_ONLY = 0x200,
    D3D11_CONTENT_PROTECTION_CAPS_DECRYPTION_BLT = 0x400,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECT_UNCOMPRESSED = 0x800,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECTED_MEMORY_PAGEABLE = 0x1000,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_TEARDOWN = 0x2000,
    D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_DRM_COMMUNICATION = 0x4000,
}}
DEFINE_GUID!{D3D11_CRYPTO_TYPE_AES128_CTR,
    0x9b6bd711, 0x4f74, 0x41c9, 0x9e, 0x7b, 0x0b, 0xe2, 0xd7, 0xd9, 0x3b, 0x4f}
DEFINE_GUID!{D3D11_DECODER_ENCRYPTION_HW_CENC,
    0x89d6ac4f, 0x09f2, 0x4229, 0xb2, 0xcd, 0x37, 0x74, 0x0a, 0x6d, 0xfd, 0x81}
DEFINE_GUID!{D3D11_KEY_EXCHANGE_HW_PROTECTION,
    0xb1170d8a, 0x628d, 0x4da3, 0xad, 0x3b, 0x82, 0xdd, 0xb0, 0x8b, 0x49, 0x70}
STRUCT!{struct D3D11_VIDEO_CONTENT_PROTECTION_CAPS {
    Caps: UINT,
    KeyExchangeTypeCount: UINT,
    BlockAlignmentSize: UINT,
    ProtectedMemorySize: ULONGLONG,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {
    CustomRate: DXGI_RATIONAL,
    OutputFrames: UINT,
    InputInterlaced: BOOL,
    InputFramesOrFields: UINT,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_FILTER {
    D3D11_VIDEO_PROCESSOR_FILTER_BRIGHTNESS = 0,
    D3D11_VIDEO_PROCESSOR_FILTER_CONTRAST = 1,
    D3D11_VIDEO_PROCESSOR_FILTER_HUE = 2,
    D3D11_VIDEO_PROCESSOR_FILTER_SATURATION = 3,
    D3D11_VIDEO_PROCESSOR_FILTER_NOISE_REDUCTION = 4,
    D3D11_VIDEO_PROCESSOR_FILTER_EDGE_ENHANCEMENT = 5,
    D3D11_VIDEO_PROCESSOR_FILTER_ANAMORPHIC_SCALING = 6,
    D3D11_VIDEO_PROCESSOR_FILTER_STEREO_ADJUSTMENT = 7,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_FILTER_RANGE {
    Minimum: c_int,
    Maximum: c_int,
    Default: c_int,
    Multiplier: c_float,
}}
ENUM!{enum D3D11_VIDEO_FRAME_FORMAT {
    D3D11_VIDEO_FRAME_FORMAT_PROGRESSIVE = 0,
    D3D11_VIDEO_FRAME_FORMAT_INTERLACED_TOP_FIELD_FIRST = 1,
    D3D11_VIDEO_FRAME_FORMAT_INTERLACED_BOTTOM_FIELD_FIRST = 2,
}}
ENUM!{enum D3D11_VIDEO_USAGE {
    D3D11_VIDEO_USAGE_PLAYBACK_NORMAL = 0,
    D3D11_VIDEO_USAGE_OPTIMAL_SPEED = 1,
    D3D11_VIDEO_USAGE_OPTIMAL_QUALITY = 2,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_CONTENT_DESC {
    InputFrameFormat: D3D11_VIDEO_FRAME_FORMAT,
    InputFrameRate: DXGI_RATIONAL,
    InputWidth: UINT,
    InputHeight: UINT,
    OutputFrameRate: DXGI_RATIONAL,
    OutputWidth: UINT,
    OutputHeight: UINT,
    Usage: D3D11_VIDEO_USAGE,
}}
RIDL!{#[uuid(0x31627037, 0x53ab, 0x4200, 0x90, 0x61, 0x05, 0xfa, 0xa9, 0xab, 0x45, 0xf9)]
interface ID3D11VideoProcessorEnumerator(ID3D11VideoProcessorEnumeratorVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetVideoProcessorContentDesc(
        pContentDesc: *mut D3D11_VIDEO_PROCESSOR_CONTENT_DESC,
    ) -> HRESULT,
    fn CheckVideoProcessorFormat(
        Format: DXGI_FORMAT,
        pFlags: *mut UINT,
    ) -> HRESULT,
    fn GetVideoProcessorCaps(
        pCaps: *mut D3D11_VIDEO_PROCESSOR_CAPS,
    ) -> HRESULT,
    fn GetVideoProcessorRateConversionCaps(
        TypeIndex: UINT,
        pCaps: *mut D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS,
    ) -> HRESULT,
    fn GetVideoProcessorCustomRate(
        TypeIndex: UINT,
        CustomRateIndex: UINT,
        pRate: *mut D3D11_VIDEO_PROCESSOR_CUSTOM_RATE,
    ) -> HRESULT,
    fn GetVideoProcessorFilterRange(
        Filter: D3D11_VIDEO_PROCESSOR_FILTER,
        Range: *mut D3D11_VIDEO_PROCESSOR_FILTER_RANGE,
    ) -> HRESULT,
}}
STRUCT!{struct D3D11_VIDEO_COLOR_RGBA {
    R: c_float,
    G: c_float,
    B: c_float,
    A: c_float,
}}
STRUCT!{struct D3D11_VIDEO_COLOR_YCbCrA {
    Y: c_float,
    Cb: c_float,
    Cr: c_float,
    A: c_float,
}}
UNION!{union D3D11_VIDEO_COLOR {
    [f32; 4],
    YCbCr YCbCr_mut: D3D11_VIDEO_COLOR_YCbCrA,
    RGBA RGBA_mut: D3D11_VIDEO_COLOR_RGBA,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE {
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_UNDEFINED = 0,
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_16_235 = 1,
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_0_255 = 2,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_COLOR_SPACE {
    bitfield: UINT,
}}
BITFIELD!{D3D11_VIDEO_PROCESSOR_COLOR_SPACE bitfield: UINT [
    Usage set_Usage[0..1],
    RGB_Range set_RGB_Range[1..2],
    YCbCr_Matrix set_YCbCr_Matrix[2..3],
    YCbCr_xvYCC set_YCbCr_xvYCC[3..4],
    Nominal_Range set_Nominal_Range[4..6],
]}
ENUM!{enum D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE {
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_OPAQUE = 0,
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_BACKGROUND = 1,
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_DESTINATION = 2,
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_SOURCE_STREAM = 3,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_OUTPUT_RATE {
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_NORMAL = 0,
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_HALF = 1,
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_CUSTOM = 2,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_STEREO_FORMAT {
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO = 0,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_HORIZONTAL = 1,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_VERTICAL = 2,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_SEPARATE = 3,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO_OFFSET = 4,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_ROW_INTERLEAVED = 5,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_COLUMN_INTERLEAVED = 6,
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_CHECKERBOARD = 7,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE {
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_NONE = 0,
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME0 = 1,
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME1 = 2,
}}
ENUM!{enum D3D11_VIDEO_PROCESSOR_ROTATION {
    D3D11_VIDEO_PROCESSOR_ROTATION_IDENTITY = 0,
    D3D11_VIDEO_PROCESSOR_ROTATION_90 = 1,
    D3D11_VIDEO_PROCESSOR_ROTATION_180 = 2,
    D3D11_VIDEO_PROCESSOR_ROTATION_270 = 3,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_STREAM {
    Enable: BOOL,
    OutputIndex: UINT,
    InputFrameOrField: UINT,
    PastFrames: UINT,
    FutureFrames: UINT,
    ppPastSurfaces: *mut *mut ID3D11VideoProcessorInputView,
    pInputSurface: *mut ID3D11VideoProcessorInputView,
    ppFutureSurfaces: *mut *mut ID3D11VideoProcessorInputView,
    ppPastSurfacesRight: *mut *mut ID3D11VideoProcessorInputView,
    pInputSurfaceRight: *mut ID3D11VideoProcessorInputView,
    ppFutureSurfacesRight: *mut *mut ID3D11VideoProcessorInputView,
}}
RIDL!{#[uuid(0x1d7b0652, 0x185f, 0x41c6, 0x85, 0xce, 0x0c, 0x5b, 0xe3, 0xd4, 0xae, 0x6c)]
interface ID3D11VideoProcessor(ID3D11VideoProcessorVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetContentDesc(
        pDesc: *mut D3D11_VIDEO_PROCESSOR_CONTENT_DESC,
    ) -> (),
    fn GetRateConversionCaps(
        pCaps: *mut D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS,
    ) -> (),
}}
STRUCT!{struct D3D11_OMAC {
    Omac: [BYTE; 16],
}}
ENUM!{enum D3D11_AUTHENTICATED_CHANNEL_TYPE {
    D3D11_AUTHENTICATED_CHANNEL_D3D11 = 1,
    D3D11_AUTHENTICATED_CHANNEL_DRIVER_SOFTWARE = 2,
    D3D11_AUTHENTICATED_CHANNEL_DRIVER_HARDWARE = 3,
}}
RIDL!{#[uuid(0x3015a308, 0xdcbd, 0x47aa, 0xa7, 0x47, 0x19, 0x24, 0x86, 0xd1, 0x4d, 0x4a)]
interface ID3D11AuthenticatedChannel(ID3D11AuthenticatedChannelVtbl):
    ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetCertificateSize(
        pCertificateSize: *mut UINT,
    ) -> HRESULT,
    fn GetCertificate(
        CertificateSize: UINT,
        pCertificate: *mut BYTE,
    ) -> HRESULT,
    fn GetChannelHandle(
        pChannelHandle: *mut HANDLE,
    ) -> (),
}}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_PROTECTION,
    0xa84eb584, 0xc495, 0x48aa, 0xb9, 0x4d, 0x8b, 0xd2, 0xd6, 0xfb, 0xce, 0x05}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE,
    0xbc1b18a5, 0xb1fb, 0x42ab, 0xbd, 0x94, 0xb5, 0x82, 0x8b, 0x4b, 0xf7, 0xbe}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE,
    0xec1c539d, 0x8cff, 0x4e2a, 0xbc, 0xc4, 0xf5, 0x69, 0x2f, 0x99, 0xf4, 0x80}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION,
    0x2634499e, 0xd018, 0x4d74, 0xac, 0x17, 0x7f, 0x72, 0x40, 0x59, 0x52, 0x8d}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT,
    0x0db207b3, 0x9450, 0x46a6, 0x82, 0xde, 0x1b, 0x96, 0xd4, 0x4f, 0x9c, 0xf2}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS,
    0x649bbadb, 0xf0f4, 0x4639, 0xa1, 0x5b, 0x24, 0x39, 0x3f, 0xc3, 0xab, 0xac}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT,
    0x012f0bd6, 0xe662, 0x4474, 0xbe, 0xfd, 0xaa, 0x53, 0xe5, 0x14, 0x3c, 0x6d}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT,
    0x2c042b5e, 0x8c07, 0x46d5, 0xaa, 0xbe, 0x8f, 0x75, 0xcb, 0xad, 0x4c, 0x31}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_OUTPUT_ID,
    0x839ddca3, 0x9b4e, 0x41e4, 0xb0, 0x53, 0x89, 0x2b, 0xd2, 0xa1, 0x1e, 0xe7}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ATTRIBUTES,
    0x6214d9d2, 0x432c, 0x4abb, 0x9f, 0xce, 0x21, 0x6e, 0xea, 0x26, 0x9e, 0x3b}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID_COUNT,
    0xb30f7066, 0x203c, 0x4b07, 0x93, 0xfc, 0xce, 0xaa, 0xfd, 0x61, 0x24, 0x1e}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID,
    0xf83a5958, 0xe986, 0x4bda, 0xbe, 0xb0, 0x41, 0x1f, 0x6a, 0x7a, 0x01, 0xb7}
DEFINE_GUID!{D3D11_AUTHENTICATED_QUERY_CURRENT_ENCRYPTION_WHEN_ACCESSIBLE,
    0xec1791c7, 0xdad3, 0x4f15, 0x9e, 0xc3, 0xfa, 0xa9, 0x3d, 0x60, 0xd4, 0xf0}
DEFINE_GUID!{D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE,
    0x06114bdb, 0x3523, 0x470a, 0x8d, 0xca, 0xfb, 0xc2, 0x84, 0x51, 0x54, 0xf0}
DEFINE_GUID!{D3D11_AUTHENTICATED_CONFIGURE_PROTECTION,
    0x50455658, 0x3f47, 0x4362, 0xbf, 0x99, 0xbf, 0xdf, 0xcd, 0xe9, 0xed, 0x29}
DEFINE_GUID!{D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION,
    0x6346cc54, 0x2cfc, 0x4ad4, 0x82, 0x24, 0xd1, 0x58, 0x37, 0xde, 0x77, 0x00}
DEFINE_GUID!{D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE,
    0x0772d047, 0x1b40, 0x48e8, 0x9c, 0xa6, 0xb5, 0xf5, 0x10, 0xde, 0x9f, 0x01}
DEFINE_GUID!{D3D11_AUTHENTICATED_CONFIGURE_ENCRYPTION_WHEN_ACCESSIBLE,
    0x41fff286, 0x6ae0, 0x4d43, 0x9d, 0x55, 0xa4, 0x6e, 0x9e, 0xfd, 0x15, 0x8a}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_INPUT {
    QueryType: GUID,
    hChannel: HANDLE,
    SequenceNumber: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT {
    omac: D3D11_OMAC,
    QueryType: GUID,
    hChannel: HANDLE,
    SequenceNumber: UINT,
    ReturnCode: HRESULT,
}}
//FIXME bitfield
STRUCT!{struct D3D11_AUTHENTICATED_PROTECTION_FLAGS {
    u: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    ProtectionFlags: D3D11_AUTHENTICATED_PROTECTION_FLAGS,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    ChannelType: D3D11_AUTHENTICATED_CHANNEL_TYPE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    DeviceHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    DecoderHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    DecoderHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    DeviceHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    RestrictedSharedResourceProcessCount: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    ProcessIndex: UINT,
}}
ENUM!{enum D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE {
    DD3D11_PROCESSIDTYPE_UNKNOWN = 0,
    DD3D11_PROCESSIDTYPE_DWM = 1,
    DD3D11_PROCESSIDTYPE_HANDLE = 2,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    ProcessIndex: UINT,
    ProcessIdentifier: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
    ProcessHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    UnrestrictedProtectedSharedResourceCount: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    DeviceHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    DeviceHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    OutputIDCount: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    DeviceHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    OutputIDIndex: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    DeviceHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    OutputIDIndex: UINT,
    OutputID: UINT64,
}}
ENUM!{enum D3D11_BUS_TYPE {
    D3D11_BUS_TYPE_OTHER = 0,
    D3D11_BUS_TYPE_PCI = 0x1,
    D3D11_BUS_TYPE_PCIX = 0x2,
    D3D11_BUS_TYPE_PCIEXPRESS = 0x3,
    D3D11_BUS_TYPE_AGP = 0x4,
    D3D11_BUS_IMPL_MODIFIER_INSIDE_OF_CHIPSET = 0x10000,
    D3D11_BUS_IMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_CHIP = 0x20000,
    D3D11_BUS_IMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_SOCKET = 0x30000,
    D3D11_BUS_IMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR = 0x40000,
    D3D11_BUS_IMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR_INSIDE_OF_NUAE = 0x50000,
    D3D11_BUS_IMPL_MODIFIER_NON_STANDARD = 0x80000000,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_ACESSIBILITY_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    BusType: D3D11_BUS_TYPE,
    AccessibleInContiguousBlocks: BOOL,
    AccessibleInNonContiguousBlocks: BOOL,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    EncryptionGuidCount: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT {
    Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    EncryptionGuidIndex: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    EncryptionGuidIndex: UINT,
    EncryptionGuid: GUID,
}}
STRUCT!{struct D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT {
    Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    EncryptionGuid: GUID,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_INPUT {
    omac: D3D11_OMAC,
    ConfigureType: GUID,
    hChannel: HANDLE,
    SequenceNumber: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {
    omac: D3D11_OMAC,
    ConfigureType: GUID,
    hChannel: HANDLE,
    SequenceNumber: UINT,
    ReturnCode: HRESULT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    StartSequenceQuery: UINT,
    StartSequenceConfigure: UINT,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    Protections: D3D11_AUTHENTICATED_PROTECTION_FLAGS,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    DecoderHandle: HANDLE,
    CryptoSessionHandle: HANDLE,
    DeviceHandle: HANDLE,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    ProcessType: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
    ProcessHandle: HANDLE,
    AllowAccess: BOOL,
}}
STRUCT!{struct D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {
    Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    EncryptionGuid: GUID,
}}
DEFINE_GUID!{D3D11_KEY_EXCHANGE_RSAES_OAEP,
    0xc1949895, 0xd72a, 0x4a1d, 0x8e, 0x5d, 0xed, 0x85, 0x7d, 0x17, 0x15, 0x20}
RIDL!{#[uuid(0x9b32f9ad, 0xbdcc, 0x40a6, 0xa3, 0x9d, 0xd5, 0xc8, 0x65, 0x84, 0x57, 0x20)]
interface ID3D11CryptoSession(ID3D11CryptoSessionVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetCryptoType(
        pCryptoType: *mut GUID,
    ) -> (),
    fn GetDecoderProfile(
        pDecoderProfile: *mut GUID,
    ) -> (),
    fn GetCertificateSize(
        pCertificateSize: *mut UINT,
    ) -> HRESULT,
    fn GetCertificate(
        CertificateSize: UINT,
        pCertificate: *mut BYTE,
    ) -> HRESULT,
    fn GetCryptoSessionHandle(
        pCertificate: *mut HANDLE,
    ) -> (),
}}
ENUM!{enum D3D11_VDOV_DIMENSION {
    D3D11_VDOV_DIMENSION_UNKNOWN = 0,
    D3D11_VDOV_DIMENSION_TEXTURE2D = 1,
}}
STRUCT!{struct D3D11_TEX2D_VDOV {
    ArraySlice: UINT,
}}
STRUCT!{struct D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC {
    DecodeProfile: GUID,
    ViewDimension: D3D11_VDOV_DIMENSION,
    Texture2D: D3D11_TEX2D_VDOV,
}}
RIDL!{#[uuid(0xc2931aea, 0x2a85, 0x4f20, 0x86, 0x0f, 0xfb, 0xa1, 0xfd, 0x25, 0x6e, 0x18)]
interface ID3D11VideoDecoderOutputView(ID3D11VideoDecoderOutputViewVtbl):
    ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC,
    ) -> (),
}}
ENUM!{enum D3D11_VPIV_DIMENSION {
    D3D11_VPIV_DIMENSION_UNKNOWN = 0,
    D3D11_VPIV_DIMENSION_TEXTURE2D = 1,
}}
STRUCT!{struct D3D11_TEX2D_VPIV {
    MipSlice: UINT,
    ArraySlice: UINT,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC {
    FourCC: UINT,
    ViewDimension: D3D11_VPIV_DIMENSION,
    Texture2D: D3D11_TEX2D_VPIV,
}}
RIDL!{#[uuid(0x11ec5a5f, 0x51dc, 0x4945, 0xab, 0x34, 0x6e, 0x8c, 0x21, 0x30, 0x0e, 0xa5)]
interface ID3D11VideoProcessorInputView(ID3D11VideoProcessorInputViewVtbl):
    ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC,
    ) -> (),
}}
ENUM!{enum D3D11_VPOV_DIMENSION {
    D3D11_VPOV_DIMENSION_UNKNOWN = 0,
    D3D11_VPOV_DIMENSION_TEXTURE2D = 1,
    D3D11_VPOV_DIMENSION_TEXTURE2DARRAY = 2,
}}
STRUCT!{struct D3D11_TEX2D_VPOV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D11_TEX2D_ARRAY_VPOV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
UNION!{union D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_u {
    [u32; 3],
    Texture2D Texture2D_mut: D3D11_TEX2D_VPOV,
    Texture2DArray Texture2DArray_mut: D3D11_TEX2D_ARRAY_VPOV,
}}
STRUCT!{struct D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC {
    ViewDimension: D3D11_VPOV_DIMENSION,
    u: D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_u,
}}
RIDL!{#[uuid(0xa048285e, 0x25a9, 0x4527, 0xbd, 0x93, 0xd6, 0x8b, 0x68, 0xc4, 0x42, 0x54)]
interface ID3D11VideoProcessorOutputView(ID3D11VideoProcessorOutputViewVtbl):
    ID3D11View(ID3D11ViewVtbl) {
    fn GetDesc(
        pDesc: *mut D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC,
    ) -> (),
}}
RIDL!{#[uuid(0x61f21c45, 0x3c0e, 0x4a74, 0x9c, 0xea, 0x67, 0x10, 0x0d, 0x9a, 0xd5, 0xe4)]
interface ID3D11VideoContext(ID3D11VideoContextVtbl): ID3D11DeviceChild(ID3D11DeviceChildVtbl) {
    fn GetDecoderBuffer(
        pDecoder: *mut ID3D11VideoDecoder,
        Type: D3D11_VIDEO_DECODER_BUFFER_TYPE,
        pBufferSize: *mut UINT,
        ppBuffer: *mut *mut c_void,
    ) -> HRESULT,
    fn ReleaseDecoderBuffer(
        pDecoder: *mut ID3D11VideoDecoder,
        Type: D3D11_VIDEO_DECODER_BUFFER_TYPE,
    ) -> HRESULT,
    fn DecoderBeginFrame(
        pDecoder: *mut ID3D11VideoDecoder,
        pView: *mut ID3D11VideoDecoderOutputView,
        ContentKeySize: UINT,
        pContentKey: *const c_void,
    ) -> HRESULT,
    fn DecoderEndFrame(
        pDecoder: *mut ID3D11VideoDecoder,
    ) -> HRESULT,
    fn SubmitDecoderBuffers(
        pDecoder: *mut ID3D11VideoDecoder,
        NumBuffers: UINT,
        pBufferDesc: *const D3D11_VIDEO_DECODER_BUFFER_DESC,
    ) -> HRESULT,
    fn DecoderExtension(
        pDecoder: *mut ID3D11VideoDecoder,
        pExtensionData: *const D3D11_VIDEO_DECODER_EXTENSION,
    ) -> HRESULT,
    fn VideoProcessorSetOutputTargetRect(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        Enable: BOOL,
        pRect: *const RECT,
    ) -> (),
    fn VideoProcessorSetOutputBackgroundColor(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        YCbCr: BOOL,
        pRect: *const RECT,
    ) -> (),
    fn VideoProcessorSetOutputColorSpace(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pColorSpace: *const D3D11_VIDEO_PROCESSOR_COLOR_SPACE,
    ) -> HRESULT,
    fn VideoProcessorSetOutputAlphaFillMode(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        AlphaFillMode: D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE,
        StreamIndex: UINT,
    ) -> (),
    fn VideoProcessorSetOutputConstriction(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        Enable: BOOL,
        Size: SIZE,
    ) -> (),
    fn VideoProcessorSetOutputStereoMode(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        Enable: BOOL,
    ) -> (),
    fn VideoProcessorSetOutputExtension(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pExtensionGuid: *const GUID,
        DataSize: UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn VideoProcessorGetOutputTargetRect(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        Enabled: *mut BOOL,
        pRect: *mut RECT,
    ) -> (),
    fn VideoProcessorGetOutputBackgroundColor(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pYCbCr: *mut BOOL,
        pColor: *mut D3D11_VIDEO_COLOR,
    ) -> (),
    fn VideoProcessorGetOutputColorSpace(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pColorSpace: *mut D3D11_VIDEO_PROCESSOR_COLOR_SPACE,
    ) -> (),
    fn VideoProcessorGetOutputAlphaFillMode(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pAlphaFillMode: *mut D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE,
        pStreamIndex: *mut UINT,
    ) -> (),
    fn VideoProcessorGetOutputConstriction(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pEnabled: *mut BOOL,
        pSize: *mut SIZE,
    ) -> (),
    fn VideoProcessorGetOutputStereoMode(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pEnabled: *mut BOOL,
    ) -> (),
    fn VideoProcessorGetOutputExtension(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pExtensionGuid: *const GUID,
        DataSize: UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn VideoProcessorSetStreamFrameFormat(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        FrameFormat: D3D11_VIDEO_FRAME_FORMAT,
    ) -> (),
    fn VideoProcessorSetStreamColorSpace(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pColorSpace: *const D3D11_VIDEO_PROCESSOR_COLOR_SPACE,
    ) -> (),
    fn VideoProcessorSetStreamOutputRate(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        OutputRate: D3D11_VIDEO_PROCESSOR_OUTPUT_RATE,
        RepeatFrame: BOOL,
        pCustomRate: *const DXGI_RATIONAL,
    ) -> (),
    fn VideoProcessorSetStreamSourceRect(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Enable: BOOL,
        pRect: *const RECT,
    ) -> (),
    fn VideoProcessorSetStreamDestRect(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Enable: BOOL,
        pRect: *const RECT,
    ) -> (),
    fn VideoProcessorSetStreamAlpha(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Enable: BOOL,
        Alpha: FLOAT,
    ) -> (),
    fn VideoProcessorSetStreamPalette(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Count: UINT,
        pEntries: *const UINT,
    ) -> (),
    fn VideoProcessorSetStreamPixelAspectRatio(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Enable: BOOL,
        pSourceAspectRatio: *const DXGI_RATIONAL,
        pDestinationAspectRatio: *const DXGI_RATIONAL,
    ) -> (),
    fn VideoProcessorSetStreamLumaKey(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Enable: BOOL,
        Lower: FLOAT,
        Upper: FLOAT,
    ) -> (),
    fn VideoProcessorSetStreamStereoFormat(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Enable: BOOL,
        Format: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT,
        LeftViewFrame0: BOOL,
        BaseViewFrame0: BOOL,
        FlipMode: D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE,
    ) -> (),
    fn VideoProcessorSetStreamAutoProcessingMode(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Enable: BOOL,
    ) -> (),
    fn VideoProcessorSetStreamFilter(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Filter: D3D11_VIDEO_PROCESSOR_FILTER,
        Enable: BOOL,
        Level: c_int,
    ) -> (),
    fn VideoProcessorSetStreamExtension(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pExtensionGuid: *const GUID,
        DataSize: UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn VideoProcessorGetStreamFrameFormat(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pFrameFormat: *mut D3D11_VIDEO_FRAME_FORMAT,
    ) -> (),
    fn VideoProcessorGetStreamColorSpace(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pColorSpace: *mut D3D11_VIDEO_PROCESSOR_COLOR_SPACE,
    ) -> (),
    fn VideoProcessorGetStreamOutputRate(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pOutputRate: *mut D3D11_VIDEO_PROCESSOR_OUTPUT_RATE,
        pRepeatFrame: *mut BOOL,
        pCustomRate: *mut DXGI_RATIONAL,
    ) -> (),
    fn VideoProcessorGetStreamSourceRect(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pEnabled: *mut BOOL,
        pRect: *mut RECT,
    ) -> (),
    fn VideoProcessorGetStreamDestRect(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pEnabled: *mut BOOL,
        pRect: *mut RECT,
    ) -> (),
    fn VideoProcessorGetStreamAlpha(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pEnabled: *mut BOOL,
        pAlpha: *mut FLOAT,
    ) -> (),
    fn VideoProcessorGetStreamPalette(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Count: UINT,
        pEntries: *mut UINT,
    ) -> (),
    fn VideoProcessorGetStreamPixelAspectRatio(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pEnabled: *mut BOOL,
        pSourceAspectRatio: *mut DXGI_RATIONAL,
        pDestinationAspectRatio: *mut DXGI_RATIONAL,
    ) -> (),
    fn VideoProcessorGetStreamLumaKey(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pEnabled: *mut BOOL,
        pLower: *mut FLOAT,
        pUpper: *mut FLOAT,
    ) -> (),
    fn VideoProcessorGetStreamStereoFormat(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pEnabled: *mut BOOL,
        pFormat: *mut D3D11_VIDEO_PROCESSOR_STEREO_FORMAT,
        pLeftViewFrame0: *mut BOOL,
        pBaseViewFrame0: *mut BOOL,
        pFlipMode: *mut D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE,
        MonoOffset: *mut c_int,
    ) -> (),
    fn VideoProcessorGetStreamAutoProcessingMode(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pEnabled: *mut BOOL,
    ) -> (),
    fn VideoProcessorGetStreamFilter(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Filter: D3D11_VIDEO_PROCESSOR_FILTER,
        pEnabled: *mut BOOL,
        pLevel: *mut c_int,
    ) -> (),
    fn VideoProcessorGetStreamExtension(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pExtensionGuid: *const GUID,
        DataSize: UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn VideoProcessorBlt(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        pView: *mut ID3D11VideoProcessorOutputView,
        OutputFrame: UINT,
        StreamCount: UINT,
        pStreams: *const D3D11_VIDEO_PROCESSOR_STREAM,
    ) -> HRESULT,
    fn NegotiateCryptoSessionKeyExchange(
        pCryptoSession: *mut ID3D11CryptoSession,
        DataSize: UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn EncryptionBlt(
        pCryptoSession: *mut ID3D11CryptoSession,
        pSrcSurface: *mut ID3D11Texture2D,
        pDstSurface: *mut ID3D11Texture2D,
        IVSize: UINT,
        pIV: *mut c_void,
    ) -> HRESULT,
    fn DecryptionBlt(
        pCryptoSession: *mut ID3D11CryptoSession,
        pSrcSurface: *mut ID3D11Texture2D,
        pDstSurface: *mut ID3D11Texture2D,
        pEncryptedBlockInfo: *mut D3D11_ENCRYPTED_BLOCK_INFO,
        ContentKeySize: UINT,
        pContentKey: *const c_void,
        IVSize: UINT,
        pIV: *mut c_void,
    ) -> HRESULT,
    fn StartSessionKeyRefresh(
        pCryptoSession: *mut ID3D11CryptoSession,
        RandomNumberSize: UINT,
        pRandomNumber: *mut c_void,
    ) -> HRESULT,
    fn FinishSessionKeyRefresh(
        pCryptoSession: *mut ID3D11CryptoSession,
    ) -> HRESULT,
    fn GetEncryptionBltKey(
        pCryptoSession: *mut ID3D11CryptoSession,
        KeySize: UINT,
        pReadbackKey: *mut c_void,
    ) -> HRESULT,
    fn NegotiateAuthenticatedChannelKeyExchange(
        pChannel: *mut ID3D11AuthenticatedChannel,
        DataSize: UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn QueryAuthenticatedChannel(
        pChannel: *mut ID3D11AuthenticatedChannel,
        InputSize: UINT,
        pInput: *const c_void,
        OutputSize: UINT,
        pOutput: *mut c_void,
    ) -> HRESULT,
    fn ConfigureAuthenticatedChannel(
        pChannel: *mut ID3D11AuthenticatedChannel,
        InputSize: UINT,
        pInput: *const c_void,
        pOutput: *mut D3D11_AUTHENTICATED_CONFIGURE_OUTPUT,
    ) -> HRESULT,
    fn VideoProcessorSetStreamRotation(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        Enable: BOOL,
        Rotation: D3D11_VIDEO_PROCESSOR_ROTATION,
    ) -> HRESULT,
    fn VideoProcessorGetStreamRotation(
        pVideoProcessor: *mut ID3D11VideoProcessor,
        StreamIndex: UINT,
        pEnable: *mut BOOL,
        pRotation: *mut D3D11_VIDEO_PROCESSOR_ROTATION,
    ) -> HRESULT,
}}
RIDL!{#[uuid(0x10ec4d5b, 0x975a, 0x4689, 0xb9, 0xe4, 0xd0, 0xaa, 0xc3, 0x0f, 0xe3, 0x33)]
interface ID3D11VideoDevice(ID3D11VideoDeviceVtbl): IUnknown(IUnknownVtbl) {
    fn CreateVideoDecoder(
        pVideoDesc: *const D3D11_VIDEO_DECODER_DESC,
        pConfig: *const D3D11_VIDEO_DECODER_CONFIG,
        ppDecoder: *mut *mut ID3D11VideoDecoder,
    ) -> HRESULT,
    fn CreateVideoProcessor(
        pEnum: *mut ID3D11VideoProcessorEnumerator,
        RateConversionIndex: UINT,
        ppVideoProcessor: *mut *mut ID3D11VideoProcessor,
    ) -> HRESULT,
    fn CreateAuthenticatedChannel(
        ChannelType: D3D11_AUTHENTICATED_CHANNEL_TYPE,
        ppAuthenticatedChannel: *mut *mut ID3D11AuthenticatedChannel,
    ) -> HRESULT,
    fn CreateCryptoSession(
        pCryptoType: *const GUID,
        pDecoderProfile: *const GUID,
        pKeyExchangeType: *const GUID,
        ppCryptoSession: *mut *mut ID3D11CryptoSession,
    ) -> HRESULT,
    fn CreateVideoDecoderOutputView(
        pResource: *mut ID3D11Resource,
        pDesc: *const D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC,
        ppVDOVView: *mut *mut ID3D11VideoDecoderOutputView,
    ) -> HRESULT,
    fn CreateVideoProcessorInputView(
        pResource: *mut ID3D11Resource,
        pEnum: *mut ID3D11VideoProcessorEnumerator,
        pDesc: *const D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC,
        ppVPIView: *mut *mut ID3D11VideoProcessorInputView,
    ) -> HRESULT,
    fn CreateVideoProcessorOutputView(
        pResource: *mut ID3D11Resource,
        pEnum: *mut ID3D11VideoProcessorEnumerator,
        pDesc: *const D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC,
        ppVPOView: *mut *mut ID3D11VideoProcessorOutputView,
    ) -> HRESULT,
    fn CreateVideoProcessorEnumerator(
        pDesc: *const D3D11_VIDEO_PROCESSOR_CONTENT_DESC,
        ppEnum: *mut *mut ID3D11VideoProcessorEnumerator,
    ) -> HRESULT,
    fn GetVideoDecoderProfileCount() -> UINT,
    fn GetVideoDecoderProfile(
        Index: UINT,
        pDecoderProfile: *mut GUID,
    ) -> HRESULT,
    fn CheckVideoDecoderFormat(
        pDecoderProfile: *const GUID,
        Format: DXGI_FORMAT,
        pSupported: *mut BOOL,
    ) -> HRESULT,
    fn GetVideoDecoderConfigCount(
        pDesc: *const D3D11_VIDEO_DECODER_DESC,
        pCount: *mut UINT,
    ) -> HRESULT,
    fn GetVideoDecoderConfig(
        pDesc: *const D3D11_VIDEO_DECODER_DESC,
        Index: UINT,
        pConfig: *mut D3D11_VIDEO_DECODER_CONFIG,
    ) -> HRESULT,
    fn GetContentProtectionCaps(
        pCryptoType: *const GUID,
        pDecoderProfile: *const GUID,
        pCaps: *mut D3D11_VIDEO_CONTENT_PROTECTION_CAPS,
    ) -> HRESULT,
    fn CheckCryptoKeyExchange(
        pCryptoType: *const GUID,
        pDecoderProfile: *const GUID,
        Index: UINT,
        pKeyExchangeType: *mut GUID,
    ) -> HRESULT,
    fn SetPrivateData(
        guid: REFGUID,
        DataSize: UINT,
        pData: *const c_void,
    ) -> HRESULT,
    fn SetPrivateDataInterface(
        guid: REFGUID,
        pData: *const IUnknown,
    ) -> HRESULT,
}}
RIDL!{#[uuid(0xdb6f6ddb, 0xac77, 0x4e88, 0x82, 0x53, 0x81, 0x9d, 0xf9, 0xbb, 0xf1, 0x40)]
interface ID3D11Device(ID3D11DeviceVtbl): IUnknown(IUnknownVtbl) {
    fn CreateBuffer(
        pDesc: *const D3D11_BUFFER_DESC,
        pInitialData: *const D3D11_SUBRESOURCE_DATA,
        ppBuffer: *mut *mut ID3D11Buffer,
    ) -> HRESULT,
    fn CreateTexture1D(
        pDesc: *const D3D11_TEXTURE1D_DESC,
        pInitialData: *const D3D11_SUBRESOURCE_DATA,
        ppTexture1D: *mut *mut ID3D11Texture1D,
    ) -> HRESULT,
    fn CreateTexture2D(
        pDesc: *const D3D11_TEXTURE2D_DESC,
        pInitialData: *const D3D11_SUBRESOURCE_DATA,
        ppTexture2D: *mut *mut ID3D11Texture2D,
    ) -> HRESULT,
    fn CreateTexture3D(
        pDesc: *const D3D11_TEXTURE3D_DESC,
        pInitialData: *const D3D11_SUBRESOURCE_DATA,
        ppTexture3D: *mut *mut ID3D11Texture3D,
    ) -> HRESULT,
    fn CreateShaderResourceView(
        pResource: *mut ID3D11Resource,
        pDesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
        ppSRView: *mut *mut ID3D11ShaderResourceView,
    ) -> HRESULT,
    fn CreateUnorderedAccessView(
        pResource: *mut ID3D11Resource,
        pDesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
        ppUAView: *mut *mut ID3D11UnorderedAccessView,
    ) -> HRESULT,
    fn CreateRenderTargetView(
        pResource: *mut ID3D11Resource,
        pDesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
        ppRTView: *mut *mut ID3D11RenderTargetView,
    ) -> HRESULT,
    fn CreateDepthStencilView(
        pResource: *mut ID3D11Resource,
        pDesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
        ppDepthStencilView: *mut *mut ID3D11DepthStencilView,
    ) -> HRESULT,
    fn CreateInputLayout(
        pInputElementDescs: *const D3D11_INPUT_ELEMENT_DESC,
        NumElements: UINT,
        pShaderBytecodeWithInputSignature: *const c_void,
        BytecodeLength: SIZE_T,
        ppInputLayout: *mut *mut ID3D11InputLayout,
    ) -> HRESULT,
    fn CreateVertexShader(
        pShaderBytecode: *const c_void,
        BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage,
        ppVertexShader: *mut *mut ID3D11VertexShader,
    ) -> HRESULT,
    fn CreateGeometryShader(
        pShaderBytecode: *const c_void,
        BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage,
        ppGeometryShader: *mut *mut ID3D11GeometryShader,
    ) -> HRESULT,
    fn CreateGeometryShaderWithStreamOutput(
        pShaderBytecode: *const c_void,
        BytecodeLength: SIZE_T,
        pSODeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        NumEntries: UINT,
        pBufferStrides: *const UINT,
        NumStrides: UINT,
        RasterizedStream: UINT,
        pClassLinkage: *mut ID3D11ClassLinkage,
        ppGeometryShader: *mut *mut ID3D11GeometryShader,
    ) -> HRESULT,
    fn CreatePixelShader(
        pShaderBytecode: *const c_void,
        BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage,
        ppPixelShader: *mut *mut ID3D11PixelShader,
    ) -> HRESULT,
    fn CreateHullShader(
        pShaderBytecode: *const c_void,
        BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage,
        ppHullShader: *mut *mut ID3D11HullShader,
    ) -> HRESULT,
    fn CreateDomainShader(
        pShaderBytecode: *const c_void,
        BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage,
        ppDomainShader: *mut *mut ID3D11DomainShader,
    ) -> HRESULT,
    fn CreateComputeShader(
        pShaderBytecode: *const c_void,
        BytecodeLength: SIZE_T,
        pClassLinkage: *mut ID3D11ClassLinkage,
        ppComputeShader: *mut *mut ID3D11ComputeShader,
    ) -> HRESULT,
    fn CreateClassLinkage(
        ppLinkage: *mut *mut ID3D11ClassLinkage,
    ) -> HRESULT,
    fn CreateBlendState(
        pBlendStateDesc: *const D3D11_BLEND_DESC,
        ppBlendState: *mut *mut ID3D11BlendState,
    ) -> HRESULT,
    fn CreateDepthStencilState(
        pDepthStencilDesc: *const D3D11_DEPTH_STENCIL_DESC,
        ppDepthStencilState: *mut *mut ID3D11DepthStencilState,
    ) -> HRESULT,
    fn CreateRasterizerState(
        pRasterizerDesc: *const D3D11_RASTERIZER_DESC,
        ppRasterizerState: *mut *mut ID3D11RasterizerState,
    ) -> HRESULT,
    fn CreateSamplerState(
        pSamplerDesc: *const D3D11_SAMPLER_DESC,
        ppSamplerState: *mut *mut ID3D11SamplerState,
    ) -> HRESULT,
    fn CreateQuery(
        pQueryDesc: *const D3D11_QUERY_DESC,
        ppQuery: *mut *mut ID3D11Query,
    ) -> HRESULT,
    fn CreatePredicate(
        pPredicateDesc: *const D3D11_QUERY_DESC,
        ppPredicate: *mut *mut ID3D11Predicate,
    ) -> HRESULT,
    fn CreateCounter(
        pCounterDesc: *const D3D11_COUNTER_DESC,
        ppCounter: *mut *mut ID3D11Counter,
    ) -> HRESULT,
    fn CreateDeferredContext(
        ContextFlags: UINT,
        ppDeferredContext: *mut *mut ID3D11DeviceContext,
    ) -> HRESULT,
    fn OpenSharedResource(
        hResource: HANDLE,
        ReturnedInterface: REFIID,
        ppResource: *mut *mut c_void,
    ) -> HRESULT,
    fn CheckFormatSupport(
        Format: DXGI_FORMAT,
        pFormatSupport: *mut UINT,
    ) -> HRESULT,
    fn CheckMultisampleQualityLevels(
        Format: DXGI_FORMAT,
        SampleCount: UINT,
        pNumQualityLevels: *mut UINT,
    ) -> HRESULT,
    fn CheckCounterInfo(
        pCounterInfo: *mut D3D11_COUNTER_INFO,
    ) -> (),
    fn CheckCounter(
        pDesc: *const D3D11_COUNTER_DESC,
        pType: *mut D3D11_COUNTER_TYPE,
        pActiveCounters: *mut UINT,
        szName: LPSTR,
        pNameLength: *mut UINT,
        szUnits: LPSTR,
        pUnitsLength: *mut UINT,
        szDescription: LPSTR,
        pDescriptionLength: *mut UINT,
    ) -> HRESULT,
    fn CheckFeatureSupport(
        Feature: D3D11_FEATURE,
        pFeatureSupportData: *mut c_void,
        FeatureSupportDataSize: UINT,
    ) -> HRESULT,
    fn GetPrivateData(
        guid: REFGUID,
        pDataSize: *mut UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn SetPrivateData(
        guid: REFGUID,
        DataSize: UINT,
        pData: *const c_void,
    ) -> HRESULT,
    fn SetPrivateDataInterface(
        guid: REFGUID,
        pData: *const IUnknown,
    ) -> HRESULT,
    fn GetFeatureLevel() -> D3D_FEATURE_LEVEL,
    fn GetCreationFlags() -> UINT,
    fn GetDeviceRemovedReason() -> HRESULT,
    fn GetImmediateContext(
        ppImmediateContext: *mut *mut ID3D11DeviceContext,
    ) -> (),
    fn SetExceptionMode(
        RaiseFlags: UINT,
    ) -> HRESULT,
    fn GetExceptionMode() -> UINT,
}}
ENUM!{enum D3D11_CREATE_DEVICE_FLAG {
    D3D11_CREATE_DEVICE_SINGLETHREADED = 0x1,
    D3D11_CREATE_DEVICE_DEBUG = 0x2,
    D3D11_CREATE_DEVICE_SWITCH_TO_REF = 0x4,
    D3D11_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS = 0x8,
    D3D11_CREATE_DEVICE_BGRA_SUPPORT = 0x20,
    D3D11_CREATE_DEVICE_DEBUGGABLE = 0x40,
    D3D11_CREATE_DEVICE_PREVENT_ALTERING_LAYER_SETTINGS_FROM_REGISTRY = 0x80,
    D3D11_CREATE_DEVICE_DISABLE_GPU_TIMEOUT = 0x100,
    D3D11_CREATE_DEVICE_VIDEO_SUPPORT = 0x800,
}}
pub const D3D11_SDK_VERSION: DWORD = 7;
#[inline]
pub fn D3D11CalcSubresource(MipSlice: UINT, ArraySlice: UINT, MipLevels: UINT) -> UINT {
    MipSlice + ArraySlice * MipLevels
}
extern "system" {
    pub fn D3D11CreateDevice(
        pAdapter: *mut IDXGIAdapter,
        DriverType: D3D_DRIVER_TYPE,
        Software: HMODULE,
        Flags: UINT,
        pFeatureLevels: *const D3D_FEATURE_LEVEL,
        FeatureLevels: UINT,
        SDKVersion: UINT,
        ppDevice: *mut *mut ID3D11Device,
        pFeatureLevel: *mut D3D_FEATURE_LEVEL,
        ppImmediateContext: *mut *mut ID3D11DeviceContext,
    ) -> HRESULT;
    pub fn D3D11CreateDeviceAndSwapChain(
        pAdapter: *mut IDXGIAdapter,
        DriverType: D3D_DRIVER_TYPE,
        Software: HMODULE,
        Flags: UINT,
        pFeatureLevels: *const D3D_FEATURE_LEVEL,
        FeatureLevels: UINT,
        SDKVersion: UINT,
        pSwapChainDesc: *const DXGI_SWAP_CHAIN_DESC,
        ppSwapChain: *mut *mut IDXGISwapChain,
        ppDevice: *mut *mut ID3D11Device,
        pFeatureLevel: *mut D3D_FEATURE_LEVEL,
        ppImmediateContext: *mut *mut ID3D11DeviceContext,
    ) -> HRESULT;
}
DEFINE_GUID!{IID_ID3D11DeviceChild,
    0x1841e5c8, 0x16b0, 0x489b, 0xbc, 0xc8, 0x44, 0xcf, 0xb0, 0xd5, 0xde, 0xae}
DEFINE_GUID!{IID_ID3D11DepthStencilState,
    0x03823efb, 0x8d8f, 0x4e1c, 0x9a, 0xa2, 0xf6, 0x4b, 0xb2, 0xcb, 0xfd, 0xf1}
DEFINE_GUID!{IID_ID3D11BlendState,
    0x75b68faa, 0x347d, 0x4159, 0x8f, 0x45, 0xa0, 0x64, 0x0f, 0x01, 0xcd, 0x9a}
DEFINE_GUID!{IID_ID3D11RasterizerState,
    0x9bb4ab81, 0xab1a, 0x4d8f, 0xb5, 0x06, 0xfc, 0x04, 0x20, 0x0b, 0x6e, 0xe7}
DEFINE_GUID!{IID_ID3D11Resource,
    0xdc8e63f3, 0xd12b, 0x4952, 0xb4, 0x7b, 0x5e, 0x45, 0x02, 0x6a, 0x86, 0x2d}
DEFINE_GUID!{IID_ID3D11Buffer,
    0x48570b85, 0xd1ee, 0x4fcd, 0xa2, 0x50, 0xeb, 0x35, 0x07, 0x22, 0xb0, 0x37}
DEFINE_GUID!{IID_ID3D11Texture1D,
    0xf8fb5c27, 0xc6b3, 0x4f75, 0xa4, 0xc8, 0x43, 0x9a, 0xf2, 0xef, 0x56, 0x4c}
DEFINE_GUID!{IID_ID3D11Texture2D,
    0x6f15aaf2, 0xd208, 0x4e89, 0x9a, 0xb4, 0x48, 0x95, 0x35, 0xd3, 0x4f, 0x9c}
DEFINE_GUID!{IID_ID3D11Texture3D,
    0x037e866e, 0xf56d, 0x4357, 0xa8, 0xaf, 0x9d, 0xab, 0xbe, 0x6e, 0x25, 0x0e}
DEFINE_GUID!{IID_ID3D11View,
    0x839d1216, 0xbb2e, 0x412b, 0xb7, 0xf4, 0xa9, 0xdb, 0xeb, 0xe0, 0x8e, 0xd1}
DEFINE_GUID!{IID_ID3D11ShaderResourceView,
    0xb0e06fe0, 0x8192, 0x4e1a, 0xb1, 0xca, 0x36, 0xd7, 0x41, 0x47, 0x10, 0xb2}
DEFINE_GUID!{IID_ID3D11RenderTargetView,
    0xdfdba067, 0x0b8d, 0x4865, 0x87, 0x5b, 0xd7, 0xb4, 0x51, 0x6c, 0xc1, 0x64}
DEFINE_GUID!{IID_ID3D11DepthStencilView,
    0x9fdac92a, 0x1876, 0x48c3, 0xaf, 0xad, 0x25, 0xb9, 0x4f, 0x84, 0xa9, 0xb6}
DEFINE_GUID!{IID_ID3D11UnorderedAccessView,
    0x28acf509, 0x7f5c, 0x48f6, 0x86, 0x11, 0xf3, 0x16, 0x01, 0x0a, 0x63, 0x80}
DEFINE_GUID!{IID_ID3D11VertexShader,
    0x3b301d64, 0xd678, 0x4289, 0x88, 0x97, 0x22, 0xf8, 0x92, 0x8b, 0x72, 0xf3}
DEFINE_GUID!{IID_ID3D11HullShader,
    0x8e5c6061, 0x628a, 0x4c8e, 0x82, 0x64, 0xbb, 0xe4, 0x5c, 0xb3, 0xd5, 0xdd}
DEFINE_GUID!{IID_ID3D11DomainShader,
    0xf582c508, 0x0f36, 0x490c, 0x99, 0x77, 0x31, 0xee, 0xce, 0x26, 0x8c, 0xfa}
DEFINE_GUID!{IID_ID3D11GeometryShader,
    0x38325b96, 0xeffb, 0x4022, 0xba, 0x02, 0x2e, 0x79, 0x5b, 0x70, 0x27, 0x5c}
DEFINE_GUID!{IID_ID3D11PixelShader,
    0xea82e40d, 0x51dc, 0x4f33, 0x93, 0xd4, 0xdb, 0x7c, 0x91, 0x25, 0xae, 0x8c}
DEFINE_GUID!{IID_ID3D11ComputeShader,
    0x4f5b196e, 0xc2bd, 0x495e, 0xbd, 0x01, 0x1f, 0xde, 0xd3, 0x8e, 0x49, 0x69}
DEFINE_GUID!{IID_ID3D11InputLayout,
    0xe4819ddc, 0x4cf0, 0x4025, 0xbd, 0x26, 0x5d, 0xe8, 0x2a, 0x3e, 0x07, 0xb7}
DEFINE_GUID!{IID_ID3D11SamplerState,
    0xda6fea51, 0x564c, 0x4487, 0x98, 0x10, 0xf0, 0xd0, 0xf9, 0xb4, 0xe3, 0xa5}
DEFINE_GUID!{IID_ID3D11Asynchronous,
    0x4b35d0cd, 0x1e15, 0x4258, 0x9c, 0x98, 0x1b, 0x13, 0x33, 0xf6, 0xdd, 0x3b}
DEFINE_GUID!{IID_ID3D11Query,
    0xd6c00747, 0x87b7, 0x425e, 0xb8, 0x4d, 0x44, 0xd1, 0x08, 0x56, 0x0a, 0xfd}
DEFINE_GUID!{IID_ID3D11Predicate,
    0x9eb576dd, 0x9f77, 0x4d86, 0x81, 0xaa, 0x8b, 0xab, 0x5f, 0xe4, 0x90, 0xe2}
DEFINE_GUID!{IID_ID3D11Counter,
    0x6e8c49fb, 0xa371, 0x4770, 0xb4, 0x40, 0x29, 0x08, 0x60, 0x22, 0xb7, 0x41}
DEFINE_GUID!{IID_ID3D11ClassInstance,
    0xa6cd7faa, 0xb0b7, 0x4a2f, 0x94, 0x36, 0x86, 0x62, 0xa6, 0x57, 0x97, 0xcb}
DEFINE_GUID!{IID_ID3D11ClassLinkage,
    0xddf57cba, 0x9543, 0x46e4, 0xa1, 0x2b, 0xf2, 0x07, 0xa0, 0xfe, 0x7f, 0xed}
DEFINE_GUID!{IID_ID3D11CommandList,
    0xa24bc4d1, 0x769e, 0x43f7, 0x80, 0x13, 0x98, 0xff, 0x56, 0x6c, 0x18, 0xe2}
DEFINE_GUID!{IID_ID3D11DeviceContext,
    0xc0bfa96c, 0xe089, 0x44fb, 0x8e, 0xaf, 0x26, 0xf8, 0x79, 0x61, 0x90, 0xda}
DEFINE_GUID!{IID_ID3D11VideoDecoder,
    0x3c9c5b51, 0x995d, 0x48d1, 0x9b, 0x8d, 0xfa, 0x5c, 0xae, 0xde, 0xd6, 0x5c}
DEFINE_GUID!{IID_ID3D11VideoProcessorEnumerator,
    0x31627037, 0x53ab, 0x4200, 0x90, 0x61, 0x05, 0xfa, 0xa9, 0xab, 0x45, 0xf9}
DEFINE_GUID!{IID_ID3D11VideoProcessor,
    0x1d7b0652, 0x185f, 0x41c6, 0x85, 0xce, 0x0c, 0x5b, 0xe3, 0xd4, 0xae, 0x6c}
DEFINE_GUID!{IID_ID3D11AuthenticatedChannel,
    0x3015a308, 0xdcbd, 0x47aa, 0xa7, 0x47, 0x19, 0x24, 0x86, 0xd1, 0x4d, 0x4a}
DEFINE_GUID!{IID_ID3D11CryptoSession,
    0x9b32f9ad, 0xbdcc, 0x40a6, 0xa3, 0x9d, 0xd5, 0xc8, 0x65, 0x84, 0x57, 0x20}
DEFINE_GUID!{IID_ID3D11VideoDecoderOutputView,
    0xc2931aea, 0x2a85, 0x4f20, 0x86, 0x0f, 0xfb, 0xa1, 0xfd, 0x25, 0x6e, 0x18}
DEFINE_GUID!{IID_ID3D11VideoProcessorInputView,
    0x11ec5a5f, 0x51dc, 0x4945, 0xab, 0x34, 0x6e, 0x8c, 0x21, 0x30, 0x0e, 0xa5}
DEFINE_GUID!{IID_ID3D11VideoProcessorOutputView,
    0xa048285e, 0x25a9, 0x4527, 0xbd, 0x93, 0xd6, 0x8b, 0x68, 0xc4, 0x42, 0x54}
DEFINE_GUID!{IID_ID3D11VideoContext,
    0x61f21c45, 0x3c0e, 0x4a74, 0x9c, 0xea, 0x67, 0x10, 0x0d, 0x9a, 0xd5, 0xe4}
DEFINE_GUID!{IID_ID3D11VideoDevice,
    0x10ec4d5b, 0x975a, 0x4689, 0xb9, 0xe4, 0xd0, 0xaa, 0xc3, 0x0f, 0xe3, 0x33}
DEFINE_GUID!{IID_ID3D11Device,
    0xdb6f6ddb, 0xac77, 0x4e88, 0x82, 0x53, 0x81, 0x9d, 0xf9, 0xbb, 0xf1, 0x40}
