/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Menu
#define GUARD_Menu

#include "GenWindow_Base.h"
#include "GlobalConstants.h"

#include <vector>
#include <string>

using std::vector;
using std::string;

class ItemInfo {
public:
	ItemInfo(): flags(0) {}
	string desc;
	WindowChoice choice;
	int parem;
	int flags;
};

class MenuItem: public ItemInfo {
public:
	MenuItem() {rect.x = 0; rect.y = 0; rect.w = menuItemWidth; rect.h = lineGap;}
	SDL_Rect rect;
};

class MenuChoice: public ItemInfo {
public:
	MenuChoiceType choiceType;
};

class Menu_Base: public GenWindow_Base {
public:
	Menu_Base(int ix, int iy, int iParentID, int flags);

	virtual bool MouseD(Uint8 button, Uint16 x, Uint16 y);
	virtual bool MouseM(Uint8 state, Uint16 x, Uint16 y);
	virtual void DrawSelf();

protected:
	void InitRects();
	void AddItem(MenuItem& tempItem);
	void AddBlankItem();
	void ClearItems() {items.clear(); newItemx = 0; newItemy = 0;}
	virtual bool SwitchOnChoice(Uint16 x, Uint16 y) = 0;

	vector<MenuItem> items;
	MenuChoice currentSelection;
	int highlight;
	int newItemx;
	int newItemy;	
};

class PopupMenu: public Menu_Base {
public:
	PopupMenu(int ix, int iy, int iParentID, int flags);
	
	virtual bool MouseD(Uint8 button, Uint16 x, Uint16 y);
};

class SidePU: public PopupMenu {
public:
	SidePU(int iMySide, int iMyGroup, WindowChoice iChoiceType, int iWhichSaveGroup = 0);

	void DrawSelf();
	void Update();

	bool MouseD(Uint8 button, Uint16 x, Uint16 y);
	virtual bool SwitchOnChoice(Uint16 x, Uint16 y);

	void WinMessage(WindowChoice theMessage, int paremOne, int paremTwo, int targetID, int sourceID);

	static SideInfoType infoType;

protected:
	int mySide;
	int myGroup;
	WindowChoice choiceType;
	int whichSaveGroup;
};

class DeleteBox: public Menu_Base {
public:
	DeleteBox(const string& iFilename, const string& iDirectory, int iParentID);
	bool SwitchOnChoice(Uint16 x, Uint16 y);

protected:
	const string filename;
	const string directory;
};

class FileListMenu: public Menu_Base {
public:
	FileListMenu(int iParentID);
	virtual ~FileListMenu();
	
protected:
	void AddDirectory(const string& directory, const string& findExtension, WindowChoice itemChoice);
	void AddFleets(WindowChoice itemChoice);
	void AddFleetFiles(int whichSide, const string& findExtension, WindowChoice itemChoice);
};



#endif
