/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.XPackFile;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerBase;
import com.izforge.izpack.io.FileSpanningOutputStream;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVolumePackager
extends PackagerBase {
    public static final String INSTALLER_PAK_NAME = "installer";
    private ZipOutputStream primaryJarStream;
    private IXMLElement configdata = null;

    public MultiVolumePackager() throws CompilerException {
        this("default");
    }

    public MultiVolumePackager(String string) throws CompilerException {
        this(string, -1);
    }

    public MultiVolumePackager(String string, int n) throws CompilerException {
        this.initPackCompressor(string, n);
    }

    @Override
    public void createInstaller(File file) throws Exception {
        this.analyzeConfigurationInformation();
        String string = file.getName();
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.length() - 4);
            this.baseFile = new File(file.getParentFile(), string);
        } else {
            this.baseFile = file;
        }
        this.info.setInstallerBase(this.baseFile.getName());
        this.packJarsSeparate = this.info.getWebDirURL() != null;
        this.primaryJarStream = this.getJarOutputStream(this.baseFile.getName() + ".jar");
        this.sendStart();
        this.writeInstaller();
        String string2 = this.baseFile.getParent() + File.separator + INSTALLER_PAK_NAME;
        this.writePacks(new File(string2));
        this.primaryJarStream.close();
        this.sendStop();
    }

    private void analyzeConfigurationInformation() {
        String string = this.getClass().getName();
        String string2 = string + ".volumesize";
        String string3 = string + ".firstvolumefreespace";
        if (this.configdata == null) {
            this.variables.setProperty(string2, Long.toString(650000000L));
            this.variables.setProperty(string3, Long.toString(0L));
        } else {
            String string4 = this.configdata.getAttribute("volumesize", Long.toString(650000000L));
            String string5 = this.configdata.getAttribute("firstvolumefreespace", Long.toString(0L));
            this.variables.setProperty(string2, string4);
            this.variables.setProperty(string3, string5);
        }
    }

    @Override
    protected void writeSkeletonInstaller() throws IOException {
        Object object;
        this.sendMsg("Copying the skeleton installer", 3);
        InputStream inputStream = MultiVolumePackager.class.getResourceAsStream("/lib/installer.jar");
        if (inputStream == null) {
            object = new File(Compiler.IZPACK_HOME, "lib/installer.jar");
            inputStream = new FileInputStream((File)object);
        }
        object = new ZipInputStream(inputStream);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("META-INF.MANIFEST.MF");
        this.copyZipWithoutExcludes((ZipInputStream)object, this.primaryJarStream, arrayList);
        inputStream = MultiVolumePackager.class.getResourceAsStream("/lib/installer.jar");
        if (inputStream == null) {
            File file = new File(Compiler.IZPACK_HOME, "lib/installer.jar");
            inputStream = new FileInputStream(file);
        }
        object = new ZipInputStream(inputStream);
        boolean bl = false;
        java.util.zip.ZipEntry zipEntry = null;
        String string = null;
        while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null && !bl) {
            Object object2;
            if (!"META-INF/MANIFEST.MF".equals(zipEntry.getName())) continue;
            long l = zipEntry.getSize();
            byte[] byArray = new byte[4096];
            int n = 0;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = ((FilterInputStream)object).read(byArray)) > 0 && (long)n2 < l) {
                n2 += n;
                object2 = new String(byArray, 0, n, "utf-8");
                stringBuffer.append((String)object2);
            }
            object2 = new StringReader(stringBuffer.toString());
            BufferedReader bufferedReader = new BufferedReader((Reader)object2);
            String string2 = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("Main-Class:")) {
                    string2 = "Main-Class: com.izforge.izpack.installer.MultiVolumeInstaller";
                }
                stringBuffer2.append(string2);
                stringBuffer2.append("\r\n");
            }
            bufferedReader.close();
            string = stringBuffer2.toString();
            break;
        }
        this.primaryJarStream.putNextEntry(new java.util.zip.ZipEntry("META-INF/MANIFEST.MF"));
        this.primaryJarStream.write(string.getBytes());
        this.primaryJarStream.closeEntry();
    }

    @Override
    protected void writeInstallerObject(String string, Object object) throws IOException {
        this.primaryJarStream.putNextEntry(new java.util.zip.ZipEntry(string));
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.primaryJarStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        this.primaryJarStream.closeEntry();
    }

    @Override
    protected void writeInstallerResources() throws IOException {
        this.sendMsg("Copying " + this.installerResourceURLMap.size() + " files into installer");
        Iterator iterator = this.installerResourceURLMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = (String)iterator.next();
            InputStream inputStream = ((URL)this.installerResourceURLMap.get(string2)).openStream();
            ZipEntry zipEntry = new ZipEntry(string2);
            long l = FileUtil.getFileDateTime((URL)this.installerResourceURLMap.get(string2));
            if (l != -1L) {
                zipEntry.setTime(l);
            }
            this.primaryJarStream.putNextEntry(zipEntry);
            this.copyStream(inputStream, this.primaryJarStream);
            this.primaryJarStream.closeEntry();
            inputStream.close();
        }
    }

    @Override
    protected void writeIncludedJars() throws IOException {
        this.sendMsg("Merging " + this.includedJarURLs.size() + " jars into installer");
        Iterator iterator = this.includedJarURLs.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = (Object[])iterator.next();
            InputStream inputStream = ((URL)objectArray2[0]).openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            this.copyZip(zipInputStream, this.primaryJarStream, (List)objectArray2[1]);
        }
    }

    private void writePacks(File file) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n = this.packsList.size();
        this.sendMsg("Writing " + n + " Pack" + (n > 1 ? "s" : "") + " into installer");
        Debug.trace("Writing " + n + " Pack" + (n > 1 ? "s" : "") + " into installer");
        HashMap hashMap = new HashMap();
        String string = this.getClass().getName();
        String string2 = this.getVariables().getProperty(string + ".volumesize");
        String string3 = this.getVariables().getProperty(string + ".firstvolumefreespace");
        long l = 650000000L;
        long l2 = 0L;
        if (string2 != null) {
            l = Long.parseLong(string2);
        }
        if (string3 != null) {
            l2 = Long.parseLong(string3);
        }
        Debug.trace("Volumesize: " + l);
        Debug.trace("Extra space on first volume: " + l2);
        FileSpanningOutputStream fileSpanningOutputStream = new FileSpanningOutputStream(file.getParent() + File.separator + file.getName() + ".pak", l);
        fileSpanningOutputStream.setFirstvolumefreespacesize(l2);
        int n2 = 0;
        Iterator iterator = this.packsList.iterator();
        while (iterator.hasNext()) {
            object4 = object5 = (PackInfo)iterator.next();
            object3 = ((PackInfo)object4).getPack();
            ((Pack)object3).nbytes = 0L;
            this.sendMsg("Writing Pack " + n2 + ": " + ((Pack)object3).name, 3);
            Debug.trace("Writing Pack " + n2 + ": " + ((Pack)object3).name);
            object2 = new java.util.zip.ZipEntry("packs/pack" + n2);
            this.primaryJarStream.putNextEntry((java.util.zip.ZipEntry)object2);
            object = new ObjectOutputStream(this.primaryJarStream);
            ((ObjectOutputStream)object).writeInt(((PackInfo)object4).getPackFiles().size());
            Iterator iterator2 = ((PackInfo)object4).getPackFiles().iterator();
            for (Object e : ((PackInfo)object4).getPackFiles()) {
                boolean bl = !((Pack)object3).loose;
                PackFile packFile = (PackFile)e;
                XPackFile xPackFile = new XPackFile(packFile);
                File file2 = ((PackInfo)object4).getFile(packFile);
                Debug.trace("Next file: " + file2.getAbsolutePath());
                Object[] objectArray = (Object[])hashMap.get(file2);
                if (objectArray != null && !this.packJarsSeparate) {
                    Debug.trace("File already included in other pack");
                    xPackFile.setPreviousPackFileRef((String)objectArray[0], (Long)objectArray[1]);
                    bl = false;
                }
                if (bl && !xPackFile.isDirectory()) {
                    long l3 = fileSpanningOutputStream.getFilepointer();
                    xPackFile.setArchivefileposition(l3);
                    int n3 = fileSpanningOutputStream.getVolumeCount();
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    long l4 = this.copyStream(fileInputStream, fileSpanningOutputStream);
                    fileSpanningOutputStream.flush();
                    long l5 = fileSpanningOutputStream.getFilepointer();
                    Debug.trace("File (" + xPackFile.sourcePath + ") " + l3 + " <-> " + l5);
                    if (fileSpanningOutputStream.getFilepointer() != l3 + l4) {
                        Debug.trace("file: " + file2.getName());
                        Debug.trace("(Filepos/BytesWritten/ExpectedNewFilePos/NewFilePointer) (" + l3 + "/" + l4 + "/" + (l3 + l4) + "/" + fileSpanningOutputStream.getFilepointer() + ")");
                        Debug.trace("Volumecount (before/after) (" + n3 + "/" + fileSpanningOutputStream.getVolumeCount() + ")");
                        throw new IOException("Error new filepointer is illegal");
                    }
                    if (l4 != xPackFile.length()) {
                        throw new IOException("File size mismatch when reading " + file2);
                    }
                    fileInputStream.close();
                }
                ((ObjectOutputStream)object).writeObject(xPackFile);
                ((ObjectOutputStream)object).flush();
                ((Pack)object3).nbytes += xPackFile.length();
            }
            ((ObjectOutputStream)object).writeInt(((PackInfo)object4).getParsables().size());
            iterator2 = ((PackInfo)object4).getParsables().iterator();
            while (iterator2.hasNext()) {
                ((ObjectOutputStream)object).writeObject(iterator2.next());
            }
            ((ObjectOutputStream)object).writeInt(((PackInfo)object4).getExecutables().size());
            iterator2 = ((PackInfo)object4).getExecutables().iterator();
            while (iterator2.hasNext()) {
                ((ObjectOutputStream)object).writeObject(iterator2.next());
            }
            ((ObjectOutputStream)object).writeInt(((PackInfo)object4).getUpdateChecks().size());
            iterator2 = ((PackInfo)object4).getUpdateChecks().iterator();
            while (iterator2.hasNext()) {
                ((ObjectOutputStream)object).writeObject(iterator2.next());
            }
            ((ObjectOutputStream)object).flush();
            ++n2;
        }
        int n4 = fileSpanningOutputStream.getVolumeCount();
        Debug.trace("Written " + n4 + " volumes");
        object5 = file.getName() + ".pak";
        fileSpanningOutputStream.flush();
        fileSpanningOutputStream.close();
        this.primaryJarStream.putNextEntry(new java.util.zip.ZipEntry("volumes.info"));
        object4 = new ObjectOutputStream(this.primaryJarStream);
        ((ObjectOutputStream)object4).writeInt(n4);
        ((ObjectOutputStream)object4).writeUTF((String)object5);
        ((ObjectOutputStream)object4).flush();
        this.primaryJarStream.closeEntry();
        this.primaryJarStream.putNextEntry(new java.util.zip.ZipEntry("packs.info"));
        object4 = new ObjectOutputStream(this.primaryJarStream);
        ((ObjectOutputStream)object4).writeInt(this.packsList.size());
        object3 = this.packsList.iterator();
        while (object3.hasNext()) {
            object = object2 = (PackInfo)object3.next();
            ((ObjectOutputStream)object4).writeObject(((PackInfo)object).getPack());
        }
        ((ObjectOutputStream)object4).flush();
        this.primaryJarStream.closeEntry();
    }

    private ZipOutputStream getJarOutputStream(String string) throws IOException {
        File file = new File(this.baseFile.getParentFile(), string);
        this.sendMsg("Building installer jar: " + file.getAbsolutePath());
        Debug.trace("Building installer jar: " + file.getAbsolutePath());
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.setLevel(9);
        return zipOutputStream;
    }

    private void copyZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, List<String> list) throws IOException {
        java.util.zip.ZipEntry zipEntry;
        if (!this.alreadyWrittenFiles.containsKey(zipOutputStream)) {
            this.alreadyWrittenFiles.put(zipOutputStream, new HashSet());
        }
        HashSet hashSet = (HashSet)this.alreadyWrittenFiles.get(zipOutputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Object object;
            String string = zipEntry.getName();
            String string2 = string.replace('/', '.');
            string2 = string2.replace('\\', '.');
            if (list != null) {
                object = list.iterator();
                boolean bl = false;
                while (object.hasNext()) {
                    String string3 = object.next();
                    if (!string2.matches(string3)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (hashSet.contains(string)) continue;
            try {
                object = new java.util.zip.ZipEntry(string);
                long l = zipEntry.getTime();
                if (l != -1L) {
                    ((java.util.zip.ZipEntry)object).setTime(l);
                }
                zipOutputStream.putNextEntry((java.util.zip.ZipEntry)object);
                this.copyStream(zipInputStream, zipOutputStream);
                zipOutputStream.closeEntry();
                zipInputStream.closeEntry();
                hashSet.add(string);
            }
            catch (ZipException zipException) {}
        }
    }

    private void copyZipWithoutExcludes(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, List<String> list) throws IOException {
        java.util.zip.ZipEntry zipEntry;
        if (!this.alreadyWrittenFiles.containsKey(zipOutputStream)) {
            this.alreadyWrittenFiles.put(zipOutputStream, new HashSet());
        }
        HashSet hashSet = (HashSet)this.alreadyWrittenFiles.get(zipOutputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Object object;
            String string = zipEntry.getName();
            String string2 = string.replace('/', '.');
            string2 = string2.replace('\\', '.');
            if (list != null) {
                object = list.iterator();
                boolean bl = false;
                while (object.hasNext()) {
                    String string3 = object.next();
                    if (!string2.matches(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
            }
            if (hashSet.contains(string)) continue;
            try {
                object = new java.util.zip.ZipEntry(string);
                long l = zipEntry.getTime();
                if (l != -1L) {
                    ((java.util.zip.ZipEntry)object).setTime(l);
                }
                zipOutputStream.putNextEntry((java.util.zip.ZipEntry)object);
                this.copyStream(zipInputStream, zipOutputStream);
                zipOutputStream.closeEntry();
                zipInputStream.closeEntry();
                hashSet.add(string);
            }
            catch (ZipException zipException) {}
        }
    }

    private long copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[5120];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Override
    public void addConfigurationInformation(IXMLElement iXMLElement) {
        this.configdata = iXMLElement;
    }

    @Override
    protected void writePacks() throws Exception {
    }
}

