import type { BasicTemplateInterpolations, CSSProps } from '../types';
export type KeyframeSteps = string | Record<'from' | 'to' | string, CSSProps<void> | {
    [key: `--${string}`]: CSSProps<void>[keyof CSSProps<void>];
}>;
/**
 * ## Keyframes
 *
 * Define keyframes to be used in a [CSS animation](https://developer.mozilla.org/en-US/docs/Web/CSS/animation).
 * For further details [read the API documentation](https://compiledcssinjs.com/docs/api-keyframes).
 *
 * ### Style with objects
 *
 * @example
 * ```
 * const fadeOut = keyframes({
 *   from: {
 *     opacity: 1,
 *   },
 *   to: {
 *     opacity: 0,
 *   },
 * });
 *
 * <div css={{ animation: `${fadeOut} 2s` }} />
 * ```
 *
 * ### Style with template literals
 *
 * @example
 * ```
 * const fadeOut = keyframes`
 *   from {
 *     opacity: 1;
 *   }
 *
 *   to {
 *     opacity: 0;
 *   }
 * `;
 *
 * <div css={{ animation: `${fadeOut} 2s` }} />
 * ```
 */
export declare function keyframes(steps: KeyframeSteps): string;
export declare function keyframes(strings: TemplateStringsArray, ...interpolations: BasicTemplateInterpolations[]): string;
