import type { Direction, DroppableId, DroppableMode } from 'react-beautiful-dnd';
import type { CleanupFn } from '../internal-types';
export type DroppableRegistryEntry = {
    droppableId: DroppableId;
    isDropDisabled: boolean;
    parentDroppableId: DroppableId | null;
    type: string;
    element: HTMLElement;
    direction: Direction;
    mode: DroppableMode;
};
type Register = (entry: DroppableRegistryEntry) => CleanupFn;
export type GetEntry = ({ droppableId, }: {
    droppableId: DroppableId;
}) => DroppableRegistryEntry | null;
type UpdateListener = (entry: DroppableRegistryEntry) => void;
type SetUpdateListener = (updateListener: UpdateListener) => void;
export type DroppableRegistry = {
    getEntry: GetEntry;
    register: Register;
    setUpdateListener: SetUpdateListener;
};
export declare function useDroppableRegistry(): DroppableRegistry;
export {};
