"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _routerLinkProvider = _interopRequireDefault(require("./router-link-provider"));
var _themeProvider = _interopRequireDefault(require("./theme-provider"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var InsideAppProviderContext = /*#__PURE__*/(0, _react.createContext)(false);
/**
 * __App provider__
 *
 * An app provider provides app level configuration such as global theming.
 *
 * Place it at the root of your application.
 */
function AppProvider(_ref) {
  var children = _ref.children,
    _ref$defaultColorMode = _ref.defaultColorMode,
    defaultColorMode = _ref$defaultColorMode === void 0 ? 'light' : _ref$defaultColorMode,
    defaultTheme = _ref.defaultTheme,
    routerLinkComponent = _ref.routerLinkComponent,
    UNSAFE_isThemingDisabled = _ref.UNSAFE_isThemingDisabled;
  var isInsideAppProvider = (0, _react.useContext)(InsideAppProviderContext);
  if (isInsideAppProvider) {
    throw new Error('App provider should not be nested within another app provider.');
  }
  var routerLinkProvider = /*#__PURE__*/_react.default.createElement(_routerLinkProvider.default, {
    routerLinkComponent: routerLinkComponent
  }, children);
  return /*#__PURE__*/_react.default.createElement(InsideAppProviderContext.Provider, {
    value: true
  }, UNSAFE_isThemingDisabled ? routerLinkProvider : /*#__PURE__*/_react.default.createElement(_themeProvider.default, {
    defaultColorMode: defaultColorMode,
    defaultTheme: defaultTheme
  }, routerLinkProvider));
}
var _default = exports.default = AppProvider;