/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.controller;

import java.util.HashSet;
import java.util.Map;
import org.dbuml.base.model.Column;
import org.dbuml.base.model.DBDependency;
import org.dbuml.base.model.DBDerive;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Database;
import org.dbuml.base.model.FKey;
import org.dbuml.base.model.PKey;
import org.dbuml.base.model.Registry;
import org.dbuml.base.model.Schema;
import org.dbuml.base.model.Table;
import org.dbuml.base.model.View;

public class CreateActions {
    private static final String VARCHAR = "VARCHAR";

    public static Object createRegistry(Object node) {
        Registry registry = new Registry("new_reg");
        registry.setModelElement(node);
        DBModelFacade.getInstance().updateRegistry(registry);
        return node;
    }

    public static Object createDatabase(Object node) {
        Database database = new Database("new_db");
        database.setModelElement(node);
        DBModelFacade.getInstance().updateDatabase(database);
        return node;
    }

    public static Object createSchema(Object node) {
        Schema schema = new Schema("new_sch");
        schema.setModelElement(node);
        DBModelFacade.getInstance().updateSchema(schema);
        return node;
    }

    public static Object createTable(Object node) {
        Table table = new Table("new_tbl");
        table.setModelElement(node);
        DBModelFacade.getInstance().updateTable(table);
        return node;
    }

    public static Object createView(Object node) {
        View view = new View("new_view");
        view.setModelElement(node);
        DBModelFacade.getInstance().updateView(view);
        return node;
    }

    public static Object createColumn(Object node) {
        Column column = new Column("new_col");
        column.setTypeNameJdbc(VARCHAR);
        column.setModelElement(node);
        DBModelFacade.getInstance().updateColumn(column);
        return node;
    }

    public static Object createPKEY(Object node) {
        Column column = new Column("new_col");
        column.setTypeNameJdbc(VARCHAR);
        column.setModelElement(node);
        PKey key = new PKey("", "", "new_col", 1, "new_pk_constraint");
        column.setKey(key);
        DBModelFacade.getInstance().updateColumn(column);
        return node;
    }

    public static Object createFKEY(Object source, Object target, Object assoc) {
        Table sourceTable = DBModelFacade.getInstance().getTable(source);
        Schema sourceSchema = DBModelFacade.getInstance().getSchema(DBModelFacade.getInstance().getParent(sourceTable));
        String sourceSchemaName = null;
        if (sourceSchema != null) {
            sourceSchemaName = sourceSchema.getName();
        }
        Table targetTable = DBModelFacade.getInstance().getTable(target);
        Schema targetSchema = DBModelFacade.getInstance().getSchema(DBModelFacade.getInstance().getParent(targetTable));
        String targetSchemaName = null;
        if (targetSchema != null) {
            targetSchemaName = targetSchema.getName();
        }
        Column pkColumn = new Column("new_pk");
        pkColumn.setTypeNameJdbc(VARCHAR);
        PKey pkey = new PKey("", "", "new_pk", 1, "");
        pkColumn.setKey(pkey);
        targetTable.addColumn(pkColumn);
        DBModelFacade.getInstance().updateTable(targetTable);
        Column fkColumn = new Column("new_fk");
        fkColumn.setTypeNameJdbc(VARCHAR);
        FKey fkey = new FKey(sourceSchemaName, sourceTable.getName(), fkColumn.getName(), 1, "new_fk_constraint");
        fkey.setNativeData(targetSchemaName, targetTable.getName(), pkColumn.getName(), "new_pk_constraint");
        fkey.setUpdateRule("");
        fkey.setDeleteRule("");
        fkColumn.setKey(fkey);
        DBModelFacade.getInstance().addColumn(fkColumn, source);
        fkey.setModelElement(assoc, source, target);
        fkey.setSourceEndStereoString("PK");
        DBModelFacade.getInstance().updateFKey(fkey);
        return assoc;
    }

    public static DBDerive createDBDerive(Object source, Object target, Object dep) {
        DBDerive derive = new DBDerive(dep, source, target);
        derive.setName(DBModelFacade.getInstance().getName(source) + "->" + DBModelFacade.getInstance().getName(target));
        DBModelFacade.getInstance().updateDBDerive(derive);
        return derive;
    }

    public static DBDependency createDBDependency(Object source, Object target, Object dep) {
        DBDependency depend = new DBDependency(dep, source, target);
        DBModelFacade.getInstance().updateDBDependency(depend);
        return depend;
    }

    protected static void createConstraintNotNull(Object tableModel, String[] choices) {
        if (choices != null) {
            for (int i = 0; i < choices.length; ++i) {
                DBModelFacade.getInstance().addConstraintNotNull(choices[i], tableModel);
            }
        }
    }

    protected static void createConstraintUnique(Table table, String[] choices, String indexName) {
        if (choices != null && choices.length >= 1) {
            int i;
            HashSet<String> setOfColumnNames = new HashSet<String>();
            for (i = 0; i < choices.length; ++i) {
                setOfColumnNames.add(choices[i]);
            }
            DBModelFacade.getInstance().addConstraintUnique(table.getModelElement(), setOfColumnNames, indexName);
            for (i = 0; i < choices.length; ++i) {
                Column col = table.getColumn(choices[i]);
                col.setIndexInfo(indexName);
                DBModelFacade.getInstance().updateColumn(col);
            }
        }
    }

    public static void createColumnForView(Object viewModel, Map allBasesColumnsMap, String[] choices) {
        for (int i = 0; i < choices.length; ++i) {
            Column tCol = (Column)allBasesColumnsMap.get(choices[i]);
            Column viewCol = new Column(tCol.getName());
            viewCol.setTypeName(choices[i]);
            viewCol.setJdbcType(tCol.getJdbcType());
            DBModelFacade.getInstance().addColumn(viewCol, viewModel, true);
        }
    }
}

