/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.basic;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTArguments;
import net.sourceforge.pmd.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.Node;

public class BigIntegerInstantiation
extends AbstractRule {
    public Object visit(ASTAllocationExpression node, Object data) {
        ASTArguments args;
        boolean jdk15;
        Node type = node.jjtGetChild(0);
        if (!(type instanceof ASTClassOrInterfaceType)) {
            return super.visit(node, data);
        }
        String img = ((ASTClassOrInterfaceType)type).getImage();
        if (img.startsWith("java.math.")) {
            img = img.substring(10);
        }
        boolean bl = jdk15 = ((RuleContext)data).getSourceType().compareTo(SourceType.JAVA_15) >= 0;
        if (("BigInteger".equals(img) || jdk15 && "BigDecimal".equals(img)) && node.getFirstChildOfType(ASTArrayDimsAndInits.class) == null && (args = node.getFirstChildOfType(ASTArguments.class)).getArgumentCount() == 1) {
            ASTLiteral literal = node.getFirstChildOfType(ASTLiteral.class);
            if (literal == null || literal.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() != args) {
                return super.visit(node, data);
            }
            img = literal.getImage();
            if (img.length() > 2 && img.charAt(0) == '\"') {
                img = img.substring(1, img.length() - 1);
            }
            if ("0".equals(img) || "1".equals(img) || jdk15 && "10".equals(img)) {
                this.addViolation(data, node);
                return data;
            }
        }
        return super.visit(node, data);
    }
}

