/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.report;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.EnumSet;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import jrm.locale.Messages;
import jrm.misc.Settings;
import jrm.profile.report.FilterOptions;
import jrm.profile.scan.Scan;
import jrm.ui.profile.report.ReportTreeCellRenderer;
import jrm.ui.progress.StatusHandler;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.SerializationUtils;

public class ReportFrame
extends JDialog
implements StatusHandler {
    private final JLabel lblStatus = new JLabel("");

    public ReportFrame(Window owner) throws HeadlessException {
        this.setTitle(Messages.getString("ReportFrame.Title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.setProperty("ReportFrame.Bounds", Hex.encodeHexString(SerializationUtils.serialize((Serializable)ReportFrame.this.getBounds())));
            }
        });
        this.setTitle(Messages.getString("ReportFrame.Title"));
        this.setPreferredSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(400, 300));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ReportFrame.class.getResource("/jrm/resources/rom.png")));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{784, 0};
        gridBagLayout.rowHeights = new int[]{280, 24, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        this.getContentPane().add((Component)scrollPane, gbc_scrollPane);
        JTree tree = new JTree();
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setModel(Scan.report.getModel());
        tree.setCellRenderer(new ReportTreeCellRenderer());
        Scan.report.setStatusHandler(this);
        scrollPane.setViewportView(tree);
        JPopupMenu popupMenu = new JPopupMenu();
        ReportFrame.addPopup(tree, popupMenu);
        JMenuItem mntmOpenAllNodes = new JMenuItem(Messages.getString("ReportFrame.mntmOpenAllNodes.text"));
        mntmOpenAllNodes.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/folder_open.png")));
        mntmOpenAllNodes.addActionListener(e -> {
            tree.invalidate();
            int j = tree.getRowCount();
            for (int i = 0; i < j; ++i) {
                tree.expandRow(i);
                j = tree.getRowCount();
            }
            tree.validate();
        });
        popupMenu.add(mntmOpenAllNodes);
        JCheckBoxMenuItem chckbxmntmShowOkEntries = new JCheckBoxMenuItem(Messages.getString("ReportFrame.chckbxmntmShowOkEntries.text"));
        chckbxmntmShowOkEntries.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/folder_closed_green.png")));
        chckbxmntmShowOkEntries.addItemListener(e -> {
            EnumSet<FilterOptions> options = Scan.report.getModel().getFilterOptions();
            if (e.getStateChange() == 1) {
                options.add(FilterOptions.SHOWOK);
            } else {
                options.remove((Object)FilterOptions.SHOWOK);
            }
            Scan.report.getModel().filter(options.toArray(new FilterOptions[0]));
        });
        JMenuItem mntmCloseAllNodes = new JMenuItem(Messages.getString("ReportFrame.mntmCloseAllNodes.text"));
        mntmCloseAllNodes.addActionListener(e -> {
            tree.invalidate();
            int j = tree.getRowCount();
            for (int i = 0; i < j; ++i) {
                tree.collapseRow(i);
                j = tree.getRowCount();
            }
            tree.validate();
        });
        mntmCloseAllNodes.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/folder_closed.png")));
        popupMenu.add(mntmCloseAllNodes);
        popupMenu.add(chckbxmntmShowOkEntries);
        JCheckBoxMenuItem chckbxmntmHideFullyMissing = new JCheckBoxMenuItem(Messages.getString("ReportFrame.chckbxmntmHideFullyMissing.text"));
        chckbxmntmHideFullyMissing.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/folder_closed_red.png")));
        chckbxmntmHideFullyMissing.addItemListener(e -> {
            EnumSet<FilterOptions> options = Scan.report.getModel().getFilterOptions();
            if (e.getStateChange() == 1) {
                options.add(FilterOptions.HIDEMISSING);
            } else {
                options.remove((Object)FilterOptions.HIDEMISSING);
            }
            Scan.report.getModel().filter(options.toArray(new FilterOptions[0]));
        });
        popupMenu.add(chckbxmntmHideFullyMissing);
        GridBagConstraints gbc_lblStatus = new GridBagConstraints();
        gbc_lblStatus.ipadx = 2;
        gbc_lblStatus.insets = new Insets(2, 2, 2, 2);
        gbc_lblStatus.fill = 1;
        gbc_lblStatus.gridx = 0;
        gbc_lblStatus.gridy = 1;
        this.lblStatus.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)this.lblStatus, gbc_lblStatus);
        this.pack();
        try {
            this.setBounds((Rectangle)SerializationUtils.deserialize((byte[])Hex.decodeHex(Settings.getProperty("ReportFrame.Bounds", Hex.encodeHexString(SerializationUtils.serialize((Serializable)new Rectangle(10, 10, 800, 600)))))));
        }
        catch (DecoderException e1) {
            e1.printStackTrace();
        }
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    @Override
    public void setStatus(String text) {
        this.lblStatus.setText(text);
    }
}

