// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package timestamp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/sigstore/timestamp-authority/pkg/generated/models"
)

// GetTimestampResponseReader is a Reader for the GetTimestampResponse structure.
type GetTimestampResponseReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *GetTimestampResponseReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewGetTimestampResponseCreated(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetTimestampResponseBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewGetTimestampResponseNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewGetTimestampResponseDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetTimestampResponseCreated creates a GetTimestampResponseCreated with default headers values
func NewGetTimestampResponseCreated(writer io.Writer) *GetTimestampResponseCreated {
	return &GetTimestampResponseCreated{

		Payload: writer,
	}
}

/*
GetTimestampResponseCreated describes a response with status code 201, with default header values.

Returns a timestamp response and the location of the log entry in the transprency log
*/
type GetTimestampResponseCreated struct {
	Payload io.Writer
}

// IsSuccess returns true when this get timestamp response created response has a 2xx status code
func (o *GetTimestampResponseCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get timestamp response created response has a 3xx status code
func (o *GetTimestampResponseCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get timestamp response created response has a 4xx status code
func (o *GetTimestampResponseCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this get timestamp response created response has a 5xx status code
func (o *GetTimestampResponseCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this get timestamp response created response a status code equal to that given
func (o *GetTimestampResponseCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the get timestamp response created response
func (o *GetTimestampResponseCreated) Code() int {
	return 201
}

func (o *GetTimestampResponseCreated) Error() string {
	return fmt.Sprintf("[POST /api/v1/timestamp][%d] getTimestampResponseCreated", 201)
}

func (o *GetTimestampResponseCreated) String() string {
	return fmt.Sprintf("[POST /api/v1/timestamp][%d] getTimestampResponseCreated", 201)
}

func (o *GetTimestampResponseCreated) GetPayload() io.Writer {
	return o.Payload
}

func (o *GetTimestampResponseCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTimestampResponseBadRequest creates a GetTimestampResponseBadRequest with default headers values
func NewGetTimestampResponseBadRequest() *GetTimestampResponseBadRequest {
	return &GetTimestampResponseBadRequest{}
}

/*
GetTimestampResponseBadRequest describes a response with status code 400, with default header values.

The content supplied to the server was invalid
*/
type GetTimestampResponseBadRequest struct {
	Payload *models.Error
}

// IsSuccess returns true when this get timestamp response bad request response has a 2xx status code
func (o *GetTimestampResponseBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get timestamp response bad request response has a 3xx status code
func (o *GetTimestampResponseBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get timestamp response bad request response has a 4xx status code
func (o *GetTimestampResponseBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get timestamp response bad request response has a 5xx status code
func (o *GetTimestampResponseBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get timestamp response bad request response a status code equal to that given
func (o *GetTimestampResponseBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get timestamp response bad request response
func (o *GetTimestampResponseBadRequest) Code() int {
	return 400
}

func (o *GetTimestampResponseBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/timestamp][%d] getTimestampResponseBadRequest %s", 400, payload)
}

func (o *GetTimestampResponseBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/timestamp][%d] getTimestampResponseBadRequest %s", 400, payload)
}

func (o *GetTimestampResponseBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *GetTimestampResponseBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTimestampResponseNotImplemented creates a GetTimestampResponseNotImplemented with default headers values
func NewGetTimestampResponseNotImplemented() *GetTimestampResponseNotImplemented {
	return &GetTimestampResponseNotImplemented{}
}

/*
GetTimestampResponseNotImplemented describes a response with status code 501, with default header values.

The content requested is not implemented
*/
type GetTimestampResponseNotImplemented struct {
}

// IsSuccess returns true when this get timestamp response not implemented response has a 2xx status code
func (o *GetTimestampResponseNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get timestamp response not implemented response has a 3xx status code
func (o *GetTimestampResponseNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get timestamp response not implemented response has a 4xx status code
func (o *GetTimestampResponseNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this get timestamp response not implemented response has a 5xx status code
func (o *GetTimestampResponseNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this get timestamp response not implemented response a status code equal to that given
func (o *GetTimestampResponseNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the get timestamp response not implemented response
func (o *GetTimestampResponseNotImplemented) Code() int {
	return 501
}

func (o *GetTimestampResponseNotImplemented) Error() string {
	return fmt.Sprintf("[POST /api/v1/timestamp][%d] getTimestampResponseNotImplemented", 501)
}

func (o *GetTimestampResponseNotImplemented) String() string {
	return fmt.Sprintf("[POST /api/v1/timestamp][%d] getTimestampResponseNotImplemented", 501)
}

func (o *GetTimestampResponseNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetTimestampResponseDefault creates a GetTimestampResponseDefault with default headers values
func NewGetTimestampResponseDefault(code int) *GetTimestampResponseDefault {
	return &GetTimestampResponseDefault{
		_statusCode: code,
	}
}

/*
GetTimestampResponseDefault describes a response with status code -1, with default header values.

There was an internal error in the server while processing the request
*/
type GetTimestampResponseDefault struct {
	_statusCode int

	Payload *models.Error
}

// IsSuccess returns true when this get timestamp response default response has a 2xx status code
func (o *GetTimestampResponseDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get timestamp response default response has a 3xx status code
func (o *GetTimestampResponseDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get timestamp response default response has a 4xx status code
func (o *GetTimestampResponseDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get timestamp response default response has a 5xx status code
func (o *GetTimestampResponseDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get timestamp response default response a status code equal to that given
func (o *GetTimestampResponseDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get timestamp response default response
func (o *GetTimestampResponseDefault) Code() int {
	return o._statusCode
}

func (o *GetTimestampResponseDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/timestamp][%d] getTimestampResponse default %s", o._statusCode, payload)
}

func (o *GetTimestampResponseDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/timestamp][%d] getTimestampResponse default %s", o._statusCode, payload)
}

func (o *GetTimestampResponseDefault) GetPayload() *models.Error {
	return o.Payload
}

func (o *GetTimestampResponseDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
