# The following functions are generated by running:
# utils/gen-vowel-constraints.py ms-use/IndicShapingInvalidCluster.txt

from fontFeatures.shaperLib.Buffer import BufferItem

DOTTED_CIRCLE = 0x25CC


def _insert_dotted_circle(buf, index):
    dotted_circle = BufferItem.new_unicode(DOTTED_CIRCLE)
    buf.items.insert(index, dotted_circle)


def preprocess_text_vowel_constraints(buffer):
    if buffer.script == "Devanagari":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x0905:
                if buffer.items[i + 1].codepoint in [
                    0x093A,
                    0x093B,
                    0x093E,
                    0x0945,
                    0x0946,
                    0x0949,
                    0x094A,
                    0x094B,
                    0x094C,
                    0x094F,
                    0x0956,
                    0x0957,
                ]:
                    matched = True
            if buffer.items[i].codepoint == 0x0906:
                if buffer.items[i + 1].codepoint in [
                    0x093A,
                    0x0945,
                    0x0946,
                    0x0947,
                    0x0948,
                ]:
                    matched = True
            if buffer.items[i].codepoint == 0x0909:
                matched = 0x0941 == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x090F:
                if buffer.items[i + 1].codepoint in [0x0945, 0x0946, 0x0947]:
                    matched = True
            if buffer.items[i].codepoint == 0x0930:
                if (
                    0x094D == buffer.items[i + 1].codepoint
                    and i + 2 < len(buffer.items)
                    and 0x0907 == buffer.items[i + 2].codepoint
                ):
                    i = i + 1
                    matched = True
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Bengali":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x0985:
                matched = 0x09BE == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x098B:
                matched = 0x09C3 == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x098C:
                matched = 0x09E2 == buffer.items[i + 1].codepoint
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Gurmukhi":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x0A05:
                if buffer.items[i + 1].codepoint in [0x0A3E, 0x0A48, 0x0A4C]:
                    matched = True
            if buffer.items[i].codepoint == 0x0A72:
                if buffer.items[i + 1].codepoint in [0x0A3F, 0x0A40, 0x0A47]:
                    matched = True
            if buffer.items[i].codepoint == 0x0A73:
                if buffer.items[i + 1].codepoint in [0x0A41, 0x0A42, 0x0A4B]:
                    matched = True
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Gujarati":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x0A85:
                if buffer.items[i + 1].codepoint in [
                    0x0ABE,
                    0x0AC5,
                    0x0AC7,
                    0x0AC8,
                    0x0AC9,
                    0x0ACB,
                    0x0ACC,
                ]:
                    matched = True
            if buffer.items[i].codepoint == 0x0AC5:
                matched = 0x0ABE == buffer.items[i + 1].codepoint
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Oriya":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x0B05:
                matched = 0x0B3E == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint in [0x0B0F, 0x0B13]:
                matched = 0x0B57 == buffer.items[i + 1].codepoint
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Tamil":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if (
                0x0B85 == buffer.items[i].codepoint
                and 0x0BC2 == buffer.items[i + 1].codepoint
            ):
                matched = True
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Telugu":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x0C12:
                if buffer.items[i + 1].codepoint in [0x0C4C, 0x0C55]:
                    matched = True
            if buffer.items[i].codepoint in [0x0C3F, 0x0C46, 0x0C4A]:
                matched = 0x0C55 == buffer.items[i + 1].codepoint
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Kannada":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint in [0x0C89, 0x0C8B]:
                matched = 0x0CBE == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x0C92:
                matched = 0x0CCC == buffer.items[i + 1].codepoint
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Malayalam":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint in [0x0D07, 0x0D09]:
                matched = 0x0D57 == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x0D0E:
                matched = 0x0D46 == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x0D12:
                if buffer.items[i + 1].codepoint in [0x0D3E, 0x0D57]:
                    matched = True
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Sinhala":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x0D85:
                if buffer.items[i + 1].codepoint in [0x0DCF, 0x0DD0, 0x0DD1]:
                    matched = True
            if buffer.items[i].codepoint in [0x0D8B, 0x0D8F, 0x0D94]:
                matched = 0x0DDF == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x0D8D:
                matched = 0x0DD8 == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x0D91:
                if buffer.items[i + 1].codepoint in [
                    0x0DCA,
                    0x0DD9,
                    0x0DDA,
                    0x0DDC,
                    0x0DDD,
                    0x0DDE,
                ]:
                    matched = True
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Brahmi":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x11005:
                matched = 0x11038 == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x1100B:
                matched = 0x1103E == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x1100F:
                matched = 0x11042 == buffer.items[i + 1].codepoint
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Khudawadi":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x112B0:
                if buffer.items[i + 1].codepoint in [
                    0x112E0,
                    0x112E5,
                    0x112E6,
                    0x112E7,
                    0x112E8,
                ]:
                    matched = True
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Tirhuta":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x11481:
                matched = 0x114B0 == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint in [0x1148B, 0x1148D]:
                matched = 0x114BA == buffer.items[i + 1].codepoint
            if buffer.items[i].codepoint == 0x114AA:
                if buffer.items[i + 1].codepoint in [0x114B5, 0x114B6]:
                    matched = True
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Modi":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint in [0x11600, 0x11601]:
                if buffer.items[i + 1].codepoint in [0x11639, 0x1163A]:
                    matched = True
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
    if buffer.script == "Takri":
        i = 0
        while i < len(buffer.items) - 1:
            matched = False
            if buffer.items[i].codepoint == 0x11680:
                if buffer.items[i + 1].codepoint in [0x116AD, 0x116B4, 0x116B5]:
                    matched = True
            if buffer.items[i].codepoint == 0x11686:
                matched = 0x116B2 == buffer.items[i + 1].codepoint
            i = i + 1
            if matched:
                _insert_dotted_circle(buffer, i)
