# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AutoProvisioningSetting(Resource):
    """Auto provisioning setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar auto_provision: Describes what kind of security agent provisioning action to take. Known
     values are: "On" and "Off".
    :vartype auto_provision: str or ~azure.mgmt.security.v2017_08_01_preview.models.AutoProvision
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "auto_provision": {"key": "properties.autoProvision", "type": "str"},
    }

    def __init__(self, *, auto_provision: Optional[Union[str, "_models.AutoProvision"]] = None, **kwargs):
        """
        :keyword auto_provision: Describes what kind of security agent provisioning action to take.
         Known values are: "On" and "Off".
        :paramtype auto_provision: str or ~azure.mgmt.security.v2017_08_01_preview.models.AutoProvision
        """
        super().__init__(**kwargs)
        self.auto_provision = auto_provision


class AutoProvisioningSettingList(_serialization.Model):
    """List of all the auto provisioning settings response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of all the auto provisioning settings.
    :vartype value: list[~azure.mgmt.security.v2017_08_01_preview.models.AutoProvisioningSetting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutoProvisioningSetting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AutoProvisioningSetting"]] = None, **kwargs):
        """
        :keyword value: List of all the auto provisioning settings.
        :paramtype value: list[~azure.mgmt.security.v2017_08_01_preview.models.AutoProvisioningSetting]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2017_08_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2017_08_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Compliance(Resource):
    """Compliance of a scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar assessment_timestamp_utc_date: The timestamp when the Compliance calculation was
     conducted.
    :vartype assessment_timestamp_utc_date: ~datetime.datetime
    :ivar resource_count: The resource count of the given subscription for which the Compliance
     calculation was conducted (needed for Management Group Compliance calculation).
    :vartype resource_count: int
    :ivar assessment_result: An array of segment, which is the actually the compliance assessment.
    :vartype assessment_result:
     list[~azure.mgmt.security.v2017_08_01_preview.models.ComplianceSegment]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "assessment_timestamp_utc_date": {"readonly": True},
        "resource_count": {"readonly": True},
        "assessment_result": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "assessment_timestamp_utc_date": {"key": "properties.assessmentTimestampUtcDate", "type": "iso-8601"},
        "resource_count": {"key": "properties.resourceCount", "type": "int"},
        "assessment_result": {"key": "properties.assessmentResult", "type": "[ComplianceSegment]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.assessment_timestamp_utc_date = None
        self.resource_count = None
        self.assessment_result = None


class ComplianceList(_serialization.Model):
    """List of Compliance objects response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Compliance objects.
    :vartype value: list[~azure.mgmt.security.v2017_08_01_preview.models.Compliance]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Compliance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Compliance"]] = None, **kwargs):
        """
        :keyword value: List of Compliance objects.
        :paramtype value: list[~azure.mgmt.security.v2017_08_01_preview.models.Compliance]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ComplianceSegment(_serialization.Model):
    """A segment of a compliance assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar segment_type: The segment type, e.g. compliant, non-compliance, insufficient coverage,
     N/A, etc.
    :vartype segment_type: str
    :ivar percentage: The size (%) of the segment.
    :vartype percentage: float
    """

    _validation = {
        "segment_type": {"readonly": True},
        "percentage": {"readonly": True},
    }

    _attribute_map = {
        "segment_type": {"key": "segmentType", "type": "str"},
        "percentage": {"key": "percentage", "type": "float"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.segment_type = None
        self.percentage = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class InformationProtectionKeyword(_serialization.Model):
    """The information type keyword.

    :ivar pattern: The keyword pattern.
    :vartype pattern: str
    :ivar custom: Indicates whether the keyword is custom or not.
    :vartype custom: bool
    :ivar can_be_numeric: Indicates whether the keyword can be applied on numeric types or not.
    :vartype can_be_numeric: bool
    :ivar excluded: Indicates whether the keyword is excluded or not.
    :vartype excluded: bool
    """

    _attribute_map = {
        "pattern": {"key": "pattern", "type": "str"},
        "custom": {"key": "custom", "type": "bool"},
        "can_be_numeric": {"key": "canBeNumeric", "type": "bool"},
        "excluded": {"key": "excluded", "type": "bool"},
    }

    def __init__(
        self,
        *,
        pattern: Optional[str] = None,
        custom: Optional[bool] = None,
        can_be_numeric: Optional[bool] = None,
        excluded: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword pattern: The keyword pattern.
        :paramtype pattern: str
        :keyword custom: Indicates whether the keyword is custom or not.
        :paramtype custom: bool
        :keyword can_be_numeric: Indicates whether the keyword can be applied on numeric types or not.
        :paramtype can_be_numeric: bool
        :keyword excluded: Indicates whether the keyword is excluded or not.
        :paramtype excluded: bool
        """
        super().__init__(**kwargs)
        self.pattern = pattern
        self.custom = custom
        self.can_be_numeric = can_be_numeric
        self.excluded = excluded


class InformationProtectionPolicy(Resource):
    """Information protection policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar last_modified_utc: Describes the last UTC time the policy was modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar version: Describes the version of the policy.
    :vartype version: str
    :ivar labels: Dictionary of sensitivity labels.
    :vartype labels: dict[str, ~azure.mgmt.security.v2017_08_01_preview.models.SensitivityLabel]
    :ivar information_types: The sensitivity information types.
    :vartype information_types: dict[str,
     ~azure.mgmt.security.v2017_08_01_preview.models.InformationType]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_modified_utc": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "version": {"key": "properties.version", "type": "str"},
        "labels": {"key": "properties.labels", "type": "{SensitivityLabel}"},
        "information_types": {"key": "properties.informationTypes", "type": "{InformationType}"},
    }

    def __init__(
        self,
        *,
        labels: Optional[Dict[str, "_models.SensitivityLabel"]] = None,
        information_types: Optional[Dict[str, "_models.InformationType"]] = None,
        **kwargs
    ):
        """
        :keyword labels: Dictionary of sensitivity labels.
        :paramtype labels: dict[str, ~azure.mgmt.security.v2017_08_01_preview.models.SensitivityLabel]
        :keyword information_types: The sensitivity information types.
        :paramtype information_types: dict[str,
         ~azure.mgmt.security.v2017_08_01_preview.models.InformationType]
        """
        super().__init__(**kwargs)
        self.last_modified_utc = None
        self.version = None
        self.labels = labels
        self.information_types = information_types


class InformationProtectionPolicyList(_serialization.Model):
    """Information protection policies response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of information protection policies.
    :vartype value:
     list[~azure.mgmt.security.v2017_08_01_preview.models.InformationProtectionPolicy]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InformationProtectionPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.InformationProtectionPolicy"]] = None, **kwargs):
        """
        :keyword value: List of information protection policies.
        :paramtype value:
         list[~azure.mgmt.security.v2017_08_01_preview.models.InformationProtectionPolicy]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class InformationType(_serialization.Model):
    """The information type.

    :ivar display_name: The name of the information type.
    :vartype display_name: str
    :ivar description: The description of the information type.
    :vartype description: str
    :ivar order: The order of the information type.
    :vartype order: int
    :ivar recommended_label_id: The recommended label id to be associated with this information
     type.
    :vartype recommended_label_id: str
    :ivar enabled: Indicates whether the information type is enabled or not.
    :vartype enabled: bool
    :ivar custom: Indicates whether the information type is custom or not.
    :vartype custom: bool
    :ivar keywords: The information type keywords.
    :vartype keywords:
     list[~azure.mgmt.security.v2017_08_01_preview.models.InformationProtectionKeyword]
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "recommended_label_id": {"key": "recommendedLabelId", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "custom": {"key": "custom", "type": "bool"},
        "keywords": {"key": "keywords", "type": "[InformationProtectionKeyword]"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        order: Optional[int] = None,
        recommended_label_id: Optional[str] = None,
        enabled: Optional[bool] = None,
        custom: Optional[bool] = None,
        keywords: Optional[List["_models.InformationProtectionKeyword"]] = None,
        **kwargs
    ):
        """
        :keyword display_name: The name of the information type.
        :paramtype display_name: str
        :keyword description: The description of the information type.
        :paramtype description: str
        :keyword order: The order of the information type.
        :paramtype order: int
        :keyword recommended_label_id: The recommended label id to be associated with this information
         type.
        :paramtype recommended_label_id: str
        :keyword enabled: Indicates whether the information type is enabled or not.
        :paramtype enabled: bool
        :keyword custom: Indicates whether the information type is custom or not.
        :paramtype custom: bool
        :keyword keywords: The information type keywords.
        :paramtype keywords:
         list[~azure.mgmt.security.v2017_08_01_preview.models.InformationProtectionKeyword]
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.order = order
        self.recommended_label_id = recommended_label_id
        self.enabled = enabled
        self.custom = custom
        self.keywords = keywords


class SecurityContact(Resource):
    """Contact details for security issues.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar email: The email of this security contact.
    :vartype email: str
    :ivar phone: The phone number of this security contact.
    :vartype phone: str
    :ivar alert_notifications: Whether to send security alerts notifications to the security
     contact. Known values are: "On" and "Off".
    :vartype alert_notifications: str or
     ~azure.mgmt.security.v2017_08_01_preview.models.AlertNotifications
    :ivar alerts_to_admins: Whether to send security alerts notifications to subscription admins.
     Known values are: "On" and "Off".
    :vartype alerts_to_admins: str or
     ~azure.mgmt.security.v2017_08_01_preview.models.AlertsToAdmins
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "email": {"key": "properties.email", "type": "str"},
        "phone": {"key": "properties.phone", "type": "str"},
        "alert_notifications": {"key": "properties.alertNotifications", "type": "str"},
        "alerts_to_admins": {"key": "properties.alertsToAdmins", "type": "str"},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        phone: Optional[str] = None,
        alert_notifications: Optional[Union[str, "_models.AlertNotifications"]] = None,
        alerts_to_admins: Optional[Union[str, "_models.AlertsToAdmins"]] = None,
        **kwargs
    ):
        """
        :keyword email: The email of this security contact.
        :paramtype email: str
        :keyword phone: The phone number of this security contact.
        :paramtype phone: str
        :keyword alert_notifications: Whether to send security alerts notifications to the security
         contact. Known values are: "On" and "Off".
        :paramtype alert_notifications: str or
         ~azure.mgmt.security.v2017_08_01_preview.models.AlertNotifications
        :keyword alerts_to_admins: Whether to send security alerts notifications to subscription
         admins. Known values are: "On" and "Off".
        :paramtype alerts_to_admins: str or
         ~azure.mgmt.security.v2017_08_01_preview.models.AlertsToAdmins
        """
        super().__init__(**kwargs)
        self.email = email
        self.phone = phone
        self.alert_notifications = alert_notifications
        self.alerts_to_admins = alerts_to_admins


class SecurityContactList(_serialization.Model):
    """List of security contacts response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of security contacts.
    :vartype value: list[~azure.mgmt.security.v2017_08_01_preview.models.SecurityContact]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityContact]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SensitivityLabel(_serialization.Model):
    """The sensitivity label.

    :ivar display_name: The name of the sensitivity label.
    :vartype display_name: str
    :ivar description: The description of the sensitivity label.
    :vartype description: str
    :ivar rank: The rank of the sensitivity label. Known values are: "None", "Low", "Medium",
     "High", and "Critical".
    :vartype rank: str or ~azure.mgmt.security.v2017_08_01_preview.models.Rank
    :ivar order: The order of the sensitivity label.
    :vartype order: int
    :ivar enabled: Indicates whether the label is enabled or not.
    :vartype enabled: bool
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rank": {"key": "rank", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        rank: Optional[Union[str, "_models.Rank"]] = None,
        order: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword display_name: The name of the sensitivity label.
        :paramtype display_name: str
        :keyword description: The description of the sensitivity label.
        :paramtype description: str
        :keyword rank: The rank of the sensitivity label. Known values are: "None", "Low", "Medium",
         "High", and "Critical".
        :paramtype rank: str or ~azure.mgmt.security.v2017_08_01_preview.models.Rank
        :keyword order: The order of the sensitivity label.
        :paramtype order: int
        :keyword enabled: Indicates whether the label is enabled or not.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.rank = rank
        self.order = order
        self.enabled = enabled


class WorkspaceSetting(Resource):
    """Configures where to store the OMS agent data for workspaces under a scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar workspace_id: The full Azure ID of the workspace to save the data in.
    :vartype workspace_id: str
    :ivar scope: All the VMs in this scope will send their security data to the mentioned workspace
     unless overridden by a setting with more specific scope.
    :vartype scope: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "workspace_id": {"key": "properties.workspaceId", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
    }

    def __init__(self, *, workspace_id: Optional[str] = None, scope: Optional[str] = None, **kwargs):
        """
        :keyword workspace_id: The full Azure ID of the workspace to save the data in.
        :paramtype workspace_id: str
        :keyword scope: All the VMs in this scope will send their security data to the mentioned
         workspace unless overridden by a setting with more specific scope.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.workspace_id = workspace_id
        self.scope = scope


class WorkspaceSettingList(_serialization.Model):
    """List of workspace settings response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of workspace settings. Required.
    :vartype value: list[~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkspaceSetting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.WorkspaceSetting"], **kwargs):
        """
        :keyword value: List of workspace settings. Required.
        :paramtype value: list[~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None
