# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ..._operations._operations import (
    build_conversation_authoring_assign_deployment_resources_request,
    build_conversation_authoring_cancel_training_job_request,
    build_conversation_authoring_create_project_request,
    build_conversation_authoring_delete_deployment_from_resources_request,
    build_conversation_authoring_delete_deployment_request,
    build_conversation_authoring_delete_project_request,
    build_conversation_authoring_delete_trained_model_request,
    build_conversation_authoring_deploy_project_request,
    build_conversation_authoring_export_project_request,
    build_conversation_authoring_get_assign_deployment_resources_status_request,
    build_conversation_authoring_get_deployment_delete_from_resources_status_request,
    build_conversation_authoring_get_deployment_job_status_request,
    build_conversation_authoring_get_deployment_request,
    build_conversation_authoring_get_export_project_job_status_request,
    build_conversation_authoring_get_import_project_job_status_request,
    build_conversation_authoring_get_load_snapshot_status_request,
    build_conversation_authoring_get_model_evaluation_summary_request,
    build_conversation_authoring_get_project_deletion_job_status_request,
    build_conversation_authoring_get_project_request,
    build_conversation_authoring_get_swap_deployments_job_status_request,
    build_conversation_authoring_get_trained_model_request,
    build_conversation_authoring_get_training_job_status_request,
    build_conversation_authoring_get_unassign_deployment_resources_status_request,
    build_conversation_authoring_import_project_request,
    build_conversation_authoring_list_assigned_resource_deployments_request,
    build_conversation_authoring_list_deployment_resources_request,
    build_conversation_authoring_list_deployments_request,
    build_conversation_authoring_list_model_evaluation_results_request,
    build_conversation_authoring_list_projects_request,
    build_conversation_authoring_list_supported_languages_request,
    build_conversation_authoring_list_supported_prebuilt_entities_request,
    build_conversation_authoring_list_trained_models_request,
    build_conversation_authoring_list_training_config_versions_request,
    build_conversation_authoring_list_training_jobs_request,
    build_conversation_authoring_load_snapshot_request,
    build_conversation_authoring_swap_deployments_request,
    build_conversation_authoring_train_request,
    build_conversation_authoring_unassign_deployment_resources_request,
)
from .._vendor import ConversationAuthoringClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ConversationAuthoringClientOperationsMixin(
    ConversationAuthoringClientMixinABC
):  # pylint: disable=too-many-public-methods
    @distributed_trace
    def list_projects(
        self, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the existing projects.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/list-projects
        for more information.

        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation", "Orchestration", and "CustomConversationSummarization".
                    "projectName": "str",  # The new project name. Required.
                    "description": "str",  # Optional. The project description.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". The value of the threshold should be between 0 and 1 inclusive.
                          Required.
                    },
                    "storageInputContainerName": "str"  # Optional. The storage container name in
                      case of conversation summarization.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_projects_request(
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_project(
        self, project_name: str, project: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates a new project or updates an existing one.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/create-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project parameters. Required.
        :type project: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                project = {
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation", "Orchestration", and "CustomConversationSummarization".
                    "projectName": "str",  # The new project name. Required.
                    "description": "str",  # Optional. The project description.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". The value of the threshold should be between 0 and 1 inclusive.
                          Required.
                    },
                    "storageInputContainerName": "str"  # Optional. The storage container name in
                      case of conversation summarization.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation", "Orchestration", and "CustomConversationSummarization".
                    "projectName": "str",  # The new project name. Required.
                    "description": "str",  # Optional. The project description.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". The value of the threshold should be between 0 and 1 inclusive.
                          Required.
                    },
                    "storageInputContainerName": "str"  # Optional. The storage container name in
                      case of conversation summarization.
                }
        """

    @overload
    async def create_project(
        self, project_name: str, project: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates a new project or updates an existing one.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/create-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project parameters. Required.
        :type project: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation", "Orchestration", and "CustomConversationSummarization".
                    "projectName": "str",  # The new project name. Required.
                    "description": "str",  # Optional. The project description.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". The value of the threshold should be between 0 and 1 inclusive.
                          Required.
                    },
                    "storageInputContainerName": "str"  # Optional. The storage container name in
                      case of conversation summarization.
                }
        """

    @distributed_trace_async
    async def create_project(self, project_name: str, project: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates a new project or updates an existing one.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/create-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project parameters. Is either a model type or a IO type. Required.
        :type project: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation", "Orchestration", and "CustomConversationSummarization".
                    "projectName": "str",  # The new project name. Required.
                    "description": "str",  # Optional. The project description.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". The value of the threshold should be between 0 and 1 inclusive.
                          Required.
                    },
                    "storageInputContainerName": "str"  # Optional. The storage container name in
                      case of conversation summarization.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(project, (IO, bytes)):
            _content = project
        else:
            _json = project

        request = build_conversation_authoring_create_project_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_project(self, project_name: str, **kwargs: Any) -> JSON:
        """Gets the details of a project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Represents the project creation
                      datetime. Required.
                    "language": "str",  # The project language. This is BCP-47 representation of
                      a language. For example, use "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Represents the project
                      creation datetime. Required.
                    "projectKind": "str",  # Represents the project kind. Required. Known values
                      are: "Conversation", "Orchestration", and "CustomConversationSummarization".
                    "projectName": "str",  # The new project name. Required.
                    "description": "str",  # Optional. The project description.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployed datetime.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last trained datetime.
                    "multilingual": bool,  # Optional. Whether the project would be used for
                      multiple languages or not.
                    "settings": {
                        "confidenceThreshold": 0.0  # The threshold of the intent with the
                          highest confidence, at which the prediction will automatically be changed to
                          "None". The value of the threshold should be between 0 and 1 inclusive.
                          Required.
                    },
                    "storageInputContainerName": "str"  # Optional. The storage container name in
                      case of conversation summarization.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_project_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _delete_project_initial(self, project_name: str, **kwargs: Any) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        request = build_conversation_authoring_delete_project_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def begin_delete_project(self, project_name: str, **kwargs: Any) -> AsyncLROPoller[JSON]:
        """Deletes a project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/delete-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_project_initial(
                project_name=project_name, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _export_project_initial(
        self,
        project_name: str,
        *,
        string_index_type: str,
        exported_project_format: Optional[str] = None,
        asset_kind: Optional[str] = None,
        trained_model_label: Optional[str] = None,
        **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        request = build_conversation_authoring_export_project_request(
            project_name=project_name,
            string_index_type=string_index_type,
            exported_project_format=exported_project_format,
            asset_kind=asset_kind,
            trained_model_label=trained_model_label,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def begin_export_project(
        self,
        project_name: str,
        *,
        string_index_type: str,
        exported_project_format: Optional[str] = None,
        asset_kind: Optional[str] = None,
        trained_model_label: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Triggers a job to export a project's data.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/export
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword string_index_type: Specifies the method used to interpret string offsets. For
         additional information see https://aka.ms/text-analytics-offsets. "Utf16CodeUnit" Required.
        :paramtype string_index_type: str
        :keyword exported_project_format: The format of the exported project file to use. Known values
         are: "Conversation" and "Luis". Default value is None.
        :paramtype exported_project_format: str
        :keyword asset_kind: Kind of asset to export. Default value is None.
        :paramtype asset_kind: str
        :keyword trained_model_label: Trained model label to export. If the trainedModelLabel is null,
         the default behavior is to export the current working copy. Default value is None.
        :paramtype trained_model_label: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "resultUrl": "str",  # Optional. The URL to use in order to download the
                      exported project.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._export_project_initial(
                project_name=project_name,
                string_index_type=string_index_type,
                exported_project_format=exported_project_format,
                asset_kind=asset_kind,
                trained_model_label=trained_model_label,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _import_project_initial(
        self,
        project_name: str,
        project: Union[JSON, IO],
        *,
        exported_project_format: Optional[str] = None,
        **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(project, (IO, bytes)):
            _content = project
        else:
            _json = project

        request = build_conversation_authoring_import_project_request(
            project_name=project_name,
            exported_project_format=exported_project_format,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    async def begin_import_project(
        self,
        project_name: str,
        project: JSON,
        *,
        exported_project_format: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Triggers a job to import a project. If a project with the same name already exists, the data of
        that project is replaced.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/import
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project data to import. Required.
        :type project: JSON
        :keyword exported_project_format: The format of the exported project file to use. Known values
         are: "Conversation" and "Luis". Default value is None.
        :paramtype exported_project_format: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "projectKind":

                # JSON input template for discriminator value "Conversation":
                exported_project_assets = {
                    "projectKind": "Conversation",
                    "entities": [
                        {
                            "category": "str",  # The category of the entity. Required.
                            "compositionSetting": "str",  # Optional. The behavior to
                              follow when the entity's components overlap with each other. Known values
                              are: "returnLongestOverlap", "requireExactOverlap", "separateComponents",
                              and "combineComponents".
                            "list": {
                                "sublists": [
                                    {
                                        "listKey": "str",  # Optional. The
                                          key of the sub-list.
                                        "synonyms": [
                                            {
                                                "language": "str",  #
                                                  Optional. Represents the language of the synonyms.
                                                  This is BCP-47 representation of a language. For
                                                  example, use "en" for English, "en-gb" for English
                                                  (UK), "es" for Spanish etc.
                                                "values": [
                                                    "str"  #
                                                      Optional. The list of synonyms.
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            "prebuilts": [
                                {
                                    "category": "str"  # The prebuilt entity
                                      category. Required.
                                }
                            ],
                            "regex": {
                                "expressions": [
                                    {
                                        "language": "str",  # Optional.
                                          Represents the language of the regex expression. This is
                                          BCP-47 representation of a language. For example, use "en"
                                          for English, "en-gb" for English (UK), "es" for Spanish etc.
                                        "regexKey": "str",  # Optional. The
                                          key of the regex expression.
                                        "regexPattern": "str"  # Optional.
                                          The regex pattern.
                                    }
                                ]
                            },
                            "requiredComponents": [
                                "str"  # Optional. The required components. Allowed
                                  values are 'learned', 'list', 'prebuilts' and 'regex'.
                            ]
                        }
                    ],
                    "intents": [
                        {
                            "category": "str"  # The intent category. Required.
                        }
                    ],
                    "utterances": [
                        {
                            "intent": "str",  # The intent of the utterance. Required.
                            "text": "str",  # The utterance text. Required.
                            "dataset": "str",  # Optional. The dataset for this
                              utterance. Allowed values are 'Train' and 'Test'.
                            "entities": [
                                {
                                    "category": "str",  # The category of the
                                      entity label. Required.
                                    "length": 0,  # Length for the entity text.
                                      Required.
                                    "offset": 0  # Start position for the entity
                                      text. Required.
                                }
                            ],
                            "language": "str"  # Optional. Represents the utterance's
                              language. This is BCP-47 representation of a language. For example, use
                              "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
                        }
                    ]
                }

                # JSON input template for discriminator value "Orchestration":
                exported_project_assets = {
                    "projectKind": "Orchestration",
                    "intents": [
                        {
                            "category": "str",  # The intent category. Required.
                            "orchestration": exported_orchestration_options
                        }
                    ],
                    "utterances": [
                        {
                            "intent": "str",  # The intent of the utterance. Required.
                            "text": "str",  # The utterance text. Required.
                            "dataset": "str",  # Optional. The dataset for this
                              utterance. Allowed values are 'Train' and 'Test'.
                            "language": "str"  # Optional. Represents the utterance's
                              language. This is BCP-47 representation of a language. For example, use
                              "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
                        }
                    ]
                }

                # JSON input template you can fill out and use as your body input.
                project = {
                    "metadata": {
                        "language": "str",  # The project language. This is BCP-47
                          representation of a language. For example, use "en" for English, "en-gb" for
                          English (UK), "es" for Spanish etc. Required.
                        "projectKind": "str",  # Represents the project kind. Required. Known
                          values are: "Conversation", "Orchestration", and
                          "CustomConversationSummarization".
                        "projectName": "str",  # The new project name. Required.
                        "description": "str",  # Optional. The project description.
                        "multilingual": bool,  # Optional. Whether the project would be used
                          for multiple languages or not.
                        "settings": {
                            "confidenceThreshold": 0.0  # The threshold of the intent
                              with the highest confidence, at which the prediction will automatically
                              be changed to "None". The value of the threshold should be between 0 and
                              1 inclusive. Required.
                        },
                        "storageInputContainerName": "str"  # Optional. The storage container
                          name in case of conversation summarization.
                    },
                    "projectFileVersion": "str",  # The version of the exported file. Required.
                    "stringIndexType": "str",  # Specifies the method used to interpret string
                      offsets. For additional information see https://aka.ms/text-analytics-offsets.
                      Required. "Utf16CodeUnit"
                    "assets": exported_project_assets
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @overload
    async def begin_import_project(
        self,
        project_name: str,
        project: IO,
        *,
        exported_project_format: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Triggers a job to import a project. If a project with the same name already exists, the data of
        that project is replaced.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/import
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project data to import. Required.
        :type project: IO
        :keyword exported_project_format: The format of the exported project file to use. Known values
         are: "Conversation" and "Luis". Default value is None.
        :paramtype exported_project_format: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_import_project(
        self,
        project_name: str,
        project: Union[JSON, IO],
        *,
        exported_project_format: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Triggers a job to import a project. If a project with the same name already exists, the data of
        that project is replaced.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/import
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param project: The project data to import. Is either a model type or a IO type. Required.
        :type project: JSON or IO
        :keyword exported_project_format: The format of the exported project file to use. Known values
         are: "Conversation" and "Luis". Default value is None.
        :paramtype exported_project_format: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._import_project_initial(
                project_name=project_name,
                project=project,
                exported_project_format=exported_project_format,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _train_initial(self, project_name: str, configuration: Union[JSON, IO], **kwargs: Any) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(configuration, (IO, bytes)):
            _content = configuration
        else:
            _json = configuration

        request = build_conversation_authoring_train_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    async def begin_train(
        self, project_name: str, configuration: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Triggers a training job for a project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/train
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param configuration: The training input parameters. Required.
        :type configuration: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                configuration = {
                    "modelLabel": "str",  # Represents the output model label. Required.
                    "trainingMode": "str",  # Represents the mode of the training operation.
                      Required. Known values are: "advanced" and "standard".
                    "evaluationOptions": {
                        "kind": "str",  # Optional. Represents the evaluation kind. By
                          default, the evaluation kind is set to percentage. Known values are:
                          "percentage" and "manual".
                        "testingSplitPercentage": 0,  # Optional. Represents the testing
                          dataset split percentage. Only needed in case the evaluation kind is
                          percentage.
                        "trainingSplitPercentage": 0  # Optional. Represents the training
                          dataset split percentage. Only needed in case the evaluation kind is
                          percentage.
                    },
                    "trainingConfigVersion": "str"  # Optional. Represents training config
                      version. By default, "latest" value is used which uses the latest released
                      training config version.
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "trainingMode": "str"  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @overload
    async def begin_train(
        self, project_name: str, configuration: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Triggers a training job for a project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/train
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param configuration: The training input parameters. Required.
        :type configuration: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "trainingMode": "str"  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_train(
        self, project_name: str, configuration: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Triggers a training job for a project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/train
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param configuration: The training input parameters. Is either a model type or a IO type.
         Required.
        :type configuration: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "trainingMode": "str"  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._train_initial(
                project_name=project_name,
                configuration=configuration,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_deployments(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the deployments belonging to a project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/list-deployments
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str",  # Represents model training config
                      version. Required.
                    "assignedResources": [
                        {
                            "region": "str",  # Represents the resource region. Required.
                            "resourceId": "str"  # Represents the Azure resource Id.
                              Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_deployments_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _swap_deployments_initial(
        self, project_name: str, deployments: Union[JSON, IO], **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployments, (IO, bytes)):
            _content = deployments
        else:
            _json = deployments

        request = build_conversation_authoring_swap_deployments_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    async def begin_swap_deployments(
        self, project_name: str, deployments: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Swaps two existing deployments with each other.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/swap-deployments
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployments: The job object to swap two deployments. Required.
        :type deployments: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                deployments = {
                    "firstDeploymentName": "str",  # Represents the first deployment name.
                      Required.
                    "secondDeploymentName": "str"  # Represents the second deployment name.
                      Required.
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @overload
    async def begin_swap_deployments(
        self, project_name: str, deployments: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Swaps two existing deployments with each other.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/swap-deployments
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployments: The job object to swap two deployments. Required.
        :type deployments: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_swap_deployments(
        self, project_name: str, deployments: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Swaps two existing deployments with each other.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/swap-deployments
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployments: The job object to swap two deployments. Is either a model type or a IO
         type. Required.
        :type deployments: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._swap_deployments_initial(
                project_name=project_name,
                deployments=deployments,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_deployment(self, project_name: str, deployment_name: str, **kwargs: Any) -> JSON:
        """Gets the details of a deployment.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-deployment
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str",  # Represents model training config
                      version. Required.
                    "assignedResources": [
                        {
                            "region": "str",  # Represents the resource region. Required.
                            "resourceId": "str"  # Represents the Azure resource Id.
                              Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_deployment_request(
            project_name=project_name,
            deployment_name=deployment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _deploy_project_initial(
        self, project_name: str, deployment_name: str, deployment: Union[JSON, IO], **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment, (IO, bytes)):
            _content = deployment
        else:
            _json = deployment

        request = build_conversation_authoring_deploy_project_request(
            project_name=project_name,
            deployment_name=deployment_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    async def begin_deploy_project(
        self,
        project_name: str,
        deployment_name: str,
        deployment: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates a new deployment or replaces an existing one.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/deploy-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param deployment: The new deployment info. Required.
        :type deployment: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                deployment = {
                    "trainedModelLabel": "str",  # Represents the trained model label. Required.
                    "assignedResourceIds": [
                        "str"  # Optional. Represents the resource IDs to be assigned to the
                          deployment."n            If provided, the deployment will be rolled out to
                          the resources provided here as well as the original resource in which the
                          project is created.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str",  # Represents model training config
                      version. Required.
                    "assignedResources": [
                        {
                            "region": "str",  # Represents the resource region. Required.
                            "resourceId": "str"  # Represents the Azure resource Id.
                              Required.
                        }
                    ]
                }
        """

    @overload
    async def begin_deploy_project(
        self,
        project_name: str,
        deployment_name: str,
        deployment: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates a new deployment or replaces an existing one.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/deploy-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param deployment: The new deployment info. Required.
        :type deployment: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str",  # Represents model training config
                      version. Required.
                    "assignedResources": [
                        {
                            "region": "str",  # Represents the resource region. Required.
                            "resourceId": "str"  # Represents the Azure resource Id.
                              Required.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_deploy_project(
        self, project_name: str, deployment_name: str, deployment: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Creates a new deployment or replaces an existing one.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/deploy-project
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param deployment: The new deployment info. Is either a model type or a IO type. Required.
        :type deployment: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentExpirationDate": "2020-02-20",  # Represents deployment expiration
                      date in the runtime. Required.
                    "deploymentName": "str",  # Represents deployment name. Required.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      deployed time. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # Represents deployment last
                      trained time. Required.
                    "modelId": "str",  # Represents deployment modelId. Required.
                    "modelTrainingConfigVersion": "str",  # Represents model training config
                      version. Required.
                    "assignedResources": [
                        {
                            "region": "str",  # Represents the resource region. Required.
                            "resourceId": "str"  # Represents the Azure resource Id.
                              Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._deploy_project_initial(
                project_name=project_name,
                deployment_name=deployment_name,
                deployment=deployment,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _delete_deployment_initial(
        self, project_name: str, deployment_name: str, **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        request = build_conversation_authoring_delete_deployment_request(
            project_name=project_name,
            deployment_name=deployment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def begin_delete_deployment(
        self, project_name: str, deployment_name: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Deletes a project deployment.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/delete-deployment
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_deployment_initial(
                project_name=project_name,
                deployment_name=deployment_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _delete_deployment_from_resources_initial(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, deployment_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_conversation_authoring_delete_deployment_from_resources_request(
            project_name=project_name,
            deployment_name=deployment_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["operation-location"] = self._deserialize("str", response.headers.get("operation-location"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @overload
    async def begin_delete_deployment_from_resources(
        self,
        project_name: str,
        deployment_name: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a project deployment from the specified assigned resources.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/delete-deployment-from-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param body: The options for deleting the deployment. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "assignedResourceIds": [
                        "str"  # Optional. Represents the resource IDs to delete the
                          deployment from."n            If not provided, the deployment will be rolled
                          out from all the resources it is deployed to."n            If provided, it
                          will delete the deployment only from the specified assigned resources, and
                          leave it for the rest.
                    ]
                }
        """

    @overload
    async def begin_delete_deployment_from_resources(
        self,
        project_name: str,
        deployment_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a project deployment from the specified assigned resources.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/delete-deployment-from-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param body: The options for deleting the deployment. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_delete_deployment_from_resources(
        self, project_name: str, deployment_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a project deployment from the specified assigned resources.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/delete-deployment-from-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param body: The options for deleting the deployment. Is either a model type or a IO type.
         Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_deployment_from_resources_initial(  # type: ignore
                project_name=project_name,
                deployment_name=deployment_name,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_deployment_delete_from_resources_status(
        self, project_name: str, deployment_name: str, job_id: str, **kwargs: Any
    ) -> JSON:
        """Gets the status of an existing delete deployment from specific resources job.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-deployment-delete-from-resources-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_deployment_delete_from_resources_status_request(
            project_name=project_name,
            deployment_name=deployment_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_deployment_job_status(
        self, project_name: str, deployment_name: str, job_id: str, **kwargs: Any
    ) -> JSON:
        """Gets the status of an existing deployment job.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-deployment-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use. Required.
        :type deployment_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_deployment_job_status_request(
            project_name=project_name,
            deployment_name=deployment_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_swap_deployments_job_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an existing swap deployment job.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-swap-deployments-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_swap_deployments_job_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_export_project_job_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an export job. Once job completes, returns the project metadata, and assets.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-export-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "resultUrl": "str",  # Optional. The URL to use in order to download the
                      exported project.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_export_project_job_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_import_project_job_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status for an import.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-import-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_import_project_job_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_trained_models(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the trained models belonging to a project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/list-trained-models
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "label": "str",  # The trained model label. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # The last trained date time
                      of the model. Required.
                    "lastTrainingDurationInSeconds": 0,  # The duration of the model's last
                      training request in seconds. Required.
                    "modelExpirationDate": "2020-02-20",  # The model expiration date. Required.
                    "modelId": "str",  # The model ID. Required.
                    "modelTrainingConfigVersion": "str",  # The model training config version.
                      Required.
                    "hasSnapshot": bool  # Optional. The flag to indicate if the trained model
                      has a snapshot ready.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_trained_models_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_trained_model(self, project_name: str, trained_model_label: str, **kwargs: Any) -> JSON:
        """Gets the details of a trained model.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-trained-model
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "label": "str",  # The trained model label. Required.
                    "lastTrainedDateTime": "2020-02-20 00:00:00",  # The last trained date time
                      of the model. Required.
                    "lastTrainingDurationInSeconds": 0,  # The duration of the model's last
                      training request in seconds. Required.
                    "modelExpirationDate": "2020-02-20",  # The model expiration date. Required.
                    "modelId": "str",  # The model ID. Required.
                    "modelTrainingConfigVersion": "str",  # The model training config version.
                      Required.
                    "hasSnapshot": bool  # Optional. The flag to indicate if the trained model
                      has a snapshot ready.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_trained_model_request(
            project_name=project_name,
            trained_model_label=trained_model_label,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_trained_model(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, trained_model_label: str, **kwargs: Any
    ) -> None:
        """Deletes an existing trained model.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/delete-trained-model
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_conversation_authoring_delete_trained_model_request(
            project_name=project_name,
            trained_model_label=trained_model_label,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    async def _load_snapshot_initial(
        self, project_name: str, trained_model_label: str, **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        request = build_conversation_authoring_load_snapshot_request(
            project_name=project_name,
            trained_model_label=trained_model_label,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def begin_load_snapshot(
        self, project_name: str, trained_model_label: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Restores the snapshot of this trained model to be the current working directory of the project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/load-snapshot
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._load_snapshot_initial(
                project_name=project_name,
                trained_model_label=trained_model_label,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_model_evaluation_results(
        self,
        project_name: str,
        trained_model_label: str,
        *,
        string_index_type: str,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Gets the detailed results of the evaluation for a trained model. This includes the raw
        inference results for the data included in the evaluation process.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-model-evaluation-results
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :keyword string_index_type: Specifies the method used to interpret string offsets. For
         additional information see https://aka.ms/text-analytics-offsets. "Utf16CodeUnit" Required.
        :paramtype string_index_type: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entitiesResult": {
                        "expectedEntities": [
                            {
                                "category": "str",  # Represents the entity category.
                                  Required.
                                "length": 0,  # Represents the entity length.
                                  Required.
                                "offset": 0  # Represents the entity offset index
                                  relative to the original text. Required.
                            }
                        ],
                        "predictedEntities": [
                            {
                                "category": "str",  # Represents the entity category.
                                  Required.
                                "length": 0,  # Represents the entity length.
                                  Required.
                                "offset": 0  # Represents the entity offset index
                                  relative to the original text. Required.
                            }
                        ]
                    },
                    "intentsResult": {
                        "expectedIntent": "str",  # Represents the utterance's expected
                          intent. Required.
                        "predictedIntent": "str"  # Represents the utterance's predicted
                          intent. Required.
                    },
                    "language": "str",  # Represents the utterance language. This is BCP-47
                      representation of a language. For example, use "en" for English, "en-gb" for
                      English (UK), "es" for Spanish etc. Required.
                    "text": "str"  # Represents the utterance text. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_model_evaluation_results_request(
                    project_name=project_name,
                    trained_model_label=trained_model_label,
                    string_index_type=string_index_type,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_model_evaluation_summary(self, project_name: str, trained_model_label: str, **kwargs: Any) -> JSON:
        """Gets the evaluation summary of a trained model. The summary includes high level performance
        measurements of the model e.g., F1, Precision, Recall, etc.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-model-evaluation-summary
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entitiesEvaluation": {
                        "confusionMatrix": {
                            "str": {
                                "str": {
                                    "normalizedValue": 0.0,  # Represents
                                      normalized value in percentages. Required.
                                    "rawValue": 0.0  # Represents raw value.
                                      Required.
                                }
                            }
                        },
                        "entities": {
                            "str": {
                                "f1": 0.0,  # Represents the model precision.
                                  Required.
                                "falseNegativeCount": 0,  # Represents the count of
                                  false negative. Required.
                                "falsePositiveCount": 0,  # Represents the count of
                                  false positive. Required.
                                "precision": 0.0,  # Represents the model recall.
                                  Required.
                                "recall": 0.0,  # Represents the model F1 score.
                                  Required.
                                "trueNegativeCount": 0,  # Represents the count of
                                  true negative. Required.
                                "truePositiveCount": 0  # Represents the count of
                                  true positive. Required.
                            }
                        },
                        "macroF1": 0.0,  # Represents the macro F1. Required.
                        "macroPrecision": 0.0,  # Represents the macro precision. Required.
                        "macroRecall": 0.0,  # Represents the macro recall. Required.
                        "microF1": 0.0,  # Represents the micro F1. Required.
                        "microPrecision": 0.0,  # Represents the micro precision. Required.
                        "microRecall": 0.0  # Represents the micro recall. Required.
                    },
                    "intentsEvaluation": {
                        "confusionMatrix": {
                            "str": {
                                "str": {
                                    "normalizedValue": 0.0,  # Represents
                                      normalized value in percentages. Required.
                                    "rawValue": 0.0  # Represents raw value.
                                      Required.
                                }
                            }
                        },
                        "intents": {
                            "str": {
                                "f1": 0.0,  # Represents the model precision.
                                  Required.
                                "falseNegativeCount": 0,  # Represents the count of
                                  false negative. Required.
                                "falsePositiveCount": 0,  # Represents the count of
                                  false positive. Required.
                                "precision": 0.0,  # Represents the model recall.
                                  Required.
                                "recall": 0.0,  # Represents the model F1 score.
                                  Required.
                                "trueNegativeCount": 0,  # Represents the count of
                                  true negative. Required.
                                "truePositiveCount": 0  # Represents the count of
                                  true positive. Required.
                            }
                        },
                        "macroF1": 0.0,  # Represents the macro F1. Required.
                        "macroPrecision": 0.0,  # Represents the macro precision. Required.
                        "macroRecall": 0.0,  # Represents the macro recall. Required.
                        "microF1": 0.0,  # Represents the micro F1. Required.
                        "microPrecision": 0.0,  # Represents the micro precision. Required.
                        "microRecall": 0.0  # Represents the micro recall. Required.
                    },
                    "evaluationOptions": {
                        "kind": "str",  # Optional. Represents the evaluation kind. By
                          default, the evaluation kind is set to percentage. Known values are:
                          "percentage" and "manual".
                        "testingSplitPercentage": 0,  # Optional. Represents the testing
                          dataset split percentage. Only needed in case the evaluation kind is
                          percentage.
                        "trainingSplitPercentage": 0  # Optional. Represents the training
                          dataset split percentage. Only needed in case the evaluation kind is
                          percentage.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_model_evaluation_summary_request(
            project_name=project_name,
            trained_model_label=trained_model_label,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_load_snapshot_status(
        self, project_name: str, trained_model_label: str, job_id: str, **kwargs: Any
    ) -> JSON:
        """Gets the status for loading a snapshot.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-load-snapshot-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param trained_model_label: The trained model label. Required.
        :type trained_model_label: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_load_snapshot_status_request(
            project_name=project_name,
            trained_model_label=trained_model_label,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_deployment_resources(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the deployments resources assigned to the project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/list-deployment-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "azureResourceId": "str",  # The resource ID. Required.
                    "region": "str"  # The resource region. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_deployment_resources_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _assign_deployment_resources_initial(
        self, project_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_conversation_authoring_assign_deployment_resources_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    async def begin_assign_deployment_resources(
        self, project_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Assign new Azure resources to a project to allow deploying new deployments to them. This API is
        available only via AAD authentication and not supported via subscription key authentication.
        For more details about AAD authentication, check here:
        https://learn.microsoft.com/en-us/azure/cognitive-services/authentication?tabs=powershell#authenticate-with-azure-active-directory

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/assign-deployment-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: The new project resources info. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "resourcesMetadata": [
                        {
                            "azureResourceId": "str",  # Represents the Azure resource
                              ID. Required.
                            "customDomain": "str",  # Represents the Azure resource
                              custom domain. Required.
                            "region": "str"  # Represents the Azure resource region.
                              Required.
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @overload
    async def begin_assign_deployment_resources(
        self, project_name: str, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Assign new Azure resources to a project to allow deploying new deployments to them. This API is
        available only via AAD authentication and not supported via subscription key authentication.
        For more details about AAD authentication, check here:
        https://learn.microsoft.com/en-us/azure/cognitive-services/authentication?tabs=powershell#authenticate-with-azure-active-directory

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/assign-deployment-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: The new project resources info. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_assign_deployment_resources(
        self, project_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Assign new Azure resources to a project to allow deploying new deployments to them. This API is
        available only via AAD authentication and not supported via subscription key authentication.
        For more details about AAD authentication, check here:
        https://learn.microsoft.com/en-us/azure/cognitive-services/authentication?tabs=powershell#authenticate-with-azure-active-directory

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/assign-deployment-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: The new project resources info. Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._assign_deployment_resources_initial(
                project_name=project_name,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _unassign_deployment_resources_initial(
        self, project_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_conversation_authoring_unassign_deployment_resources_request(
            project_name=project_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    async def begin_unassign_deployment_resources(
        self, project_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Unassign resources from a project. This disallows deploying new deployments to these resources,
        and deletes existing deployments assigned to them.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/unassign-deployment-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: The info for the deployment resources to be deleted. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "assignedResourceIds": [
                        "str"  # Represents the assigned resource IDs to be unassigned.
                          Required.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @overload
    async def begin_unassign_deployment_resources(
        self, project_name: str, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Unassign resources from a project. This disallows deploying new deployments to these resources,
        and deletes existing deployments assigned to them.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/unassign-deployment-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: The info for the deployment resources to be deleted. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def begin_unassign_deployment_resources(
        self, project_name: str, body: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Unassign resources from a project. This disallows deploying new deployments to these resources,
        and deletes existing deployments assigned to them.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/unassign-deployment-resources
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param body: The info for the deployment resources to be deleted. Is either a model type or a
         IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._unassign_deployment_resources_initial(
                project_name=project_name,
                body=body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_assign_deployment_resources_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an existing assign deployment resources job.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-assign-deployment-resources-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_assign_deployment_resources_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_unassign_deployment_resources_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an existing unassign deployment resources job.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-unassign-deployment-resources-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_unassign_deployment_resources_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_training_jobs(
        self, project_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the non-expired training jobs created for a project.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/list-training-jobs
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "trainingMode": "str"  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_training_jobs_request(
                    project_name=project_name,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_training_job_status(self, project_name: str, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status for a training job.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-training-status
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "trainingMode": "str"  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_training_job_status_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _cancel_training_job_initial(self, project_name: str, job_id: str, **kwargs: Any) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        request = build_conversation_authoring_cancel_training_job_request(
            project_name=project_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["operation-location"] = self._deserialize(
                "str", response.headers.get("operation-location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace_async
    async def begin_cancel_training_job(self, project_name: str, job_id: str, **kwargs: Any) -> AsyncLROPoller[JSON]:
        """Triggers a cancellation for a running training job.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/cancel-training-job
        for more information.

        :param project_name: The name of the project to use. Required.
        :type project_name: str
        :param job_id: The job ID. Required.
        :type job_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "result": {
                        "modelLabel": "str",  # Represents trained model label. Required.
                        "trainingConfigVersion": "str",  # Represents training config
                          version. Required.
                        "trainingStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "estimatedEndDateTime": "2020-02-20 00:00:00",  # Optional.
                          Represents the estimated end date time for training and evaluation.
                        "evaluationStatus": {
                            "percentComplete": 0,  # Represents progress percentage.
                              Required.
                            "status": "str",  # Represents the status of the
                              sub-operation. Required. Known values are: "notStarted", "running",
                              "succeeded", "failed", "cancelled", "cancelling", and
                              "partiallyCompleted".
                            "endDateTime": "2020-02-20 00:00:00",  # Optional. Represents
                              the end date time.
                            "startDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the start date time.
                        },
                        "trainingMode": "str"  # Optional. Represents the mode of the
                          training operation. Known values are: "advanced" and "standard".
                    },
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._cancel_training_job_initial(
                project_name=project_name,
                job_id=job_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_project_deletion_job_status(self, job_id: str, **kwargs: Any) -> JSON:
        """Gets the status for a project deletion job.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-project-deletion-status
        for more information.

        :param job_id: The job ID. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # The creation date time of the
                      job. Required.
                    "jobId": "str",  # The job ID. Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # The last date time the job
                      was updated. Required.
                    "status": "str",  # The job status. Required. Known values are: "notStarted",
                      "running", "succeeded", "failed", "cancelled", "cancelling", and
                      "partiallyCompleted".
                    "errors": [
                        {
                            "code": "str",  # One of a server-defined set of error codes.
                              Required. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", and
                              "Warning".
                            "message": "str",  # A human-readable representation of the
                              error. Required.
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # One of a server-defined set of
                                  error codes. Required. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode", and
                                  "InvalidCountryHint".
                                "message": "str",  # Error message. Required.
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "target": "str"  # Optional. Error target.
                            },
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional. The expiration date
                      time of the job.
                    "warnings": [
                        {
                            "code": "str",  # The warning code. Required.
                            "message": "str"  # The warning message. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_conversation_authoring_get_project_deletion_job_status_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_assigned_resource_deployments(
        self, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the deployments to which an Azure resource is assigned. This doesn't return deployments
        belonging to projects owned by this resource. It only returns deployments belonging to projects
        owned by other resources.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/list-assigned-resource-deployments
        for more information.

        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentsMetadata": [
                        {
                            "deploymentExpirationDate": "2020-02-20",  # Represents
                              deployment expiration date in the runtime. Required.
                            "deploymentName": "str",  # Represents the deployment name.
                              Required.
                            "lastDeployedDateTime": "2020-02-20 00:00:00"  # Represents
                              deployment last deployed time. Required.
                        }
                    ],
                    "projectName": "str"  # Represents the project name. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_assigned_resource_deployments_request(
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_supported_languages(
        self, *, project_kind: str, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the supported languages for the given project type.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-supported-languages
        for more information.

        :keyword project_kind: The project kind. Known values are: "Conversation", "Orchestration", and
         "CustomConversationSummarization". Required.
        :paramtype project_kind: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "languageCode": "str",  # The language code. This is BCP-47 representation of
                      a language. For example, "en" for English, "en-gb" for English (UK), "es" for
                      Spanish etc. Required.
                    "languageName": "str"  # The language name. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_supported_languages_request(
                    project_kind=project_kind,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_supported_prebuilt_entities(
        self,
        *,
        language: Optional[str] = None,
        multilingual: Optional[bool] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the supported prebuilt entities that can be used while creating composed entities.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/get-supported-prebuilt-entities
        for more information.

        :keyword language: The language to get supported prebuilt entities for. Required if
         multilingual is false. This is BCP-47 representation of a language. For example, use "en" for
         English, "en-gb" for English (UK), "es" for Spanish etc. Default value is None.
        :paramtype language: str
        :keyword multilingual: Whether to get the support prebuilt entities for multilingual or
         monolingual projects. If true, the language parameter is ignored. Default value is None.
        :paramtype multilingual: bool
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "category": "str",  # The prebuilt entity category. Required.
                    "description": "str",  # The description. Required.
                    "examples": "str"  # English examples for the entity. Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_supported_prebuilt_entities_request(
                    language=language,
                    multilingual=multilingual,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_training_config_versions(
        self, *, project_kind: str, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Lists the support training config version for a given project type.

        See
        https://learn.microsoft.com/rest/api/language/2022-10-01-preview/conversational-analysis-authoring/list-training-config-versions
        for more information.

        :keyword project_kind: The project kind. Known values are: "Conversation", "Orchestration", and
         "CustomConversationSummarization". Required.
        :paramtype project_kind: str
        :keyword top: The maximum number of resources to return from the collection. Default value is
         None.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned. Default
         value is None.
        :paramtype skip: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "modelExpirationDate": "2020-02-20",  # Represents the training config
                      version expiration date. Required.
                    "trainingConfigVersion": "str"  # Represents the version of the config.
                      Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_conversation_authoring_list_training_config_versions_request(
                    project_kind=project_kind,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
