/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Compute the cumulative maximum of a strided array.
*
* @module @stdlib/stats/base/cumax
*
* @example
* var cumax = require( '@stdlib/stats/base/cumax' );
*
* var x = [ 1.0, -2.0, 2.0 ];
* var y = [ 0.0, 0.0, 0.0 ];
* var N = x.length;
*
* cumax( N, x, 1, y, 1 );
* // y => [ 1.0, 1.0, 2.0 ]
*
* @example
* var floor = require( '@stdlib/math/base/special/floor' );
* var cumax = require( '@stdlib/stats/base/cumax' );
*
* var x = [ 2.0, 1.0, 2.0, -2.0, -2.0, 2.0, 3.0, 4.0 ];
* var y = [ 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 ];
* var N = floor( x.length / 2 );
*
* cumax.ndarray( N, x, 2, 1, y, 1, 0 );
* // y => [ 1.0, 1.0, 2.0, 4.0, 0.0, 0.0, 0.0, 0.0 ]
*/

// MODULES //

var cumax = require( './main.js' );


// EXPORTS //

module.exports = cumax;
