/*
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Generates a linearly spaced numeric array.
*
* @param x1 - first array value
* @param x2 - last array value
* @param len - length of output array (default: 100)
* @throws third argument must be a nonnegative integer
* @returns linearly spaced numeric array
*
* @example
* var arr = linspace( 0, 100, 6 );
* // returns [ 0, 20, 40, 60, 80, 100 ]
*/
declare function linspace( x1: number, x2: number, len?: number ): Array<number>; // tslint-disable-line max-line-length


// EXPORTS //

export = linspace;
