
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file IntervalSelectionTypeAttributes.h
    \\brief Definition of IntervalSelectionType Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "IntervalSelectionTypeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



IntervalSelectionTypeWrapper::IntervalSelectionTypeWrapper(): intervalselectiontype_(new IntervalSelectionType())


{


	
	LevelSelectionWrapper::object(intervalselectiontype_);
	

}
IntervalSelectionTypeWrapper::IntervalSelectionTypeWrapper(IntervalSelectionType* intervalselectiontype): intervalselectiontype_(intervalselectiontype)
{

	
	LevelSelectionWrapper::object(intervalselectiontype_);
	
}

IntervalSelectionTypeWrapper::~IntervalSelectionTypeWrapper()
{

}

void IntervalSelectionTypeWrapper::set(const MagRequest& request)
{

	

	LevelSelectionWrapper::set(request);
	

	if  (request.countValues("CONTOUR_REFERENCE_LEVEL") ) {
		double reference_value = request("CONTOUR_REFERENCE_LEVEL");
		intervalselectiontype_->reference_ = reference_value;
		}
	if  (request.countValues("CONTOUR_INTERVAL") ) {
		double interval_value = request("CONTOUR_INTERVAL");
		intervalselectiontype_->interval_ = interval_value;
		}
	
	
}

void IntervalSelectionTypeWrapper::print(ostream& out)  const
{
	out << "IntervalSelectionTypeWrapper[]";
}


