/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Map;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonGenerationException;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonValue;

public class JakartaGeneratorWrapper
implements Wrapper,
JsonGenerator {
    OracleJsonGenerator wrapped;

    public JakartaGeneratorWrapper(OracleJsonGenerator wrapped) {
        this.wrapped = wrapped;
    }

    public void close() {
        try {
            this.wrapped.close();
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
    }

    public void flush() {
        try {
            this.wrapped.flush();
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
    }

    public JsonGenerator writeKey(String key) {
        try {
            this.wrapped.writeKey(key);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    private JsonException translate(OracleJsonException e) {
        if (e instanceof OracleJsonGenerationException) {
            return new JsonGenerationException(e.getMessage(), (Throwable)e);
        }
        return new JsonException(e.getMessage(), (Throwable)e);
    }

    public JsonGenerator write(String key, JsonValue arg) {
        try {
            this.wrapped.writeKey(key);
            this.write(arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(JsonValue arg) {
        if (arg instanceof Wrapper) {
            Wrapper w = (Wrapper)arg;
            try {
                if (w.isWrapperFor(OracleJsonValue.class)) {
                    this.wrapped.write(w.unwrap(OracleJsonValue.class));
                    return this;
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        this.writeJsonValue(arg);
        return this;
    }

    private void writeJsonValue(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                JsonObject obj = (JsonObject)value;
                this.writeStartObject();
                for (Map.Entry entry : obj.entrySet()) {
                    this.writeKey((String)entry.getKey());
                    this.writeJsonValue((JsonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case ARRAY: {
                JsonArray arr = (JsonArray)value;
                this.writeStartArray();
                for (JsonValue v : arr) {
                    this.writeJsonValue(v);
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString str = (JsonString)value;
                this.write(str.getString());
                break;
            }
            case NUMBER: {
                JsonNumber num = (JsonNumber)value;
                this.writeOraNum(num.bigDecimalValue());
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
    }

    public void writeJsonParser(Object p) {
        JsonParser parser = (JsonParser)p;
        int depth = 0;
        while (parser.hasNext()) {
            switch (parser.next()) {
                case END_ARRAY: {
                    this.writeEnd();
                    --depth;
                    break;
                }
                case END_OBJECT: {
                    this.writeEnd();
                    --depth;
                    break;
                }
                case KEY_NAME: {
                    this.writeKey(parser.getString());
                    break;
                }
                case START_ARRAY: {
                    this.writeStartArray();
                    ++depth;
                    break;
                }
                case START_OBJECT: {
                    this.writeStartObject();
                    ++depth;
                    break;
                }
                case VALUE_FALSE: {
                    this.write(false);
                    break;
                }
                case VALUE_NULL: {
                    this.writeNull();
                    break;
                }
                case VALUE_NUMBER: {
                    this.writeOraNum(parser.getBigDecimal());
                    break;
                }
                case VALUE_STRING: {
                    this.write(parser.getString());
                    break;
                }
                case VALUE_TRUE: {
                    this.write(true);
                }
            }
            if (depth > 0) continue;
            break;
        }
    }

    public JsonGenerator write(String arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(BigDecimal arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(BigInteger arg) {
        this.wrapped.write(arg);
        return this;
    }

    public JsonGenerator write(int arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(long arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(double arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(boolean arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(String key, String arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(String key, BigInteger arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(String key, BigDecimal arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(String key, int arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(String key, long arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(String key, double arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator write(String key, boolean arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator writeEnd() {
        try {
            this.wrapped.writeEnd();
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator writeNull() {
        try {
            this.wrapped.writeNull();
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator writeNull(String key) {
        try {
            this.wrapped.writeNull(key);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator writeStartArray() {
        try {
            this.wrapped.writeStartArray();
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator writeStartArray(String key) {
        try {
            this.wrapped.writeStartArray(key);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator writeStartObject() {
        try {
            this.wrapped.writeStartObject();
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    public JsonGenerator writeStartObject(String key) {
        try {
            this.wrapped.writeStartObject(key);
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> wrapped) throws SQLException {
        if (wrapped.isInstance(this.wrapped)) {
            return (T)this.wrapped;
        }
        throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, wrapped.getName()).getMessage());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.wrapped);
    }

    private void writeOraNum(BigDecimal value) {
        try {
            this.wrapped.write(new OracleJsonDecimalImpl(value));
        }
        catch (OracleJsonException e) {
            throw this.translate(e);
        }
    }
}

