/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Altitude;
import tim.prune.data.DoubleRange;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class AltitudeRange {
    private final DoubleRange _range = new DoubleRange();
    private final int _wiggleLimit;
    private boolean _gotPreviousValue;
    private double _previousValue;
    private int _climb;
    private int _descent;
    private boolean _gotPreviousMinimum;
    private boolean _gotPreviousMaximum;
    private double _previousExtreme;

    public AltitudeRange(int n) {
        this._wiggleLimit = n;
        this._range.clear();
        this._descent = 0;
        this._climb = 0;
        this._gotPreviousValue = false;
        this._previousValue = 0.0;
        this._gotPreviousMaximum = false;
        this._gotPreviousMinimum = false;
        this._previousExtreme = 0.0;
    }

    public void addValue(Altitude altitude) {
        if (altitude != null && altitude.isValid()) {
            int n = (int)altitude.getMetricValue();
            this._range.addValue(n);
            if (this._gotPreviousValue) {
                if ((double)n != this._previousValue) {
                    boolean bl;
                    boolean bl2 = (double)n > this._previousValue;
                    boolean bl3 = this._gotPreviousMinimum && this._previousValue > this._previousExtreme;
                    boolean bl4 = this._gotPreviousMaximum && this._previousValue < this._previousExtreme;
                    boolean bl5 = bl = Math.abs((double)n - this._previousValue) > (double)this._wiggleLimit;
                    if (!this._gotPreviousMinimum && !this._gotPreviousMaximum) {
                        if (bl) {
                            if (bl2) {
                                this._gotPreviousMinimum = true;
                            } else {
                                this._gotPreviousMaximum = true;
                            }
                            this._previousExtreme = this._previousValue;
                            this._previousValue = n;
                        }
                    } else if (bl3) {
                        if (bl2) {
                            this._previousValue = n;
                        } else if (bl) {
                            this._climb = (int)((double)this._climb + (this._previousValue - this._previousExtreme));
                            this._previousExtreme = this._previousValue;
                            this._gotPreviousMinimum = false;
                            this._gotPreviousMaximum = true;
                            this._previousValue = n;
                        }
                    } else if (bl4) {
                        if (bl2) {
                            if (bl) {
                                this._descent = (int)((double)this._descent + (this._previousExtreme - this._previousValue));
                                this._previousExtreme = this._previousValue;
                                this._gotPreviousMinimum = true;
                                this._gotPreviousMaximum = false;
                                this._previousValue = n;
                            }
                        } else {
                            this._previousValue = n;
                        }
                    }
                }
            } else {
                this._previousValue = n;
                this._gotPreviousValue = true;
            }
        }
    }

    public void ignoreValue(Altitude altitude) {
        if (this._gotPreviousValue && this._gotPreviousMinimum && this._previousValue > this._previousExtreme) {
            this._climb = (int)((double)this._climb + (this._previousValue - this._previousExtreme));
        } else if (this._gotPreviousValue && this._gotPreviousMaximum && this._previousValue < this._previousExtreme) {
            this._descent = (int)((double)this._descent + (this._previousExtreme - this._previousValue));
        }
        this._gotPreviousMaximum = false;
        this._gotPreviousMinimum = false;
        this._gotPreviousValue = false;
        if (altitude != null && altitude.isValid()) {
            int n = (int)altitude.getMetricValue();
            this._range.addValue(n);
            this._previousValue = n;
            this._gotPreviousValue = true;
        }
    }

    public boolean hasRange() {
        return this._range.hasData();
    }

    public int getMinimum(Unit unit) {
        return (int)(this._range.getMinimum() * unit.getMultFactorFromStd());
    }

    public int getMaximum(Unit unit) {
        return (int)(this._range.getMaximum() * unit.getMultFactorFromStd());
    }

    public int getClimb(Unit unit) {
        double d = 0.0;
        if (this._gotPreviousValue && this._gotPreviousMinimum && this._previousValue > this._previousExtreme) {
            d = this._previousValue - this._previousExtreme;
        }
        return (int)(((double)this._climb + d) * unit.getMultFactorFromStd());
    }

    public int getDescent(Unit unit) {
        double d = 0.0;
        if (this._gotPreviousValue && this._gotPreviousMaximum && this._previousValue < this._previousExtreme) {
            d = this._previousExtreme - this._previousValue;
        }
        return (int)(((double)this._descent + d) * unit.getMultFactorFromStd());
    }

    public double getMetricHeightDiff() {
        return this.getClimb(UnitSetLibrary.UNITS_METRES) - this.getDescent(UnitSetLibrary.UNITS_METRES);
    }
}

