/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.Completion;

private import glib.ConstructionException;
private import glib.ListG;
private import glib.MemorySlice;
private import glib.Str;
private import glib.c.functions;
public  import glib.c.types;


/**
 * `GCompletion` provides support for automatic completion of a string
 * using any group of target strings. It is typically used for file
 * name completion as is common in many UNIX shells.
 * 
 * A `GCompletion` is created using [func@GLib.Completion.new]. Target items are
 * added and removed with [method@GLib.Completion.add_items],
 * [method@GLib.Completion.remove_items] and
 * [method@GLib.Completion.clear_items]. A completion attempt is requested with
 * [method@GLib.Completion.complete] or [method@GLib.Completion.complete_utf8].
 * When no longer needed, the `GCompletion` is freed with
 * [method@GLib.Completion.free].
 * 
 * Items in the completion can be simple strings (e.g. filenames), or
 * pointers to arbitrary data structures. If data structures are used
 * you must provide a [type@GLib.CompletionFunc] in [func@GLib.Completion.new],
 * which retrieves the item’s string from the data structure. You can change
 * the way in which strings are compared by setting a different
 * [type@GLib.CompletionStrncmpFunc] in [method@GLib.Completion.set_compare].
 * 
 * `GCompletion` has been marked as deprecated, since this API is rarely
 * used and not very actively maintained.
 * 
 * Deprecated: Rarely used API
 */
public final class Completion
{
	/** the main Gtk struct */
	protected GCompletion* gCompletion;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GCompletion* getCompletionStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gCompletion;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gCompletion;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GCompletion* gCompletion, bool ownedRef = false)
	{
		this.gCompletion = gCompletion;
		this.ownedRef = ownedRef;
	}

	~this ()
	{
		if ( ownedRef )
			g_completion_free(gCompletion);
	}


	/**
	 * list of target items (strings or data structures).
	 */
	public @property ListG items()
	{
		return new ListG(gCompletion.items, false);
	}

	/** Ditto */
	public @property void items(ListG value)
	{
		gCompletion.items = value.getListGStruct();
	}

	/**
	 * function which is called to get the string associated with a
	 * target item. It is %NULL if the target items are strings.
	 */
	public @property GCompletionFunc func()
	{
		return gCompletion.func;
	}

	/** Ditto */
	public @property void func(GCompletionFunc value)
	{
		gCompletion.func = value;
	}

	/**
	 * the last prefix passed to g_completion_complete() or
	 * g_completion_complete_utf8().
	 */
	public @property string prefix()
	{
		return Str.toString(gCompletion.prefix);
	}

	/** Ditto */
	public @property void prefix(string value)
	{
		gCompletion.prefix = Str.toStringz(value);
	}

	/**
	 * the list of items which begin with @prefix.
	 */
	public @property ListG cache()
	{
		return new ListG(gCompletion.cache, false);
	}

	/** Ditto */
	public @property void cache(ListG value)
	{
		gCompletion.cache = value.getListGStruct();
	}

	/**
	 * The function to use when comparing strings.  Use
	 * g_completion_set_compare() to modify this function.
	 */
	public @property GCompletionStrncmpFunc strncmpFunc()
	{
		return gCompletion.strncmpFunc;
	}

	/** Ditto */
	public @property void strncmpFunc(GCompletionStrncmpFunc value)
	{
		gCompletion.strncmpFunc = value;
	}

	/**
	 * Adds items to the #GCompletion.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     items = the list of items to add.
	 */
	public void addItems(ListG items)
	{
		g_completion_add_items(gCompletion, (items is null) ? null : items.getListGStruct());
	}

	/**
	 * Removes all items from the #GCompletion. The items are not freed, so if the
	 * memory was dynamically allocated, it should be freed after calling this
	 * function.
	 *
	 * Deprecated: Rarely used API
	 */
	public void clearItems()
	{
		g_completion_clear_items(gCompletion);
	}

	/**
	 * Attempts to complete the string @prefix using the #GCompletion
	 * target items.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     prefix = the prefix string, typically typed by the user, which is
	 *         compared with each of the items.
	 *     newPrefix = if non-%NULL, returns the longest prefix which is
	 *         common to all items that matched @prefix, or %NULL if
	 *         no items matched @prefix.  This string should be freed
	 *         when no longer needed.
	 *
	 * Returns: the list of items whose strings begin with
	 *     @prefix. This should not be changed.
	 */
	public ListG complete(string prefix, string[] newPrefix)
	{
		auto __p = g_completion_complete(gCompletion, Str.toStringz(prefix), Str.toStringzArray(newPrefix));

		if(__p is null)
		{
			return null;
		}

		return new ListG(cast(GList*) __p);
	}

	/**
	 * Attempts to complete the string @prefix using the #GCompletion target items.
	 * In contrast to g_completion_complete(), this function returns the largest common
	 * prefix that is a valid UTF-8 string, omitting a possible common partial
	 * character.
	 *
	 * You should use this function instead of g_completion_complete() if your
	 * items are UTF-8 strings.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     prefix = the prefix string, typically used by the user, which is compared
	 *         with each of the items
	 *     newPrefix = if non-%NULL, returns the longest prefix which is common to all
	 *         items that matched @prefix, or %NULL if no items matched @prefix.
	 *         This string should be freed when no longer needed.
	 *
	 * Returns: the list of items whose strings begin with @prefix. This should
	 *     not be changed.
	 *
	 * Since: 2.4
	 */
	public ListG completeUtf8(string prefix, string[] newPrefix)
	{
		auto __p = g_completion_complete_utf8(gCompletion, Str.toStringz(prefix), Str.toStringzArray(newPrefix));

		if(__p is null)
		{
			return null;
		}

		return new ListG(cast(GList*) __p);
	}

	/**
	 * Frees all memory used by the #GCompletion. The items are not freed, so if
	 * the memory was dynamically allocated, it should be freed after calling this
	 * function.
	 *
	 * Deprecated: Rarely used API
	 */
	public void free()
	{
		g_completion_free(gCompletion);
		ownedRef = false;
	}

	/**
	 * Removes items from a #GCompletion. The items are not freed, so if the memory
	 * was dynamically allocated, free @items with g_list_free_full() after calling
	 * this function.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     items = the items to remove.
	 */
	public void removeItems(ListG items)
	{
		g_completion_remove_items(gCompletion, (items is null) ? null : items.getListGStruct());
	}

	/**
	 * Sets the function to use for string comparisons. The default string
	 * comparison function is strncmp().
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     strncmpFunc = the string comparison function.
	 */
	public void setCompare(GCompletionStrncmpFunc strncmpFunc)
	{
		g_completion_set_compare(gCompletion, strncmpFunc);
	}

	/**
	 * Creates a new #GCompletion.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     func = the function to be called to return the string representing
	 *         an item in the #GCompletion, or %NULL if strings are going to
	 *         be used as the #GCompletion items.
	 *
	 * Returns: the new #GCompletion.
	 *
	 * Throws: ConstructionException GTK+ fails to create the object.
	 */
	public this(GCompletionFunc func)
	{
		auto __p = g_completion_new(func);

		if(__p is null)
		{
			throw new ConstructionException("null returned by new");
		}

		this(cast(GCompletion*) __p);
	}
}
