//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Internal.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#include <IceGrid/Internal.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <Ice/SlicedData.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::IceInternal::DefaultValueFactoryInit<::IceGrid::InternalDbEnvDescriptor> iceC_IceGrid_InternalDbEnvDescriptor_init("::IceGrid::InternalDbEnvDescriptor");

const ::IceInternal::DefaultValueFactoryInit<::IceGrid::InternalAdapterDescriptor> iceC_IceGrid_InternalAdapterDescriptor_init("::IceGrid::InternalAdapterDescriptor");

const ::IceInternal::DefaultValueFactoryInit<::IceGrid::InternalDistributionDescriptor> iceC_IceGrid_InternalDistributionDescriptor_init("::IceGrid::InternalDistributionDescriptor");

const ::IceInternal::DefaultValueFactoryInit<::IceGrid::InternalServerDescriptor> iceC_IceGrid_InternalServerDescriptor_init("::IceGrid::InternalServerDescriptor");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceGrid::AdapterActiveException> iceC_IceGrid_AdapterActiveException_init("::IceGrid::AdapterActiveException");

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceGrid::AdapterNotActiveException> iceC_IceGrid_AdapterNotActiveException_init("::IceGrid::AdapterNotActiveException");

const ::std::string iceC_IceGrid_Adapter_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::Adapter"
};
const ::std::string iceC_IceGrid_Adapter_ops[] =
{
    "activate",
    "getDirectProxy",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "setDirectProxy"
};
const ::std::string iceC_IceGrid_Adapter_activate_name = "activate";
const ::std::string iceC_IceGrid_Adapter_getDirectProxy_name = "getDirectProxy";
const ::std::string iceC_IceGrid_Adapter_setDirectProxy_name = "setDirectProxy";

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceGrid::AdapterExistsException> iceC_IceGrid_AdapterExistsException_init("::IceGrid::AdapterExistsException");

const ::std::string iceC_IceGrid_FileReader_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::FileReader"
};
const ::std::string iceC_IceGrid_FileReader_ops[] =
{
    "getOffsetFromEnd",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "read"
};
const ::std::string iceC_IceGrid_FileReader_getOffsetFromEnd_name = "getOffsetFromEnd";
const ::std::string iceC_IceGrid_FileReader_read_name = "read";

const ::std::string iceC_IceGrid_Server_ids[3] =
{
    "::Ice::Object",
    "::IceGrid::FileReader",
    "::IceGrid::Server"
};
const ::std::string iceC_IceGrid_Server_ops[] =
{
    "checkUpdate",
    "getOffsetFromEnd",
    "getPid",
    "getState",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "isEnabled",
    "read",
    "sendSignal",
    "setEnabled",
    "setProcess",
    "start",
    "stop",
    "writeMessage"
};
const ::std::string iceC_IceGrid_Server_start_name = "start";
const ::std::string iceC_IceGrid_Server_stop_name = "stop";
const ::std::string iceC_IceGrid_Server_checkUpdate_name = "checkUpdate";
const ::std::string iceC_IceGrid_Server_setEnabled_name = "setEnabled";
const ::std::string iceC_IceGrid_Server_isEnabled_name = "isEnabled";
const ::std::string iceC_IceGrid_Server_sendSignal_name = "sendSignal";
const ::std::string iceC_IceGrid_Server_writeMessage_name = "writeMessage";
const ::std::string iceC_IceGrid_Server_getState_name = "getState";
const ::std::string iceC_IceGrid_Server_getPid_name = "getPid";
const ::std::string iceC_IceGrid_Server_setProcess_name = "setProcess";

const ::std::string iceC_IceGrid_ReplicaObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::ReplicaObserver"
};
const ::std::string iceC_IceGrid_ReplicaObserver_ops[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "replicaAdded",
    "replicaInit",
    "replicaRemoved"
};
const ::std::string iceC_IceGrid_ReplicaObserver_replicaInit_name = "replicaInit";
const ::std::string iceC_IceGrid_ReplicaObserver_replicaAdded_name = "replicaAdded";
const ::std::string iceC_IceGrid_ReplicaObserver_replicaRemoved_name = "replicaRemoved";

const ::std::string iceC_IceGrid_PatcherFeedback_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::PatcherFeedback"
};
const ::std::string iceC_IceGrid_PatcherFeedback_ops[] =
{
    "failed",
    "finished",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IceGrid_PatcherFeedback_finished_name = "finished";
const ::std::string iceC_IceGrid_PatcherFeedback_failed_name = "failed";

const ::std::string iceC_IceGrid_Node_ids[4] =
{
    "::Ice::Object",
    "::IceGrid::FileReader",
    "::IceGrid::Node",
    "::IceGrid::ReplicaObserver"
};
const ::std::string iceC_IceGrid_Node_ops[] =
{
    "destroyServer",
    "destroyServerWithoutRestart",
    "getHostname",
    "getLoad",
    "getName",
    "getOffsetFromEnd",
    "getProcessorSocketCount",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "loadServer",
    "loadServerWithoutRestart",
    "patch",
    "read",
    "registerWithReplica",
    "replicaAdded",
    "replicaInit",
    "replicaRemoved",
    "shutdown"
};
const ::std::string iceC_IceGrid_Node_loadServer_name = "loadServer";
const ::std::string iceC_IceGrid_Node_loadServerWithoutRestart_name = "loadServerWithoutRestart";
const ::std::string iceC_IceGrid_Node_destroyServer_name = "destroyServer";
const ::std::string iceC_IceGrid_Node_destroyServerWithoutRestart_name = "destroyServerWithoutRestart";
const ::std::string iceC_IceGrid_Node_patch_name = "patch";
const ::std::string iceC_IceGrid_Node_registerWithReplica_name = "registerWithReplica";
const ::std::string iceC_IceGrid_Node_getName_name = "getName";
const ::std::string iceC_IceGrid_Node_getHostname_name = "getHostname";
const ::std::string iceC_IceGrid_Node_getLoad_name = "getLoad";
const ::std::string iceC_IceGrid_Node_getProcessorSocketCount_name = "getProcessorSocketCount";
const ::std::string iceC_IceGrid_Node_shutdown_name = "shutdown";

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceGrid::NodeActiveException> iceC_IceGrid_NodeActiveException_init("::IceGrid::NodeActiveException");

const ::std::string iceC_IceGrid_NodeSession_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::NodeSession"
};
const ::std::string iceC_IceGrid_NodeSession_ops[] =
{
    "destroy",
    "getObserver",
    "getServers",
    "getTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "keepAlive",
    "loadServers",
    "setReplicaObserver",
    "waitForApplicationUpdate"
};
const ::std::string iceC_IceGrid_NodeSession_keepAlive_name = "keepAlive";
const ::std::string iceC_IceGrid_NodeSession_setReplicaObserver_name = "setReplicaObserver";
const ::std::string iceC_IceGrid_NodeSession_getTimeout_name = "getTimeout";
const ::std::string iceC_IceGrid_NodeSession_getObserver_name = "getObserver";
const ::std::string iceC_IceGrid_NodeSession_loadServers_name = "loadServers";
const ::std::string iceC_IceGrid_NodeSession_getServers_name = "getServers";
const ::std::string iceC_IceGrid_NodeSession_waitForApplicationUpdate_name = "waitForApplicationUpdate";
const ::std::string iceC_IceGrid_NodeSession_destroy_name = "destroy";

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceGrid::ReplicaActiveException> iceC_IceGrid_ReplicaActiveException_init("::IceGrid::ReplicaActiveException");

const ::std::string iceC_IceGrid_DatabaseObserver_ids[5] =
{
    "::Ice::Object",
    "::IceGrid::AdapterObserver",
    "::IceGrid::ApplicationObserver",
    "::IceGrid::DatabaseObserver",
    "::IceGrid::ObjectObserver"
};
const ::std::string iceC_IceGrid_DatabaseObserver_ops[] =
{
    "adapterAdded",
    "adapterInit",
    "adapterRemoved",
    "adapterUpdated",
    "applicationAdded",
    "applicationInit",
    "applicationRemoved",
    "applicationUpdated",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "objectAdded",
    "objectInit",
    "objectRemoved",
    "objectUpdated"
};

const ::std::string iceC_IceGrid_ReplicaSession_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::ReplicaSession"
};
const ::std::string iceC_IceGrid_ReplicaSession_ops[] =
{
    "destroy",
    "getTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "keepAlive",
    "receivedUpdate",
    "registerWellKnownObjects",
    "setAdapterDirectProxy",
    "setDatabaseObserver",
    "setEndpoints"
};
const ::std::string iceC_IceGrid_ReplicaSession_keepAlive_name = "keepAlive";
const ::std::string iceC_IceGrid_ReplicaSession_getTimeout_name = "getTimeout";
const ::std::string iceC_IceGrid_ReplicaSession_setDatabaseObserver_name = "setDatabaseObserver";
const ::std::string iceC_IceGrid_ReplicaSession_setEndpoints_name = "setEndpoints";
const ::std::string iceC_IceGrid_ReplicaSession_registerWellKnownObjects_name = "registerWellKnownObjects";
const ::std::string iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name = "setAdapterDirectProxy";
const ::std::string iceC_IceGrid_ReplicaSession_receivedUpdate_name = "receivedUpdate";
const ::std::string iceC_IceGrid_ReplicaSession_destroy_name = "destroy";

const ::IceInternal::DefaultValueFactoryInit<::IceGrid::InternalNodeInfo> iceC_IceGrid_InternalNodeInfo_init("::IceGrid::InternalNodeInfo");

const ::IceInternal::DefaultValueFactoryInit<::IceGrid::InternalReplicaInfo> iceC_IceGrid_InternalReplicaInfo_init("::IceGrid::InternalReplicaInfo");

const ::std::string iceC_IceGrid_InternalRegistry_ids[3] =
{
    "::Ice::Object",
    "::IceGrid::FileReader",
    "::IceGrid::InternalRegistry"
};
const ::std::string iceC_IceGrid_InternalRegistry_ops[] =
{
    "getAdapters",
    "getApplications",
    "getNodes",
    "getObjects",
    "getOffsetFromEnd",
    "getReplicas",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "read",
    "registerNode",
    "registerReplica",
    "registerWithReplica",
    "shutdown"
};
const ::std::string iceC_IceGrid_InternalRegistry_registerNode_name = "registerNode";
const ::std::string iceC_IceGrid_InternalRegistry_registerReplica_name = "registerReplica";
const ::std::string iceC_IceGrid_InternalRegistry_registerWithReplica_name = "registerWithReplica";
const ::std::string iceC_IceGrid_InternalRegistry_getNodes_name = "getNodes";
const ::std::string iceC_IceGrid_InternalRegistry_getReplicas_name = "getReplicas";
const ::std::string iceC_IceGrid_InternalRegistry_getApplications_name = "getApplications";
const ::std::string iceC_IceGrid_InternalRegistry_getAdapters_name = "getAdapters";
const ::std::string iceC_IceGrid_InternalRegistry_getObjects_name = "getObjects";
const ::std::string iceC_IceGrid_InternalRegistry_shutdown_name = "shutdown";

}

IceGrid::SynchronizationException::~SynchronizationException()
{
}

const ::std::string&
IceGrid::SynchronizationException::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::SynchronizationException";
    return typeId;
}

IceGrid::AdapterActiveException::~AdapterActiveException()
{
}

const ::std::string&
IceGrid::AdapterActiveException::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::AdapterActiveException";
    return typeId;
}

IceGrid::AdapterNotActiveException::~AdapterNotActiveException()
{
}

const ::std::string&
IceGrid::AdapterNotActiveException::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::AdapterNotActiveException";
    return typeId;
}

IceGrid::AdapterExistsException::~AdapterExistsException()
{
}

const ::std::string&
IceGrid::AdapterExistsException::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::AdapterExistsException";
    return typeId;
}

IceGrid::NodeActiveException::~NodeActiveException()
{
}

const ::std::string&
IceGrid::NodeActiveException::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::NodeActiveException";
    return typeId;
}

IceGrid::ReplicaActiveException::~ReplicaActiveException()
{
}

const ::std::string&
IceGrid::ReplicaActiveException::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::ReplicaActiveException";
    return typeId;
}

bool
IceGrid::Adapter::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Adapter_ids, iceC_IceGrid_Adapter_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::Adapter::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_Adapter_ids[0], &iceC_IceGrid_Adapter_ids[2]);
}

::std::string
IceGrid::Adapter::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Adapter::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::Adapter";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::Adapter::_iceD_activate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::shared_ptr<::Ice::ObjectPrx>& ret)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->activateAsync(responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Adapter::_iceD_getDirectProxy(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->getDirectProxy(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Adapter::_iceD_setDirectProxy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> iceP_proxy;
    istr->readAll(iceP_proxy);
    inS.endReadParams();
    this->setDirectProxy(::std::move(iceP_proxy), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Adapter::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Adapter_ops, iceC_IceGrid_Adapter_ops + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Adapter_ops)
    {
        case 0:
        {
            return _iceD_activate(in, current);
        }
        case 1:
        {
            return _iceD_getDirectProxy(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_setDirectProxy(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::FileReader::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_FileReader_ids, iceC_IceGrid_FileReader_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::FileReader::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_FileReader_ids[0], &iceC_IceGrid_FileReader_ids[2]);
}

::std::string
IceGrid::FileReader::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::FileReader::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::FileReader";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::FileReader::_iceD_getOffsetFromEnd(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_filename;
    int iceP_lines;
    istr->readAll(iceP_filename, iceP_lines);
    inS.endReadParams();
    long long int ret = this->getOffsetFromEnd(::std::move(iceP_filename), iceP_lines, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::FileReader::_iceD_read(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_filename;
    long long int iceP_pos;
    int iceP_size;
    istr->readAll(iceP_filename, iceP_pos, iceP_size);
    inS.endReadParams();
    long long int iceP_newPos;
    ::Ice::StringSeq iceP_lines;
    bool ret = this->read(::std::move(iceP_filename), iceP_pos, iceP_size, iceP_newPos, iceP_lines, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(iceP_newPos, iceP_lines, ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::FileReader::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_FileReader_ops, iceC_IceGrid_FileReader_ops + 6, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_FileReader_ops)
    {
        case 0:
        {
            return _iceD_getOffsetFromEnd(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        case 5:
        {
            return _iceD_read(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::Server::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Server_ids, iceC_IceGrid_Server_ids + 3, s);
}

::std::vector<::std::string>
IceGrid::Server::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_Server_ids[0], &iceC_IceGrid_Server_ids[3]);
}

::std::string
IceGrid::Server::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Server::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::Server";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_start(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->startAsync(inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_stop(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->stopAsync(inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_checkUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalServerDescriptor> iceP_svr;
    bool iceP_noRestart;
    istr->readAll(iceP_svr, iceP_noRestart);
    istr->readPendingValues();
    inS.endReadParams();
    bool ret = this->checkUpdate(::std::move(iceP_svr), iceP_noRestart, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_setEnabled(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    bool iceP_enable;
    istr->readAll(iceP_enable);
    inS.endReadParams();
    this->setEnabled(iceP_enable, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_isEnabled(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    bool ret = this->isEnabled(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_sendSignal(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_signal;
    istr->readAll(iceP_signal);
    inS.endReadParams();
    this->sendSignal(::std::move(iceP_signal), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_writeMessage(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_message;
    int iceP_fd;
    istr->readAll(iceP_message, iceP_fd);
    inS.endReadParams();
    this->writeMessage(::std::move(iceP_message), iceP_fd, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_getState(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ServerState ret = this->getState(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_getPid(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    int ret = this->getPid(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_setProcess(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<::Ice::ProcessPrx> iceP_proc;
    istr->readAll(iceP_proc);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->setProcessAsync(::std::move(iceP_proc), inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Server_ops, iceC_IceGrid_Server_ops + 16, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Server_ops)
    {
        case 0:
        {
            return _iceD_checkUpdate(in, current);
        }
        case 1:
        {
            return _iceD_getOffsetFromEnd(in, current);
        }
        case 2:
        {
            return _iceD_getPid(in, current);
        }
        case 3:
        {
            return _iceD_getState(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        case 8:
        {
            return _iceD_isEnabled(in, current);
        }
        case 9:
        {
            return _iceD_read(in, current);
        }
        case 10:
        {
            return _iceD_sendSignal(in, current);
        }
        case 11:
        {
            return _iceD_setEnabled(in, current);
        }
        case 12:
        {
            return _iceD_setProcess(in, current);
        }
        case 13:
        {
            return _iceD_start(in, current);
        }
        case 14:
        {
            return _iceD_stop(in, current);
        }
        case 15:
        {
            return _iceD_writeMessage(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::ReplicaObserver::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_ReplicaObserver_ids, iceC_IceGrid_ReplicaObserver_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::ReplicaObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_ReplicaObserver_ids[0], &iceC_IceGrid_ReplicaObserver_ids[2]);
}

::std::string
IceGrid::ReplicaObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::ReplicaObserver::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::ReplicaObserver";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::ReplicaObserver::_iceD_replicaInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    InternalRegistryPrxSeq iceP_replicas;
    istr->readAll(iceP_replicas);
    inS.endReadParams();
    this->replicaInit(::std::move(iceP_replicas), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaObserver::_iceD_replicaAdded(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalRegistryPrx> iceP_replica;
    istr->readAll(iceP_replica);
    inS.endReadParams();
    this->replicaAdded(::std::move(iceP_replica), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaObserver::_iceD_replicaRemoved(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalRegistryPrx> iceP_replica;
    istr->readAll(iceP_replica);
    inS.endReadParams();
    this->replicaRemoved(::std::move(iceP_replica), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_ReplicaObserver_ops, iceC_IceGrid_ReplicaObserver_ops + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_ReplicaObserver_ops)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_replicaAdded(in, current);
        }
        case 5:
        {
            return _iceD_replicaInit(in, current);
        }
        case 6:
        {
            return _iceD_replicaRemoved(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::PatcherFeedback::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_PatcherFeedback_ids, iceC_IceGrid_PatcherFeedback_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::PatcherFeedback::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_PatcherFeedback_ids[0], &iceC_IceGrid_PatcherFeedback_ids[2]);
}

::std::string
IceGrid::PatcherFeedback::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::PatcherFeedback::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::PatcherFeedback";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::PatcherFeedback::_iceD_finished(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->finished(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::PatcherFeedback::_iceD_failed(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_reason;
    istr->readAll(iceP_reason);
    inS.endReadParams();
    this->failed(::std::move(iceP_reason), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::PatcherFeedback::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_PatcherFeedback_ops, iceC_IceGrid_PatcherFeedback_ops + 6, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_PatcherFeedback_ops)
    {
        case 0:
        {
            return _iceD_failed(in, current);
        }
        case 1:
        {
            return _iceD_finished(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::Node::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Node_ids, iceC_IceGrid_Node_ids + 4, s);
}

::std::vector<::std::string>
IceGrid::Node::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_Node_ids[0], &iceC_IceGrid_Node_ids[4]);
}

::std::string
IceGrid::Node::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Node::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::Node";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_loadServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalServerDescriptor> iceP_svr;
    ::std::string iceP_replicaName;
    istr->readAll(iceP_svr, iceP_replicaName);
    istr->readPendingValues();
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::shared_ptr<ServerPrx>& ret, const AdapterPrxDict& iceP_adapters, int iceP_actTimeout, int iceP_deactTimeout)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(iceP_adapters, iceP_actTimeout, iceP_deactTimeout, ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->loadServerAsync(::std::move(iceP_svr), ::std::move(iceP_replicaName), responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_loadServerWithoutRestart(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalServerDescriptor> iceP_svr;
    ::std::string iceP_replicaName;
    istr->readAll(iceP_svr, iceP_replicaName);
    istr->readPendingValues();
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    auto responseCB = [inA](const ::std::shared_ptr<ServerPrx>& ret, const AdapterPrxDict& iceP_adapters, int iceP_actTimeout, int iceP_deactTimeout)
    {
        auto ostr = inA->startWriteParams();
        ostr->writeAll(iceP_adapters, iceP_actTimeout, iceP_deactTimeout, ret);
        inA->endWriteParams();
        inA->completed();
    };
    this->loadServerWithoutRestartAsync(::std::move(iceP_svr), ::std::move(iceP_replicaName), responseCB, inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_destroyServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    ::std::string iceP_uuid;
    int iceP_revision;
    ::std::string iceP_replicaName;
    istr->readAll(iceP_name, iceP_uuid, iceP_revision, iceP_replicaName);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->destroyServerAsync(::std::move(iceP_name), ::std::move(iceP_uuid), iceP_revision, ::std::move(iceP_replicaName), inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_destroyServerWithoutRestart(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    ::std::string iceP_uuid;
    int iceP_revision;
    ::std::string iceP_replicaName;
    istr->readAll(iceP_name, iceP_uuid, iceP_revision, iceP_replicaName);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->destroyServerWithoutRestartAsync(::std::move(iceP_name), ::std::move(iceP_uuid), iceP_revision, ::std::move(iceP_replicaName), inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_patch(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<PatcherFeedbackPrx> iceP_feedback;
    ::std::string iceP_application;
    ::std::string iceP_server;
    ::std::shared_ptr<InternalDistributionDescriptor> iceP_appDistrib;
    bool iceP_shutdown;
    istr->readAll(iceP_feedback, iceP_application, iceP_server, iceP_appDistrib, iceP_shutdown);
    istr->readPendingValues();
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->patchAsync(::std::move(iceP_feedback), ::std::move(iceP_application), ::std::move(iceP_server), ::std::move(iceP_appDistrib), iceP_shutdown, inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_registerWithReplica(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalRegistryPrx> iceP_replica;
    istr->readAll(iceP_replica);
    inS.endReadParams();
    this->registerWithReplica(::std::move(iceP_replica), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_getName(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getName(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_getHostname(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getHostname(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_getLoad(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    LoadInfo ret = this->getLoad(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_getProcessorSocketCount(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    int ret = this->getProcessorSocketCount(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_shutdown(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    this->shutdown(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Node_ops, iceC_IceGrid_Node_ops + 20, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Node_ops)
    {
        case 0:
        {
            return _iceD_destroyServer(in, current);
        }
        case 1:
        {
            return _iceD_destroyServerWithoutRestart(in, current);
        }
        case 2:
        {
            return _iceD_getHostname(in, current);
        }
        case 3:
        {
            return _iceD_getLoad(in, current);
        }
        case 4:
        {
            return _iceD_getName(in, current);
        }
        case 5:
        {
            return _iceD_getOffsetFromEnd(in, current);
        }
        case 6:
        {
            return _iceD_getProcessorSocketCount(in, current);
        }
        case 7:
        {
            return _iceD_ice_id(in, current);
        }
        case 8:
        {
            return _iceD_ice_ids(in, current);
        }
        case 9:
        {
            return _iceD_ice_isA(in, current);
        }
        case 10:
        {
            return _iceD_ice_ping(in, current);
        }
        case 11:
        {
            return _iceD_loadServer(in, current);
        }
        case 12:
        {
            return _iceD_loadServerWithoutRestart(in, current);
        }
        case 13:
        {
            return _iceD_patch(in, current);
        }
        case 14:
        {
            return _iceD_read(in, current);
        }
        case 15:
        {
            return _iceD_registerWithReplica(in, current);
        }
        case 16:
        {
            return _iceD_replicaAdded(in, current);
        }
        case 17:
        {
            return _iceD_replicaInit(in, current);
        }
        case 18:
        {
            return _iceD_replicaRemoved(in, current);
        }
        case 19:
        {
            return _iceD_shutdown(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::NodeSession::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_NodeSession_ids, iceC_IceGrid_NodeSession_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::NodeSession::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_NodeSession_ids[0], &iceC_IceGrid_NodeSession_ids[2]);
}

::std::string
IceGrid::NodeSession::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::NodeSession::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::NodeSession";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_keepAlive(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    LoadInfo iceP_load;
    istr->readAll(iceP_load);
    inS.endReadParams();
    this->keepAlive(::std::move(iceP_load), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_setReplicaObserver(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<ReplicaObserverPrx> iceP_observer;
    istr->readAll(iceP_observer);
    inS.endReadParams();
    this->setReplicaObserver(::std::move(iceP_observer), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_getTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    int ret = this->getTimeout(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_getObserver(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<NodeObserverPrx> ret = this->getObserver(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_loadServers(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->loadServersAsync(inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_getServers(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getServers(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_waitForApplicationUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_application;
    int iceP_revision;
    istr->readAll(iceP_application, iceP_revision);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->waitForApplicationUpdateAsync(::std::move(iceP_application), iceP_revision, inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_NodeSession_ops, iceC_IceGrid_NodeSession_ops + 12, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_NodeSession_ops)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_getObserver(in, current);
        }
        case 2:
        {
            return _iceD_getServers(in, current);
        }
        case 3:
        {
            return _iceD_getTimeout(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        case 8:
        {
            return _iceD_keepAlive(in, current);
        }
        case 9:
        {
            return _iceD_loadServers(in, current);
        }
        case 10:
        {
            return _iceD_setReplicaObserver(in, current);
        }
        case 11:
        {
            return _iceD_waitForApplicationUpdate(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::DatabaseObserver::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_DatabaseObserver_ids, iceC_IceGrid_DatabaseObserver_ids + 5, s);
}

::std::vector<::std::string>
IceGrid::DatabaseObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_DatabaseObserver_ids[0], &iceC_IceGrid_DatabaseObserver_ids[5]);
}

::std::string
IceGrid::DatabaseObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::DatabaseObserver::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::DatabaseObserver";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::DatabaseObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_DatabaseObserver_ops, iceC_IceGrid_DatabaseObserver_ops + 16, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_DatabaseObserver_ops)
    {
        case 0:
        {
            return _iceD_adapterAdded(in, current);
        }
        case 1:
        {
            return _iceD_adapterInit(in, current);
        }
        case 2:
        {
            return _iceD_adapterRemoved(in, current);
        }
        case 3:
        {
            return _iceD_adapterUpdated(in, current);
        }
        case 4:
        {
            return _iceD_applicationAdded(in, current);
        }
        case 5:
        {
            return _iceD_applicationInit(in, current);
        }
        case 6:
        {
            return _iceD_applicationRemoved(in, current);
        }
        case 7:
        {
            return _iceD_applicationUpdated(in, current);
        }
        case 8:
        {
            return _iceD_ice_id(in, current);
        }
        case 9:
        {
            return _iceD_ice_ids(in, current);
        }
        case 10:
        {
            return _iceD_ice_isA(in, current);
        }
        case 11:
        {
            return _iceD_ice_ping(in, current);
        }
        case 12:
        {
            return _iceD_objectAdded(in, current);
        }
        case 13:
        {
            return _iceD_objectInit(in, current);
        }
        case 14:
        {
            return _iceD_objectRemoved(in, current);
        }
        case 15:
        {
            return _iceD_objectUpdated(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::ReplicaSession::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_ReplicaSession_ids, iceC_IceGrid_ReplicaSession_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::ReplicaSession::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_ReplicaSession_ids[0], &iceC_IceGrid_ReplicaSession_ids[2]);
}

::std::string
IceGrid::ReplicaSession::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::ReplicaSession::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::ReplicaSession";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_keepAlive(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->keepAlive(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_getTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    int ret = this->getTimeout(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_setDatabaseObserver(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<DatabaseObserverPrx> iceP_dbObs;
    Ice::optional<StringLongDict> iceP_serials;
    istr->readAll(iceP_dbObs);
    istr->readAll({1}, iceP_serials);
    inS.endReadParams();
    this->setDatabaseObserver(::std::move(iceP_dbObs), ::std::move(iceP_serials), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_setEndpoints(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    StringObjectProxyDict iceP_endpoints;
    istr->readAll(iceP_endpoints);
    inS.endReadParams();
    this->setEndpoints(::std::move(iceP_endpoints), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_registerWellKnownObjects(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ObjectInfoSeq iceP_objects;
    istr->readAll(iceP_objects);
    inS.endReadParams();
    this->registerWellKnownObjects(::std::move(iceP_objects), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_setAdapterDirectProxy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_adapterId;
    ::std::string iceP_replicaGroupId;
    ::std::shared_ptr<::Ice::ObjectPrx> iceP_proxy;
    istr->readAll(iceP_adapterId, iceP_replicaGroupId, iceP_proxy);
    inS.endReadParams();
    this->setAdapterDirectProxy(::std::move(iceP_adapterId), ::std::move(iceP_replicaGroupId), ::std::move(iceP_proxy), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_receivedUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    TopicName iceP_name;
    int iceP_serial;
    ::std::string iceP_failure;
    istr->readAll(iceP_name, iceP_serial, iceP_failure);
    inS.endReadParams();
    this->receivedUpdate(iceP_name, iceP_serial, ::std::move(iceP_failure), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_ReplicaSession_ops, iceC_IceGrid_ReplicaSession_ops + 12, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_ReplicaSession_ops)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_getTimeout(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_keepAlive(in, current);
        }
        case 7:
        {
            return _iceD_receivedUpdate(in, current);
        }
        case 8:
        {
            return _iceD_registerWellKnownObjects(in, current);
        }
        case 9:
        {
            return _iceD_setAdapterDirectProxy(in, current);
        }
        case 10:
        {
            return _iceD_setDatabaseObserver(in, current);
        }
        case 11:
        {
            return _iceD_setEndpoints(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::InternalRegistry::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_InternalRegistry_ids, iceC_IceGrid_InternalRegistry_ids + 3, s);
}

::std::vector<::std::string>
IceGrid::InternalRegistry::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_InternalRegistry_ids[0], &iceC_IceGrid_InternalRegistry_ids[3]);
}

::std::string
IceGrid::InternalRegistry::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::InternalRegistry::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::InternalRegistry";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_registerNode(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalNodeInfo> iceP_info;
    ::std::shared_ptr<NodePrx> iceP_prx;
    LoadInfo iceP_loadInf;
    istr->readAll(iceP_info, iceP_prx, iceP_loadInf);
    istr->readPendingValues();
    inS.endReadParams();
    ::std::shared_ptr<NodeSessionPrx> ret = this->registerNode(::std::move(iceP_info), ::std::move(iceP_prx), ::std::move(iceP_loadInf), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_registerReplica(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalReplicaInfo> iceP_info;
    ::std::shared_ptr<InternalRegistryPrx> iceP_prx;
    istr->readAll(iceP_info, iceP_prx);
    istr->readPendingValues();
    inS.endReadParams();
    ::std::shared_ptr<ReplicaSessionPrx> ret = this->registerReplica(::std::move(iceP_info), ::std::move(iceP_prx), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_registerWithReplica(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<InternalRegistryPrx> iceP_prx;
    istr->readAll(iceP_prx);
    inS.endReadParams();
    this->registerWithReplica(::std::move(iceP_prx), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getNodes(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    NodePrxSeq ret = this->getNodes(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getReplicas(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    InternalRegistryPrxSeq ret = this->getReplicas(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getApplications(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    long long int iceP_serial;
    ApplicationInfoSeq ret = this->getApplications(iceP_serial, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(iceP_serial, ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getAdapters(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    long long int iceP_serial;
    AdapterInfoSeq ret = this->getAdapters(iceP_serial, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(iceP_serial, ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getObjects(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    long long int iceP_serial;
    ObjectInfoSeq ret = this->getObjects(iceP_serial, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(iceP_serial, ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_shutdown(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    this->shutdown(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_InternalRegistry_ops, iceC_IceGrid_InternalRegistry_ops + 15, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_InternalRegistry_ops)
    {
        case 0:
        {
            return _iceD_getAdapters(in, current);
        }
        case 1:
        {
            return _iceD_getApplications(in, current);
        }
        case 2:
        {
            return _iceD_getNodes(in, current);
        }
        case 3:
        {
            return _iceD_getObjects(in, current);
        }
        case 4:
        {
            return _iceD_getOffsetFromEnd(in, current);
        }
        case 5:
        {
            return _iceD_getReplicas(in, current);
        }
        case 6:
        {
            return _iceD_ice_id(in, current);
        }
        case 7:
        {
            return _iceD_ice_ids(in, current);
        }
        case 8:
        {
            return _iceD_ice_isA(in, current);
        }
        case 9:
        {
            return _iceD_ice_ping(in, current);
        }
        case 10:
        {
            return _iceD_read(in, current);
        }
        case 11:
        {
            return _iceD_registerNode(in, current);
        }
        case 12:
        {
            return _iceD_registerReplica(in, current);
        }
        case 13:
        {
            return _iceD_registerWithReplica(in, current);
        }
        case 14:
        {
            return _iceD_shutdown(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

IceGrid::InternalDbEnvDescriptor::~InternalDbEnvDescriptor()
{
}

const ::std::string&
IceGrid::InternalDbEnvDescriptor::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::InternalDbEnvDescriptor";
    return typeId;
}

IceGrid::InternalAdapterDescriptor::~InternalAdapterDescriptor()
{
}

const ::std::string&
IceGrid::InternalAdapterDescriptor::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::InternalAdapterDescriptor";
    return typeId;
}

IceGrid::InternalDistributionDescriptor::~InternalDistributionDescriptor()
{
}

const ::std::string&
IceGrid::InternalDistributionDescriptor::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::InternalDistributionDescriptor";
    return typeId;
}

IceGrid::InternalServerDescriptor::~InternalServerDescriptor()
{
}

const ::std::string&
IceGrid::InternalServerDescriptor::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::InternalServerDescriptor";
    return typeId;
}

IceGrid::InternalNodeInfo::~InternalNodeInfo()
{
}

const ::std::string&
IceGrid::InternalNodeInfo::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::InternalNodeInfo";
    return typeId;
}

IceGrid::InternalReplicaInfo::~InternalReplicaInfo()
{
}

const ::std::string&
IceGrid::InternalReplicaInfo::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::InternalReplicaInfo";
    return typeId;
}

/// \cond INTERNAL
void
IceGrid::AdapterPrx::_iceI_activate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Adapter_activate_name);
    outAsync->invoke(iceC_IceGrid_Adapter_activate_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdapterPrx::_iceI_getDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Adapter_getDirectProxy_name);
    outAsync->invoke(iceC_IceGrid_Adapter_getDirectProxy_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AdapterNotActiveException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdapterPrx::_iceI_setDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Adapter_setDirectProxy_name);
    outAsync->invoke(iceC_IceGrid_Adapter_setDirectProxy_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_proxy);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AdapterActiveException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::AdapterPrx::_newInstance() const
{
    return ::IceInternal::createProxy<AdapterPrx>();
}
/// \endcond

const ::std::string&
IceGrid::AdapterPrx::ice_staticId()
{
    return Adapter::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::FileReaderPrx::_iceI_getOffsetFromEnd(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<long long int>>& outAsync, const ::std::string& iceP_filename, int iceP_lines, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_FileReader_getOffsetFromEnd_name);
    outAsync->invoke(iceC_IceGrid_FileReader_getOffsetFromEnd_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_filename, iceP_lines);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::FileReaderPrx::_iceI_read(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<FileReader::ReadResult>>& outAsync, const ::std::string& iceP_filename, long long int iceP_pos, int iceP_size, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_FileReader_read_name);
    outAsync->invoke(iceC_IceGrid_FileReader_read_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_filename, iceP_pos, iceP_size);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            FileReader::ReadResult v;
            istr->readAll(v.newPos, v.lines, v.returnValue);
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::FileReaderPrx::_newInstance() const
{
    return ::IceInternal::createProxy<FileReaderPrx>();
}
/// \endcond

const ::std::string&
IceGrid::FileReaderPrx::ice_staticId()
{
    return FileReader::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_start(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Server_start_name);
    outAsync->invoke(iceC_IceGrid_Server_start_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ServerStartException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_stop(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Server_stop_name);
    outAsync->invoke(iceC_IceGrid_Server_stop_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ServerStopException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_checkUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>& outAsync, const ::std::shared_ptr<InternalServerDescriptor>& iceP_svr, bool iceP_noRestart, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Server_checkUpdate_name);
    outAsync->invoke(iceC_IceGrid_Server_checkUpdate_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_svr, iceP_noRestart);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_setEnabled(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, bool iceP_enable, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_Server_setEnabled_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_enable);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_isEnabled(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Server_isEnabled_name);
    outAsync->invoke(iceC_IceGrid_Server_isEnabled_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_sendSignal(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_signal, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Server_sendSignal_name);
    outAsync->invoke(iceC_IceGrid_Server_sendSignal_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_signal);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const BadSignalException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_writeMessage(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_message, int iceP_fd, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_Server_writeMessage_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_message, iceP_fd);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_getState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ServerState>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Server_getState_name);
    outAsync->invoke(iceC_IceGrid_Server_getState_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_getPid(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Server_getPid_name);
    outAsync->invoke(iceC_IceGrid_Server_getPid_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ServerPrx::_iceI_setProcess(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<::Ice::ProcessPrx>& iceP_proc, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_Server_setProcess_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_proc);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::ServerPrx::_newInstance() const
{
    return ::IceInternal::createProxy<ServerPrx>();
}
/// \endcond

const ::std::string&
IceGrid::ServerPrx::ice_staticId()
{
    return Server::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::ReplicaObserverPrx::_iceI_replicaInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const InternalRegistryPrxSeq& iceP_replicas, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ReplicaObserver_replicaInit_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_replicas);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaObserverPrx::_iceI_replicaAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<InternalRegistryPrx>& iceP_replica, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ReplicaObserver_replicaAdded_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_replica);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaObserverPrx::_iceI_replicaRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<InternalRegistryPrx>& iceP_replica, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ReplicaObserver_replicaRemoved_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_replica);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::ReplicaObserverPrx::_newInstance() const
{
    return ::IceInternal::createProxy<ReplicaObserverPrx>();
}
/// \endcond

const ::std::string&
IceGrid::ReplicaObserverPrx::ice_staticId()
{
    return ReplicaObserver::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::PatcherFeedbackPrx::_iceI_finished(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_PatcherFeedback_finished_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::PatcherFeedbackPrx::_iceI_failed(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_reason, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_PatcherFeedback_failed_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_reason);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::PatcherFeedbackPrx::_newInstance() const
{
    return ::IceInternal::createProxy<PatcherFeedbackPrx>();
}
/// \endcond

const ::std::string&
IceGrid::PatcherFeedbackPrx::ice_staticId()
{
    return PatcherFeedback::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_loadServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<Node::LoadServerResult>>& outAsync, const ::std::shared_ptr<InternalServerDescriptor>& iceP_svr, const ::std::string& iceP_replicaName, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Node_loadServer_name);
    outAsync->invoke(iceC_IceGrid_Node_loadServer_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_svr, iceP_replicaName);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            Node::LoadServerResult v;
            istr->readAll(v.adapters, v.actTimeout, v.deactTimeout, v.returnValue);
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_loadServerWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<Node::LoadServerWithoutRestartResult>>& outAsync, const ::std::shared_ptr<InternalServerDescriptor>& iceP_svr, const ::std::string& iceP_replicaName, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Node_loadServerWithoutRestart_name);
    outAsync->invoke(iceC_IceGrid_Node_loadServerWithoutRestart_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_svr, iceP_replicaName);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            Node::LoadServerWithoutRestartResult v;
            istr->readAll(v.adapters, v.actTimeout, v.deactTimeout, v.returnValue);
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_destroyServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_name, const ::std::string& iceP_uuid, int iceP_revision, const ::std::string& iceP_replicaName, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Node_destroyServer_name);
    outAsync->invoke(iceC_IceGrid_Node_destroyServer_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name, iceP_uuid, iceP_revision, iceP_replicaName);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_destroyServerWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_name, const ::std::string& iceP_uuid, int iceP_revision, const ::std::string& iceP_replicaName, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Node_destroyServerWithoutRestart_name);
    outAsync->invoke(iceC_IceGrid_Node_destroyServerWithoutRestart_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name, iceP_uuid, iceP_revision, iceP_replicaName);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_patch(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<PatcherFeedbackPrx>& iceP_feedback, const ::std::string& iceP_application, const ::std::string& iceP_server, const ::std::shared_ptr<InternalDistributionDescriptor>& iceP_appDistrib, bool iceP_shutdown, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_Node_patch_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_feedback, iceP_application, iceP_server, iceP_appDistrib, iceP_shutdown);
            ostr->writePendingValues();
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_registerWithReplica(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<InternalRegistryPrx>& iceP_replica, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_Node_registerWithReplica_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_replica);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_getName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Node_getName_name);
    outAsync->invoke(iceC_IceGrid_Node_getName_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_getHostname(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Node_getHostname_name);
    outAsync->invoke(iceC_IceGrid_Node_getHostname_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_getLoad(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::LoadInfo>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Node_getLoad_name);
    outAsync->invoke(iceC_IceGrid_Node_getLoad_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_getProcessorSocketCount(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Node_getProcessorSocketCount_name);
    outAsync->invoke(iceC_IceGrid_Node_getProcessorSocketCount_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodePrx::_iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_Node_shutdown_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::NodePrx::_newInstance() const
{
    return ::IceInternal::createProxy<NodePrx>();
}
/// \endcond

const ::std::string&
IceGrid::NodePrx::ice_staticId()
{
    return Node::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::NodeSessionPrx::_iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const LoadInfo& iceP_load, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeSession_keepAlive_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_load);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeSessionPrx::_iceI_setReplicaObserver(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<ReplicaObserverPrx>& iceP_observer, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeSession_setReplicaObserver_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_observer);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeSessionPrx::_iceI_getTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_NodeSession_getTimeout_name);
    outAsync->invoke(iceC_IceGrid_NodeSession_getTimeout_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeSessionPrx::_iceI_getObserver(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::NodeObserverPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_NodeSession_getObserver_name);
    outAsync->invoke(iceC_IceGrid_NodeSession_getObserver_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeSessionPrx::_iceI_loadServers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeSession_loadServers_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeSessionPrx::_iceI_getServers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_NodeSession_getServers_name);
    outAsync->invoke(iceC_IceGrid_NodeSession_getServers_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeSessionPrx::_iceI_waitForApplicationUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_application, int iceP_revision, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeSession_waitForApplicationUpdate_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_application, iceP_revision);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeSessionPrx::_iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeSession_destroy_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::NodeSessionPrx::_newInstance() const
{
    return ::IceInternal::createProxy<NodeSessionPrx>();
}
/// \endcond

const ::std::string&
IceGrid::NodeSessionPrx::ice_staticId()
{
    return NodeSession::ice_staticId();
}

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::DatabaseObserverPrx::_newInstance() const
{
    return ::IceInternal::createProxy<DatabaseObserverPrx>();
}
/// \endcond

const ::std::string&
IceGrid::DatabaseObserverPrx::ice_staticId()
{
    return DatabaseObserver::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::ReplicaSessionPrx::_iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ReplicaSession_keepAlive_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaSessionPrx::_iceI_getTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_ReplicaSession_getTimeout_name);
    outAsync->invoke(iceC_IceGrid_ReplicaSession_getTimeout_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaSessionPrx::_iceI_setDatabaseObserver(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<DatabaseObserverPrx>& iceP_dbObs, const Ice::optional<StringLongDict>& iceP_serials, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_ReplicaSession_setDatabaseObserver_name);
    outAsync->invoke(iceC_IceGrid_ReplicaSession_setDatabaseObserver_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_dbObs);
            ostr->writeAll({1}, iceP_serials);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ObserverAlreadyRegisteredException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaSessionPrx::_iceI_setEndpoints(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const StringObjectProxyDict& iceP_endpoints, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ReplicaSession_setEndpoints_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_endpoints);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaSessionPrx::_iceI_registerWellKnownObjects(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ObjectInfoSeq& iceP_objects, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ReplicaSession_registerWellKnownObjects_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_objects);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaSessionPrx::_iceI_setAdapterDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name);
    outAsync->invoke(iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_adapterId, iceP_replicaGroupId, iceP_proxy);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AdapterExistsException&)
            {
                throw;
            }
            catch(const AdapterNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaSessionPrx::_iceI_receivedUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, TopicName iceP_name, int iceP_serial, const ::std::string& iceP_failure, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ReplicaSession_receivedUpdate_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name, iceP_serial, iceP_failure);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ReplicaSessionPrx::_iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ReplicaSession_destroy_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::ReplicaSessionPrx::_newInstance() const
{
    return ::IceInternal::createProxy<ReplicaSessionPrx>();
}
/// \endcond

const ::std::string&
IceGrid::ReplicaSessionPrx::ice_staticId()
{
    return ReplicaSession::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_registerNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::NodeSessionPrx>>>& outAsync, const ::std::shared_ptr<InternalNodeInfo>& iceP_info, const ::std::shared_ptr<NodePrx>& iceP_prx, const LoadInfo& iceP_loadInf, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_registerNode_name);
    outAsync->invoke(iceC_IceGrid_InternalRegistry_registerNode_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_info, iceP_prx, iceP_loadInf);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NodeActiveException&)
            {
                throw;
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_registerReplica(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::ReplicaSessionPrx>>>& outAsync, const ::std::shared_ptr<InternalReplicaInfo>& iceP_info, const ::std::shared_ptr<InternalRegistryPrx>& iceP_prx, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_registerReplica_name);
    outAsync->invoke(iceC_IceGrid_InternalRegistry_registerReplica_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_info, iceP_prx);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const PermissionDeniedException&)
            {
                throw;
            }
            catch(const ReplicaActiveException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_registerWithReplica(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<InternalRegistryPrx>& iceP_prx, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_InternalRegistry_registerWithReplica_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_prx);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_getNodes(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::NodePrxSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getNodes_name);
    outAsync->invoke(iceC_IceGrid_InternalRegistry_getNodes_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_getReplicas(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::InternalRegistryPrxSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getReplicas_name);
    outAsync->invoke(iceC_IceGrid_InternalRegistry_getReplicas_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_getApplications(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<InternalRegistry::GetApplicationsResult>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getApplications_name);
    outAsync->invoke(iceC_IceGrid_InternalRegistry_getApplications_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr,
        [](::Ice::InputStream* istr)
        {
            InternalRegistry::GetApplicationsResult v;
            istr->readAll(v.serial, v.returnValue);
            istr->readPendingValues();
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_getAdapters(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<InternalRegistry::GetAdaptersResult>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getAdapters_name);
    outAsync->invoke(iceC_IceGrid_InternalRegistry_getAdapters_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr,
        [](::Ice::InputStream* istr)
        {
            InternalRegistry::GetAdaptersResult v;
            istr->readAll(v.serial, v.returnValue);
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_getObjects(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<InternalRegistry::GetObjectsResult>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getObjects_name);
    outAsync->invoke(iceC_IceGrid_InternalRegistry_getObjects_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr,
        [](::Ice::InputStream* istr)
        {
            InternalRegistry::GetObjectsResult v;
            istr->readAll(v.serial, v.returnValue);
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::InternalRegistryPrx::_iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_InternalRegistry_shutdown_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::InternalRegistryPrx::_newInstance() const
{
    return ::IceInternal::createProxy<InternalRegistryPrx>();
}
/// \endcond

const ::std::string&
IceGrid::InternalRegistryPrx::ice_staticId()
{
    return InternalRegistry::ice_staticId();
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_IceGrid_Adapter_activate_name = "activate";

const ::std::string iceC_IceGrid_Adapter_getDirectProxy_name = "getDirectProxy";

const ::std::string iceC_IceGrid_Adapter_setDirectProxy_name = "setDirectProxy";

const ::std::string iceC_IceGrid_FileReader_getOffsetFromEnd_name = "getOffsetFromEnd";

const ::std::string iceC_IceGrid_FileReader_read_name = "read";

const ::std::string iceC_IceGrid_Server_start_name = "start";

const ::std::string iceC_IceGrid_Server_stop_name = "stop";

const ::std::string iceC_IceGrid_Server_checkUpdate_name = "checkUpdate";

const ::std::string iceC_IceGrid_Server_setEnabled_name = "setEnabled";

const ::std::string iceC_IceGrid_Server_isEnabled_name = "isEnabled";

const ::std::string iceC_IceGrid_Server_sendSignal_name = "sendSignal";

const ::std::string iceC_IceGrid_Server_writeMessage_name = "writeMessage";

const ::std::string iceC_IceGrid_Server_getState_name = "getState";

const ::std::string iceC_IceGrid_Server_getPid_name = "getPid";

const ::std::string iceC_IceGrid_Server_setProcess_name = "setProcess";

const ::std::string iceC_IceGrid_ReplicaObserver_replicaInit_name = "replicaInit";

const ::std::string iceC_IceGrid_ReplicaObserver_replicaAdded_name = "replicaAdded";

const ::std::string iceC_IceGrid_ReplicaObserver_replicaRemoved_name = "replicaRemoved";

const ::std::string iceC_IceGrid_PatcherFeedback_finished_name = "finished";

const ::std::string iceC_IceGrid_PatcherFeedback_failed_name = "failed";

const ::std::string iceC_IceGrid_Node_loadServer_name = "loadServer";

const ::std::string iceC_IceGrid_Node_loadServerWithoutRestart_name = "loadServerWithoutRestart";

const ::std::string iceC_IceGrid_Node_destroyServer_name = "destroyServer";

const ::std::string iceC_IceGrid_Node_destroyServerWithoutRestart_name = "destroyServerWithoutRestart";

const ::std::string iceC_IceGrid_Node_patch_name = "patch";

const ::std::string iceC_IceGrid_Node_registerWithReplica_name = "registerWithReplica";

const ::std::string iceC_IceGrid_Node_getName_name = "getName";

const ::std::string iceC_IceGrid_Node_getHostname_name = "getHostname";

const ::std::string iceC_IceGrid_Node_getLoad_name = "getLoad";

const ::std::string iceC_IceGrid_Node_getProcessorSocketCount_name = "getProcessorSocketCount";

const ::std::string iceC_IceGrid_Node_shutdown_name = "shutdown";

const ::std::string iceC_IceGrid_NodeSession_keepAlive_name = "keepAlive";

const ::std::string iceC_IceGrid_NodeSession_setReplicaObserver_name = "setReplicaObserver";

const ::std::string iceC_IceGrid_NodeSession_getTimeout_name = "getTimeout";

const ::std::string iceC_IceGrid_NodeSession_getObserver_name = "getObserver";

const ::std::string iceC_IceGrid_NodeSession_loadServers_name = "loadServers";

const ::std::string iceC_IceGrid_NodeSession_getServers_name = "getServers";

const ::std::string iceC_IceGrid_NodeSession_waitForApplicationUpdate_name = "waitForApplicationUpdate";

const ::std::string iceC_IceGrid_NodeSession_destroy_name = "destroy";

const ::std::string iceC_IceGrid_ReplicaSession_keepAlive_name = "keepAlive";

const ::std::string iceC_IceGrid_ReplicaSession_getTimeout_name = "getTimeout";

const ::std::string iceC_IceGrid_ReplicaSession_setDatabaseObserver_name = "setDatabaseObserver";

const ::std::string iceC_IceGrid_ReplicaSession_setEndpoints_name = "setEndpoints";

const ::std::string iceC_IceGrid_ReplicaSession_registerWellKnownObjects_name = "registerWellKnownObjects";

const ::std::string iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name = "setAdapterDirectProxy";

const ::std::string iceC_IceGrid_ReplicaSession_receivedUpdate_name = "receivedUpdate";

const ::std::string iceC_IceGrid_ReplicaSession_destroy_name = "destroy";

const ::std::string iceC_IceGrid_InternalRegistry_registerNode_name = "registerNode";

const ::std::string iceC_IceGrid_InternalRegistry_registerReplica_name = "registerReplica";

const ::std::string iceC_IceGrid_InternalRegistry_registerWithReplica_name = "registerWithReplica";

const ::std::string iceC_IceGrid_InternalRegistry_getNodes_name = "getNodes";

const ::std::string iceC_IceGrid_InternalRegistry_getReplicas_name = "getReplicas";

const ::std::string iceC_IceGrid_InternalRegistry_getApplications_name = "getApplications";

const ::std::string iceC_IceGrid_InternalRegistry_getAdapters_name = "getAdapters";

const ::std::string iceC_IceGrid_InternalRegistry_getObjects_name = "getObjects";

const ::std::string iceC_IceGrid_InternalRegistry_shutdown_name = "shutdown";

}

IceGrid::SynchronizationException::SynchronizationException(const char* file, int line) :
    ::Ice::LocalException(file, line)
{
}

#ifdef ICE_CPP11_COMPILER
IceGrid::SynchronizationException::~SynchronizationException()
{
}
#else
IceGrid::SynchronizationException::~SynchronizationException() throw()
{
}
#endif

::std::string
IceGrid::SynchronizationException::ice_id() const
{
    return "::IceGrid::SynchronizationException";
}

IceGrid::SynchronizationException*
IceGrid::SynchronizationException::ice_clone() const
{
    return new SynchronizationException(*this);
}

void
IceGrid::SynchronizationException::ice_throw() const
{
    throw *this;
}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceGrid::AdapterActiveException> iceC_IceGrid_AdapterActiveException_init("::IceGrid::AdapterActiveException");

}

#ifdef ICE_CPP11_COMPILER
IceGrid::AdapterActiveException::~AdapterActiveException()
{
}
#else
IceGrid::AdapterActiveException::~AdapterActiveException() throw()
{
}
#endif

::std::string
IceGrid::AdapterActiveException::ice_id() const
{
    return "::IceGrid::AdapterActiveException";
}

IceGrid::AdapterActiveException*
IceGrid::AdapterActiveException::ice_clone() const
{
    return new AdapterActiveException(*this);
}

void
IceGrid::AdapterActiveException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceGrid::AdapterActiveException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceGrid::AdapterActiveException", -1, true);
    ::Ice::StreamWriter< AdapterActiveException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::AdapterActiveException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< AdapterActiveException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceGrid::AdapterNotActiveException> iceC_IceGrid_AdapterNotActiveException_init("::IceGrid::AdapterNotActiveException");

}

IceGrid::AdapterNotActiveException::AdapterNotActiveException(bool activatable) :
    ::Ice::UserException(),
    activatable(activatable)
{
}

#ifdef ICE_CPP11_COMPILER
IceGrid::AdapterNotActiveException::~AdapterNotActiveException()
{
}
#else
IceGrid::AdapterNotActiveException::~AdapterNotActiveException() throw()
{
}
#endif

::std::string
IceGrid::AdapterNotActiveException::ice_id() const
{
    return "::IceGrid::AdapterNotActiveException";
}

IceGrid::AdapterNotActiveException*
IceGrid::AdapterNotActiveException::ice_clone() const
{
    return new AdapterNotActiveException(*this);
}

void
IceGrid::AdapterNotActiveException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceGrid::AdapterNotActiveException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceGrid::AdapterNotActiveException", -1, true);
    ::Ice::StreamWriter< AdapterNotActiveException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::AdapterNotActiveException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< AdapterNotActiveException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceGrid::AdapterExistsException> iceC_IceGrid_AdapterExistsException_init("::IceGrid::AdapterExistsException");

}

IceGrid::AdapterExistsException::AdapterExistsException(const ::std::string& id) :
    ::Ice::UserException(),
    id(id)
{
}

#ifdef ICE_CPP11_COMPILER
IceGrid::AdapterExistsException::~AdapterExistsException()
{
}
#else
IceGrid::AdapterExistsException::~AdapterExistsException() throw()
{
}
#endif

::std::string
IceGrid::AdapterExistsException::ice_id() const
{
    return "::IceGrid::AdapterExistsException";
}

IceGrid::AdapterExistsException*
IceGrid::AdapterExistsException::ice_clone() const
{
    return new AdapterExistsException(*this);
}

void
IceGrid::AdapterExistsException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceGrid::AdapterExistsException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceGrid::AdapterExistsException", -1, true);
    ::Ice::StreamWriter< AdapterExistsException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::AdapterExistsException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< AdapterExistsException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceGrid::NodeActiveException> iceC_IceGrid_NodeActiveException_init("::IceGrid::NodeActiveException");

}

#ifdef ICE_CPP11_COMPILER
IceGrid::NodeActiveException::~NodeActiveException()
{
}
#else
IceGrid::NodeActiveException::~NodeActiveException() throw()
{
}
#endif

::std::string
IceGrid::NodeActiveException::ice_id() const
{
    return "::IceGrid::NodeActiveException";
}

IceGrid::NodeActiveException*
IceGrid::NodeActiveException::ice_clone() const
{
    return new NodeActiveException(*this);
}

void
IceGrid::NodeActiveException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceGrid::NodeActiveException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceGrid::NodeActiveException", -1, true);
    ::Ice::StreamWriter< NodeActiveException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::NodeActiveException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< NodeActiveException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceGrid::ReplicaActiveException> iceC_IceGrid_ReplicaActiveException_init("::IceGrid::ReplicaActiveException");

}

#ifdef ICE_CPP11_COMPILER
IceGrid::ReplicaActiveException::~ReplicaActiveException()
{
}
#else
IceGrid::ReplicaActiveException::~ReplicaActiveException() throw()
{
}
#endif

::std::string
IceGrid::ReplicaActiveException::ice_id() const
{
    return "::IceGrid::ReplicaActiveException";
}

IceGrid::ReplicaActiveException*
IceGrid::ReplicaActiveException::ice_clone() const
{
    return new ReplicaActiveException(*this);
}

void
IceGrid::ReplicaActiveException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceGrid::ReplicaActiveException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceGrid::ReplicaActiveException", -1, true);
    ::Ice::StreamWriter< ReplicaActiveException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::ReplicaActiveException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< ReplicaActiveException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

IceGrid::AMD_Adapter_activate::~AMD_Adapter_activate()
{
}

IceGrid::AMD_Server_start::~AMD_Server_start()
{
}

IceGrid::AMD_Server_stop::~AMD_Server_stop()
{
}

IceGrid::AMD_Server_setProcess::~AMD_Server_setProcess()
{
}

IceGrid::AMD_Node_loadServer::~AMD_Node_loadServer()
{
}

IceGrid::AMD_Node_loadServerWithoutRestart::~AMD_Node_loadServerWithoutRestart()
{
}

IceGrid::AMD_Node_destroyServer::~AMD_Node_destroyServer()
{
}

IceGrid::AMD_Node_destroyServerWithoutRestart::~AMD_Node_destroyServerWithoutRestart()
{
}

IceGrid::AMD_Node_patch::~AMD_Node_patch()
{
}

IceGrid::AMD_NodeSession_loadServers::~AMD_NodeSession_loadServers()
{
}

IceGrid::AMD_NodeSession_waitForApplicationUpdate::~AMD_NodeSession_waitForApplicationUpdate()
{
}

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Adapter_activate::AMD_Adapter_activate(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Adapter_activate::ice_response(const ::Ice::ObjectPrx& ret)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Server_start::AMD_Server_start(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Server_start::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Server_stop::AMD_Server_stop(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Server_stop::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Server_setProcess::AMD_Server_setProcess(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Server_setProcess::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Node_loadServer::AMD_Node_loadServer(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Node_loadServer::ice_response(const ::IceGrid::ServerPrx& ret, const ::IceGrid::AdapterPrxDict& adapters, ::Ice::Int actTimeout, ::Ice::Int deactTimeout)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(adapters);
    ostr->write(actTimeout);
    ostr->write(deactTimeout);
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Node_loadServerWithoutRestart::AMD_Node_loadServerWithoutRestart(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Node_loadServerWithoutRestart::ice_response(const ::IceGrid::ServerPrx& ret, const ::IceGrid::AdapterPrxDict& adapters, ::Ice::Int actTimeout, ::Ice::Int deactTimeout)
{
    ::Ice::OutputStream* ostr = startWriteParams();
    ostr->write(adapters);
    ostr->write(actTimeout);
    ostr->write(deactTimeout);
    ostr->write(ret);
    endWriteParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Node_destroyServer::AMD_Node_destroyServer(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Node_destroyServer::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Node_destroyServerWithoutRestart::AMD_Node_destroyServerWithoutRestart(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Node_destroyServerWithoutRestart::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Node_patch::AMD_Node_patch(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Node_patch::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_NodeSession_loadServers::AMD_NodeSession_loadServers(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_NodeSession_loadServers::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_NodeSession_waitForApplicationUpdate::AMD_NodeSession_waitForApplicationUpdate(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_NodeSession_waitForApplicationUpdate::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(InternalDbEnvDescriptor* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< InternalDbEnvDescriptor>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new InternalDbEnvDescriptor;
        v->_copyFrom(proxy);
    }
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::InternalDbEnvDescriptor::_newInstance() const
{
    return new InternalDbEnvDescriptor;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::InternalDbEnvDescriptor::ice_staticId()
{
    return ::IceGrid::InternalDbEnvDescriptor::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(InternalAdapterDescriptor* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< InternalAdapterDescriptor>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new InternalAdapterDescriptor;
        v->_copyFrom(proxy);
    }
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::InternalAdapterDescriptor::_newInstance() const
{
    return new InternalAdapterDescriptor;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::InternalAdapterDescriptor::ice_staticId()
{
    return ::IceGrid::InternalAdapterDescriptor::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(InternalDistributionDescriptor* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< InternalDistributionDescriptor>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new InternalDistributionDescriptor;
        v->_copyFrom(proxy);
    }
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::InternalDistributionDescriptor::_newInstance() const
{
    return new InternalDistributionDescriptor;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::InternalDistributionDescriptor::ice_staticId()
{
    return ::IceGrid::InternalDistributionDescriptor::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(InternalServerDescriptor* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< InternalServerDescriptor>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new InternalServerDescriptor;
        v->_copyFrom(proxy);
    }
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::InternalServerDescriptor::_newInstance() const
{
    return new InternalServerDescriptor;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::InternalServerDescriptor::ice_staticId()
{
    return ::IceGrid::InternalServerDescriptor::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(Adapter* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Adapter>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Adapter;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::Adapter::_iceI_begin_activate(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Adapter_activate_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Adapter_activate_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Adapter_activate_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Adapter_activate_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::Adapter::end_activate(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Adapter_activate_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Adapter::_iceI_begin_getDirectProxy(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Adapter_getDirectProxy_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Adapter_getDirectProxy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Adapter_getDirectProxy_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Adapter_getDirectProxy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::Adapter::end_getDirectProxy(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Adapter_getDirectProxy_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AdapterNotActiveException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Adapter::_iceI_begin_setDirectProxy(const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Adapter_setDirectProxy_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Adapter_setDirectProxy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Adapter_setDirectProxy_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_proxy);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Adapter_setDirectProxy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Adapter::end_setDirectProxy(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Adapter_setDirectProxy_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AdapterActiveException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::Adapter::_newInstance() const
{
    return new Adapter;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::Adapter::ice_staticId()
{
    return ::IceGrid::Adapter::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(FileReader* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< FileReader>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new FileReader;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::FileReader::_iceI_begin_getOffsetFromEnd(const ::std::string& iceP_filename, ::Ice::Int iceP_lines, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_FileReader_getOffsetFromEnd_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_FileReader_getOffsetFromEnd_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_FileReader_getOffsetFromEnd_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_filename);
        ostr->write(iceP_lines);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_FileReader_getOffsetFromEnd_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Long
IceProxy::IceGrid::FileReader::end_getOffsetFromEnd(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_FileReader_getOffsetFromEnd_name);
    ::Ice::Long ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::FileReader::_iceI_begin_read(const ::std::string& iceP_filename, ::Ice::Long iceP_pos, ::Ice::Int iceP_size, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_FileReader_read_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_FileReader_read_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_FileReader_read_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_filename);
        ostr->write(iceP_pos);
        ostr->write(iceP_size);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_FileReader_read_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::IceGrid::FileReader::end_read(::Ice::Long& iceP_newPos, ::Ice::StringSeq& iceP_lines, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_FileReader_read_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_newPos);
    istr->read(iceP_lines);
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::IceGrid::FileReader::_iceI_end_read(::Ice::Long& iceP_newPos, ::Ice::StringSeq& iceP_lines, bool& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_FileReader_read_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_newPos);
    istr->read(iceP_lines);
    istr->read(ret);
    result->_endReadParams();
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::FileReader::_newInstance() const
{
    return new FileReader;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::FileReader::ice_staticId()
{
    return ::IceGrid::FileReader::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(Server* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Server>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Server;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_start(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Server_start_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_start_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_start_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Server_start_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Server::end_start(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Server_start_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ServerStartException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_stop(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Server_stop_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_stop_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_stop_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Server_stop_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Server::end_stop(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Server_stop_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ServerStopException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_checkUpdate(const ::IceGrid::InternalServerDescriptorPtr& iceP_svr, bool iceP_noRestart, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Server_checkUpdate_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_checkUpdate_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_checkUpdate_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_svr);
        ostr->write(iceP_noRestart);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Server_checkUpdate_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::IceGrid::Server::end_checkUpdate(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Server_checkUpdate_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_setEnabled(bool iceP_enable, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_setEnabled_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_setEnabled_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_enable);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Server_setEnabled_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Server::end_setEnabled(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_Server_setEnabled_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_isEnabled(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Server_isEnabled_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_isEnabled_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_isEnabled_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Server_isEnabled_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::IceGrid::Server::end_isEnabled(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Server_isEnabled_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_sendSignal(const ::std::string& iceP_signal, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Server_sendSignal_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_sendSignal_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_sendSignal_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_signal);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Server_sendSignal_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Server::end_sendSignal(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Server_sendSignal_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::BadSignalException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_writeMessage(const ::std::string& iceP_message, ::Ice::Int iceP_fd, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_writeMessage_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_writeMessage_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_message);
        ostr->write(iceP_fd);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Server_writeMessage_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Server::end_writeMessage(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_Server_writeMessage_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_getState(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Server_getState_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_getState_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_getState_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Server_getState_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ServerState
IceProxy::IceGrid::Server::end_getState(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Server_getState_name);
    ::IceGrid::ServerState ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_getPid(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Server_getPid_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_getPid_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_getPid_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Server_getPid_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::Server::end_getPid(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Server_getPid_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Server::_iceI_begin_setProcess(const ::Ice::ProcessPrx& iceP_proc, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Server_setProcess_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Server_setProcess_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_proc);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Server_setProcess_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Server::end_setProcess(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_Server_setProcess_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::Server::_newInstance() const
{
    return new Server;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::Server::ice_staticId()
{
    return ::IceGrid::Server::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(ReplicaObserver* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< ReplicaObserver>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ReplicaObserver;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaObserver::_iceI_begin_replicaInit(const ::IceGrid::InternalRegistryPrxSeq& iceP_replicas, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaObserver_replicaInit_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaObserver_replicaInit_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_replicas);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ReplicaObserver_replicaInit_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaObserver::end_replicaInit(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ReplicaObserver_replicaInit_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaObserver::_iceI_begin_replicaAdded(const ::IceGrid::InternalRegistryPrx& iceP_replica, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaObserver_replicaAdded_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaObserver_replicaAdded_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_replica);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ReplicaObserver_replicaAdded_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaObserver::end_replicaAdded(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ReplicaObserver_replicaAdded_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaObserver::_iceI_begin_replicaRemoved(const ::IceGrid::InternalRegistryPrx& iceP_replica, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaObserver_replicaRemoved_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaObserver_replicaRemoved_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_replica);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ReplicaObserver_replicaRemoved_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaObserver::end_replicaRemoved(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ReplicaObserver_replicaRemoved_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::ReplicaObserver::_newInstance() const
{
    return new ReplicaObserver;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::ReplicaObserver::ice_staticId()
{
    return ::IceGrid::ReplicaObserver::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(PatcherFeedback* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< PatcherFeedback>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new PatcherFeedback;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::PatcherFeedback::_iceI_begin_finished(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_PatcherFeedback_finished_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_PatcherFeedback_finished_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_PatcherFeedback_finished_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::PatcherFeedback::end_finished(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_PatcherFeedback_finished_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::PatcherFeedback::_iceI_begin_failed(const ::std::string& iceP_reason, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_PatcherFeedback_failed_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_PatcherFeedback_failed_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_reason);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_PatcherFeedback_failed_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::PatcherFeedback::end_failed(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_PatcherFeedback_failed_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::PatcherFeedback::_newInstance() const
{
    return new PatcherFeedback;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::PatcherFeedback::ice_staticId()
{
    return ::IceGrid::PatcherFeedback::ice_staticId();
}

::IceProxy::IceGrid::_NodeBase::~_NodeBase()
{
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(Node* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Node>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Node;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_loadServer(const ::IceGrid::InternalServerDescriptorPtr& iceP_svr, const ::std::string& iceP_replicaName, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Node_loadServer_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_loadServer_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_loadServer_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_svr);
        ostr->write(iceP_replicaName);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Node_loadServer_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ServerPrx
IceProxy::IceGrid::Node::end_loadServer(::IceGrid::AdapterPrxDict& iceP_adapters, ::Ice::Int& iceP_actTimeout, ::Ice::Int& iceP_deactTimeout, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_loadServer_name);
    ::IceGrid::ServerPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_adapters);
    istr->read(iceP_actTimeout);
    istr->read(iceP_deactTimeout);
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::IceGrid::Node::_iceI_end_loadServer(::IceGrid::AdapterPrxDict& iceP_adapters, ::Ice::Int& iceP_actTimeout, ::Ice::Int& iceP_deactTimeout, ::IceGrid::ServerPrx& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_loadServer_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_adapters);
    istr->read(iceP_actTimeout);
    istr->read(iceP_deactTimeout);
    istr->read(ret);
    result->_endReadParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_loadServerWithoutRestart(const ::IceGrid::InternalServerDescriptorPtr& iceP_svr, const ::std::string& iceP_replicaName, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Node_loadServerWithoutRestart_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_loadServerWithoutRestart_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_loadServerWithoutRestart_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_svr);
        ostr->write(iceP_replicaName);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Node_loadServerWithoutRestart_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ServerPrx
IceProxy::IceGrid::Node::end_loadServerWithoutRestart(::IceGrid::AdapterPrxDict& iceP_adapters, ::Ice::Int& iceP_actTimeout, ::Ice::Int& iceP_deactTimeout, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_loadServerWithoutRestart_name);
    ::IceGrid::ServerPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_adapters);
    istr->read(iceP_actTimeout);
    istr->read(iceP_deactTimeout);
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::IceGrid::Node::_iceI_end_loadServerWithoutRestart(::IceGrid::AdapterPrxDict& iceP_adapters, ::Ice::Int& iceP_actTimeout, ::Ice::Int& iceP_deactTimeout, ::IceGrid::ServerPrx& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_loadServerWithoutRestart_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_adapters);
    istr->read(iceP_actTimeout);
    istr->read(iceP_deactTimeout);
    istr->read(ret);
    result->_endReadParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_destroyServer(const ::std::string& iceP_name, const ::std::string& iceP_uuid, ::Ice::Int iceP_revision, const ::std::string& iceP_replicaName, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Node_destroyServer_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_destroyServer_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_destroyServer_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        ostr->write(iceP_uuid);
        ostr->write(iceP_revision);
        ostr->write(iceP_replicaName);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Node_destroyServer_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Node::end_destroyServer(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_destroyServer_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_destroyServerWithoutRestart(const ::std::string& iceP_name, const ::std::string& iceP_uuid, ::Ice::Int iceP_revision, const ::std::string& iceP_replicaName, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Node_destroyServerWithoutRestart_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_destroyServerWithoutRestart_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_destroyServerWithoutRestart_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        ostr->write(iceP_uuid);
        ostr->write(iceP_revision);
        ostr->write(iceP_replicaName);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Node_destroyServerWithoutRestart_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Node::end_destroyServerWithoutRestart(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_destroyServerWithoutRestart_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_patch(const ::IceGrid::PatcherFeedbackPrx& iceP_feedback, const ::std::string& iceP_application, const ::std::string& iceP_server, const ::IceGrid::InternalDistributionDescriptorPtr& iceP_appDistrib, bool iceP_shutdown, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_patch_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_patch_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_feedback);
        ostr->write(iceP_application);
        ostr->write(iceP_server);
        ostr->write(iceP_appDistrib);
        ostr->write(iceP_shutdown);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Node_patch_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Node::end_patch(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_Node_patch_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& iceP_replica, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_registerWithReplica_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_registerWithReplica_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_replica);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Node_registerWithReplica_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Node::end_registerWithReplica(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_Node_registerWithReplica_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_getName(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Node_getName_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_getName_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_getName_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Node_getName_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::std::string
IceProxy::IceGrid::Node::end_getName(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_getName_name);
    ::std::string ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_getHostname(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Node_getHostname_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_getHostname_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_getHostname_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Node_getHostname_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::std::string
IceProxy::IceGrid::Node::end_getHostname(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_getHostname_name);
    ::std::string ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_getLoad(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Node_getLoad_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_getLoad_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_getLoad_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Node_getLoad_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::LoadInfo
IceProxy::IceGrid::Node::end_getLoad(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_getLoad_name);
    ::IceGrid::LoadInfo ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_getProcessorSocketCount(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Node_getProcessorSocketCount_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_getProcessorSocketCount_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_getProcessorSocketCount_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Node_getProcessorSocketCount_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::Node::end_getProcessorSocketCount(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Node_getProcessorSocketCount_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Node::_iceI_begin_shutdown(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Node_shutdown_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Node_shutdown_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Node_shutdown_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Node::end_shutdown(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_Node_shutdown_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::Node::_newInstance() const
{
    return new Node;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::Node::ice_staticId()
{
    return ::IceGrid::Node::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(NodeSession* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< NodeSession>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new NodeSession;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeSession::_iceI_begin_keepAlive(const ::IceGrid::LoadInfo& iceP_load, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeSession_keepAlive_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeSession_keepAlive_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_load);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_NodeSession_keepAlive_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeSession::end_keepAlive(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeSession_keepAlive_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeSession::_iceI_begin_setReplicaObserver(const ::IceGrid::ReplicaObserverPrx& iceP_observer, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeSession_setReplicaObserver_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeSession_setReplicaObserver_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_observer);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_NodeSession_setReplicaObserver_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeSession::end_setReplicaObserver(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeSession_setReplicaObserver_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeSession::_iceI_begin_getTimeout(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_NodeSession_getTimeout_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeSession_getTimeout_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeSession_getTimeout_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_NodeSession_getTimeout_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::NodeSession::end_getTimeout(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_NodeSession_getTimeout_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeSession::_iceI_begin_getObserver(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_NodeSession_getObserver_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeSession_getObserver_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeSession_getObserver_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_NodeSession_getObserver_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::NodeObserverPrx
IceProxy::IceGrid::NodeSession::end_getObserver(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_NodeSession_getObserver_name);
    ::IceGrid::NodeObserverPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeSession::_iceI_begin_loadServers(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeSession_loadServers_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeSession_loadServers_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_NodeSession_loadServers_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeSession::end_loadServers(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeSession_loadServers_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeSession::_iceI_begin_getServers(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_NodeSession_getServers_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeSession_getServers_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeSession_getServers_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_NodeSession_getServers_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::StringSeq
IceProxy::IceGrid::NodeSession::end_getServers(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_NodeSession_getServers_name);
    ::Ice::StringSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeSession::_iceI_begin_waitForApplicationUpdate(const ::std::string& iceP_application, ::Ice::Int iceP_revision, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeSession_waitForApplicationUpdate_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeSession_waitForApplicationUpdate_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_application);
        ostr->write(iceP_revision);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_NodeSession_waitForApplicationUpdate_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeSession::end_waitForApplicationUpdate(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeSession_waitForApplicationUpdate_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeSession::_iceI_begin_destroy(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeSession_destroy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeSession_destroy_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_NodeSession_destroy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeSession::end_destroy(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeSession_destroy_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::NodeSession::_newInstance() const
{
    return new NodeSession;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::NodeSession::ice_staticId()
{
    return ::IceGrid::NodeSession::ice_staticId();
}

::IceProxy::IceGrid::_DatabaseObserverBase::~_DatabaseObserverBase()
{
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(DatabaseObserver* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< DatabaseObserver>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new DatabaseObserver;
        v->_copyFrom(proxy);
    }
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::DatabaseObserver::_newInstance() const
{
    return new DatabaseObserver;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::DatabaseObserver::ice_staticId()
{
    return ::IceGrid::DatabaseObserver::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(ReplicaSession* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< ReplicaSession>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ReplicaSession;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaSession::_iceI_begin_keepAlive(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaSession_keepAlive_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaSession_keepAlive_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_ReplicaSession_keepAlive_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaSession::end_keepAlive(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ReplicaSession_keepAlive_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaSession::_iceI_begin_getTimeout(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_ReplicaSession_getTimeout_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaSession_getTimeout_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaSession_getTimeout_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_ReplicaSession_getTimeout_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::ReplicaSession::end_getTimeout(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_ReplicaSession_getTimeout_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaSession::_iceI_begin_setDatabaseObserver(const ::IceGrid::DatabaseObserverPrx& iceP_dbObs, const IceUtil::Optional< ::IceGrid::StringLongDict>& iceP_serials, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_ReplicaSession_setDatabaseObserver_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaSession_setDatabaseObserver_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaSession_setDatabaseObserver_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_dbObs);
        ostr->write(1, iceP_serials);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ReplicaSession_setDatabaseObserver_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaSession::end_setDatabaseObserver(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_ReplicaSession_setDatabaseObserver_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::ObserverAlreadyRegisteredException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaSession::_iceI_begin_setEndpoints(const ::IceGrid::StringObjectProxyDict& iceP_endpoints, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaSession_setEndpoints_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaSession_setEndpoints_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_endpoints);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ReplicaSession_setEndpoints_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaSession::end_setEndpoints(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ReplicaSession_setEndpoints_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaSession::_iceI_begin_registerWellKnownObjects(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaSession_registerWellKnownObjects_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaSession_registerWellKnownObjects_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_objects);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ReplicaSession_registerWellKnownObjects_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaSession::end_registerWellKnownObjects(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ReplicaSession_registerWellKnownObjects_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaSession::_iceI_begin_setAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_adapterId);
        ostr->write(iceP_replicaGroupId);
        ostr->write(iceP_proxy);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaSession::end_setAdapterDirectProxy(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_ReplicaSession_setAdapterDirectProxy_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AdapterExistsException&)
        {
            throw;
        }
        catch(const ::IceGrid::AdapterNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaSession::_iceI_begin_receivedUpdate(::IceGrid::TopicName iceP_name, ::Ice::Int iceP_serial, const ::std::string& iceP_failure, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaSession_receivedUpdate_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaSession_receivedUpdate_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        ostr->write(iceP_serial);
        ostr->write(iceP_failure);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ReplicaSession_receivedUpdate_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaSession::end_receivedUpdate(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ReplicaSession_receivedUpdate_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ReplicaSession::_iceI_begin_destroy(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ReplicaSession_destroy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ReplicaSession_destroy_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_ReplicaSession_destroy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ReplicaSession::end_destroy(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ReplicaSession_destroy_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::ReplicaSession::_newInstance() const
{
    return new ReplicaSession;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::ReplicaSession::ice_staticId()
{
    return ::IceGrid::ReplicaSession::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(InternalNodeInfo* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< InternalNodeInfo>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new InternalNodeInfo;
        v->_copyFrom(proxy);
    }
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::InternalNodeInfo::_newInstance() const
{
    return new InternalNodeInfo;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::InternalNodeInfo::ice_staticId()
{
    return ::IceGrid::InternalNodeInfo::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(InternalReplicaInfo* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< InternalReplicaInfo>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new InternalReplicaInfo;
        v->_copyFrom(proxy);
    }
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::InternalReplicaInfo::_newInstance() const
{
    return new InternalReplicaInfo;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::InternalReplicaInfo::ice_staticId()
{
    return ::IceGrid::InternalReplicaInfo::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(InternalRegistry* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< InternalRegistry>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new InternalRegistry;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_registerNode(const ::IceGrid::InternalNodeInfoPtr& iceP_info, const ::IceGrid::NodePrx& iceP_prx, const ::IceGrid::LoadInfo& iceP_loadInf, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_registerNode_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_registerNode_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_registerNode_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_info);
        ostr->write(iceP_prx);
        ostr->write(iceP_loadInf);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_InternalRegistry_registerNode_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::NodeSessionPrx
IceProxy::IceGrid::InternalRegistry::end_registerNode(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_registerNode_name);
    ::IceGrid::NodeSessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::NodeActiveException&)
        {
            throw;
        }
        catch(const ::IceGrid::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_registerReplica(const ::IceGrid::InternalReplicaInfoPtr& iceP_info, const ::IceGrid::InternalRegistryPrx& iceP_prx, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_registerReplica_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_registerReplica_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_registerReplica_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_info);
        ostr->write(iceP_prx);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_InternalRegistry_registerReplica_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ReplicaSessionPrx
IceProxy::IceGrid::InternalRegistry::end_registerReplica(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_registerReplica_name);
    ::IceGrid::ReplicaSessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::PermissionDeniedException&)
        {
            throw;
        }
        catch(const ::IceGrid::ReplicaActiveException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& iceP_prx, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_registerWithReplica_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_registerWithReplica_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_prx);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_InternalRegistry_registerWithReplica_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::InternalRegistry::end_registerWithReplica(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_InternalRegistry_registerWithReplica_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_getNodes(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getNodes_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_getNodes_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_getNodes_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_InternalRegistry_getNodes_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::NodePrxSeq
IceProxy::IceGrid::InternalRegistry::end_getNodes(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_getNodes_name);
    ::IceGrid::NodePrxSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_getReplicas(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getReplicas_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_getReplicas_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_getReplicas_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_InternalRegistry_getReplicas_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::InternalRegistryPrxSeq
IceProxy::IceGrid::InternalRegistry::end_getReplicas(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_getReplicas_name);
    ::IceGrid::InternalRegistryPrxSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_getApplications(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getApplications_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_getApplications_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_getApplications_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_InternalRegistry_getApplications_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ApplicationInfoSeq
IceProxy::IceGrid::InternalRegistry::end_getApplications(::Ice::Long& iceP_serial, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_getApplications_name);
    ::IceGrid::ApplicationInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_serial);
    istr->read(ret);
    istr->readPendingValues();
    result->_endReadParams();
    return ret;
}

void IceProxy::IceGrid::InternalRegistry::_iceI_end_getApplications(::Ice::Long& iceP_serial, ::IceGrid::ApplicationInfoSeq& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_getApplications_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_serial);
    istr->read(ret);
    istr->readPendingValues();
    result->_endReadParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_getAdapters(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getAdapters_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_getAdapters_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_getAdapters_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_InternalRegistry_getAdapters_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::AdapterInfoSeq
IceProxy::IceGrid::InternalRegistry::end_getAdapters(::Ice::Long& iceP_serial, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_getAdapters_name);
    ::IceGrid::AdapterInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_serial);
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::IceGrid::InternalRegistry::_iceI_end_getAdapters(::Ice::Long& iceP_serial, ::IceGrid::AdapterInfoSeq& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_getAdapters_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_serial);
    istr->read(ret);
    result->_endReadParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_getObjects(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_InternalRegistry_getObjects_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_getObjects_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_getObjects_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_InternalRegistry_getObjects_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ObjectInfoSeq
IceProxy::IceGrid::InternalRegistry::end_getObjects(::Ice::Long& iceP_serial, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_getObjects_name);
    ::IceGrid::ObjectInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_serial);
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::IceGrid::InternalRegistry::_iceI_end_getObjects(::Ice::Long& iceP_serial, ::IceGrid::ObjectInfoSeq& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_InternalRegistry_getObjects_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_serial);
    istr->read(ret);
    result->_endReadParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::InternalRegistry::_iceI_begin_shutdown(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_InternalRegistry_shutdown_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_InternalRegistry_shutdown_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_InternalRegistry_shutdown_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::InternalRegistry::end_shutdown(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_InternalRegistry_shutdown_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::InternalRegistry::_newInstance() const
{
    return new InternalRegistry;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::InternalRegistry::ice_staticId()
{
    return ::IceGrid::InternalRegistry::ice_staticId();
}

IceGrid::InternalDbEnvDescriptor::~InternalDbEnvDescriptor()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(InternalDbEnvDescriptor* p) { return p; }

/// \endcond
::Ice::ObjectPtr
IceGrid::InternalDbEnvDescriptor::ice_clone() const
{
    ::Ice::Object* p = new InternalDbEnvDescriptor(*this);
    return p;
}

namespace
{
const ::std::string iceC_IceGrid_InternalDbEnvDescriptor_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::InternalDbEnvDescriptor"
};

}

bool
IceGrid::InternalDbEnvDescriptor::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_InternalDbEnvDescriptor_ids, iceC_IceGrid_InternalDbEnvDescriptor_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::InternalDbEnvDescriptor::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_InternalDbEnvDescriptor_ids[0], &iceC_IceGrid_InternalDbEnvDescriptor_ids[2]);
}

const ::std::string&
IceGrid::InternalDbEnvDescriptor::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::InternalDbEnvDescriptor::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::InternalDbEnvDescriptor";
    return typeId;
#else
    return iceC_IceGrid_InternalDbEnvDescriptor_ids[1];
#endif
}

/// \cond STREAM
void
IceGrid::InternalDbEnvDescriptor::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< InternalDbEnvDescriptor, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::InternalDbEnvDescriptor::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< InternalDbEnvDescriptor, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{
const ::IceInternal::DefaultValueFactoryInit< ::IceGrid::InternalDbEnvDescriptor> iceC_IceGrid_InternalDbEnvDescriptor_init("::IceGrid::InternalDbEnvDescriptor");
}

::Ice::ValueFactoryPtr
IceGrid::InternalDbEnvDescriptor::ice_factory()
{
    return ::IceInternal::factoryTable->getValueFactory(::IceGrid::InternalDbEnvDescriptor::ice_staticId());
}

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(InternalDbEnvDescriptorPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = InternalDbEnvDescriptorPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(InternalDbEnvDescriptor::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::InternalAdapterDescriptor::~InternalAdapterDescriptor()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(InternalAdapterDescriptor* p) { return p; }

/// \endcond
::Ice::ObjectPtr
IceGrid::InternalAdapterDescriptor::ice_clone() const
{
    ::Ice::Object* p = new InternalAdapterDescriptor(*this);
    return p;
}

namespace
{
const ::std::string iceC_IceGrid_InternalAdapterDescriptor_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::InternalAdapterDescriptor"
};

}

bool
IceGrid::InternalAdapterDescriptor::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_InternalAdapterDescriptor_ids, iceC_IceGrid_InternalAdapterDescriptor_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::InternalAdapterDescriptor::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_InternalAdapterDescriptor_ids[0], &iceC_IceGrid_InternalAdapterDescriptor_ids[2]);
}

const ::std::string&
IceGrid::InternalAdapterDescriptor::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::InternalAdapterDescriptor::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::InternalAdapterDescriptor";
    return typeId;
#else
    return iceC_IceGrid_InternalAdapterDescriptor_ids[1];
#endif
}

/// \cond STREAM
void
IceGrid::InternalAdapterDescriptor::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< InternalAdapterDescriptor, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::InternalAdapterDescriptor::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< InternalAdapterDescriptor, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{
const ::IceInternal::DefaultValueFactoryInit< ::IceGrid::InternalAdapterDescriptor> iceC_IceGrid_InternalAdapterDescriptor_init("::IceGrid::InternalAdapterDescriptor");
}

::Ice::ValueFactoryPtr
IceGrid::InternalAdapterDescriptor::ice_factory()
{
    return ::IceInternal::factoryTable->getValueFactory(::IceGrid::InternalAdapterDescriptor::ice_staticId());
}

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(InternalAdapterDescriptorPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = InternalAdapterDescriptorPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(InternalAdapterDescriptor::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::InternalDistributionDescriptor::~InternalDistributionDescriptor()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(InternalDistributionDescriptor* p) { return p; }

/// \endcond
::Ice::ObjectPtr
IceGrid::InternalDistributionDescriptor::ice_clone() const
{
    ::Ice::Object* p = new InternalDistributionDescriptor(*this);
    return p;
}

namespace
{
const ::std::string iceC_IceGrid_InternalDistributionDescriptor_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::InternalDistributionDescriptor"
};

}

bool
IceGrid::InternalDistributionDescriptor::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_InternalDistributionDescriptor_ids, iceC_IceGrid_InternalDistributionDescriptor_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::InternalDistributionDescriptor::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_InternalDistributionDescriptor_ids[0], &iceC_IceGrid_InternalDistributionDescriptor_ids[2]);
}

const ::std::string&
IceGrid::InternalDistributionDescriptor::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::InternalDistributionDescriptor::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::InternalDistributionDescriptor";
    return typeId;
#else
    return iceC_IceGrid_InternalDistributionDescriptor_ids[1];
#endif
}

/// \cond STREAM
void
IceGrid::InternalDistributionDescriptor::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< InternalDistributionDescriptor, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::InternalDistributionDescriptor::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< InternalDistributionDescriptor, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{
const ::IceInternal::DefaultValueFactoryInit< ::IceGrid::InternalDistributionDescriptor> iceC_IceGrid_InternalDistributionDescriptor_init("::IceGrid::InternalDistributionDescriptor");
}

::Ice::ValueFactoryPtr
IceGrid::InternalDistributionDescriptor::ice_factory()
{
    return ::IceInternal::factoryTable->getValueFactory(::IceGrid::InternalDistributionDescriptor::ice_staticId());
}

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(InternalDistributionDescriptorPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = InternalDistributionDescriptorPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(InternalDistributionDescriptor::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::InternalServerDescriptor::~InternalServerDescriptor()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(InternalServerDescriptor* p) { return p; }

/// \endcond

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4589)
#endif
::Ice::ObjectPtr
IceGrid::InternalServerDescriptor::ice_clone() const
{
    ::Ice::Object* p = new InternalServerDescriptor(*this);
    return p;
}
#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

namespace
{
const ::std::string iceC_IceGrid_InternalServerDescriptor_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::InternalServerDescriptor"
};

}

bool
IceGrid::InternalServerDescriptor::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_InternalServerDescriptor_ids, iceC_IceGrid_InternalServerDescriptor_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::InternalServerDescriptor::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_InternalServerDescriptor_ids[0], &iceC_IceGrid_InternalServerDescriptor_ids[2]);
}

const ::std::string&
IceGrid::InternalServerDescriptor::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::InternalServerDescriptor::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::InternalServerDescriptor";
    return typeId;
#else
    return iceC_IceGrid_InternalServerDescriptor_ids[1];
#endif
}

void
IceGrid::InternalServerDescriptor::_iceGcVisitMembers(::IceInternal::GCVisitor& v_)
{
    if(distrib)
    {
        if((::IceGrid::upCast(distrib.get())->_iceGcVisit(v_)))
        {
            distrib = 0;
        }
    }
    {
        for(::IceGrid::InternalAdapterDescriptorSeq::iterator _i0 = adapters.begin(); _i0 != adapters.end(); ++_i0)
        {
            if((*_i0))
            {
                if((::IceGrid::upCast((*_i0).get())->_iceGcVisit(v_)))
                {
                    (*_i0) = 0;
                }
            }
        }
    }
    {
        for(::IceGrid::InternalDbEnvDescriptorSeq::iterator _i0 = dbEnvs.begin(); _i0 != dbEnvs.end(); ++_i0)
        {
            if((*_i0))
            {
                if((::IceGrid::upCast((*_i0).get())->_iceGcVisit(v_)))
                {
                    (*_i0) = 0;
                }
            }
        }
    }
}

/// \cond STREAM
void
IceGrid::InternalServerDescriptor::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< InternalServerDescriptor, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::InternalServerDescriptor::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< InternalServerDescriptor, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{
const ::IceInternal::DefaultValueFactoryInit< ::IceGrid::InternalServerDescriptor> iceC_IceGrid_InternalServerDescriptor_init("::IceGrid::InternalServerDescriptor");
}

::Ice::ValueFactoryPtr
IceGrid::InternalServerDescriptor::ice_factory()
{
    return ::IceInternal::factoryTable->getValueFactory(::IceGrid::InternalServerDescriptor::ice_staticId());
}

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(InternalServerDescriptorPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = InternalServerDescriptorPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(InternalServerDescriptor::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::Adapter::~Adapter()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(Adapter* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Adapter_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::Adapter"
};

}

bool
IceGrid::Adapter::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Adapter_ids, iceC_IceGrid_Adapter_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::Adapter::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_Adapter_ids[0], &iceC_IceGrid_Adapter_ids[2]);
}

const ::std::string&
IceGrid::Adapter::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Adapter::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::Adapter";
    return typeId;
#else
    return iceC_IceGrid_Adapter_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::Adapter::_iceD_activate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->activate_async(new IceAsync::IceGrid::AMD_Adapter_activate(inS), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Adapter::_iceD_getDirectProxy(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::ObjectPrx ret = this->getDirectProxy(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Adapter::_iceD_setDirectProxy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::ObjectPrx iceP_proxy;
    istr->read(iceP_proxy);
    inS.endReadParams();
    this->setDirectProxy(iceP_proxy, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Adapter_all[] =
{
    "activate",
    "getDirectProxy",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "setDirectProxy"
};

}

/// \cond INTERNAL
bool
IceGrid::Adapter::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Adapter_all, iceC_IceGrid_Adapter_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Adapter_all)
    {
        case 0:
        {
            return _iceD_activate(in, current);
        }
        case 1:
        {
            return _iceD_getDirectProxy(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_setDirectProxy(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::Adapter::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Adapter, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::Adapter::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Adapter, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(AdapterPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = AdapterPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Adapter::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::FileReader::~FileReader()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(FileReader* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_FileReader_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::FileReader"
};

}

bool
IceGrid::FileReader::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_FileReader_ids, iceC_IceGrid_FileReader_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::FileReader::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_FileReader_ids[0], &iceC_IceGrid_FileReader_ids[2]);
}

const ::std::string&
IceGrid::FileReader::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::FileReader::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::FileReader";
    return typeId;
#else
    return iceC_IceGrid_FileReader_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::FileReader::_iceD_getOffsetFromEnd(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_filename;
    ::Ice::Int iceP_lines;
    istr->read(iceP_filename);
    istr->read(iceP_lines);
    inS.endReadParams();
    ::Ice::Long ret = this->getOffsetFromEnd(iceP_filename, iceP_lines, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::FileReader::_iceD_read(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_filename;
    ::Ice::Long iceP_pos;
    ::Ice::Int iceP_size;
    istr->read(iceP_filename);
    istr->read(iceP_pos);
    istr->read(iceP_size);
    inS.endReadParams();
    ::Ice::Long iceP_newPos;
    ::Ice::StringSeq iceP_lines;
    bool ret = this->read(iceP_filename, iceP_pos, iceP_size, iceP_newPos, iceP_lines, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(iceP_newPos);
    ostr->write(iceP_lines);
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_FileReader_all[] =
{
    "getOffsetFromEnd",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "read"
};

}

/// \cond INTERNAL
bool
IceGrid::FileReader::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_FileReader_all, iceC_IceGrid_FileReader_all + 6, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_FileReader_all)
    {
        case 0:
        {
            return _iceD_getOffsetFromEnd(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        case 5:
        {
            return _iceD_read(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::FileReader::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< FileReader, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::FileReader::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< FileReader, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(FileReaderPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = FileReaderPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(FileReader::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::Server::~Server()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(Server* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Server_ids[3] =
{
    "::Ice::Object",
    "::IceGrid::FileReader",
    "::IceGrid::Server"
};

}

bool
IceGrid::Server::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Server_ids, iceC_IceGrid_Server_ids + 3, s);
}

::std::vector< ::std::string>
IceGrid::Server::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_Server_ids[0], &iceC_IceGrid_Server_ids[3]);
}

const ::std::string&
IceGrid::Server::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Server::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::Server";
    return typeId;
#else
    return iceC_IceGrid_Server_ids[2];
#endif
}

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_start(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->start_async(new IceAsync::IceGrid::AMD_Server_start(inS), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_stop(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->stop_async(new IceAsync::IceGrid::AMD_Server_stop(inS), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_checkUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalServerDescriptorPtr iceP_svr;
    bool iceP_noRestart;
    istr->read(iceP_svr);
    istr->read(iceP_noRestart);
    istr->readPendingValues();
    inS.endReadParams();
    bool ret = this->checkUpdate(iceP_svr, iceP_noRestart, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_setEnabled(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    bool iceP_enable;
    istr->read(iceP_enable);
    inS.endReadParams();
    this->setEnabled(iceP_enable, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_isEnabled(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    bool ret = this->isEnabled(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_sendSignal(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_signal;
    istr->read(iceP_signal);
    inS.endReadParams();
    this->sendSignal(iceP_signal, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_writeMessage(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_message;
    ::Ice::Int iceP_fd;
    istr->read(iceP_message);
    istr->read(iceP_fd);
    inS.endReadParams();
    this->writeMessage(iceP_message, iceP_fd, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_getState(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ServerState ret = this->getState(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_getPid(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->getPid(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Server::_iceD_setProcess(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::ProcessPrx iceP_proc;
    istr->read(iceP_proc);
    inS.endReadParams();
    this->setProcess_async(new IceAsync::IceGrid::AMD_Server_setProcess(inS), iceP_proc, current);
    return false;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Server_all[] =
{
    "checkUpdate",
    "getOffsetFromEnd",
    "getPid",
    "getState",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "isEnabled",
    "read",
    "sendSignal",
    "setEnabled",
    "setProcess",
    "start",
    "stop",
    "writeMessage"
};

}

/// \cond INTERNAL
bool
IceGrid::Server::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Server_all, iceC_IceGrid_Server_all + 16, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Server_all)
    {
        case 0:
        {
            return _iceD_checkUpdate(in, current);
        }
        case 1:
        {
            return _iceD_getOffsetFromEnd(in, current);
        }
        case 2:
        {
            return _iceD_getPid(in, current);
        }
        case 3:
        {
            return _iceD_getState(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        case 8:
        {
            return _iceD_isEnabled(in, current);
        }
        case 9:
        {
            return _iceD_read(in, current);
        }
        case 10:
        {
            return _iceD_sendSignal(in, current);
        }
        case 11:
        {
            return _iceD_setEnabled(in, current);
        }
        case 12:
        {
            return _iceD_setProcess(in, current);
        }
        case 13:
        {
            return _iceD_start(in, current);
        }
        case 14:
        {
            return _iceD_stop(in, current);
        }
        case 15:
        {
            return _iceD_writeMessage(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::Server::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Server, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::Server::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Server, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(ServerPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ServerPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Server::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::ReplicaObserver::~ReplicaObserver()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(ReplicaObserver* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_ReplicaObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::ReplicaObserver"
};

}

bool
IceGrid::ReplicaObserver::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_ReplicaObserver_ids, iceC_IceGrid_ReplicaObserver_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::ReplicaObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_ReplicaObserver_ids[0], &iceC_IceGrid_ReplicaObserver_ids[2]);
}

const ::std::string&
IceGrid::ReplicaObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::ReplicaObserver::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::ReplicaObserver";
    return typeId;
#else
    return iceC_IceGrid_ReplicaObserver_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::ReplicaObserver::_iceD_replicaInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalRegistryPrxSeq iceP_replicas;
    istr->read(iceP_replicas);
    inS.endReadParams();
    this->replicaInit(iceP_replicas, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaObserver::_iceD_replicaAdded(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalRegistryPrx iceP_replica;
    istr->read(iceP_replica);
    inS.endReadParams();
    this->replicaAdded(iceP_replica, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaObserver::_iceD_replicaRemoved(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalRegistryPrx iceP_replica;
    istr->read(iceP_replica);
    inS.endReadParams();
    this->replicaRemoved(iceP_replica, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_ReplicaObserver_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "replicaAdded",
    "replicaInit",
    "replicaRemoved"
};

}

/// \cond INTERNAL
bool
IceGrid::ReplicaObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_ReplicaObserver_all, iceC_IceGrid_ReplicaObserver_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_ReplicaObserver_all)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_replicaAdded(in, current);
        }
        case 5:
        {
            return _iceD_replicaInit(in, current);
        }
        case 6:
        {
            return _iceD_replicaRemoved(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::ReplicaObserver::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< ReplicaObserver, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::ReplicaObserver::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< ReplicaObserver, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(ReplicaObserverPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ReplicaObserverPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(ReplicaObserver::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::PatcherFeedback::~PatcherFeedback()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(PatcherFeedback* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_PatcherFeedback_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::PatcherFeedback"
};

}

bool
IceGrid::PatcherFeedback::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_PatcherFeedback_ids, iceC_IceGrid_PatcherFeedback_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::PatcherFeedback::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_PatcherFeedback_ids[0], &iceC_IceGrid_PatcherFeedback_ids[2]);
}

const ::std::string&
IceGrid::PatcherFeedback::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::PatcherFeedback::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::PatcherFeedback";
    return typeId;
#else
    return iceC_IceGrid_PatcherFeedback_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::PatcherFeedback::_iceD_finished(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->finished(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::PatcherFeedback::_iceD_failed(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_reason;
    istr->read(iceP_reason);
    inS.endReadParams();
    this->failed(iceP_reason, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_PatcherFeedback_all[] =
{
    "failed",
    "finished",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IceGrid::PatcherFeedback::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_PatcherFeedback_all, iceC_IceGrid_PatcherFeedback_all + 6, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_PatcherFeedback_all)
    {
        case 0:
        {
            return _iceD_failed(in, current);
        }
        case 1:
        {
            return _iceD_finished(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::PatcherFeedback::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< PatcherFeedback, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::PatcherFeedback::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< PatcherFeedback, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(PatcherFeedbackPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = PatcherFeedbackPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(PatcherFeedback::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::Node::~Node()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(Node* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Node_ids[4] =
{
    "::Ice::Object",
    "::IceGrid::FileReader",
    "::IceGrid::Node",
    "::IceGrid::ReplicaObserver"
};

}

bool
IceGrid::Node::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Node_ids, iceC_IceGrid_Node_ids + 4, s);
}

::std::vector< ::std::string>
IceGrid::Node::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_Node_ids[0], &iceC_IceGrid_Node_ids[4]);
}

const ::std::string&
IceGrid::Node::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Node::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::Node";
    return typeId;
#else
    return iceC_IceGrid_Node_ids[2];
#endif
}

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_loadServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalServerDescriptorPtr iceP_svr;
    ::std::string iceP_replicaName;
    istr->read(iceP_svr);
    istr->read(iceP_replicaName);
    istr->readPendingValues();
    inS.endReadParams();
    this->loadServer_async(new IceAsync::IceGrid::AMD_Node_loadServer(inS), iceP_svr, iceP_replicaName, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_loadServerWithoutRestart(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalServerDescriptorPtr iceP_svr;
    ::std::string iceP_replicaName;
    istr->read(iceP_svr);
    istr->read(iceP_replicaName);
    istr->readPendingValues();
    inS.endReadParams();
    this->loadServerWithoutRestart_async(new IceAsync::IceGrid::AMD_Node_loadServerWithoutRestart(inS), iceP_svr, iceP_replicaName, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_destroyServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    ::std::string iceP_uuid;
    ::Ice::Int iceP_revision;
    ::std::string iceP_replicaName;
    istr->read(iceP_name);
    istr->read(iceP_uuid);
    istr->read(iceP_revision);
    istr->read(iceP_replicaName);
    inS.endReadParams();
    this->destroyServer_async(new IceAsync::IceGrid::AMD_Node_destroyServer(inS), iceP_name, iceP_uuid, iceP_revision, iceP_replicaName, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_destroyServerWithoutRestart(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    ::std::string iceP_uuid;
    ::Ice::Int iceP_revision;
    ::std::string iceP_replicaName;
    istr->read(iceP_name);
    istr->read(iceP_uuid);
    istr->read(iceP_revision);
    istr->read(iceP_replicaName);
    inS.endReadParams();
    this->destroyServerWithoutRestart_async(new IceAsync::IceGrid::AMD_Node_destroyServerWithoutRestart(inS), iceP_name, iceP_uuid, iceP_revision, iceP_replicaName, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_patch(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    PatcherFeedbackPrx iceP_feedback;
    ::std::string iceP_application;
    ::std::string iceP_server;
    InternalDistributionDescriptorPtr iceP_appDistrib;
    bool iceP_shutdown;
    istr->read(iceP_feedback);
    istr->read(iceP_application);
    istr->read(iceP_server);
    istr->read(iceP_appDistrib);
    istr->read(iceP_shutdown);
    istr->readPendingValues();
    inS.endReadParams();
    this->patch_async(new IceAsync::IceGrid::AMD_Node_patch(inS), iceP_feedback, iceP_application, iceP_server, iceP_appDistrib, iceP_shutdown, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_registerWithReplica(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalRegistryPrx iceP_replica;
    istr->read(iceP_replica);
    inS.endReadParams();
    this->registerWithReplica(iceP_replica, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_getName(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getName(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_getHostname(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getHostname(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_getLoad(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    LoadInfo ret = this->getLoad(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_getProcessorSocketCount(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->getProcessorSocketCount(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Node::_iceD_shutdown(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    this->shutdown(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Node_all[] =
{
    "destroyServer",
    "destroyServerWithoutRestart",
    "getHostname",
    "getLoad",
    "getName",
    "getOffsetFromEnd",
    "getProcessorSocketCount",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "loadServer",
    "loadServerWithoutRestart",
    "patch",
    "read",
    "registerWithReplica",
    "replicaAdded",
    "replicaInit",
    "replicaRemoved",
    "shutdown"
};

}

/// \cond INTERNAL
bool
IceGrid::Node::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Node_all, iceC_IceGrid_Node_all + 20, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Node_all)
    {
        case 0:
        {
            return _iceD_destroyServer(in, current);
        }
        case 1:
        {
            return _iceD_destroyServerWithoutRestart(in, current);
        }
        case 2:
        {
            return _iceD_getHostname(in, current);
        }
        case 3:
        {
            return _iceD_getLoad(in, current);
        }
        case 4:
        {
            return _iceD_getName(in, current);
        }
        case 5:
        {
            return _iceD_getOffsetFromEnd(in, current);
        }
        case 6:
        {
            return _iceD_getProcessorSocketCount(in, current);
        }
        case 7:
        {
            return _iceD_ice_id(in, current);
        }
        case 8:
        {
            return _iceD_ice_ids(in, current);
        }
        case 9:
        {
            return _iceD_ice_isA(in, current);
        }
        case 10:
        {
            return _iceD_ice_ping(in, current);
        }
        case 11:
        {
            return _iceD_loadServer(in, current);
        }
        case 12:
        {
            return _iceD_loadServerWithoutRestart(in, current);
        }
        case 13:
        {
            return _iceD_patch(in, current);
        }
        case 14:
        {
            return _iceD_read(in, current);
        }
        case 15:
        {
            return _iceD_registerWithReplica(in, current);
        }
        case 16:
        {
            return _iceD_replicaAdded(in, current);
        }
        case 17:
        {
            return _iceD_replicaInit(in, current);
        }
        case 18:
        {
            return _iceD_replicaRemoved(in, current);
        }
        case 19:
        {
            return _iceD_shutdown(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::Node::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Node, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::Node::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Node, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(NodePtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = NodePtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Node::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::NodeSession::~NodeSession()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(NodeSession* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_NodeSession_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::NodeSession"
};

}

bool
IceGrid::NodeSession::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_NodeSession_ids, iceC_IceGrid_NodeSession_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::NodeSession::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_NodeSession_ids[0], &iceC_IceGrid_NodeSession_ids[2]);
}

const ::std::string&
IceGrid::NodeSession::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::NodeSession::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::NodeSession";
    return typeId;
#else
    return iceC_IceGrid_NodeSession_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_keepAlive(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    LoadInfo iceP_load;
    istr->read(iceP_load);
    inS.endReadParams();
    this->keepAlive(iceP_load, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_setReplicaObserver(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ReplicaObserverPrx iceP_observer;
    istr->read(iceP_observer);
    inS.endReadParams();
    this->setReplicaObserver(iceP_observer, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_getTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->getTimeout(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_getObserver(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    NodeObserverPrx ret = this->getObserver(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_loadServers(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    this->loadServers_async(new IceAsync::IceGrid::AMD_NodeSession_loadServers(inS), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_getServers(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getServers(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_waitForApplicationUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_application;
    ::Ice::Int iceP_revision;
    istr->read(iceP_application);
    istr->read(iceP_revision);
    inS.endReadParams();
    this->waitForApplicationUpdate_async(new IceAsync::IceGrid::AMD_NodeSession_waitForApplicationUpdate(inS), iceP_application, iceP_revision, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_NodeSession_all[] =
{
    "destroy",
    "getObserver",
    "getServers",
    "getTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "keepAlive",
    "loadServers",
    "setReplicaObserver",
    "waitForApplicationUpdate"
};

}

/// \cond INTERNAL
bool
IceGrid::NodeSession::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_NodeSession_all, iceC_IceGrid_NodeSession_all + 12, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_NodeSession_all)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_getObserver(in, current);
        }
        case 2:
        {
            return _iceD_getServers(in, current);
        }
        case 3:
        {
            return _iceD_getTimeout(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        case 8:
        {
            return _iceD_keepAlive(in, current);
        }
        case 9:
        {
            return _iceD_loadServers(in, current);
        }
        case 10:
        {
            return _iceD_setReplicaObserver(in, current);
        }
        case 11:
        {
            return _iceD_waitForApplicationUpdate(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::NodeSession::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< NodeSession, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::NodeSession::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< NodeSession, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(NodeSessionPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = NodeSessionPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(NodeSession::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::DatabaseObserver::~DatabaseObserver()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(DatabaseObserver* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_DatabaseObserver_ids[5] =
{
    "::Ice::Object",
    "::IceGrid::AdapterObserver",
    "::IceGrid::ApplicationObserver",
    "::IceGrid::DatabaseObserver",
    "::IceGrid::ObjectObserver"
};

}

bool
IceGrid::DatabaseObserver::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_DatabaseObserver_ids, iceC_IceGrid_DatabaseObserver_ids + 5, s);
}

::std::vector< ::std::string>
IceGrid::DatabaseObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_DatabaseObserver_ids[0], &iceC_IceGrid_DatabaseObserver_ids[5]);
}

const ::std::string&
IceGrid::DatabaseObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::DatabaseObserver::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::DatabaseObserver";
    return typeId;
#else
    return iceC_IceGrid_DatabaseObserver_ids[3];
#endif
}

namespace
{
const ::std::string iceC_IceGrid_DatabaseObserver_all[] =
{
    "adapterAdded",
    "adapterInit",
    "adapterRemoved",
    "adapterUpdated",
    "applicationAdded",
    "applicationInit",
    "applicationRemoved",
    "applicationUpdated",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "objectAdded",
    "objectInit",
    "objectRemoved",
    "objectUpdated"
};

}

/// \cond INTERNAL
bool
IceGrid::DatabaseObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_DatabaseObserver_all, iceC_IceGrid_DatabaseObserver_all + 16, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_DatabaseObserver_all)
    {
        case 0:
        {
            return _iceD_adapterAdded(in, current);
        }
        case 1:
        {
            return _iceD_adapterInit(in, current);
        }
        case 2:
        {
            return _iceD_adapterRemoved(in, current);
        }
        case 3:
        {
            return _iceD_adapterUpdated(in, current);
        }
        case 4:
        {
            return _iceD_applicationAdded(in, current);
        }
        case 5:
        {
            return _iceD_applicationInit(in, current);
        }
        case 6:
        {
            return _iceD_applicationRemoved(in, current);
        }
        case 7:
        {
            return _iceD_applicationUpdated(in, current);
        }
        case 8:
        {
            return _iceD_ice_id(in, current);
        }
        case 9:
        {
            return _iceD_ice_ids(in, current);
        }
        case 10:
        {
            return _iceD_ice_isA(in, current);
        }
        case 11:
        {
            return _iceD_ice_ping(in, current);
        }
        case 12:
        {
            return _iceD_objectAdded(in, current);
        }
        case 13:
        {
            return _iceD_objectInit(in, current);
        }
        case 14:
        {
            return _iceD_objectRemoved(in, current);
        }
        case 15:
        {
            return _iceD_objectUpdated(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::DatabaseObserver::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< DatabaseObserver, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::DatabaseObserver::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< DatabaseObserver, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(DatabaseObserverPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = DatabaseObserverPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(DatabaseObserver::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::ReplicaSession::~ReplicaSession()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(ReplicaSession* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_ReplicaSession_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::ReplicaSession"
};

}

bool
IceGrid::ReplicaSession::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_ReplicaSession_ids, iceC_IceGrid_ReplicaSession_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::ReplicaSession::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_ReplicaSession_ids[0], &iceC_IceGrid_ReplicaSession_ids[2]);
}

const ::std::string&
IceGrid::ReplicaSession::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::ReplicaSession::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::ReplicaSession";
    return typeId;
#else
    return iceC_IceGrid_ReplicaSession_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_keepAlive(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->keepAlive(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_getTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->getTimeout(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_setDatabaseObserver(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    DatabaseObserverPrx iceP_dbObs;
    IceUtil::Optional<StringLongDict> iceP_serials;
    istr->read(iceP_dbObs);
    istr->read(1, iceP_serials);
    inS.endReadParams();
    this->setDatabaseObserver(iceP_dbObs, iceP_serials, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_setEndpoints(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    StringObjectProxyDict iceP_endpoints;
    istr->read(iceP_endpoints);
    inS.endReadParams();
    this->setEndpoints(iceP_endpoints, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_registerWellKnownObjects(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ObjectInfoSeq iceP_objects;
    istr->read(iceP_objects);
    inS.endReadParams();
    this->registerWellKnownObjects(iceP_objects, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_setAdapterDirectProxy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_adapterId;
    ::std::string iceP_replicaGroupId;
    ::Ice::ObjectPrx iceP_proxy;
    istr->read(iceP_adapterId);
    istr->read(iceP_replicaGroupId);
    istr->read(iceP_proxy);
    inS.endReadParams();
    this->setAdapterDirectProxy(iceP_adapterId, iceP_replicaGroupId, iceP_proxy, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_receivedUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    TopicName iceP_name;
    ::Ice::Int iceP_serial;
    ::std::string iceP_failure;
    istr->read(iceP_name);
    istr->read(iceP_serial);
    istr->read(iceP_failure);
    inS.endReadParams();
    this->receivedUpdate(iceP_name, iceP_serial, iceP_failure, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_ReplicaSession_all[] =
{
    "destroy",
    "getTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "keepAlive",
    "receivedUpdate",
    "registerWellKnownObjects",
    "setAdapterDirectProxy",
    "setDatabaseObserver",
    "setEndpoints"
};

}

/// \cond INTERNAL
bool
IceGrid::ReplicaSession::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_ReplicaSession_all, iceC_IceGrid_ReplicaSession_all + 12, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_ReplicaSession_all)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_getTimeout(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_keepAlive(in, current);
        }
        case 7:
        {
            return _iceD_receivedUpdate(in, current);
        }
        case 8:
        {
            return _iceD_registerWellKnownObjects(in, current);
        }
        case 9:
        {
            return _iceD_setAdapterDirectProxy(in, current);
        }
        case 10:
        {
            return _iceD_setDatabaseObserver(in, current);
        }
        case 11:
        {
            return _iceD_setEndpoints(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::ReplicaSession::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< ReplicaSession, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::ReplicaSession::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< ReplicaSession, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(ReplicaSessionPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ReplicaSessionPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(ReplicaSession::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::InternalNodeInfo::~InternalNodeInfo()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(InternalNodeInfo* p) { return p; }

/// \endcond
::Ice::ObjectPtr
IceGrid::InternalNodeInfo::ice_clone() const
{
    ::Ice::Object* p = new InternalNodeInfo(*this);
    return p;
}

namespace
{
const ::std::string iceC_IceGrid_InternalNodeInfo_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::InternalNodeInfo"
};

}

bool
IceGrid::InternalNodeInfo::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_InternalNodeInfo_ids, iceC_IceGrid_InternalNodeInfo_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::InternalNodeInfo::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_InternalNodeInfo_ids[0], &iceC_IceGrid_InternalNodeInfo_ids[2]);
}

const ::std::string&
IceGrid::InternalNodeInfo::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::InternalNodeInfo::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::InternalNodeInfo";
    return typeId;
#else
    return iceC_IceGrid_InternalNodeInfo_ids[1];
#endif
}

/// \cond STREAM
void
IceGrid::InternalNodeInfo::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< InternalNodeInfo, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::InternalNodeInfo::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< InternalNodeInfo, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{
const ::IceInternal::DefaultValueFactoryInit< ::IceGrid::InternalNodeInfo> iceC_IceGrid_InternalNodeInfo_init("::IceGrid::InternalNodeInfo");
}

::Ice::ValueFactoryPtr
IceGrid::InternalNodeInfo::ice_factory()
{
    return ::IceInternal::factoryTable->getValueFactory(::IceGrid::InternalNodeInfo::ice_staticId());
}

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(InternalNodeInfoPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = InternalNodeInfoPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(InternalNodeInfo::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::InternalReplicaInfo::~InternalReplicaInfo()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(InternalReplicaInfo* p) { return p; }

/// \endcond
::Ice::ObjectPtr
IceGrid::InternalReplicaInfo::ice_clone() const
{
    ::Ice::Object* p = new InternalReplicaInfo(*this);
    return p;
}

namespace
{
const ::std::string iceC_IceGrid_InternalReplicaInfo_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::InternalReplicaInfo"
};

}

bool
IceGrid::InternalReplicaInfo::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_InternalReplicaInfo_ids, iceC_IceGrid_InternalReplicaInfo_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::InternalReplicaInfo::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_InternalReplicaInfo_ids[0], &iceC_IceGrid_InternalReplicaInfo_ids[2]);
}

const ::std::string&
IceGrid::InternalReplicaInfo::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::InternalReplicaInfo::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::InternalReplicaInfo";
    return typeId;
#else
    return iceC_IceGrid_InternalReplicaInfo_ids[1];
#endif
}

/// \cond STREAM
void
IceGrid::InternalReplicaInfo::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< InternalReplicaInfo, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::InternalReplicaInfo::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< InternalReplicaInfo, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

namespace
{
const ::IceInternal::DefaultValueFactoryInit< ::IceGrid::InternalReplicaInfo> iceC_IceGrid_InternalReplicaInfo_init("::IceGrid::InternalReplicaInfo");
}

::Ice::ValueFactoryPtr
IceGrid::InternalReplicaInfo::ice_factory()
{
    return ::IceInternal::factoryTable->getValueFactory(::IceGrid::InternalReplicaInfo::ice_staticId());
}

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(InternalReplicaInfoPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = InternalReplicaInfoPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(InternalReplicaInfo::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::InternalRegistry::~InternalRegistry()
{
}

/// \cond INTERNAL
::Ice::Object* IceGrid::upCast(InternalRegistry* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_InternalRegistry_ids[3] =
{
    "::Ice::Object",
    "::IceGrid::FileReader",
    "::IceGrid::InternalRegistry"
};

}

bool
IceGrid::InternalRegistry::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_InternalRegistry_ids, iceC_IceGrid_InternalRegistry_ids + 3, s);
}

::std::vector< ::std::string>
IceGrid::InternalRegistry::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_InternalRegistry_ids[0], &iceC_IceGrid_InternalRegistry_ids[3]);
}

const ::std::string&
IceGrid::InternalRegistry::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::InternalRegistry::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::InternalRegistry";
    return typeId;
#else
    return iceC_IceGrid_InternalRegistry_ids[2];
#endif
}

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_registerNode(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalNodeInfoPtr iceP_info;
    NodePrx iceP_prx;
    LoadInfo iceP_loadInf;
    istr->read(iceP_info);
    istr->read(iceP_prx);
    istr->read(iceP_loadInf);
    istr->readPendingValues();
    inS.endReadParams();
    NodeSessionPrx ret = this->registerNode(iceP_info, iceP_prx, iceP_loadInf, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_registerReplica(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalReplicaInfoPtr iceP_info;
    InternalRegistryPrx iceP_prx;
    istr->read(iceP_info);
    istr->read(iceP_prx);
    istr->readPendingValues();
    inS.endReadParams();
    ReplicaSessionPrx ret = this->registerReplica(iceP_info, iceP_prx, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_registerWithReplica(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    InternalRegistryPrx iceP_prx;
    istr->read(iceP_prx);
    inS.endReadParams();
    this->registerWithReplica(iceP_prx, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getNodes(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    NodePrxSeq ret = this->getNodes(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getReplicas(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    InternalRegistryPrxSeq ret = this->getReplicas(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getApplications(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Long iceP_serial;
    ApplicationInfoSeq ret = this->getApplications(iceP_serial, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(iceP_serial);
    ostr->write(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getAdapters(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Long iceP_serial;
    AdapterInfoSeq ret = this->getAdapters(iceP_serial, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(iceP_serial);
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_getObjects(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Long iceP_serial;
    ObjectInfoSeq ret = this->getObjects(iceP_serial, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(iceP_serial);
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceD_shutdown(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    this->shutdown(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_InternalRegistry_all[] =
{
    "getAdapters",
    "getApplications",
    "getNodes",
    "getObjects",
    "getOffsetFromEnd",
    "getReplicas",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "read",
    "registerNode",
    "registerReplica",
    "registerWithReplica",
    "shutdown"
};

}

/// \cond INTERNAL
bool
IceGrid::InternalRegistry::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_InternalRegistry_all, iceC_IceGrid_InternalRegistry_all + 15, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_InternalRegistry_all)
    {
        case 0:
        {
            return _iceD_getAdapters(in, current);
        }
        case 1:
        {
            return _iceD_getApplications(in, current);
        }
        case 2:
        {
            return _iceD_getNodes(in, current);
        }
        case 3:
        {
            return _iceD_getObjects(in, current);
        }
        case 4:
        {
            return _iceD_getOffsetFromEnd(in, current);
        }
        case 5:
        {
            return _iceD_getReplicas(in, current);
        }
        case 6:
        {
            return _iceD_ice_id(in, current);
        }
        case 7:
        {
            return _iceD_ice_ids(in, current);
        }
        case 8:
        {
            return _iceD_ice_isA(in, current);
        }
        case 9:
        {
            return _iceD_ice_ping(in, current);
        }
        case 10:
        {
            return _iceD_read(in, current);
        }
        case 11:
        {
            return _iceD_registerNode(in, current);
        }
        case 12:
        {
            return _iceD_registerReplica(in, current);
        }
        case 13:
        {
            return _iceD_registerWithReplica(in, current);
        }
        case 14:
        {
            return _iceD_shutdown(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::InternalRegistry::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< InternalRegistry, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::InternalRegistry::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< InternalRegistry, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(InternalRegistryPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = InternalRegistryPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(InternalRegistry::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
