/* UserBox.c generated by valac 0.56.17, the Vala compiler
 * generated from UserBox.vala, do not modify */

/*
 * Copyright (c) 2011-2017 elementary LLC. (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#include "session.h"
#include <act/act.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <handy.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>

#define SESSION_WIDGETS_USERBOX_ICON_SIZE 48
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SESSION_WIDGETS_USERBOX_0_PROPERTY,
	SESSION_WIDGETS_USERBOX_USER_PROPERTY,
	SESSION_WIDGETS_USERBOX_FULLNAME_PROPERTY,
	SESSION_WIDGETS_USERBOX_STATE_PROPERTY,
	SESSION_WIDGETS_USERBOX_IS_GUEST_PROPERTY,
	SESSION_WIDGETS_USERBOX_NUM_PROPERTIES
};
static GParamSpec* session_widgets_userbox_properties[SESSION_WIDGETS_USERBOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SessionWidgetsUserboxGetUserStateData SessionWidgetsUserboxGetUserStateData;
typedef struct _SessionWidgetsUserboxUpdateStateData SessionWidgetsUserboxUpdateStateData;

struct _SessionWidgetsUserboxPrivate {
	ActUser* _user;
	gchar* _fullname;
	UserState _state;
	HdyAvatar* avatar;
	GtkLabel* fullname_label;
	GtkLabel* status_label;
};

struct _SessionWidgetsUserboxGetUserStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SessionWidgetsUserbox* self;
	UserState result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ActUser* _tmp2_;
};

struct _SessionWidgetsUserboxUpdateStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SessionWidgetsUserbox* self;
	UserState _tmp0_;
	UserState _tmp1_;
	gboolean _tmp2_;
	UserState _tmp3_;
	UserState _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
};

static gint SessionWidgetsUserbox_private_offset;
static gpointer session_widgets_userbox_parent_class = NULL;

static GdkPixbuf* session_widgets_userbox_avatar_image_load_func (SessionWidgetsUserbox* self,
                                                           gint size);
static void session_widgets_userbox_get_user_state_data_free (gpointer _data);
static gboolean session_widgets_userbox_get_user_state_co (SessionWidgetsUserboxGetUserStateData* _data_);
static void session_widgets_userbox_get_user_state_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void session_widgets_userbox_update (SessionWidgetsUserbox* self);
static GdkPixbuf* _session_widgets_userbox_avatar_image_load_func_hdy_avatar_image_load_func (gint size,
                                                                                       gpointer self);
static void session_widgets_userbox_update_state_data_free (gpointer _data);
static gboolean session_widgets_userbox_update_state_co (SessionWidgetsUserboxUpdateStateData* _data_);
static void session_widgets_userbox_update_state_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void session_widgets_userbox_set_state (SessionWidgetsUserbox* self,
                                        UserState value);
static gboolean session_widgets_userbox_real_draw (GtkWidget* base,
                                            cairo_t* ctx);
static GObject * session_widgets_userbox_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _session_widgets_userbox____lambda4_ (SessionWidgetsUserbox* self);
static void __session_widgets_userbox____lambda4__act_user_changed (ActUser* _sender,
                                                             gpointer self);
static void session_widgets_userbox_finalize (GObject * obj);
static GType session_widgets_userbox_get_type_once (void);
static void _vala_session_widgets_userbox_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_session_widgets_userbox_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
session_widgets_userbox_get_instance_private (SessionWidgetsUserbox* self)
{
	return G_STRUCT_MEMBER_P (self, SessionWidgetsUserbox_private_offset);
}

SessionWidgetsUserbox*
session_widgets_userbox_construct (GType object_type,
                                   ActUser* user)
{
	SessionWidgetsUserbox * self = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	self = (SessionWidgetsUserbox*) g_object_new (object_type, "user", user, NULL);
	return self;
}

SessionWidgetsUserbox*
session_widgets_userbox_new (ActUser* user)
{
	return session_widgets_userbox_construct (SESSION_WIDGETS_TYPE_USERBOX, user);
}

SessionWidgetsUserbox*
session_widgets_userbox_construct_guest (GType object_type)
{
	SessionWidgetsUserbox * self = NULL;
	self = (SessionWidgetsUserbox*) g_object_new (object_type, "fullname", _ ("Guest"), NULL);
	return self;
}

SessionWidgetsUserbox*
session_widgets_userbox_new_guest (void)
{
	return session_widgets_userbox_construct_guest (SESSION_WIDGETS_TYPE_USERBOX);
}

static GdkPixbuf*
session_widgets_userbox_avatar_image_load_func (SessionWidgetsUserbox* self,
                                                gint size)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GdkPixbuf* pixbuf = NULL;
		ActUser* _tmp0_;
		const gchar* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp0_ = self->priv->_user;
		_tmp1_ = act_user_get_icon_file (_tmp0_);
		_tmp2_ = gdk_pixbuf_new_from_file (_tmp1_, &_inner_error0_);
		pixbuf = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = gdk_pixbuf_scale_simple (pixbuf, size, size, GDK_INTERP_BILINEAR);
		result = _tmp3_;
		_g_object_unref0 (pixbuf);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_debug ("UserBox.vala:109: %s", _tmp5_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
session_widgets_userbox_get_user_state_data_free (gpointer _data)
{
	SessionWidgetsUserboxGetUserStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SessionWidgetsUserboxGetUserStateData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
session_widgets_userbox_get_user_state (SessionWidgetsUserbox* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	SessionWidgetsUserboxGetUserStateData* _data_;
	SessionWidgetsUserbox* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SessionWidgetsUserboxGetUserStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, session_widgets_userbox_get_user_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	session_widgets_userbox_get_user_state_co (_data_);
}

UserState
session_widgets_userbox_get_user_state_finish (SessionWidgetsUserbox* self,
                                               GAsyncResult* _res_)
{
	UserState result;
	SessionWidgetsUserboxGetUserStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
session_widgets_userbox_get_user_state_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	SessionWidgetsUserboxGetUserStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	session_widgets_userbox_get_user_state_co (_data_);
}

static gboolean
session_widgets_userbox_get_user_state_co (SessionWidgetsUserboxGetUserStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = session_widgets_userbox_get_is_guest (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->_state_ = 1;
		session_services_user_manager_get_guest_state (session_widgets_userbox_get_user_state_ready, _data_);
		return FALSE;
		_state_1:
		_data_->result = session_services_user_manager_get_guest_state_finish (_data_->_res_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_user;
		_data_->_state_ = 2;
		session_services_user_manager_get_user_state ((guint32) act_user_get_uid (_data_->_tmp2_), session_widgets_userbox_get_user_state_ready, _data_);
		return FALSE;
		_state_2:
		_data_->result = session_services_user_manager_get_user_state_finish (_data_->_res_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static GdkPixbuf*
_session_widgets_userbox_avatar_image_load_func_hdy_avatar_image_load_func (gint size,
                                                                            gpointer self)
{
	GdkPixbuf* result;
	result = session_widgets_userbox_avatar_image_load_func ((SessionWidgetsUserbox*) self, size);
	return result;
}

static void
session_widgets_userbox_update (SessionWidgetsUserbox* self)
{
	ActUser* _tmp0_;
	GtkLabel* _tmp1_;
	ActUser* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	HdyAvatar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_user;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->fullname_label;
	_tmp2_ = self->priv->_user;
	_tmp3_ = act_user_get_real_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("<b>%s</b>", _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_label (_tmp1_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->avatar;
	hdy_avatar_set_image_load_func (_tmp7_, _session_widgets_userbox_avatar_image_load_func_hdy_avatar_image_load_func, g_object_ref (self), g_object_unref);
}

static void
session_widgets_userbox_update_state_data_free (gpointer _data)
{
	SessionWidgetsUserboxUpdateStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SessionWidgetsUserboxUpdateStateData, _data_);
}

void
session_widgets_userbox_update_state (SessionWidgetsUserbox* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SessionWidgetsUserboxUpdateStateData* _data_;
	SessionWidgetsUserbox* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SessionWidgetsUserboxUpdateStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, session_widgets_userbox_update_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	session_widgets_userbox_update_state_co (_data_);
}

void
session_widgets_userbox_update_state_finish (SessionWidgetsUserbox* self,
                                             GAsyncResult* _res_)
{
	SessionWidgetsUserboxUpdateStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
session_widgets_userbox_update_state_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	SessionWidgetsUserboxUpdateStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	session_widgets_userbox_update_state_co (_data_);
}

static gboolean
session_widgets_userbox_update_state_co (SessionWidgetsUserboxUpdateStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	session_widgets_userbox_get_user_state (_data_->self, session_widgets_userbox_update_state_ready, _data_);
	return FALSE;
	_state_1:
	session_widgets_userbox_set_state (_data_->self, session_widgets_userbox_get_user_state_finish (_data_->self, _data_->_res_));
	_data_->_tmp0_ = _data_->self->priv->_state;
	gtk_list_box_row_set_selectable ((GtkListBoxRow*) _data_->self, _data_->_tmp0_ != USER_STATE_ACTIVE);
	_data_->_tmp1_ = _data_->self->priv->_state;
	gtk_list_box_row_set_activatable ((GtkListBoxRow*) _data_->self, _data_->_tmp1_ != USER_STATE_ACTIVE);
	_data_->_tmp3_ = _data_->self->priv->_state;
	if (_data_->_tmp3_ == USER_STATE_ONLINE) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->_state;
		_data_->_tmp2_ = _data_->_tmp4_ == USER_STATE_ACTIVE;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp5_ = _data_->self->priv->status_label;
		gtk_label_set_label (_data_->_tmp5_, _ ("Logged in"));
	} else {
		_data_->_tmp6_ = _data_->self->priv->status_label;
		gtk_label_set_label (_data_->_tmp6_, _ ("Logged out"));
	}
	gtk_list_box_row_changed ((GtkListBoxRow*) _data_->self);
	gtk_widget_show_all ((GtkWidget*) _data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
session_widgets_userbox_real_draw (GtkWidget* base,
                                   cairo_t* ctx)
{
	SessionWidgetsUserbox * self;
	gboolean result;
	self = (SessionWidgetsUserbox*) base;
	g_return_val_if_fail (ctx != NULL, FALSE);
	if (!gtk_list_box_row_get_selectable ((GtkListBoxRow*) self)) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_set_state (_tmp0_, GTK_STATE_FLAG_NORMAL);
	}
	result = GTK_WIDGET_CLASS (session_widgets_userbox_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), ctx);
	return result;
}

ActUser*
session_widgets_userbox_get_user (SessionWidgetsUserbox* self)
{
	ActUser* result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
session_widgets_userbox_set_user (SessionWidgetsUserbox* self,
                                  ActUser* value)
{
	ActUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = session_widgets_userbox_get_user (self);
	if (old_value != value) {
		ActUser* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_user);
		self->priv->_user = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, session_widgets_userbox_properties[SESSION_WIDGETS_USERBOX_USER_PROPERTY]);
	}
}

const gchar*
session_widgets_userbox_get_fullname (SessionWidgetsUserbox* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_fullname;
	result = _tmp0_;
	return result;
}

void
session_widgets_userbox_set_fullname (SessionWidgetsUserbox* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = session_widgets_userbox_get_fullname (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_fullname);
		self->priv->_fullname = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, session_widgets_userbox_properties[SESSION_WIDGETS_USERBOX_FULLNAME_PROPERTY]);
	}
}

UserState
session_widgets_userbox_get_state (SessionWidgetsUserbox* self)
{
	UserState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
session_widgets_userbox_set_state (SessionWidgetsUserbox* self,
                                   UserState value)
{
	UserState old_value;
	g_return_if_fail (self != NULL);
	old_value = session_widgets_userbox_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, session_widgets_userbox_properties[SESSION_WIDGETS_USERBOX_STATE_PROPERTY]);
	}
}

gboolean
session_widgets_userbox_get_is_guest (SessionWidgetsUserbox* self)
{
	gboolean result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_user;
	result = _tmp0_ == NULL;
	return result;
}

static void
_session_widgets_userbox____lambda4_ (SessionWidgetsUserbox* self)
{
	session_widgets_userbox_update (self);
	session_widgets_userbox_update_state (self, NULL, NULL);
}

static void
__session_widgets_userbox____lambda4__act_user_changed (ActUser* _sender,
                                                        gpointer self)
{
	_session_widgets_userbox____lambda4_ ((SessionWidgetsUserbox*) self);
}

static GObject *
session_widgets_userbox_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SessionWidgetsUserbox * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	ActUser* _tmp5_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp31_ = NULL;
	GtkGrid* _tmp32_;
	HdyAvatar* _tmp33_;
	GtkGrid* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkStyleContext* _tmp38_;
	GtkGrid* _tmp39_;
	parent_class = G_OBJECT_CLASS (session_widgets_userbox_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SESSION_WIDGETS_TYPE_USERBOX, SessionWidgetsUserbox);
	_tmp0_ = self->priv->_fullname;
	_tmp1_ = g_strdup_printf ("<b>%s</b>", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	gtk_label_set_use_markup (_tmp3_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->fullname_label);
	self->priv->fullname_label = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->status_label);
	self->priv->status_label = _tmp4_;
	_tmp5_ = self->priv->_user;
	if (_tmp5_ == NULL) {
		HdyAvatar* _tmp6_;
		GtkStyleContext* avatar_context = NULL;
		HdyAvatar* _tmp7_;
		GtkStyleContext* _tmp8_;
		GtkStyleContext* _tmp9_;
		GtkStyleContext* _tmp10_;
		GtkStyleContext* _tmp11_;
		GtkStyleContext* _tmp12_;
		GtkStyleContext* _tmp13_;
		GtkStyleContext* _tmp14_;
		GtkStyleContext* _tmp15_;
		GtkStyleContext* _tmp16_;
		GtkStyleContext* _tmp17_;
		GtkStyleContext* _tmp18_;
		GtkStyleContext* _tmp19_;
		GtkStyleContext* _tmp20_;
		GtkStyleContext* _tmp21_;
		GtkStyleContext* _tmp22_;
		_tmp6_ = (HdyAvatar*) hdy_avatar_new (SESSION_WIDGETS_USERBOX_ICON_SIZE, NULL, FALSE);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->avatar);
		self->priv->avatar = _tmp6_;
		_tmp7_ = self->priv->avatar;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		avatar_context = _tmp8_;
		_tmp9_ = avatar_context;
		gtk_style_context_remove_class (_tmp9_, "color1");
		_tmp10_ = avatar_context;
		gtk_style_context_remove_class (_tmp10_, "color2");
		_tmp11_ = avatar_context;
		gtk_style_context_remove_class (_tmp11_, "color3");
		_tmp12_ = avatar_context;
		gtk_style_context_remove_class (_tmp12_, "color4");
		_tmp13_ = avatar_context;
		gtk_style_context_remove_class (_tmp13_, "color5");
		_tmp14_ = avatar_context;
		gtk_style_context_remove_class (_tmp14_, "color6");
		_tmp15_ = avatar_context;
		gtk_style_context_remove_class (_tmp15_, "color7");
		_tmp16_ = avatar_context;
		gtk_style_context_remove_class (_tmp16_, "color8");
		_tmp17_ = avatar_context;
		gtk_style_context_remove_class (_tmp17_, "color9");
		_tmp18_ = avatar_context;
		gtk_style_context_remove_class (_tmp18_, "color10");
		_tmp19_ = avatar_context;
		gtk_style_context_remove_class (_tmp19_, "color11");
		_tmp20_ = avatar_context;
		gtk_style_context_remove_class (_tmp20_, "color12");
		_tmp21_ = avatar_context;
		gtk_style_context_remove_class (_tmp21_, "color13");
		_tmp22_ = avatar_context;
		gtk_style_context_remove_class (_tmp22_, "color14");
	} else {
		const gchar* _tmp23_;
		HdyAvatar* _tmp24_;
		HdyAvatar* _tmp25_;
		ActUser* _tmp26_;
		ActUser* _tmp27_;
		ActUser* _tmp28_;
		ActUser* _tmp29_;
		HdyAvatar* _tmp30_;
		_tmp23_ = self->priv->_fullname;
		_tmp24_ = (HdyAvatar*) hdy_avatar_new (SESSION_WIDGETS_USERBOX_ICON_SIZE, _tmp23_, TRUE);
		g_object_ref_sink (_tmp24_);
		_g_object_unref0 (self->priv->avatar);
		self->priv->avatar = _tmp24_;
		_tmp25_ = self->priv->avatar;
		hdy_avatar_set_image_load_func (_tmp25_, _session_widgets_userbox_avatar_image_load_func_hdy_avatar_image_load_func, g_object_ref (self), g_object_unref);
		_tmp26_ = self->priv->_user;
		g_signal_connect_object (_tmp26_, "changed", (GCallback) __session_widgets_userbox____lambda4__act_user_changed, self, 0);
		_tmp27_ = self->priv->_user;
		g_object_bind_property_with_closures ((GObject*) _tmp27_, "locked", (GObject*) self, "visible", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp28_ = self->priv->_user;
		g_object_bind_property_with_closures ((GObject*) _tmp28_, "locked", (GObject*) self, "no-show-all", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp29_ = self->priv->_user;
		_tmp30_ = self->priv->avatar;
		g_object_bind_property_with_closures ((GObject*) _tmp29_, "real-name", (GObject*) _tmp30_, "text", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		session_widgets_userbox_update (self);
	}
	_tmp31_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp31_, 12);
	g_object_ref_sink (_tmp31_);
	grid = _tmp31_;
	_tmp32_ = grid;
	_tmp33_ = self->priv->avatar;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 0, 0, 3, 3);
	_tmp34_ = grid;
	_tmp35_ = self->priv->fullname_label;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 3, 0, 2, 1);
	_tmp36_ = grid;
	_tmp37_ = self->priv->status_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 3, 1, 2, 1);
	_tmp38_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp38_, "menuitem");
	_tmp39_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp39_);
	session_widgets_userbox_update_state (self, NULL, NULL);
	_g_object_unref0 (grid);
	return obj;
}

static void
session_widgets_userbox_class_init (SessionWidgetsUserboxClass * klass,
                                    gpointer klass_data)
{
	session_widgets_userbox_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SessionWidgetsUserbox_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) session_widgets_userbox_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_session_widgets_userbox_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_session_widgets_userbox_set_property;
	G_OBJECT_CLASS (klass)->constructor = session_widgets_userbox_constructor;
	G_OBJECT_CLASS (klass)->finalize = session_widgets_userbox_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_WIDGETS_USERBOX_USER_PROPERTY, session_widgets_userbox_properties[SESSION_WIDGETS_USERBOX_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", act_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_WIDGETS_USERBOX_FULLNAME_PROPERTY, session_widgets_userbox_properties[SESSION_WIDGETS_USERBOX_FULLNAME_PROPERTY] = g_param_spec_string ("fullname", "fullname", "fullname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_WIDGETS_USERBOX_STATE_PROPERTY, session_widgets_userbox_properties[SESSION_WIDGETS_USERBOX_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", TYPE_USER_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_WIDGETS_USERBOX_IS_GUEST_PROPERTY, session_widgets_userbox_properties[SESSION_WIDGETS_USERBOX_IS_GUEST_PROPERTY] = g_param_spec_boolean ("is-guest", "is-guest", "is-guest", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
session_widgets_userbox_instance_init (SessionWidgetsUserbox * self,
                                       gpointer klass)
{
	self->priv = session_widgets_userbox_get_instance_private (self);
	self->priv->_user = NULL;
}

static void
session_widgets_userbox_finalize (GObject * obj)
{
	SessionWidgetsUserbox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SESSION_WIDGETS_TYPE_USERBOX, SessionWidgetsUserbox);
	_g_object_unref0 (self->priv->_user);
	_g_free0 (self->priv->_fullname);
	_g_object_unref0 (self->priv->avatar);
	_g_object_unref0 (self->priv->fullname_label);
	_g_object_unref0 (self->priv->status_label);
	G_OBJECT_CLASS (session_widgets_userbox_parent_class)->finalize (obj);
}

static GType
session_widgets_userbox_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionWidgetsUserboxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_widgets_userbox_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionWidgetsUserbox), 0, (GInstanceInitFunc) session_widgets_userbox_instance_init, NULL };
	GType session_widgets_userbox_type_id;
	session_widgets_userbox_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SessionWidgetsUserbox", &g_define_type_info, 0);
	SessionWidgetsUserbox_private_offset = g_type_add_instance_private (session_widgets_userbox_type_id, sizeof (SessionWidgetsUserboxPrivate));
	return session_widgets_userbox_type_id;
}

GType
session_widgets_userbox_get_type (void)
{
	static volatile gsize session_widgets_userbox_type_id__once = 0;
	if (g_once_init_enter (&session_widgets_userbox_type_id__once)) {
		GType session_widgets_userbox_type_id;
		session_widgets_userbox_type_id = session_widgets_userbox_get_type_once ();
		g_once_init_leave (&session_widgets_userbox_type_id__once, session_widgets_userbox_type_id);
	}
	return session_widgets_userbox_type_id__once;
}

static void
_vala_session_widgets_userbox_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	SessionWidgetsUserbox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SESSION_WIDGETS_TYPE_USERBOX, SessionWidgetsUserbox);
	switch (property_id) {
		case SESSION_WIDGETS_USERBOX_USER_PROPERTY:
		g_value_set_object (value, session_widgets_userbox_get_user (self));
		break;
		case SESSION_WIDGETS_USERBOX_FULLNAME_PROPERTY:
		g_value_set_string (value, session_widgets_userbox_get_fullname (self));
		break;
		case SESSION_WIDGETS_USERBOX_STATE_PROPERTY:
		g_value_set_enum (value, session_widgets_userbox_get_state (self));
		break;
		case SESSION_WIDGETS_USERBOX_IS_GUEST_PROPERTY:
		g_value_set_boolean (value, session_widgets_userbox_get_is_guest (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_session_widgets_userbox_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	SessionWidgetsUserbox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SESSION_WIDGETS_TYPE_USERBOX, SessionWidgetsUserbox);
	switch (property_id) {
		case SESSION_WIDGETS_USERBOX_USER_PROPERTY:
		session_widgets_userbox_set_user (self, g_value_get_object (value));
		break;
		case SESSION_WIDGETS_USERBOX_FULLNAME_PROPERTY:
		session_widgets_userbox_set_fullname (self, g_value_get_string (value));
		break;
		case SESSION_WIDGETS_USERBOX_STATE_PROPERTY:
		session_widgets_userbox_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

