// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "OutlineProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::OutlinePropertyPrivate
{
public:
    std::optional<LineProperty> left;
    std::optional<LineProperty> right;
    std::optional<LineProperty> top;
    std::optional<LineProperty> bottom;
};

OutlineProperty::OutlineProperty()
    : d(std::make_unique<OutlinePropertyPrivate>())
{
}

OutlineProperty::OutlineProperty(const OutlineProperty &other)
    : d(std::make_unique<OutlinePropertyPrivate>())
{
    d->left = other.d->left;
    d->right = other.d->right;
    d->top = other.d->top;
    d->bottom = other.d->bottom;
}

OutlineProperty::OutlineProperty(OutlineProperty &&other)
    : d(std::move(other.d))
{
}

OutlineProperty::~OutlineProperty() = default;

OutlineProperty &OutlineProperty::operator=(const OutlineProperty &other)
{
    if (this != &other) {
        d->left = other.d->left;
        d->right = other.d->right;
        d->top = other.d->top;
        d->bottom = other.d->bottom;
    }
    return *this;
}

OutlineProperty &OutlineProperty::operator=(OutlineProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<LineProperty> OutlineProperty::left() const
{
    return d->left;
}

LineProperty OutlineProperty::left_or_new() const
{
    return d->left.value_or(LineProperty{});
}

void OutlineProperty::setLeft(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->left) {
        return;
    }

    d->left = newValue;
}
std::optional<LineProperty> OutlineProperty::right() const
{
    return d->right;
}

LineProperty OutlineProperty::right_or_new() const
{
    return d->right.value_or(LineProperty{});
}

void OutlineProperty::setRight(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->right) {
        return;
    }

    d->right = newValue;
}
std::optional<LineProperty> OutlineProperty::top() const
{
    return d->top;
}

LineProperty OutlineProperty::top_or_new() const
{
    return d->top.value_or(LineProperty{});
}

void OutlineProperty::setTop(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->top) {
        return;
    }

    d->top = newValue;
}
std::optional<LineProperty> OutlineProperty::bottom() const
{
    return d->bottom;
}

LineProperty OutlineProperty::bottom_or_new() const
{
    return d->bottom.value_or(LineProperty{});
}

void OutlineProperty::setBottom(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->bottom) {
        return;
    }

    d->bottom = newValue;
}

bool OutlineProperty::hasAnyValue() const
{
    if (d->left.has_value() && d->left->hasAnyValue()) {
        return true;
    }
    if (d->right.has_value() && d->right->hasAnyValue()) {
        return true;
    }
    if (d->top.has_value() && d->top->hasAnyValue()) {
        return true;
    }
    if (d->bottom.has_value() && d->bottom->hasAnyValue()) {
        return true;
    }
    return false;
}

bool OutlineProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->left.has_value() && !d->left->isEmpty()) {
        return false;
    }
    if (d->right.has_value() && !d->right->isEmpty()) {
        return false;
    }
    if (d->top.has_value() && !d->top->isEmpty()) {
        return false;
    }
    if (d->bottom.has_value() && !d->bottom->isEmpty()) {
        return false;
    }

    return true;
}

void OutlineProperty::resolveProperties(const OutlineProperty &source, OutlineProperty &destination)
{
    if (source.d->left.has_value()) {
        LineProperty property;
        if (destination.d->left.has_value()) {
            property = destination.d->left.value();
        }
        LineProperty::resolveProperties(source.d->left.value(), property);
        if (property.hasAnyValue()) {
            destination.d->left = property;
        }
    }
    if (source.d->right.has_value()) {
        LineProperty property;
        if (destination.d->right.has_value()) {
            property = destination.d->right.value();
        }
        LineProperty::resolveProperties(source.d->right.value(), property);
        if (property.hasAnyValue()) {
            destination.d->right = property;
        }
    }
    if (source.d->top.has_value()) {
        LineProperty property;
        if (destination.d->top.has_value()) {
            property = destination.d->top.value();
        }
        LineProperty::resolveProperties(source.d->top.value(), property);
        if (property.hasAnyValue()) {
            destination.d->top = property;
        }
    }
    if (source.d->bottom.has_value()) {
        LineProperty property;
        if (destination.d->bottom.has_value()) {
            property = destination.d->bottom.value();
        }
        LineProperty::resolveProperties(source.d->bottom.value(), property);
        if (property.hasAnyValue()) {
            destination.d->bottom = property;
        }
    }
}

OutlineProperty OutlineProperty::empty()
{
    OutlineProperty result;
    result.d->left = emptyValue<LineProperty>();
    result.d->right = emptyValue<LineProperty>();
    result.d->top = emptyValue<LineProperty>();
    result.d->bottom = emptyValue<LineProperty>();
    return result;
}

bool Union::Properties::operator==(const OutlineProperty &left, const OutlineProperty &right)
{
    if (left.left() != right.left()) {
        return false;
    }
    if (left.right() != right.right()) {
        return false;
    }
    if (left.top() != right.top()) {
        return false;
    }
    if (left.bottom() != right.bottom()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::OutlineProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "OutlineProperty(" //
                    << "left: " << type.left() //
                    << ", right: " << type.right() //
                    << ", top: " << type.top() //
                    << ", bottom: " << type.bottom() //
                    << ")";
    return debug;
}