// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>


#include "../Color.h"
#include "../PropertiesTypes.h"
#include "ImageProperty.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class LinePropertyPrivate;

/*!
\class Union::Properties::LineProperty
\inmodule core
\ingroup core-properties

\brief A property group containing the properties of a line.

*/
class UNION_EXPORT LineProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    LineProperty();
    /*!
     * Copy constructor.
     */
    LineProperty(const LineProperty &other);
    /*!
     * Move constructor.
     */
    LineProperty(LineProperty &&other);
    ~LineProperty();

    /*!
     * Copy assignment operator.
     */
    LineProperty &operator=(const LineProperty &other);
    /*!
     * Move assignment operator.
     */
    LineProperty &operator=(LineProperty &&other);

    /*!
     * Returns the value of size.
     */
    std::optional<qreal> size() const;
    /*!
     * Set the value of size.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setSize(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of color.
     */
    std::optional<Union::Color> color() const;
    /*!
     * Set the value of color.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setColor(const std::optional<Union::Color> &newValue);

    /*!
     * Returns the value of style.
     */
    std::optional<Union::Properties::LineStyle> style() const;
    /*!
     * Set the value of style.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setStyle(const std::optional<Union::Properties::LineStyle> &newValue);

    /*!
     * Returns the value of image.
     */
    std::optional<ImageProperty> image() const;
    /*!
     * Returns image if set or a new ImageProperty if not.
     */
    ImageProperty image_or_new() const;
    /*!
     * Set the value of image.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setImage(const std::optional<ImageProperty> &newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Returns if this property is considered empty.
     *
     * A property is considered empty if it has no values or if the values it
     * contains are all considered empty values.
     */
    bool isEmpty() const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const LineProperty &source, LineProperty &destination);

    /*!
     * Create and return an empty LineProperty instance.
     *
     * This will create an empty LineProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static LineProperty empty();

private:
    std::unique_ptr<LinePropertyPrivate> d;
};

/*!
 * \relates Union::Properties::LineProperty
 * Equality comparison for LineProperty.
 */
UNION_EXPORT bool operator==(const LineProperty &left, const LineProperty &right);
}
}

/*!
 * \relates Union::Properties::LineProperty
 * QDebug support for LineProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, const Union::Properties::LineProperty &type);