// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "BackgroundProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::BackgroundPropertyPrivate
{
public:
    std::optional<Union::Color> color;
    std::optional<ImageProperty> image;
};

BackgroundProperty::BackgroundProperty()
    : d(std::make_unique<BackgroundPropertyPrivate>())
{
}

BackgroundProperty::BackgroundProperty(const BackgroundProperty &other)
    : d(std::make_unique<BackgroundPropertyPrivate>())
{
    d->color = other.d->color;
    d->image = other.d->image;
}

BackgroundProperty::BackgroundProperty(BackgroundProperty &&other)
    : d(std::move(other.d))
{
}

BackgroundProperty::~BackgroundProperty() = default;

BackgroundProperty &BackgroundProperty::operator=(const BackgroundProperty &other)
{
    if (this != &other) {
        d->color = other.d->color;
        d->image = other.d->image;
    }
    return *this;
}

BackgroundProperty &BackgroundProperty::operator=(BackgroundProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<Union::Color> BackgroundProperty::color() const
{
    return d->color;
}

void BackgroundProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}
std::optional<ImageProperty> BackgroundProperty::image() const
{
    return d->image;
}

ImageProperty BackgroundProperty::image_or_new() const
{
    return d->image.value_or(ImageProperty{});
}

void BackgroundProperty::setImage(const std::optional<ImageProperty> &newValue)
{
    if (newValue == d->image) {
        return;
    }

    d->image = newValue;
}

bool BackgroundProperty::hasAnyValue() const
{
    if (d->color.has_value()) {
        return true;
    }
    if (d->image.has_value() && d->image->hasAnyValue()) {
        return true;
    }
    return false;
}

bool BackgroundProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->color.has_value() && d->color.value() != emptyValue<Union::Color>()) {
        return false;
    }
    if (d->image.has_value() && !d->image->isEmpty()) {
        return false;
    }

    return true;
}

void BackgroundProperty::resolveProperties(const BackgroundProperty &source, BackgroundProperty &destination)
{
    if (!destination.d->color.has_value()) {
        destination.d->color = source.d->color;
    }
    if (source.d->image.has_value()) {
        ImageProperty property;
        if (destination.d->image.has_value()) {
            property = destination.d->image.value();
        }
        ImageProperty::resolveProperties(source.d->image.value(), property);
        if (property.hasAnyValue()) {
            destination.d->image = property;
        }
    }
}

BackgroundProperty BackgroundProperty::empty()
{
    BackgroundProperty result;
    result.d->color = emptyValue<Union::Color>();
    result.d->image = emptyValue<ImageProperty>();
    return result;
}

bool Union::Properties::operator==(const BackgroundProperty &left, const BackgroundProperty &right)
{
    if (left.color() != right.color()) {
        return false;
    }
    if (left.image() != right.image()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::BackgroundProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "BackgroundProperty(" //
                    << "color: " << type.color() //
                    << ", image: " << type.image() //
                    << ")";
    return debug;
}