const char metrics_plugins_graphite_lua[] =
"local socket = require('socket')\n"
"local fiber = require('fiber')\n"
"local metrics = require('metrics')\n"
"local checks = require('checks')\n"
"local log = require('log')\n"
"local fun = require('fun')\n"
"\n"
"local graphite = {}\n"
"\n"
"-- Default values\n"
"local DEFAULT_PREFIX = 'tarantool'\n"
"local DEFAULT_HOST = '127.0.0.1'\n"
"local DEFAULT_PORT = 2003\n"
"local DEFAULT_SEND_INTERVAL = 2\n"
"\n"
"-- Constants\n"
"local LABELS_SEP = ';'\n"
"\n"
"function graphite.format_observation(prefix, obs)\n"
"    local metric_path = #prefix > 0 and ('%s.%s'):format(prefix, obs.metric_name) or obs.metric_name\n"
"\n"
"    if next(obs.label_pairs) then\n"
"        local label_pairs_str_parts = {}\n"
"        for label, value in pairs(obs.label_pairs) do\n"
"            table.insert(label_pairs_str_parts, ('%s=%s'):format(label, value))\n"
"        end\n"
"        local label_pairs_str = table.concat(label_pairs_str_parts, LABELS_SEP)\n"
"        metric_path = metric_path .. LABELS_SEP .. label_pairs_str\n"
"    end\n"
"    metric_path = metric_path:gsub(' ', '_') -- remove spaces (e.g. in values)\n"
"    local string_val = tostring(tonumber(obs.value)) -- removes ULL/LL suffixes\n"
"\n"
"    local ts = tostring(obs.timestamp / 10^6):gsub(\"U*LL\", \"\") -- Graphite takes time in seconds\n"
"    local graph = ('%s %s %s\\n'):format(metric_path, string_val, ts)\n"
"\n"
"    return graph\n"
"end\n"
"\n"
"local function graphite_worker(opts)\n"
"    fiber.name('metrics_graphite_worker')\n"
"\n"
"    while true do\n"
"        metrics.invoke_callbacks()\n"
"        for _, c in pairs(metrics.collectors()) do\n"
"            for _, obs in ipairs(c:collect()) do\n"
"                local data = graphite.format_observation(opts.prefix, obs)\n"
"                local numbytes = opts.sock:sendto(opts.host, opts.port, data)\n"
"                if numbytes == nil then\n"
"                    log.error('Error while sending to host %s port %s data %s',\n"
"                              opts.host, opts.port, data)\n"
"                end\n"
"            end\n"
"        end\n"
"\n"
"        fiber.sleep(opts.send_interval)\n"
"    end\n"
"end\n"
"\n"
"function graphite.init(opts)\n"
"    checks {\n"
"        prefix = '\?string',\n"
"        host = '\?string',\n"
"        port = '\?number',\n"
"        send_interval = '\?number'\n"
"    }\n"
"\n"
"    local sock = socket('AF_INET', 'SOCK_DGRAM', 'udp')\n"
"    assert(sock ~= nil, 'Socket creation failed')\n"
"\n"
"    local prefix = opts.prefix or DEFAULT_PREFIX\n"
"    local host = opts.host or DEFAULT_HOST\n"
"    local port = opts.port or DEFAULT_PORT\n"
"    local send_interval = opts.send_interval or DEFAULT_SEND_INTERVAL\n"
"\n"
"    fun.iter(fiber.info()):\n"
"        filter(function(_, x) return x.name == 'metrics_graphite_worker' end):\n"
"        each(function(x) fiber.kill(x) end)\n"
"\n"
"    fiber.create(graphite_worker, {\n"
"        prefix = prefix,\n"
"        sock = sock,\n"
"        host = host,\n"
"        port = port,\n"
"        send_interval = send_interval,\n"
"    })\n"
"end\n"
"\n"
"return graphite\n"
""
;
