const char loaders_lua[] =
"local minifio = require('internal.minifio')\n"
"\n"
"local soext = (jit.os == \"OSX\" and \"dylib\" or \"so\")\n"
"\n"
"local ROCKS_LIB_PATH = '.rocks/lib/tarantool'\n"
"local ROCKS_LUA_PATH = '.rocks/share/tarantool'\n"
"local LIB_TEMPLATES = { '\?.'..soext }\n"
"local LUA_TEMPLATES = { '\?.lua', '\?/init.lua' }\n"
"local ROCKS_LIB_TEMPLATES = {\n"
"    ROCKS_LIB_PATH .. '/\?.'..soext,\n"
"}\n"
"local ROCKS_LUA_TEMPLATES = {\n"
"    ROCKS_LUA_PATH .. '/\?.lua',\n"
"    ROCKS_LUA_PATH .. '/\?/init.lua',\n"
"}\n"
"\n"
"-- Tarantool's builtin modules.\n"
"--\n"
"-- Similar to _LOADED (package.loaded).\n"
"local builtin_modules = debug.getregistry()._TARANTOOL_BUILTIN\n"
"\n"
"-- Loader for built-in modules.\n"
"local function builtin_loader(name)\n"
"    -- A loader is more like a searching function rather than a\n"
"    -- loading function (fun fact: package.loaders was renamed to\n"
"    -- package.searchers in Lua 5.2).\n"
"    --\n"
"    -- A loader (a searcher) typically searches for a file and, if\n"
"    -- the file is found, loads it and returns a function to\n"
"    -- execute it. Typically just result of loadfile(file).\n"
"    --\n"
"    -- Our 'filesystem' is a table of modules, a 'file' is an\n"
"    -- entry in the table. If a module is found, the loader\n"
"    -- returns a function that 'executes' it. The function just\n"
"    -- returns the module itself.\n"
"    if builtin_modules[name] ~= nil then\n"
"        return function(_name)\n"
"            return builtin_modules[name]\n"
"        end\n"
"    end\n"
"\n"
"    return (\"\\n\\tno field loaders.builtin['%s']\"):format(name)\n"
"end\n"
"\n"
"local package_searchroot\n"
"\n"
"local function searchroot()\n"
"    return package_searchroot or minifio.cwd()\n"
"end\n"
"\n"
"local function setsearchroot(path)\n"
"    if not path then\n"
"        -- Here we need to get this function caller's sourcedir.\n"
"        path = debug.sourcedir(3)\n"
"    elseif path == box.NULL then\n"
"        path = nil\n"
"    else\n"
"        assert(type(path) == 'string', 'Search root must be a string')\n"
"    end\n"
"    package_searchroot = path and minifio.abspath(path)\n"
"end\n"
"\n"
"local function mksymname(name)\n"
"    local mark = string.find(name, \"-\")\n"
"    if mark then name = string.sub(name, mark + 1) end\n"
"    return \"luaopen_\" .. string.gsub(name, \"%.\", \"_\")\n"
"end\n"
"\n"
"local function load_lib(file, name)\n"
"    return package.loadlib(file, mksymname(name))\n"
"end\n"
"\n"
"local function load_lua(file)\n"
"    return loadfile(file)\n"
"end\n"
"\n"
"local function traverse_path(path)\n"
"    path = minifio.abspath(path)\n"
"    local paths = { path }\n"
"\n"
"    while path ~= '/' do\n"
"        path = minifio.dirname(path)\n"
"        table.insert(paths, path)\n"
"    end\n"
"\n"
"    return paths\n"
"end\n"
"\n"
"-- Generate a search function, which performs searching through\n"
"-- templates setup in options.\n"
"--\n"
"-- @param path_fn function which returns a base path for the\n"
"--     resulting template\n"
"-- @param templates table with lua search templates\n"
"-- @param need_traverse bool flag which tells search function to\n"
"--     build multiple paths by expanding base path up to the\n"
"--     root ('/')\n"
"-- @return a searcher function which builds a path template and\n"
"--     calls package.searchpath\n"
"local function gen_search_func(path_fn, templates, need_traverse)\n"
"    assert(type(path_fn) == 'function', 'path_fn must be a function')\n"
"    assert(type(templates) == 'table', 'templates must be a table')\n"
"\n"
"    return function(name)\n"
"        local path = path_fn() or '.'\n"
"        local paths = need_traverse and traverse_path(path) or { path }\n"
"\n"
"        local searchpaths = {}\n"
"\n"
"        for _, path in ipairs(paths) do\n"
"            for _, template in pairs(templates) do\n"
"                table.insert(searchpaths, minifio.pathjoin(path, template))\n"
"            end\n"
"        end\n"
"\n"
"        local searchpath = table.concat(searchpaths, ';')\n"
"\n"
"        return package.searchpath(name, searchpath)\n"
"    end\n"
"end\n"
"\n"
"-- Compose a loader function from options.\n"
"--\n"
"-- @param search_fn function will be used to search a file from\n"
"--     path template\n"
"-- @param load_fn function will be used to load a file, found by\n"
"--     search function\n"
"-- @return function a loader, which first search for the file and\n"
"--     then loads it\n"
"local function gen_loader_func(search_fn, load_fn)\n"
"    assert(type(search_fn) == 'function', 'search_fn must be defined')\n"
"    assert(type(load_fn) == 'function', 'load_fn must be defined')\n"
"\n"
"    return function(name)\n"
"        if not name then\n"
"            return \"empty name of module\"\n"
"        end\n"
"        local file, err = search_fn(name)\n"
"        if not file then\n"
"            return err\n"
"        end\n"
"        local loaded, err = load_fn(file, name)\n"
"        if err == nil then\n"
"            return loaded\n"
"        else\n"
"            return err\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local search_lua = gen_search_func(searchroot, LUA_TEMPLATES)\n"
"local search_lib = gen_search_func(searchroot, LIB_TEMPLATES)\n"
"local search_rocks_lua = gen_search_func(searchroot, ROCKS_LUA_TEMPLATES, true)\n"
"local search_rocks_lib = gen_search_func(searchroot, ROCKS_LIB_TEMPLATES, true)\n"
"\n"
"local search_funcs = {\n"
"    search_lua,\n"
"    search_lib,\n"
"    search_rocks_lua,\n"
"    search_rocks_lib,\n"
"    function(name) return package.searchpath(name, package.path) end,\n"
"    function(name) return package.searchpath(name, package.cpath) end,\n"
"}\n"
"\n"
"local function search(name)\n"
"    if not name then\n"
"        return \"empty name of module\"\n"
"    end\n"
"    for _, searcher in ipairs(search_funcs) do\n"
"        local file = searcher(name)\n"
"        if file ~= nil then\n"
"            return file\n"
"        end\n"
"    end\n"
"    return nil\n"
"end\n"
"\n"
"-- Accept a loader and return a loader, which search by a prefixed\n"
"-- module name.\n"
"--\n"
"-- The module receives the original (unprefixed) module name in\n"
"-- the argument (three dots).\n"
"local function prefix_loader(prefix, subloader)\n"
"    return function(name)\n"
"        local prefixed_name = prefix .. '.' .. name\n"
"        -- On success the return value is a function, which\n"
"        -- executes module's initialization code. require() calls\n"
"        -- it with one argument: the module name (it can be\n"
"        -- received in the module using three dots). Since\n"
"        -- require() knows nothing about our prefixing it passes\n"
"        -- the original name there.\n"
"        --\n"
"        -- It is expected behavior in our case. The prefixed\n"
"        -- loaders are added to enable extra search paths: like\n"
"        -- we would add more package.{path,cpath} entries. It\n"
"        -- shouldn't change the string passed to the module's\n"
"        -- initialization code.\n"
"        return subloader(prefixed_name)\n"
"    end\n"
"end\n"
"\n"
"-- Accept a loader and return the same loader, but enabled only\n"
"-- when given condition (a function return value) is true.\n"
"local function conditional_loader(subloader, onoff)\n"
"    assert(type(onoff) == 'function')\n"
"    return function(name)\n"
"        if onoff(name) then\n"
"            return subloader(name)\n"
"        end\n"
"        -- It is okay to return nothing, require() ignores it.\n"
"    end\n"
"end\n"
"\n"
"-- Accept an array of loaders and return a loader, whose effect is\n"
"-- equivalent to calling the loaders in a row.\n"
"local function chain_loaders(subloaders)\n"
"    return function(name)\n"
"        -- Error accumulator.\n"
"        local err = ''\n"
"\n"
"        for _, loader in ipairs(subloaders) do\n"
"            local loaded = loader(name)\n"
"            -- Whether the module found\? Let's return it.\n"
"            --\n"
"            -- loaded is a function, which executes module's\n"
"            -- initialization code.\n"
"            if type(loaded) == 'function' then\n"
"                return loaded\n"
"            end\n"
"            -- If the module is not found and the loader function\n"
"            -- returns an error, add the error into the\n"
"            -- accumulator.\n"
"            if type(loaded) == 'string' then\n"
"                err = err .. loaded\n"
"            end\n"
"            -- Ignore any other return value: require() does the\n"
"            -- same.\n"
"        end\n"
"\n"
"        return err\n"
"    end\n"
"end\n"
"\n"
"-- loader_preload 1\n"
"table.insert(package.loaders, 2, gen_loader_func(search_lua, load_lua))\n"
"table.insert(package.loaders, 3, gen_loader_func(search_lib, load_lib))\n"
"table.insert(package.loaders, 4, gen_loader_func(search_rocks_lua, load_lua))\n"
"table.insert(package.loaders, 5, gen_loader_func(search_rocks_lib, load_lib))\n"
"-- package.path   6\n"
"-- package.cpath  7\n"
"-- croot          8\n"
"\n"
"-- Search for modules next to the main script.\n"
"--\n"
"-- If the script is not provided (script == nil) or provided as\n"
"-- stdin (script == '-'), there is no script directory, so nothing\n"
"-- to do here.\n"
"local script = minifio.script()\n"
"if script ~= nil and script ~= '-' then\n"
"    -- It is important to obtain the directory at initialization,\n"
"    -- before any cwd change may occur. The script path may be\n"
"    -- passed as relative to the current directory.\n"
"    local script_dir = minifio.dirname(minifio.abspath(script))\n"
"    local function script_dir_fn()\n"
"        return script_dir\n"
"    end\n"
"\n"
"    -- Search non-recursively, only next to the script.\n"
"    local search_app_lua = gen_search_func(script_dir_fn, LUA_TEMPLATES)\n"
"    local search_app_lib = gen_search_func(script_dir_fn, LIB_TEMPLATES)\n"
"    local search_app_rocks_lua = gen_search_func(script_dir_fn,\n"
"        ROCKS_LUA_TEMPLATES)\n"
"    local search_app_rocks_lib = gen_search_func(script_dir_fn,\n"
"        ROCKS_LIB_TEMPLATES)\n"
"\n"
"    -- Mix the script directory loaders into corresponding\n"
"    -- searchroot based loaders. It allows to avoid changing\n"
"    -- ordinals of the loaders and also makes the override\n"
"    -- loader search here.\n"
"    --\n"
"    -- We can just add more paths to package.path/package.cpath,\n"
"    -- but:\n"
"    --\n"
"    -- * Search for override modules is implemented as a loader.\n"
"    -- * Search inside .rocks in implemented as a loaders.\n"
"    --\n"
"    -- And it is simpler to wrap this logic rather than repeat.\n"
"    -- It is possible (and maybe even desirable) to reimplement\n"
"    -- all the loaders logic as paths generation, but we should\n"
"    -- do that for all the logic at once.\n"
"    package.loaders[2] = chain_loaders({\n"
"        package.loaders[2],\n"
"        gen_loader_func(search_app_lua, load_lua),\n"
"    })\n"
"    package.loaders[3] = chain_loaders({\n"
"        package.loaders[3],\n"
"        gen_loader_func(search_app_lib, load_lib),\n"
"    })\n"
"    package.loaders[4] = chain_loaders({\n"
"        package.loaders[4],\n"
"        gen_loader_func(search_app_rocks_lua, load_lua),\n"
"    })\n"
"    package.loaders[5] = chain_loaders({\n"
"        package.loaders[5],\n"
"        gen_loader_func(search_app_rocks_lib, load_lib),\n"
"    })\n"
"end\n"
"\n"
"local function getenv_boolean(varname, default)\n"
"    local envvar = os.getenv(varname)\n"
"\n"
"    -- If unset or empty, use the default.\n"
"    if envvar == nil or envvar == '' then\n"
"        return default\n"
"    end\n"
"\n"
"    -- Explicitly enabled or disabled.\n"
"    --\n"
"    -- Accept false/true case insensitively.\n"
"    --\n"
"    -- Accept 0/1 as boolean values.\n"
"    if envvar:lower() == 'false' or envvar == '0' then\n"
"        return false\n"
"    end\n"
"    if envvar:lower() == 'true' or envvar == '1' then\n"
"        return true\n"
"    end\n"
"\n"
"    -- Can't parse the value, let's use the default.\n"
"    return default\n"
"end\n"
"\n"
"-- true/false if explicitly enabled or disabled, nil otherwise.\n"
"local override_loader_is_enabled\n"
"\n"
"-- Whether the override loader is enabled.\n"
"local function override_loader_onoff(_name)\n"
"    -- Follow the switch if it is explicitly enabled or disabled.\n"
"    if override_loader_is_enabled ~= nil then\n"
"        return override_loader_is_enabled\n"
"    end\n"
"\n"
"    -- Follow the environment variable otherwise.\n"
"    return getenv_boolean('TT_OVERRIDE_BUILTIN', true)\n"
"end\n"
"\n"
"local override_loader = conditional_loader(chain_loaders({\n"
"    prefix_loader('override', package.loaders[2]),\n"
"    prefix_loader('override', package.loaders[3]),\n"
"    prefix_loader('override', package.loaders[4]),\n"
"    prefix_loader('override', package.loaders[5]),\n"
"    prefix_loader('override', package.loaders[6]),\n"
"    prefix_loader('override', package.loaders[7]),\n"
"}), override_loader_onoff)\n"
"\n"
"-- Add two loaders:\n"
"--\n"
"-- - Search for override.<module_name> module. It is necessary for\n"
"--   overriding built-in modules.\n"
"-- - Search for a built-in module (compiled into tarantool's\n"
"--   executable).\n"
"--\n"
"-- Those two loaders are mixed into the first loader to don't\n"
"-- change ordinals of the loaders 2-8. It is possible that someone\n"
"-- has a logic based on those loader positions.\n"
"package.loaders[1] = chain_loaders({\n"
"    package.loaders[1],\n"
"    override_loader,\n"
"    builtin_loader,\n"
"})\n"
"\n"
"rawset(package, \"search\", search)\n"
"rawset(package, \"searchroot\", searchroot)\n"
"rawset(package, \"setsearchroot\", setsearchroot)\n"
"\n"
"local no_package_loaded = {}\n"
"local raw_require = require\n"
"\n"
"-- Allow an override module to refuse caching in package.loaded.\n"
"--\n"
"-- It may be useful to return a built-in module into the platform,\n"
"-- but the override module into application's code.\n"
"_G.require = function(modname)\n"
"    if no_package_loaded[modname] then\n"
"        no_package_loaded[modname] = nil\n"
"        package.loaded[modname] = nil\n"
"    end\n"
"    -- NB: This call is a tail call and it is important to some\n"
"    -- extent. At least luajit's test suites expect certain error\n"
"    -- messages from `require()` calls and from the `-l` option.\n"
"    --\n"
"    -- A non-tail call changes the filename at the beginning of\n"
"    -- the error message.\n"
"    return raw_require(modname)\n"
"end\n"
"\n"
"return {\n"
"    ROCKS_LIB_PATH = ROCKS_LIB_PATH,\n"
"    ROCKS_LUA_PATH = ROCKS_LUA_PATH,\n"
"    builtin = builtin_modules,\n"
"    override_builtin_enable = function()\n"
"        override_loader_is_enabled = true\n"
"    end,\n"
"    override_builtin_disable = function()\n"
"        override_loader_is_enabled = false\n"
"    end,\n"
"    -- It is `true` during tarantool initialization, but once all\n"
"    -- the built-in modules are ready, will be set to `nil`.\n"
"    initializing = true,\n"
"    raw_require = raw_require,\n"
"    -- Add a module name here to ignore package.loaded[modname] at\n"
"    -- next require(). The flag is dropped at the require() call.\n"
"    --\n"
"    -- This is intended to be used from inside a module to refuse\n"
"    -- caching in package.loaded. Any other usage has unspecified\n"
"    -- behavior (just manipulate package.loaded directly if you\n"
"    -- need it).\n"
"    --\n"
"    -- Usage: loaders.no_package_loaded[modname] = true\n"
"    no_package_loaded = no_package_loaded,\n"
"}\n"
""
;
