const char fiber_lua[] =
"-- fiber.lua (internal file)\n"
"\n"
"local compat = require('compat')\n"
"local fiber = require('fiber')\n"
"local ffi = require('ffi')\n"
"ffi.cdef[[\n"
"double\n"
"fiber_time(void);\n"
"int64_t\n"
"fiber_time64(void);\n"
"double\n"
"fiber_clock(void);\n"
"int64_t\n"
"fiber_clock64(void);\n"
"]]\n"
"local C = ffi.C\n"
"\n"
"local TIMEOUT_INFINITY = 100 * 365 * 86400\n"
"\n"
"local FIBER_SLICE_DEFAULT_BRIEF = [[\n"
"Sets the default value for the max fiber slice. The old value is infinity\n"
"(no warnings or errors). The new value is {warn = 0.5, err = 1.0}.\n"
"\n"
"https://tarantool.io/compat/fiber_slice_default\n"
"]]\n"
"\n"
"compat.add_option({\n"
"    name = 'fiber_slice_default',\n"
"    default = 'old',\n"
"    obsolete = nil,\n"
"    brief = FIBER_SLICE_DEFAULT_BRIEF,\n"
"    action = function(is_new)\n"
"        local slice = {}\n"
"        if is_new then\n"
"            slice.warn = 0.5\n"
"            slice.err = 1.0\n"
"        else\n"
"            slice.warn = TIMEOUT_INFINITY\n"
"            slice.err = TIMEOUT_INFINITY\n"
"        end\n"
"        fiber.set_max_slice(slice)\n"
"    end,\n"
"    run_action_now = true,\n"
"})\n"
"\n"
"local function fiber_time()\n"
"    return tonumber(C.fiber_time())\n"
"end\n"
"\n"
"local function fiber_time64()\n"
"    return C.fiber_time64()\n"
"end\n"
"\n"
"local function fiber_clock()\n"
"    return tonumber(C.fiber_clock())\n"
"end\n"
"\n"
"local function fiber_clock64()\n"
"    return C.fiber_clock64()\n"
"end\n"
"\n"
"fiber.time = fiber_time\n"
"fiber.time64 = fiber_time64\n"
"fiber.clock = fiber_clock\n"
"fiber.clock64 = fiber_clock64\n"
"\n"
"local stall = fiber.stall\n"
"fiber.stall = nil\n"
"\n"
"local worker_next_task = nil\n"
"local worker_last_task\n"
"local worker_fiber\n"
"\n"
"--\n"
"-- Worker is a singleton fiber for not urgent delayed execution of\n"
"-- functions. Main purpose - schedule execution of a function,\n"
"-- which is going to yield, from a context, where a yield is not\n"
"-- allowed. Such as an FFI object's GC callback.\n"
"--\n"
"local function worker_f()\n"
"    local task\n"
"    while true do\n"
"        while true do\n"
"            task = worker_next_task\n"
"            if task then\n"
"                break\n"
"            end\n"
"            stall()\n"
"        end\n"
"        worker_next_task = task.next\n"
"        task.f(task.arg)\n"
"        fiber.sleep(0)\n"
"    end\n"
"end\n"
"\n"
"local function worker_safe_f()\n"
"    pcall(worker_f)\n"
"    -- Worker_f never returns. If the execution is here, this\n"
"    -- fiber is probably canceled and now is not able to sleep.\n"
"    -- Create a new one.\n"
"    worker_fiber = fiber.new(worker_safe_f)\n"
"end\n"
"\n"
"worker_fiber = fiber.new(worker_safe_f)\n"
"\n"
"local function worker_schedule_task(f, arg)\n"
"    local task = {f = f, arg = arg}\n"
"    if not worker_next_task then\n"
"        worker_next_task = task\n"
"    else\n"
"        worker_last_task.next = task\n"
"    end\n"
"    worker_last_task = task\n"
"    worker_fiber:wakeup()\n"
"end\n"
"\n"
"-- Start from '_' to hide it from auto completion.\n"
"fiber._internal = fiber._internal or {}\n"
"fiber._internal.schedule_task = worker_schedule_task\n"
"\n"
"setmetatable(fiber, {__serialize = function(self)\n"
"    local res = table.copy(self)\n"
"    res._internal = nil\n"
"    return setmetatable(res, {})\n"
"end})\n"
"\n"
"return fiber\n"
""
;
