/* directory-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from directory-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */
/*
 * This plugin keeps a cache of file names for directories that are commonly
 * used.
 */

#include "plugins.h"
#include <synapse-core.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_ATTRIBUTE_CUSTOM_ICON "metadata::custom-icon"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO (synapse_directory_plugin_directory_info_get_type ())
#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, SynapseDirectoryPluginDirectoryInfo))
#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, SynapseDirectoryPluginDirectoryInfoClass))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, SynapseDirectoryPluginDirectoryInfoClass))

typedef struct _SynapseDirectoryPluginDirectoryInfo SynapseDirectoryPluginDirectoryInfo;
typedef struct _SynapseDirectoryPluginDirectoryInfoClass SynapseDirectoryPluginDirectoryInfoClass;

#define SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG (synapse_directory_plugin_config_get_type ())
#define SYNAPSE_DIRECTORY_PLUGIN_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfig))
#define SYNAPSE_DIRECTORY_PLUGIN_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfigClass))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG))
#define SYNAPSE_DIRECTORY_PLUGIN_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfigClass))

typedef struct _SynapseDirectoryPluginConfig SynapseDirectoryPluginConfig;
typedef struct _SynapseDirectoryPluginConfigClass SynapseDirectoryPluginConfigClass;
enum  {
	SYNAPSE_DIRECTORY_PLUGIN_0_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_directory_plugin_properties[SYNAPSE_DIRECTORY_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseDirectoryPluginDirectoryInfoPrivate SynapseDirectoryPluginDirectoryInfoPrivate;

#define SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT (synapse_directory_plugin_match_object_get_type ())
#define SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, SynapseDirectoryPluginMatchObject))
#define SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, SynapseDirectoryPluginMatchObjectClass))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_MATCH_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_DIRECTORY_PLUGIN_IS_MATCH_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT))
#define SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, SynapseDirectoryPluginMatchObjectClass))

typedef struct _SynapseDirectoryPluginMatchObject SynapseDirectoryPluginMatchObject;
typedef struct _SynapseDirectoryPluginMatchObjectClass SynapseDirectoryPluginMatchObjectClass;
#define _synapse_directory_plugin_directory_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_directory_plugin_directory_info_unref (var), NULL)))
typedef struct _SynapseDirectoryPluginIndexXdgDirectoriesData SynapseDirectoryPluginIndexXdgDirectoriesData;
typedef struct _SynapseDirectoryPluginProcessDirectoriesData SynapseDirectoryPluginProcessDirectoriesData;
typedef struct _Block2Data Block2Data;
typedef struct _SynapseDirectoryPluginSearchData SynapseDirectoryPluginSearchData;
typedef struct _SynapseDirectoryPluginMatchObjectPrivate SynapseDirectoryPluginMatchObjectPrivate;
enum  {
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_0_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_directory_plugin_match_object_properties[SYNAPSE_DIRECTORY_PLUGIN_MATCH_OBJECT_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDirectoryPluginDirectoryInfoInitializeData SynapseDirectoryPluginDirectoryInfoInitializeData;
typedef struct _SynapseDirectoryPluginParamSpecDirectoryInfo SynapseDirectoryPluginParamSpecDirectoryInfo;
typedef struct _SynapseDirectoryPluginConfigPrivate SynapseDirectoryPluginConfigPrivate;
enum  {
	SYNAPSE_DIRECTORY_PLUGIN_CONFIG_0_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY_PROPERTY,
	SYNAPSE_DIRECTORY_PLUGIN_CONFIG_NUM_PROPERTIES
};
static GParamSpec* synapse_directory_plugin_config_properties[SYNAPSE_DIRECTORY_PLUGIN_CONFIG_NUM_PROPERTIES];
enum  {
	SYNAPSE_DIRECTORY_PLUGIN_ZEITGEIST_SEARCH_COMPLETE_SIGNAL,
	SYNAPSE_DIRECTORY_PLUGIN_NUM_SIGNALS
};
static guint synapse_directory_plugin_signals[SYNAPSE_DIRECTORY_PLUGIN_NUM_SIGNALS] = {0};

struct _SynapseDirectoryPluginPrivate {
	SynapseDataSink* _data_sink;
	gboolean _enabled;
	GeeMap* directory_info_map;
	SynapseDirectoryPluginConfig* config;
	gboolean xdg_indexed;
	gchar* home_dir_uri;
};

struct _SynapseDirectoryPluginDirectoryInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseDirectoryPluginDirectoryInfoPrivate * priv;
	SynapseDirectoryPluginMatchObject* match_obj;
	gchar* name;
	gchar* name_folded;
};

struct _SynapseDirectoryPluginDirectoryInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseDirectoryPluginDirectoryInfo *self);
};

struct _SynapseDirectoryPluginIndexXdgDirectoriesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDirectoryPlugin* self;
	GUserDirectory dir;
	gboolean _tmp0_;
	gchar* path;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* f;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	gchar* uri;
	GFile* _tmp6_;
	gchar* _tmp7_;
	GeeMap* _tmp8_;
	const gchar* _tmp9_;
	SynapseDirectoryPluginDirectoryInfo* info;
	const gchar* _tmp10_;
	SynapseDirectoryPluginDirectoryInfo* _tmp11_;
	SynapseDirectoryPluginDirectoryInfo* _tmp12_;
	GeeMap* _tmp13_;
	SynapseDirectoryPluginDirectoryInfo* _tmp14_;
	SynapseDirectoryPluginMatchObject* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	SynapseDirectoryPluginDirectoryInfo* _tmp18_;
};

struct _SynapseDirectoryPluginProcessDirectoriesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDirectoryPlugin* self;
	GeeCollection* dirs;
	const gchar* _tmp0_;
	gchar* home_dir;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* home;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GeeIterator* _dir_it;
	GeeIterator* _tmp11_;
	GeeIterator* _tmp12_;
	gchar* dir;
	GeeIterator* _tmp13_;
	gpointer _tmp14_;
	GeeMap* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	SynapseDirectoryPluginConfig* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar** directories;
	const gchar* _tmp23_;
	gint _tmp24_;
	gchar** _tmp25_;
	gint directories_length1;
	gint _directories_size_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar** dir_uri_collection;
	gint dir_uri_collection_length1;
	gint _dir_uri_collection_size_;
	gint dir_uri_it;
	const gchar* dir_uri;
	GeeMap* _tmp27_;
	const gchar* _tmp28_;
	SynapseDirectoryPluginDirectoryInfo* info;
	const gchar* _tmp29_;
	SynapseDirectoryPluginDirectoryInfo* _tmp30_;
	SynapseDirectoryPluginDirectoryInfo* _tmp31_;
	GeeMap* _tmp32_;
	SynapseDirectoryPluginDirectoryInfo* _tmp33_;
	SynapseDirectoryPluginMatchObject* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	SynapseDirectoryPluginDirectoryInfo* _tmp37_;
};

struct _Block2Data {
	int _ref_count_;
	SynapseDirectoryPlugin* self;
	GeeCollection* directories;
	guint query_id;
	SynapseResultSet* zg_rs;
	gulong sig_id;
	gpointer _async_data_;
};

struct _SynapseDirectoryPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDirectoryPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block2Data* _data2_;
	SynapseQuery _tmp0_;
	gulong _tmp1_;
	gulong canc_sig_id;
	SynapseQuery _tmp2_;
	GCancellable* _tmp3_;
	SynapseDataSink* _tmp4_;
	SynapseQuery _tmp5_;
	GCancellable* _tmp6_;
	GeeCollection* _tmp7_;
	SynapseResultSet* rs;
	SynapseResultSet* _tmp8_;
	GeeIterator* _entry_it;
	GeeMap* _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	SynapseDirectoryPluginDirectoryInfo* entry;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	gboolean _tmp18_;
	SynapseResultSet* _tmp19_;
	SynapseResultSet* _tmp20_;
	SynapseDirectoryPluginDirectoryInfo* _tmp21_;
	SynapseDirectoryPluginMatchObject* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	SynapseDirectoryPluginDirectoryInfo* _tmp25_;
	const gchar* _tmp26_;
	SynapseQuery _tmp27_;
	const gchar* _tmp28_;
	SynapseMatchScore _tmp29_;
	SynapseDirectoryPluginDirectoryInfo* _tmp30_;
	SynapseDirectoryPluginMatchObject* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gint relevancy1;
	SynapseResultSet* _tmp35_;
	SynapseDirectoryPluginDirectoryInfo* _tmp36_;
	SynapseDirectoryPluginMatchObject* _tmp37_;
	SynapseDirectoryPluginDirectoryInfo* _tmp38_;
	const gchar* _tmp39_;
	SynapseQuery _tmp40_;
	const gchar* _tmp41_;
	SynapseMatchScore _tmp42_;
	SynapseDirectoryPluginDirectoryInfo* _tmp43_;
	SynapseDirectoryPluginMatchObject* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	gint relevancy2;
	SynapseResultSet* _tmp48_;
	SynapseDirectoryPluginDirectoryInfo* _tmp49_;
	SynapseDirectoryPluginMatchObject* _tmp50_;
	GError* _inner_error0_;
};

struct _SynapseDirectoryPluginMatchObject {
	SynapseUriMatch parent_instance;
	SynapseDirectoryPluginMatchObjectPrivate * priv;
};

struct _SynapseDirectoryPluginMatchObjectClass {
	SynapseUriMatchClass parent_class;
};

struct _SynapseDirectoryPluginDirectoryInfoPrivate {
	gboolean initialized;
};

struct _SynapseDirectoryPluginDirectoryInfoInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDirectoryPluginDirectoryInfo* self;
	GFile* f;
	SynapseDirectoryPluginMatchObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFileInfo* fi;
	GFileInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	SynapseDirectoryPluginMatchObject* _tmp9_;
	const gchar* _tmp10_;
	SynapseDirectoryPluginMatchObject* _tmp11_;
	GIcon* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* icon_f;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	SynapseDirectoryPluginMatchObject* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* err;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _inner_error0_;
};

struct _SynapseDirectoryPluginParamSpecDirectoryInfo {
	GParamSpec parent_instance;
};

struct _SynapseDirectoryPluginConfig {
	SynapseConfigObject parent_instance;
	SynapseDirectoryPluginConfigPrivate * priv;
};

struct _SynapseDirectoryPluginConfigClass {
	SynapseConfigObjectClass parent_class;
};

struct _SynapseDirectoryPluginConfigPrivate {
	gboolean _home_dir_children_only;
};

static gint SynapseDirectoryPlugin_private_offset;
static gpointer synapse_directory_plugin_parent_class = NULL;
static gpointer synapse_directory_plugin_match_object_parent_class = NULL;
static gint SynapseDirectoryPluginDirectoryInfo_private_offset;
static gpointer synapse_directory_plugin_directory_info_parent_class = NULL;
static gint SynapseDirectoryPluginConfig_private_offset;
static gpointer synapse_directory_plugin_config_parent_class = NULL;
static SynapseActivatableIface * synapse_directory_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_directory_plugin_synapse_item_provider_parent_iface = NULL;

static gpointer synapse_directory_plugin_directory_info_ref (gpointer instance);
static void synapse_directory_plugin_directory_info_unref (gpointer instance);
static GParamSpec* synapse_directory_plugin_param_spec_directory_info (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags) G_GNUC_UNUSED ;
static void synapse_directory_plugin_value_set_directory_info (GValue* value,
                                                        gpointer v_object) G_GNUC_UNUSED ;
static void synapse_directory_plugin_value_take_directory_info (GValue* value,
                                                         gpointer v_object) G_GNUC_UNUSED ;
static gpointer synapse_directory_plugin_value_get_directory_info (const GValue* value) G_GNUC_UNUSED ;
static GType synapse_directory_plugin_directory_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType synapse_directory_plugin_config_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_directory_plugin_real_activate (SynapseActivatable* base);
static void synapse_directory_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_directory_plugin_register_plugin (void);
static void _synapse_directory_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_directory_plugin_real_constructed (GObject* base);
static void synapse_directory_plugin_zg_plugin_search_done (SynapseDirectoryPlugin* self,
                                                     SynapseResultSet* rs,
                                                     guint query_id);
static void _synapse_directory_plugin_zg_plugin_search_done_synapse_data_sink_search_done (SynapseDataSink* _sender,
                                                                                    SynapseResultSet* rs,
                                                                                    guint query_id,
                                                                                    gpointer self);
static void synapse_directory_plugin_index_xdg_directories_data_free (gpointer _data);
static void synapse_directory_plugin_index_xdg_directories (SynapseDirectoryPlugin* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_directory_plugin_index_xdg_directories_finish (SynapseDirectoryPlugin* self,
                                                            GAsyncResult* _res_);
static gboolean synapse_directory_plugin_index_xdg_directories_co (SynapseDirectoryPluginIndexXdgDirectoriesData* _data_);
static SynapseDirectoryPluginDirectoryInfo* synapse_directory_plugin_directory_info_new (const gchar* uri);
static SynapseDirectoryPluginDirectoryInfo* synapse_directory_plugin_directory_info_construct (GType object_type,
                                                                                        const gchar* uri);
static void synapse_directory_plugin_directory_info_initialize (SynapseDirectoryPluginDirectoryInfo* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void synapse_directory_plugin_directory_info_initialize_finish (SynapseDirectoryPluginDirectoryInfo* self,
                                                                GAsyncResult* _res_);
static void synapse_directory_plugin_index_xdg_directories_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static GType synapse_directory_plugin_match_object_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GeeCollection* synapse_directory_plugin_extract_directories (SynapseDirectoryPlugin* self,
                                                             SynapseResultSet* rs);
static gchar** synapse_directory_plugin_get_dir_parents (SynapseDirectoryPlugin* self,
                                                  const gchar* dir_uri,
                                                  gboolean include_self,
                                                  gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gboolean synapse_directory_plugin_config_get_home_dir_children_only (SynapseDirectoryPluginConfig* self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void synapse_directory_plugin_process_directories_data_free (gpointer _data);
static void synapse_directory_plugin_process_directories (SynapseDirectoryPlugin* self,
                                                   GeeCollection* dirs,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void synapse_directory_plugin_process_directories_finish (SynapseDirectoryPlugin* self,
                                                          GAsyncResult* _res_);
static gboolean synapse_directory_plugin_process_directories_co (SynapseDirectoryPluginProcessDirectoriesData* _data_);
static void synapse_directory_plugin_process_directories_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static gboolean synapse_directory_plugin_real_handles_query (SynapseItemProvider* base,
                                                      SynapseQuery* q);
static void synapse_directory_plugin_real_search_data_free (gpointer _data);
static void synapse_directory_plugin_real_search (SynapseItemProvider* base,
                                           SynapseQuery* q,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean synapse_directory_plugin_real_search_co (SynapseDirectoryPluginSearchData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda7_ (Block2Data* _data2_,
                 SynapseResultSet* rs,
                 guint q_id);
static void ___lambda7__synapse_directory_plugin_zeitgeist_search_complete (SynapseDirectoryPlugin* _sender,
                                                                     SynapseResultSet* rs,
                                                                     guint query_id,
                                                                     gpointer self);
static void __lambda8_ (Block2Data* _data2_);
static gboolean _synapse_directory_plugin_real_search_co_gsource_func (gpointer self);
static void ___lambda8__gfunc (gconstpointer data,
                        gpointer self);
static void synapse_directory_plugin_search_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static SynapseDirectoryPluginMatchObject* synapse_directory_plugin_match_object_new (const gchar* uri);
static SynapseDirectoryPluginMatchObject* synapse_directory_plugin_match_object_construct (GType object_type,
                                                                                    const gchar* uri);
static GType synapse_directory_plugin_match_object_get_type_once (void);
static void synapse_directory_plugin_directory_info_initialize_data_free (gpointer _data);
static gboolean synapse_directory_plugin_directory_info_initialize_co (SynapseDirectoryPluginDirectoryInfoInitializeData* _data_);
static void synapse_directory_plugin_directory_info_initialize_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void synapse_directory_plugin_directory_info_finalize (SynapseDirectoryPluginDirectoryInfo * obj);
static GType synapse_directory_plugin_directory_info_get_type_once (void);
static SynapseDirectoryPluginConfig* synapse_directory_plugin_config_new (void);
static SynapseDirectoryPluginConfig* synapse_directory_plugin_config_construct (GType object_type);
static void synapse_directory_plugin_config_set_home_dir_children_only (SynapseDirectoryPluginConfig* self,
                                                                 gboolean value);
static void synapse_directory_plugin_config_finalize (GObject * obj);
static GType synapse_directory_plugin_config_get_type_once (void);
static void _vala_synapse_directory_plugin_config_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_synapse_directory_plugin_config_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static GObject * synapse_directory_plugin_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void synapse_directory_plugin_finalize (GObject * obj);
static GType synapse_directory_plugin_get_type_once (void);
static void _vala_synapse_directory_plugin_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_synapse_directory_plugin_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_directory_plugin_get_instance_private (SynapseDirectoryPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDirectoryPlugin_private_offset);
}

static void
synapse_directory_plugin_real_activate (SynapseActivatable* base)
{
	SynapseDirectoryPlugin * self;
#line 34 "directory-plugin.vala"
	self = (SynapseDirectoryPlugin*) base;
#line 546 "directory-plugin.c"
}

static void
synapse_directory_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseDirectoryPlugin * self;
#line 39 "directory-plugin.vala"
	self = (SynapseDirectoryPlugin*) base;
#line 555 "directory-plugin.c"
}

static void
_synapse_directory_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 108 "directory-plugin.vala"
	synapse_directory_plugin_register_plugin ();
#line 563 "directory-plugin.c"
}

static void
synapse_directory_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
#line 108 "directory-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 108 "directory-plugin.vala"
	_tmp1_ = _tmp0_;
#line 108 "directory-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DIRECTORY_PLUGIN, "Directory Search", _ ("Open commonly used directories."), "folder", _synapse_directory_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 108 "directory-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 579 "directory-plugin.c"
}

static void
_synapse_directory_plugin_zg_plugin_search_done_synapse_data_sink_search_done (SynapseDataSink* _sender,
                                                                               SynapseResultSet* rs,
                                                                               guint query_id,
                                                                               gpointer self)
{
#line 134 "directory-plugin.vala"
	synapse_directory_plugin_zg_plugin_search_done ((SynapseDirectoryPlugin*) self, rs, query_id);
#line 590 "directory-plugin.c"
}

static void
synapse_directory_plugin_real_constructed (GObject* base)
{
	SynapseDirectoryPlugin * self;
	SynapseDataSink* _tmp0_;
#line 132 "directory-plugin.vala"
	self = (SynapseDirectoryPlugin*) base;
#line 134 "directory-plugin.vala"
	_tmp0_ = self->priv->_data_sink;
#line 134 "directory-plugin.vala"
	g_signal_connect_object (_tmp0_, "search-done::SynapseZeitgeistPlugin", (GCallback) _synapse_directory_plugin_zg_plugin_search_done_synapse_data_sink_search_done, self, 0);
#line 604 "directory-plugin.c"
}

static void
synapse_directory_plugin_index_xdg_directories_data_free (gpointer _data)
{
	SynapseDirectoryPluginIndexXdgDirectoriesData* _data_;
	_data_ = _data;
#line 29 "directory-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "directory-plugin.vala"
	g_slice_free (SynapseDirectoryPluginIndexXdgDirectoriesData, _data_);
#line 616 "directory-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 29 "directory-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 624 "directory-plugin.c"
}

static void
synapse_directory_plugin_index_xdg_directories (SynapseDirectoryPlugin* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDirectoryPluginIndexXdgDirectoriesData* _data_;
	SynapseDirectoryPlugin* _tmp0_;
#line 29 "directory-plugin.vala"
	g_return_if_fail (self != NULL);
#line 29 "directory-plugin.vala"
	_data_ = g_slice_new0 (SynapseDirectoryPluginIndexXdgDirectoriesData);
#line 29 "directory-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "directory-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_directory_plugin_index_xdg_directories_data_free);
#line 29 "directory-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "directory-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "directory-plugin.vala"
	synapse_directory_plugin_index_xdg_directories_co (_data_);
#line 648 "directory-plugin.c"
}

static void
synapse_directory_plugin_index_xdg_directories_finish (SynapseDirectoryPlugin* self,
                                                       GAsyncResult* _res_)
{
	SynapseDirectoryPluginIndexXdgDirectoriesData* _data_;
#line 29 "directory-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 658 "directory-plugin.c"
}

static void
synapse_directory_plugin_index_xdg_directories_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDirectoryPluginIndexXdgDirectoriesData* _data_;
#line 154 "directory-plugin.vala"
	_data_ = _user_data_;
#line 154 "directory-plugin.vala"
	_data_->_source_object_ = source_object;
#line 154 "directory-plugin.vala"
	_data_->_res_ = _res_;
#line 154 "directory-plugin.vala"
	synapse_directory_plugin_index_xdg_directories_co (_data_);
#line 675 "directory-plugin.c"
}

static gboolean
synapse_directory_plugin_index_xdg_directories_co (SynapseDirectoryPluginIndexXdgDirectoriesData* _data_)
{
#line 139 "directory-plugin.vala"
	switch (_data_->_state_) {
#line 139 "directory-plugin.vala"
		case 0:
#line 685 "directory-plugin.c"
		goto _state_0;
#line 139 "directory-plugin.vala"
		case 1:
#line 689 "directory-plugin.c"
		goto _state_1;
		default:
#line 139 "directory-plugin.vala"
		g_assert_not_reached ();
#line 694 "directory-plugin.c"
	}
	_state_0:
#line 141 "directory-plugin.vala"
	if (_data_->self->priv->xdg_indexed) {
#line 141 "directory-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 141 "directory-plugin.vala"
		if (_data_->_state_ != 0) {
#line 141 "directory-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 141 "directory-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 707 "directory-plugin.c"
			}
		}
#line 141 "directory-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 141 "directory-plugin.vala"
		return FALSE;
#line 714 "directory-plugin.c"
	}
	{
#line 143 "directory-plugin.vala"
		_data_->dir = G_USER_DIRECTORY_DESKTOP;
#line 719 "directory-plugin.c"
		{
#line 143 "directory-plugin.vala"
			_data_->_tmp0_ = TRUE;
#line 143 "directory-plugin.vala"
			while (TRUE) {
#line 143 "directory-plugin.vala"
				if (!_data_->_tmp0_) {
#line 145 "directory-plugin.vala"
					_data_->dir = _data_->dir + 1;
#line 729 "directory-plugin.c"
				}
#line 143 "directory-plugin.vala"
				_data_->_tmp0_ = FALSE;
#line 144 "directory-plugin.vala"
				if (!(_data_->dir <= G_USER_DIRECTORY_VIDEOS)) {
#line 144 "directory-plugin.vala"
					break;
#line 737 "directory-plugin.c"
				}
#line 147 "directory-plugin.vala"
				_data_->_tmp1_ = g_get_user_special_dir (_data_->dir);
#line 147 "directory-plugin.vala"
				_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
#line 147 "directory-plugin.vala"
				_data_->path = _data_->_tmp2_;
#line 148 "directory-plugin.vala"
				_data_->_tmp3_ = _data_->path;
#line 148 "directory-plugin.vala"
				if (_data_->_tmp3_ == NULL) {
#line 148 "directory-plugin.vala"
					_g_free0 (_data_->path);
#line 148 "directory-plugin.vala"
					continue;
#line 753 "directory-plugin.c"
				}
#line 149 "directory-plugin.vala"
				_data_->_tmp4_ = _data_->path;
#line 149 "directory-plugin.vala"
				_data_->_tmp5_ = g_file_new_for_path (_data_->_tmp4_);
#line 149 "directory-plugin.vala"
				_data_->f = _data_->_tmp5_;
#line 150 "directory-plugin.vala"
				_data_->_tmp6_ = _data_->f;
#line 150 "directory-plugin.vala"
				_data_->_tmp7_ = g_file_get_uri (_data_->_tmp6_);
#line 150 "directory-plugin.vala"
				_data_->uri = _data_->_tmp7_;
#line 151 "directory-plugin.vala"
				_data_->_tmp8_ = _data_->self->priv->directory_info_map;
#line 151 "directory-plugin.vala"
				_data_->_tmp9_ = _data_->uri;
#line 151 "directory-plugin.vala"
				if (gee_map_has_key (_data_->_tmp8_, _data_->_tmp9_)) {
#line 151 "directory-plugin.vala"
					_g_free0 (_data_->uri);
#line 151 "directory-plugin.vala"
					_g_object_unref0 (_data_->f);
#line 151 "directory-plugin.vala"
					_g_free0 (_data_->path);
#line 151 "directory-plugin.vala"
					continue;
#line 781 "directory-plugin.c"
				}
#line 153 "directory-plugin.vala"
				_data_->_tmp10_ = _data_->uri;
#line 153 "directory-plugin.vala"
				_data_->_tmp11_ = synapse_directory_plugin_directory_info_new (_data_->_tmp10_);
#line 153 "directory-plugin.vala"
				_data_->info = _data_->_tmp11_;
#line 154 "directory-plugin.vala"
				_data_->_tmp12_ = _data_->info;
#line 154 "directory-plugin.vala"
				_data_->_state_ = 1;
#line 154 "directory-plugin.vala"
				synapse_directory_plugin_directory_info_initialize (_data_->_tmp12_, synapse_directory_plugin_index_xdg_directories_ready, _data_);
#line 154 "directory-plugin.vala"
				return FALSE;
#line 797 "directory-plugin.c"
				_state_1:
#line 154 "directory-plugin.vala"
				synapse_directory_plugin_directory_info_initialize_finish (_data_->_tmp12_, _data_->_res_);
#line 155 "directory-plugin.vala"
				_data_->_tmp13_ = _data_->self->priv->directory_info_map;
#line 155 "directory-plugin.vala"
				_data_->_tmp14_ = _data_->info;
#line 155 "directory-plugin.vala"
				_data_->_tmp15_ = _data_->_tmp14_->match_obj;
#line 155 "directory-plugin.vala"
				_data_->_tmp16_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp15_);
#line 155 "directory-plugin.vala"
				_data_->_tmp17_ = _data_->_tmp16_;
#line 155 "directory-plugin.vala"
				_data_->_tmp18_ = _data_->info;
#line 155 "directory-plugin.vala"
				gee_map_set (_data_->_tmp13_, _data_->_tmp17_, _data_->_tmp18_);
#line 143 "directory-plugin.vala"
				_synapse_directory_plugin_directory_info_unref0 (_data_->info);
#line 143 "directory-plugin.vala"
				_g_free0 (_data_->uri);
#line 143 "directory-plugin.vala"
				_g_object_unref0 (_data_->f);
#line 143 "directory-plugin.vala"
				_g_free0 (_data_->path);
#line 823 "directory-plugin.c"
			}
		}
	}
#line 158 "directory-plugin.vala"
	_data_->self->priv->xdg_indexed = TRUE;
#line 139 "directory-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 139 "directory-plugin.vala"
	if (_data_->_state_ != 0) {
#line 139 "directory-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 139 "directory-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 837 "directory-plugin.c"
		}
	}
#line 139 "directory-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 139 "directory-plugin.vala"
	return FALSE;
#line 844 "directory-plugin.c"
}

static void
synapse_directory_plugin_zg_plugin_search_done (SynapseDirectoryPlugin* self,
                                                SynapseResultSet* rs,
                                                guint query_id)
{
#line 163 "directory-plugin.vala"
	g_return_if_fail (self != NULL);
#line 165 "directory-plugin.vala"
	g_signal_emit (self, synapse_directory_plugin_signals[SYNAPSE_DIRECTORY_PLUGIN_ZEITGEIST_SEARCH_COMPLETE_SIGNAL], 0, rs, query_id);
#line 856 "directory-plugin.c"
}

static GeeCollection*
synapse_directory_plugin_extract_directories (SynapseDirectoryPlugin* self,
                                              SynapseResultSet* rs)
{
	GeeSet* directories = NULL;
	GeeHashSet* _tmp0_;
	GeeCollection* result;
#line 168 "directory-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 168 "directory-plugin.vala"
	g_return_val_if_fail (rs != NULL, NULL);
#line 170 "directory-plugin.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 170 "directory-plugin.vala"
	directories = (GeeSet*) _tmp0_;
#line 874 "directory-plugin.c"
	{
		GeeIterator* _match_it = NULL;
		GeeIterator* _tmp1_;
#line 172 "directory-plugin.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) rs);
#line 172 "directory-plugin.vala"
		_match_it = _tmp1_;
#line 172 "directory-plugin.vala"
		while (TRUE) {
#line 884 "directory-plugin.c"
			GeeIterator* _tmp2_;
			GeeMapEntry* match = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SynapseUriMatch* uri_match = NULL;
			GeeMapEntry* _tmp5_;
			gconstpointer _tmp6_;
			gconstpointer _tmp7_;
			SynapseMatch* _tmp8_;
			SynapseUriMatch* _tmp9_;
			GFile* f = NULL;
			SynapseUriMatch* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			gboolean _tmp14_ = FALSE;
			GFile* _tmp15_;
			GFile* parent = NULL;
			GFile* _tmp17_;
			GFile* _tmp18_;
			gchar* parent_uri = NULL;
			GFile* _tmp19_;
			gchar* _tmp20_;
			GeeSet* _tmp21_;
			const gchar* _tmp22_;
			GeeSet* _tmp23_;
			const gchar* _tmp24_;
#line 172 "directory-plugin.vala"
			_tmp2_ = _match_it;
#line 172 "directory-plugin.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 172 "directory-plugin.vala"
				break;
#line 918 "directory-plugin.c"
			}
#line 172 "directory-plugin.vala"
			_tmp3_ = _match_it;
#line 172 "directory-plugin.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 172 "directory-plugin.vala"
			match = (GeeMapEntry*) _tmp4_;
#line 174 "directory-plugin.vala"
			_tmp5_ = match;
#line 174 "directory-plugin.vala"
			_tmp6_ = gee_map_entry_get_key (_tmp5_);
#line 174 "directory-plugin.vala"
			_tmp7_ = _tmp6_;
#line 174 "directory-plugin.vala"
			_tmp8_ = (SynapseMatch*) _tmp7_;
#line 174 "directory-plugin.vala"
			uri_match = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) _tmp8_) : NULL;
#line 175 "directory-plugin.vala"
			_tmp9_ = uri_match;
#line 175 "directory-plugin.vala"
			if (_tmp9_ == NULL) {
#line 175 "directory-plugin.vala"
				_g_object_unref0 (match);
#line 175 "directory-plugin.vala"
				continue;
#line 944 "directory-plugin.c"
			}
#line 176 "directory-plugin.vala"
			_tmp10_ = uri_match;
#line 176 "directory-plugin.vala"
			_tmp11_ = synapse_uri_match_get_uri (_tmp10_);
#line 176 "directory-plugin.vala"
			_tmp12_ = _tmp11_;
#line 176 "directory-plugin.vala"
			_tmp13_ = g_file_new_for_uri (_tmp12_);
#line 176 "directory-plugin.vala"
			f = _tmp13_;
#line 177 "directory-plugin.vala"
			_tmp15_ = f;
#line 177 "directory-plugin.vala"
			if (!g_file_is_native (_tmp15_)) {
#line 177 "directory-plugin.vala"
				_tmp14_ = TRUE;
#line 962 "directory-plugin.c"
			} else {
				GFile* _tmp16_;
#line 177 "directory-plugin.vala"
				_tmp16_ = f;
#line 177 "directory-plugin.vala"
				_tmp14_ = !g_file_has_parent (_tmp16_, NULL);
#line 969 "directory-plugin.c"
			}
#line 177 "directory-plugin.vala"
			if (_tmp14_) {
#line 177 "directory-plugin.vala"
				_g_object_unref0 (f);
#line 177 "directory-plugin.vala"
				_g_object_unref0 (match);
#line 177 "directory-plugin.vala"
				continue;
#line 979 "directory-plugin.c"
			}
#line 178 "directory-plugin.vala"
			_tmp17_ = f;
#line 178 "directory-plugin.vala"
			_tmp18_ = g_file_get_parent (_tmp17_);
#line 178 "directory-plugin.vala"
			parent = _tmp18_;
#line 179 "directory-plugin.vala"
			_tmp19_ = parent;
#line 179 "directory-plugin.vala"
			_tmp20_ = g_file_get_uri (_tmp19_);
#line 179 "directory-plugin.vala"
			parent_uri = _tmp20_;
#line 180 "directory-plugin.vala"
			_tmp21_ = directories;
#line 180 "directory-plugin.vala"
			_tmp22_ = parent_uri;
#line 180 "directory-plugin.vala"
			if (gee_collection_contains ((GeeCollection*) _tmp21_, _tmp22_)) {
#line 180 "directory-plugin.vala"
				_g_free0 (parent_uri);
#line 180 "directory-plugin.vala"
				_g_object_unref0 (parent);
#line 180 "directory-plugin.vala"
				_g_object_unref0 (f);
#line 180 "directory-plugin.vala"
				_g_object_unref0 (match);
#line 180 "directory-plugin.vala"
				continue;
#line 1009 "directory-plugin.c"
			}
#line 182 "directory-plugin.vala"
			_tmp23_ = directories;
#line 182 "directory-plugin.vala"
			_tmp24_ = parent_uri;
#line 182 "directory-plugin.vala"
			gee_collection_add ((GeeCollection*) _tmp23_, _tmp24_);
#line 172 "directory-plugin.vala"
			_g_free0 (parent_uri);
#line 172 "directory-plugin.vala"
			_g_object_unref0 (parent);
#line 172 "directory-plugin.vala"
			_g_object_unref0 (f);
#line 172 "directory-plugin.vala"
			_g_object_unref0 (match);
#line 1025 "directory-plugin.c"
		}
#line 172 "directory-plugin.vala"
		_g_object_unref0 (_match_it);
#line 1029 "directory-plugin.c"
	}
#line 185 "directory-plugin.vala"
	result = (GeeCollection*) directories;
#line 185 "directory-plugin.vala"
	return result;
#line 1035 "directory-plugin.c"
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 194 "directory-plugin.vala"
	if ((*length) == (*size)) {
#line 194 "directory-plugin.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 194 "directory-plugin.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1050 "directory-plugin.c"
	}
#line 194 "directory-plugin.vala"
	(*array)[(*length)++] = value;
#line 194 "directory-plugin.vala"
	(*array)[*length] = NULL;
#line 1056 "directory-plugin.c"
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 202 "directory-plugin.vala"
	if ((*length) == (*size)) {
#line 202 "directory-plugin.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 202 "directory-plugin.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1071 "directory-plugin.c"
	}
#line 202 "directory-plugin.vala"
	(*array)[(*length)++] = value;
#line 202 "directory-plugin.vala"
	(*array)[*length] = NULL;
#line 1077 "directory-plugin.c"
}

static gchar**
synapse_directory_plugin_get_dir_parents (SynapseDirectoryPlugin* self,
                                          const gchar* dir_uri,
                                          gboolean include_self,
                                          gint* result_length1)
{
	gchar** dirs = NULL;
	gchar** _tmp0_;
	gint dirs_length1;
	gint _dirs_size_;
	GFile* f = NULL;
	GFile* _tmp1_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** result;
#line 190 "directory-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "directory-plugin.vala"
	g_return_val_if_fail (dir_uri != NULL, NULL);
#line 192 "directory-plugin.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 192 "directory-plugin.vala"
	dirs = _tmp0_;
#line 192 "directory-plugin.vala"
	dirs_length1 = 0;
#line 192 "directory-plugin.vala"
	_dirs_size_ = dirs_length1;
#line 193 "directory-plugin.vala"
	_tmp1_ = g_file_new_for_uri (dir_uri);
#line 193 "directory-plugin.vala"
	f = _tmp1_;
#line 194 "directory-plugin.vala"
	if (include_self) {
#line 1113 "directory-plugin.c"
		GFile* _tmp2_;
		gchar* _tmp3_;
#line 194 "directory-plugin.vala"
		_tmp2_ = f;
#line 194 "directory-plugin.vala"
		_tmp3_ = g_file_get_uri (_tmp2_);
#line 194 "directory-plugin.vala"
		_vala_array_add1 (&dirs, &dirs_length1, &_dirs_size_, _tmp3_);
#line 1122 "directory-plugin.c"
	}
#line 196 "directory-plugin.vala"
	while (TRUE) {
#line 1126 "directory-plugin.c"
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		gchar* parent_uri = NULL;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		SynapseDirectoryPluginConfig* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
#line 196 "directory-plugin.vala"
		_tmp4_ = f;
#line 196 "directory-plugin.vala"
		if (!g_file_has_parent (_tmp4_, NULL)) {
#line 196 "directory-plugin.vala"
			break;
#line 1145 "directory-plugin.c"
		}
#line 198 "directory-plugin.vala"
		_tmp5_ = f;
#line 198 "directory-plugin.vala"
		_tmp6_ = g_file_get_parent (_tmp5_);
#line 198 "directory-plugin.vala"
		_g_object_unref0 (f);
#line 198 "directory-plugin.vala"
		f = _tmp6_;
#line 199 "directory-plugin.vala"
		_tmp7_ = f;
#line 199 "directory-plugin.vala"
		_tmp8_ = g_file_get_uri (_tmp7_);
#line 199 "directory-plugin.vala"
		parent_uri = _tmp8_;
#line 200 "directory-plugin.vala"
		_tmp10_ = self->priv->config;
#line 200 "directory-plugin.vala"
		_tmp11_ = synapse_directory_plugin_config_get_home_dir_children_only (_tmp10_);
#line 200 "directory-plugin.vala"
		_tmp12_ = _tmp11_;
#line 200 "directory-plugin.vala"
		if (_tmp12_) {
#line 1169 "directory-plugin.c"
			const gchar* _tmp13_;
			const gchar* _tmp14_;
#line 201 "directory-plugin.vala"
			_tmp13_ = parent_uri;
#line 201 "directory-plugin.vala"
			_tmp14_ = self->priv->home_dir_uri;
#line 201 "directory-plugin.vala"
			_tmp9_ = !g_str_has_prefix (_tmp13_, _tmp14_);
#line 1178 "directory-plugin.c"
		} else {
#line 200 "directory-plugin.vala"
			_tmp9_ = FALSE;
#line 1182 "directory-plugin.c"
		}
#line 200 "directory-plugin.vala"
		if (_tmp9_) {
#line 201 "directory-plugin.vala"
			_g_free0 (parent_uri);
#line 201 "directory-plugin.vala"
			break;
#line 1190 "directory-plugin.c"
		}
#line 202 "directory-plugin.vala"
		_tmp15_ = parent_uri;
#line 202 "directory-plugin.vala"
		_tmp16_ = g_strdup (_tmp15_);
#line 202 "directory-plugin.vala"
		_vala_array_add2 (&dirs, &dirs_length1, &_dirs_size_, _tmp16_);
#line 196 "directory-plugin.vala"
		_g_free0 (parent_uri);
#line 1200 "directory-plugin.c"
	}
#line 205 "directory-plugin.vala"
	_tmp17_ = dirs;
#line 205 "directory-plugin.vala"
	_tmp17__length1 = dirs_length1;
#line 205 "directory-plugin.vala"
	if (result_length1) {
#line 205 "directory-plugin.vala"
		*result_length1 = _tmp17__length1;
#line 1210 "directory-plugin.c"
	}
#line 205 "directory-plugin.vala"
	result = _tmp17_;
#line 205 "directory-plugin.vala"
	_g_object_unref0 (f);
#line 205 "directory-plugin.vala"
	return result;
#line 1218 "directory-plugin.c"
}

static void
synapse_directory_plugin_process_directories_data_free (gpointer _data)
{
	SynapseDirectoryPluginProcessDirectoriesData* _data_;
	_data_ = _data;
#line 29 "directory-plugin.vala"
	_g_object_unref0 (_data_->dirs);
#line 29 "directory-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "directory-plugin.vala"
	g_slice_free (SynapseDirectoryPluginProcessDirectoriesData, _data_);
#line 1232 "directory-plugin.c"
}

static void
synapse_directory_plugin_process_directories (SynapseDirectoryPlugin* self,
                                              GeeCollection* dirs,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SynapseDirectoryPluginProcessDirectoriesData* _data_;
	SynapseDirectoryPlugin* _tmp0_;
	GeeCollection* _tmp1_;
#line 29 "directory-plugin.vala"
	g_return_if_fail (self != NULL);
#line 29 "directory-plugin.vala"
	_data_ = g_slice_new0 (SynapseDirectoryPluginProcessDirectoriesData);
#line 29 "directory-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "directory-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_directory_plugin_process_directories_data_free);
#line 29 "directory-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "directory-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "directory-plugin.vala"
	_tmp1_ = _g_object_ref0 (dirs);
#line 29 "directory-plugin.vala"
	_g_object_unref0 (_data_->dirs);
#line 29 "directory-plugin.vala"
	_data_->dirs = _tmp1_;
#line 29 "directory-plugin.vala"
	synapse_directory_plugin_process_directories_co (_data_);
#line 1264 "directory-plugin.c"
}

static void
synapse_directory_plugin_process_directories_finish (SynapseDirectoryPlugin* self,
                                                     GAsyncResult* _res_)
{
	SynapseDirectoryPluginProcessDirectoriesData* _data_;
#line 29 "directory-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1274 "directory-plugin.c"
}

static void
synapse_directory_plugin_process_directories_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	SynapseDirectoryPluginProcessDirectoriesData* _data_;
#line 239 "directory-plugin.vala"
	_data_ = _user_data_;
#line 239 "directory-plugin.vala"
	_data_->_source_object_ = source_object;
#line 239 "directory-plugin.vala"
	_data_->_res_ = _res_;
#line 239 "directory-plugin.vala"
	synapse_directory_plugin_process_directories_co (_data_);
#line 1291 "directory-plugin.c"
}

static gboolean
synapse_directory_plugin_process_directories_co (SynapseDirectoryPluginProcessDirectoriesData* _data_)
{
#line 208 "directory-plugin.vala"
	switch (_data_->_state_) {
#line 208 "directory-plugin.vala"
		case 0:
#line 1301 "directory-plugin.c"
		goto _state_0;
#line 208 "directory-plugin.vala"
		case 1:
#line 1305 "directory-plugin.c"
		goto _state_1;
		default:
#line 208 "directory-plugin.vala"
		g_assert_not_reached ();
#line 1310 "directory-plugin.c"
	}
	_state_0:
#line 210 "directory-plugin.vala"
	_data_->_tmp0_ = _data_->self->priv->home_dir_uri;
#line 210 "directory-plugin.vala"
	if (_data_->_tmp0_ == NULL) {
#line 212 "directory-plugin.vala"
		_data_->_tmp1_ = g_get_home_dir ();
#line 212 "directory-plugin.vala"
		_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
#line 212 "directory-plugin.vala"
		_data_->home_dir = _data_->_tmp2_;
#line 213 "directory-plugin.vala"
		_data_->_tmp3_ = _data_->home_dir;
#line 213 "directory-plugin.vala"
		if (_data_->_tmp3_ != NULL) {
#line 215 "directory-plugin.vala"
			_data_->_tmp4_ = _data_->home_dir;
#line 215 "directory-plugin.vala"
			_data_->_tmp5_ = g_file_new_for_path (_data_->_tmp4_);
#line 215 "directory-plugin.vala"
			_data_->home = _data_->_tmp5_;
#line 216 "directory-plugin.vala"
			_data_->_tmp6_ = _data_->home;
#line 216 "directory-plugin.vala"
			_data_->_tmp7_ = g_file_get_uri (_data_->_tmp6_);
#line 216 "directory-plugin.vala"
			_data_->_tmp8_ = _data_->_tmp7_;
#line 216 "directory-plugin.vala"
			_data_->_tmp9_ = g_strconcat (_data_->_tmp8_, "/", NULL);
#line 216 "directory-plugin.vala"
			_g_free0 (_data_->self->priv->home_dir_uri);
#line 216 "directory-plugin.vala"
			_data_->self->priv->home_dir_uri = _data_->_tmp9_;
#line 216 "directory-plugin.vala"
			_g_free0 (_data_->_tmp8_);
#line 213 "directory-plugin.vala"
			_g_object_unref0 (_data_->home);
#line 1349 "directory-plugin.c"
		} else {
#line 220 "directory-plugin.vala"
			g_warning ("directory-plugin.vala:220: Home directory is not set!");
#line 221 "directory-plugin.vala"
			_data_->_tmp10_ = g_strdup ("file:///home/");
#line 221 "directory-plugin.vala"
			_g_free0 (_data_->self->priv->home_dir_uri);
#line 221 "directory-plugin.vala"
			_data_->self->priv->home_dir_uri = _data_->_tmp10_;
#line 1359 "directory-plugin.c"
		}
#line 210 "directory-plugin.vala"
		_g_free0 (_data_->home_dir);
#line 1363 "directory-plugin.c"
	}
#line 225 "directory-plugin.vala"
	if (_data_->dirs == NULL) {
#line 225 "directory-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 225 "directory-plugin.vala"
		if (_data_->_state_ != 0) {
#line 225 "directory-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 225 "directory-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1375 "directory-plugin.c"
			}
		}
#line 225 "directory-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 225 "directory-plugin.vala"
		return FALSE;
#line 1382 "directory-plugin.c"
	}
	{
#line 227 "directory-plugin.vala"
		_data_->_tmp11_ = gee_iterable_iterator ((GeeIterable*) _data_->dirs);
#line 227 "directory-plugin.vala"
		_data_->_dir_it = _data_->_tmp11_;
#line 227 "directory-plugin.vala"
		while (TRUE) {
#line 227 "directory-plugin.vala"
			_data_->_tmp12_ = _data_->_dir_it;
#line 227 "directory-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp12_)) {
#line 227 "directory-plugin.vala"
				break;
#line 1397 "directory-plugin.c"
			}
#line 227 "directory-plugin.vala"
			_data_->_tmp13_ = _data_->_dir_it;
#line 227 "directory-plugin.vala"
			_data_->_tmp14_ = gee_iterator_get (_data_->_tmp13_);
#line 227 "directory-plugin.vala"
			_data_->dir = (gchar*) _data_->_tmp14_;
#line 229 "directory-plugin.vala"
			_data_->_tmp15_ = _data_->self->priv->directory_info_map;
#line 229 "directory-plugin.vala"
			_data_->_tmp16_ = _data_->dir;
#line 229 "directory-plugin.vala"
			if (gee_map_has_key (_data_->_tmp15_, _data_->_tmp16_)) {
#line 229 "directory-plugin.vala"
				_g_free0 (_data_->dir);
#line 229 "directory-plugin.vala"
				continue;
#line 1415 "directory-plugin.c"
			}
#line 230 "directory-plugin.vala"
			_data_->_tmp18_ = _data_->self->priv->config;
#line 230 "directory-plugin.vala"
			_data_->_tmp19_ = synapse_directory_plugin_config_get_home_dir_children_only (_data_->_tmp18_);
#line 230 "directory-plugin.vala"
			_data_->_tmp20_ = _data_->_tmp19_;
#line 230 "directory-plugin.vala"
			if (_data_->_tmp20_) {
#line 231 "directory-plugin.vala"
				_data_->_tmp21_ = _data_->dir;
#line 231 "directory-plugin.vala"
				_data_->_tmp22_ = _data_->self->priv->home_dir_uri;
#line 231 "directory-plugin.vala"
				_data_->_tmp17_ = !g_str_has_prefix (_data_->_tmp21_, _data_->_tmp22_);
#line 1431 "directory-plugin.c"
			} else {
#line 230 "directory-plugin.vala"
				_data_->_tmp17_ = FALSE;
#line 1435 "directory-plugin.c"
			}
#line 230 "directory-plugin.vala"
			if (_data_->_tmp17_) {
#line 231 "directory-plugin.vala"
				_g_free0 (_data_->dir);
#line 231 "directory-plugin.vala"
				continue;
#line 1443 "directory-plugin.c"
			}
#line 233 "directory-plugin.vala"
			_data_->_tmp23_ = _data_->dir;
#line 233 "directory-plugin.vala"
			_data_->_tmp24_ = 0;
#line 233 "directory-plugin.vala"
			_data_->_tmp25_ = synapse_directory_plugin_get_dir_parents (_data_->self, _data_->_tmp23_, TRUE, &_data_->_tmp24_);
#line 233 "directory-plugin.vala"
			_data_->directories = _data_->_tmp25_;
#line 233 "directory-plugin.vala"
			_data_->directories_length1 = _data_->_tmp24_;
#line 233 "directory-plugin.vala"
			_data_->_directories_size_ = _data_->directories_length1;
#line 234 "directory-plugin.vala"
			_data_->_tmp26_ = _data_->directories;
#line 234 "directory-plugin.vala"
			_data_->_tmp26__length1 = _data_->directories_length1;
#line 1461 "directory-plugin.c"
			{
#line 234 "directory-plugin.vala"
				_data_->dir_uri_collection_length1 = 0;
#line 234 "directory-plugin.vala"
				_data_->_dir_uri_collection_size_ = 0;
#line 234 "directory-plugin.vala"
				_data_->dir_uri_collection = _data_->_tmp26_;
#line 234 "directory-plugin.vala"
				_data_->dir_uri_collection_length1 = _data_->_tmp26__length1;
#line 234 "directory-plugin.vala"
				for (_data_->dir_uri_it = 0; _data_->dir_uri_it < _data_->dir_uri_collection_length1; _data_->dir_uri_it = _data_->dir_uri_it + 1) {
#line 234 "directory-plugin.vala"
					_data_->dir_uri = _data_->dir_uri_collection[_data_->dir_uri_it];
#line 1475 "directory-plugin.c"
					{
#line 236 "directory-plugin.vala"
						_data_->_tmp27_ = _data_->self->priv->directory_info_map;
#line 236 "directory-plugin.vala"
						_data_->_tmp28_ = _data_->dir_uri;
#line 236 "directory-plugin.vala"
						if (gee_map_has_key (_data_->_tmp27_, _data_->_tmp28_)) {
#line 236 "directory-plugin.vala"
							continue;
#line 1485 "directory-plugin.c"
						}
#line 238 "directory-plugin.vala"
						_data_->_tmp29_ = _data_->dir_uri;
#line 238 "directory-plugin.vala"
						_data_->_tmp30_ = synapse_directory_plugin_directory_info_new (_data_->_tmp29_);
#line 238 "directory-plugin.vala"
						_data_->info = _data_->_tmp30_;
#line 239 "directory-plugin.vala"
						_data_->_tmp31_ = _data_->info;
#line 239 "directory-plugin.vala"
						_data_->_state_ = 1;
#line 239 "directory-plugin.vala"
						synapse_directory_plugin_directory_info_initialize (_data_->_tmp31_, synapse_directory_plugin_process_directories_ready, _data_);
#line 239 "directory-plugin.vala"
						return FALSE;
#line 1501 "directory-plugin.c"
						_state_1:
#line 239 "directory-plugin.vala"
						synapse_directory_plugin_directory_info_initialize_finish (_data_->_tmp31_, _data_->_res_);
#line 240 "directory-plugin.vala"
						_data_->_tmp32_ = _data_->self->priv->directory_info_map;
#line 240 "directory-plugin.vala"
						_data_->_tmp33_ = _data_->info;
#line 240 "directory-plugin.vala"
						_data_->_tmp34_ = _data_->_tmp33_->match_obj;
#line 240 "directory-plugin.vala"
						_data_->_tmp35_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp34_);
#line 240 "directory-plugin.vala"
						_data_->_tmp36_ = _data_->_tmp35_;
#line 240 "directory-plugin.vala"
						_data_->_tmp37_ = _data_->info;
#line 240 "directory-plugin.vala"
						gee_map_set (_data_->_tmp32_, _data_->_tmp36_, _data_->_tmp37_);
#line 234 "directory-plugin.vala"
						_synapse_directory_plugin_directory_info_unref0 (_data_->info);
#line 1521 "directory-plugin.c"
					}
				}
			}
#line 227 "directory-plugin.vala"
			_data_->directories = (_vala_array_free (_data_->directories, _data_->directories_length1, (GDestroyNotify) g_free), NULL);
#line 227 "directory-plugin.vala"
			_g_free0 (_data_->dir);
#line 1529 "directory-plugin.c"
		}
#line 227 "directory-plugin.vala"
		_g_object_unref0 (_data_->_dir_it);
#line 1533 "directory-plugin.c"
	}
#line 208 "directory-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 208 "directory-plugin.vala"
	if (_data_->_state_ != 0) {
#line 208 "directory-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 208 "directory-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1543 "directory-plugin.c"
		}
	}
#line 208 "directory-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 208 "directory-plugin.vala"
	return FALSE;
#line 1550 "directory-plugin.c"
}

static gboolean
synapse_directory_plugin_real_handles_query (SynapseItemProvider* base,
                                             SynapseQuery* q)
{
	SynapseDirectoryPlugin * self;
	SynapseQuery _tmp0_;
	gboolean result;
#line 245 "directory-plugin.vala"
	self = (SynapseDirectoryPlugin*) base;
#line 245 "directory-plugin.vala"
	g_return_val_if_fail (q != NULL, FALSE);
#line 247 "directory-plugin.vala"
	_tmp0_ = *q;
#line 247 "directory-plugin.vala"
	result = (_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_PLACES) == SYNAPSE_QUERY_FLAGS_PLACES;
#line 247 "directory-plugin.vala"
	return result;
#line 1570 "directory-plugin.c"
}

static void
synapse_directory_plugin_real_search_data_free (gpointer _data)
{
	SynapseDirectoryPluginSearchData* _data_;
	_data_ = _data;
#line 29 "directory-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 29 "directory-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 29 "directory-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "directory-plugin.vala"
	g_slice_free (SynapseDirectoryPluginSearchData, _data_);
#line 1586 "directory-plugin.c"
}

static void
synapse_directory_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* q,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SynapseDirectoryPlugin * self;
	SynapseDirectoryPluginSearchData* _data_;
	SynapseDirectoryPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 29 "directory-plugin.vala"
	g_return_if_fail (q != NULL);
#line 29 "directory-plugin.vala"
	self = (SynapseDirectoryPlugin*) base;
#line 29 "directory-plugin.vala"
	_data_ = g_slice_new0 (SynapseDirectoryPluginSearchData);
#line 29 "directory-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "directory-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_directory_plugin_real_search_data_free);
#line 29 "directory-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "directory-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "directory-plugin.vala"
	_tmp1_ = *q;
#line 29 "directory-plugin.vala"
	_tmp2_ = _tmp1_;
#line 29 "directory-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 29 "directory-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 29 "directory-plugin.vala"
	_data_->q = _tmp3_;
#line 29 "directory-plugin.vala"
	synapse_directory_plugin_real_search_co (_data_);
#line 1627 "directory-plugin.c"
}

static SynapseResultSet*
synapse_directory_plugin_search_finish (SynapseItemProvider* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	SynapseResultSet* result;
	SynapseDirectoryPluginSearchData* _data_;
#line 29 "directory-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 29 "directory-plugin.vala"
	if (NULL == _data_) {
#line 29 "directory-plugin.vala"
		return NULL;
#line 1643 "directory-plugin.c"
	}
#line 29 "directory-plugin.vala"
	result = _data_->result;
#line 29 "directory-plugin.vala"
	_data_->result = NULL;
#line 29 "directory-plugin.vala"
	return result;
#line 1651 "directory-plugin.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 250 "directory-plugin.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 250 "directory-plugin.vala"
	return _data2_;
#line 1661 "directory-plugin.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 250 "directory-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1671 "directory-plugin.c"
		SynapseDirectoryPlugin* self;
#line 250 "directory-plugin.vala"
		self = _data2_->self;
#line 250 "directory-plugin.vala"
		_g_object_unref0 (_data2_->zg_rs);
#line 250 "directory-plugin.vala"
		_g_object_unref0 (_data2_->directories);
#line 250 "directory-plugin.vala"
		_g_object_unref0 (self);
#line 250 "directory-plugin.vala"
		g_slice_free (Block2Data, _data2_);
#line 1683 "directory-plugin.c"
	}
}

static void
__lambda7_ (Block2Data* _data2_,
            SynapseResultSet* rs,
            guint q_id)
{
	SynapseDirectoryPlugin* self;
#line 257 "directory-plugin.vala"
	self = _data2_->self;
#line 258 "directory-plugin.vala"
	if (q_id != _data2_->query_id) {
#line 258 "directory-plugin.vala"
		return;
#line 1699 "directory-plugin.c"
	}
#line 260 "directory-plugin.vala"
	if (rs != NULL) {
#line 1703 "directory-plugin.c"
		GeeCollection* _tmp0_;
		SynapseResultSet* _tmp1_;
#line 262 "directory-plugin.vala"
		_tmp0_ = synapse_directory_plugin_extract_directories (self, rs);
#line 262 "directory-plugin.vala"
		_g_object_unref0 (_data2_->directories);
#line 262 "directory-plugin.vala"
		_data2_->directories = _tmp0_;
#line 263 "directory-plugin.vala"
		_tmp1_ = _g_object_ref0 (rs);
#line 263 "directory-plugin.vala"
		_g_object_unref0 (_data2_->zg_rs);
#line 263 "directory-plugin.vala"
		_data2_->zg_rs = _tmp1_;
#line 1718 "directory-plugin.c"
	}
#line 265 "directory-plugin.vala"
	synapse_directory_plugin_real_search_co (_data2_->_async_data_);
#line 1722 "directory-plugin.c"
}

static void
___lambda7__synapse_directory_plugin_zeitgeist_search_complete (SynapseDirectoryPlugin* _sender,
                                                                SynapseResultSet* rs,
                                                                guint query_id,
                                                                gpointer self)
{
#line 257 "directory-plugin.vala"
	__lambda7_ (self, rs, query_id);
#line 1733 "directory-plugin.c"
}

static gboolean
_synapse_directory_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_directory_plugin_real_search_co (self);
#line 270 "directory-plugin.vala"
	return result;
#line 1743 "directory-plugin.c"
}

static void
__lambda8_ (Block2Data* _data2_)
{
	SynapseDirectoryPlugin* self;
#line 267 "directory-plugin.vala"
	self = _data2_->self;
#line 269 "directory-plugin.vala"
	g_signal_handler_block (self, _data2_->sig_id);
#line 270 "directory-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_directory_plugin_real_search_co_gsource_func, _data2_->_async_data_, NULL);
#line 1756 "directory-plugin.c"
}

static void
___lambda8__gfunc (gconstpointer data,
                   gpointer self)
{
#line 267 "directory-plugin.vala"
	__lambda8_ (self);
#line 1765 "directory-plugin.c"
}

static void
synapse_directory_plugin_search_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	SynapseDirectoryPluginSearchData* _data_;
#line 283 "directory-plugin.vala"
	_data_ = _user_data_;
#line 283 "directory-plugin.vala"
	_data_->_source_object_ = source_object;
#line 283 "directory-plugin.vala"
	_data_->_res_ = _res_;
#line 283 "directory-plugin.vala"
	synapse_directory_plugin_real_search_co (_data_);
#line 1782 "directory-plugin.c"
}

static gboolean
synapse_directory_plugin_real_search_co (SynapseDirectoryPluginSearchData* _data_)
{
#line 250 "directory-plugin.vala"
	switch (_data_->_state_) {
#line 250 "directory-plugin.vala"
		case 0:
#line 1792 "directory-plugin.c"
		goto _state_0;
#line 250 "directory-plugin.vala"
		case 1:
#line 1796 "directory-plugin.c"
		goto _state_1;
#line 250 "directory-plugin.vala"
		case 2:
#line 1800 "directory-plugin.c"
		goto _state_2;
#line 250 "directory-plugin.vala"
		case 3:
#line 1804 "directory-plugin.c"
		goto _state_3;
		default:
#line 250 "directory-plugin.vala"
		g_assert_not_reached ();
#line 1809 "directory-plugin.c"
	}
	_state_0:
#line 250 "directory-plugin.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 250 "directory-plugin.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 250 "directory-plugin.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 250 "directory-plugin.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 252 "directory-plugin.vala"
	_data_->_data2_->directories = NULL;
#line 253 "directory-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 253 "directory-plugin.vala"
	_data_->_data2_->query_id = _data_->_tmp0_.query_id;
#line 256 "directory-plugin.vala"
	_data_->_data2_->zg_rs = NULL;
#line 257 "directory-plugin.vala"
	_data_->_tmp1_ = g_signal_connect_data (_data_->self, "zeitgeist-search-complete", (GCallback) ___lambda7__synapse_directory_plugin_zeitgeist_search_complete, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
#line 257 "directory-plugin.vala"
	_data_->_data2_->sig_id = _data_->_tmp1_;
#line 267 "directory-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 267 "directory-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_.cancellable;
#line 267 "directory-plugin.vala"
	_data_->canc_sig_id = g_cancellable_connect (_data_->_tmp3_, (GCallback) ___lambda8__gfunc, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 273 "directory-plugin.vala"
	_data_->_tmp4_ = _data_->self->priv->_data_sink;
#line 273 "directory-plugin.vala"
	if (synapse_data_sink_is_plugin_enabled (_data_->_tmp4_, g_type_from_name ("SynapseZeitgeistPlugin"))) {
#line 276 "directory-plugin.vala"
		_data_->_state_ = 1;
#line 276 "directory-plugin.vala"
		return FALSE;
#line 1846 "directory-plugin.c"
		_state_1:
		;
	}
#line 279 "directory-plugin.vala"
	g_signal_handler_disconnect (_data_->self, _data_->_data2_->sig_id);
#line 280 "directory-plugin.vala"
	_data_->_tmp5_ = _data_->q;
#line 280 "directory-plugin.vala"
	_data_->_tmp6_ = _data_->_tmp5_.cancellable;
#line 280 "directory-plugin.vala"
	g_cancellable_disconnect (_data_->_tmp6_, _data_->canc_sig_id);
#line 282 "directory-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 282 "directory-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 282 "directory-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 282 "directory-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 282 "directory-plugin.vala"
			block2_data_unref (_data_->_data2_);
#line 282 "directory-plugin.vala"
			_data_->_data2_ = NULL;
#line 282 "directory-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 282 "directory-plugin.vala"
			return FALSE;
#line 1874 "directory-plugin.c"
		} else {
#line 282 "directory-plugin.vala"
			block2_data_unref (_data_->_data2_);
#line 282 "directory-plugin.vala"
			_data_->_data2_ = NULL;
#line 282 "directory-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 282 "directory-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 282 "directory-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 282 "directory-plugin.vala"
			return FALSE;
#line 1888 "directory-plugin.c"
		}
	}
#line 283 "directory-plugin.vala"
	if (!_data_->self->priv->xdg_indexed) {
#line 283 "directory-plugin.vala"
		_data_->_state_ = 2;
#line 283 "directory-plugin.vala"
		synapse_directory_plugin_index_xdg_directories (_data_->self, synapse_directory_plugin_search_ready, _data_);
#line 283 "directory-plugin.vala"
		return FALSE;
#line 1899 "directory-plugin.c"
		_state_2:
#line 283 "directory-plugin.vala"
		synapse_directory_plugin_index_xdg_directories_finish (_data_->self, _data_->_res_);
#line 1903 "directory-plugin.c"
	}
#line 286 "directory-plugin.vala"
	_data_->_tmp7_ = _data_->_data2_->directories;
#line 286 "directory-plugin.vala"
	_data_->_state_ = 3;
#line 286 "directory-plugin.vala"
	synapse_directory_plugin_process_directories (_data_->self, _data_->_tmp7_, synapse_directory_plugin_search_ready, _data_);
#line 286 "directory-plugin.vala"
	return FALSE;
#line 1913 "directory-plugin.c"
	_state_3:
#line 286 "directory-plugin.vala"
	synapse_directory_plugin_process_directories_finish (_data_->self, _data_->_res_);
#line 288 "directory-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 288 "directory-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 288 "directory-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 288 "directory-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 288 "directory-plugin.vala"
			block2_data_unref (_data_->_data2_);
#line 288 "directory-plugin.vala"
			_data_->_data2_ = NULL;
#line 288 "directory-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 288 "directory-plugin.vala"
			return FALSE;
#line 1933 "directory-plugin.c"
		} else {
#line 288 "directory-plugin.vala"
			block2_data_unref (_data_->_data2_);
#line 288 "directory-plugin.vala"
			_data_->_data2_ = NULL;
#line 288 "directory-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 288 "directory-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 288 "directory-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 288 "directory-plugin.vala"
			return FALSE;
#line 1947 "directory-plugin.c"
		}
	}
#line 290 "directory-plugin.vala"
	_data_->_tmp8_ = synapse_result_set_new ();
#line 290 "directory-plugin.vala"
	_data_->rs = _data_->_tmp8_;
#line 1954 "directory-plugin.c"
	{
#line 291 "directory-plugin.vala"
		_data_->_tmp9_ = _data_->self->priv->directory_info_map;
#line 291 "directory-plugin.vala"
		_data_->_tmp10_ = gee_map_get_values (_data_->_tmp9_);
#line 291 "directory-plugin.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 291 "directory-plugin.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 291 "directory-plugin.vala"
		_data_->_tmp13_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp12_);
#line 291 "directory-plugin.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 291 "directory-plugin.vala"
		_g_object_unref0 (_data_->_tmp12_);
#line 291 "directory-plugin.vala"
		_data_->_entry_it = _data_->_tmp14_;
#line 291 "directory-plugin.vala"
		while (TRUE) {
#line 291 "directory-plugin.vala"
			_data_->_tmp15_ = _data_->_entry_it;
#line 291 "directory-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp15_)) {
#line 291 "directory-plugin.vala"
				break;
#line 1980 "directory-plugin.c"
			}
#line 291 "directory-plugin.vala"
			_data_->_tmp16_ = _data_->_entry_it;
#line 291 "directory-plugin.vala"
			_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
#line 291 "directory-plugin.vala"
			_data_->entry = (SynapseDirectoryPluginDirectoryInfo*) _data_->_tmp17_;
#line 294 "directory-plugin.vala"
			_data_->_tmp19_ = _data_->_data2_->zg_rs;
#line 294 "directory-plugin.vala"
			if (_data_->_tmp19_ != NULL) {
#line 294 "directory-plugin.vala"
				_data_->_tmp20_ = _data_->_data2_->zg_rs;
#line 294 "directory-plugin.vala"
				_data_->_tmp21_ = _data_->entry;
#line 294 "directory-plugin.vala"
				_data_->_tmp22_ = _data_->_tmp21_->match_obj;
#line 294 "directory-plugin.vala"
				_data_->_tmp23_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp22_);
#line 294 "directory-plugin.vala"
				_data_->_tmp24_ = _data_->_tmp23_;
#line 294 "directory-plugin.vala"
				_data_->_tmp18_ = synapse_result_set_contains_uri (_data_->_tmp20_, _data_->_tmp24_);
#line 2004 "directory-plugin.c"
			} else {
#line 294 "directory-plugin.vala"
				_data_->_tmp18_ = FALSE;
#line 2008 "directory-plugin.c"
			}
#line 294 "directory-plugin.vala"
			if (_data_->_tmp18_) {
#line 294 "directory-plugin.vala"
				_synapse_directory_plugin_directory_info_unref0 (_data_->entry);
#line 294 "directory-plugin.vala"
				continue;
#line 2016 "directory-plugin.c"
			}
#line 296 "directory-plugin.vala"
			_data_->_tmp25_ = _data_->entry;
#line 296 "directory-plugin.vala"
			_data_->_tmp26_ = _data_->_tmp25_->name_folded;
#line 296 "directory-plugin.vala"
			_data_->_tmp27_ = _data_->q;
#line 296 "directory-plugin.vala"
			_data_->_tmp28_ = _data_->_tmp27_.query_string_folded;
#line 296 "directory-plugin.vala"
			if (g_strcmp0 (_data_->_tmp26_, _data_->_tmp28_) == 0) {
#line 299 "directory-plugin.vala"
				_data_->_tmp30_ = _data_->entry;
#line 299 "directory-plugin.vala"
				_data_->_tmp31_ = _data_->_tmp30_->match_obj;
#line 299 "directory-plugin.vala"
				_data_->_tmp32_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp31_);
#line 299 "directory-plugin.vala"
				_data_->_tmp33_ = _data_->_tmp32_;
#line 299 "directory-plugin.vala"
				_data_->_tmp34_ = _data_->self->priv->home_dir_uri;
#line 299 "directory-plugin.vala"
				if (g_str_has_prefix (_data_->_tmp33_, _data_->_tmp34_)) {
#line 300 "directory-plugin.vala"
					_data_->_tmp29_ = SYNAPSE_MATCH_SCORE_EXCELLENT - SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 2042 "directory-plugin.c"
				} else {
#line 301 "directory-plugin.vala"
					_data_->_tmp29_ = SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 2046 "directory-plugin.c"
				}
#line 299 "directory-plugin.vala"
				_data_->relevancy1 = (gint) _data_->_tmp29_;
#line 302 "directory-plugin.vala"
				_data_->_tmp35_ = _data_->rs;
#line 302 "directory-plugin.vala"
				_data_->_tmp36_ = _data_->entry;
#line 302 "directory-plugin.vala"
				_data_->_tmp37_ = _data_->_tmp36_->match_obj;
#line 302 "directory-plugin.vala"
				synapse_result_set_add (_data_->_tmp35_, (SynapseMatch*) _data_->_tmp37_, _data_->relevancy1);
#line 2058 "directory-plugin.c"
			} else {
#line 304 "directory-plugin.vala"
				_data_->_tmp38_ = _data_->entry;
#line 304 "directory-plugin.vala"
				_data_->_tmp39_ = _data_->_tmp38_->name_folded;
#line 304 "directory-plugin.vala"
				_data_->_tmp40_ = _data_->q;
#line 304 "directory-plugin.vala"
				_data_->_tmp41_ = _data_->_tmp40_.query_string_folded;
#line 304 "directory-plugin.vala"
				if (g_str_has_prefix (_data_->_tmp39_, _data_->_tmp41_)) {
#line 307 "directory-plugin.vala"
					_data_->_tmp43_ = _data_->entry;
#line 307 "directory-plugin.vala"
					_data_->_tmp44_ = _data_->_tmp43_->match_obj;
#line 307 "directory-plugin.vala"
					_data_->_tmp45_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp44_);
#line 307 "directory-plugin.vala"
					_data_->_tmp46_ = _data_->_tmp45_;
#line 307 "directory-plugin.vala"
					_data_->_tmp47_ = _data_->self->priv->home_dir_uri;
#line 307 "directory-plugin.vala"
					if (g_str_has_prefix (_data_->_tmp46_, _data_->_tmp47_)) {
#line 308 "directory-plugin.vala"
						_data_->_tmp42_ = SYNAPSE_MATCH_SCORE_VERY_GOOD - SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 2084 "directory-plugin.c"
					} else {
#line 309 "directory-plugin.vala"
						_data_->_tmp42_ = SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE - SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 2088 "directory-plugin.c"
					}
#line 307 "directory-plugin.vala"
					_data_->relevancy2 = (gint) _data_->_tmp42_;
#line 310 "directory-plugin.vala"
					_data_->_tmp48_ = _data_->rs;
#line 310 "directory-plugin.vala"
					_data_->_tmp49_ = _data_->entry;
#line 310 "directory-plugin.vala"
					_data_->_tmp50_ = _data_->_tmp49_->match_obj;
#line 310 "directory-plugin.vala"
					synapse_result_set_add (_data_->_tmp48_, (SynapseMatch*) _data_->_tmp50_, _data_->relevancy2);
#line 2100 "directory-plugin.c"
				}
			}
#line 291 "directory-plugin.vala"
			_synapse_directory_plugin_directory_info_unref0 (_data_->entry);
#line 2105 "directory-plugin.c"
		}
#line 291 "directory-plugin.vala"
		_g_object_unref0 (_data_->_entry_it);
#line 2109 "directory-plugin.c"
	}
#line 314 "directory-plugin.vala"
	_data_->result = _data_->rs;
#line 314 "directory-plugin.vala"
	block2_data_unref (_data_->_data2_);
#line 314 "directory-plugin.vala"
	_data_->_data2_ = NULL;
#line 314 "directory-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 314 "directory-plugin.vala"
	if (_data_->_state_ != 0) {
#line 314 "directory-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 314 "directory-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2125 "directory-plugin.c"
		}
	}
#line 314 "directory-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 314 "directory-plugin.vala"
	return FALSE;
#line 2132 "directory-plugin.c"
}

SynapseDirectoryPlugin*
synapse_directory_plugin_construct (GType object_type)
{
	SynapseDirectoryPlugin * self = NULL;
#line 29 "directory-plugin.vala"
	self = (SynapseDirectoryPlugin*) g_object_new (object_type, NULL);
#line 29 "directory-plugin.vala"
	return self;
#line 2143 "directory-plugin.c"
}

SynapseDirectoryPlugin*
synapse_directory_plugin_new (void)
{
#line 29 "directory-plugin.vala"
	return synapse_directory_plugin_construct (SYNAPSE_TYPE_DIRECTORY_PLUGIN);
#line 2151 "directory-plugin.c"
}

SynapseDataSink*
synapse_directory_plugin_get_data_sink (SynapseDirectoryPlugin* self)
{
	SynapseDataSink* result;
	SynapseDataSink* _tmp0_;
#line 31 "directory-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "directory-plugin.vala"
	_tmp0_ = self->priv->_data_sink;
#line 31 "directory-plugin.vala"
	result = _tmp0_;
#line 31 "directory-plugin.vala"
	return result;
#line 2167 "directory-plugin.c"
}

static void
synapse_directory_plugin_set_data_sink (SynapseDirectoryPlugin* self,
                                        SynapseDataSink* value)
{
	SynapseDataSink* old_value;
#line 31 "directory-plugin.vala"
	g_return_if_fail (self != NULL);
#line 31 "directory-plugin.vala"
	old_value = synapse_directory_plugin_get_data_sink (self);
#line 31 "directory-plugin.vala"
	if (old_value != value) {
#line 31 "directory-plugin.vala"
		self->priv->_data_sink = value;
#line 31 "directory-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_directory_plugin_properties[SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK_PROPERTY]);
#line 2185 "directory-plugin.c"
	}
}

static gboolean
synapse_directory_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseDirectoryPlugin* self;
#line 32 "directory-plugin.vala"
	self = (SynapseDirectoryPlugin*) base;
#line 32 "directory-plugin.vala"
	result = self->priv->_enabled;
#line 32 "directory-plugin.vala"
	return result;
#line 2200 "directory-plugin.c"
}

static void
synapse_directory_plugin_real_set_enabled (SynapseActivatable* base,
                                           gboolean value)
{
	SynapseDirectoryPlugin* self;
	gboolean old_value;
#line 32 "directory-plugin.vala"
	self = (SynapseDirectoryPlugin*) base;
#line 32 "directory-plugin.vala"
	old_value = synapse_directory_plugin_real_get_enabled (base);
#line 32 "directory-plugin.vala"
	if (old_value != value) {
#line 32 "directory-plugin.vala"
		self->priv->_enabled = value;
#line 32 "directory-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_directory_plugin_properties[SYNAPSE_DIRECTORY_PLUGIN_ENABLED_PROPERTY]);
#line 2219 "directory-plugin.c"
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 29 "directory-plugin.vala"
	g_return_if_fail (n_param_values == 3);
#line 29 "directory-plugin.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 29 "directory-plugin.vala"
		data1 = closure->data;
#line 29 "directory-plugin.vala"
		data2 = param_values->data[0].v_pointer;
#line 2245 "directory-plugin.c"
	} else {
#line 29 "directory-plugin.vala"
		data1 = param_values->data[0].v_pointer;
#line 29 "directory-plugin.vala"
		data2 = closure->data;
#line 2251 "directory-plugin.c"
	}
#line 29 "directory-plugin.vala"
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
#line 29 "directory-plugin.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
#line 2257 "directory-plugin.c"
}

static SynapseDirectoryPluginMatchObject*
synapse_directory_plugin_match_object_construct (GType object_type,
                                                 const gchar* uri)
{
	SynapseDirectoryPluginMatchObject * self = NULL;
#line 46 "directory-plugin.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 48 "directory-plugin.vala"
	self = (SynapseDirectoryPluginMatchObject*) g_object_new (object_type, "has-thumbnail", FALSE, "uri", uri, "file-type", SYNAPSE_QUERY_FLAGS_UNCATEGORIZED, "mime-type", "inode/directory", NULL);
#line 46 "directory-plugin.vala"
	return self;
#line 2271 "directory-plugin.c"
}

static SynapseDirectoryPluginMatchObject*
synapse_directory_plugin_match_object_new (const gchar* uri)
{
#line 46 "directory-plugin.vala"
	return synapse_directory_plugin_match_object_construct (SYNAPSE_DIRECTORY_PLUGIN_TYPE_MATCH_OBJECT, uri);
#line 2279 "directory-plugin.c"
}

static void
synapse_directory_plugin_match_object_class_init (SynapseDirectoryPluginMatchObjectClass * klass,
                                                  gpointer klass_data)
{
#line 44 "directory-plugin.vala"
	synapse_directory_plugin_match_object_parent_class = g_type_class_peek_parent (klass);
#line 2288 "directory-plugin.c"
}

static void
synapse_directory_plugin_match_object_instance_init (SynapseDirectoryPluginMatchObject * self,
                                                     gpointer klass)
{
}

static GType
synapse_directory_plugin_match_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDirectoryPluginMatchObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_directory_plugin_match_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDirectoryPluginMatchObject), 0, (GInstanceInitFunc) synapse_directory_plugin_match_object_instance_init, NULL };
	GType synapse_directory_plugin_match_object_type_id;
	synapse_directory_plugin_match_object_type_id = g_type_register_static (SYNAPSE_TYPE_URI_MATCH, "SynapseDirectoryPluginMatchObject", &g_define_type_info, 0);
	return synapse_directory_plugin_match_object_type_id;
}

static GType
synapse_directory_plugin_match_object_get_type (void)
{
	static volatile gsize synapse_directory_plugin_match_object_type_id__once = 0;
	if (g_once_init_enter (&synapse_directory_plugin_match_object_type_id__once)) {
		GType synapse_directory_plugin_match_object_type_id;
		synapse_directory_plugin_match_object_type_id = synapse_directory_plugin_match_object_get_type_once ();
		g_once_init_leave (&synapse_directory_plugin_match_object_type_id__once, synapse_directory_plugin_match_object_type_id);
	}
	return synapse_directory_plugin_match_object_type_id__once;
}

static inline gpointer
synapse_directory_plugin_directory_info_get_instance_private (SynapseDirectoryPluginDirectoryInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDirectoryPluginDirectoryInfo_private_offset);
}

static SynapseDirectoryPluginDirectoryInfo*
synapse_directory_plugin_directory_info_construct (GType object_type,
                                                   const gchar* uri)
{
	SynapseDirectoryPluginDirectoryInfo* self = NULL;
	SynapseDirectoryPluginMatchObject* _tmp0_;
	GFile* f = NULL;
	GFile* _tmp1_;
	SynapseDirectoryPluginMatchObject* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 61 "directory-plugin.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 61 "directory-plugin.vala"
	self = (SynapseDirectoryPluginDirectoryInfo*) g_type_create_instance (object_type);
#line 63 "directory-plugin.vala"
	_tmp0_ = synapse_directory_plugin_match_object_new (uri);
#line 63 "directory-plugin.vala"
	_g_object_unref0 (self->match_obj);
#line 63 "directory-plugin.vala"
	self->match_obj = _tmp0_;
#line 64 "directory-plugin.vala"
	_tmp1_ = g_file_new_for_uri (uri);
#line 64 "directory-plugin.vala"
	f = _tmp1_;
#line 65 "directory-plugin.vala"
	_tmp2_ = self->match_obj;
#line 65 "directory-plugin.vala"
	_tmp3_ = g_file_get_path (f);
#line 65 "directory-plugin.vala"
	_tmp4_ = _tmp3_;
#line 65 "directory-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) _tmp2_, _tmp4_);
#line 65 "directory-plugin.vala"
	_g_free0 (_tmp4_);
#line 61 "directory-plugin.vala"
	_g_object_unref0 (f);
#line 61 "directory-plugin.vala"
	return self;
#line 2363 "directory-plugin.c"
}

static SynapseDirectoryPluginDirectoryInfo*
synapse_directory_plugin_directory_info_new (const gchar* uri)
{
#line 61 "directory-plugin.vala"
	return synapse_directory_plugin_directory_info_construct (SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, uri);
#line 2371 "directory-plugin.c"
}

static void
synapse_directory_plugin_directory_info_initialize_data_free (gpointer _data)
{
	SynapseDirectoryPluginDirectoryInfoInitializeData* _data_;
	_data_ = _data;
#line 55 "directory-plugin.vala"
	_synapse_directory_plugin_directory_info_unref0 (_data_->self);
#line 55 "directory-plugin.vala"
	g_slice_free (SynapseDirectoryPluginDirectoryInfoInitializeData, _data_);
#line 2383 "directory-plugin.c"
}

static gpointer
_synapse_directory_plugin_directory_info_ref0 (gpointer self)
{
#line 55 "directory-plugin.vala"
	return self ? synapse_directory_plugin_directory_info_ref (self) : NULL;
#line 2391 "directory-plugin.c"
}

static void
synapse_directory_plugin_directory_info_initialize (SynapseDirectoryPluginDirectoryInfo* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	SynapseDirectoryPluginDirectoryInfoInitializeData* _data_;
	SynapseDirectoryPluginDirectoryInfo* _tmp0_;
#line 55 "directory-plugin.vala"
	g_return_if_fail (self != NULL);
#line 55 "directory-plugin.vala"
	_data_ = g_slice_new0 (SynapseDirectoryPluginDirectoryInfoInitializeData);
#line 55 "directory-plugin.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 55 "directory-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_directory_plugin_directory_info_initialize_data_free);
#line 55 "directory-plugin.vala"
	_tmp0_ = _synapse_directory_plugin_directory_info_ref0 (self);
#line 55 "directory-plugin.vala"
	_data_->self = _tmp0_;
#line 55 "directory-plugin.vala"
	synapse_directory_plugin_directory_info_initialize_co (_data_);
#line 2415 "directory-plugin.c"
}

static void
synapse_directory_plugin_directory_info_initialize_finish (SynapseDirectoryPluginDirectoryInfo* self,
                                                           GAsyncResult* _res_)
{
	SynapseDirectoryPluginDirectoryInfoInitializeData* _data_;
#line 55 "directory-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2425 "directory-plugin.c"
}

static void
synapse_directory_plugin_directory_info_initialize_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	SynapseDirectoryPluginDirectoryInfoInitializeData* _data_;
#line 78 "directory-plugin.vala"
	_data_ = _user_data_;
#line 78 "directory-plugin.vala"
	_data_->_source_object_ = source_object;
#line 78 "directory-plugin.vala"
	_data_->_res_ = _res_;
#line 78 "directory-plugin.vala"
	synapse_directory_plugin_directory_info_initialize_co (_data_);
#line 2442 "directory-plugin.c"
}

static gboolean
synapse_directory_plugin_directory_info_initialize_co (SynapseDirectoryPluginDirectoryInfoInitializeData* _data_)
{
#line 72 "directory-plugin.vala"
	switch (_data_->_state_) {
#line 72 "directory-plugin.vala"
		case 0:
#line 2452 "directory-plugin.c"
		goto _state_0;
#line 72 "directory-plugin.vala"
		case 1:
#line 2456 "directory-plugin.c"
		goto _state_1;
		default:
#line 72 "directory-plugin.vala"
		g_assert_not_reached ();
#line 2461 "directory-plugin.c"
	}
	_state_0:
#line 75 "directory-plugin.vala"
	_data_->_tmp0_ = _data_->self->match_obj;
#line 75 "directory-plugin.vala"
	_data_->_tmp1_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp0_);
#line 75 "directory-plugin.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 75 "directory-plugin.vala"
	_data_->_tmp3_ = g_file_new_for_uri (_data_->_tmp2_);
#line 75 "directory-plugin.vala"
	_data_->f = _data_->_tmp3_;
#line 2474 "directory-plugin.c"
	{
#line 78 "directory-plugin.vala"
		_data_->_state_ = 1;
#line 78 "directory-plugin.vala"
		g_file_query_info_async (_data_->f, G_FILE_ATTRIBUTE_STANDARD_ICON "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_ATTRIBUTE_CUSTOM_ICON, 0, G_PRIORITY_DEFAULT, NULL, synapse_directory_plugin_directory_info_initialize_ready, _data_);
#line 78 "directory-plugin.vala"
		return FALSE;
#line 2482 "directory-plugin.c"
		_state_1:
#line 78 "directory-plugin.vala"
		_data_->_tmp4_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error0_);
#line 78 "directory-plugin.vala"
		_data_->fi = _data_->_tmp4_;
#line 78 "directory-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 2490 "directory-plugin.c"
			goto __catch0_g_error;
		}
#line 82 "directory-plugin.vala"
		_data_->_tmp5_ = g_file_info_get_display_name (_data_->fi);
#line 82 "directory-plugin.vala"
		_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 82 "directory-plugin.vala"
		_g_free0 (_data_->self->name);
#line 82 "directory-plugin.vala"
		_data_->self->name = _data_->_tmp6_;
#line 83 "directory-plugin.vala"
		_data_->_tmp7_ = _data_->self->name;
#line 83 "directory-plugin.vala"
		_data_->_tmp8_ = g_utf8_casefold (_data_->_tmp7_, (gssize) -1);
#line 83 "directory-plugin.vala"
		_g_free0 (_data_->self->name_folded);
#line 83 "directory-plugin.vala"
		_data_->self->name_folded = _data_->_tmp8_;
#line 84 "directory-plugin.vala"
		_data_->_tmp9_ = _data_->self->match_obj;
#line 84 "directory-plugin.vala"
		_data_->_tmp10_ = _data_->self->name;
#line 84 "directory-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) _data_->_tmp9_, _data_->_tmp10_);
#line 85 "directory-plugin.vala"
		_data_->_tmp11_ = _data_->self->match_obj;
#line 85 "directory-plugin.vala"
		_data_->_tmp12_ = g_file_info_get_icon (_data_->fi);
#line 85 "directory-plugin.vala"
		_data_->_tmp13_ = g_icon_to_string (_data_->_tmp12_);
#line 85 "directory-plugin.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 85 "directory-plugin.vala"
		synapse_match_set_icon_name ((SynapseMatch*) _data_->_tmp11_, _data_->_tmp14_);
#line 85 "directory-plugin.vala"
		_g_free0 (_data_->_tmp14_);
#line 86 "directory-plugin.vala"
		if (g_file_info_has_attribute (_data_->fi, SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_ATTRIBUTE_CUSTOM_ICON)) {
#line 88 "directory-plugin.vala"
			_data_->_tmp15_ = g_file_info_get_attribute_string (_data_->fi, SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_ATTRIBUTE_CUSTOM_ICON);
#line 88 "directory-plugin.vala"
			_data_->_tmp16_ = g_file_new_for_uri (_data_->_tmp15_);
#line 88 "directory-plugin.vala"
			_data_->icon_f = _data_->_tmp16_;
#line 89 "directory-plugin.vala"
			_data_->_tmp17_ = _data_->self->match_obj;
#line 89 "directory-plugin.vala"
			_data_->_tmp18_ = _data_->icon_f;
#line 89 "directory-plugin.vala"
			_data_->_tmp19_ = g_file_get_path (_data_->_tmp18_);
#line 89 "directory-plugin.vala"
			_data_->_tmp20_ = _data_->_tmp19_;
#line 89 "directory-plugin.vala"
			synapse_match_set_icon_name ((SynapseMatch*) _data_->_tmp17_, _data_->_tmp20_);
#line 89 "directory-plugin.vala"
			_g_free0 (_data_->_tmp20_);
#line 86 "directory-plugin.vala"
			_g_object_unref0 (_data_->icon_f);
#line 2549 "directory-plugin.c"
		}
#line 76 "directory-plugin.vala"
		_g_object_unref0 (_data_->fi);
#line 2553 "directory-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 76 "directory-plugin.vala"
		_data_->err = _data_->_inner_error0_;
#line 76 "directory-plugin.vala"
		_data_->_inner_error0_ = NULL;
#line 94 "directory-plugin.vala"
		_data_->_tmp21_ = _data_->err;
#line 94 "directory-plugin.vala"
		_data_->_tmp22_ = _data_->_tmp21_->message;
#line 94 "directory-plugin.vala"
		g_warning ("directory-plugin.vala:94: %s", _data_->_tmp22_);
#line 76 "directory-plugin.vala"
		_g_error_free0 (_data_->err);
#line 2570 "directory-plugin.c"
	}
	__finally0:
#line 76 "directory-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 76 "directory-plugin.vala"
		_g_object_unref0 (_data_->f);
#line 76 "directory-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 76 "directory-plugin.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 76 "directory-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 76 "directory-plugin.vala"
		return FALSE;
#line 2585 "directory-plugin.c"
	}
#line 97 "directory-plugin.vala"
	_data_->self->priv->initialized = TRUE;
#line 72 "directory-plugin.vala"
	_g_object_unref0 (_data_->f);
#line 72 "directory-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 72 "directory-plugin.vala"
	if (_data_->_state_ != 0) {
#line 72 "directory-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 72 "directory-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2599 "directory-plugin.c"
		}
	}
#line 72 "directory-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 72 "directory-plugin.vala"
	return FALSE;
#line 2606 "directory-plugin.c"
}

static void
synapse_directory_plugin_value_directory_info_init (GValue* value)
{
#line 55 "directory-plugin.vala"
	value->data[0].v_pointer = NULL;
#line 2614 "directory-plugin.c"
}

static void
synapse_directory_plugin_value_directory_info_free_value (GValue* value)
{
#line 55 "directory-plugin.vala"
	if (value->data[0].v_pointer) {
#line 55 "directory-plugin.vala"
		synapse_directory_plugin_directory_info_unref (value->data[0].v_pointer);
#line 2624 "directory-plugin.c"
	}
}

static void
synapse_directory_plugin_value_directory_info_copy_value (const GValue* src_value,
                                                          GValue* dest_value)
{
#line 55 "directory-plugin.vala"
	if (src_value->data[0].v_pointer) {
#line 55 "directory-plugin.vala"
		dest_value->data[0].v_pointer = synapse_directory_plugin_directory_info_ref (src_value->data[0].v_pointer);
#line 2636 "directory-plugin.c"
	} else {
#line 55 "directory-plugin.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2640 "directory-plugin.c"
	}
}

static gpointer
synapse_directory_plugin_value_directory_info_peek_pointer (const GValue* value)
{
#line 55 "directory-plugin.vala"
	return value->data[0].v_pointer;
#line 2649 "directory-plugin.c"
}

static gchar*
synapse_directory_plugin_value_directory_info_collect_value (GValue* value,
                                                             guint n_collect_values,
                                                             GTypeCValue* collect_values,
                                                             guint collect_flags)
{
#line 55 "directory-plugin.vala"
	if (collect_values[0].v_pointer) {
#line 2660 "directory-plugin.c"
		SynapseDirectoryPluginDirectoryInfo * object;
		object = collect_values[0].v_pointer;
#line 55 "directory-plugin.vala"
		if (object->parent_instance.g_class == NULL) {
#line 55 "directory-plugin.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2667 "directory-plugin.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 55 "directory-plugin.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2671 "directory-plugin.c"
		}
#line 55 "directory-plugin.vala"
		value->data[0].v_pointer = synapse_directory_plugin_directory_info_ref (object);
#line 2675 "directory-plugin.c"
	} else {
#line 55 "directory-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 2679 "directory-plugin.c"
	}
#line 55 "directory-plugin.vala"
	return NULL;
#line 2683 "directory-plugin.c"
}

static gchar*
synapse_directory_plugin_value_directory_info_lcopy_value (const GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	SynapseDirectoryPluginDirectoryInfo ** object_p;
	object_p = collect_values[0].v_pointer;
#line 55 "directory-plugin.vala"
	if (!object_p) {
#line 55 "directory-plugin.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2698 "directory-plugin.c"
	}
#line 55 "directory-plugin.vala"
	if (!value->data[0].v_pointer) {
#line 55 "directory-plugin.vala"
		*object_p = NULL;
#line 2704 "directory-plugin.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 55 "directory-plugin.vala"
		*object_p = value->data[0].v_pointer;
#line 2708 "directory-plugin.c"
	} else {
#line 55 "directory-plugin.vala"
		*object_p = synapse_directory_plugin_directory_info_ref (value->data[0].v_pointer);
#line 2712 "directory-plugin.c"
	}
#line 55 "directory-plugin.vala"
	return NULL;
#line 2716 "directory-plugin.c"
}

static GParamSpec*
synapse_directory_plugin_param_spec_directory_info (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags)
{
	SynapseDirectoryPluginParamSpecDirectoryInfo* spec;
#line 55 "directory-plugin.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
#line 55 "directory-plugin.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 55 "directory-plugin.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 55 "directory-plugin.vala"
	return G_PARAM_SPEC (spec);
#line 2735 "directory-plugin.c"
}

static gpointer
synapse_directory_plugin_value_get_directory_info (const GValue* value)
{
#line 55 "directory-plugin.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
#line 55 "directory-plugin.vala"
	return value->data[0].v_pointer;
#line 2745 "directory-plugin.c"
}

static void
synapse_directory_plugin_value_set_directory_info (GValue* value,
                                                   gpointer v_object)
{
	SynapseDirectoryPluginDirectoryInfo * old;
#line 55 "directory-plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO));
#line 55 "directory-plugin.vala"
	old = value->data[0].v_pointer;
#line 55 "directory-plugin.vala"
	if (v_object) {
#line 55 "directory-plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO));
#line 55 "directory-plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "directory-plugin.vala"
		value->data[0].v_pointer = v_object;
#line 55 "directory-plugin.vala"
		synapse_directory_plugin_directory_info_ref (value->data[0].v_pointer);
#line 2767 "directory-plugin.c"
	} else {
#line 55 "directory-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 2771 "directory-plugin.c"
	}
#line 55 "directory-plugin.vala"
	if (old) {
#line 55 "directory-plugin.vala"
		synapse_directory_plugin_directory_info_unref (old);
#line 2777 "directory-plugin.c"
	}
}

static void
synapse_directory_plugin_value_take_directory_info (GValue* value,
                                                    gpointer v_object)
{
	SynapseDirectoryPluginDirectoryInfo * old;
#line 55 "directory-plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO));
#line 55 "directory-plugin.vala"
	old = value->data[0].v_pointer;
#line 55 "directory-plugin.vala"
	if (v_object) {
#line 55 "directory-plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO));
#line 55 "directory-plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "directory-plugin.vala"
		value->data[0].v_pointer = v_object;
#line 2798 "directory-plugin.c"
	} else {
#line 55 "directory-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 2802 "directory-plugin.c"
	}
#line 55 "directory-plugin.vala"
	if (old) {
#line 55 "directory-plugin.vala"
		synapse_directory_plugin_directory_info_unref (old);
#line 2808 "directory-plugin.c"
	}
}

static void
synapse_directory_plugin_directory_info_class_init (SynapseDirectoryPluginDirectoryInfoClass * klass,
                                                    gpointer klass_data)
{
#line 55 "directory-plugin.vala"
	synapse_directory_plugin_directory_info_parent_class = g_type_class_peek_parent (klass);
#line 55 "directory-plugin.vala"
	((SynapseDirectoryPluginDirectoryInfoClass *) klass)->finalize = synapse_directory_plugin_directory_info_finalize;
#line 55 "directory-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDirectoryPluginDirectoryInfo_private_offset);
#line 2822 "directory-plugin.c"
}

static void
synapse_directory_plugin_directory_info_instance_init (SynapseDirectoryPluginDirectoryInfo * self,
                                                       gpointer klass)
{
#line 55 "directory-plugin.vala"
	self->priv = synapse_directory_plugin_directory_info_get_instance_private (self);
#line 68 "directory-plugin.vala"
	self->priv->initialized = FALSE;
#line 55 "directory-plugin.vala"
	self->ref_count = 1;
#line 2835 "directory-plugin.c"
}

static void
synapse_directory_plugin_directory_info_finalize (SynapseDirectoryPluginDirectoryInfo * obj)
{
	SynapseDirectoryPluginDirectoryInfo * self;
#line 55 "directory-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, SynapseDirectoryPluginDirectoryInfo);
#line 55 "directory-plugin.vala"
	g_signal_handlers_destroy (self);
#line 57 "directory-plugin.vala"
	_g_object_unref0 (self->match_obj);
#line 58 "directory-plugin.vala"
	_g_free0 (self->name);
#line 59 "directory-plugin.vala"
	_g_free0 (self->name_folded);
#line 2852 "directory-plugin.c"
}

static GType
synapse_directory_plugin_directory_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_directory_plugin_value_directory_info_init, synapse_directory_plugin_value_directory_info_free_value, synapse_directory_plugin_value_directory_info_copy_value, synapse_directory_plugin_value_directory_info_peek_pointer, "p", synapse_directory_plugin_value_directory_info_collect_value, "p", synapse_directory_plugin_value_directory_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDirectoryPluginDirectoryInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_directory_plugin_directory_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDirectoryPluginDirectoryInfo), 0, (GInstanceInitFunc) synapse_directory_plugin_directory_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_directory_plugin_directory_info_type_id;
	synapse_directory_plugin_directory_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseDirectoryPluginDirectoryInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SynapseDirectoryPluginDirectoryInfo_private_offset = g_type_add_instance_private (synapse_directory_plugin_directory_info_type_id, sizeof (SynapseDirectoryPluginDirectoryInfoPrivate));
	return synapse_directory_plugin_directory_info_type_id;
}

static GType
synapse_directory_plugin_directory_info_get_type (void)
{
	static volatile gsize synapse_directory_plugin_directory_info_type_id__once = 0;
	if (g_once_init_enter (&synapse_directory_plugin_directory_info_type_id__once)) {
		GType synapse_directory_plugin_directory_info_type_id;
		synapse_directory_plugin_directory_info_type_id = synapse_directory_plugin_directory_info_get_type_once ();
		g_once_init_leave (&synapse_directory_plugin_directory_info_type_id__once, synapse_directory_plugin_directory_info_type_id);
	}
	return synapse_directory_plugin_directory_info_type_id__once;
}

static gpointer
synapse_directory_plugin_directory_info_ref (gpointer instance)
{
	SynapseDirectoryPluginDirectoryInfo * self;
	self = instance;
#line 55 "directory-plugin.vala"
	g_atomic_int_inc (&self->ref_count);
#line 55 "directory-plugin.vala"
	return instance;
#line 2888 "directory-plugin.c"
}

static void
synapse_directory_plugin_directory_info_unref (gpointer instance)
{
	SynapseDirectoryPluginDirectoryInfo * self;
	self = instance;
#line 55 "directory-plugin.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 55 "directory-plugin.vala"
		SYNAPSE_DIRECTORY_PLUGIN_DIRECTORY_INFO_GET_CLASS (self)->finalize (self);
#line 55 "directory-plugin.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2902 "directory-plugin.c"
	}
}

static inline gpointer
synapse_directory_plugin_config_get_instance_private (SynapseDirectoryPluginConfig* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDirectoryPluginConfig_private_offset);
}

static SynapseDirectoryPluginConfig*
synapse_directory_plugin_config_construct (GType object_type)
{
	SynapseDirectoryPluginConfig * self = NULL;
#line 101 "directory-plugin.vala"
	self = (SynapseDirectoryPluginConfig*) synapse_config_object_construct (object_type);
#line 101 "directory-plugin.vala"
	return self;
#line 2920 "directory-plugin.c"
}

static SynapseDirectoryPluginConfig*
synapse_directory_plugin_config_new (void)
{
#line 101 "directory-plugin.vala"
	return synapse_directory_plugin_config_construct (SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG);
#line 2928 "directory-plugin.c"
}

static gboolean
synapse_directory_plugin_config_get_home_dir_children_only (SynapseDirectoryPluginConfig* self)
{
	gboolean result;
#line 103 "directory-plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 103 "directory-plugin.vala"
	result = self->priv->_home_dir_children_only;
#line 103 "directory-plugin.vala"
	return result;
#line 2941 "directory-plugin.c"
}

static void
synapse_directory_plugin_config_set_home_dir_children_only (SynapseDirectoryPluginConfig* self,
                                                            gboolean value)
{
	gboolean old_value;
#line 103 "directory-plugin.vala"
	g_return_if_fail (self != NULL);
#line 103 "directory-plugin.vala"
	old_value = synapse_directory_plugin_config_get_home_dir_children_only (self);
#line 103 "directory-plugin.vala"
	if (old_value != value) {
#line 103 "directory-plugin.vala"
		self->priv->_home_dir_children_only = value;
#line 103 "directory-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_directory_plugin_config_properties[SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY_PROPERTY]);
#line 2959 "directory-plugin.c"
	}
}

static void
synapse_directory_plugin_config_class_init (SynapseDirectoryPluginConfigClass * klass,
                                            gpointer klass_data)
{
#line 101 "directory-plugin.vala"
	synapse_directory_plugin_config_parent_class = g_type_class_peek_parent (klass);
#line 101 "directory-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDirectoryPluginConfig_private_offset);
#line 101 "directory-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_directory_plugin_config_get_property;
#line 101 "directory-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_directory_plugin_config_set_property;
#line 101 "directory-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_directory_plugin_config_finalize;
#line 101 "directory-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY_PROPERTY, synapse_directory_plugin_config_properties[SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY_PROPERTY] = g_param_spec_boolean ("home-dir-children-only", "home-dir-children-only", "home-dir-children-only", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2979 "directory-plugin.c"
}

static void
synapse_directory_plugin_config_instance_init (SynapseDirectoryPluginConfig * self,
                                               gpointer klass)
{
#line 101 "directory-plugin.vala"
	self->priv = synapse_directory_plugin_config_get_instance_private (self);
#line 103 "directory-plugin.vala"
	self->priv->_home_dir_children_only = TRUE;
#line 2990 "directory-plugin.c"
}

static void
synapse_directory_plugin_config_finalize (GObject * obj)
{
	SynapseDirectoryPluginConfig * self;
#line 101 "directory-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfig);
#line 101 "directory-plugin.vala"
	G_OBJECT_CLASS (synapse_directory_plugin_config_parent_class)->finalize (obj);
#line 3001 "directory-plugin.c"
}

static GType
synapse_directory_plugin_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDirectoryPluginConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_directory_plugin_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDirectoryPluginConfig), 0, (GInstanceInitFunc) synapse_directory_plugin_config_instance_init, NULL };
	GType synapse_directory_plugin_config_type_id;
	synapse_directory_plugin_config_type_id = g_type_register_static (SYNAPSE_TYPE_CONFIG_OBJECT, "SynapseDirectoryPluginConfig", &g_define_type_info, 0);
	SynapseDirectoryPluginConfig_private_offset = g_type_add_instance_private (synapse_directory_plugin_config_type_id, sizeof (SynapseDirectoryPluginConfigPrivate));
	return synapse_directory_plugin_config_type_id;
}

static GType
synapse_directory_plugin_config_get_type (void)
{
	static volatile gsize synapse_directory_plugin_config_type_id__once = 0;
	if (g_once_init_enter (&synapse_directory_plugin_config_type_id__once)) {
		GType synapse_directory_plugin_config_type_id;
		synapse_directory_plugin_config_type_id = synapse_directory_plugin_config_get_type_once ();
		g_once_init_leave (&synapse_directory_plugin_config_type_id__once, synapse_directory_plugin_config_type_id);
	}
	return synapse_directory_plugin_config_type_id__once;
}

static void
_vala_synapse_directory_plugin_config_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	SynapseDirectoryPluginConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfig);
#line 101 "directory-plugin.vala"
	switch (property_id) {
#line 101 "directory-plugin.vala"
		case SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY_PROPERTY:
#line 101 "directory-plugin.vala"
		g_value_set_boolean (value, synapse_directory_plugin_config_get_home_dir_children_only (self));
#line 101 "directory-plugin.vala"
		break;
#line 3042 "directory-plugin.c"
		default:
#line 101 "directory-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 101 "directory-plugin.vala"
		break;
#line 3048 "directory-plugin.c"
	}
}

static void
_vala_synapse_directory_plugin_config_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	SynapseDirectoryPluginConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfig);
#line 101 "directory-plugin.vala"
	switch (property_id) {
#line 101 "directory-plugin.vala"
		case SYNAPSE_DIRECTORY_PLUGIN_CONFIG_HOME_DIR_CHILDREN_ONLY_PROPERTY:
#line 101 "directory-plugin.vala"
		synapse_directory_plugin_config_set_home_dir_children_only (self, g_value_get_boolean (value));
#line 101 "directory-plugin.vala"
		break;
#line 3068 "directory-plugin.c"
		default:
#line 101 "directory-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 101 "directory-plugin.vala"
		break;
#line 3074 "directory-plugin.c"
	}
}

static GObject *
synapse_directory_plugin_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDirectoryPlugin * self;
	GeeHashMap* _tmp0_;
	SynapseConfigService* cs = NULL;
	SynapseConfigService* _tmp1_;
	SynapseConfigService* _tmp2_;
	SynapseConfigObject* _tmp3_;
#line 125 "directory-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_directory_plugin_parent_class);
#line 125 "directory-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 125 "directory-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DIRECTORY_PLUGIN, SynapseDirectoryPlugin);
#line 127 "directory-plugin.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, NULL, NULL, SYNAPSE_DIRECTORY_PLUGIN_TYPE_DIRECTORY_INFO, (GBoxedCopyFunc) synapse_directory_plugin_directory_info_ref, (GDestroyNotify) synapse_directory_plugin_directory_info_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 127 "directory-plugin.vala"
	_g_object_unref0 (self->priv->directory_info_map);
#line 127 "directory-plugin.vala"
	self->priv->directory_info_map = (GeeMap*) _tmp0_;
#line 128 "directory-plugin.vala"
	_tmp1_ = synapse_config_service_get_default ();
#line 128 "directory-plugin.vala"
	cs = _tmp1_;
#line 129 "directory-plugin.vala"
	_tmp2_ = cs;
#line 129 "directory-plugin.vala"
	_tmp3_ = synapse_config_service_get_config (_tmp2_, "plugins", "directory-plugin", SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG);
#line 129 "directory-plugin.vala"
	_g_object_unref0 (self->priv->config);
#line 129 "directory-plugin.vala"
	self->priv->config = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SYNAPSE_DIRECTORY_PLUGIN_TYPE_CONFIG, SynapseDirectoryPluginConfig);
#line 125 "directory-plugin.vala"
	_g_object_unref0 (cs);
#line 125 "directory-plugin.vala"
	return obj;
#line 3119 "directory-plugin.c"
}

static void
synapse_directory_plugin_class_init (SynapseDirectoryPluginClass * klass,
                                     gpointer klass_data)
{
#line 29 "directory-plugin.vala"
	synapse_directory_plugin_parent_class = g_type_class_peek_parent (klass);
#line 29 "directory-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDirectoryPlugin_private_offset);
#line 29 "directory-plugin.vala"
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) synapse_directory_plugin_real_constructed;
#line 29 "directory-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_directory_plugin_get_property;
#line 29 "directory-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_directory_plugin_set_property;
#line 29 "directory-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_directory_plugin_constructor;
#line 29 "directory-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_directory_plugin_finalize;
#line 29 "directory-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK_PROPERTY, synapse_directory_plugin_properties[SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK_PROPERTY] = g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 29 "directory-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DIRECTORY_PLUGIN_ENABLED_PROPERTY, synapse_directory_plugin_properties[SYNAPSE_DIRECTORY_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "directory-plugin.vala"
	synapse_directory_plugin_signals[SYNAPSE_DIRECTORY_PLUGIN_ZEITGEIST_SEARCH_COMPLETE_SIGNAL] = g_signal_new ("zeitgeist-search-complete", SYNAPSE_TYPE_DIRECTORY_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
#line 119 "directory-plugin.vala"
	synapse_directory_plugin_register_plugin ();
#line 3148 "directory-plugin.c"
}

static void
synapse_directory_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                             gpointer iface_data)
{
#line 29 "directory-plugin.vala"
	synapse_directory_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "directory-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_directory_plugin_real_activate;
#line 29 "directory-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_directory_plugin_real_deactivate;
#line 29 "directory-plugin.vala"
	iface->get_enabled = synapse_directory_plugin_real_get_enabled;
#line 29 "directory-plugin.vala"
	iface->set_enabled = synapse_directory_plugin_real_set_enabled;
#line 3165 "directory-plugin.c"
}

static void
synapse_directory_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                               gpointer iface_data)
{
#line 29 "directory-plugin.vala"
	synapse_directory_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "directory-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_directory_plugin_real_handles_query;
#line 29 "directory-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_directory_plugin_real_search;
#line 29 "directory-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_directory_plugin_search_finish;
#line 3180 "directory-plugin.c"
}

static void
synapse_directory_plugin_instance_init (SynapseDirectoryPlugin * self,
                                        gpointer klass)
{
#line 29 "directory-plugin.vala"
	self->priv = synapse_directory_plugin_get_instance_private (self);
#line 32 "directory-plugin.vala"
	self->priv->_enabled = TRUE;
#line 137 "directory-plugin.vala"
	self->priv->xdg_indexed = FALSE;
#line 188 "directory-plugin.vala"
	self->priv->home_dir_uri = NULL;
#line 3195 "directory-plugin.c"
}

static void
synapse_directory_plugin_finalize (GObject * obj)
{
	SynapseDirectoryPlugin * self;
#line 29 "directory-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DIRECTORY_PLUGIN, SynapseDirectoryPlugin);
#line 122 "directory-plugin.vala"
	_g_object_unref0 (self->priv->directory_info_map);
#line 123 "directory-plugin.vala"
	_g_object_unref0 (self->priv->config);
#line 188 "directory-plugin.vala"
	_g_free0 (self->priv->home_dir_uri);
#line 29 "directory-plugin.vala"
	G_OBJECT_CLASS (synapse_directory_plugin_parent_class)->finalize (obj);
#line 3212 "directory-plugin.c"
}

static GType
synapse_directory_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDirectoryPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_directory_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDirectoryPlugin), 0, (GInstanceInitFunc) synapse_directory_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_directory_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_directory_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_directory_plugin_type_id;
	synapse_directory_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDirectoryPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_directory_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_directory_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseDirectoryPlugin_private_offset = g_type_add_instance_private (synapse_directory_plugin_type_id, sizeof (SynapseDirectoryPluginPrivate));
	return synapse_directory_plugin_type_id;
}

GType
synapse_directory_plugin_get_type (void)
{
	static volatile gsize synapse_directory_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_directory_plugin_type_id__once)) {
		GType synapse_directory_plugin_type_id;
		synapse_directory_plugin_type_id = synapse_directory_plugin_get_type_once ();
		g_once_init_leave (&synapse_directory_plugin_type_id__once, synapse_directory_plugin_type_id);
	}
	return synapse_directory_plugin_type_id__once;
}

static void
_vala_synapse_directory_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SynapseDirectoryPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DIRECTORY_PLUGIN, SynapseDirectoryPlugin);
#line 29 "directory-plugin.vala"
	switch (property_id) {
#line 29 "directory-plugin.vala"
		case SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK_PROPERTY:
#line 29 "directory-plugin.vala"
		g_value_set_object (value, synapse_directory_plugin_get_data_sink (self));
#line 29 "directory-plugin.vala"
		break;
#line 29 "directory-plugin.vala"
		case SYNAPSE_DIRECTORY_PLUGIN_ENABLED_PROPERTY:
#line 29 "directory-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 29 "directory-plugin.vala"
		break;
#line 3263 "directory-plugin.c"
		default:
#line 29 "directory-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "directory-plugin.vala"
		break;
#line 3269 "directory-plugin.c"
	}
}

static void
_vala_synapse_directory_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SynapseDirectoryPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DIRECTORY_PLUGIN, SynapseDirectoryPlugin);
#line 29 "directory-plugin.vala"
	switch (property_id) {
#line 29 "directory-plugin.vala"
		case SYNAPSE_DIRECTORY_PLUGIN_DATA_SINK_PROPERTY:
#line 29 "directory-plugin.vala"
		synapse_directory_plugin_set_data_sink (self, g_value_get_object (value));
#line 29 "directory-plugin.vala"
		break;
#line 29 "directory-plugin.vala"
		case SYNAPSE_DIRECTORY_PLUGIN_ENABLED_PROPERTY:
#line 29 "directory-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 29 "directory-plugin.vala"
		break;
#line 3295 "directory-plugin.c"
		default:
#line 29 "directory-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "directory-plugin.vala"
		break;
#line 3301 "directory-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

