/* devhelp-search.c generated by valac 0.56.17, the Vala compiler
 * generated from devhelp-search.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <synapse-core.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH (synapse_devhelp_plugin_search_get_type ())
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch))
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearchClass))
#define SYNAPSE_DEVHELP_PLUGIN_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH))
#define SYNAPSE_DEVHELP_PLUGIN_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH))
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearchClass))

typedef struct _SynapseDevhelpPluginSearch SynapseDevhelpPluginSearch;
typedef struct _SynapseDevhelpPluginSearchClass SynapseDevhelpPluginSearchClass;
enum  {
	SYNAPSE_DEVHELP_PLUGIN_0_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_devhelp_plugin_properties[SYNAPSE_DEVHELP_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseDevhelpPluginSearchPrivate SynapseDevhelpPluginSearchPrivate;
enum  {
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_0_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_NUM_PROPERTIES
};
static GParamSpec* synapse_devhelp_plugin_search_properties[SYNAPSE_DEVHELP_PLUGIN_SEARCH_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseDevhelpPluginPrivate {
	gboolean _enabled;
	SynapseDevhelpPluginSearch* action;
	gboolean has_devhelp;
	GRegex* symbol_re;
};

struct _SynapseDevhelpPluginSearch {
	SynapseMatch parent_instance;
	SynapseDevhelpPluginSearchPrivate * priv;
};

struct _SynapseDevhelpPluginSearchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseDevhelpPluginSearchPrivate {
	gint _default_relevancy;
};

static gint SynapseDevhelpPlugin_private_offset;
static gpointer synapse_devhelp_plugin_parent_class = NULL;
static gint SynapseDevhelpPluginSearch_private_offset;
static gpointer synapse_devhelp_plugin_search_parent_class = NULL;
static SynapseActivatableIface * synapse_devhelp_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_devhelp_plugin_synapse_action_provider_parent_iface = NULL;

static GType synapse_devhelp_plugin_search_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_devhelp_plugin_real_activate (SynapseActivatable* base);
static void synapse_devhelp_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_devhelp_plugin_register_plugin (void);
static void _synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_devhelp_plugin_real_handles_unknown (SynapseActionProvider* base);
static SynapseResultSet* synapse_devhelp_plugin_real_find_for_match (SynapseActionProvider* base,
                                                              SynapseQuery* query,
                                                              SynapseMatch* match);
static gint synapse_devhelp_plugin_search_get_default_relevancy (SynapseDevhelpPluginSearch* self);
static void synapse_devhelp_plugin_search_real_execute (SynapseMatch* base,
                                                 SynapseMatch* match);
static SynapseDevhelpPluginSearch* synapse_devhelp_plugin_search_new (void);
static SynapseDevhelpPluginSearch* synapse_devhelp_plugin_search_construct (GType object_type);
static void synapse_devhelp_plugin_search_set_default_relevancy (SynapseDevhelpPluginSearch* self,
                                                          gint value);
static void synapse_devhelp_plugin_search_finalize (GObject * obj);
static GType synapse_devhelp_plugin_search_get_type_once (void);
static void _vala_synapse_devhelp_plugin_search_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_synapse_devhelp_plugin_search_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static GObject * synapse_devhelp_plugin_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_devhelp_plugin_finalize (GObject * obj);
static GType synapse_devhelp_plugin_get_type_once (void);
static void _vala_synapse_devhelp_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_devhelp_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
synapse_devhelp_plugin_get_instance_private (SynapseDevhelpPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDevhelpPlugin_private_offset);
}

static void
synapse_devhelp_plugin_real_activate (SynapseActivatable* base)
{
	SynapseDevhelpPlugin * self;
#line 28 "devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 151 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseDevhelpPlugin * self;
#line 33 "devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 160 "devhelp-search.c"
}

static void
_synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 67 "devhelp-search.vala"
	synapse_devhelp_plugin_register_plugin ();
#line 168 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 67 "devhelp-search.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 67 "devhelp-search.vala"
	_tmp1_ = _tmp0_;
#line 67 "devhelp-search.vala"
	_tmp2_ = g_find_program_in_path ("devhelp");
#line 67 "devhelp-search.vala"
	_tmp3_ = _tmp2_;
#line 67 "devhelp-search.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DEVHELP_PLUGIN, "Devhelp", _ ("Search documentation using Devhelp."), "devhelp", _synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("Devhelp is not installed"));
#line 67 "devhelp-search.vala"
	_g_free0 (_tmp3_);
#line 67 "devhelp-search.vala"
	_g_object_unref0 (_tmp1_);
#line 192 "devhelp-search.c"
}

static gboolean
synapse_devhelp_plugin_real_handles_unknown (SynapseActionProvider* base)
{
	SynapseDevhelpPlugin * self;
	gboolean result;
#line 103 "devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 105 "devhelp-search.vala"
	result = self->priv->has_devhelp;
#line 105 "devhelp-search.vala"
	return result;
#line 206 "devhelp-search.c"
}

static SynapseResultSet*
synapse_devhelp_plugin_real_find_for_match (SynapseActionProvider* base,
                                            SynapseQuery* query,
                                            SynapseMatch* match)
{
	SynapseDevhelpPlugin * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp5_;
	SynapseResultSet* result;
#line 110 "devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 110 "devhelp-search.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 110 "devhelp-search.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 112 "devhelp-search.vala"
	if (!self->priv->has_devhelp) {
#line 112 "devhelp-search.vala"
		_tmp1_ = TRUE;
#line 233 "devhelp-search.c"
	} else {
#line 112 "devhelp-search.vala"
		_tmp1_ = !G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_UNKNOWN_MATCH);
#line 237 "devhelp-search.c"
	}
#line 112 "devhelp-search.vala"
	if (_tmp1_) {
#line 112 "devhelp-search.vala"
		_tmp0_ = TRUE;
#line 243 "devhelp-search.c"
	} else {
		SynapseQuery _tmp2_;
#line 113 "devhelp-search.vala"
		_tmp2_ = *query;
#line 113 "devhelp-search.vala"
		_tmp0_ = !((_tmp2_.query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS);
#line 250 "devhelp-search.c"
	}
#line 112 "devhelp-search.vala"
	if (_tmp0_) {
#line 115 "devhelp-search.vala"
		result = NULL;
#line 115 "devhelp-search.vala"
		return result;
#line 258 "devhelp-search.c"
	}
#line 118 "devhelp-search.vala"
	_tmp3_ = *query;
#line 118 "devhelp-search.vala"
	_tmp4_ = _tmp3_.query_string;
#line 118 "devhelp-search.vala"
	query_empty = g_strcmp0 (_tmp4_, "") == 0;
#line 119 "devhelp-search.vala"
	_tmp5_ = synapse_result_set_new ();
#line 119 "devhelp-search.vala"
	results = _tmp5_;
#line 121 "devhelp-search.vala"
	if (query_empty) {
#line 272 "devhelp-search.c"
		gint relevancy = 0;
		SynapseDevhelpPluginSearch* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GRegex* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		SynapseResultSet* _tmp12_;
		SynapseDevhelpPluginSearch* _tmp13_;
#line 123 "devhelp-search.vala"
		_tmp6_ = self->priv->action;
#line 123 "devhelp-search.vala"
		_tmp7_ = synapse_devhelp_plugin_search_get_default_relevancy (_tmp6_);
#line 123 "devhelp-search.vala"
		_tmp8_ = _tmp7_;
#line 123 "devhelp-search.vala"
		relevancy = _tmp8_;
#line 124 "devhelp-search.vala"
		_tmp9_ = self->priv->symbol_re;
#line 124 "devhelp-search.vala"
		_tmp10_ = synapse_match_get_title (match);
#line 124 "devhelp-search.vala"
		_tmp11_ = _tmp10_;
#line 124 "devhelp-search.vala"
		if (g_regex_match (_tmp9_, _tmp11_, 0, NULL)) {
#line 124 "devhelp-search.vala"
			relevancy += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 300 "devhelp-search.c"
		}
#line 125 "devhelp-search.vala"
		_tmp12_ = results;
#line 125 "devhelp-search.vala"
		_tmp13_ = self->priv->action;
#line 125 "devhelp-search.vala"
		synapse_result_set_add (_tmp12_, (SynapseMatch*) _tmp13_, relevancy);
#line 308 "devhelp-search.c"
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp14_;
		const gchar* _tmp15_;
		GeeList* _tmp16_;
#line 129 "devhelp-search.vala"
		_tmp14_ = *query;
#line 129 "devhelp-search.vala"
		_tmp15_ = _tmp14_.query_string;
#line 129 "devhelp-search.vala"
		_tmp16_ = synapse_query_get_matchers_for_query (_tmp15_, 0, G_REGEX_CASELESS);
#line 129 "devhelp-search.vala"
		matchers = _tmp16_;
#line 322 "devhelp-search.c"
		{
			GeeList* _matcher_list = NULL;
			GeeList* _tmp17_;
			gint _matcher_size = 0;
			GeeList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _matcher_index = 0;
#line 131 "devhelp-search.vala"
			_tmp17_ = matchers;
#line 131 "devhelp-search.vala"
			_matcher_list = _tmp17_;
#line 131 "devhelp-search.vala"
			_tmp18_ = _matcher_list;
#line 131 "devhelp-search.vala"
			_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
#line 131 "devhelp-search.vala"
			_tmp20_ = _tmp19_;
#line 131 "devhelp-search.vala"
			_matcher_size = _tmp20_;
#line 131 "devhelp-search.vala"
			_matcher_index = -1;
#line 131 "devhelp-search.vala"
			while (TRUE) {
#line 347 "devhelp-search.c"
				gint _tmp21_;
				gint _tmp22_;
				GeeMapEntry* matcher = NULL;
				GeeList* _tmp23_;
				gpointer _tmp24_;
				GeeMapEntry* _tmp25_;
				gconstpointer _tmp26_;
				gconstpointer _tmp27_;
				SynapseDevhelpPluginSearch* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
#line 131 "devhelp-search.vala"
				_matcher_index = _matcher_index + 1;
#line 131 "devhelp-search.vala"
				_tmp21_ = _matcher_index;
#line 131 "devhelp-search.vala"
				_tmp22_ = _matcher_size;
#line 131 "devhelp-search.vala"
				if (!(_tmp21_ < _tmp22_)) {
#line 131 "devhelp-search.vala"
					break;
#line 369 "devhelp-search.c"
				}
#line 131 "devhelp-search.vala"
				_tmp23_ = _matcher_list;
#line 131 "devhelp-search.vala"
				_tmp24_ = gee_list_get (_tmp23_, _matcher_index);
#line 131 "devhelp-search.vala"
				matcher = (GeeMapEntry*) _tmp24_;
#line 133 "devhelp-search.vala"
				_tmp25_ = matcher;
#line 133 "devhelp-search.vala"
				_tmp26_ = gee_map_entry_get_key (_tmp25_);
#line 133 "devhelp-search.vala"
				_tmp27_ = _tmp26_;
#line 133 "devhelp-search.vala"
				_tmp28_ = self->priv->action;
#line 133 "devhelp-search.vala"
				_tmp29_ = synapse_match_get_title ((SynapseMatch*) _tmp28_);
#line 133 "devhelp-search.vala"
				_tmp30_ = _tmp29_;
#line 133 "devhelp-search.vala"
				if (g_regex_match ((GRegex*) _tmp27_, _tmp30_, 0, NULL)) {
#line 391 "devhelp-search.c"
					SynapseResultSet* _tmp31_;
					SynapseDevhelpPluginSearch* _tmp32_;
					GeeMapEntry* _tmp33_;
					gconstpointer _tmp34_;
					gconstpointer _tmp35_;
#line 135 "devhelp-search.vala"
					_tmp31_ = results;
#line 135 "devhelp-search.vala"
					_tmp32_ = self->priv->action;
#line 135 "devhelp-search.vala"
					_tmp33_ = matcher;
#line 135 "devhelp-search.vala"
					_tmp34_ = gee_map_entry_get_value (_tmp33_);
#line 135 "devhelp-search.vala"
					_tmp35_ = _tmp34_;
#line 135 "devhelp-search.vala"
					synapse_result_set_add (_tmp31_, (SynapseMatch*) _tmp32_, (gint) ((gintptr) _tmp35_));
#line 136 "devhelp-search.vala"
					_g_object_unref0 (matcher);
#line 136 "devhelp-search.vala"
					break;
#line 413 "devhelp-search.c"
				}
#line 131 "devhelp-search.vala"
				_g_object_unref0 (matcher);
#line 417 "devhelp-search.c"
			}
		}
#line 121 "devhelp-search.vala"
		_g_object_unref0 (matchers);
#line 422 "devhelp-search.c"
	}
#line 141 "devhelp-search.vala"
	result = results;
#line 141 "devhelp-search.vala"
	return result;
#line 428 "devhelp-search.c"
}

SynapseDevhelpPlugin*
synapse_devhelp_plugin_construct (GType object_type)
{
	SynapseDevhelpPlugin * self = NULL;
#line 24 "devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) g_object_new (object_type, NULL);
#line 24 "devhelp-search.vala"
	return self;
#line 439 "devhelp-search.c"
}

SynapseDevhelpPlugin*
synapse_devhelp_plugin_new (void)
{
#line 24 "devhelp-search.vala"
	return synapse_devhelp_plugin_construct (SYNAPSE_TYPE_DEVHELP_PLUGIN);
#line 447 "devhelp-search.c"
}

static gboolean
synapse_devhelp_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseDevhelpPlugin* self;
#line 26 "devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 26 "devhelp-search.vala"
	result = self->priv->_enabled;
#line 26 "devhelp-search.vala"
	return result;
#line 461 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseDevhelpPlugin* self;
	gboolean old_value;
#line 26 "devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 26 "devhelp-search.vala"
	old_value = synapse_devhelp_plugin_real_get_enabled (base);
#line 26 "devhelp-search.vala"
	if (old_value != value) {
#line 26 "devhelp-search.vala"
		self->priv->_enabled = value;
#line 26 "devhelp-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_devhelp_plugin_properties[SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY]);
#line 480 "devhelp-search.c"
	}
}

static inline gpointer
synapse_devhelp_plugin_search_get_instance_private (SynapseDevhelpPluginSearch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDevhelpPluginSearch_private_offset);
}

static void
synapse_devhelp_plugin_search_real_execute (SynapseMatch* base,
                                            SynapseMatch* match)
{
	SynapseDevhelpPluginSearch * self;
	GError* _inner_error0_ = NULL;
#line 42 "devhelp-search.vala"
	self = (SynapseDevhelpPluginSearch*) base;
#line 42 "devhelp-search.vala"
	g_return_if_fail (match != NULL);
#line 500 "devhelp-search.c"
	{
		GAppInfo* ai = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		GAppInfo* _tmp6_;
#line 46 "devhelp-search.vala"
		_tmp0_ = synapse_match_get_title (match);
#line 46 "devhelp-search.vala"
		_tmp1_ = _tmp0_;
#line 46 "devhelp-search.vala"
		_tmp2_ = g_strdup_printf ("devhelp -s \"%s\"", _tmp1_);
#line 46 "devhelp-search.vala"
		_tmp3_ = _tmp2_;
#line 46 "devhelp-search.vala"
		_tmp4_ = g_app_info_create_from_commandline (_tmp3_, "devhelp", 0, &_inner_error0_);
#line 46 "devhelp-search.vala"
		_tmp5_ = _tmp4_;
#line 46 "devhelp-search.vala"
		_g_free0 (_tmp3_);
#line 46 "devhelp-search.vala"
		ai = _tmp5_;
#line 46 "devhelp-search.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 528 "devhelp-search.c"
			goto __catch0_g_error;
		}
#line 49 "devhelp-search.vala"
		_tmp6_ = ai;
#line 49 "devhelp-search.vala"
		g_app_info_launch (_tmp6_, NULL, NULL, &_inner_error0_);
#line 49 "devhelp-search.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 49 "devhelp-search.vala"
			_g_object_unref0 (ai);
#line 539 "devhelp-search.c"
			goto __catch0_g_error;
		}
#line 44 "devhelp-search.vala"
		_g_object_unref0 (ai);
#line 544 "devhelp-search.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 44 "devhelp-search.vala"
		err = _inner_error0_;
#line 44 "devhelp-search.vala"
		_inner_error0_ = NULL;
#line 53 "devhelp-search.vala"
		_tmp7_ = err;
#line 53 "devhelp-search.vala"
		_tmp8_ = _tmp7_->message;
#line 53 "devhelp-search.vala"
		g_warning ("devhelp-search.vala:53: %s", _tmp8_);
#line 44 "devhelp-search.vala"
		_g_error_free0 (err);
#line 564 "devhelp-search.c"
	}
	__finally0:
#line 44 "devhelp-search.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 44 "devhelp-search.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 44 "devhelp-search.vala"
		g_clear_error (&_inner_error0_);
#line 44 "devhelp-search.vala"
		return;
#line 575 "devhelp-search.c"
	}
}

static SynapseDevhelpPluginSearch*
synapse_devhelp_plugin_search_construct (GType object_type)
{
	SynapseDevhelpPluginSearch * self = NULL;
#line 59 "devhelp-search.vala"
	self = (SynapseDevhelpPluginSearch*) g_object_new (object_type, "title", _ ("Search in Devhelp"), "description", _ ("Search documentation for this symbol"), "has-thumbnail", FALSE, "icon-name", "devhelp", NULL);
#line 57 "devhelp-search.vala"
	return self;
#line 587 "devhelp-search.c"
}

static SynapseDevhelpPluginSearch*
synapse_devhelp_plugin_search_new (void)
{
#line 57 "devhelp-search.vala"
	return synapse_devhelp_plugin_search_construct (SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH);
#line 595 "devhelp-search.c"
}

static gint
synapse_devhelp_plugin_search_get_default_relevancy (SynapseDevhelpPluginSearch* self)
{
	gint result;
#line 40 "devhelp-search.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "devhelp-search.vala"
	result = self->priv->_default_relevancy;
#line 40 "devhelp-search.vala"
	return result;
#line 608 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_search_set_default_relevancy (SynapseDevhelpPluginSearch* self,
                                                     gint value)
{
	gint old_value;
#line 40 "devhelp-search.vala"
	g_return_if_fail (self != NULL);
#line 40 "devhelp-search.vala"
	old_value = synapse_devhelp_plugin_search_get_default_relevancy (self);
#line 40 "devhelp-search.vala"
	if (old_value != value) {
#line 40 "devhelp-search.vala"
		self->priv->_default_relevancy = value;
#line 40 "devhelp-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_devhelp_plugin_search_properties[SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY]);
#line 626 "devhelp-search.c"
	}
}

static void
synapse_devhelp_plugin_search_class_init (SynapseDevhelpPluginSearchClass * klass,
                                          gpointer klass_data)
{
#line 38 "devhelp-search.vala"
	synapse_devhelp_plugin_search_parent_class = g_type_class_peek_parent (klass);
#line 38 "devhelp-search.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDevhelpPluginSearch_private_offset);
#line 38 "devhelp-search.vala"
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_devhelp_plugin_search_real_execute;
#line 38 "devhelp-search.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_devhelp_plugin_search_get_property;
#line 38 "devhelp-search.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_devhelp_plugin_search_set_property;
#line 38 "devhelp-search.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_devhelp_plugin_search_finalize;
#line 38 "devhelp-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY, synapse_devhelp_plugin_search_properties[SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 648 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_search_instance_init (SynapseDevhelpPluginSearch * self,
                                             gpointer klass)
{
#line 38 "devhelp-search.vala"
	self->priv = synapse_devhelp_plugin_search_get_instance_private (self);
#line 40 "devhelp-search.vala"
	self->priv->_default_relevancy = 0;
#line 659 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_search_finalize (GObject * obj)
{
	SynapseDevhelpPluginSearch * self;
#line 38 "devhelp-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch);
#line 38 "devhelp-search.vala"
	G_OBJECT_CLASS (synapse_devhelp_plugin_search_parent_class)->finalize (obj);
#line 670 "devhelp-search.c"
}

static GType
synapse_devhelp_plugin_search_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDevhelpPluginSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_devhelp_plugin_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDevhelpPluginSearch), 0, (GInstanceInitFunc) synapse_devhelp_plugin_search_instance_init, NULL };
	GType synapse_devhelp_plugin_search_type_id;
	synapse_devhelp_plugin_search_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseDevhelpPluginSearch", &g_define_type_info, 0);
	SynapseDevhelpPluginSearch_private_offset = g_type_add_instance_private (synapse_devhelp_plugin_search_type_id, sizeof (SynapseDevhelpPluginSearchPrivate));
	return synapse_devhelp_plugin_search_type_id;
}

static GType
synapse_devhelp_plugin_search_get_type (void)
{
	static volatile gsize synapse_devhelp_plugin_search_type_id__once = 0;
	if (g_once_init_enter (&synapse_devhelp_plugin_search_type_id__once)) {
		GType synapse_devhelp_plugin_search_type_id;
		synapse_devhelp_plugin_search_type_id = synapse_devhelp_plugin_search_get_type_once ();
		g_once_init_leave (&synapse_devhelp_plugin_search_type_id__once, synapse_devhelp_plugin_search_type_id);
	}
	return synapse_devhelp_plugin_search_type_id__once;
}

static void
_vala_synapse_devhelp_plugin_search_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	SynapseDevhelpPluginSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch);
#line 38 "devhelp-search.vala"
	switch (property_id) {
#line 38 "devhelp-search.vala"
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "devhelp-search.vala"
		g_value_set_int (value, synapse_devhelp_plugin_search_get_default_relevancy (self));
#line 38 "devhelp-search.vala"
		break;
#line 711 "devhelp-search.c"
		default:
#line 38 "devhelp-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "devhelp-search.vala"
		break;
#line 717 "devhelp-search.c"
	}
}

static void
_vala_synapse_devhelp_plugin_search_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	SynapseDevhelpPluginSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch);
#line 38 "devhelp-search.vala"
	switch (property_id) {
#line 38 "devhelp-search.vala"
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "devhelp-search.vala"
		synapse_devhelp_plugin_search_set_default_relevancy (self, g_value_get_int (value));
#line 38 "devhelp-search.vala"
		break;
#line 737 "devhelp-search.c"
		default:
#line 38 "devhelp-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "devhelp-search.vala"
		break;
#line 743 "devhelp-search.c"
	}
}

static GObject *
synapse_devhelp_plugin_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDevhelpPlugin * self;
	SynapseDevhelpPluginSearch* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 86 "devhelp-search.vala"
	parent_class = G_OBJECT_CLASS (synapse_devhelp_plugin_parent_class);
#line 86 "devhelp-search.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 86 "devhelp-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin);
#line 88 "devhelp-search.vala"
	_tmp0_ = synapse_devhelp_plugin_search_new ();
#line 88 "devhelp-search.vala"
	_g_object_unref0 (self->priv->action);
#line 88 "devhelp-search.vala"
	self->priv->action = _tmp0_;
#line 89 "devhelp-search.vala"
	_tmp1_ = g_find_program_in_path ("devhelp");
#line 89 "devhelp-search.vala"
	_tmp2_ = _tmp1_;
#line 89 "devhelp-search.vala"
	self->priv->has_devhelp = _tmp2_ != NULL;
#line 89 "devhelp-search.vala"
	_g_free0 (_tmp2_);
#line 779 "devhelp-search.c"
	{
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 94 "devhelp-search.vala"
		_tmp4_ = g_regex_new ("^([a-z]+_)|([A-Z]+[a-z]+[A-Z])", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 94 "devhelp-search.vala"
		_tmp3_ = _tmp4_;
#line 94 "devhelp-search.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 790 "devhelp-search.c"
			goto __catch0_g_error;
		}
#line 94 "devhelp-search.vala"
		_tmp5_ = _tmp3_;
#line 94 "devhelp-search.vala"
		_tmp3_ = NULL;
#line 94 "devhelp-search.vala"
		_g_regex_unref0 (self->priv->symbol_re);
#line 94 "devhelp-search.vala"
		self->priv->symbol_re = _tmp5_;
#line 92 "devhelp-search.vala"
		_g_regex_unref0 (_tmp3_);
#line 803 "devhelp-search.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 92 "devhelp-search.vala"
		err = _inner_error0_;
#line 92 "devhelp-search.vala"
		_inner_error0_ = NULL;
#line 99 "devhelp-search.vala"
		_tmp6_ = err;
#line 99 "devhelp-search.vala"
		_tmp7_ = _tmp6_->message;
#line 99 "devhelp-search.vala"
		g_warning ("devhelp-search.vala:99: %s", _tmp7_);
#line 92 "devhelp-search.vala"
		_g_error_free0 (err);
#line 823 "devhelp-search.c"
	}
	__finally0:
#line 92 "devhelp-search.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 92 "devhelp-search.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 92 "devhelp-search.vala"
		g_clear_error (&_inner_error0_);
#line 832 "devhelp-search.c"
	}
#line 86 "devhelp-search.vala"
	return obj;
#line 836 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_class_init (SynapseDevhelpPluginClass * klass,
                                   gpointer klass_data)
{
#line 24 "devhelp-search.vala"
	synapse_devhelp_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "devhelp-search.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDevhelpPlugin_private_offset);
#line 24 "devhelp-search.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_devhelp_plugin_get_property;
#line 24 "devhelp-search.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_devhelp_plugin_set_property;
#line 24 "devhelp-search.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_devhelp_plugin_constructor;
#line 24 "devhelp-search.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_devhelp_plugin_finalize;
#line 24 "devhelp-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY, synapse_devhelp_plugin_properties[SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 80 "devhelp-search.vala"
	synapse_devhelp_plugin_register_plugin ();
#line 859 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
#line 24 "devhelp-search.vala"
	synapse_devhelp_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "devhelp-search.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_devhelp_plugin_real_activate;
#line 24 "devhelp-search.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_devhelp_plugin_real_deactivate;
#line 24 "devhelp-search.vala"
	iface->get_enabled = synapse_devhelp_plugin_real_get_enabled;
#line 24 "devhelp-search.vala"
	iface->set_enabled = synapse_devhelp_plugin_real_set_enabled;
#line 876 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                               gpointer iface_data)
{
#line 24 "devhelp-search.vala"
	synapse_devhelp_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "devhelp-search.vala"
	iface->handles_unknown = (gboolean (*) (SynapseActionProvider*)) synapse_devhelp_plugin_real_handles_unknown;
#line 24 "devhelp-search.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_devhelp_plugin_real_find_for_match;
#line 889 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_instance_init (SynapseDevhelpPlugin * self,
                                      gpointer klass)
{
#line 24 "devhelp-search.vala"
	self->priv = synapse_devhelp_plugin_get_instance_private (self);
#line 26 "devhelp-search.vala"
	self->priv->_enabled = TRUE;
#line 900 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_finalize (GObject * obj)
{
	SynapseDevhelpPlugin * self;
#line 24 "devhelp-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin);
#line 83 "devhelp-search.vala"
	_g_object_unref0 (self->priv->action);
#line 108 "devhelp-search.vala"
	_g_regex_unref0 (self->priv->symbol_re);
#line 24 "devhelp-search.vala"
	G_OBJECT_CLASS (synapse_devhelp_plugin_parent_class)->finalize (obj);
#line 915 "devhelp-search.c"
}

static GType
synapse_devhelp_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDevhelpPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_devhelp_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDevhelpPlugin), 0, (GInstanceInitFunc) synapse_devhelp_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_devhelp_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_devhelp_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_devhelp_plugin_type_id;
	synapse_devhelp_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDevhelpPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_devhelp_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_devhelp_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseDevhelpPlugin_private_offset = g_type_add_instance_private (synapse_devhelp_plugin_type_id, sizeof (SynapseDevhelpPluginPrivate));
	return synapse_devhelp_plugin_type_id;
}

GType
synapse_devhelp_plugin_get_type (void)
{
	static volatile gsize synapse_devhelp_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_devhelp_plugin_type_id__once)) {
		GType synapse_devhelp_plugin_type_id;
		synapse_devhelp_plugin_type_id = synapse_devhelp_plugin_get_type_once ();
		g_once_init_leave (&synapse_devhelp_plugin_type_id__once, synapse_devhelp_plugin_type_id);
	}
	return synapse_devhelp_plugin_type_id__once;
}

static void
_vala_synapse_devhelp_plugin_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseDevhelpPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin);
#line 24 "devhelp-search.vala"
	switch (property_id) {
#line 24 "devhelp-search.vala"
		case SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY:
#line 24 "devhelp-search.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "devhelp-search.vala"
		break;
#line 960 "devhelp-search.c"
		default:
#line 24 "devhelp-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "devhelp-search.vala"
		break;
#line 966 "devhelp-search.c"
	}
}

static void
_vala_synapse_devhelp_plugin_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseDevhelpPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin);
#line 24 "devhelp-search.vala"
	switch (property_id) {
#line 24 "devhelp-search.vala"
		case SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY:
#line 24 "devhelp-search.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "devhelp-search.vala"
		break;
#line 986 "devhelp-search.c"
		default:
#line 24 "devhelp-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "devhelp-search.vala"
		break;
#line 992 "devhelp-search.c"
	}
}

