/* MainPage.c generated by valac 0.56.18, the Vala compiler
 * generated from MainPage.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2019-2024 elementary, Inc. (https://elementary.io)
 */

#include "wacom.h"
#include <granite-7.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WACOM_MAIN_PAGE_0_PROPERTY,
	WACOM_MAIN_PAGE_NUM_PROPERTIES
};
static GParamSpec* wacom_main_page_properties[WACOM_MAIN_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _WacomMainPagePrivate {
	WacomBackendDeviceManager* device_manager;
	WacomBackendWacomTool* last_stylus;
	WacomBackendWacomToolMap* tool_map;
	GranitePlaceholder* placeholder;
	GtkBox* main_box;
	GtkStack* stack;
	GtkStack* stylus_stack;
	GtkGestureStylus* stylus_gesture;
	WacomStylusView* stylus_view;
	WacomTabletView* tablet_view;
};

static gint WacomMainPage_private_offset;
static gpointer wacom_main_page_parent_class = NULL;

static void wacom_main_page_on_device_added (WacomMainPage* self,
                                      WacomBackendDevice* device);
static void wacom_main_page_add_known_device (WacomMainPage* self,
                                       WacomBackendDevice* d);
static void wacom_main_page_update_current_page (WacomMainPage* self);
static void wacom_main_page_on_device_removed (WacomMainPage* self,
                                        WacomBackendDevice* device);
static void wacom_main_page_on_stylus (WacomMainPage* self,
                                gdouble object,
                                gdouble p0);
static GObject * wacom_main_page_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _wacom_main_page_on_device_added_wacom_backend_device_manager_device_added (WacomBackendDeviceManager* _sender,
                                                                                 WacomBackendDevice* device,
                                                                                 gpointer self);
static void _wacom_main_page_on_device_removed_wacom_backend_device_manager_device_removed (WacomBackendDeviceManager* _sender,
                                                                                     WacomBackendDevice* device,
                                                                                     gpointer self);
static void _wacom_main_page_on_stylus_gtk_gesture_stylus_proximity (GtkGestureStylus* _sender,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self);
static void wacom_main_page_finalize (GObject * obj);
static GType wacom_main_page_get_type_once (void);

static inline gpointer
wacom_main_page_get_instance_private (WacomMainPage* self)
{
	return G_STRUCT_MEMBER_P (self, WacomMainPage_private_offset);
}

WacomMainPage*
wacom_main_page_construct (GType object_type)
{
	WacomMainPage * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("input-tablet");
	_tmp1_ = _tmp0_;
	self = (WacomMainPage*) g_object_new (object_type, "title", _ ("Wacom"), "icon", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

WacomMainPage*
wacom_main_page_new (void)
{
	return wacom_main_page_construct (WACOM_TYPE_MAIN_PAGE);
}

static void
wacom_main_page_on_device_added (WacomMainPage* self,
                                 WacomBackendDevice* device)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	wacom_main_page_add_known_device (self, device);
	wacom_main_page_update_current_page (self);
}

static void
wacom_main_page_on_device_removed (WacomMainPage* self,
                                   WacomBackendDevice* device)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	wacom_main_page_update_current_page (self);
}

static void
wacom_main_page_add_known_device (WacomMainPage* self,
                                  WacomBackendDevice* d)
{
	WacomBackendDeviceDeviceType _tmp0_;
	WacomBackendDeviceDeviceType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	WacomBackendDeviceDeviceType _tmp4_;
	WacomBackendDeviceDeviceType _tmp5_;
	GeeArrayList* tools = NULL;
	gboolean _tmp16_ = FALSE;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	_tmp0_ = wacom_backend_device_get_dev_type (d);
	_tmp1_ = _tmp0_;
	if (!((_tmp1_ & WACOM_BACKEND_DEVICE_DEVICE_TYPE_TABLET) == WACOM_BACKEND_DEVICE_DEVICE_TYPE_TABLET)) {
		return;
	}
	_tmp4_ = wacom_backend_device_get_dev_type (d);
	_tmp5_ = _tmp4_;
	if ((_tmp5_ & WACOM_BACKEND_DEVICE_DEVICE_TYPE_TOUCHSCREEN) == WACOM_BACKEND_DEVICE_DEVICE_TYPE_TOUCHSCREEN) {
		_tmp3_ = TRUE;
	} else {
		WacomBackendDeviceDeviceType _tmp6_;
		WacomBackendDeviceDeviceType _tmp7_;
		_tmp6_ = wacom_backend_device_get_dev_type (d);
		_tmp7_ = _tmp6_;
		_tmp3_ = (_tmp7_ & WACOM_BACKEND_DEVICE_DEVICE_TYPE_TOUCHPAD) == WACOM_BACKEND_DEVICE_DEVICE_TYPE_TOUCHPAD;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		WacomBackendDeviceDeviceType _tmp8_;
		WacomBackendDeviceDeviceType _tmp9_;
		_tmp8_ = wacom_backend_device_get_dev_type (d);
		_tmp9_ = _tmp8_;
		_tmp2_ = (_tmp9_ & WACOM_BACKEND_DEVICE_DEVICE_TYPE_PAD) == WACOM_BACKEND_DEVICE_DEVICE_TYPE_PAD;
	}
	if (_tmp2_) {
		return;
	}
	{
		GeeArrayList* _tmp10_ = NULL;
		WacomBackendWacomToolMap* _tmp11_;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		_tmp11_ = self->priv->tool_map;
		_tmp12_ = wacom_backend_wacom_tool_map_list_tools (_tmp11_, d, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == WACOM_EXCEPTION) {
				goto __catch0_wacom_exception;
			}
			_g_object_unref0 (tools);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (tools);
		tools = _tmp13_;
		_g_object_unref0 (_tmp10_);
	}
	goto __finally0;
	__catch0_wacom_exception:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("MainPage.vala:95: Failed to list tools: %s", _tmp15_);
		_g_error_free0 (e);
		_g_object_unref0 (tools);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (tools);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = tools;
	_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ > 0) {
		WacomStylusView* _tmp20_;
		GeeArrayList* _tmp21_;
		gpointer _tmp22_;
		WacomBackendWacomTool* _tmp23_;
		_tmp20_ = self->priv->stylus_view;
		_tmp21_ = tools;
		_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
		_tmp23_ = (WacomBackendWacomTool*) _tmp22_;
		_tmp16_ = wacom_stylus_view_is_stylus_supported (_tmp20_, _tmp23_);
		_g_object_unref0 (_tmp23_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		WacomStylusView* _tmp24_;
		GeeArrayList* _tmp25_;
		gpointer _tmp26_;
		WacomBackendWacomTool* _tmp27_;
		GtkStack* _tmp28_;
		WacomStylusView* _tmp29_;
		_tmp24_ = self->priv->stylus_view;
		_tmp25_ = tools;
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
		_tmp27_ = (WacomBackendWacomTool*) _tmp26_;
		wacom_stylus_view_set_device (_tmp24_, _tmp27_);
		_g_object_unref0 (_tmp27_);
		_tmp28_ = self->priv->stylus_stack;
		_tmp29_ = self->priv->stylus_view;
		gtk_stack_set_visible_child (_tmp28_, (GtkWidget*) _tmp29_);
	}
	_g_object_unref0 (tools);
}

static void
wacom_main_page_update_current_page (WacomMainPage* self)
{
	GtkStack* _tmp20_;
	GranitePlaceholder* _tmp21_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _device_list = NULL;
		WacomBackendDeviceManager* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _device_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _device_index = 0;
		_tmp0_ = self->priv->device_manager;
		_tmp1_ = wacom_backend_device_manager_list_devices (_tmp0_, WACOM_BACKEND_DEVICE_DEVICE_TYPE_TABLET);
		_device_list = _tmp1_;
		_tmp2_ = _device_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_device_size = _tmp4_;
		_device_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			WacomBackendDevice* device = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GtkStack* _tmp9_;
			GtkBox* _tmp10_;
			WacomTabletView* _tmp11_;
			WacomBackendDevice* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			WacomBackendDevice* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_device_index = _device_index + 1;
			_tmp5_ = _device_index;
			_tmp6_ = _device_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _device_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _device_index);
			device = (WacomBackendDevice*) _tmp8_;
			_tmp9_ = self->priv->stack;
			_tmp10_ = self->priv->main_box;
			gtk_stack_set_visible_child (_tmp9_, (GtkWidget*) _tmp10_);
			_tmp11_ = self->priv->tablet_view;
			_tmp12_ = device;
			_tmp13_ = wacom_backend_device_get_vendor_id (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = device;
			_tmp16_ = wacom_backend_device_get_product_id (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("%s:%s", _tmp14_, _tmp17_);
			_tmp19_ = _tmp18_;
			wacom_tablet_view_set_device_key (_tmp11_, _tmp19_);
			_g_free0 (_tmp19_);
			_g_object_unref0 (device);
			_g_object_unref0 (_device_list);
			return;
		}
		_g_object_unref0 (_device_list);
	}
	_tmp20_ = self->priv->stack;
	_tmp21_ = self->priv->placeholder;
	gtk_stack_set_visible_child (_tmp20_, (GtkWidget*) _tmp21_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
wacom_main_page_on_stylus (WacomMainPage* self,
                           gdouble object,
                           gdouble p0)
{
	GdkDeviceTool* tool = NULL;
	GtkGestureStylus* _tmp0_;
	GdkDeviceTool* _tmp1_;
	GdkDeviceTool* _tmp2_;
	GdkDeviceTool* _tmp3_;
	guint64 serial = 0ULL;
	GdkDeviceTool* _tmp4_;
	WacomBackendWacomTool* wacom_tool = NULL;
	WacomBackendWacomToolMap* _tmp5_;
	WacomTabletView* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	WacomBackendWacomTool* _tmp9_;
	WacomBackendWacomTool* _tmp10_;
	WacomBackendWacomTool* _tmp20_;
	WacomBackendWacomTool* _tmp21_;
	WacomBackendWacomTool* _tmp28_;
	WacomBackendWacomTool* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stylus_gesture;
	_tmp1_ = gtk_gesture_stylus_get_device_tool (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	tool = _tmp2_;
	_tmp3_ = tool;
	if (_tmp3_ == NULL) {
		g_critical ("MainPage.vala:121: DeviceTool not found");
		_g_object_unref0 (tool);
		return;
	}
	_tmp4_ = tool;
	serial = gdk_device_tool_get_serial (_tmp4_);
	_tmp5_ = self->priv->tool_map;
	_tmp6_ = self->priv->tablet_view;
	_tmp7_ = wacom_tablet_view_get_device_key (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = wacom_backend_wacom_tool_map_lookup_tool (_tmp5_, serial, _tmp8_);
	wacom_tool = _tmp9_;
	_tmp10_ = wacom_tool;
	if (_tmp10_ == NULL) {
		GdkDeviceTool* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		WacomBackendWacomTool* _tmp14_;
		WacomBackendWacomToolMap* _tmp15_;
		WacomTabletView* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		WacomBackendWacomTool* _tmp19_;
		_tmp11_ = tool;
		_tmp12_ = g_strdup_printf ("/org/gnome/desktop/peripherals/stylus/%llx/", serial);
		_tmp13_ = _tmp12_;
		_tmp14_ = wacom_backend_wacom_tool_new (serial, gdk_device_tool_get_hardware_id (_tmp11_), _tmp13_);
		_g_object_unref0 (wacom_tool);
		wacom_tool = _tmp14_;
		_g_free0 (_tmp13_);
		_tmp15_ = self->priv->tool_map;
		_tmp16_ = self->priv->tablet_view;
		_tmp17_ = wacom_tablet_view_get_device_key (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = wacom_tool;
		wacom_backend_wacom_tool_map_add_relation (_tmp15_, _tmp18_, _tmp19_);
	}
	_tmp20_ = wacom_tool;
	_tmp21_ = self->priv->last_stylus;
	if (_tmp20_ != _tmp21_) {
		WacomStylusView* _tmp22_;
		WacomBackendWacomTool* _tmp23_;
		_tmp22_ = self->priv->stylus_view;
		_tmp23_ = wacom_tool;
		if (wacom_stylus_view_is_stylus_supported (_tmp22_, _tmp23_)) {
			WacomStylusView* _tmp24_;
			WacomBackendWacomTool* _tmp25_;
			GtkStack* _tmp26_;
			WacomStylusView* _tmp27_;
			_tmp24_ = self->priv->stylus_view;
			_tmp25_ = wacom_tool;
			wacom_stylus_view_set_device (_tmp24_, _tmp25_);
			_tmp26_ = self->priv->stylus_stack;
			_tmp27_ = self->priv->stylus_view;
			gtk_stack_set_visible_child (_tmp26_, (GtkWidget*) _tmp27_);
		}
	}
	_tmp28_ = wacom_tool;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (self->priv->last_stylus);
	self->priv->last_stylus = _tmp29_;
	_g_object_unref0 (wacom_tool);
	_g_object_unref0 (tool);
}

static void
_wacom_main_page_on_device_added_wacom_backend_device_manager_device_added (WacomBackendDeviceManager* _sender,
                                                                            WacomBackendDevice* device,
                                                                            gpointer self)
{
	wacom_main_page_on_device_added ((WacomMainPage*) self, device);
}

static void
_wacom_main_page_on_device_removed_wacom_backend_device_manager_device_removed (WacomBackendDeviceManager* _sender,
                                                                                WacomBackendDevice* device,
                                                                                gpointer self)
{
	wacom_main_page_on_device_removed ((WacomMainPage*) self, device);
}

static void
_wacom_main_page_on_stylus_gtk_gesture_stylus_proximity (GtkGestureStylus* _sender,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self)
{
	wacom_main_page_on_stylus ((WacomMainPage*) self, x, y);
}

static GObject *
wacom_main_page_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WacomMainPage * self;
	WacomBackendWacomToolMap* _tmp0_;
	WacomBackendWacomToolMap* _tmp1_;
	gchar* _tmp2_;
	GranitePlaceholder* _tmp3_ = NULL;
	GranitePlaceholder* stylus_placeholder = NULL;
	gchar* _tmp4_;
	GranitePlaceholder* _tmp5_ = NULL;
	WacomTabletView* _tmp6_;
	WacomStylusView* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	GranitePlaceholder* _tmp10_;
	GtkStack* _tmp11_;
	WacomStylusView* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	WacomTabletView* _tmp15_;
	GtkBox* _tmp16_;
	GtkStack* _tmp17_;
	GtkStack* _tmp18_;
	GtkStack* _tmp19_;
	GtkBox* _tmp20_;
	GtkStack* _tmp21_;
	GranitePlaceholder* _tmp22_;
	GtkStack* _tmp23_;
	WacomBackendDeviceManager* _tmp24_;
	WacomBackendDeviceManager* _tmp25_;
	WacomBackendDeviceManager* _tmp26_;
	WacomBackendDeviceManager* _tmp27_;
	GtkGestureStylus* _tmp38_;
	GtkGestureStylus* _tmp39_;
	GtkGestureStylus* _tmp40_;
	GtkEventController* _tmp41_;
	parent_class = G_OBJECT_CLASS (wacom_main_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_TYPE_MAIN_PAGE, WacomMainPage);
	_tmp0_ = wacom_backend_wacom_tool_map_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->tool_map);
	self->priv->tool_map = _tmp1_;
	_tmp2_ = g_strdup (_ ("Please ensure your tablet is connected and switched on"));
	_tmp3_ = granite_placeholder_new (_ ("No Tablets Available"));
	granite_placeholder_set_description (_tmp3_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp3_;
	_tmp4_ = g_strdup (_ ("Move the stylus over this window"));
	_tmp5_ = granite_placeholder_new (_ ("No Stylus Detected"));
	granite_placeholder_set_description (_tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	stylus_placeholder = _tmp5_;
	_tmp6_ = wacom_tablet_view_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->tablet_view);
	self->priv->tablet_view = _tmp6_;
	_tmp7_ = wacom_stylus_view_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->stylus_view);
	self->priv->stylus_view = _tmp7_;
	_tmp8_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->stylus_stack);
	self->priv->stylus_stack = _tmp8_;
	_tmp9_ = self->priv->stylus_stack;
	_tmp10_ = stylus_placeholder;
	gtk_stack_add_child (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->stylus_stack;
	_tmp12_ = self->priv->stylus_view;
	gtk_stack_add_child (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = _tmp13_;
	_tmp14_ = self->priv->main_box;
	_tmp15_ = self->priv->tablet_view;
	gtk_box_append (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->main_box;
	_tmp17_ = self->priv->stylus_stack;
	gtk_box_append (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp18_;
	_tmp19_ = self->priv->stack;
	_tmp20_ = self->priv->main_box;
	gtk_stack_add_child (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->stack;
	_tmp22_ = self->priv->placeholder;
	gtk_stack_add_child (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->stack;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp23_);
	_tmp24_ = wacom_backend_device_manager_get_default ();
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->priv->device_manager);
	self->priv->device_manager = _tmp25_;
	_tmp26_ = self->priv->device_manager;
	g_signal_connect_object (_tmp26_, "device-added", (GCallback) _wacom_main_page_on_device_added_wacom_backend_device_manager_device_added, self, 0);
	_tmp27_ = self->priv->device_manager;
	g_signal_connect_object (_tmp27_, "device-removed", (GCallback) _wacom_main_page_on_device_removed_wacom_backend_device_manager_device_removed, self, 0);
	{
		GeeArrayList* _device_list = NULL;
		WacomBackendDeviceManager* _tmp28_;
		GeeArrayList* _tmp29_;
		gint _device_size = 0;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _device_index = 0;
		_tmp28_ = self->priv->device_manager;
		_tmp29_ = wacom_backend_device_manager_list_devices (_tmp28_, WACOM_BACKEND_DEVICE_DEVICE_TYPE_TABLET);
		_device_list = _tmp29_;
		_tmp30_ = _device_list;
		_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_device_size = _tmp32_;
		_device_index = -1;
		while (TRUE) {
			gint _tmp33_;
			gint _tmp34_;
			WacomBackendDevice* device = NULL;
			GeeArrayList* _tmp35_;
			gpointer _tmp36_;
			WacomBackendDevice* _tmp37_;
			_device_index = _device_index + 1;
			_tmp33_ = _device_index;
			_tmp34_ = _device_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _device_list;
			_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _device_index);
			device = (WacomBackendDevice*) _tmp36_;
			_tmp37_ = device;
			wacom_main_page_add_known_device (self, _tmp37_);
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_list);
	}
	_tmp38_ = (GtkGestureStylus*) gtk_gesture_stylus_new ();
	_g_object_unref0 (self->priv->stylus_gesture);
	self->priv->stylus_gesture = _tmp38_;
	_tmp39_ = self->priv->stylus_gesture;
	g_signal_connect_object (_tmp39_, "proximity", (GCallback) _wacom_main_page_on_stylus_gtk_gesture_stylus_proximity, self, 0);
	_tmp40_ = self->priv->stylus_gesture;
	_tmp41_ = _g_object_ref0 ((GtkEventController*) _tmp40_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp41_);
	wacom_main_page_update_current_page (self);
	_g_object_unref0 (stylus_placeholder);
	return obj;
}

static void
wacom_main_page_class_init (WacomMainPageClass * klass,
                            gpointer klass_data)
{
	wacom_main_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WacomMainPage_private_offset);
	G_OBJECT_CLASS (klass)->constructor = wacom_main_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = wacom_main_page_finalize;
}

static void
wacom_main_page_instance_init (WacomMainPage * self,
                               gpointer klass)
{
	self->priv = wacom_main_page_get_instance_private (self);
	self->priv->last_stylus = NULL;
}

static void
wacom_main_page_finalize (GObject * obj)
{
	WacomMainPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_TYPE_MAIN_PAGE, WacomMainPage);
	_g_object_unref0 (self->priv->device_manager);
	_g_object_unref0 (self->priv->last_stylus);
	_g_object_unref0 (self->priv->tool_map);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->stylus_stack);
	_g_object_unref0 (self->priv->stylus_gesture);
	_g_object_unref0 (self->priv->stylus_view);
	_g_object_unref0 (self->priv->tablet_view);
	G_OBJECT_CLASS (wacom_main_page_parent_class)->finalize (obj);
}

static GType
wacom_main_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WacomMainPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wacom_main_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WacomMainPage), 0, (GInstanceInitFunc) wacom_main_page_instance_init, NULL };
	GType wacom_main_page_type_id;
	wacom_main_page_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "WacomMainPage", &g_define_type_info, 0);
	WacomMainPage_private_offset = g_type_add_instance_private (wacom_main_page_type_id, sizeof (WacomMainPagePrivate));
	return wacom_main_page_type_id;
}

GType
wacom_main_page_get_type (void)
{
	static volatile gsize wacom_main_page_type_id__once = 0;
	if (g_once_init_enter (&wacom_main_page_type_id__once)) {
		GType wacom_main_page_type_id;
		wacom_main_page_type_id = wacom_main_page_get_type_once ();
		g_once_init_leave (&wacom_main_page_type_id__once, wacom_main_page_type_id);
	}
	return wacom_main_page_type_id__once;
}

