/* UserSettingsView.c generated by valac 0.56.17, the Vala compiler
 * generated from UserSettingsView.vala, do not modify */

/*
* Copyright (c) 2014-2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "useraccounts.h"
#include <act/act.h>
#include <gtk/gtk.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <polkit/polkit.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <libgnome-desktop/gnome-languages.h>
#include "run-passwd.h"

#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING _ ("You do not have permission to change this")
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_CURRENT_USER_STRING _ ("You cannot change this for the currently active user")
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_LAST_ADMIN_STRING _ ("You cannot remove the last administrator's privileges")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_0_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_user_accounts_widgets_user_settings_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NUM_PROPERTIES];
#define _switchboard_plug_user_accounts_user_utils_unref0(var) ((var == NULL) ? NULL : (var = (switchboard_plug_user_accounts_user_utils_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_REMOVE_USER_SIGNAL,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NUM_SIGNALS
};
static guint switchboard_plug_user_accounts_widgets_user_settings_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NUM_SIGNALS] = {0};

struct _SwitchboardPlugUserAccountsWidgetsUserSettingsViewPrivate {
	ActUser* _user;
	SwitchboardPlugUserAccountsUserUtils* utils;
	SwitchboardPlugUserAccountsDeltaUser* delta_user;
	GtkListStore* language_store;
	GtkListStore* region_store;
	AdwAvatar* avatar;
	GraniteHeaderLabel* autologin_label;
	GraniteHeaderLabel* lang_label;
	GraniteHeaderLabel* user_type_label;
	GtkEntry* full_name_entry;
	GtkButton* password_button;
	GtkButton* enable_user_button;
	GtkComboBoxText* user_type_dropdown;
	GtkComboBox* language_dropdown;
	GtkComboBox* region_box;
	GtkButton* language_button;
	GtkSwitch* autologin_switch;
	GtkInfoBar* infobar;
	GtkImage* full_name_lock;
	GeeHashMap* default_regions;
};

struct _Block4Data {
	int _ref_count_;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
	gchar* language;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GtkTreeIter* active_iter;
};

struct _Block6Data {
	int _ref_count_;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
	GtkRevealer* region_revealer;
};

static gint SwitchboardPlugUserAccountsWidgetsUserSettingsView_private_offset;
static gpointer switchboard_plug_user_accounts_widgets_user_settings_view_parent_class = NULL;

static void switchboard_plug_user_accounts_widgets_user_settings_view_update_permission (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void switchboard_plug_user_accounts_widgets_user_settings_view_update_ui (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static gboolean _act_user_account_type_equal (const ActUserAccountType * s1,
                                       const ActUserAccountType * s2);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean ___lambda6_ (Block5Data* _data5_,
                      GtkTreeModel* model,
                      GtkTreePath* path,
                      GtkTreeIter* iter);
static gboolean ____lambda6__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                   GtkTreePath* path,
                                                   GtkTreeIter* iter,
                                                   gpointer self);
static void switchboard_plug_user_accounts_widgets_user_settings_view_change_lock (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void switchboard_plug_user_accounts_widgets_user_settings_view_change_password (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                                ActUserPasswordMode mode,
                                                                                const gchar* new_password);
static void _____lambda7_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                     PasswdHandler* h,
                    GError* e);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void ______lambda7__passwd_passwd_callback ( PasswdHandler* handler,
                                            GError* e,
                                            gpointer self);
static GObject * switchboard_plug_user_accounts_widgets_user_settings_view_constructor (GType type,
                                                                                 guint n_construct_properties,
                                                                                 GObjectConstructParam * construct_properties);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda10_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda10__gtk_entry_activate (GtkEntry* _sender,
                                                                                                 gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda11_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda11__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                    gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _switchboard_plug_user_accounts_widgets_user_settings_view____lambda12_ (Block6Data* _data6_);
static void __switchboard_plug_user_accounts_widgets_user_settings_view____lambda12__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                     gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view____lambda13_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view____lambda13__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                     gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda14_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda14__g_object_notify (GObject* _sender,
                                                                                              GParamSpec* pspec,
                                                                                              gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda15_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_change_password_switchboard_plug_user_accounts_change_password_dialog_request_password_change (SwitchboardPlugUserAccountsChangePasswordDialog* _sender,
                                                                                                                                                               ActUserPasswordMode mode,
                                                                                                                                                               const gchar* new_password,
                                                                                                                                                               gpointer self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda15__gtk_button_clicked (GtkButton* _sender,
                                                                                                 gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_change_lock_gtk_button_clicked (GtkButton* _sender,
                                                                                                gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda22_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda22__gtk_button_clicked (GtkButton* _sender,
                                                                                                 gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_g_object_notify (GObject* _sender,
                                                                                                   GParamSpec* pspec,
                                                                                                   gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_update_ui_act_user_changed (ActUser* _sender,
                                                                                            gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_act_user_changed (ActUser* _sender,
                                                                                                    gpointer self);
static void switchboard_plug_user_accounts_widgets_user_settings_view_finalize (GObject * obj);
static GType switchboard_plug_user_accounts_widgets_user_settings_view_get_type_once (void);
static void _vala_switchboard_plug_user_accounts_widgets_user_settings_view_get_property (GObject * object,
                                                                                   guint property_id,
                                                                                   GValue * value,
                                                                                   GParamSpec * pspec);
static void _vala_switchboard_plug_user_accounts_widgets_user_settings_view_set_property (GObject * object,
                                                                                   guint property_id,
                                                                                   const GValue * value,
                                                                                   GParamSpec * pspec);

static inline gpointer
switchboard_plug_user_accounts_widgets_user_settings_view_get_instance_private (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugUserAccountsWidgetsUserSettingsView_private_offset);
}

SwitchboardPlugUserAccountsWidgetsUserSettingsView*
switchboard_plug_user_accounts_widgets_user_settings_view_construct (GType object_type,
                                                                     ActUser* user)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	self = (SwitchboardPlugUserAccountsWidgetsUserSettingsView*) g_object_new (object_type, "user", user, NULL);
	return self;
}

SwitchboardPlugUserAccountsWidgetsUserSettingsView*
switchboard_plug_user_accounts_widgets_user_settings_view_new (ActUser* user)
{
	return switchboard_plug_user_accounts_widgets_user_settings_view_construct (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, user);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_update_permission (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	gboolean allowed = FALSE;
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean current_user = FALSE;
	ActUser* _tmp5_;
	ActUser* _tmp6_;
	gboolean user_locked = FALSE;
	ActUser* _tmp7_;
	gboolean last_admin = FALSE;
	ActUser* _tmp8_;
	GtkInfoBar* _tmp9_;
	GraniteHeaderLabel* _tmp15_;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	allowed = _tmp4_;
	_tmp5_ = switchboard_plug_user_accounts_get_current_user ();
	_tmp6_ = self->priv->_user;
	current_user = _tmp5_ == _tmp6_;
	_tmp7_ = self->priv->_user;
	user_locked = act_user_get_locked (_tmp7_);
	_tmp8_ = self->priv->_user;
	last_admin = switchboard_plug_user_accounts_is_last_admin (_tmp8_);
	_tmp9_ = self->priv->infobar;
	gtk_info_bar_set_revealed (_tmp9_, !allowed);
	if (!allowed) {
		GtkComboBoxText* _tmp10_;
		GtkButton* _tmp11_;
		GtkSwitch* _tmp12_;
		GraniteHeaderLabel* _tmp13_;
		GraniteHeaderLabel* _tmp14_;
		_tmp10_ = self->priv->user_type_dropdown;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
		_tmp11_ = self->priv->password_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
		_tmp12_ = self->priv->autologin_switch;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
		_tmp13_ = self->priv->autologin_label;
		granite_header_label_set_secondary_text (_tmp13_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
		_tmp14_ = self->priv->user_type_label;
		granite_header_label_set_secondary_text (_tmp14_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
	}
	_tmp15_ = self->priv->lang_label;
	granite_header_label_set_secondary_text (_tmp15_, NULL);
	if (current_user) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = allowed;
	}
	if (_tmp16_) {
		GtkEntry* _tmp17_;
		GtkImage* _tmp18_;
		GtkButton* _tmp19_;
		_tmp17_ = self->priv->full_name_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, TRUE);
		_tmp18_ = self->priv->full_name_lock;
		gtk_widget_set_opacity ((GtkWidget*) _tmp18_, (gdouble) 0);
		_tmp19_ = self->priv->password_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, !user_locked);
		if (allowed) {
			gboolean _tmp24_ = FALSE;
			if (!user_locked) {
				GtkSwitch* _tmp20_;
				GraniteHeaderLabel* _tmp21_;
				_tmp20_ = self->priv->autologin_switch;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, TRUE);
				_tmp21_ = self->priv->autologin_label;
				granite_header_label_set_secondary_text (_tmp21_, NULL);
			} else {
				GtkSwitch* _tmp22_;
				GraniteHeaderLabel* _tmp23_;
				_tmp22_ = self->priv->autologin_switch;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, FALSE);
				_tmp23_ = self->priv->autologin_label;
				granite_header_label_set_secondary_text (_tmp23_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
			}
			if (!last_admin) {
				_tmp24_ = !current_user;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GtkComboBoxText* _tmp25_;
				GraniteHeaderLabel* _tmp26_;
				_tmp25_ = self->priv->user_type_dropdown;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, TRUE);
				_tmp26_ = self->priv->user_type_label;
				granite_header_label_set_secondary_text (_tmp26_, NULL);
			}
		}
		if (!current_user) {
			GtkComboBox* _tmp27_;
			GtkComboBox* _tmp28_;
			_tmp27_ = self->priv->language_dropdown;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp27_, TRUE);
			_tmp28_ = self->priv->region_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp28_, TRUE);
		}
	} else {
		GtkEntry* _tmp29_;
		_tmp29_ = self->priv->full_name_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp29_, FALSE);
		if (!current_user) {
			GraniteHeaderLabel* _tmp30_;
			GtkComboBox* _tmp31_;
			GtkComboBox* _tmp32_;
			_tmp30_ = self->priv->lang_label;
			granite_header_label_set_secondary_text (_tmp30_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
			_tmp31_ = self->priv->language_dropdown;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, FALSE);
			_tmp32_ = self->priv->region_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, FALSE);
		}
	}
}

static gboolean
_act_user_account_type_equal (const ActUserAccountType * s1,
                              const ActUserAccountType * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_update_ui (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	SwitchboardPlugUserAccountsDeltaUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ActUser* _tmp3_;
	const gchar* _tmp4_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp10_;
	ActUserAccountType* _tmp11_;
	ActUserAccountType* _tmp12_;
	ActUser* _tmp13_;
	ActUserAccountType _tmp14_;
	gboolean user_automatic_login = FALSE;
	ActUser* _tmp15_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean user_locked = FALSE;
	ActUser* _tmp29_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	ActUser* _tmp37_;
	const gchar* _tmp38_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp39_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->delta_user;
	_tmp1_ = switchboard_plug_user_accounts_delta_user_get_real_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_user;
	_tmp4_ = act_user_get_real_name (_tmp3_);
	if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
		switchboard_plug_user_accounts_widgets_user_settings_view_update_real_name (self);
	}
	{
		GdkTexture* _tmp5_ = NULL;
		ActUser* _tmp6_;
		const gchar* _tmp7_;
		GdkTexture* _tmp8_;
		AdwAvatar* _tmp9_;
		_tmp6_ = self->priv->_user;
		_tmp7_ = act_user_get_icon_file (_tmp6_);
		_tmp8_ = gdk_texture_new_from_filename (_tmp7_, &_inner_error0_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = self->priv->avatar;
		adw_avatar_set_custom_image (_tmp9_, (GdkPaintable*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_critical ("UserSettingsView.vala:400: couldn't load avatar");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp10_ = self->priv->delta_user;
	_tmp11_ = switchboard_plug_user_accounts_delta_user_get_account_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_user;
	_tmp14_ = act_user_get_account_type (_tmp13_);
	if (_act_user_account_type_equal (_tmp12_, &_tmp14_) != TRUE) {
		switchboard_plug_user_accounts_widgets_user_settings_view_update_account_type (self);
	}
	_tmp15_ = self->priv->_user;
	user_automatic_login = act_user_get_automatic_login (_tmp15_);
	_tmp16_ = self->priv->delta_user;
	_tmp17_ = switchboard_plug_user_accounts_delta_user_get_automatic_login (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != user_automatic_login) {
		gboolean _tmp19_ = FALSE;
		if (user_automatic_login) {
			GtkSwitch* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			_tmp20_ = self->priv->autologin_switch;
			_tmp21_ = gtk_switch_get_active (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp19_ = !_tmp22_;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GtkSwitch* _tmp23_;
			_tmp23_ = self->priv->autologin_switch;
			gtk_switch_set_active (_tmp23_, TRUE);
		} else {
			gboolean _tmp24_ = FALSE;
			if (!user_automatic_login) {
				GtkSwitch* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				_tmp25_ = self->priv->autologin_switch;
				_tmp26_ = gtk_switch_get_active (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp24_ = _tmp27_;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GtkSwitch* _tmp28_;
				_tmp28_ = self->priv->autologin_switch;
				gtk_switch_set_active (_tmp28_, FALSE);
			}
		}
	}
	_tmp29_ = self->priv->_user;
	user_locked = act_user_get_locked (_tmp29_);
	if (user_locked) {
		GtkButton* _tmp30_;
		GtkButton* _tmp31_;
		_tmp30_ = self->priv->enable_user_button;
		gtk_button_set_label (_tmp30_, _ ("Enable Account"));
		_tmp31_ = self->priv->enable_user_button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp31_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	} else {
		GtkButton* _tmp32_;
		GtkButton* _tmp33_;
		_tmp32_ = self->priv->enable_user_button;
		gtk_button_set_label (_tmp32_, _ ("Disable Account"));
		_tmp33_ = self->priv->enable_user_button;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp33_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	}
	_tmp34_ = self->priv->delta_user;
	_tmp35_ = switchboard_plug_user_accounts_delta_user_get_language (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = self->priv->_user;
	_tmp38_ = act_user_get_language (_tmp37_);
	if (g_strcmp0 (_tmp36_, _tmp38_) != 0) {
		switchboard_plug_user_accounts_widgets_user_settings_view_update_language (self);
	}
	_tmp39_ = self->priv->delta_user;
	switchboard_plug_user_accounts_delta_user_update (_tmp39_);
}

void
switchboard_plug_user_accounts_widgets_user_settings_view_update_real_name (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	GtkEntry* _tmp0_;
	ActUser* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->full_name_entry;
	_tmp1_ = self->priv->_user;
	_tmp2_ = act_user_get_real_name (_tmp1_);
	gtk_editable_set_text ((GtkEditable*) _tmp0_, _tmp2_);
}

void
switchboard_plug_user_accounts_widgets_user_settings_view_update_account_type (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	ActUser* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_user;
	if (act_user_get_account_type (_tmp0_) == ACT_USER_ACCOUNT_TYPE_ADMINISTRATOR) {
		GtkComboBoxText* _tmp1_;
		_tmp1_ = self->priv->user_type_dropdown;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp1_, 1);
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->user_type_dropdown;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp2_, 0);
	}
}

void
switchboard_plug_user_accounts_widgets_user_settings_view_update_language (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	gchar* user_lang = NULL;
	ActUser* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar* user_lang_code = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gboolean _tmp14_;
	ActUser* _tmp16_;
	ActUser* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_user;
	_tmp1_ = act_user_get_language (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	user_lang = _tmp2_;
	_tmp4_ = user_lang;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = user_lang;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == 0;
	}
	if (_tmp3_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp11_;
		_tmp9_ = switchboard_plug_user_accounts_get_system_locale ();
		_tmp8_ = _tmp9_;
		if (_tmp8_ == NULL) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("en_US.UTF-8");
			_g_free0 (_tmp8_);
			_tmp8_ = _tmp10_;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (user_lang);
		user_lang = _tmp11_;
		_g_free0 (_tmp8_);
	}
	_tmp12_ = user_lang;
	_tmp14_ = gnome_parse_locale (_tmp12_, &_tmp13_, NULL, NULL, NULL);
	_g_free0 (user_lang_code);
	user_lang_code = _tmp13_;
	if (!_tmp14_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("en");
		_g_free0 (user_lang_code);
		user_lang_code = _tmp15_;
	}
	_tmp16_ = self->priv->_user;
	_tmp17_ = switchboard_plug_user_accounts_get_current_user ();
	if (_tmp16_ != _tmp17_) {
		GeeArrayList* languages = NULL;
		GeeArrayList* _tmp18_;
		GtkListStore* _tmp19_;
		GtkTreeIter iter = {0};
		GtkComboBox* _tmp20_;
		GtkListStore* _tmp21_;
		_tmp18_ = switchboard_plug_user_accounts_get_languages ();
		languages = _tmp18_;
		_tmp19_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
		_g_object_unref0 (self->priv->language_store);
		self->priv->language_store = _tmp19_;
		_tmp20_ = self->priv->language_dropdown;
		_tmp21_ = self->priv->language_store;
		gtk_combo_box_set_model (_tmp20_, (GtkTreeModel*) _tmp21_);
		{
			GeeArrayList* _language_list = NULL;
			GeeArrayList* _tmp22_;
			gint _language_size = 0;
			GeeArrayList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _language_index = 0;
			_tmp22_ = languages;
			_language_list = _tmp22_;
			_tmp23_ = _language_list;
			_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_language_size = _tmp25_;
			_language_index = -1;
			while (TRUE) {
				gint _tmp26_;
				gint _tmp27_;
				gchar* language = NULL;
				GeeArrayList* _tmp28_;
				gpointer _tmp29_;
				GtkListStore* _tmp30_;
				GtkTreeIter _tmp31_ = {0};
				GtkListStore* _tmp32_;
				GtkTreeIter _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				_language_index = _language_index + 1;
				_tmp26_ = _language_index;
				_tmp27_ = _language_size;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = _language_list;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _language_index);
				language = (gchar*) _tmp29_;
				_tmp30_ = self->priv->language_store;
				gtk_list_store_insert (_tmp30_, &_tmp31_, 0);
				iter = _tmp31_;
				_tmp32_ = self->priv->language_store;
				_tmp33_ = iter;
				_tmp34_ = language;
				_tmp35_ = language;
				_tmp36_ = gnome_get_language_from_code (_tmp35_, NULL);
				_tmp37_ = _tmp36_;
				gtk_list_store_set (_tmp32_, &_tmp33_, 0, _tmp34_, 1, _tmp37_, -1);
				_g_free0 (_tmp37_);
				_tmp38_ = user_lang_code;
				_tmp39_ = language;
				if (g_strcmp0 (_tmp38_, _tmp39_) == 0) {
					GtkComboBox* _tmp40_;
					GtkTreeIter _tmp41_;
					_tmp40_ = self->priv->language_dropdown;
					_tmp41_ = iter;
					gtk_combo_box_set_active_iter (_tmp40_, &_tmp41_);
				}
				_g_free0 (language);
			}
		}
		_g_object_unref0 (languages);
	} else {
		gchar* language = NULL;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		GtkButton* _tmp44_;
		const gchar* _tmp45_;
		_tmp42_ = user_lang_code;
		_tmp43_ = gnome_get_language_from_code (_tmp42_, NULL);
		language = _tmp43_;
		_tmp44_ = self->priv->language_button;
		_tmp45_ = language;
		gtk_button_set_label (_tmp44_, _tmp45_);
		_g_free0 (language);
	}
	_g_free0 (user_lang_code);
	_g_free0 (user_lang);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
		self = _data4_->self;
		_g_free0 (_data4_->language);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
		self = _data5_->_data4_->self;
		__vala_GtkTreeIter_free0 (_data5_->active_iter);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
___lambda6_ (Block5Data* _data5_,
             GtkTreeModel* model,
             GtkTreePath* path,
             GtkTreeIter* iter)
{
	Block4Data* _data4_;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
	GValue cell = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp5_;
	gboolean result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->region_store;
	_tmp1_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 0, &_tmp2_);
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	cell = _tmp2_;
	_tmp5_ = self->priv->default_regions;
	if (_tmp5_ != NULL) {
		GeeHashMap* _tmp6_;
		_tmp6_ = self->priv->default_regions;
		_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _data4_->language);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GeeHashMap* _tmp7_;
		gpointer _tmp8_;
		gchar* _tmp9_;
		GValue _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp7_ = self->priv->default_regions;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _data4_->language);
		_tmp9_ = (gchar*) _tmp8_;
		_tmp10_ = cell;
		_tmp11_ = g_strdup_printf ("%s_%s", _data4_->language, g_value_get_string (&_tmp10_));
		_tmp12_ = _tmp11_;
		_tmp3_ = g_strcmp0 (_tmp9_, _tmp12_) == 0;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkTreeIter _tmp13_;
		GtkTreeIter* _tmp14_;
		_tmp13_ = *iter;
		_tmp14_ = __vala_GtkTreeIter_copy0 (&_tmp13_);
		__vala_GtkTreeIter_free0 (_data5_->active_iter);
		_data5_->active_iter = _tmp14_;
	}
	result = FALSE;
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	return result;
}

static gboolean
____lambda6__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                          GtkTreePath* path,
                                          GtkTreeIter* iter,
                                          gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self, model, path, iter);
	return result;
}

void
switchboard_plug_user_accounts_widgets_user_settings_view_update_region (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                         const gchar* language)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	GtkTreeIter* iter = NULL;
	GeeArrayList* regions = NULL;
	GeeArrayList* _tmp11_;
	GtkListStore* _tmp12_;
	gboolean iter_set = FALSE;
	GtkComboBox* _tmp13_;
	GtkListStore* _tmp14_;
	gchar* user_lang = NULL;
	ActUser* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gchar* user_region_code = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_strdup (language);
	_g_free0 (_data4_->language);
	_data4_->language = _tmp0_;
	if (_data4_->language == NULL) {
		GValue cell = {0};
		GtkComboBox* _tmp1_;
		GtkTreeIter _tmp2_ = {0};
		GtkTreeIter _tmp3_;
		GtkTreeIter* _tmp4_;
		GtkListStore* _tmp5_;
		GtkTreeIter* _tmp6_;
		GtkTreeIter _tmp7_;
		GValue _tmp8_ = {0};
		GValue _tmp9_;
		gchar* _tmp10_;
		_tmp1_ = self->priv->language_dropdown;
		gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
		__vala_GtkTreeIter_free0 (iter);
		_tmp3_ = _tmp2_;
		_tmp4_ = __vala_GtkTreeIter_copy0 (&_tmp3_);
		iter = _tmp4_;
		_tmp5_ = self->priv->language_store;
		_tmp6_ = iter;
		_tmp7_ = *_tmp6_;
		gtk_tree_model_get_value ((GtkTreeModel*) _tmp5_, &_tmp7_, 0, &_tmp8_);
		G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
		cell = _tmp8_;
		_tmp9_ = cell;
		_tmp10_ = g_strdup (g_value_get_string (&_tmp9_));
		_g_free0 (_data4_->language);
		_data4_->language = _tmp10_;
		G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	}
	_tmp11_ = switchboard_plug_user_accounts_get_regions (_data4_->language);
	regions = _tmp11_;
	_tmp12_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->region_store);
	self->priv->region_store = _tmp12_;
	iter_set = FALSE;
	_tmp13_ = self->priv->region_box;
	_tmp14_ = self->priv->region_store;
	gtk_combo_box_set_model (_tmp13_, (GtkTreeModel*) _tmp14_);
	_tmp15_ = self->priv->_user;
	_tmp16_ = act_user_get_language (_tmp15_);
	_tmp17_ = g_strdup (_tmp16_);
	user_lang = _tmp17_;
	_tmp19_ = user_lang;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp20_ = user_lang;
		_tmp21_ = strlen (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_ == 0;
	}
	if (_tmp18_) {
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp26_;
		_tmp24_ = switchboard_plug_user_accounts_get_system_locale ();
		_tmp23_ = _tmp24_;
		if (_tmp23_ == NULL) {
			gchar* _tmp25_;
			_tmp25_ = g_strdup ("en_US.UTF-8");
			_g_free0 (_tmp23_);
			_tmp23_ = _tmp25_;
		}
		_tmp26_ = _tmp23_;
		_tmp23_ = NULL;
		_g_free0 (user_lang);
		user_lang = _tmp26_;
		_g_free0 (_tmp23_);
	}
	_tmp27_ = user_lang;
	_tmp29_ = gnome_parse_locale (_tmp27_, NULL, &_tmp28_, NULL, NULL);
	_g_free0 (user_region_code);
	user_region_code = _tmp28_;
	if (!_tmp29_) {
		gchar* _tmp30_;
		_tmp30_ = g_strdup ("US");
		_g_free0 (user_region_code);
		user_region_code = _tmp30_;
	}
	{
		GeeArrayList* _region_list = NULL;
		GeeArrayList* _tmp31_;
		gint _region_size = 0;
		GeeArrayList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _region_index = 0;
		_tmp31_ = regions;
		_region_list = _tmp31_;
		_tmp32_ = _region_list;
		_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_region_size = _tmp34_;
		_region_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gchar* region = NULL;
			GeeArrayList* _tmp37_;
			gpointer _tmp38_;
			GtkListStore* _tmp39_;
			GtkTreeIter _tmp40_ = {0};
			GtkTreeIter _tmp41_;
			GtkTreeIter* _tmp42_;
			GtkListStore* _tmp43_;
			GtkTreeIter* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			GtkTreeIter _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_region_index = _region_index + 1;
			_tmp35_ = _region_index;
			_tmp36_ = _region_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _region_list;
			_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _region_index);
			region = (gchar*) _tmp38_;
			_tmp39_ = self->priv->region_store;
			gtk_list_store_insert (_tmp39_, &_tmp40_, 0);
			__vala_GtkTreeIter_free0 (iter);
			_tmp41_ = _tmp40_;
			_tmp42_ = __vala_GtkTreeIter_copy0 (&_tmp41_);
			iter = _tmp42_;
			_tmp43_ = self->priv->region_store;
			_tmp44_ = iter;
			_tmp45_ = region;
			_tmp46_ = region;
			_tmp47_ = gnome_get_country_from_code (_tmp46_, NULL);
			_tmp48_ = _tmp47_;
			_tmp49_ = *_tmp44_;
			gtk_list_store_set (_tmp43_, &_tmp49_, 0, _tmp45_, 1, _tmp48_, -1);
			_g_free0 (_tmp48_);
			_tmp50_ = user_region_code;
			_tmp51_ = region;
			if (g_strcmp0 (_tmp50_, _tmp51_) == 0) {
				GtkComboBox* _tmp52_;
				GtkTreeIter* _tmp53_;
				_tmp52_ = self->priv->region_box;
				_tmp53_ = iter;
				gtk_combo_box_set_active_iter (_tmp52_, _tmp53_);
				iter_set = TRUE;
			}
			_g_free0 (region);
		}
	}
	if (!iter_set) {
		Block5Data* _data5_;
		GtkTreeModelForeachFunc check_region_store = NULL;
		gpointer check_region_store_target;
		GDestroyNotify check_region_store_target_destroy_notify;
		GtkListStore* _tmp54_;
		GtkTreeModelForeachFunc _tmp55_;
		gpointer _tmp55__target;
		GtkTreeIter* _tmp56_;
		GtkComboBox* _tmp61_;
		GtkTreeIter* _tmp62_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		_data5_->active_iter = NULL;
		check_region_store = ____lambda6__gtk_tree_model_foreach_func;
		check_region_store_target = block5_data_ref (_data5_);
		check_region_store_target_destroy_notify = block5_data_unref;
		_tmp54_ = self->priv->region_store;
		_tmp55_ = check_region_store;
		_tmp55__target = check_region_store_target;
		gtk_tree_model_foreach ((GtkTreeModel*) _tmp54_, _tmp55_, _tmp55__target);
		_tmp56_ = _data5_->active_iter;
		if (_tmp56_ == NULL) {
			GtkListStore* _tmp57_;
			GtkTreeIter _tmp58_ = {0};
			GtkTreeIter _tmp59_;
			GtkTreeIter* _tmp60_;
			_tmp57_ = self->priv->region_store;
			gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp57_, &_tmp58_);
			__vala_GtkTreeIter_free0 (_data5_->active_iter);
			_tmp59_ = _tmp58_;
			_tmp60_ = __vala_GtkTreeIter_copy0 (&_tmp59_);
			_data5_->active_iter = _tmp60_;
		}
		_tmp61_ = self->priv->region_box;
		_tmp62_ = _data5_->active_iter;
		gtk_combo_box_set_active_iter (_tmp61_, _tmp62_);
		(check_region_store_target_destroy_notify == NULL) ? NULL : (check_region_store_target_destroy_notify (check_region_store_target), NULL);
		check_region_store = NULL;
		check_region_store_target = NULL;
		check_region_store_target_destroy_notify = NULL;
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	_g_free0 (user_region_code);
	_g_free0 (user_lang);
	_g_object_unref0 (regions);
	__vala_GtkTreeIter_free0 (iter);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_change_lock (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	PolkitPermission* permission = NULL;
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean user_locked = FALSE;
	ActUser* _tmp7_;
	ActUser* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	permission = _tmp0_;
	_tmp1_ = permission;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		{
			PolkitPermission* _tmp4_;
			_tmp4_ = permission;
			g_permission_acquire ((GPermission*) _tmp4_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_critical ("UserSettingsView.vala:543: %s", _tmp6_);
			_g_error_free0 (e);
			_g_object_unref0 (permission);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (permission);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = self->priv->_user;
	user_locked = act_user_get_locked (_tmp7_);
	if (user_locked) {
		ActUser* _tmp8_;
		_tmp8_ = self->priv->_user;
		act_user_set_password_mode (_tmp8_, ACT_USER_PASSWORD_MODE_REGULAR);
	} else {
		ActUser* _tmp9_;
		_tmp9_ = self->priv->_user;
		act_user_set_automatic_login (_tmp9_, FALSE);
	}
	_tmp10_ = self->priv->_user;
	act_user_set_locked (_tmp10_, !user_locked);
	_g_object_unref0 (permission);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
_____lambda7_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                PasswdHandler* h,
               GError* e)
{
	g_return_if_fail (h != NULL);
	if (e != NULL) {
		GraniteMessageDialog* dialog = NULL;
		ActUser* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		GThemedIcon* _tmp5_;
		GThemedIcon* _tmp6_;
		GThemedIcon* _tmp7_;
		GtkRoot* _tmp8_;
		GtkWindow* _tmp9_;
		GraniteMessageDialog* _tmp10_ = NULL;
		GraniteMessageDialog* _tmp11_;
		GraniteMessageDialog* _tmp12_;
		GraniteMessageDialog* _tmp13_;
		GraniteMessageDialog* _tmp14_;
		_tmp0_ = self->priv->_user;
		_tmp1_ = act_user_get_real_name (_tmp0_);
		_tmp2_ = g_strdup_printf (_ ("Unable to change the password for %s"), _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = e->message;
		_tmp5_ = (GThemedIcon*) g_themed_icon_new ("dialog-password");
		_tmp6_ = _tmp5_;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp8_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow));
		_tmp10_ = granite_message_dialog_new (_tmp3_, _tmp4_, (GIcon*) _tmp6_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp10_, (GIcon*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		gtk_window_set_transient_for ((GtkWindow*) _tmp10_, _tmp9_);
		_g_object_unref0 (_tmp9_);
		g_object_ref_sink (_tmp10_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp6_);
		_g_free0 (_tmp3_);
		dialog = _tmp11_;
		_tmp12_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp12_);
		_tmp13_ = dialog;
		_tmp14_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp14_, 0);
		_g_object_unref0 (dialog);
	} else {
		ActUser* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = self->priv->_user;
		_tmp16_ = act_user_get_user_name (_tmp15_);
		_tmp17_ = g_strdup_printf ("Setting new password for %s (user context)", _tmp16_);
		_tmp18_ = _tmp17_;
		g_debug ("UserSettingsView.vala:594: %s", _tmp18_);
		_g_free0 (_tmp18_);
	}
}

static void
______lambda7__passwd_passwd_callback ( PasswdHandler* handler,
                                       GError* e,
                                       gpointer self)
{
	_____lambda7_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self, handler, e);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_change_password (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                           ActUserPasswordMode mode,
                                                                           const gchar* new_password)
{
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		switch (mode) {
			case ACT_USER_PASSWORD_MODE_REGULAR:
			{
				if (new_password != NULL) {
					ActUser* _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					ActUser* _tmp9_;
					_tmp5_ = self->priv->_user;
					_tmp6_ = act_user_get_user_name (_tmp5_);
					_tmp7_ = g_strdup_printf ("Setting new password for %s", _tmp6_);
					_tmp8_ = _tmp7_;
					g_debug ("UserSettingsView.vala:563: %s", _tmp8_);
					_g_free0 (_tmp8_);
					_tmp9_ = self->priv->_user;
					act_user_set_password (_tmp9_, new_password, "");
				}
				break;
			}
			case ACT_USER_PASSWORD_MODE_NONE:
			{
				ActUser* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				ActUser* _tmp14_;
				_tmp10_ = self->priv->_user;
				_tmp11_ = act_user_get_user_name (_tmp10_);
				_tmp12_ = g_strdup_printf ("Setting no password for %s", _tmp11_);
				_tmp13_ = _tmp12_;
				g_debug ("UserSettingsView.vala:568: %s", _tmp13_);
				_g_free0 (_tmp13_);
				_tmp14_ = self->priv->_user;
				act_user_set_password_mode (_tmp14_, ACT_USER_PASSWORD_MODE_NONE);
				break;
			}
			case ACT_USER_PASSWORD_MODE_SET_AT_LOGIN:
			{
				ActUser* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				ActUser* _tmp19_;
				_tmp15_ = self->priv->_user;
				_tmp16_ = act_user_get_user_name (_tmp15_);
				_tmp17_ = g_strdup_printf ("Setting password mode to SET_AT_LOGIN for %s", _tmp16_);
				_tmp18_ = _tmp17_;
				g_debug ("UserSettingsView.vala:572: %s", _tmp18_);
				_g_free0 (_tmp18_);
				_tmp19_ = self->priv->_user;
				act_user_set_password_mode (_tmp19_, ACT_USER_PASSWORD_MODE_SET_AT_LOGIN);
				break;
			}
			default:
			{
				break;
			}
		}
	} else {
		ActUser* _tmp20_;
		ActUser* _tmp21_;
		_tmp20_ = self->priv->_user;
		_tmp21_ = switchboard_plug_user_accounts_get_current_user ();
		if (_tmp20_ == _tmp21_) {
			if (new_password != NULL) {
				 PasswdHandler* _tmp22_;
				_tmp22_ = switchboard_plug_user_accounts_get_passwd_handler (FALSE);
				passwd_change_password (_tmp22_, new_password, ______lambda7__passwd_passwd_callback, self);
			}
		}
	}
}

ActUser*
switchboard_plug_user_accounts_widgets_user_settings_view_get_user (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	ActUser* result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_set_user (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                    ActUser* value)
{
	ActUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_user_accounts_widgets_user_settings_view_get_user (self);
	if (old_value != value) {
		self->priv->_user = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_user_settings_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY]);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda10_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	SwitchboardPlugUserAccountsUserUtils* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = self->priv->utils;
	_tmp1_ = self->priv->full_name_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	switchboard_plug_user_accounts_user_utils_change_full_name (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda10__gtk_entry_activate (GtkEntry* _sender,
                                                                                            gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda10_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda11_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	SwitchboardPlugUserAccountsUserUtils* _tmp0_;
	GtkComboBoxText* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = self->priv->utils;
	_tmp1_ = self->priv->user_type_dropdown;
	_tmp2_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp1_);
	_tmp3_ = _tmp2_;
	switchboard_plug_user_accounts_user_utils_change_user_type (_tmp0_, _tmp3_);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda11__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                               gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda11_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->region_revealer);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view____lambda12_ (Block6Data* _data6_)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
	GtkTreeIter* iter = NULL;
	GValue cell = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkTreeIter _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeIter* _tmp5_;
	GtkTreeIter _tmp6_;
	GValue _tmp7_ = {0};
	GValue _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
	self = _data6_->self;
	_tmp0_ = self->priv->language_dropdown;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	__vala_GtkTreeIter_free0 (iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = __vala_GtkTreeIter_copy0 (&_tmp2_);
	iter = _tmp3_;
	_tmp4_ = self->priv->language_store;
	_tmp5_ = iter;
	_tmp6_ = *_tmp5_;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp4_, &_tmp6_, 0, &_tmp7_);
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	cell = _tmp7_;
	_tmp8_ = cell;
	_tmp9_ = switchboard_plug_user_accounts_get_regions (g_value_get_string (&_tmp8_));
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_ == 0;
	_g_object_unref0 (_tmp10_);
	if (_tmp13_) {
		GtkRevealer* _tmp14_;
		ActUser* _tmp15_;
		const gchar* _tmp16_;
		GValue _tmp17_;
		_tmp14_ = _data6_->region_revealer;
		gtk_revealer_set_reveal_child (_tmp14_, FALSE);
		_tmp15_ = self->priv->_user;
		_tmp16_ = act_user_get_language (_tmp15_);
		_tmp17_ = cell;
		if (g_strcmp0 (_tmp16_, g_value_get_string (&_tmp17_)) != 0) {
			SwitchboardPlugUserAccountsUserUtils* _tmp18_;
			GValue _tmp19_;
			_tmp18_ = self->priv->utils;
			_tmp19_ = cell;
			switchboard_plug_user_accounts_user_utils_change_language (_tmp18_, g_value_get_string (&_tmp19_));
		}
	} else {
		GtkRevealer* _tmp20_;
		GValue _tmp21_;
		_tmp20_ = _data6_->region_revealer;
		gtk_revealer_set_reveal_child (_tmp20_, TRUE);
		_tmp21_ = cell;
		switchboard_plug_user_accounts_widgets_user_settings_view_update_region (self, g_value_get_string (&_tmp21_));
	}
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	__vala_GtkTreeIter_free0 (iter);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view____lambda12__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view____lambda12_ (self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view____lambda13_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	gchar* new_language = NULL;
	GtkTreeIter* iter = NULL;
	GValue cell = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkTreeIter _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeIter* _tmp5_;
	GtkTreeIter _tmp6_;
	GValue _tmp7_ = {0};
	GValue _tmp8_;
	gchar* _tmp9_;
	GtkComboBox* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	GtkTreeIter _tmp12_;
	GtkTreeIter* _tmp13_;
	GtkListStore* _tmp14_;
	GtkTreeIter* _tmp15_;
	GtkTreeIter _tmp16_;
	GValue _tmp17_ = {0};
	const gchar* _tmp18_;
	GValue _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_;
	_tmp0_ = self->priv->language_dropdown;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	__vala_GtkTreeIter_free0 (iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = __vala_GtkTreeIter_copy0 (&_tmp2_);
	iter = _tmp3_;
	_tmp4_ = self->priv->language_store;
	_tmp5_ = iter;
	_tmp6_ = *_tmp5_;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp4_, &_tmp6_, 0, &_tmp7_);
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	cell = _tmp7_;
	_tmp8_ = cell;
	_tmp9_ = g_strdup (g_value_get_string (&_tmp8_));
	_g_free0 (new_language);
	new_language = _tmp9_;
	_tmp10_ = self->priv->region_box;
	gtk_combo_box_get_active_iter (_tmp10_, &_tmp11_);
	__vala_GtkTreeIter_free0 (iter);
	_tmp12_ = _tmp11_;
	_tmp13_ = __vala_GtkTreeIter_copy0 (&_tmp12_);
	iter = _tmp13_;
	_tmp14_ = self->priv->region_store;
	_tmp15_ = iter;
	_tmp16_ = *_tmp15_;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp14_, &_tmp16_, 0, &_tmp17_);
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	cell = _tmp17_;
	_tmp18_ = new_language;
	_tmp19_ = cell;
	_tmp20_ = g_strdup_printf ("_%s", g_value_get_string (&_tmp19_));
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
	_g_free0 (new_language);
	new_language = _tmp22_;
	_g_free0 (_tmp21_);
	_tmp24_ = new_language;
	if (g_strcmp0 (_tmp24_, "") != 0) {
		const gchar* _tmp25_;
		ActUser* _tmp26_;
		const gchar* _tmp27_;
		_tmp25_ = new_language;
		_tmp26_ = self->priv->_user;
		_tmp27_ = act_user_get_language (_tmp26_);
		_tmp23_ = g_strcmp0 (_tmp25_, _tmp27_) != 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		SwitchboardPlugUserAccountsUserUtils* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = self->priv->utils;
		_tmp29_ = new_language;
		switchboard_plug_user_accounts_user_utils_change_language (_tmp28_, _tmp29_);
	}
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	__vala_GtkTreeIter_free0 (iter);
	_g_free0 (new_language);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view____lambda13__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view____lambda13_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda14_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	SwitchboardPlugUserAccountsUserUtils* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->utils;
	_tmp1_ = self->priv->autologin_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	switchboard_plug_user_accounts_user_utils_change_autologin (_tmp0_, _tmp3_);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda14__g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda14_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_change_password_switchboard_plug_user_accounts_change_password_dialog_request_password_change (SwitchboardPlugUserAccountsChangePasswordDialog* _sender,
                                                                                                                                                          ActUserPasswordMode mode,
                                                                                                                                                          const gchar* new_password,
                                                                                                                                                          gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_change_password ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self, mode, new_password);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda15_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	PolkitPermission* permission = NULL;
	PolkitPermission* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ActUser* _tmp2_;
	ActUser* _tmp3_;
	SwitchboardPlugUserAccountsChangePasswordDialog* change_password_dialog = NULL;
	GtkRoot* _tmp10_;
	ActUser* _tmp11_;
	SwitchboardPlugUserAccountsChangePasswordDialog* _tmp12_;
	SwitchboardPlugUserAccountsChangePasswordDialog* _tmp13_;
	SwitchboardPlugUserAccountsChangePasswordDialog* _tmp14_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	permission = _tmp0_;
	_tmp2_ = self->priv->_user;
	_tmp3_ = switchboard_plug_user_accounts_get_current_user ();
	if (_tmp2_ == _tmp3_) {
		PolkitPermission* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = permission;
		_tmp5_ = g_permission_get_allowed ((GPermission*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			PolkitPermission* _tmp7_;
			_tmp7_ = permission;
			g_permission_release ((GPermission*) _tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_critical ("UserSettingsView.vala:232: Error releasing privileges: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (permission);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp11_ = self->priv->_user;
	_tmp12_ = switchboard_plug_user_accounts_change_password_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow), _tmp11_);
	g_object_ref_sink (_tmp12_);
	change_password_dialog = _tmp12_;
	_tmp13_ = change_password_dialog;
	gtk_window_present ((GtkWindow*) _tmp13_);
	_tmp14_ = change_password_dialog;
	g_signal_connect_object (_tmp14_, "request-password-change", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_change_password_switchboard_plug_user_accounts_change_password_dialog_request_password_change, self, 0);
	_g_object_unref0 (change_password_dialog);
	_g_object_unref0 (permission);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda15__gtk_button_clicked (GtkButton* _sender,
                                                                                            gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda15_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_change_lock_gtk_button_clicked (GtkButton* _sender,
                                                                                           gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_change_lock ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda22_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	g_signal_emit (self, switchboard_plug_user_accounts_widgets_user_settings_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_REMOVE_USER_SIGNAL], 0);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda22__gtk_button_clicked (GtkButton* _sender,
                                                                                            gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda22_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_g_object_notify (GObject* _sender,
                                                                                              GParamSpec* pspec,
                                                                                              gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_update_permission ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_update_ui_act_user_changed (ActUser* _sender,
                                                                                       gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_update_ui ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_act_user_changed (ActUser* _sender,
                                                                                               gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_update_permission ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static GObject *
switchboard_plug_user_accounts_widgets_user_settings_view_constructor (GType type,
                                                                       guint n_construct_properties,
                                                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self;
	ActUser* _tmp0_;
	SwitchboardPlugUserAccountsUserUtils* _tmp1_;
	ActUser* _tmp2_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	ActUser* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	AdwAvatar* _tmp9_;
	SwitchboardPlugUserAccountsWidgetsAvatarPopover* avatar_popover = NULL;
	ActUser* _tmp10_;
	SwitchboardPlugUserAccountsUserUtils* _tmp11_;
	SwitchboardPlugUserAccountsWidgetsAvatarPopover* _tmp12_;
	SwitchboardPlugUserAccountsWidgetsAvatarPopover* _tmp13_;
	GtkMenuButton* avatar_button = NULL;
	AdwAvatar* _tmp14_;
	GtkWidget* _tmp15_;
	SwitchboardPlugUserAccountsWidgetsAvatarPopover* _tmp16_;
	GtkPopover* _tmp17_;
	GtkMenuButton* _tmp18_ = NULL;
	GtkEntry* _tmp19_ = NULL;
	GtkEntry* _tmp20_;
	GtkEntry* _tmp21_;
	gchar* _tmp22_;
	GtkImage* _tmp23_ = NULL;
	GtkImage* _tmp24_;
	GtkGrid* header_area = NULL;
	GtkGrid* _tmp25_ = NULL;
	GtkGrid* _tmp26_;
	GtkMenuButton* _tmp27_;
	GtkGrid* _tmp28_;
	GtkEntry* _tmp29_;
	GtkGrid* _tmp30_;
	GtkImage* _tmp31_;
	GtkGrid* _tmp32_;
	GtkWindowControls* end_widget = NULL;
	GtkWindowControls* _tmp33_ = NULL;
	GtkCenterBox* headerbar = NULL;
	GtkGrid* _tmp34_;
	GtkWidget* _tmp35_;
	GtkWindowControls* _tmp36_;
	GtkWidget* _tmp37_;
	GtkCenterBox* _tmp38_ = NULL;
	GtkWindowHandle* window_handle = NULL;
	GtkCenterBox* _tmp39_;
	GtkWidget* _tmp40_;
	GtkWindowHandle* _tmp41_ = NULL;
	GtkComboBoxText* _tmp42_ = NULL;
	GtkComboBoxText* _tmp43_;
	GtkComboBoxText* _tmp44_;
	GtkComboBoxText* _tmp45_;
	GtkComboBoxText* _tmp46_;
	GtkWidget* _tmp47_;
	GraniteHeaderLabel* _tmp48_ = NULL;
	GtkBox* user_type_box = NULL;
	GtkBox* _tmp49_;
	GtkBox* _tmp50_;
	GraniteHeaderLabel* _tmp51_;
	GtkBox* _tmp52_;
	GtkComboBoxText* _tmp53_;
	GraniteHeaderLabel* _tmp54_;
	GtkBox* language_box = NULL;
	GtkBox* _tmp55_;
	GtkBox* _tmp56_;
	GraniteHeaderLabel* _tmp57_;
	ActUser* _tmp58_;
	ActUser* _tmp59_;
	GtkSwitch* _tmp85_ = NULL;
	GtkSwitch* _tmp86_;
	GtkSwitch* _tmp87_;
	GtkWidget* _tmp88_;
	GraniteHeaderLabel* _tmp89_ = NULL;
	GtkBox* autologin_box = NULL;
	GtkBox* _tmp90_;
	GtkBox* _tmp91_;
	GraniteHeaderLabel* _tmp92_;
	GtkBox* _tmp93_;
	GtkSwitch* _tmp94_;
	GtkButton* _tmp95_;
	GtkButton* _tmp96_;
	GtkButton* _tmp97_ = NULL;
	GtkButton* _tmp98_;
	GtkButton* remove_user_button = NULL;
	GtkButton* _tmp99_ = NULL;
	GtkButton* _tmp100_;
	GtkButton* _tmp101_;
	GtkImage* remove_lock = NULL;
	GtkImage* _tmp102_ = NULL;
	GtkImage* _tmp103_;
	GtkLockButton* lock_button = NULL;
	PolkitPermission* _tmp104_;
	PolkitPermission* _tmp105_;
	GtkLockButton* _tmp106_;
	GtkLockButton* _tmp107_;
	GtkLabel* infobar_label = NULL;
	GtkLabel* _tmp108_ = NULL;
	GtkInfoBar* _tmp109_ = NULL;
	GtkInfoBar* _tmp110_;
	GtkInfoBar* _tmp111_;
	GtkLockButton* _tmp112_;
	GtkInfoBar* _tmp113_;
	GtkLabel* _tmp114_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp115_;
	GtkBox* _tmp116_;
	GtkInfoBar* _tmp117_;
	GtkBox* _tmp118_;
	GtkBox* _tmp119_;
	GtkBox* _tmp120_;
	GtkBox* _tmp121_;
	GtkBox* _tmp122_;
	GtkBox* _tmp123_;
	AdwClamp* content_area = NULL;
	GtkBox* _tmp124_;
	GtkWidget* _tmp125_;
	AdwClamp* _tmp126_ = NULL;
	AdwClamp* _tmp127_;
	GtkBox* action_area = NULL;
	GtkBox* _tmp128_ = NULL;
	GtkBox* _tmp129_;
	GtkButton* _tmp130_;
	GtkBox* _tmp131_;
	GtkButton* _tmp132_;
	GtkBox* _tmp133_;
	GtkImage* _tmp134_;
	GtkBox* _tmp135_;
	GtkGrid* _tmp136_ = NULL;
	GtkGrid* _tmp137_;
	GtkBox* _tmp138_;
	GtkButton* _tmp139_;
	GtkBox* _tmp140_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp141_;
	GtkSizeGroup* _tmp142_;
	GtkGrid* _tmp143_;
	GtkSizeGroup* _tmp144_;
	AdwClamp* _tmp145_;
	GtkScrolledWindow* scrolled = NULL;
	AdwClamp* _tmp146_;
	GtkWidget* _tmp147_;
	GtkScrolledWindow* _tmp148_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp149_;
	GtkBox* _tmp150_;
	GtkWindowHandle* _tmp151_;
	GtkBox* _tmp152_;
	GtkScrolledWindow* _tmp153_;
	GtkBox* _tmp154_;
	GtkBox* _tmp155_;
	GtkBox* _tmp156_;
	ActUser* _tmp157_;
	ActUser* _tmp158_;
	PolkitPermission* _tmp168_;
	PolkitPermission* _tmp169_;
	ActUser* _tmp170_;
	ActUser* _tmp171_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_user_settings_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, SwitchboardPlugUserAccountsWidgetsUserSettingsView);
	_tmp0_ = self->priv->_user;
	_tmp1_ = switchboard_plug_user_accounts_user_utils_new (_tmp0_, self);
	_switchboard_plug_user_accounts_user_utils_unref0 (self->priv->utils);
	self->priv->utils = _tmp1_;
	_tmp2_ = self->priv->_user;
	_tmp3_ = switchboard_plug_user_accounts_delta_user_new (_tmp2_);
	_g_object_unref0 (self->priv->delta_user);
	self->priv->delta_user = _tmp3_;
	_tmp4_ = switchboard_plug_user_accounts_get_default_regions ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->default_regions);
	self->priv->default_regions = _tmp5_;
	_tmp6_ = self->priv->_user;
	_tmp7_ = act_user_get_real_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = (AdwAvatar*) adw_avatar_new (48, _tmp8_, TRUE);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->avatar);
	self->priv->avatar = _tmp9_;
	_tmp10_ = self->priv->_user;
	_tmp11_ = self->priv->utils;
	_tmp12_ = switchboard_plug_user_accounts_widgets_avatar_popover_new (_tmp10_, _tmp11_);
	g_object_ref_sink (_tmp12_);
	avatar_popover = _tmp12_;
	_tmp13_ = avatar_popover;
	gtk_widget_add_css_class ((GtkWidget*) _tmp13_, GRANITE_STYLE_CLASS_MENU);
	_tmp14_ = self->priv->avatar;
	_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
	_tmp16_ = avatar_popover;
	_tmp17_ = _g_object_ref0 ((GtkPopover*) _tmp16_);
	_tmp18_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_child (_tmp18_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_END);
	gtk_menu_button_set_has_frame (_tmp18_, FALSE);
	gtk_menu_button_set_popover (_tmp18_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	avatar_button = _tmp18_;
	_tmp19_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->full_name_entry);
	self->priv->full_name_entry = _tmp19_;
	_tmp20_ = self->priv->full_name_entry;
	gtk_widget_add_css_class ((GtkWidget*) _tmp20_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp21_ = self->priv->full_name_entry;
	g_signal_connect_object (_tmp21_, "activate", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda10__gtk_entry_activate, self, 0);
	_tmp22_ = g_strdup (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
	_tmp23_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic");
	gtk_widget_set_margin_start ((GtkWidget*) _tmp23_, 6);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp23_, _tmp22_);
	_g_free0 (_tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->full_name_lock);
	self->priv->full_name_lock = _tmp23_;
	_tmp24_ = self->priv->full_name_lock;
	gtk_widget_add_css_class ((GtkWidget*) _tmp24_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp25_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp25_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp25_);
	header_area = _tmp25_;
	_tmp26_ = header_area;
	_tmp27_ = avatar_button;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 0, 0, 1, 1);
	_tmp28_ = header_area;
	_tmp29_ = self->priv->full_name_entry;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 1, 0, 1, 1);
	_tmp30_ = header_area;
	_tmp31_ = self->priv->full_name_lock;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 2, 0, 1, 1);
	_tmp32_ = header_area;
	gtk_widget_add_css_class ((GtkWidget*) _tmp32_, "header-area");
	_tmp33_ = (GtkWindowControls*) gtk_window_controls_new (GTK_PACK_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp33_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp33_);
	end_widget = _tmp33_;
	_tmp34_ = header_area;
	_tmp35_ = _g_object_ref0 ((GtkWidget*) _tmp34_);
	_tmp36_ = end_widget;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	_tmp38_ = (GtkCenterBox*) gtk_center_box_new ();
	gtk_center_box_set_center_widget (_tmp38_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	gtk_center_box_set_end_widget (_tmp38_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	headerbar = _tmp38_;
	_tmp39_ = headerbar;
	_tmp40_ = _g_object_ref0 ((GtkWidget*) _tmp39_);
	_tmp41_ = (GtkWindowHandle*) gtk_window_handle_new ();
	gtk_window_handle_set_child (_tmp41_, _tmp40_);
	_g_object_unref0 (_tmp40_);
	g_object_ref_sink (_tmp41_);
	window_handle = _tmp41_;
	_tmp42_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp42_, TRUE);
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->user_type_dropdown);
	self->priv->user_type_dropdown = _tmp42_;
	_tmp43_ = self->priv->user_type_dropdown;
	gtk_combo_box_text_append_text (_tmp43_, _ ("Standard"));
	_tmp44_ = self->priv->user_type_dropdown;
	gtk_combo_box_text_append_text (_tmp44_, _ ("Administrator"));
	_tmp45_ = self->priv->user_type_dropdown;
	g_signal_connect_object ((GtkComboBox*) _tmp45_, "changed", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda11__gtk_combo_box_changed, self, 0);
	_tmp46_ = self->priv->user_type_dropdown;
	_tmp47_ = _g_object_ref0 ((GtkWidget*) _tmp46_);
	_tmp48_ = granite_header_label_new (_ ("Account type"));
	granite_header_label_set_mnemonic_widget (_tmp48_, _tmp47_);
	_g_object_unref0 (_tmp47_);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->user_type_label);
	self->priv->user_type_label = _tmp48_;
	_tmp49_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp49_);
	user_type_box = _tmp49_;
	_tmp50_ = user_type_box;
	_tmp51_ = self->priv->user_type_label;
	gtk_box_append (_tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = user_type_box;
	_tmp53_ = self->priv->user_type_dropdown;
	gtk_box_append (_tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = granite_header_label_new (_ ("Language"));
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->lang_label);
	self->priv->lang_label = _tmp54_;
	_tmp55_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp55_);
	language_box = _tmp55_;
	_tmp56_ = language_box;
	_tmp57_ = self->priv->lang_label;
	gtk_box_append (_tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = self->priv->_user;
	_tmp59_ = switchboard_plug_user_accounts_get_current_user ();
	if (_tmp58_ != _tmp59_) {
		Block6Data* _data6_;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp60_;
		GtkComboBox* _tmp61_ = NULL;
		GtkComboBox* _tmp62_;
		GtkCellRendererText* _tmp63_;
		GtkComboBox* _tmp64_;
		GtkCellRendererText* _tmp65_;
		GtkCellRendererText* _tmp66_;
		GtkComboBox* _tmp67_ = NULL;
		GtkComboBox* _tmp68_;
		GtkCellRendererText* _tmp69_;
		GtkComboBox* _tmp70_;
		GtkCellRendererText* _tmp71_;
		GtkComboBox* _tmp72_;
		GtkWidget* _tmp73_;
		GtkRevealer* _tmp74_ = NULL;
		GtkBox* _tmp75_;
		GtkComboBox* _tmp76_;
		GtkBox* _tmp77_;
		GtkRevealer* _tmp78_;
		GtkComboBox* _tmp79_;
		GtkComboBox* _tmp80_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->self = g_object_ref (self);
		_tmp60_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp60_);
		renderer = _tmp60_;
		_tmp61_ = (GtkComboBox*) gtk_combo_box_new ();
		gtk_widget_set_sensitive ((GtkWidget*) _tmp61_, FALSE);
		g_object_ref_sink (_tmp61_);
		_g_object_unref0 (self->priv->language_dropdown);
		self->priv->language_dropdown = _tmp61_;
		_tmp62_ = self->priv->language_dropdown;
		_tmp63_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp62_, (GtkCellRenderer*) _tmp63_, TRUE);
		_tmp64_ = self->priv->language_dropdown;
		_tmp65_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp64_, (GtkCellRenderer*) _tmp65_, "text", 1);
		_tmp66_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp66_);
		_g_object_unref0 (renderer);
		renderer = _tmp66_;
		_tmp67_ = (GtkComboBox*) gtk_combo_box_new ();
		gtk_widget_set_sensitive ((GtkWidget*) _tmp67_, FALSE);
		g_object_ref_sink (_tmp67_);
		_g_object_unref0 (self->priv->region_box);
		self->priv->region_box = _tmp67_;
		_tmp68_ = self->priv->region_box;
		_tmp69_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp68_, (GtkCellRenderer*) _tmp69_, TRUE);
		_tmp70_ = self->priv->region_box;
		_tmp71_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp70_, (GtkCellRenderer*) _tmp71_, "text", 1);
		_tmp72_ = self->priv->region_box;
		_tmp73_ = _g_object_ref0 ((GtkWidget*) _tmp72_);
		_tmp74_ = (GtkRevealer*) gtk_revealer_new ();
		gtk_revealer_set_child (_tmp74_, _tmp73_);
		_g_object_unref0 (_tmp73_);
		gtk_revealer_set_transition_type (_tmp74_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
		gtk_revealer_set_reveal_child (_tmp74_, TRUE);
		g_object_ref_sink (_tmp74_);
		_data6_->region_revealer = _tmp74_;
		_tmp75_ = language_box;
		_tmp76_ = self->priv->language_dropdown;
		gtk_box_append (_tmp75_, (GtkWidget*) _tmp76_);
		_tmp77_ = language_box;
		_tmp78_ = _data6_->region_revealer;
		gtk_box_append (_tmp77_, (GtkWidget*) _tmp78_);
		_tmp79_ = self->priv->language_dropdown;
		g_signal_connect_data (_tmp79_, "changed", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view____lambda12__gtk_combo_box_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp80_ = self->priv->region_box;
		g_signal_connect_object (_tmp80_, "changed", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view____lambda13__gtk_combo_box_changed, self, 0);
		_g_object_unref0 (renderer);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	} else {
		gchar* _tmp81_;
		GtkLinkButton* _tmp82_ = NULL;
		GtkBox* _tmp83_;
		GtkButton* _tmp84_;
		_tmp81_ = g_strdup (_ ("Click to switch to Language & Region Settings"));
		_tmp82_ = (GtkLinkButton*) gtk_link_button_new_with_label ("settings://language", "Language");
		gtk_widget_set_halign ((GtkWidget*) _tmp82_, GTK_ALIGN_START);
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp82_, _tmp81_);
		_g_free0 (_tmp81_);
		g_object_ref_sink (_tmp82_);
		_g_object_unref0 (self->priv->language_button);
		self->priv->language_button = (GtkButton*) _tmp82_;
		_tmp83_ = language_box;
		_tmp84_ = self->priv->language_button;
		gtk_box_append (_tmp83_, (GtkWidget*) _tmp84_);
	}
	_tmp85_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp85_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp85_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp85_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (self->priv->autologin_switch);
	self->priv->autologin_switch = _tmp85_;
	_tmp86_ = self->priv->autologin_switch;
	g_signal_connect_object ((GObject*) _tmp86_, "notify::active", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda14__g_object_notify, self, 0);
	_tmp87_ = self->priv->autologin_switch;
	_tmp88_ = _g_object_ref0 ((GtkWidget*) _tmp87_);
	_tmp89_ = granite_header_label_new (_ ("Log In automatically"));
	granite_header_label_set_mnemonic_widget (_tmp89_, _tmp88_);
	_g_object_unref0 (_tmp88_);
	gtk_widget_set_valign ((GtkWidget*) _tmp89_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp89_);
	_g_object_unref0 (self->priv->autologin_label);
	self->priv->autologin_label = _tmp89_;
	_tmp90_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp90_);
	autologin_box = _tmp90_;
	_tmp91_ = autologin_box;
	_tmp92_ = self->priv->autologin_label;
	gtk_box_append (_tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = autologin_box;
	_tmp94_ = self->priv->autologin_switch;
	gtk_box_append (_tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = (GtkButton*) gtk_button_new_with_label (_ ("Change Password…"));
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->priv->password_button);
	self->priv->password_button = _tmp95_;
	_tmp96_ = self->priv->password_button;
	g_signal_connect_object (_tmp96_, "clicked", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda15__gtk_button_clicked, self, 0);
	_tmp97_ = (GtkButton*) gtk_button_new ();
	gtk_widget_set_sensitive ((GtkWidget*) _tmp97_, FALSE);
	g_object_ref_sink (_tmp97_);
	_g_object_unref0 (self->priv->enable_user_button);
	self->priv->enable_user_button = _tmp97_;
	_tmp98_ = self->priv->enable_user_button;
	g_signal_connect_object (_tmp98_, "clicked", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_change_lock_gtk_button_clicked, self, 0);
	_tmp99_ = (GtkButton*) gtk_button_new_with_label (_ ("Remove Account"));
	gtk_widget_set_sensitive ((GtkWidget*) _tmp99_, FALSE);
	g_object_ref_sink (_tmp99_);
	remove_user_button = _tmp99_;
	_tmp100_ = remove_user_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp100_, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp101_ = remove_user_button;
	g_signal_connect_object (_tmp101_, "clicked", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda22__gtk_button_clicked, self, 0);
	_tmp102_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic");
	gtk_widget_set_margin_start ((GtkWidget*) _tmp102_, 6);
	g_object_ref_sink (_tmp102_);
	remove_lock = _tmp102_;
	_tmp103_ = remove_lock;
	gtk_widget_add_css_class ((GtkWidget*) _tmp103_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp104_ = switchboard_plug_user_accounts_get_permission ();
	_tmp105_ = _tmp104_;
	_tmp106_ = (GtkLockButton*) gtk_lock_button_new ((GPermission*) _tmp105_);
	g_object_ref_sink (_tmp106_);
	_tmp107_ = _tmp106_;
	_g_object_unref0 (_tmp105_);
	lock_button = _tmp107_;
	_tmp108_ = (GtkLabel*) gtk_label_new (_ ("Some settings require administrator rights to be changed"));
	gtk_label_set_wrap (_tmp108_, TRUE);
	g_object_ref_sink (_tmp108_);
	infobar_label = _tmp108_;
	_tmp109_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_info_bar_set_message_type (_tmp109_, GTK_MESSAGE_INFO);
	g_object_ref_sink (_tmp109_);
	_g_object_unref0 (self->priv->infobar);
	self->priv->infobar = _tmp109_;
	_tmp110_ = self->priv->infobar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp110_, GRANITE_STYLE_CLASS_FRAME);
	_tmp111_ = self->priv->infobar;
	_tmp112_ = lock_button;
	gtk_info_bar_add_action_widget (_tmp111_, (GtkWidget*) _tmp112_, 0);
	_tmp113_ = self->priv->infobar;
	_tmp114_ = infobar_label;
	gtk_info_bar_add_child (_tmp113_, (GtkWidget*) _tmp114_);
	_tmp115_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp115_);
	content_box = _tmp115_;
	_tmp116_ = content_box;
	_tmp117_ = self->priv->infobar;
	gtk_box_append (_tmp116_, (GtkWidget*) _tmp117_);
	_tmp118_ = content_box;
	_tmp119_ = user_type_box;
	gtk_box_append (_tmp118_, (GtkWidget*) _tmp119_);
	_tmp120_ = content_box;
	_tmp121_ = language_box;
	gtk_box_append (_tmp120_, (GtkWidget*) _tmp121_);
	_tmp122_ = content_box;
	_tmp123_ = autologin_box;
	gtk_box_append (_tmp122_, (GtkWidget*) _tmp123_);
	_tmp124_ = content_box;
	_tmp125_ = _g_object_ref0 ((GtkWidget*) _tmp124_);
	_tmp126_ = (AdwClamp*) adw_clamp_new ();
	adw_clamp_set_child (_tmp126_, _tmp125_);
	_g_object_unref0 (_tmp125_);
	adw_clamp_set_maximum_size (_tmp126_, 600);
	adw_clamp_set_tightening_threshold (_tmp126_, 600);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp126_, TRUE);
	g_object_ref_sink (_tmp126_);
	content_area = _tmp126_;
	_tmp127_ = content_area;
	gtk_widget_add_css_class ((GtkWidget*) _tmp127_, "content-area");
	_tmp128_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp128_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp128_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp128_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp128_, 12);
	g_object_ref_sink (_tmp128_);
	action_area = _tmp128_;
	_tmp129_ = action_area;
	_tmp130_ = remove_user_button;
	gtk_box_append (_tmp129_, (GtkWidget*) _tmp130_);
	_tmp131_ = action_area;
	_tmp132_ = self->priv->enable_user_button;
	gtk_box_append (_tmp131_, (GtkWidget*) _tmp132_);
	_tmp133_ = action_area;
	_tmp134_ = remove_lock;
	gtk_box_append (_tmp133_, (GtkWidget*) _tmp134_);
	_tmp135_ = action_area;
	_tmp136_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp136_, TRUE);
	g_object_ref_sink (_tmp136_);
	_tmp137_ = _tmp136_;
	gtk_box_append (_tmp135_, (GtkWidget*) _tmp137_);
	_g_object_unref0 (_tmp137_);
	_tmp138_ = action_area;
	_tmp139_ = self->priv->password_button;
	gtk_box_append (_tmp138_, (GtkWidget*) _tmp139_);
	_tmp140_ = action_area;
	gtk_widget_add_css_class ((GtkWidget*) _tmp140_, "buttonbox");
	_tmp141_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	size_group = _tmp141_;
	_tmp142_ = size_group;
	_tmp143_ = header_area;
	gtk_size_group_add_widget (_tmp142_, (GtkWidget*) _tmp143_);
	_tmp144_ = size_group;
	_tmp145_ = content_area;
	gtk_size_group_add_widget (_tmp144_, (GtkWidget*) _tmp145_);
	_tmp146_ = content_area;
	_tmp147_ = _g_object_ref0 ((GtkWidget*) _tmp146_);
	_tmp148_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp148_, _tmp147_);
	_g_object_unref0 (_tmp147_);
	g_object_set (_tmp148_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp148_);
	scrolled = _tmp148_;
	_tmp149_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp149_);
	box = _tmp149_;
	_tmp150_ = box;
	_tmp151_ = window_handle;
	gtk_box_append (_tmp150_, (GtkWidget*) _tmp151_);
	_tmp152_ = box;
	_tmp153_ = scrolled;
	gtk_box_append (_tmp152_, (GtkWidget*) _tmp153_);
	_tmp154_ = box;
	_tmp155_ = action_area;
	gtk_box_append (_tmp154_, (GtkWidget*) _tmp155_);
	_tmp156_ = box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp156_);
	switchboard_plug_user_accounts_widgets_user_settings_view_update_ui (self);
	switchboard_plug_user_accounts_widgets_user_settings_view_update_permission (self);
	_tmp157_ = switchboard_plug_user_accounts_get_current_user ();
	_tmp158_ = self->priv->_user;
	if (_tmp157_ == _tmp158_) {
		GraniteHeaderLabel* _tmp159_;
		GtkImage* _tmp160_;
		_tmp159_ = self->priv->user_type_label;
		granite_header_label_set_secondary_text (_tmp159_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_CURRENT_USER_STRING);
		_tmp160_ = remove_lock;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp160_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_CURRENT_USER_STRING);
	} else {
		ActUser* _tmp161_;
		_tmp161_ = self->priv->_user;
		if (switchboard_plug_user_accounts_is_last_admin (_tmp161_)) {
			GraniteHeaderLabel* _tmp162_;
			GtkImage* _tmp163_;
			_tmp162_ = self->priv->user_type_label;
			granite_header_label_set_secondary_text (_tmp162_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_LAST_ADMIN_STRING);
			_tmp163_ = remove_lock;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp163_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_LAST_ADMIN_STRING);
		} else {
			GtkButton* _tmp164_;
			GtkButton* _tmp165_;
			GtkBox* _tmp166_;
			GtkImage* _tmp167_;
			_tmp164_ = self->priv->enable_user_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp164_, TRUE);
			_tmp165_ = remove_user_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp165_, TRUE);
			_tmp166_ = action_area;
			_tmp167_ = remove_lock;
			gtk_box_remove (_tmp166_, (GtkWidget*) _tmp167_);
		}
	}
	_tmp168_ = switchboard_plug_user_accounts_get_permission ();
	_tmp169_ = _tmp168_;
	g_signal_connect_object ((GObject*) _tmp169_, "notify::allowed", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_g_object_notify, self, 0);
	_g_object_unref0 (_tmp169_);
	_tmp170_ = self->priv->_user;
	g_signal_connect_object (_tmp170_, "changed", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_update_ui_act_user_changed, self, 0);
	_tmp171_ = self->priv->_user;
	g_signal_connect_object (_tmp171_, "changed", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_act_user_changed, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (size_group);
	_g_object_unref0 (action_area);
	_g_object_unref0 (content_area);
	_g_object_unref0 (content_box);
	_g_object_unref0 (infobar_label);
	_g_object_unref0 (lock_button);
	_g_object_unref0 (remove_lock);
	_g_object_unref0 (remove_user_button);
	_g_object_unref0 (autologin_box);
	_g_object_unref0 (language_box);
	_g_object_unref0 (user_type_box);
	_g_object_unref0 (window_handle);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (end_widget);
	_g_object_unref0 (header_area);
	_g_object_unref0 (avatar_button);
	_g_object_unref0 (avatar_popover);
	return obj;
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_base_init (SwitchboardPlugUserAccountsWidgetsUserSettingsViewClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "settingspage");
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_class_init (SwitchboardPlugUserAccountsWidgetsUserSettingsViewClass * klass,
                                                                      gpointer klass_data)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugUserAccountsWidgetsUserSettingsView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_user_accounts_widgets_user_settings_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_user_accounts_widgets_user_settings_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_user_accounts_widgets_user_settings_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_user_accounts_widgets_user_settings_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY, switchboard_plug_user_accounts_widgets_user_settings_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", act_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	switchboard_plug_user_accounts_widgets_user_settings_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_REMOVE_USER_SIGNAL] = g_signal_new ("remove-user", SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_instance_init (SwitchboardPlugUserAccountsWidgetsUserSettingsView * self,
                                                                         gpointer klass)
{
	self->priv = switchboard_plug_user_accounts_widgets_user_settings_view_get_instance_private (self);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_finalize (GObject * obj)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, SwitchboardPlugUserAccountsWidgetsUserSettingsView);
	_switchboard_plug_user_accounts_user_utils_unref0 (self->priv->utils);
	_g_object_unref0 (self->priv->delta_user);
	_g_object_unref0 (self->priv->language_store);
	_g_object_unref0 (self->priv->region_store);
	_g_object_unref0 (self->priv->avatar);
	_g_object_unref0 (self->priv->autologin_label);
	_g_object_unref0 (self->priv->lang_label);
	_g_object_unref0 (self->priv->user_type_label);
	_g_object_unref0 (self->priv->full_name_entry);
	_g_object_unref0 (self->priv->password_button);
	_g_object_unref0 (self->priv->enable_user_button);
	_g_object_unref0 (self->priv->user_type_dropdown);
	_g_object_unref0 (self->priv->language_dropdown);
	_g_object_unref0 (self->priv->region_box);
	_g_object_unref0 (self->priv->language_button);
	_g_object_unref0 (self->priv->autologin_switch);
	_g_object_unref0 (self->priv->infobar);
	_g_object_unref0 (self->priv->full_name_lock);
	_g_object_unref0 (self->priv->default_regions);
	G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_user_settings_view_parent_class)->finalize (obj);
}

static GType
switchboard_plug_user_accounts_widgets_user_settings_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugUserAccountsWidgetsUserSettingsViewClass), (GBaseInitFunc) switchboard_plug_user_accounts_widgets_user_settings_view_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_user_accounts_widgets_user_settings_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugUserAccountsWidgetsUserSettingsView), 0, (GInstanceInitFunc) switchboard_plug_user_accounts_widgets_user_settings_view_instance_init, NULL };
	GType switchboard_plug_user_accounts_widgets_user_settings_view_type_id;
	switchboard_plug_user_accounts_widgets_user_settings_view_type_id = g_type_register_static (gtk_box_get_type (), "SwitchboardPlugUserAccountsWidgetsUserSettingsView", &g_define_type_info, 0);
	SwitchboardPlugUserAccountsWidgetsUserSettingsView_private_offset = g_type_add_instance_private (switchboard_plug_user_accounts_widgets_user_settings_view_type_id, sizeof (SwitchboardPlugUserAccountsWidgetsUserSettingsViewPrivate));
	return switchboard_plug_user_accounts_widgets_user_settings_view_type_id;
}

GType
switchboard_plug_user_accounts_widgets_user_settings_view_get_type (void)
{
	static volatile gsize switchboard_plug_user_accounts_widgets_user_settings_view_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_user_accounts_widgets_user_settings_view_type_id__once)) {
		GType switchboard_plug_user_accounts_widgets_user_settings_view_type_id;
		switchboard_plug_user_accounts_widgets_user_settings_view_type_id = switchboard_plug_user_accounts_widgets_user_settings_view_get_type_once ();
		g_once_init_leave (&switchboard_plug_user_accounts_widgets_user_settings_view_type_id__once, switchboard_plug_user_accounts_widgets_user_settings_view_type_id);
	}
	return switchboard_plug_user_accounts_widgets_user_settings_view_type_id__once;
}

static void
_vala_switchboard_plug_user_accounts_widgets_user_settings_view_get_property (GObject * object,
                                                                              guint property_id,
                                                                              GValue * value,
                                                                              GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, SwitchboardPlugUserAccountsWidgetsUserSettingsView);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY:
		g_value_set_object (value, switchboard_plug_user_accounts_widgets_user_settings_view_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_user_accounts_widgets_user_settings_view_set_property (GObject * object,
                                                                              guint property_id,
                                                                              const GValue * value,
                                                                              GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, SwitchboardPlugUserAccountsWidgetsUserSettingsView);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY:
		switchboard_plug_user_accounts_widgets_user_settings_view_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

