/* GradientEditor.c generated by valac 0.56.18, the Vala compiler
 * generated from GradientEditor.vala, do not modify */

/*
* Copyright (c) 2018 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#define SPICE_GRADIENT_EDITOR_GRADIENT_MAKER_STYLE "\n" \
"            * {\n" \
"                background-image: %s;\n" \
"                border-radius: 20px;\n" \
"                border: 1.4px solid rgba(0,0,0,0.2);\n" \
"            }\n" \
"        "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_GRADIENT_EDITOR (spice_gradient_editor_get_type ())
#define SPICE_GRADIENT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditor))
#define SPICE_GRADIENT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditorClass))
#define SPICE_IS_GRADIENT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_GRADIENT_EDITOR))
#define SPICE_IS_GRADIENT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_GRADIENT_EDITOR))
#define SPICE_GRADIENT_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditorClass))

typedef struct _SpiceGradientEditor SpiceGradientEditor;
typedef struct _SpiceGradientEditorClass SpiceGradientEditorClass;
typedef struct _SpiceGradientEditorPrivate SpiceGradientEditorPrivate;

#define SPICE_TYPE_COLOR_BUTTON (spice_color_button_get_type ())
#define SPICE_COLOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_COLOR_BUTTON, SpiceColorButton))
#define SPICE_COLOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_COLOR_BUTTON, SpiceColorButtonClass))
#define SPICE_IS_COLOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_COLOR_BUTTON))
#define SPICE_IS_COLOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_COLOR_BUTTON))
#define SPICE_COLOR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_COLOR_BUTTON, SpiceColorButtonClass))

typedef struct _SpiceColorButton SpiceColorButton;
typedef struct _SpiceColorButtonClass SpiceColorButtonClass;

#define SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB (spice_gradient_editor_gradient_nub_get_type ())
#define SPICE_GRADIENT_EDITOR_GRADIENT_NUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB, SpiceGradientEditorGradientNub))
#define SPICE_GRADIENT_EDITOR_GRADIENT_NUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB, SpiceGradientEditorGradientNubClass))
#define SPICE_GRADIENT_EDITOR_IS_GRADIENT_NUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB))
#define SPICE_GRADIENT_EDITOR_IS_GRADIENT_NUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB))
#define SPICE_GRADIENT_EDITOR_GRADIENT_NUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB, SpiceGradientEditorGradientNubClass))

typedef struct _SpiceGradientEditorGradientNub SpiceGradientEditorGradientNub;
typedef struct _SpiceGradientEditorGradientNubClass SpiceGradientEditorGradientNubClass;

#define SPICE_TYPE_GRADIENT (spice_gradient_get_type ())
#define SPICE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_GRADIENT, SpiceGradient))
#define SPICE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_GRADIENT, SpiceGradientClass))
#define SPICE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_GRADIENT))
#define SPICE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_GRADIENT))
#define SPICE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_GRADIENT, SpiceGradientClass))

typedef struct _SpiceGradient SpiceGradient;
typedef struct _SpiceGradientClass SpiceGradientClass;

#define SPICE_TYPE_COLOR_CHOOSER (spice_color_chooser_get_type ())
#define SPICE_COLOR_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooser))
#define SPICE_COLOR_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooserClass))
#define SPICE_IS_COLOR_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_COLOR_CHOOSER))
#define SPICE_IS_COLOR_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_COLOR_CHOOSER))
#define SPICE_COLOR_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooserClass))

typedef struct _SpiceColorChooser SpiceColorChooser;
typedef struct _SpiceColorChooserClass SpiceColorChooserClass;

#define SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER (spice_gradient_editor_gradient_maker_get_type ())
#define SPICE_GRADIENT_EDITOR_GRADIENT_MAKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER, SpiceGradientEditorGradientMaker))
#define SPICE_GRADIENT_EDITOR_GRADIENT_MAKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER, SpiceGradientEditorGradientMakerClass))
#define SPICE_GRADIENT_EDITOR_IS_GRADIENT_MAKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER))
#define SPICE_GRADIENT_EDITOR_IS_GRADIENT_MAKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER))
#define SPICE_GRADIENT_EDITOR_GRADIENT_MAKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER, SpiceGradientEditorGradientMakerClass))

typedef struct _SpiceGradientEditorGradientMaker SpiceGradientEditorGradientMaker;
typedef struct _SpiceGradientEditorGradientMakerClass SpiceGradientEditorGradientMakerClass;
enum  {
	SPICE_GRADIENT_EDITOR_0_PROPERTY,
	SPICE_GRADIENT_EDITOR_GRADIENT_COLOR_PROPERTY,
	SPICE_GRADIENT_EDITOR_SELECTED_STEP_PROPERTY,
	SPICE_GRADIENT_EDITOR_GRADIENT_PROPERTY,
	SPICE_GRADIENT_EDITOR_NUM_PROPERTIES
};
static GParamSpec* spice_gradient_editor_properties[SPICE_GRADIENT_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPICE_GRADIENT_TYPE_GRADIENT_STEP (spice_gradient_gradient_step_get_type ())
#define SPICE_GRADIENT_GRADIENT_STEP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStep))
#define SPICE_GRADIENT_GRADIENT_STEP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStepClass))
#define SPICE_GRADIENT_IS_GRADIENT_STEP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP))
#define SPICE_GRADIENT_IS_GRADIENT_STEP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_GRADIENT_TYPE_GRADIENT_STEP))
#define SPICE_GRADIENT_GRADIENT_STEP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStepClass))

typedef struct _SpiceGradientGradientStep SpiceGradientGradientStep;
typedef struct _SpiceGradientGradientStepClass SpiceGradientGradientStepClass;
typedef struct _Block20Data Block20Data;
typedef struct _SpiceGradientPrivate SpiceGradientPrivate;
typedef struct _Block21Data Block21Data;
typedef struct _SpiceColorButtonPrivate SpiceColorButtonPrivate;
typedef struct _SpiceGradientEditorGradientNubPrivate SpiceGradientEditorGradientNubPrivate;
enum  {
	SPICE_GRADIENT_EDITOR_GRADIENT_NUB_0_PROPERTY,
	SPICE_GRADIENT_EDITOR_GRADIENT_NUB_STEP_PROPERTY,
	SPICE_GRADIENT_EDITOR_GRADIENT_NUB_DELTA_Y_PROPERTY,
	SPICE_GRADIENT_EDITOR_GRADIENT_NUB_SELECTED_PROPERTY,
	SPICE_GRADIENT_EDITOR_GRADIENT_NUB_NUM_PROPERTIES
};
static GParamSpec* spice_gradient_editor_gradient_nub_properties[SPICE_GRADIENT_EDITOR_GRADIENT_NUB_NUM_PROPERTIES];
typedef struct _Block22Data Block22Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SpiceGradientEditorGradientMakerPrivate SpiceGradientEditorGradientMakerPrivate;
enum  {
	SPICE_GRADIENT_EDITOR_GRADIENT_MAKER_0_PROPERTY,
	SPICE_GRADIENT_EDITOR_GRADIENT_MAKER_NUM_PROPERTIES
};
static GParamSpec* spice_gradient_editor_gradient_maker_properties[SPICE_GRADIENT_EDITOR_GRADIENT_MAKER_NUM_PROPERTIES];
enum  {
	SPICE_GRADIENT_EDITOR_UPDATED_SIGNAL,
	SPICE_GRADIENT_EDITOR_COLOR_SELECTED_SIGNAL,
	SPICE_GRADIENT_EDITOR_NUM_SIGNALS
};
static guint spice_gradient_editor_signals[SPICE_GRADIENT_EDITOR_NUM_SIGNALS] = {0};

struct _SpiceGradientEditor {
	GtkGrid parent_instance;
	SpiceGradientEditorPrivate * priv;
};

struct _SpiceGradientEditorClass {
	GtkGridClass parent_class;
};

struct _SpiceGradientEditorPrivate {
	SpiceGradientEditorGradientNub* _selected_nub;
	SpiceGradient* _gradient;
	gchar* _gradient_color;
	SpiceColorChooser* color_picker;
	SpiceGradientEditorGradientMaker* editor;
	GtkScale* direction;
	GtkButton* add_step;
	GtkButton* remove_step;
};

struct _Block20Data {
	int _ref_count_;
	SpiceGradientEditor* self;
	gint step_count;
	SpiceGradientEditorGradientNub* first_nub;
	SpiceGradientGradientStep* first_step;
};

struct _SpiceGradient {
	GObject parent_instance;
	SpiceGradientPrivate * priv;
	GList* steps;
	gchar* direction;
};

struct _SpiceGradientClass {
	GObjectClass parent_class;
};

struct _Block21Data {
	int _ref_count_;
	Block20Data * _data20_;
	SpiceGradientEditorGradientNub* nub;
};

struct _SpiceColorButton {
	GtkButton parent_instance;
	SpiceColorButtonPrivate * priv;
	GtkEventBox* surface;
	GtkEventBox* checkered_bg;
	gchar* _color;
};

struct _SpiceColorButtonClass {
	GtkButtonClass parent_class;
};

struct _SpiceGradientEditorGradientNub {
	SpiceColorButton parent_instance;
	SpiceGradientEditorGradientNubPrivate * priv;
	SpiceGradientEditorGradientMaker* maker;
	SpiceGradientEditor* editor;
	gdouble start_y;
	gdouble start_value;
};

struct _SpiceGradientEditorGradientNubClass {
	SpiceColorButtonClass parent_class;
};

struct _SpiceGradientEditorGradientNubPrivate {
	SpiceGradientGradientStep* _step;
	gint _delta_y;
	gboolean holding;
};

struct _Block22Data {
	int _ref_count_;
	SpiceGradientEditorGradientNub* self;
	SpiceGradientGradientStep* step;
};

struct _SpiceGradientEditorGradientMaker {
	GtkOverlay parent_instance;
	SpiceGradientEditorGradientMakerPrivate * priv;
};

struct _SpiceGradientEditorGradientMakerClass {
	GtkOverlayClass parent_class;
};

struct _SpiceGradientEditorGradientMakerPrivate {
	GtkWidget* grid;
};

static gint SpiceGradientEditor_private_offset;
static gpointer spice_gradient_editor_parent_class = NULL;
static gint SpiceGradientEditorGradientNub_private_offset;
static gpointer spice_gradient_editor_gradient_nub_parent_class = NULL;
static gint SpiceGradientEditorGradientMaker_private_offset;
static gpointer spice_gradient_editor_gradient_maker_parent_class = NULL;

VALA_EXTERN GType spice_gradient_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradientEditor, g_object_unref)
VALA_EXTERN GType spice_color_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceColorButton, g_object_unref)
static GType spice_gradient_editor_gradient_nub_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradientEditorGradientNub, g_object_unref)
VALA_EXTERN GType spice_gradient_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradient, g_object_unref)
VALA_EXTERN GType spice_color_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceColorChooser, g_object_unref)
static GType spice_gradient_editor_gradient_maker_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradientEditorGradientMaker, g_object_unref)
VALA_EXTERN SpiceGradientEditor* spice_gradient_editor_new (SpiceColorChooser* _color_picker);
VALA_EXTERN SpiceGradientEditor* spice_gradient_editor_construct (GType object_type,
                                                      SpiceColorChooser* _color_picker);
VALA_EXTERN void spice_gradient_editor_set_color (SpiceGradientEditor* self,
                                      const gchar* color,
                                      gboolean override);
VALA_EXTERN void spice_gradient_editor_parse_gradient (SpiceGradientEditor* self,
                                           const gchar* color,
                                           gboolean force);
VALA_EXTERN GType spice_gradient_gradient_step_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradientGradientStep, g_object_unref)
VALA_EXTERN SpiceGradientGradientStep* spice_gradient_editor_get_selected_step (SpiceGradientEditor* self);
VALA_EXTERN void spice_gradient_gradient_step_set_color (SpiceGradientGradientStep* self,
                                             const gchar* value);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
VALA_EXTERN gchar* spice_gradient_editor_make_gradient (SpiceGradientEditor* self);
VALA_EXTERN SpiceGradient* spice_gradient_editor_get_gradient (SpiceGradientEditor* self);
VALA_EXTERN void spice_gradient_parse (SpiceGradient* self,
                           const gchar* gradient);
static void spice_gradient_editor_gradient_maker_css_style (SpiceGradientEditorGradientMaker* self,
                                                     const gchar* style);
VALA_EXTERN gchar* spice_gradient_to_string (SpiceGradient* self,
                                 gboolean force_down);
static void spice_gradient_editor_gradient_maker_clear_all (SpiceGradientEditorGradientMaker* self);
VALA_EXTERN SpiceGradientGradientStep* spice_gradient_get_color (SpiceGradient* self,
                                                     gint nth);
static void __lambda32_ (Block20Data* _data20_,
                  SpiceGradientGradientStep* item);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static SpiceGradientEditorGradientNub* spice_gradient_editor_gradient_nub_new (SpiceGradientEditor* editor,
                                                                        SpiceGradientGradientStep* step,
                                                                        SpiceGradientEditorGradientMaker* maker);
static SpiceGradientEditorGradientNub* spice_gradient_editor_gradient_nub_construct (GType object_type,
                                                                              SpiceGradientEditor* editor,
                                                                              SpiceGradientGradientStep* step,
                                                                              SpiceGradientEditorGradientMaker* maker);
static void __lambda33_ (Block21Data* _data21_);
static SpiceGradientGradientStep* spice_gradient_editor_gradient_nub_get_step (SpiceGradientEditorGradientNub* self);
VALA_EXTERN const gchar* spice_color_button_get_color (SpiceColorButton* self);
static void spice_gradient_editor_set_selected_nub (SpiceGradientEditor* self,
                                             SpiceGradientEditorGradientNub* value);
static void ___lambda33__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void ___lambda32__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void spice_gradient_editor_select_step_id (SpiceGradientEditor* self,
                                           gint step_id);
VALA_EXTERN void spice_gradient_editor_select_step (SpiceGradientEditor* self,
                                        SpiceGradientGradientStep* wanted_step);
VALA_EXTERN gboolean spice_gradient_gradient_step_equals (SpiceGradientGradientStep* self,
                                              SpiceGradientGradientStep* step);
VALA_EXTERN const gchar* spice_gradient_editor_get_gradient_color (SpiceGradientEditor* self);
VALA_EXTERN void spice_gradient_editor_set_gradient_color (SpiceGradientEditor* self,
                                               const gchar* value);
static SpiceGradientEditorGradientNub* spice_gradient_editor_get_selected_nub (SpiceGradientEditor* self);
static void spice_gradient_editor_gradient_nub_set_selected (SpiceGradientEditorGradientNub* self,
                                                      gboolean value);
static void spice_gradient_editor_set_gradient (SpiceGradientEditor* self,
                                         SpiceGradient* value);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
VALA_EXTERN const gchar* spice_gradient_gradient_step_get_color (SpiceGradientGradientStep* self);
static void spice_gradient_editor_gradient_nub_set_step (SpiceGradientEditorGradientNub* self,
                                                  SpiceGradientGradientStep* value);
VALA_EXTERN void spice_color_button_set_size (SpiceColorButton* self,
                                  gint x,
                                  gint y);
static void __lambda28_ (Block22Data* _data22_);
VALA_EXTERN void spice_color_button_set_color (SpiceColorButton* self,
                                   const gchar* value);
static void ___lambda28__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda29_ (SpiceGradientEditorGradientNub* self);
static void ___lambda29__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean spice_gradient_editor_gradient_nub_real_button_press_event (GtkWidget* base,
                                                                     GdkEventButton* event);
VALA_EXTERN const gchar* spice_gradient_gradient_step_get_percent (SpiceGradientGradientStep* self);
static gboolean spice_gradient_editor_gradient_nub_real_motion_notify_event (GtkWidget* base,
                                                                      GdkEventMotion* event);
VALA_EXTERN void spice_gradient_gradient_step_set_percent (SpiceGradientGradientStep* self,
                                               const gchar* value);
static gboolean spice_gradient_editor_gradient_nub_real_button_release_event (GtkWidget* base,
                                                                       GdkEventButton* event);
static gint spice_gradient_editor_gradient_nub_get_delta_y (SpiceGradientEditorGradientNub* self);
static void spice_gradient_editor_gradient_nub_set_delta_y (SpiceGradientEditorGradientNub* self,
                                                     gint value);
static void spice_gradient_editor_gradient_nub_finalize (GObject * obj);
static GType spice_gradient_editor_gradient_nub_get_type_once (void);
static void _vala_spice_gradient_editor_gradient_nub_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_spice_gradient_editor_gradient_nub_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
static gboolean spice_gradient_editor_gradient_maker_real_get_child_position (GtkOverlay* base,
                                                                       GtkWidget* widget,
                                                                       GdkRectangle* allocation);
VALA_EXTERN void spice_utils_set_style (GtkWidget* widget,
                            const gchar* css);
static SpiceGradientEditorGradientMaker* spice_gradient_editor_gradient_maker_new (void);
static SpiceGradientEditorGradientMaker* spice_gradient_editor_gradient_maker_construct (GType object_type);
static GObject * spice_gradient_editor_gradient_maker_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
static void spice_gradient_editor_gradient_maker_finalize (GObject * obj);
static GType spice_gradient_editor_gradient_maker_get_type_once (void);
static GObject * spice_gradient_editor_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
VALA_EXTERN SpiceGradient* spice_gradient_new (void);
VALA_EXTERN SpiceGradient* spice_gradient_construct (GType object_type);
static void _spice_gradient_editor___lambda34_ (SpiceGradientEditor* self);
static void __spice_gradient_editor___lambda34__gtk_range_value_changed (GtkRange* _sender,
                                                                  gpointer self);
static void _spice_gradient_editor___lambda35_ (SpiceGradientEditor* self);
VALA_EXTERN SpiceGradientGradientStep* spice_gradient_gradient_step_new (const gchar* _color,
                                                             const gchar* _percent);
VALA_EXTERN SpiceGradientGradientStep* spice_gradient_gradient_step_construct (GType object_type,
                                                                   const gchar* _color,
                                                                   const gchar* _percent);
static void __spice_gradient_editor___lambda35__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _spice_gradient_editor___lambda36_ (SpiceGradientEditor* self);
static void _g_object_unref0_ (gpointer var);
static void __spice_gradient_editor___lambda36__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void spice_gradient_editor_finalize (GObject * obj);
static GType spice_gradient_editor_get_type_once (void);
static void _vala_spice_gradient_editor_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_spice_gradient_editor_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
spice_gradient_editor_get_instance_private (SpiceGradientEditor* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceGradientEditor_private_offset);
}

SpiceGradientEditor*
spice_gradient_editor_construct (GType object_type,
                                 SpiceColorChooser* _color_picker)
{
	SpiceGradientEditor * self = NULL;
#line 68 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (_color_picker != NULL, NULL);
#line 68 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = (SpiceGradientEditor*) g_object_new (object_type, NULL);
#line 69 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->color_picker = _color_picker;
#line 68 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return self;
#line 446 "GradientEditor.c"
}

SpiceGradientEditor*
spice_gradient_editor_new (SpiceColorChooser* _color_picker)
{
#line 68 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return spice_gradient_editor_construct (SPICE_TYPE_GRADIENT_EDITOR, _color_picker);
#line 454 "GradientEditor.c"
}

void
spice_gradient_editor_set_color (SpiceGradientEditor* self,
                                 const gchar* color,
                                 gboolean override)
{
	SpiceGradientGradientStep* _tmp0_;
	SpiceGradientGradientStep* _tmp1_;
#line 154 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 154 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (color != NULL);
#line 155 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (override) {
#line 156 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_parse_gradient (self, color, FALSE);
#line 157 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		return;
#line 474 "GradientEditor.c"
	}
#line 160 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = spice_gradient_editor_get_selected_step (self);
#line 160 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = _tmp0_;
#line 160 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (_tmp1_ != NULL) {
#line 482 "GradientEditor.c"
		SpiceGradientGradientStep* _tmp2_;
		SpiceGradientGradientStep* _tmp3_;
#line 161 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp2_ = spice_gradient_editor_get_selected_step (self);
#line 161 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp3_ = _tmp2_;
#line 161 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_gradient_step_set_color (_tmp3_, color);
#line 491 "GradientEditor.c"
	}
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_atomic_int_inc (&_data20_->_ref_count_);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return _data20_;
#line 502 "GradientEditor.c"
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
#line 512 "GradientEditor.c"
		SpiceGradientEditor* self;
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		self = _data20_->self;
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (_data20_->first_step);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (_data20_->first_nub);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (self);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_slice_free (Block20Data, _data20_);
#line 524 "GradientEditor.c"
	}
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_atomic_int_inc (&_data21_->_ref_count_);
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return _data21_;
#line 535 "GradientEditor.c"
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
#line 545 "GradientEditor.c"
		SpiceGradientEditor* self;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		self = _data21_->_data20_->self;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (_data21_->nub);
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		block20_data_unref (_data21_->_data20_);
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_data21_->_data20_ = NULL;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_slice_free (Block21Data, _data21_);
#line 557 "GradientEditor.c"
	}
}

static void
__lambda33_ (Block21Data* _data21_)
{
	Block20Data* _data20_;
	SpiceGradientEditor* self;
	gint index = 0;
	SpiceGradient* _tmp0_;
	GList* _tmp1_;
	SpiceGradientEditorGradientNub* _tmp2_;
	SpiceGradientGradientStep* _tmp3_;
	SpiceGradientGradientStep* _tmp4_;
	SpiceGradientEditorGradientNub* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	SpiceGradientEditorGradientNub* _tmp8_;
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_ = _data21_->_data20_;
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = _data20_->self;
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_gradient;
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = _tmp0_->steps;
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = _data21_->nub;
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp3_ = spice_gradient_editor_gradient_nub_get_step (_tmp2_);
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp4_ = _tmp3_;
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	index = g_list_index (_tmp1_, _tmp4_);
#line 180 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp5_ = _data21_->nub;
#line 180 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp6_ = spice_color_button_get_color ((SpiceColorButton*) _tmp5_);
#line 180 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp7_ = _tmp6_;
#line 180 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_emit (self, spice_gradient_editor_signals[SPICE_GRADIENT_EDITOR_COLOR_SELECTED_SIGNAL], 0, index + 1, _tmp7_);
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp8_ = _data21_->nub;
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_set_selected_nub (self, _tmp8_);
#line 604 "GradientEditor.c"
}

static void
___lambda33__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	__lambda33_ (self);
#line 613 "GradientEditor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 185 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return self ? g_object_ref (self) : NULL;
#line 621 "GradientEditor.c"
}

static void
__lambda32_ (Block20Data* _data20_,
             SpiceGradientGradientStep* item)
{
	SpiceGradientEditor* self;
	Block21Data* _data21_;
	gint _tmp0_;
	SpiceGradientEditorGradientMaker* _tmp1_;
	SpiceGradientEditorGradientNub* _tmp2_;
	SpiceGradientEditorGradientNub* _tmp3_;
	SpiceGradientGradientStep* _tmp4_;
	SpiceGradientEditorGradientMaker* _tmp7_;
	SpiceGradientEditorGradientNub* _tmp8_;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = _data20_->self;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (item != NULL);
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data21_ = g_slice_new0 (Block21Data);
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data21_->_ref_count_ = 1;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data21_->_data20_ = block20_data_ref (_data20_);
#line 176 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = _data20_->step_count;
#line 176 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_->step_count = _tmp0_ + 1;
#line 177 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = self->priv->editor;
#line 177 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = spice_gradient_editor_gradient_nub_new (self, item, _tmp1_);
#line 177 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp2_);
#line 177 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data21_->nub = _tmp2_;
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp3_ = _data21_->nub;
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_connect_data ((GtkButton*) _tmp3_, "clicked", (GCallback) ___lambda33__gtk_button_clicked, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
#line 184 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp4_ = _data20_->first_step;
#line 184 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (item == _tmp4_) {
#line 667 "GradientEditor.c"
		SpiceGradientEditorGradientNub* _tmp5_;
		SpiceGradientEditorGradientNub* _tmp6_;
#line 185 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp5_ = _data21_->nub;
#line 185 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 185 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (_data20_->first_nub);
#line 185 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_data20_->first_nub = _tmp6_;
#line 678 "GradientEditor.c"
	}
#line 188 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp7_ = self->priv->editor;
#line 188 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp8_ = _data21_->nub;
#line 188 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_overlay_add_overlay ((GtkOverlay*) _tmp7_, (GtkWidget*) _tmp8_);
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	block21_data_unref (_data21_);
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data21_ = NULL;
#line 690 "GradientEditor.c"
}

static void
___lambda32__gfunc (gconstpointer data,
                    gpointer self)
{
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	__lambda32_ (self, (SpiceGradientGradientStep*) data);
#line 699 "GradientEditor.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 718 "GradientEditor.c"
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
#line 1003 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 1004 "glib-2.0.vapi"
	result = g_ascii_strtod (str, NULL);
#line 1004 "glib-2.0.vapi"
	return result;
#line 731 "GradientEditor.c"
}

void
spice_gradient_editor_parse_gradient (SpiceGradientEditor* self,
                                      const gchar* color,
                                      gboolean force)
{
	Block20Data* _data20_;
	gboolean _tmp0_ = FALSE;
	SpiceGradient* _tmp3_;
	SpiceGradientEditorGradientMaker* _tmp4_;
	SpiceGradient* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	SpiceGradientEditorGradientMaker* _tmp8_;
	SpiceGradient* _tmp9_;
	SpiceGradientGradientStep* _tmp10_;
	SpiceGradient* _tmp11_;
	GList* _tmp12_;
	GtkButton* _tmp13_;
	SpiceGradientEditorGradientMaker* _tmp14_;
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (color != NULL);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_ = g_slice_new0 (Block20Data);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_->_ref_count_ = 1;
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_->self = g_object_ref (self);
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (!force) {
#line 765 "GradientEditor.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp1_ = spice_gradient_editor_make_gradient (self);
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp2_ = _tmp1_;
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, color) == 0;
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_free0 (_tmp2_);
#line 776 "GradientEditor.c"
	} else {
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp0_ = FALSE;
#line 780 "GradientEditor.c"
	}
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (_tmp0_) {
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		block20_data_unref (_data20_);
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_data20_ = NULL;
#line 166 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		return;
#line 790 "GradientEditor.c"
	}
#line 168 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp3_ = self->priv->_gradient;
#line 168 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_parse (_tmp3_, color);
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp4_ = self->priv->editor;
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp5_ = self->priv->_gradient;
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp6_ = spice_gradient_to_string (_tmp5_, TRUE);
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp7_ = _tmp6_;
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_gradient_maker_css_style (_tmp4_, _tmp7_);
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp7_);
#line 170 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp8_ = self->priv->editor;
#line 170 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_gradient_maker_clear_all (_tmp8_);
#line 172 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_->step_count = 0;
#line 173 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_->first_nub = NULL;
#line 174 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp9_ = self->priv->_gradient;
#line 174 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp10_ = spice_gradient_get_color (_tmp9_, 0);
#line 174 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_->first_step = _tmp10_;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp11_ = self->priv->_gradient;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp12_ = _tmp11_->steps;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_list_foreach (_tmp12_, ___lambda32__gfunc, _data20_);
#line 191 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp13_ = self->priv->remove_step;
#line 191 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, _data20_->step_count > 2);
#line 193 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp14_ = self->priv->editor;
#line 193 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp14_);
#line 195 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (string_contains (color, "to bottom")) {
#line 838 "GradientEditor.c"
		GtkScale* _tmp15_;
#line 196 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp15_ = self->priv->direction;
#line 196 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		gtk_range_set_value ((GtkRange*) _tmp15_, (gdouble) 180);
#line 844 "GradientEditor.c"
	} else {
#line 197 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		if (string_contains (color, "to right")) {
#line 848 "GradientEditor.c"
			GtkScale* _tmp16_;
#line 198 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			_tmp16_ = self->priv->direction;
#line 198 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			gtk_range_set_value ((GtkRange*) _tmp16_, (gdouble) 450);
#line 854 "GradientEditor.c"
		} else {
			GtkScale* _tmp17_;
			SpiceGradient* _tmp18_;
			const gchar* _tmp19_;
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			_tmp17_ = self->priv->direction;
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			_tmp18_ = self->priv->_gradient;
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			_tmp19_ = _tmp18_->direction;
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			gtk_range_set_value ((GtkRange*) _tmp17_, double_parse (_tmp19_));
#line 867 "GradientEditor.c"
		}
	}
#line 203 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (_data20_->step_count > 0) {
#line 872 "GradientEditor.c"
		SpiceGradientEditorGradientNub* _tmp20_;
#line 204 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp20_ = _data20_->first_nub;
#line 204 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_set_selected_nub (self, _tmp20_);
#line 878 "GradientEditor.c"
	}
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	block20_data_unref (_data20_);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data20_ = NULL;
#line 884 "GradientEditor.c"
}

gchar*
spice_gradient_editor_make_gradient (SpiceGradientEditor* self)
{
	SpiceGradientEditorGradientMaker* _tmp0_;
	SpiceGradient* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SpiceGradient* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
#line 208 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->editor;
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = self->priv->_gradient;
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = spice_gradient_to_string (_tmp1_, TRUE);
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp3_ = _tmp2_;
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_gradient_maker_css_style (_tmp0_, _tmp3_);
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp3_);
#line 210 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp4_ = self->priv->_gradient;
#line 210 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp5_ = spice_gradient_to_string (_tmp4_, FALSE);
#line 210 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = _tmp5_;
#line 210 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 919 "GradientEditor.c"
}

void
spice_gradient_editor_select_step_id (SpiceGradientEditor* self,
                                      gint step_id)
{
	SpiceGradientGradientStep* wanted_step = NULL;
	SpiceGradient* _tmp0_;
	SpiceGradientGradientStep* _tmp1_;
#line 213 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 214 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_gradient;
#line 214 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = spice_gradient_get_color (_tmp0_, step_id);
#line 214 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	wanted_step = _tmp1_;
#line 215 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_select_step (self, wanted_step);
#line 213 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (wanted_step);
#line 941 "GradientEditor.c"
}

void
spice_gradient_editor_select_step (SpiceGradientEditor* self,
                                   SpiceGradientGradientStep* wanted_step)
{
	SpiceGradientEditorGradientMaker* _tmp0_;
	GList* _tmp1_;
#line 218 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 218 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (wanted_step != NULL);
#line 219 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->editor;
#line 219 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 958 "GradientEditor.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 219 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		item_collection = _tmp1_;
#line 219 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 966 "GradientEditor.c"
			GtkWidget* item = NULL;
#line 219 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			item = (GtkWidget*) item_it->data;
#line 970 "GradientEditor.c"
			{
				GtkWidget* _tmp2_;
#line 220 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
				_tmp2_ = item;
#line 220 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
				if (SPICE_GRADIENT_EDITOR_IS_GRADIENT_NUB (_tmp2_)) {
#line 977 "GradientEditor.c"
					SpiceGradientEditorGradientNub* nub = NULL;
					GtkWidget* _tmp3_;
					SpiceGradientEditorGradientNub* _tmp4_;
					SpiceGradientEditorGradientNub* _tmp5_;
					SpiceGradientGradientStep* _tmp6_;
					SpiceGradientGradientStep* _tmp7_;
#line 221 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					_tmp3_ = item;
#line 221 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					_tmp4_ = _g_object_ref0 (SPICE_GRADIENT_EDITOR_IS_GRADIENT_NUB (_tmp3_) ? ((SpiceGradientEditorGradientNub*) _tmp3_) : NULL);
#line 221 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					nub = _tmp4_;
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					_tmp5_ = nub;
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					_tmp6_ = spice_gradient_editor_gradient_nub_get_step (_tmp5_);
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					_tmp7_ = _tmp6_;
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					if (spice_gradient_gradient_step_equals (_tmp7_, wanted_step)) {
#line 998 "GradientEditor.c"
						SpiceGradientEditorGradientNub* _tmp8_;
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
						_tmp8_ = nub;
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
						spice_gradient_editor_set_selected_nub (self, _tmp8_);
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
						_g_object_unref0 (nub);
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
						(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
						return;
#line 1010 "GradientEditor.c"
					}
#line 220 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					_g_object_unref0 (nub);
#line 1014 "GradientEditor.c"
				}
			}
		}
#line 219 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
#line 1020 "GradientEditor.c"
	}
}

const gchar*
spice_gradient_editor_get_gradient_color (SpiceGradientEditor* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_gradient_color;
#line 28 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = _tmp0_;
#line 28 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1037 "GradientEditor.c"
}

void
spice_gradient_editor_set_gradient_color (SpiceGradientEditor* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
#line 29 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = g_strdup (value);
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (self->priv->_gradient_color);
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->_gradient_color = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_parse_gradient (self, value, FALSE);
#line 29 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_gradient_editor_properties[SPICE_GRADIENT_EDITOR_GRADIENT_COLOR_PROPERTY]);
#line 1057 "GradientEditor.c"
}

static SpiceGradientEditorGradientNub*
spice_gradient_editor_get_selected_nub (SpiceGradientEditor* self)
{
	SpiceGradientEditorGradientNub* result;
	SpiceGradientEditorGradientNub* _tmp0_;
#line 37 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_selected_nub;
#line 38 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = _tmp0_;
#line 38 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1073 "GradientEditor.c"
}

static void
spice_gradient_editor_set_selected_nub (SpiceGradientEditor* self,
                                        SpiceGradientEditorGradientNub* value)
{
	SpiceGradientEditorGradientNub* _tmp0_;
	SpiceGradientEditorGradientNub* _tmp2_;
#line 39 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 40 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_selected_nub;
#line 40 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (_tmp0_ != NULL) {
#line 1088 "GradientEditor.c"
		SpiceGradientEditorGradientNub* _tmp1_;
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp1_ = self->priv->_selected_nub;
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_gradient_nub_set_selected (_tmp1_, FALSE);
#line 1094 "GradientEditor.c"
	}
#line 44 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = _g_object_ref0 (value);
#line 44 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->_selected_nub);
#line 44 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->_selected_nub = _tmp2_;
#line 45 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (value != NULL) {
#line 46 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_gradient_nub_set_selected (value, TRUE);
#line 1106 "GradientEditor.c"
	}
}

SpiceGradientGradientStep*
spice_gradient_editor_get_selected_step (SpiceGradientEditor* self)
{
	SpiceGradientGradientStep* result;
	SpiceGradientEditorGradientNub* _tmp0_;
	SpiceGradientGradientStep* _tmp1_;
	SpiceGradientGradientStep* _tmp2_;
#line 52 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_selected_nub;
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = spice_gradient_editor_gradient_nub_get_step (_tmp0_);
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = _tmp1_;
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = _tmp2_;
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1129 "GradientEditor.c"
}

SpiceGradient*
spice_gradient_editor_get_gradient (SpiceGradientEditor* self)
{
	SpiceGradient* result;
	SpiceGradient* _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_gradient;
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1145 "GradientEditor.c"
}

static void
spice_gradient_editor_set_gradient (SpiceGradientEditor* self,
                                    SpiceGradient* value)
{
	SpiceGradient* old_value;
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	old_value = spice_gradient_editor_get_gradient (self);
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (old_value != value) {
#line 1159 "GradientEditor.c"
		SpiceGradient* _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (self->priv->_gradient);
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		self->priv->_gradient = _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_gradient_editor_properties[SPICE_GRADIENT_EDITOR_GRADIENT_PROPERTY]);
#line 1169 "GradientEditor.c"
	}
}

static void
g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (n_param_values == 3);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		data1 = closure->data;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		data2 = param_values->data[0].v_pointer;
#line 1195 "GradientEditor.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		data1 = param_values->data[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		data2 = closure->data;
#line 1201 "GradientEditor.c"
	}
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 1207 "GradientEditor.c"
}

static inline gpointer
spice_gradient_editor_gradient_nub_get_instance_private (SpiceGradientEditorGradientNub* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceGradientEditorGradientNub_private_offset);
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_atomic_int_inc (&_data22_->_ref_count_);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return _data22_;
#line 1223 "GradientEditor.c"
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
#line 1233 "GradientEditor.c"
		SpiceGradientEditorGradientNub* self;
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		self = _data22_->self;
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (_data22_->step);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (self);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_slice_free (Block22Data, _data22_);
#line 1243 "GradientEditor.c"
	}
}

static void
__lambda28_ (Block22Data* _data22_)
{
	SpiceGradientEditorGradientNub* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 264 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = _data22_->self;
#line 265 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = spice_gradient_gradient_step_get_color (_data22_->step);
#line 265 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = _tmp0_;
#line 265 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_color_button_set_color ((SpiceColorButton*) self, _tmp1_);
#line 1261 "GradientEditor.c"
}

static void
___lambda28__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 264 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	__lambda28_ (self);
#line 1271 "GradientEditor.c"
}

static void
__lambda29_ (SpiceGradientEditorGradientNub* self)
{
#line 269 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_queue_resize_no_redraw ((GtkWidget*) self);
#line 1279 "GradientEditor.c"
}

static void
___lambda29__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 268 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	__lambda29_ ((SpiceGradientEditorGradientNub*) self);
#line 1289 "GradientEditor.c"
}

static SpiceGradientEditorGradientNub*
spice_gradient_editor_gradient_nub_construct (GType object_type,
                                              SpiceGradientEditor* editor,
                                              SpiceGradientGradientStep* step,
                                              SpiceGradientEditorGradientMaker* maker)
{
	SpiceGradientEditorGradientNub * self = NULL;
	Block22Data* _data22_;
	SpiceGradientGradientStep* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (editor != NULL, NULL);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (step != NULL, NULL);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (maker != NULL, NULL);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data22_ = g_slice_new0 (Block22Data);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data22_->_ref_count_ = 1;
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = _g_object_ref0 (step);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (_data22_->step);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data22_->step = _tmp0_;
#line 251 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = spice_gradient_gradient_step_get_color (_data22_->step);
#line 251 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = _tmp1_;
#line 251 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = (SpiceGradientEditorGradientNub*) g_object_new (object_type, "color", _tmp2_, NULL);
#line 251 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data22_->self = g_object_ref (self);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_style_context_add_class (_tmp3_, "circular");
#line 254 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 254 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_style_context_add_class (_tmp4_, "gradient");
#line 255 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
#line 258 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_gradient_nub_set_step (self, _data22_->step);
#line 259 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->maker = maker;
#line 260 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->editor = editor;
#line 262 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_color_button_set_size ((SpiceColorButton*) self, 16, 16);
#line 264 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_connect_data ((GObject*) _data22_->step, "notify::color", (GCallback) ___lambda28__g_object_notify, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
#line 268 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_connect_object ((GObject*) _data22_->step, "notify::percent", (GCallback) ___lambda29__g_object_notify, self, 0);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	block22_data_unref (_data22_);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_data22_ = NULL;
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return self;
#line 1359 "GradientEditor.c"
}

static SpiceGradientEditorGradientNub*
spice_gradient_editor_gradient_nub_new (SpiceGradientEditor* editor,
                                        SpiceGradientGradientStep* step,
                                        SpiceGradientEditorGradientMaker* maker)
{
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return spice_gradient_editor_gradient_nub_construct (SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB, editor, step, maker);
#line 1369 "GradientEditor.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1391 "GradientEditor.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1395 "GradientEditor.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1401 "GradientEditor.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1405 "GradientEditor.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1409 "GradientEditor.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1417 "GradientEditor.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1445 "GradientEditor.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1454 "GradientEditor.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1468 "GradientEditor.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1477 "GradientEditor.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1491 "GradientEditor.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1500 "GradientEditor.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1509 "GradientEditor.c"
}

static gboolean
spice_gradient_editor_gradient_nub_real_button_press_event (GtkWidget* base,
                                                            GdkEventButton* event)
{
	SpiceGradientEditorGradientNub * self;
	SpiceGradientGradientStep* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean result;
#line 273 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = (SpiceGradientEditorGradientNub*) base;
#line 273 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 274 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_button_clicked ((GtkButton*) self);
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->start_y = event->y_root;
#line 276 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_step;
#line 276 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = spice_gradient_gradient_step_get_percent (_tmp0_);
#line 276 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = _tmp1_;
#line 276 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp3_ = string_replace (_tmp2_, "%", "");
#line 276 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp4_ = _tmp3_;
#line 276 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->start_value = double_parse (_tmp4_);
#line 276 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp4_);
#line 277 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->holding = TRUE;
#line 278 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = FALSE;
#line 278 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1551 "GradientEditor.c"
}

static gboolean
spice_gradient_editor_gradient_nub_real_motion_notify_event (GtkWidget* base,
                                                             GdkEventMotion* event)
{
	SpiceGradientEditorGradientNub * self;
	gint percent = 0;
	GtkContainer* _tmp0_;
	GtkContainer* _tmp1_;
	SpiceGradientGradientStep* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SpiceGradientEditor* _tmp7_;
	gboolean result;
#line 281 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = (SpiceGradientEditorGradientNub*) base;
#line 281 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 282 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (!self->priv->holding) {
#line 282 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		result = FALSE;
#line 282 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		return result;
#line 1579 "GradientEditor.c"
	}
#line 284 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
#line 284 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = _tmp0_;
#line 284 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	percent = (gint) (self->start_value + (((event->y_root - self->start_y) / (gtk_widget_get_allocated_height ((GtkWidget*) _tmp1_) - gtk_widget_get_allocated_height ((GtkWidget*) self))) * 100));
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = self->priv->_step;
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp3_ = g_strdup_printf ("%i", CLAMP (percent, 0, 100));
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp4_ = _tmp3_;
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp5_ = g_strconcat (_tmp4_, "%", NULL);
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp6_ = _tmp5_;
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_gradient_step_set_percent (_tmp2_, _tmp6_);
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp6_);
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp4_);
#line 286 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_queue_resize_no_redraw ((GtkWidget*) self);
#line 287 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp7_ = self->editor;
#line 287 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_emit (_tmp7_, spice_gradient_editor_signals[SPICE_GRADIENT_EDITOR_UPDATED_SIGNAL], 0);
#line 288 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = FALSE;
#line 288 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1613 "GradientEditor.c"
}

static gboolean
spice_gradient_editor_gradient_nub_real_button_release_event (GtkWidget* base,
                                                              GdkEventButton* event)
{
	SpiceGradientEditorGradientNub * self;
	gboolean result;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = (SpiceGradientEditorGradientNub*) base;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 292 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->holding = FALSE;
#line 293 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = FALSE;
#line 293 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1632 "GradientEditor.c"
}

static SpiceGradientGradientStep*
spice_gradient_editor_gradient_nub_get_step (SpiceGradientEditorGradientNub* self)
{
	SpiceGradientGradientStep* result;
	SpiceGradientGradientStep* _tmp0_;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_step;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = _tmp0_;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1648 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_nub_set_step (SpiceGradientEditorGradientNub* self,
                                             SpiceGradientGradientStep* value)
{
	SpiceGradientGradientStep* old_value;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	old_value = spice_gradient_editor_gradient_nub_get_step (self);
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (old_value != value) {
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		self->priv->_step = value;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_gradient_editor_gradient_nub_properties[SPICE_GRADIENT_EDITOR_GRADIENT_NUB_STEP_PROPERTY]);
#line 1666 "GradientEditor.c"
	}
}

static gint
spice_gradient_editor_gradient_nub_get_delta_y (SpiceGradientEditorGradientNub* self)
{
	gint result;
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = self->priv->_delta_y;
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 1680 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_nub_set_delta_y (SpiceGradientEditorGradientNub* self,
                                                gint value)
{
	gint old_value;
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	old_value = spice_gradient_editor_gradient_nub_get_delta_y (self);
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (old_value != value) {
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		self->priv->_delta_y = value;
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_gradient_editor_gradient_nub_properties[SPICE_GRADIENT_EDITOR_GRADIENT_NUB_DELTA_Y_PROPERTY]);
#line 1698 "GradientEditor.c"
	}
}

static void
spice_gradient_editor_gradient_nub_set_selected (SpiceGradientEditorGradientNub* self,
                                                 gboolean value)
{
#line 241 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 242 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (value) {
#line 1710 "GradientEditor.c"
		GtkStyleContext* _tmp0_;
#line 243 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 243 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		gtk_style_context_add_class (_tmp0_, "selected");
#line 1716 "GradientEditor.c"
	} else {
		GtkStyleContext* _tmp1_;
#line 245 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 245 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		gtk_style_context_remove_class (_tmp1_, "selected");
#line 1723 "GradientEditor.c"
	}
#line 241 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_gradient_editor_gradient_nub_properties[SPICE_GRADIENT_EDITOR_GRADIENT_NUB_SELECTED_PROPERTY]);
#line 1727 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_nub_class_init (SpiceGradientEditorGradientNubClass * klass,
                                               gpointer klass_data)
{
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_gradient_nub_parent_class = g_type_class_peek_parent (klass);
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_type_class_adjust_private_offset (klass, &SpiceGradientEditorGradientNub_private_offset);
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) spice_gradient_editor_gradient_nub_real_button_press_event;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) spice_gradient_editor_gradient_nub_real_motion_notify_event;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) spice_gradient_editor_gradient_nub_real_button_release_event;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_gradient_editor_gradient_nub_get_property;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_gradient_editor_gradient_nub_set_property;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_gradient_editor_gradient_nub_finalize;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_GRADIENT_EDITOR_GRADIENT_NUB_STEP_PROPERTY, spice_gradient_editor_gradient_nub_properties[SPICE_GRADIENT_EDITOR_GRADIENT_NUB_STEP_PROPERTY] = g_param_spec_object ("step", "step", "step", SPICE_GRADIENT_TYPE_GRADIENT_STEP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_GRADIENT_EDITOR_GRADIENT_NUB_DELTA_Y_PROPERTY, spice_gradient_editor_gradient_nub_properties[SPICE_GRADIENT_EDITOR_GRADIENT_NUB_DELTA_Y_PROPERTY] = g_param_spec_int ("delta-y", "delta-y", "delta-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_GRADIENT_EDITOR_GRADIENT_NUB_SELECTED_PROPERTY, spice_gradient_editor_gradient_nub_properties[SPICE_GRADIENT_EDITOR_GRADIENT_NUB_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
#line 1756 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_nub_instance_init (SpiceGradientEditorGradientNub * self,
                                                  gpointer klass)
{
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv = spice_gradient_editor_gradient_nub_get_instance_private (self);
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->_delta_y = 0;
#line 236 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->start_y = (gdouble) 0;
#line 237 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->start_value = (gdouble) 0;
#line 238 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->holding = FALSE;
#line 1773 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_nub_finalize (GObject * obj)
{
	SpiceGradientEditorGradientNub * self;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB, SpiceGradientEditorGradientNub);
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (spice_gradient_editor_gradient_nub_parent_class)->finalize (obj);
#line 1784 "GradientEditor.c"
}

static GType
spice_gradient_editor_gradient_nub_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceGradientEditorGradientNubClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_gradient_editor_gradient_nub_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceGradientEditorGradientNub), 0, (GInstanceInitFunc) spice_gradient_editor_gradient_nub_instance_init, NULL };
	GType spice_gradient_editor_gradient_nub_type_id;
	spice_gradient_editor_gradient_nub_type_id = g_type_register_static (SPICE_TYPE_COLOR_BUTTON, "SpiceGradientEditorGradientNub", &g_define_type_info, 0);
	SpiceGradientEditorGradientNub_private_offset = g_type_add_instance_private (spice_gradient_editor_gradient_nub_type_id, sizeof (SpiceGradientEditorGradientNubPrivate));
	return spice_gradient_editor_gradient_nub_type_id;
}

static GType
spice_gradient_editor_gradient_nub_get_type (void)
{
	static volatile gsize spice_gradient_editor_gradient_nub_type_id__once = 0;
	if (g_once_init_enter (&spice_gradient_editor_gradient_nub_type_id__once)) {
		GType spice_gradient_editor_gradient_nub_type_id;
		spice_gradient_editor_gradient_nub_type_id = spice_gradient_editor_gradient_nub_get_type_once ();
		g_once_init_leave (&spice_gradient_editor_gradient_nub_type_id__once, spice_gradient_editor_gradient_nub_type_id);
	}
	return spice_gradient_editor_gradient_nub_type_id__once;
}

static void
_vala_spice_gradient_editor_gradient_nub_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	SpiceGradientEditorGradientNub * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB, SpiceGradientEditorGradientNub);
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	switch (property_id) {
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_NUB_STEP_PROPERTY:
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_value_set_object (value, spice_gradient_editor_gradient_nub_get_step (self));
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_NUB_DELTA_Y_PROPERTY:
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_value_set_int (value, spice_gradient_editor_gradient_nub_get_delta_y (self));
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 1831 "GradientEditor.c"
		default:
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 1837 "GradientEditor.c"
	}
}

static void
_vala_spice_gradient_editor_gradient_nub_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	SpiceGradientEditorGradientNub * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB, SpiceGradientEditorGradientNub);
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	switch (property_id) {
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_NUB_STEP_PROPERTY:
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_gradient_nub_set_step (self, g_value_get_object (value));
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_NUB_DELTA_Y_PROPERTY:
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_gradient_nub_set_delta_y (self, g_value_get_int (value));
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_NUB_SELECTED_PROPERTY:
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_gradient_nub_set_selected (self, g_value_get_boolean (value));
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 1869 "GradientEditor.c"
		default:
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 1875 "GradientEditor.c"
	}
}

static inline gpointer
spice_gradient_editor_gradient_maker_get_instance_private (SpiceGradientEditorGradientMaker* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceGradientEditorGradientMaker_private_offset);
}

static void
spice_gradient_editor_gradient_maker_clear_all (SpiceGradientEditorGradientMaker* self)
{
	GList* _tmp0_;
#line 308 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 309 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 1893 "GradientEditor.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 309 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		item_collection = _tmp0_;
#line 309 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 1901 "GradientEditor.c"
			GtkWidget* item = NULL;
#line 309 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			item = (GtkWidget*) item_it->data;
#line 1905 "GradientEditor.c"
			{
				GtkWidget* _tmp1_;
#line 310 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
				_tmp1_ = item;
#line 310 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
				if (SPICE_GRADIENT_EDITOR_IS_GRADIENT_NUB (_tmp1_)) {
#line 1912 "GradientEditor.c"
					GtkWidget* _tmp2_;
#line 311 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					_tmp2_ = item;
#line 311 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
					gtk_widget_destroy (_tmp2_);
#line 1918 "GradientEditor.c"
				}
			}
		}
#line 309 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
#line 1924 "GradientEditor.c"
	}
}

static gboolean
spice_gradient_editor_gradient_maker_real_get_child_position (GtkOverlay* base,
                                                              GtkWidget* widget,
                                                              GdkRectangle* allocation)
{
	SpiceGradientEditorGradientMaker * self;
	GdkRectangle _vala_allocation = {0};
	gint height = 0;
	gboolean result;
#line 315 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = (SpiceGradientEditorGradientMaker*) base;
#line 315 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 316 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	memset (&_vala_allocation, 0, sizeof (GdkRectangle));
#line 317 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 319 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (SPICE_GRADIENT_EDITOR_IS_GRADIENT_NUB (widget)) {
#line 1947 "GradientEditor.c"
		SpiceGradientEditorGradientNub* nub = NULL;
		SpiceGradientEditorGradientNub* _tmp0_;
		gdouble percent = 0.0;
		SpiceGradientEditorGradientNub* _tmp1_;
		SpiceGradientGradientStep* _tmp2_;
		SpiceGradientGradientStep* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gdouble _tmp8_;
		gint w = 0;
		gint h = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 320 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_NUB, SpiceGradientEditorGradientNub));
#line 320 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		nub = _tmp0_;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp1_ = nub;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp2_ = spice_gradient_editor_gradient_nub_get_step (_tmp1_);
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp3_ = _tmp2_;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp4_ = spice_gradient_gradient_step_get_percent (_tmp3_);
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp5_ = _tmp4_;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp6_ = string_replace (_tmp5_, "%", "");
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp7_ = _tmp6_;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp8_ = double_parse (_tmp7_) / 100.0;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_free0 (_tmp7_);
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		percent = _tmp8_;
#line 324 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		gtk_widget_get_preferred_width (widget, &_tmp9_, NULL);
#line 324 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		w = _tmp9_;
#line 325 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		gtk_widget_get_preferred_height (widget, &_tmp10_, NULL);
#line 325 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		h = _tmp10_;
#line 326 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_vala_allocation.width = w;
#line 327 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_vala_allocation.height = h;
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_vala_allocation.x = 3;
#line 329 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_vala_allocation.y = (gint) ((height - h) * percent);
#line 330 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		result = TRUE;
#line 330 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (nub);
#line 330 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		if (allocation) {
#line 330 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			*allocation = _vala_allocation;
#line 2011 "GradientEditor.c"
		}
#line 330 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		return result;
#line 2015 "GradientEditor.c"
	}
#line 333 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	result = FALSE;
#line 333 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (allocation) {
#line 333 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		*allocation = _vala_allocation;
#line 2023 "GradientEditor.c"
	}
#line 333 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return result;
#line 2027 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_maker_css_style (SpiceGradientEditorGradientMaker* self,
                                                const gchar* style)
{
	gboolean _tmp0_ = FALSE;
#line 336 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (self != NULL);
#line 336 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_return_if_fail (style != NULL);
#line 337 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (string_contains (style, "gradient")) {
#line 337 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp0_ = string_contains (style, ",");
#line 2043 "GradientEditor.c"
	} else {
#line 337 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp0_ = FALSE;
#line 2047 "GradientEditor.c"
	}
#line 337 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (_tmp0_) {
#line 2051 "GradientEditor.c"
		GtkWidget* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 338 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp1_ = self->priv->grid;
#line 338 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp2_ = g_strdup_printf (SPICE_GRADIENT_EDITOR_GRADIENT_MAKER_STYLE, style);
#line 338 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp3_ = _tmp2_;
#line 338 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_utils_set_style (_tmp1_, _tmp3_);
#line 338 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_free0 (_tmp3_);
#line 2065 "GradientEditor.c"
	}
}

static SpiceGradientEditorGradientMaker*
spice_gradient_editor_gradient_maker_construct (GType object_type)
{
	SpiceGradientEditorGradientMaker * self = NULL;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = (SpiceGradientEditorGradientMaker*) g_object_new (object_type, NULL);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return self;
#line 2077 "GradientEditor.c"
}

static SpiceGradientEditorGradientMaker*
spice_gradient_editor_gradient_maker_new (void)
{
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return spice_gradient_editor_gradient_maker_construct (SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER);
#line 2085 "GradientEditor.c"
}

static GObject *
spice_gradient_editor_gradient_maker_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpiceGradientEditorGradientMaker * self;
	GtkEventBox* _tmp0_;
	GtkWidget* _tmp1_;
#line 300 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	parent_class = G_OBJECT_CLASS (spice_gradient_editor_gradient_maker_parent_class);
#line 300 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 300 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER, SpiceGradientEditorGradientMaker);
#line 301 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
#line 302 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
#line 303 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_set ((GtkWidget*) self, "width-request", 30, NULL);
#line 304 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
#line 304 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp0_);
#line 304 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->grid);
#line 304 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->grid = (GtkWidget*) _tmp0_;
#line 305 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = self->priv->grid;
#line 305 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_container_add ((GtkContainer*) self, _tmp1_);
#line 300 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return obj;
#line 2124 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_maker_class_init (SpiceGradientEditorGradientMakerClass * klass,
                                                 gpointer klass_data)
{
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_gradient_maker_parent_class = g_type_class_peek_parent (klass);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_type_class_adjust_private_offset (klass, &SpiceGradientEditorGradientMaker_private_offset);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	((GtkOverlayClass *) klass)->get_child_position = (gboolean (*) (GtkOverlay*, GtkWidget*, GdkRectangle*)) spice_gradient_editor_gradient_maker_real_get_child_position;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_gradient_editor_gradient_maker_constructor;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_gradient_editor_gradient_maker_finalize;
#line 2141 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_maker_instance_init (SpiceGradientEditorGradientMaker * self,
                                                    gpointer klass)
{
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv = spice_gradient_editor_gradient_maker_get_instance_private (self);
#line 2150 "GradientEditor.c"
}

static void
spice_gradient_editor_gradient_maker_finalize (GObject * obj)
{
	SpiceGradientEditorGradientMaker * self;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_GRADIENT_EDITOR_TYPE_GRADIENT_MAKER, SpiceGradientEditorGradientMaker);
#line 298 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->grid);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (spice_gradient_editor_gradient_maker_parent_class)->finalize (obj);
#line 2163 "GradientEditor.c"
}

static GType
spice_gradient_editor_gradient_maker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceGradientEditorGradientMakerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_gradient_editor_gradient_maker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceGradientEditorGradientMaker), 0, (GInstanceInitFunc) spice_gradient_editor_gradient_maker_instance_init, NULL };
	GType spice_gradient_editor_gradient_maker_type_id;
	spice_gradient_editor_gradient_maker_type_id = g_type_register_static (gtk_overlay_get_type (), "SpiceGradientEditorGradientMaker", &g_define_type_info, 0);
	SpiceGradientEditorGradientMaker_private_offset = g_type_add_instance_private (spice_gradient_editor_gradient_maker_type_id, sizeof (SpiceGradientEditorGradientMakerPrivate));
	return spice_gradient_editor_gradient_maker_type_id;
}

static GType
spice_gradient_editor_gradient_maker_get_type (void)
{
	static volatile gsize spice_gradient_editor_gradient_maker_type_id__once = 0;
	if (g_once_init_enter (&spice_gradient_editor_gradient_maker_type_id__once)) {
		GType spice_gradient_editor_gradient_maker_type_id;
		spice_gradient_editor_gradient_maker_type_id = spice_gradient_editor_gradient_maker_get_type_once ();
		g_once_init_leave (&spice_gradient_editor_gradient_maker_type_id__once, spice_gradient_editor_gradient_maker_type_id);
	}
	return spice_gradient_editor_gradient_maker_type_id__once;
}

static void
_spice_gradient_editor___lambda34_ (SpiceGradientEditor* self)
{
	SpiceGradient* _tmp0_;
	GtkScale* _tmp1_;
	gchar* _tmp2_;
#line 98 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = self->priv->_gradient;
#line 98 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = self->priv->direction;
#line 98 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = g_strdup_printf ("%ddeg", (gint) gtk_range_get_value ((GtkRange*) _tmp1_));
#line 98 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp0_->direction);
#line 98 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_->direction = _tmp2_;
#line 99 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_emit (self, spice_gradient_editor_signals[SPICE_GRADIENT_EDITOR_UPDATED_SIGNAL], 0);
#line 2206 "GradientEditor.c"
}

static void
__spice_gradient_editor___lambda34__gtk_range_value_changed (GtkRange* _sender,
                                                             gpointer self)
{
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_spice_gradient_editor___lambda34_ ((SpiceGradientEditor*) self);
#line 2215 "GradientEditor.c"
}

static void
_spice_gradient_editor___lambda35_ (SpiceGradientEditor* self)
{
	gchar* color = NULL;
	gchar* _tmp0_;
	gint percent = 0;
	SpiceGradientGradientStep* _tmp1_;
	SpiceGradientGradientStep* _tmp2_;
	SpiceGradientGradientStep* step = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	SpiceGradientGradientStep* _tmp22_;
	SpiceGradientGradientStep* _tmp23_;
	SpiceGradient* _tmp24_;
	SpiceGradientGradientStep* _tmp25_;
	SpiceGradientGradientStep* _tmp26_;
	SpiceGradient* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	SpiceGradientGradientStep* _tmp30_;
#line 114 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = g_strdup ("#df0000");
#line 114 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	color = _tmp0_;
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	percent = 50;
#line 117 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = spice_gradient_editor_get_selected_step (self);
#line 117 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = _tmp1_;
#line 117 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (_tmp2_ != NULL) {
#line 2253 "GradientEditor.c"
		SpiceGradientGradientStep* last = NULL;
		SpiceGradientGradientStep* _tmp3_;
		SpiceGradientGradientStep* _tmp4_;
		SpiceGradientGradientStep* _tmp5_;
		SpiceGradientGradientStep* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gint last_percent = 0;
		SpiceGradientGradientStep* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_ = 0;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp3_ = spice_gradient_editor_get_selected_step (self);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp4_ = _tmp3_;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		last = _tmp5_;
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp6_ = last;
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp7_ = spice_gradient_gradient_step_get_color (_tmp6_);
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp8_ = _tmp7_;
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_free0 (color);
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		color = _tmp9_;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp10_ = last;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp11_ = spice_gradient_gradient_step_get_percent (_tmp10_);
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp12_ = _tmp11_;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp13_ = string_replace (_tmp12_, "%", "");
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp14_ = _tmp13_;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp15_ = atoi (_tmp14_);
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_free0 (_tmp14_);
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		last_percent = _tmp15_;
#line 122 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		if (last_percent < 50) {
#line 122 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			_tmp16_ = last_percent + 25;
#line 2310 "GradientEditor.c"
		} else {
#line 122 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
			_tmp16_ = last_percent - 25;
#line 2314 "GradientEditor.c"
		}
#line 122 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		percent = _tmp16_;
#line 117 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_object_unref0 (last);
#line 2320 "GradientEditor.c"
	}
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp17_ = color;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp18_ = g_strdup_printf ("%i", percent);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp19_ = _tmp18_;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp20_ = g_strconcat (_tmp19_, "%", NULL);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp21_ = _tmp20_;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp22_ = spice_gradient_gradient_step_new (_tmp17_, _tmp21_);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp23_ = _tmp22_;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp21_);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp19_);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	step = _tmp23_;
#line 126 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp24_ = self->priv->_gradient;
#line 126 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp25_ = step;
#line 126 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp26_ = _g_object_ref0 (_tmp25_);
#line 126 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp24_->steps = g_list_append (_tmp24_->steps, _tmp26_);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp27_ = self->priv->_gradient;
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp28_ = spice_gradient_to_string (_tmp27_, FALSE);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp29_ = _tmp28_;
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_parse_gradient (self, _tmp29_, TRUE);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (_tmp29_);
#line 129 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_emit (self, spice_gradient_editor_signals[SPICE_GRADIENT_EDITOR_UPDATED_SIGNAL], 0);
#line 131 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp30_ = step;
#line 131 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_select_step (self, _tmp30_);
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (step);
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (color);
#line 2370 "GradientEditor.c"
}

static void
__spice_gradient_editor___lambda35__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_spice_gradient_editor___lambda35_ ((SpiceGradientEditor*) self);
#line 2379 "GradientEditor.c"
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
#line 5234 "glib-2.0.vapi"
	l = self;
#line 5235 "glib-2.0.vapi"
	while (TRUE) {
#line 2393 "GradientEditor.c"
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
#line 5235 "glib-2.0.vapi"
		_tmp0_ = l;
#line 5235 "glib-2.0.vapi"
		if (!(_tmp0_ != NULL)) {
#line 5235 "glib-2.0.vapi"
			break;
#line 2403 "GradientEditor.c"
		}
#line 5236 "glib-2.0.vapi"
		_tmp1_ = l;
#line 5236 "glib-2.0.vapi"
		_tmp2_ = ((GList*) _tmp1_)->data;
#line 5236 "glib-2.0.vapi"
		if (_tmp2_ != data) {
#line 2411 "GradientEditor.c"
			GList* _tmp3_;
			GList* _tmp4_;
#line 5237 "glib-2.0.vapi"
			_tmp3_ = l;
#line 5237 "glib-2.0.vapi"
			_tmp4_ = ((GList*) _tmp3_)->next;
#line 5237 "glib-2.0.vapi"
			l = _tmp4_;
#line 2420 "GradientEditor.c"
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
#line 5239 "glib-2.0.vapi"
			_tmp5_ = l;
#line 5239 "glib-2.0.vapi"
			_tmp6_ = ((GList*) _tmp5_)->data;
#line 5239 "glib-2.0.vapi"
			func (_tmp6_);
#line 5240 "glib-2.0.vapi"
			_tmp7_ = l;
#line 5240 "glib-2.0.vapi"
			self = g_list_delete_link (self, (GList*) _tmp7_);
#line 5241 "glib-2.0.vapi"
			break;
#line 2437 "GradientEditor.c"
		}
	}
#line 5244 "glib-2.0.vapi"
	result = self;
#line 5244 "glib-2.0.vapi"
	return result;
#line 2444 "GradientEditor.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2452 "GradientEditor.c"
}

static void
_spice_gradient_editor___lambda36_ (SpiceGradientEditor* self)
{
	SpiceGradientGradientStep* _tmp0_;
	SpiceGradientGradientStep* _tmp1_;
#line 135 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = spice_gradient_editor_get_selected_step (self);
#line 135 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = _tmp0_;
#line 135 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	if (_tmp1_ != NULL) {
#line 2466 "GradientEditor.c"
		SpiceGradient* _tmp2_;
		SpiceGradientGradientStep* _tmp3_;
		SpiceGradientGradientStep* _tmp4_;
		SpiceGradient* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp2_ = self->priv->_gradient;
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp3_ = spice_gradient_editor_get_selected_step (self);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp4_ = _tmp3_;
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp2_->steps = vala_g_list_remove_full (_tmp2_->steps, _tmp4_, _g_object_unref0_);
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp5_ = self->priv->_gradient;
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp6_ = spice_gradient_to_string (_tmp5_, FALSE);
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_tmp7_ = _tmp6_;
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_parse_gradient (self, _tmp7_, TRUE);
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		_g_free0 (_tmp7_);
#line 139 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_signal_emit (self, spice_gradient_editor_signals[SPICE_GRADIENT_EDITOR_UPDATED_SIGNAL], 0);
#line 2493 "GradientEditor.c"
	}
}

static void
__spice_gradient_editor___lambda36__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
#line 134 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_spice_gradient_editor___lambda36_ ((SpiceGradientEditor*) self);
#line 2503 "GradientEditor.c"
}

static GObject *
spice_gradient_editor_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpiceGradientEditor * self;
	SpiceGradient* _tmp0_;
	SpiceGradient* _tmp1_;
	GtkGrid* gradient_grid = NULL;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	SpiceGradientEditorGradientMaker* _tmp8_;
	GtkScale* _tmp9_;
	GtkScale* _tmp10_;
	GtkScale* _tmp11_;
	GtkScale* _tmp12_;
	GtkScale* _tmp13_;
	GtkScale* _tmp14_;
	GtkScale* _tmp15_;
	GtkScale* _tmp16_;
	GtkScale* _tmp17_;
	GtkScale* _tmp18_;
	GtkGrid* steps_grid = NULL;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkGrid* _tmp30_;
	GtkButton* _tmp31_;
	GtkGrid* _tmp32_;
	GtkButton* _tmp33_;
	GtkGrid* _tmp34_;
	GtkSeparator* _tmp35_;
	GtkSeparator* _tmp36_;
	GtkGrid* _tmp37_;
	SpiceGradientEditorGradientMaker* _tmp38_;
	GtkGrid* _tmp39_;
	GtkScale* _tmp40_;
	GtkGrid* _tmp41_;
	GtkGrid* _tmp42_;
	GtkGrid* _tmp43_;
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	parent_class = G_OBJECT_CLASS (spice_gradient_editor_parent_class);
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditor);
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp0_ = spice_gradient_new ();
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp1_ = _tmp0_;
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_set_gradient (self, _tmp1_);
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (_tmp1_);
#line 75 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_margin_top ((GtkWidget*) self, 6);
#line 77 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
#line 77 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp2_);
#line 77 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gradient_grid = _tmp2_;
#line 78 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp3_ = gradient_grid;
#line 78 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_grid_set_column_homogeneous (_tmp3_, FALSE);
#line 79 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp4_ = gradient_grid;
#line 79 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_grid_set_row_homogeneous (_tmp4_, FALSE);
#line 80 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp5_ = gradient_grid;
#line 80 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_grid_set_column_spacing (_tmp5_, 16);
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp6_ = gradient_grid;
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_grid_set_row_spacing (_tmp6_, 6);
#line 82 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp7_ = gradient_grid;
#line 82 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 6);
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp8_ = spice_gradient_editor_gradient_maker_new ();
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp8_);
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->editor);
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->editor = _tmp8_;
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp9_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_VERTICAL, (gdouble) 180, (gdouble) 540, (gdouble) 1);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp9_);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->direction);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->direction = _tmp9_;
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp10_ = self->priv->direction;
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _ ("Gradient Direction"));
#line 88 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp11_ = self->priv->direction;
#line 88 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp11_, TRUE);
#line 89 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp12_ = self->priv->direction;
#line 89 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_scale_set_draw_value (_tmp12_, FALSE);
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp13_ = self->priv->direction;
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_scale_add_mark (_tmp13_, (gdouble) 180, GTK_POS_RIGHT, "");
#line 92 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp14_ = self->priv->direction;
#line 92 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_scale_add_mark (_tmp14_, (gdouble) 270, GTK_POS_RIGHT, "");
#line 93 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp15_ = self->priv->direction;
#line 93 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_scale_add_mark (_tmp15_, (gdouble) 360, GTK_POS_RIGHT, "");
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp16_ = self->priv->direction;
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_scale_add_mark (_tmp16_, (gdouble) 450, GTK_POS_RIGHT, "");
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp17_ = self->priv->direction;
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_scale_add_mark (_tmp17_, (gdouble) 540, GTK_POS_RIGHT, "");
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp18_ = self->priv->direction;
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_connect_object ((GtkRange*) _tmp18_, "value-changed", (GCallback) __spice_gradient_editor___lambda34__gtk_range_value_changed, self, 0);
#line 102 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp19_ = (GtkGrid*) gtk_grid_new ();
#line 102 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp19_);
#line 102 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	steps_grid = _tmp19_;
#line 103 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp20_ = steps_grid;
#line 103 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
#line 103 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_style_context_add_class (_tmp21_, "linked");
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp22_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp22_);
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->add_step);
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->add_step = _tmp22_;
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp23_ = self->priv->add_step;
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp23_, _ ("Add color stop"));
#line 107 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp24_ = self->priv->add_step;
#line 107 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
#line 109 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp25_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 109 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp25_);
#line 109 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->remove_step);
#line 109 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv->remove_step = _tmp25_;
#line 110 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp26_ = self->priv->remove_step;
#line 110 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp26_, _ ("Remove color stop"));
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp27_ = self->priv->remove_step;
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp27_, TRUE);
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp28_ = self->priv->add_step;
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) __spice_gradient_editor___lambda35__gtk_button_clicked, self, 0);
#line 134 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp29_ = self->priv->remove_step;
#line 134 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_signal_connect_object (_tmp29_, "clicked", (GCallback) __spice_gradient_editor___lambda36__gtk_button_clicked, self, 0);
#line 143 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp30_ = steps_grid;
#line 143 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp31_ = self->priv->add_step;
#line 143 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
#line 144 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp32_ = steps_grid;
#line 144 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp33_ = self->priv->remove_step;
#line 144 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp34_ = gradient_grid;
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp35_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_ref_sink (_tmp35_);
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp36_ = _tmp35_;
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp36_, 0, 0, 1, 2);
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (_tmp36_);
#line 147 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp37_ = gradient_grid;
#line 147 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp38_ = self->priv->editor;
#line 147 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_grid_attach (_tmp37_, (GtkWidget*) _tmp38_, 1, 0, 1, 1);
#line 148 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp39_ = gradient_grid;
#line 148 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp40_ = self->priv->direction;
#line 148 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_grid_attach (_tmp39_, (GtkWidget*) _tmp40_, 2, 0, 1, 1);
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp41_ = gradient_grid;
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp42_ = steps_grid;
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 1, 1, 2, 1);
#line 151 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_tmp43_ = gradient_grid;
#line 151 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp43_);
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (steps_grid);
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (gradient_grid);
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	return obj;
#line 2758 "GradientEditor.c"
}

static void
spice_gradient_editor_class_init (SpiceGradientEditorClass * klass,
                                  gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_type_class_adjust_private_offset (klass, &SpiceGradientEditor_private_offset);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_gradient_editor_get_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_gradient_editor_set_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_gradient_editor_constructor;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_gradient_editor_finalize;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_GRADIENT_EDITOR_GRADIENT_COLOR_PROPERTY, spice_gradient_editor_properties[SPICE_GRADIENT_EDITOR_GRADIENT_COLOR_PROPERTY] = g_param_spec_string ("gradient-color", "gradient-color", "gradient-color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_GRADIENT_EDITOR_SELECTED_STEP_PROPERTY, spice_gradient_editor_properties[SPICE_GRADIENT_EDITOR_SELECTED_STEP_PROPERTY] = g_param_spec_object ("selected-step", "selected-step", "selected-step", SPICE_GRADIENT_TYPE_GRADIENT_STEP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_GRADIENT_EDITOR_GRADIENT_PROPERTY, spice_gradient_editor_properties[SPICE_GRADIENT_EDITOR_GRADIENT_PROPERTY] = g_param_spec_object ("gradient", "gradient", "gradient", SPICE_TYPE_GRADIENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_signals[SPICE_GRADIENT_EDITOR_UPDATED_SIGNAL] = g_signal_new ("updated", SPICE_TYPE_GRADIENT_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	spice_gradient_editor_signals[SPICE_GRADIENT_EDITOR_COLOR_SELECTED_SIGNAL] = g_signal_new ("color-selected", SPICE_TYPE_GRADIENT_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
#line 2787 "GradientEditor.c"
}

static void
spice_gradient_editor_instance_init (SpiceGradientEditor * self,
                                     gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self->priv = spice_gradient_editor_get_instance_private (self);
#line 2796 "GradientEditor.c"
}

static void
spice_gradient_editor_finalize (GObject * obj)
{
	SpiceGradientEditor * self;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditor);
#line 35 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->_selected_nub);
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->_gradient);
#line 59 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_free0 (self->priv->_gradient_color);
#line 62 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->editor);
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->direction);
#line 65 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->add_step);
#line 66 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	_g_object_unref0 (self->priv->remove_step);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	G_OBJECT_CLASS (spice_gradient_editor_parent_class)->finalize (obj);
#line 2821 "GradientEditor.c"
}

static GType
spice_gradient_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceGradientEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_gradient_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceGradientEditor), 0, (GInstanceInitFunc) spice_gradient_editor_instance_init, NULL };
	GType spice_gradient_editor_type_id;
	spice_gradient_editor_type_id = g_type_register_static (gtk_grid_get_type (), "SpiceGradientEditor", &g_define_type_info, 0);
	SpiceGradientEditor_private_offset = g_type_add_instance_private (spice_gradient_editor_type_id, sizeof (SpiceGradientEditorPrivate));
	return spice_gradient_editor_type_id;
}

GType
spice_gradient_editor_get_type (void)
{
	static volatile gsize spice_gradient_editor_type_id__once = 0;
	if (g_once_init_enter (&spice_gradient_editor_type_id__once)) {
		GType spice_gradient_editor_type_id;
		spice_gradient_editor_type_id = spice_gradient_editor_get_type_once ();
		g_once_init_leave (&spice_gradient_editor_type_id__once, spice_gradient_editor_type_id);
	}
	return spice_gradient_editor_type_id__once;
}

static void
_vala_spice_gradient_editor_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SpiceGradientEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditor);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_COLOR_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_value_set_string (value, spice_gradient_editor_get_gradient_color (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_SELECTED_STEP_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_value_set_object (value, spice_gradient_editor_get_selected_step (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		g_value_set_object (value, spice_gradient_editor_get_gradient (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 2874 "GradientEditor.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 2880 "GradientEditor.c"
	}
}

static void
_vala_spice_gradient_editor_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SpiceGradientEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditor);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_COLOR_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_set_gradient_color (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		case SPICE_GRADIENT_EDITOR_GRADIENT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		spice_gradient_editor_set_gradient (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 2906 "GradientEditor.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/GradientEditor.vala"
		break;
#line 2912 "GradientEditor.c"
	}
}

