/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt -i src/tools/roc_copy/cmdline.ggo -F cmdline --output-dir build/src/x86_64-pc-linux-gnu/gcc-14.1.1-release/tools/roc_copy --set-version 0.4.0 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: roc-copy OPTIONS";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "\nOptions:",
  "  -v, --verbose                 Increase verbosity level (may be used multiple\n                                  times)",
  "  -L, --list-supported          list supported schemes and formats",
  "  -i, --input=FILE_URI          Input file URI",
  "  -o, --output=FILE_URI         Output file URI",
  "      --input-format=FILE_FORMAT\n                                Force input file format",
  "      --output-format=FILE_FORMAT\n                                Force output file format",
  "      --frame-len=TIME          Duration of the internal frames, TIME units",
  "  -r, --rate=INT                Output sample rate, Hz",
  "      --resampler-backend=ENUM  Resampler backend  (possible\n                                  values=\"default\", \"builtin\", \"speex\",\n                                  \"speexdec\" default=`default')",
  "      --resampler-profile=ENUM  Resampler profile  (possible values=\"low\",\n                                  \"medium\", \"high\" default=`medium')",
  "      --profiling               Enable self profiling  (default=off)",
  "      --color=ENUM              Set colored logging mode for stderr output\n                                  (possible values=\"auto\", \"always\",\n                                  \"never\" default=`auto')",
  "\nFILE_URI defines an absolute or relative file path, e.g.:\n  file:///home/user/test.wav; file:./test.wav; file:-\n\nFILE_FORMAT is the output file format name, e.g.:\n  wav; ogg; mp3\n\nTIME is an integer or floating-point number with a suffix, e.g.:\n  123ns; 1.23us; 1.23ms; 1.23s; 1.23m; 1.23h;\n\nUse --list-supported option to print the list of the supported\nURI schemes and file formats.\n\nSee further details in roc-recv(1) manual page locally or online:\nhttps://roc-streaming.org/toolkit/docs/manuals/roc_copy.html",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_ENUM
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

const char *cmdline_parser_resampler_backend_values[] = {"default", "builtin", "speex", "speexdec", 0}; /*< Possible values for resampler-backend. */
const char *cmdline_parser_resampler_profile_values[] = {"low", "medium", "high", 0}; /*< Possible values for resampler-profile. */
const char *cmdline_parser_color_values[] = {"auto", "always", "never", 0}; /*< Possible values for color. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->list_supported_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->input_format_given = 0 ;
  args_info->output_format_given = 0 ;
  args_info->frame_len_given = 0 ;
  args_info->rate_given = 0 ;
  args_info->resampler_backend_given = 0 ;
  args_info->resampler_profile_given = 0 ;
  args_info->profiling_given = 0 ;
  args_info->color_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->input_arg = NULL;
  args_info->input_orig = NULL;
  args_info->output_arg = NULL;
  args_info->output_orig = NULL;
  args_info->input_format_arg = NULL;
  args_info->input_format_orig = NULL;
  args_info->output_format_arg = NULL;
  args_info->output_format_orig = NULL;
  args_info->frame_len_arg = NULL;
  args_info->frame_len_orig = NULL;
  args_info->rate_orig = NULL;
  args_info->resampler_backend_arg = resampler_backend_arg_default;
  args_info->resampler_backend_orig = NULL;
  args_info->resampler_profile_arg = resampler_profile_arg_medium;
  args_info->resampler_profile_orig = NULL;
  args_info->profiling_flag = 0;
  args_info->color_arg = color_arg_auto;
  args_info->color_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->verbose_help = gengetopt_args_info_help[3] ;
  args_info->verbose_min = 0;
  args_info->verbose_max = 0;
  args_info->list_supported_help = gengetopt_args_info_help[4] ;
  args_info->input_help = gengetopt_args_info_help[5] ;
  args_info->output_help = gengetopt_args_info_help[6] ;
  args_info->input_format_help = gengetopt_args_info_help[7] ;
  args_info->output_format_help = gengetopt_args_info_help[8] ;
  args_info->frame_len_help = gengetopt_args_info_help[9] ;
  args_info->rate_help = gengetopt_args_info_help[10] ;
  args_info->resampler_backend_help = gengetopt_args_info_help[11] ;
  args_info->resampler_profile_help = gengetopt_args_info_help[12] ;
  args_info->profiling_help = gengetopt_args_info_help[13] ;
  args_info->color_help = gengetopt_args_info_help[14] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->input_arg));
  free_string_field (&(args_info->input_orig));
  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->input_format_arg));
  free_string_field (&(args_info->input_format_orig));
  free_string_field (&(args_info->output_format_arg));
  free_string_field (&(args_info->output_format_orig));
  free_string_field (&(args_info->frame_len_arg));
  free_string_field (&(args_info->frame_len_orig));
  free_string_field (&(args_info->rate_orig));
  free_string_field (&(args_info->resampler_backend_orig));
  free_string_field (&(args_info->resampler_profile_orig));
  free_string_field (&(args_info->color_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  write_multiple_into_file(outfile, args_info->verbose_given, "verbose", 0, 0);
  if (args_info->list_supported_given)
    write_into_file(outfile, "list-supported", 0, 0 );
  if (args_info->input_given)
    write_into_file(outfile, "input", args_info->input_orig, 0);
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->input_format_given)
    write_into_file(outfile, "input-format", args_info->input_format_orig, 0);
  if (args_info->output_format_given)
    write_into_file(outfile, "output-format", args_info->output_format_orig, 0);
  if (args_info->frame_len_given)
    write_into_file(outfile, "frame-len", args_info->frame_len_orig, 0);
  if (args_info->rate_given)
    write_into_file(outfile, "rate", args_info->rate_orig, 0);
  if (args_info->resampler_backend_given)
    write_into_file(outfile, "resampler-backend", args_info->resampler_backend_orig, cmdline_parser_resampler_backend_values);
  if (args_info->resampler_profile_given)
    write_into_file(outfile, "resampler-profile", args_info->resampler_profile_orig, cmdline_parser_resampler_profile_values);
  if (args_info->profiling_given)
    write_into_file(outfile, "profiling", 0, 0 );
  if (args_info->color_given)
    write_into_file(outfile, "color", args_info->color_orig, cmdline_parser_color_values);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->verbose_given, args_info->verbose_min, args_info->verbose_max, "'--verbose' ('-v')"))
     error_occurred = 1;
  
  if (! args_info->input_given)
    {
      fprintf (stderr, "%s: '--input' ('-i') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  
  /* checks for dependences among options */

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_ENUM:
    if (val) *((int *)field) = found;
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "list-supported",	0, NULL, 'L' },
        { "input",	1, NULL, 'i' },
        { "output",	1, NULL, 'o' },
        { "input-format",	1, NULL, 0 },
        { "output-format",	1, NULL, 0 },
        { "frame-len",	1, NULL, 0 },
        { "rate",	1, NULL, 'r' },
        { "resampler-backend",	1, NULL, 0 },
        { "resampler-profile",	1, NULL, 0 },
        { "profiling",	0, NULL, 0 },
        { "color",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVvLi:o:r:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Increase verbosity level (may be used multiple times).  */
        
          local_args_info.verbose_given++;
        
          break;
        case 'L':	/* list supported schemes and formats.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->list_supported_given),
              &(local_args_info.list_supported_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "list-supported", 'L',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Input file URI.  */
        
        
          if (update_arg( (void *)&(args_info->input_arg), 
               &(args_info->input_orig), &(args_info->input_given),
              &(local_args_info.input_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "input", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Output file URI.  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Output sample rate, Hz.  */
        
        
          if (update_arg( (void *)&(args_info->rate_arg), 
               &(args_info->rate_orig), &(args_info->rate_given),
              &(local_args_info.rate_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "rate", 'r',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Force input file format.  */
          if (strcmp (long_options[option_index].name, "input-format") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->input_format_arg), 
                 &(args_info->input_format_orig), &(args_info->input_format_given),
                &(local_args_info.input_format_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "input-format", '-',
                additional_error))
              goto failure;
          
          }
          /* Force output file format.  */
          else if (strcmp (long_options[option_index].name, "output-format") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_format_arg), 
                 &(args_info->output_format_orig), &(args_info->output_format_given),
                &(local_args_info.output_format_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-format", '-',
                additional_error))
              goto failure;
          
          }
          /* Duration of the internal frames, TIME units.  */
          else if (strcmp (long_options[option_index].name, "frame-len") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->frame_len_arg), 
                 &(args_info->frame_len_orig), &(args_info->frame_len_given),
                &(local_args_info.frame_len_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "frame-len", '-',
                additional_error))
              goto failure;
          
          }
          /* Resampler backend.  */
          else if (strcmp (long_options[option_index].name, "resampler-backend") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->resampler_backend_arg), 
                 &(args_info->resampler_backend_orig), &(args_info->resampler_backend_given),
                &(local_args_info.resampler_backend_given), optarg, cmdline_parser_resampler_backend_values, "default", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "resampler-backend", '-',
                additional_error))
              goto failure;
          
          }
          /* Resampler profile.  */
          else if (strcmp (long_options[option_index].name, "resampler-profile") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->resampler_profile_arg), 
                 &(args_info->resampler_profile_orig), &(args_info->resampler_profile_given),
                &(local_args_info.resampler_profile_given), optarg, cmdline_parser_resampler_profile_values, "medium", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "resampler-profile", '-',
                additional_error))
              goto failure;
          
          }
          /* Enable self profiling.  */
          else if (strcmp (long_options[option_index].name, "profiling") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->profiling_flag), 0, &(args_info->profiling_given),
                &(local_args_info.profiling_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "profiling", '-',
                additional_error))
              goto failure;
          
          }
          /* Set colored logging mode for stderr output.  */
          else if (strcmp (long_options[option_index].name, "color") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->color_arg), 
                 &(args_info->color_orig), &(args_info->color_given),
                &(local_args_info.color_given), optarg, cmdline_parser_color_values, "auto", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "color", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  args_info->verbose_given += local_args_info.verbose_given;
  local_args_info.verbose_given = 0;
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
