// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A0__F202

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950)xyzw" };
#else
{ R"xyzw(amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_16_T_F_3_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx950)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x8acd0fb6u, 0x1c63d3c9u, 219, 16 }, // 8acd0fb61c63d3c9 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x67b6994bu, 0x12d919a0u, 219, 33 }, // 67b6994b12d919a0 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0xcce18e10u, 0x95b9e59du, 219, 50 }, // cce18e1095b9e59d = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_32_16_False__CO__wave4_warp2_stg1--Arch_gfx950
    { 0xf8aa3d3cu, 0x6e87a9aau, 235, 16 }, // f8aa3d3c6e87a9aa = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_64_32_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xd164fd25u, 0xef46cae0u, 235, 33 }, // d164fd25ef46cae0 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_64_32_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x1425d1c1u, 0x3f5f6e1eu, 235, 50 }, // 1425d1c13f5f6e1e = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_64_32_False__CO__wave4_warp2_stg1--Arch_gfx950
    { 0xb554e2cau, 0xfa87ea85u, 251, 116 }, // b554e2cafa87ea85 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_64_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x0d191ad4u, 0xea00dd58u, 251, 167 }, // 0d191ad4ea00dd58 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_64_64_False__CO__wave3_warp4_stg1--Arch_gfx950
    { 0x3f5dc035u, 0x5d2eeedbu, 251, 133 }, // 3f5dc0355d2eeedb = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_64_64_False__CO__wave4_warp4_stg1--Arch_gfx950
    { 0xa1d7bbb3u, 0x98c4b04bu, 267, 83 }, // a1d7bbb398c4b04b = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_128_64_False__CO__wave1_warp2_stg1--Arch_gfx950
    { 0xd4ec3692u, 0xe0d34297u, 267, 202 }, // d4ec3692e0d34297 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_128_64_False__CO__wave1_warp4_stg1--Arch_gfx950
    { 0x267c99a5u, 0x95bad803u, 267, 116 }, // 267c99a595bad803 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_128_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x11d252dfu, 0xf319e69au, 267, 167 }, // 11d252dff319e69a = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_128_64_False__CO__wave3_warp4_stg1--Arch_gfx950
    { 0x82a31ef0u, 0x35d225ffu, 284, 83 }, // 82a31ef035d225ff = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_128_128_False__CO__wave1_warp2_stg1--Arch_gfx950
    { 0x85547d37u, 0x1fe8dd16u, 284, 202 }, // 85547d371fe8dd16 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_128_128_False__CO__wave1_warp4_stg1--Arch_gfx950
    { 0x212a4936u, 0x9ffbe47au, 284, 116 }, // 212a49369ffbe47a = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_128_128_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0xe2d30d49u, 0xb618f3c1u, 284, 167 }, // e2d30d49b618f3c1 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊bf16@16_16_T_F_3_0___gfx950__P__2_2_128_128_False__CO__wave3_warp4_stg1--Arch_gfx950
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx950_mod0
{{ 2, 2, 1, 2, 2, 2, 2, 0, 2, 0},
 { 2, 1, 5, 5, 5, 4, 4, 3, 4, 3},
 { 3, 4, 7, 7, 6, 6, 7, 6, 8, 8},
 {12,11,11,14,15,14, 7, 7,14,15},
 {11,11,11,14,14,14,14,14,15,15},
 {11,11, 9,15,15,11,15,14,15,15},
 {11,11,11,14,15,15,11,15,15,15},
 {10,12,11,14,14,14,15,11,11,14},
 {12,11,10,13,15,15,15,15,13,13},
 { 9, 9,10,13,12,15,11,15,16,15}}
// End of GPU gfx950_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A0__F202 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 8;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 8;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 16
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 3
// Window_left = "i32"
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = "*i32"
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx950_mod0') AND inputs$Q_dtype = 'torch.bfloat16' AND inputs$BLOCK_DMODEL = 16 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = False AND inputs$CAUSAL_TYPE = 3 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

