/* base-screen-recorder.c generated by valac 0.56.17, the Vala compiler
 * generated from base-screen-recorder.vala, do not modify */

/*
Peek Copyright (c) 2017-2018 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PEEK_RECORDING_BASE_SCREEN_RECORDER_0_PROPERTY,
	PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_RECORDING_PROPERTY,
	PEEK_RECORDING_BASE_SCREEN_RECORDER_CONFIG_PROPERTY,
	PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_CANCELLING_PROPERTY,
	PEEK_RECORDING_BASE_SCREEN_RECORDER_ELAPSED_SECONDS_PROPERTY,
	PEEK_RECORDING_BASE_SCREEN_RECORDER_NUM_PROPERTIES
};
static GParamSpec* peek_recording_base_screen_recorder_properties[PEEK_RECORDING_BASE_SCREEN_RECORDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData;

struct _PeekRecordingBaseScreenRecorderPrivate {
	gboolean _is_recording;
	PeekRecordingRecordingConfig* _config;
	PeekPostProcessingPostProcessor* active_post_processor;
	gboolean _is_cancelling;
	gint64 start_time;
};

struct _PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PeekRecordingBaseScreenRecorder* self;
	PeekPostProcessingPostProcessingPipeline* pipeline;
	GFile* result;
	GArray* files;
	GArray* _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	PeekPostProcessingPostProcessor* _tmp4_;
	GArray* _tmp5_;
	GArray* _tmp6_;
	GArray* _tmp7_;
	GArray* _tmp8_;
	gboolean _tmp9_;
	GArray* _tmp10_;
	GArray* _tmp11_;
	GArray* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError* _inner_error0_;
};

static gint PeekRecordingBaseScreenRecorder_private_offset;
static gpointer peek_recording_base_screen_recorder_parent_class = NULL;
static PeekRecordingScreenRecorderIface * peek_recording_base_screen_recorder_peek_recording_screen_recorder_parent_iface = NULL;

static void peek_recording_base_screen_recorder_real_record (PeekRecordingScreenRecorder* base,
                                                      PeekRecordingRecordingArea* area,
                                                      GError** error);
static void peek_recording_base_screen_recorder_real_stop (PeekRecordingScreenRecorder* base);
static void peek_recording_base_screen_recorder_run_post_processors_async (PeekRecordingBaseScreenRecorder* self,
                                                                    PeekPostProcessingPostProcessingPipeline* pipeline,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static GFile* peek_recording_base_screen_recorder_run_post_processors_finish (PeekRecordingBaseScreenRecorder* self,
                                                                       GAsyncResult* _res_,
                                                                       GError** error);
static void __lambda22_ (PeekRecordingBaseScreenRecorder* self,
                  GObject* obj,
                  GAsyncResult* res);
static void peek_recording_base_screen_recorder_handle_postprocessing_failed (PeekRecordingBaseScreenRecorder* self,
                                                                       GError* reason);
static void ___lambda22__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void peek_recording_base_screen_recorder_real_cancel (PeekRecordingScreenRecorder* base);
static void peek_recording_base_screen_recorder_real_start_recording (PeekRecordingBaseScreenRecorder* self,
                                                               PeekRecordingRecordingArea* area,
                                                               GError** error);
static void peek_recording_base_screen_recorder_real_stop_recording (PeekRecordingBaseScreenRecorder* self);
static PeekPostProcessingPostProcessingPipeline* peek_recording_base_screen_recorder_real_build_post_processor_pipeline (PeekRecordingBaseScreenRecorder* self);
static void peek_recording_base_screen_recorder_run_post_processors_async_data_free (gpointer _data);
static gboolean peek_recording_base_screen_recorder_run_post_processors_async_co (PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData* _data_);
static void _g_object_unref0_ (gpointer var);
static void _vala_GFile_free_function_content_of (gpointer data);
static void peek_recording_base_screen_recorder_run_post_processors_async_ready (GObject* source_object,
                                                                          GAsyncResult* _res_,
                                                                          gpointer _user_data_);
static void peek_recording_base_screen_recorder_finalize (GObject * obj);
static GType peek_recording_base_screen_recorder_get_type_once (void);
static void _vala_peek_recording_base_screen_recorder_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_peek_recording_base_screen_recorder_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
peek_recording_base_screen_recorder_get_instance_private (PeekRecordingBaseScreenRecorder* self)
{
	return G_STRUCT_MEMBER_P (self, PeekRecordingBaseScreenRecorder_private_offset);
}

PeekRecordingBaseScreenRecorder*
peek_recording_base_screen_recorder_construct (GType object_type)
{
	PeekRecordingBaseScreenRecorder * self = NULL;
	PeekRecordingRecordingConfig* _tmp0_;
	PeekRecordingRecordingConfig* _tmp1_;
	self = (PeekRecordingBaseScreenRecorder*) g_object_new (object_type, NULL);
	_tmp0_ = peek_recording_recording_config_new ();
	_tmp1_ = _tmp0_;
	peek_recording_screen_recorder_set_config ((PeekRecordingScreenRecorder*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

static void
peek_recording_base_screen_recorder_real_record (PeekRecordingScreenRecorder* base,
                                                 PeekRecordingRecordingArea* area,
                                                 GError** error)
{
	PeekRecordingBaseScreenRecorder * self;
	PeekRecordingRecordingArea _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (PeekRecordingBaseScreenRecorder*) base;
	g_return_if_fail (area != NULL);
	peek_recording_screen_recorder_cancel ((PeekRecordingScreenRecorder*) self);
	_tmp0_ = *area;
	peek_recording_base_screen_recorder_start_recording (self, &_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PEEK_RECORDING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->start_time = g_get_monotonic_time ();
}

static void
peek_recording_base_screen_recorder_real_stop (PeekRecordingScreenRecorder* base)
{
	PeekRecordingBaseScreenRecorder * self;
	gint64 _tmp0_;
	gint64 _tmp1_;
	self = (PeekRecordingBaseScreenRecorder*) base;
	g_debug ("base-screen-recorder.vala:55: Recording stopped");
	_tmp0_ = peek_recording_screen_recorder_get_elapsed_seconds ((PeekRecordingScreenRecorder*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > ((gint64) 0)) {
		self->priv->_is_cancelling = FALSE;
		peek_recording_screen_recorder_set_is_recording ((PeekRecordingScreenRecorder*) self, FALSE);
		peek_recording_base_screen_recorder_stop_recording (self);
	} else {
		peek_recording_screen_recorder_cancel ((PeekRecordingScreenRecorder*) self);
	}
}

static void
__lambda22_ (PeekRecordingBaseScreenRecorder* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	g_debug ("base-screen-recorder.vala:70: Finished post processing");
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		_tmp0_ = peek_recording_base_screen_recorder_run_post_processors_finish (self, res, &_inner_error0_);
		file = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == PEEK_RECORDING_ERROR) {
				goto __catch0_peek_recording_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (file != NULL) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = g_file_get_path (file);
			_tmp2_ = _tmp1_;
			g_chmod (_tmp2_, 0644);
			_g_free0 (_tmp2_);
			g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-finished", file);
		} else {
			GError* reason = NULL;
			GError* _tmp3_;
			GError* _tmp4_;
			_tmp3_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_POSTPROCESSING_ABORTED, "Missing output file after post processing.");
			reason = _tmp3_;
			_tmp4_ = reason;
			peek_recording_base_screen_recorder_handle_postprocessing_failed (self, _tmp4_);
			_g_error_free0 (reason);
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_peek_recording_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		peek_recording_base_screen_recorder_handle_postprocessing_failed (self, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda22__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda22_ ((PeekRecordingBaseScreenRecorder*) self, source_object, res);
	g_object_unref (self);
}

void
peek_recording_base_screen_recorder_finalize_recording (PeekRecordingBaseScreenRecorder* self)
{
	PeekPostProcessingPostProcessingPipeline* pipeline = NULL;
	PeekPostProcessingPostProcessingPipeline* _tmp0_;
	g_return_if_fail (self != NULL);
	g_debug ("base-screen-recorder.vala:67: Started post processing");
	_tmp0_ = peek_recording_base_screen_recorder_build_post_processor_pipeline (self);
	pipeline = _tmp0_;
	peek_recording_base_screen_recorder_run_post_processors_async (self, pipeline, ___lambda22__gasync_ready_callback, g_object_ref (self));
	g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-postprocess-started");
	_g_object_unref0 (pipeline);
}

static void
peek_recording_base_screen_recorder_handle_postprocessing_failed (PeekRecordingBaseScreenRecorder* self,
                                                                  GError* reason)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_is_cancelling) {
		self->priv->_is_cancelling = FALSE;
		return;
	} else {
		g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-aborted", reason);
	}
}

static void
peek_recording_base_screen_recorder_real_cancel (PeekRecordingScreenRecorder* base)
{
	PeekRecordingBaseScreenRecorder * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (PeekRecordingBaseScreenRecorder*) base;
	self->priv->_is_cancelling = TRUE;
	self->priv->start_time = (gint64) 0;
	_tmp0_ = peek_recording_screen_recorder_get_is_recording ((PeekRecordingScreenRecorder*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		peek_recording_screen_recorder_set_is_recording ((PeekRecordingScreenRecorder*) self, FALSE);
		peek_recording_base_screen_recorder_stop_recording (self);
		peek_recording_base_screen_recorder_remove_temp_file (self);
		g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-aborted", NULL);
	} else {
		PeekPostProcessingPostProcessor* _tmp2_;
		_tmp2_ = self->priv->active_post_processor;
		if (_tmp2_ != NULL) {
			PeekPostProcessingPostProcessor* _tmp3_;
			_tmp3_ = self->priv->active_post_processor;
			peek_post_processing_post_processor_cancel (_tmp3_);
			_g_object_unref0 (self->priv->active_post_processor);
			self->priv->active_post_processor = NULL;
			g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-aborted", NULL);
		}
	}
}

static void
peek_recording_base_screen_recorder_real_start_recording (PeekRecordingBaseScreenRecorder* self,
                                                          PeekRecordingRecordingArea* area,
                                                          GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `peek_recording_base_screen_recorder_start_recording'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
peek_recording_base_screen_recorder_start_recording (PeekRecordingBaseScreenRecorder* self,
                                                     PeekRecordingRecordingArea* area,
                                                     GError** error)
{
	PeekRecordingBaseScreenRecorderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PEEK_RECORDING_BASE_SCREEN_RECORDER_GET_CLASS (self);
	if (_klass_->start_recording) {
		_klass_->start_recording (self, area, error);
	}
}

static void
peek_recording_base_screen_recorder_real_stop_recording (PeekRecordingBaseScreenRecorder* self)
{
	g_critical ("Type `%s' does not implement abstract method `peek_recording_base_screen_recorder_stop_recording'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
peek_recording_base_screen_recorder_stop_recording (PeekRecordingBaseScreenRecorder* self)
{
	PeekRecordingBaseScreenRecorderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PEEK_RECORDING_BASE_SCREEN_RECORDER_GET_CLASS (self);
	if (_klass_->stop_recording) {
		_klass_->stop_recording (self);
	}
}

static PeekPostProcessingPostProcessingPipeline*
peek_recording_base_screen_recorder_real_build_post_processor_pipeline (PeekRecordingBaseScreenRecorder* self)
{
	PeekPostProcessingPostProcessingPipeline* pipeline = NULL;
	PeekPostProcessingPostProcessingPipeline* _tmp0_;
	PeekRecordingRecordingConfig* _tmp1_;
	PeekRecordingRecordingConfig* _tmp2_;
	PeekOutputFormat _tmp3_;
	PeekOutputFormat _tmp4_;
	PeekPostProcessingPostProcessingPipeline* result;
	_tmp0_ = peek_post_processing_post_processing_pipeline_new ();
	pipeline = _tmp0_;
	_tmp1_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = peek_recording_recording_config_get_output_format (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PEEK_OUTPUT_FORMAT_GIF) {
		gboolean _tmp5_ = FALSE;
		PeekRecordingRecordingConfig* _tmp6_;
		PeekRecordingRecordingConfig* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = peek_recording_recording_config_get_gifski_enabled (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			_tmp5_ = peek_post_processing_gifski_post_processor_is_available ();
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			PeekPostProcessingPostProcessingPipeline* _tmp10_;
			PeekPostProcessingExtractFramesPostProcessor* _tmp11_;
			PeekPostProcessingExtractFramesPostProcessor* _tmp12_;
			PeekPostProcessingPostProcessingPipeline* _tmp13_;
			PeekRecordingRecordingConfig* _tmp14_;
			PeekRecordingRecordingConfig* _tmp15_;
			PeekPostProcessingGifskiPostProcessor* _tmp16_;
			PeekPostProcessingGifskiPostProcessor* _tmp17_;
			_tmp10_ = pipeline;
			_tmp11_ = peek_post_processing_extract_frames_post_processor_new ();
			_tmp12_ = _tmp11_;
			peek_post_processing_post_processing_pipeline_add (_tmp10_, (PeekPostProcessingPostProcessor*) _tmp12_);
			_g_object_unref0 (_tmp12_);
			_tmp13_ = pipeline;
			_tmp14_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
			_tmp15_ = _tmp14_;
			_tmp16_ = peek_post_processing_gifski_post_processor_new (_tmp15_);
			_tmp17_ = _tmp16_;
			peek_post_processing_post_processing_pipeline_add (_tmp13_, (PeekPostProcessingPostProcessor*) _tmp17_);
			_g_object_unref0 (_tmp17_);
		} else {
			if (peek_post_processing_ffmpeg_post_processor_is_available ()) {
				PeekPostProcessingPostProcessingPipeline* _tmp18_;
				PeekRecordingRecordingConfig* _tmp19_;
				PeekRecordingRecordingConfig* _tmp20_;
				PeekPostProcessingFfmpegPostProcessor* _tmp21_;
				PeekPostProcessingFfmpegPostProcessor* _tmp22_;
				_tmp18_ = pipeline;
				_tmp19_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
				_tmp20_ = _tmp19_;
				_tmp21_ = peek_post_processing_ffmpeg_post_processor_new (_tmp20_);
				_tmp22_ = _tmp21_;
				peek_post_processing_post_processing_pipeline_add (_tmp18_, (PeekPostProcessingPostProcessor*) _tmp22_);
				_g_object_unref0 (_tmp22_);
			}
		}
	} else {
		PeekRecordingRecordingConfig* _tmp23_;
		PeekRecordingRecordingConfig* _tmp24_;
		PeekOutputFormat _tmp25_;
		PeekOutputFormat _tmp26_;
		_tmp23_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp24_ = _tmp23_;
		_tmp25_ = peek_recording_recording_config_get_output_format (_tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == PEEK_OUTPUT_FORMAT_APNG) {
			PeekPostProcessingPostProcessingPipeline* _tmp27_;
			PeekRecordingRecordingConfig* _tmp28_;
			PeekRecordingRecordingConfig* _tmp29_;
			PeekPostProcessingFfmpegPostProcessor* _tmp30_;
			PeekPostProcessingFfmpegPostProcessor* _tmp31_;
			_tmp27_ = pipeline;
			_tmp28_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
			_tmp29_ = _tmp28_;
			_tmp30_ = peek_post_processing_ffmpeg_post_processor_new (_tmp29_);
			_tmp31_ = _tmp30_;
			peek_post_processing_post_processing_pipeline_add (_tmp27_, (PeekPostProcessingPostProcessor*) _tmp31_);
			_g_object_unref0 (_tmp31_);
		}
	}
	result = pipeline;
	return result;
}

PeekPostProcessingPostProcessingPipeline*
peek_recording_base_screen_recorder_build_post_processor_pipeline (PeekRecordingBaseScreenRecorder* self)
{
	PeekRecordingBaseScreenRecorderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PEEK_RECORDING_BASE_SCREEN_RECORDER_GET_CLASS (self);
	if (_klass_->build_post_processor_pipeline) {
		return _klass_->build_post_processor_pipeline (self);
	}
	return NULL;
}

static void
peek_recording_base_screen_recorder_run_post_processors_async_data_free (gpointer _data)
{
	PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->pipeline);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
peek_recording_base_screen_recorder_run_post_processors_async (PeekRecordingBaseScreenRecorder* self,
                                                               PeekPostProcessingPostProcessingPipeline* pipeline,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData* _data_;
	PeekRecordingBaseScreenRecorder* _tmp0_;
	PeekPostProcessingPostProcessingPipeline* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pipeline != NULL);
	_data_ = g_slice_new0 (PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, peek_recording_base_screen_recorder_run_post_processors_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (pipeline);
	_g_object_unref0 (_data_->pipeline);
	_data_->pipeline = _tmp1_;
	peek_recording_base_screen_recorder_run_post_processors_async_co (_data_);
}

static GFile*
peek_recording_base_screen_recorder_run_post_processors_finish (PeekRecordingBaseScreenRecorder* self,
                                                                GAsyncResult* _res_,
                                                                GError** error)
{
	GFile* result;
	PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_GFile_free_function_content_of (gpointer data)
{
	GFile* self;
	self = *((GFile**) data);
	_g_object_unref0_ (self);
}

static void
peek_recording_base_screen_recorder_run_post_processors_async_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_)
{
	PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	peek_recording_base_screen_recorder_run_post_processors_async_co (_data_);
}

static gboolean
peek_recording_base_screen_recorder_run_post_processors_async_co (PeekRecordingBaseScreenRecorderRunPostProcessorsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_array_new (TRUE, TRUE, sizeof (GFile*));
	g_array_set_clear_func (_data_->_tmp0_, (GDestroyNotify) _vala_GFile_free_function_content_of);
	_data_->files = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->files;
	_data_->_tmp2_ = _data_->self->temp_file;
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
	g_array_append_val (_data_->_tmp1_, _data_->_tmp3_);
	_data_->_tmp4_ = _g_object_ref0 ((PeekPostProcessingPostProcessor*) _data_->pipeline);
	_g_object_unref0 (_data_->self->priv->active_post_processor);
	_data_->self->priv->active_post_processor = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->files;
	_data_->_state_ = 1;
	peek_post_processing_post_processor_process_async ((PeekPostProcessingPostProcessor*) _data_->pipeline, _data_->_tmp6_, peek_recording_base_screen_recorder_run_post_processors_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = peek_post_processing_post_processor_process_finish ((PeekPostProcessingPostProcessor*) _data_->pipeline, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp5_ = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == PEEK_RECORDING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_array_unref0 (_data_->files);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_array_unref0 (_data_->files);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp8_ = _data_->_tmp5_;
	_data_->_tmp5_ = NULL;
	_g_array_unref0 (_data_->files);
	_data_->files = _data_->_tmp8_;
	_g_object_unref0 (_data_->self->priv->active_post_processor);
	_data_->self->priv->active_post_processor = NULL;
	_g_free0 (_data_->self->temp_file);
	_data_->self->temp_file = NULL;
	_data_->_tmp10_ = _data_->files;
	if (_data_->_tmp10_ == NULL) {
		_data_->_tmp9_ = TRUE;
	} else {
		_data_->_tmp11_ = _data_->files;
		_data_->_tmp9_ = _data_->_tmp11_->len == ((guint) 0);
	}
	if (_data_->_tmp9_) {
		_data_->result = NULL;
		_g_array_unref0 (_data_->_tmp5_);
		_g_array_unref0 (_data_->files);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->files;
	_data_->_tmp13_ = g_array_index (_data_->_tmp12_, GFile*, (guint) 0);
	_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
	_data_->result = _data_->_tmp14_;
	_g_array_unref0 (_data_->_tmp5_);
	_g_array_unref0 (_data_->files);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
peek_recording_base_screen_recorder_remove_temp_file (PeekRecordingBaseScreenRecorder* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->temp_file;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->temp_file;
		g_remove (_tmp1_);
		_g_free0 (self->temp_file);
		self->temp_file = NULL;
	}
}

static gboolean
peek_recording_base_screen_recorder_real_get_is_recording (PeekRecordingScreenRecorder* base)
{
	gboolean result;
	PeekRecordingBaseScreenRecorder* self;
	self = (PeekRecordingBaseScreenRecorder*) base;
	result = self->priv->_is_recording;
	return result;
}

static void
peek_recording_base_screen_recorder_real_set_is_recording (PeekRecordingScreenRecorder* base,
                                                           gboolean value)
{
	PeekRecordingBaseScreenRecorder* self;
	gboolean old_value;
	self = (PeekRecordingBaseScreenRecorder*) base;
	old_value = peek_recording_base_screen_recorder_real_get_is_recording (base);
	if (old_value != value) {
		self->priv->_is_recording = value;
		g_object_notify_by_pspec ((GObject *) self, peek_recording_base_screen_recorder_properties[PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_RECORDING_PROPERTY]);
	}
}

static PeekRecordingRecordingConfig*
peek_recording_base_screen_recorder_real_get_config (PeekRecordingScreenRecorder* base)
{
	PeekRecordingRecordingConfig* result;
	PeekRecordingBaseScreenRecorder* self;
	PeekRecordingRecordingConfig* _tmp0_;
	self = (PeekRecordingBaseScreenRecorder*) base;
	_tmp0_ = self->priv->_config;
	result = _tmp0_;
	return result;
}

static void
peek_recording_base_screen_recorder_real_set_config (PeekRecordingScreenRecorder* base,
                                                     PeekRecordingRecordingConfig* value)
{
	PeekRecordingBaseScreenRecorder* self;
	PeekRecordingRecordingConfig* old_value;
	self = (PeekRecordingBaseScreenRecorder*) base;
	old_value = peek_recording_base_screen_recorder_real_get_config (base);
	if (old_value != value) {
		PeekRecordingRecordingConfig* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_config);
		self->priv->_config = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, peek_recording_base_screen_recorder_properties[PEEK_RECORDING_BASE_SCREEN_RECORDER_CONFIG_PROPERTY]);
	}
}

gboolean
peek_recording_base_screen_recorder_get_is_cancelling (PeekRecordingBaseScreenRecorder* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_is_cancelling) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = peek_recording_screen_recorder_get_is_recording ((PeekRecordingScreenRecorder*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gint64
peek_recording_base_screen_recorder_real_get_elapsed_seconds (PeekRecordingScreenRecorder* base)
{
	gint64 result;
	PeekRecordingBaseScreenRecorder* self;
	gint64 now = 0LL;
	self = (PeekRecordingBaseScreenRecorder*) base;
	if (self->priv->start_time == ((gint64) 0)) {
		result = (gint64) 0;
		return result;
	}
	now = g_get_monotonic_time ();
	result = (now - self->priv->start_time) / 1000000;
	return result;
}

static void
peek_recording_base_screen_recorder_class_init (PeekRecordingBaseScreenRecorderClass * klass,
                                                gpointer klass_data)
{
	peek_recording_base_screen_recorder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PeekRecordingBaseScreenRecorder_private_offset);
	((PeekRecordingBaseScreenRecorderClass *) klass)->start_recording = (void (*) (PeekRecordingBaseScreenRecorder*, PeekRecordingRecordingArea*, GError**)) peek_recording_base_screen_recorder_real_start_recording;
	((PeekRecordingBaseScreenRecorderClass *) klass)->stop_recording = (void (*) (PeekRecordingBaseScreenRecorder*)) peek_recording_base_screen_recorder_real_stop_recording;
	((PeekRecordingBaseScreenRecorderClass *) klass)->build_post_processor_pipeline = (PeekPostProcessingPostProcessingPipeline* (*) (PeekRecordingBaseScreenRecorder*)) peek_recording_base_screen_recorder_real_build_post_processor_pipeline;
	G_OBJECT_CLASS (klass)->get_property = _vala_peek_recording_base_screen_recorder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_peek_recording_base_screen_recorder_set_property;
	G_OBJECT_CLASS (klass)->finalize = peek_recording_base_screen_recorder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_RECORDING_PROPERTY, peek_recording_base_screen_recorder_properties[PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_RECORDING_PROPERTY] = g_param_spec_boolean ("is-recording", "is-recording", "is-recording", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_RECORDING_BASE_SCREEN_RECORDER_CONFIG_PROPERTY, peek_recording_base_screen_recorder_properties[PEEK_RECORDING_BASE_SCREEN_RECORDER_CONFIG_PROPERTY] = g_param_spec_object ("config", "config", "config", PEEK_RECORDING_TYPE_RECORDING_CONFIG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_CANCELLING_PROPERTY, peek_recording_base_screen_recorder_properties[PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_CANCELLING_PROPERTY] = g_param_spec_boolean ("is-cancelling", "is-cancelling", "is-cancelling", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_RECORDING_BASE_SCREEN_RECORDER_ELAPSED_SECONDS_PROPERTY, peek_recording_base_screen_recorder_properties[PEEK_RECORDING_BASE_SCREEN_RECORDER_ELAPSED_SECONDS_PROPERTY] = g_param_spec_int64 ("elapsed-seconds", "elapsed-seconds", "elapsed-seconds", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
peek_recording_base_screen_recorder_peek_recording_screen_recorder_interface_init (PeekRecordingScreenRecorderIface * iface,
                                                                                   gpointer iface_data)
{
	peek_recording_base_screen_recorder_peek_recording_screen_recorder_parent_iface = g_type_interface_peek_parent (iface);
	iface->record = (void (*) (PeekRecordingScreenRecorder*, PeekRecordingRecordingArea*, GError**)) peek_recording_base_screen_recorder_real_record;
	iface->stop = (void (*) (PeekRecordingScreenRecorder*)) peek_recording_base_screen_recorder_real_stop;
	iface->cancel = (void (*) (PeekRecordingScreenRecorder*)) peek_recording_base_screen_recorder_real_cancel;
	iface->get_is_recording = peek_recording_base_screen_recorder_real_get_is_recording;
	iface->set_is_recording = peek_recording_base_screen_recorder_real_set_is_recording;
	iface->get_config = peek_recording_base_screen_recorder_real_get_config;
	iface->set_config = peek_recording_base_screen_recorder_real_set_config;
	iface->get_elapsed_seconds = peek_recording_base_screen_recorder_real_get_elapsed_seconds;
}

static void
peek_recording_base_screen_recorder_instance_init (PeekRecordingBaseScreenRecorder * self,
                                                   gpointer klass)
{
	self->priv = peek_recording_base_screen_recorder_get_instance_private (self);
	self->priv->active_post_processor = NULL;
	self->priv->start_time = (gint64) 0;
}

static void
peek_recording_base_screen_recorder_finalize (GObject * obj)
{
	PeekRecordingBaseScreenRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_RECORDING_TYPE_BASE_SCREEN_RECORDER, PeekRecordingBaseScreenRecorder);
	_g_free0 (self->temp_file);
	_g_object_unref0 (self->priv->_config);
	_g_object_unref0 (self->priv->active_post_processor);
	G_OBJECT_CLASS (peek_recording_base_screen_recorder_parent_class)->finalize (obj);
}

static GType
peek_recording_base_screen_recorder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PeekRecordingBaseScreenRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_recording_base_screen_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekRecordingBaseScreenRecorder), 0, (GInstanceInitFunc) peek_recording_base_screen_recorder_instance_init, NULL };
	static const GInterfaceInfo peek_recording_screen_recorder_info = { (GInterfaceInitFunc) peek_recording_base_screen_recorder_peek_recording_screen_recorder_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType peek_recording_base_screen_recorder_type_id;
	peek_recording_base_screen_recorder_type_id = g_type_register_static (G_TYPE_OBJECT, "PeekRecordingBaseScreenRecorder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (peek_recording_base_screen_recorder_type_id, PEEK_RECORDING_TYPE_SCREEN_RECORDER, &peek_recording_screen_recorder_info);
	PeekRecordingBaseScreenRecorder_private_offset = g_type_add_instance_private (peek_recording_base_screen_recorder_type_id, sizeof (PeekRecordingBaseScreenRecorderPrivate));
	return peek_recording_base_screen_recorder_type_id;
}

GType
peek_recording_base_screen_recorder_get_type (void)
{
	static volatile gsize peek_recording_base_screen_recorder_type_id__once = 0;
	if (g_once_init_enter (&peek_recording_base_screen_recorder_type_id__once)) {
		GType peek_recording_base_screen_recorder_type_id;
		peek_recording_base_screen_recorder_type_id = peek_recording_base_screen_recorder_get_type_once ();
		g_once_init_leave (&peek_recording_base_screen_recorder_type_id__once, peek_recording_base_screen_recorder_type_id);
	}
	return peek_recording_base_screen_recorder_type_id__once;
}

static void
_vala_peek_recording_base_screen_recorder_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	PeekRecordingBaseScreenRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PEEK_RECORDING_TYPE_BASE_SCREEN_RECORDER, PeekRecordingBaseScreenRecorder);
	switch (property_id) {
		case PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_RECORDING_PROPERTY:
		g_value_set_boolean (value, peek_recording_screen_recorder_get_is_recording ((PeekRecordingScreenRecorder*) self));
		break;
		case PEEK_RECORDING_BASE_SCREEN_RECORDER_CONFIG_PROPERTY:
		g_value_set_object (value, peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self));
		break;
		case PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_CANCELLING_PROPERTY:
		g_value_set_boolean (value, peek_recording_base_screen_recorder_get_is_cancelling (self));
		break;
		case PEEK_RECORDING_BASE_SCREEN_RECORDER_ELAPSED_SECONDS_PROPERTY:
		g_value_set_int64 (value, peek_recording_screen_recorder_get_elapsed_seconds ((PeekRecordingScreenRecorder*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_peek_recording_base_screen_recorder_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	PeekRecordingBaseScreenRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PEEK_RECORDING_TYPE_BASE_SCREEN_RECORDER, PeekRecordingBaseScreenRecorder);
	switch (property_id) {
		case PEEK_RECORDING_BASE_SCREEN_RECORDER_IS_RECORDING_PROPERTY:
		peek_recording_screen_recorder_set_is_recording ((PeekRecordingScreenRecorder*) self, g_value_get_boolean (value));
		break;
		case PEEK_RECORDING_BASE_SCREEN_RECORDER_CONFIG_PROPERTY:
		peek_recording_screen_recorder_set_config ((PeekRecordingScreenRecorder*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

