/* JfifSupport.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from JfifSupport.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer jfif_file_format_driver_parent_class = NULL;
static JfifFileFormatDriver* jfif_file_format_driver_instance;
static JfifFileFormatDriver* jfif_file_format_driver_instance = NULL;
static gpointer jfif_file_format_properties_parent_class = NULL;
static gchar** jfif_file_format_properties_known_extensions;
static gint jfif_file_format_properties_known_extensions_length1;
static gchar** jfif_file_format_properties_known_extensions = NULL;
static gint jfif_file_format_properties_known_extensions_length1 = 0;
static gint _jfif_file_format_properties_known_extensions_size_ = 0;
static gchar** jfif_file_format_properties_known_mime_types;
static gint jfif_file_format_properties_known_mime_types_length1;
static gchar** jfif_file_format_properties_known_mime_types = NULL;
static gint jfif_file_format_properties_known_mime_types_length1 = 0;
static gint _jfif_file_format_properties_known_mime_types_size_ = 0;
static JfifFileFormatProperties* jfif_file_format_properties_instance;
static JfifFileFormatProperties* jfif_file_format_properties_instance = NULL;
static gpointer jfif_sniffer_parent_class = NULL;
static gpointer jfif_reader_parent_class = NULL;
static gpointer jfif_writer_parent_class = NULL;
static gpointer jfif_metadata_writer_parent_class = NULL;

static PhotoFileFormatProperties* jfif_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
static PhotoFileReader* jfif_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                             const gchar* filepath);
static PhotoMetadata* jfif_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
static gboolean jfif_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean jfif_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* jfif_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                             const gchar* filepath);
static PhotoFileMetadataWriter* jfif_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                              const gchar* filepath);
static PhotoFileSniffer* jfif_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                               GFile* file,
                                                               PhotoFileSnifferOptions options);
static void jfif_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType jfif_file_format_driver_get_type_once (void);
static PhotoFileFormat jfif_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags jfif_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* jfif_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar* jfif_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static gchar** jfif_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                               gint* result_length1);
static gchar** _vala_array_dup12 (gchar** self,
                           gssize length);
static gchar* jfif_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** jfif_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                         gint* result_length1);
static gchar** _vala_array_dup13 (gchar** self,
                           gssize length);
static void jfif_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType jfif_file_format_properties_get_type_once (void);
static DetectedPhotoInformation* jfif_sniffer_real_sniff (PhotoFileSniffer* base,
                                                   GError** error);
static GType jfif_sniffer_get_type_once (void);
static GType jfif_reader_get_type_once (void);
static void jfif_writer_real_write (PhotoFileWriter* base,
                             GdkPixbuf* pixbuf,
                             JpegQuality quality,
                             GError** error);
static GType jfif_writer_get_type_once (void);
static void jfif_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                               PhotoMetadata* metadata,
                                               GError** error);
static GType jfif_metadata_writer_get_type_once (void);
VALA_EXTERN gint jpeg_read_marker (GFileInputStream* fins,
                       JpegMarker* marker,
                       GError** error);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
jfif_file_format_driver_init (void)
{
	JfifFileFormatDriver* _tmp0_;
	_tmp0_ = jfif_file_format_driver_new ();
	_photo_file_format_driver_unref0 (jfif_file_format_driver_instance);
	jfif_file_format_driver_instance = _tmp0_;
	jfif_file_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

JfifFileFormatDriver*
jfif_file_format_driver_get_instance (void)
{
	JfifFileFormatDriver* _tmp0_;
	JfifFileFormatDriver* _tmp1_;
	JfifFileFormatDriver* result;
	_tmp0_ = jfif_file_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
jfif_file_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	JfifFileFormatDriver * self;
	JfifFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = (JfifFileFormatDriver*) base;
	_tmp0_ = jfif_file_format_properties_get_instance ();
	result = (PhotoFileFormatProperties*) _tmp0_;
	return result;
}

static PhotoFileReader*
jfif_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                            const gchar* filepath)
{
	JfifFileFormatDriver * self;
	JfifReader* _tmp0_;
	PhotoFileReader* result;
	self = (JfifFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = jfif_reader_new (filepath);
	result = (PhotoFileReader*) _tmp0_;
	return result;
}

static PhotoMetadata*
jfif_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	JfifFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = (JfifFileFormatDriver*) base;
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

static gboolean
jfif_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	JfifFileFormatDriver * self;
	gboolean result;
	self = (JfifFileFormatDriver*) base;
	result = TRUE;
	return result;
}

static gboolean
jfif_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	JfifFileFormatDriver * self;
	gboolean result;
	self = (JfifFileFormatDriver*) base;
	result = TRUE;
	return result;
}

static PhotoFileWriter*
jfif_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                            const gchar* filepath)
{
	JfifFileFormatDriver * self;
	JfifWriter* _tmp0_;
	PhotoFileWriter* result;
	self = (JfifFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = jfif_writer_new (filepath);
	result = (PhotoFileWriter*) _tmp0_;
	return result;
}

static PhotoFileMetadataWriter*
jfif_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                     const gchar* filepath)
{
	JfifFileFormatDriver * self;
	JfifMetadataWriter* _tmp0_;
	PhotoFileMetadataWriter* result;
	self = (JfifFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = jfif_metadata_writer_new (filepath);
	result = (PhotoFileMetadataWriter*) _tmp0_;
	return result;
}

static PhotoFileSniffer*
jfif_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                             GFile* file,
                                             PhotoFileSnifferOptions options)
{
	JfifFileFormatDriver * self;
	JfifSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = (JfifFileFormatDriver*) base;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = jfif_sniffer_new (file, options);
	result = (PhotoFileSniffer*) _tmp0_;
	return result;
}

JfifFileFormatDriver*
jfif_file_format_driver_construct (GType object_type)
{
	JfifFileFormatDriver* self = NULL;
	self = (JfifFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

JfifFileFormatDriver*
jfif_file_format_driver_new (void)
{
	return jfif_file_format_driver_construct (TYPE_JFIF_FILE_FORMAT_DRIVER);
}

static void
jfif_file_format_driver_class_init (JfifFileFormatDriverClass * klass,
                                    gpointer klass_data)
{
	jfif_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = jfif_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) jfif_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) jfif_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) jfif_file_format_driver_real_create_metadata;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) jfif_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) jfif_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) jfif_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) jfif_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) jfif_file_format_driver_real_create_sniffer;
}

static void
jfif_file_format_driver_instance_init (JfifFileFormatDriver * self,
                                       gpointer klass)
{
}

static void
jfif_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	JfifFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_JFIF_FILE_FORMAT_DRIVER, JfifFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (jfif_file_format_driver_parent_class)->finalize (obj);
}

static GType
jfif_file_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JfifFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jfif_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JfifFileFormatDriver), 0, (GInstanceInitFunc) jfif_file_format_driver_instance_init, NULL };
	GType jfif_file_format_driver_type_id;
	jfif_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "JfifFileFormatDriver", &g_define_type_info, 0);
	return jfif_file_format_driver_type_id;
}

GType
jfif_file_format_driver_get_type (void)
{
	static volatile gsize jfif_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&jfif_file_format_driver_type_id__once)) {
		GType jfif_file_format_driver_type_id;
		jfif_file_format_driver_type_id = jfif_file_format_driver_get_type_once ();
		g_once_init_leave (&jfif_file_format_driver_type_id__once, jfif_file_format_driver_type_id);
	}
	return jfif_file_format_driver_type_id__once;
}

void
jfif_file_format_properties_init (void)
{
	JfifFileFormatProperties* _tmp0_;
	_tmp0_ = jfif_file_format_properties_new ();
	_photo_file_format_properties_unref0 (jfif_file_format_properties_instance);
	jfif_file_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

JfifFileFormatProperties*
jfif_file_format_properties_get_instance (void)
{
	JfifFileFormatProperties* _tmp0_;
	JfifFileFormatProperties* _tmp1_;
	JfifFileFormatProperties* result;
	_tmp0_ = jfif_file_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
jfif_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	JfifFileFormatProperties * self;
	PhotoFileFormat result;
	self = (JfifFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_JFIF;
	return result;
}

static PhotoFileFormatFlags
jfif_file_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	JfifFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = (JfifFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
jfif_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	JfifFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (JfifFileFormatProperties*) base;
	_tmp0_ = g_strdup ("jpg");
	result = _tmp0_;
	return result;
}

static gchar*
jfif_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	JfifFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (JfifFileFormatProperties*) base;
	_tmp0_ = g_strdup (_ ("JPEG"));
	result = _tmp0_;
	return result;
}

static gchar**
_vala_array_dup12 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
jfif_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                       gint* result_length1)
{
	JfifFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (JfifFileFormatProperties*) base;
	_tmp0_ = jfif_file_format_properties_known_extensions;
	_tmp0__length1 = jfif_file_format_properties_known_extensions_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup12 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
jfif_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	JfifFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (JfifFileFormatProperties*) base;
	_tmp0_ = jfif_file_format_properties_known_mime_types;
	_tmp0__length1 = jfif_file_format_properties_known_mime_types_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup13 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
jfif_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                 gint* result_length1)
{
	JfifFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (JfifFileFormatProperties*) base;
	_tmp0_ = jfif_file_format_properties_known_mime_types;
	_tmp0__length1 = jfif_file_format_properties_known_mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup13 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

JfifFileFormatProperties*
jfif_file_format_properties_construct (GType object_type)
{
	JfifFileFormatProperties* self = NULL;
	self = (JfifFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

JfifFileFormatProperties*
jfif_file_format_properties_new (void)
{
	return jfif_file_format_properties_construct (TYPE_JFIF_FILE_FORMAT_PROPERTIES);
}

static void
jfif_file_format_properties_class_init (JfifFileFormatPropertiesClass * klass,
                                        gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	jfif_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = jfif_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) jfif_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) jfif_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) jfif_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) jfif_file_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) jfif_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) jfif_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) jfif_file_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("jpg");
	_tmp1_ = g_strdup ("jpeg");
	_tmp2_ = g_strdup ("jpe");
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	jfif_file_format_properties_known_extensions = _tmp3_;
	jfif_file_format_properties_known_extensions_length1 = 3;
	_jfif_file_format_properties_known_extensions_size_ = jfif_file_format_properties_known_extensions_length1;
	_tmp4_ = g_strdup ("image/jpeg");
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	jfif_file_format_properties_known_mime_types = _tmp5_;
	jfif_file_format_properties_known_mime_types_length1 = 1;
	_jfif_file_format_properties_known_mime_types_size_ = jfif_file_format_properties_known_mime_types_length1;
}

static void
jfif_file_format_properties_instance_init (JfifFileFormatProperties * self,
                                           gpointer klass)
{
}

static void
jfif_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	JfifFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_JFIF_FILE_FORMAT_PROPERTIES, JfifFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (jfif_file_format_properties_parent_class)->finalize (obj);
}

static GType
jfif_file_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JfifFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jfif_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JfifFileFormatProperties), 0, (GInstanceInitFunc) jfif_file_format_properties_instance_init, NULL };
	GType jfif_file_format_properties_type_id;
	jfif_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "JfifFileFormatProperties", &g_define_type_info, 0);
	return jfif_file_format_properties_type_id;
}

GType
jfif_file_format_properties_get_type (void)
{
	static volatile gsize jfif_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&jfif_file_format_properties_type_id__once)) {
		GType jfif_file_format_properties_type_id;
		jfif_file_format_properties_type_id = jfif_file_format_properties_get_type_once ();
		g_once_init_leave (&jfif_file_format_properties_type_id__once, jfif_file_format_properties_type_id);
	}
	return jfif_file_format_properties_type_id__once;
}

JfifSniffer*
jfif_sniffer_construct (GType object_type,
                        GFile* file,
                        PhotoFileSnifferOptions options)
{
	JfifSniffer* self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (JfifSniffer*) gdk_sniffer_construct (object_type, file, options);
	return self;
}

JfifSniffer*
jfif_sniffer_new (GFile* file,
                  PhotoFileSnifferOptions options)
{
	return jfif_sniffer_construct (TYPE_JFIF_SNIFFER, file, options);
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

static DetectedPhotoInformation*
jfif_sniffer_real_sniff (PhotoFileSniffer* base,
                         GError** error)
{
	JfifSniffer * self;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp2_;
	DetectedPhotoInformation* _tmp3_;
	DetectedPhotoInformation* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_;
	DetectedPhotoInformation* _tmp7_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = (JfifSniffer*) base;
	_tmp1_ = ((PhotoFileSniffer*) self)->file;
	_tmp0_ = jpeg_is_jpeg (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = PHOTO_FILE_SNIFFER_CLASS (jfif_sniffer_parent_class)->sniff ((PhotoFileSniffer*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_GDK_SNIFFER, GdkSniffer), &_inner_error0_);
	detected = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = detected;
	if (_tmp3_ == NULL) {
		result = NULL;
		_detected_photo_information_unref0 (detected);
		return result;
	}
	_tmp5_ = detected;
	if (_tmp5_->file_format == PHOTO_FILE_FORMAT_JFIF) {
		DetectedPhotoInformation* _tmp6_;
		_tmp6_ = detected;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp7_ = _detected_photo_information_ref0 (_tmp4_);
	result = _tmp7_;
	_detected_photo_information_unref0 (detected);
	return result;
}

static void
jfif_sniffer_class_init (JfifSnifferClass * klass,
                         gpointer klass_data)
{
	jfif_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, GError**)) jfif_sniffer_real_sniff;
}

static void
jfif_sniffer_instance_init (JfifSniffer * self,
                            gpointer klass)
{
}

static GType
jfif_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JfifSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jfif_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JfifSniffer), 0, (GInstanceInitFunc) jfif_sniffer_instance_init, NULL };
	GType jfif_sniffer_type_id;
	jfif_sniffer_type_id = g_type_register_static (TYPE_GDK_SNIFFER, "JfifSniffer", &g_define_type_info, 0);
	return jfif_sniffer_type_id;
}

GType
jfif_sniffer_get_type (void)
{
	static volatile gsize jfif_sniffer_type_id__once = 0;
	if (g_once_init_enter (&jfif_sniffer_type_id__once)) {
		GType jfif_sniffer_type_id;
		jfif_sniffer_type_id = jfif_sniffer_get_type_once ();
		g_once_init_leave (&jfif_sniffer_type_id__once, jfif_sniffer_type_id);
	}
	return jfif_sniffer_type_id__once;
}

JfifReader*
jfif_reader_construct (GType object_type,
                       const gchar* filepath)
{
	JfifReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (JfifReader*) gdk_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_JFIF);
	return self;
}

JfifReader*
jfif_reader_new (const gchar* filepath)
{
	return jfif_reader_construct (TYPE_JFIF_READER, filepath);
}

static void
jfif_reader_class_init (JfifReaderClass * klass,
                        gpointer klass_data)
{
	jfif_reader_parent_class = g_type_class_peek_parent (klass);
}

static void
jfif_reader_instance_init (JfifReader * self,
                           gpointer klass)
{
}

static GType
jfif_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JfifReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jfif_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JfifReader), 0, (GInstanceInitFunc) jfif_reader_instance_init, NULL };
	GType jfif_reader_type_id;
	jfif_reader_type_id = g_type_register_static (TYPE_GDK_READER, "JfifReader", &g_define_type_info, 0);
	return jfif_reader_type_id;
}

GType
jfif_reader_get_type (void)
{
	static volatile gsize jfif_reader_type_id__once = 0;
	if (g_once_init_enter (&jfif_reader_type_id__once)) {
		GType jfif_reader_type_id;
		jfif_reader_type_id = jfif_reader_get_type_once ();
		g_once_init_leave (&jfif_reader_type_id__once, jfif_reader_type_id);
	}
	return jfif_reader_type_id__once;
}

JfifWriter*
jfif_writer_construct (GType object_type,
                       const gchar* filepath)
{
	JfifWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (JfifWriter*) photo_file_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_JFIF);
	return self;
}

JfifWriter*
jfif_writer_new (const gchar* filepath)
{
	return jfif_writer_construct (TYPE_JFIF_WRITER, filepath);
}

static void
jfif_writer_real_write (PhotoFileWriter* base,
                        GdkPixbuf* pixbuf,
                        JpegQuality quality,
                        GError** error)
{
	JfifWriter * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (JfifWriter*) base;
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = jpeg_quality_get_pct_text (quality);
	_tmp3_ = _tmp2_;
	gdk_pixbuf_save (pixbuf, _tmp1_, "jpeg", &_inner_error0_, "quality", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
jfif_writer_class_init (JfifWriterClass * klass,
                        gpointer klass_data)
{
	jfif_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileWriterClass *) klass)->write = (void (*) (PhotoFileWriter*, GdkPixbuf*, JpegQuality, GError**)) jfif_writer_real_write;
}

static void
jfif_writer_instance_init (JfifWriter * self,
                           gpointer klass)
{
}

static GType
jfif_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JfifWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jfif_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JfifWriter), 0, (GInstanceInitFunc) jfif_writer_instance_init, NULL };
	GType jfif_writer_type_id;
	jfif_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_WRITER, "JfifWriter", &g_define_type_info, 0);
	return jfif_writer_type_id;
}

GType
jfif_writer_get_type (void)
{
	static volatile gsize jfif_writer_type_id__once = 0;
	if (g_once_init_enter (&jfif_writer_type_id__once)) {
		GType jfif_writer_type_id;
		jfif_writer_type_id = jfif_writer_get_type_once ();
		g_once_init_leave (&jfif_writer_type_id__once, jfif_writer_type_id);
	}
	return jfif_writer_type_id__once;
}

JfifMetadataWriter*
jfif_metadata_writer_construct (GType object_type,
                                const gchar* filepath)
{
	JfifMetadataWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (JfifMetadataWriter*) photo_file_metadata_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_JFIF);
	return self;
}

JfifMetadataWriter*
jfif_metadata_writer_new (const gchar* filepath)
{
	return jfif_metadata_writer_construct (TYPE_JFIF_METADATA_WRITER, filepath);
}

static void
jfif_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                          PhotoMetadata* metadata,
                                          GError** error)
{
	JfifMetadataWriter * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (JfifMetadataWriter*) base;
	g_return_if_fail (metadata != NULL);
	_tmp0_ = photo_file_adapter_get_file ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	photo_metadata_write_to_file (metadata, _tmp1_, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
jfif_metadata_writer_class_init (JfifMetadataWriterClass * klass,
                                 gpointer klass_data)
{
	jfif_metadata_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter*, PhotoMetadata*, GError**)) jfif_metadata_writer_real_write_metadata;
}

static void
jfif_metadata_writer_instance_init (JfifMetadataWriter * self,
                                    gpointer klass)
{
}

static GType
jfif_metadata_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JfifMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jfif_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JfifMetadataWriter), 0, (GInstanceInitFunc) jfif_metadata_writer_instance_init, NULL };
	GType jfif_metadata_writer_type_id;
	jfif_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_METADATA_WRITER, "JfifMetadataWriter", &g_define_type_info, 0);
	return jfif_metadata_writer_type_id;
}

GType
jfif_metadata_writer_get_type (void)
{
	static volatile gsize jfif_metadata_writer_type_id__once = 0;
	if (g_once_init_enter (&jfif_metadata_writer_type_id__once)) {
		GType jfif_metadata_writer_type_id;
		jfif_metadata_writer_type_id = jfif_metadata_writer_get_type_once ();
		g_once_init_leave (&jfif_metadata_writer_type_id__once, jfif_metadata_writer_type_id);
	}
	return jfif_metadata_writer_type_id__once;
}

guint8
jpeg_marker_get_byte (JpegMarker self)
{
	guint8 result;
	result = (guint8) self;
	return result;
}

static GType
jpeg_marker_get_type_once (void)
{
	static const GEnumValue values[] = {{JPEG_MARKER_INVALID, "JPEG_MARKER_INVALID", "invalid"}, {JPEG_MARKER_SOI, "JPEG_MARKER_SOI", "soi"}, {JPEG_MARKER_EOI, "JPEG_MARKER_EOI", "eoi"}, {JPEG_MARKER_APP0, "JPEG_MARKER_APP0", "app0"}, {JPEG_MARKER_APP1, "JPEG_MARKER_APP1", "app1"}, {0, NULL, NULL}};
	GType jpeg_marker_type_id;
	jpeg_marker_type_id = g_enum_register_static ("JpegMarker", values);
	return jpeg_marker_type_id;
}

GType
jpeg_marker_get_type (void)
{
	static volatile gsize jpeg_marker_type_id__once = 0;
	if (g_once_init_enter (&jpeg_marker_type_id__once)) {
		GType jpeg_marker_type_id;
		jpeg_marker_type_id = jpeg_marker_get_type_once ();
		g_once_init_leave (&jpeg_marker_type_id__once, jpeg_marker_type_id);
	}
	return jpeg_marker_type_id__once;
}

gint
jpeg_quality_get_pct (JpegQuality self)
{
	gint result;
	result = (gint) self;
	return result;
}

gchar*
jpeg_quality_get_pct_text (JpegQuality self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("%d", (gint) self);
	result = _tmp0_;
	return result;
}

JpegQuality*
jpeg_quality_get_all (gint* result_length1)
{
	JpegQuality* _tmp0_;
	JpegQuality* _tmp1_;
	gint _tmp1__length1;
	JpegQuality* result;
	_tmp0_ = g_new0 (JpegQuality, 4);
	_tmp0_[0] = JPEG_QUALITY_LOW;
	_tmp0_[1] = JPEG_QUALITY_MEDIUM;
	_tmp0_[2] = JPEG_QUALITY_HIGH;
	_tmp0_[3] = JPEG_QUALITY_MAXIMUM;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 4;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gchar*
jpeg_quality_to_string (JpegQuality self)
{
	gchar* result;
	switch (self) {
		case JPEG_QUALITY_LOW:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup_printf (_ ("Low (%d%%)"), (gint) self);
			result = _tmp0_;
			return result;
		}
		case JPEG_QUALITY_MEDIUM:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup_printf (_ ("Medium (%d%%)"), (gint) self);
			result = _tmp1_;
			return result;
		}
		case JPEG_QUALITY_HIGH:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup_printf (_ ("High (%d%%)"), (gint) self);
			result = _tmp2_;
			return result;
		}
		case JPEG_QUALITY_MAXIMUM:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup_printf (_ ("Maximum (%d%%)"), (gint) self);
			result = _tmp3_;
			return result;
		}
		default:
		break;
	}
	g_warn_if_reached ();
	result = NULL;
	return result;
}

static GType
jpeg_quality_get_type_once (void)
{
	static const GEnumValue values[] = {{JPEG_QUALITY_LOW, "JPEG_QUALITY_LOW", "low"}, {JPEG_QUALITY_MEDIUM, "JPEG_QUALITY_MEDIUM", "medium"}, {JPEG_QUALITY_HIGH, "JPEG_QUALITY_HIGH", "high"}, {JPEG_QUALITY_MAXIMUM, "JPEG_QUALITY_MAXIMUM", "maximum"}, {0, NULL, NULL}};
	GType jpeg_quality_type_id;
	jpeg_quality_type_id = g_enum_register_static ("JpegQuality", values);
	return jpeg_quality_type_id;
}

GType
jpeg_quality_get_type (void)
{
	static volatile gsize jpeg_quality_type_id__once = 0;
	if (g_once_init_enter (&jpeg_quality_type_id__once)) {
		GType jpeg_quality_type_id;
		jpeg_quality_type_id = jpeg_quality_get_type_once ();
		g_once_init_leave (&jpeg_quality_type_id__once, jpeg_quality_type_id);
	}
	return jpeg_quality_type_id__once;
}

gboolean
jpeg_is_jpeg (GFile* file,
              GError** error)
{
	GFileInputStream* fins = NULL;
	GFileInputStream* _tmp0_;
	JpegMarker marker = 0;
	gint segment_length = 0;
	GFileInputStream* _tmp2_;
	JpegMarker _tmp3_ = 0;
	gint _tmp4_;
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_read (file, NULL, &_inner_error0_);
	fins = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = fins;
	_tmp4_ = jpeg_read_marker (_tmp2_, &_tmp3_, &_inner_error0_);
	marker = _tmp3_;
	segment_length = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fins);
		return _tmp5_;
	}
	if (marker == JPEG_MARKER_SOI) {
		_tmp6_ = segment_length == 0;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	_g_object_unref0 (fins);
	return result;
}

gint
jpeg_read_marker (GFileInputStream* fins,
                  JpegMarker* marker,
                  GError** error)
{
	JpegMarker _vala_marker = 0;
	GDataInputStream* dins = NULL;
	GDataInputStream* _tmp0_;
	GDataInputStream* _tmp1_;
	guint8 _tmp2_ = 0U;
	GDataInputStream* _tmp3_;
	guint8 _tmp5_ = 0U;
	GDataInputStream* _tmp6_;
	gboolean _tmp8_ = FALSE;
	guint16 length = 0U;
	GDataInputStream* _tmp9_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (fins != NULL, 0);
	_vala_marker = JPEG_MARKER_INVALID;
	_tmp0_ = g_data_input_stream_new ((GInputStream*) fins);
	dins = _tmp0_;
	_tmp1_ = dins;
	g_data_input_stream_set_byte_order (_tmp1_, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN);
	_tmp3_ = dins;
	_tmp2_ = g_data_input_stream_read_byte (_tmp3_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp4_ = -1;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dins);
		return _tmp4_;
	}
	if (_tmp2_ != JPEG_MARKER_PREFIX) {
		result = -1;
		_g_object_unref0 (dins);
		if (marker) {
			*marker = _vala_marker;
		}
		return result;
	}
	_tmp6_ = dins;
	_tmp5_ = g_data_input_stream_read_byte (_tmp6_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dins);
		return _tmp7_;
	}
	_vala_marker = (JpegMarker) _tmp5_;
	if (_vala_marker == JPEG_MARKER_SOI) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = _vala_marker == JPEG_MARKER_EOI;
	}
	if (_tmp8_) {
		result = 0;
		_g_object_unref0 (dins);
		if (marker) {
			*marker = _vala_marker;
		}
		return result;
	}
	_tmp9_ = dins;
	length = g_data_input_stream_read_uint16 (_tmp9_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dins);
		return _tmp10_;
	}
	if (((gint) length) < 2) {
		g_debug ("Invalid length %Xh at ofs %" G_GINT64_FORMAT "Xh", length, G_TYPE_INSTANCE_GET_CLASS (fins, g_file_input_stream_get_type (), GFileInputStreamClass)->tell (fins) - 2);
		result = -1;
		_g_object_unref0 (dins);
		if (marker) {
			*marker = _vala_marker;
		}
		return result;
	}
	result = length - 2;
	_g_object_unref0 (dins);
	if (marker) {
		*marker = _vala_marker;
	}
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

