/* MainWindow.c generated by valac 0.56.17, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * Copyright 2019–2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <pantheon-wayland.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <unistd.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ONBOARDING_TYPE_MAIN_WINDOW (onboarding_main_window_get_type ())
#define ONBOARDING_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_MAIN_WINDOW, OnboardingMainWindow))
#define ONBOARDING_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_MAIN_WINDOW, OnboardingMainWindowClass))
#define ONBOARDING_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_MAIN_WINDOW))
#define ONBOARDING_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_MAIN_WINDOW))
#define ONBOARDING_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_MAIN_WINDOW, OnboardingMainWindowClass))

typedef struct _OnboardingMainWindow OnboardingMainWindow;
typedef struct _OnboardingMainWindowClass OnboardingMainWindowClass;
typedef struct _OnboardingMainWindowPrivate OnboardingMainWindowPrivate;

#define ONBOARDING_TYPE_ABSTRACT_ONBOARDING_VIEW (onboarding_abstract_onboarding_view_get_type ())
#define ONBOARDING_ABSTRACT_ONBOARDING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_ABSTRACT_ONBOARDING_VIEW, OnboardingAbstractOnboardingView))
#define ONBOARDING_ABSTRACT_ONBOARDING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_ABSTRACT_ONBOARDING_VIEW, OnboardingAbstractOnboardingViewClass))
#define ONBOARDING_IS_ABSTRACT_ONBOARDING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_ABSTRACT_ONBOARDING_VIEW))
#define ONBOARDING_IS_ABSTRACT_ONBOARDING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_ABSTRACT_ONBOARDING_VIEW))
#define ONBOARDING_ABSTRACT_ONBOARDING_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_ABSTRACT_ONBOARDING_VIEW, OnboardingAbstractOnboardingViewClass))

typedef struct _OnboardingAbstractOnboardingView OnboardingAbstractOnboardingView;
typedef struct _OnboardingAbstractOnboardingViewClass OnboardingAbstractOnboardingViewClass;

#define ONBOARDING_TYPE_FINISH_VIEW (onboarding_finish_view_get_type ())
#define ONBOARDING_FINISH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_FINISH_VIEW, OnboardingFinishView))
#define ONBOARDING_FINISH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_FINISH_VIEW, OnboardingFinishViewClass))
#define ONBOARDING_IS_FINISH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_FINISH_VIEW))
#define ONBOARDING_IS_FINISH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_FINISH_VIEW))
#define ONBOARDING_FINISH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_FINISH_VIEW, OnboardingFinishViewClass))

typedef struct _OnboardingFinishView OnboardingFinishView;
typedef struct _OnboardingFinishViewClass OnboardingFinishViewClass;
enum  {
	ONBOARDING_MAIN_WINDOW_0_PROPERTY,
	ONBOARDING_MAIN_WINDOW_VIEWED_PROPERTY,
	ONBOARDING_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* onboarding_main_window_properties[ONBOARDING_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ONBOARDING_TYPE_WELCOME_VIEW (onboarding_welcome_view_get_type ())
#define ONBOARDING_WELCOME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_WELCOME_VIEW, OnboardingWelcomeView))
#define ONBOARDING_WELCOME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_WELCOME_VIEW, OnboardingWelcomeViewClass))
#define ONBOARDING_IS_WELCOME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_WELCOME_VIEW))
#define ONBOARDING_IS_WELCOME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_WELCOME_VIEW))
#define ONBOARDING_WELCOME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_WELCOME_VIEW, OnboardingWelcomeViewClass))

typedef struct _OnboardingWelcomeView OnboardingWelcomeView;
typedef struct _OnboardingWelcomeViewClass OnboardingWelcomeViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ONBOARDING_TYPE_GUEST_VIEW (onboarding_guest_view_get_type ())
#define ONBOARDING_GUEST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_GUEST_VIEW, OnboardingGuestView))
#define ONBOARDING_GUEST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_GUEST_VIEW, OnboardingGuestViewClass))
#define ONBOARDING_IS_GUEST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_GUEST_VIEW))
#define ONBOARDING_IS_GUEST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_GUEST_VIEW))
#define ONBOARDING_GUEST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_GUEST_VIEW, OnboardingGuestViewClass))

typedef struct _OnboardingGuestView OnboardingGuestView;
typedef struct _OnboardingGuestViewClass OnboardingGuestViewClass;

#define ONBOARDING_TYPE_EARLY_ACCESS_VIEW (onboarding_early_access_view_get_type ())
#define ONBOARDING_EARLY_ACCESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_EARLY_ACCESS_VIEW, OnboardingEarlyAccessView))
#define ONBOARDING_EARLY_ACCESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_EARLY_ACCESS_VIEW, OnboardingEarlyAccessViewClass))
#define ONBOARDING_IS_EARLY_ACCESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_EARLY_ACCESS_VIEW))
#define ONBOARDING_IS_EARLY_ACCESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_EARLY_ACCESS_VIEW))
#define ONBOARDING_EARLY_ACCESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_EARLY_ACCESS_VIEW, OnboardingEarlyAccessViewClass))

typedef struct _OnboardingEarlyAccessView OnboardingEarlyAccessView;
typedef struct _OnboardingEarlyAccessViewClass OnboardingEarlyAccessViewClass;

#define ONBOARDING_TYPE_STYLE_VIEW (onboarding_style_view_get_type ())
#define ONBOARDING_STYLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_STYLE_VIEW, OnboardingStyleView))
#define ONBOARDING_STYLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_STYLE_VIEW, OnboardingStyleViewClass))
#define ONBOARDING_IS_STYLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_STYLE_VIEW))
#define ONBOARDING_IS_STYLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_STYLE_VIEW))
#define ONBOARDING_STYLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_STYLE_VIEW, OnboardingStyleViewClass))

typedef struct _OnboardingStyleView OnboardingStyleView;
typedef struct _OnboardingStyleViewClass OnboardingStyleViewClass;

#define ONBOARDING_TYPE_NIGHT_LIGHT_VIEW (onboarding_night_light_view_get_type ())
#define ONBOARDING_NIGHT_LIGHT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_NIGHT_LIGHT_VIEW, OnboardingNightLightView))
#define ONBOARDING_NIGHT_LIGHT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_NIGHT_LIGHT_VIEW, OnboardingNightLightViewClass))
#define ONBOARDING_IS_NIGHT_LIGHT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_NIGHT_LIGHT_VIEW))
#define ONBOARDING_IS_NIGHT_LIGHT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_NIGHT_LIGHT_VIEW))
#define ONBOARDING_NIGHT_LIGHT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_NIGHT_LIGHT_VIEW, OnboardingNightLightViewClass))

typedef struct _OnboardingNightLightView OnboardingNightLightView;
typedef struct _OnboardingNightLightViewClass OnboardingNightLightViewClass;

#define ONBOARDING_TYPE_HOUSE_KEEPING_VIEW (onboarding_house_keeping_view_get_type ())
#define ONBOARDING_HOUSE_KEEPING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_HOUSE_KEEPING_VIEW, OnboardingHouseKeepingView))
#define ONBOARDING_HOUSE_KEEPING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_HOUSE_KEEPING_VIEW, OnboardingHouseKeepingViewClass))
#define ONBOARDING_IS_HOUSE_KEEPING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_HOUSE_KEEPING_VIEW))
#define ONBOARDING_IS_HOUSE_KEEPING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_HOUSE_KEEPING_VIEW))
#define ONBOARDING_HOUSE_KEEPING_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_HOUSE_KEEPING_VIEW, OnboardingHouseKeepingViewClass))

typedef struct _OnboardingHouseKeepingView OnboardingHouseKeepingView;
typedef struct _OnboardingHouseKeepingViewClass OnboardingHouseKeepingViewClass;

#define ONBOARDING_TYPE_ONLINE_ACCOUNTS_VIEW (onboarding_online_accounts_view_get_type ())
#define ONBOARDING_ONLINE_ACCOUNTS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_ONLINE_ACCOUNTS_VIEW, OnboardingOnlineAccountsView))
#define ONBOARDING_ONLINE_ACCOUNTS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_ONLINE_ACCOUNTS_VIEW, OnboardingOnlineAccountsViewClass))
#define ONBOARDING_IS_ONLINE_ACCOUNTS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_ONLINE_ACCOUNTS_VIEW))
#define ONBOARDING_IS_ONLINE_ACCOUNTS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_ONLINE_ACCOUNTS_VIEW))
#define ONBOARDING_ONLINE_ACCOUNTS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_ONLINE_ACCOUNTS_VIEW, OnboardingOnlineAccountsViewClass))

typedef struct _OnboardingOnlineAccountsView OnboardingOnlineAccountsView;
typedef struct _OnboardingOnlineAccountsViewClass OnboardingOnlineAccountsViewClass;

#define ONBOARDING_TYPE_APP_CENTER_VIEW (onboarding_app_center_view_get_type ())
#define ONBOARDING_APP_CENTER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_APP_CENTER_VIEW, OnboardingAppCenterView))
#define ONBOARDING_APP_CENTER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_APP_CENTER_VIEW, OnboardingAppCenterViewClass))
#define ONBOARDING_IS_APP_CENTER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_APP_CENTER_VIEW))
#define ONBOARDING_IS_APP_CENTER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_APP_CENTER_VIEW))
#define ONBOARDING_APP_CENTER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_APP_CENTER_VIEW, OnboardingAppCenterViewClass))

typedef struct _OnboardingAppCenterView OnboardingAppCenterView;
typedef struct _OnboardingAppCenterViewClass OnboardingAppCenterViewClass;

#define ONBOARDING_TYPE_UPDATES_VIEW (onboarding_updates_view_get_type ())
#define ONBOARDING_UPDATES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONBOARDING_TYPE_UPDATES_VIEW, OnboardingUpdatesView))
#define ONBOARDING_UPDATES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONBOARDING_TYPE_UPDATES_VIEW, OnboardingUpdatesViewClass))
#define ONBOARDING_IS_UPDATES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONBOARDING_TYPE_UPDATES_VIEW))
#define ONBOARDING_IS_UPDATES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONBOARDING_TYPE_UPDATES_VIEW))
#define ONBOARDING_UPDATES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONBOARDING_TYPE_UPDATES_VIEW, OnboardingUpdatesViewClass))

typedef struct _OnboardingUpdatesView OnboardingUpdatesView;
typedef struct _OnboardingUpdatesViewClass OnboardingUpdatesViewClass;

struct _OnboardingMainWindow {
	GtkApplicationWindow parent_instance;
	OnboardingMainWindowPrivate * priv;
};

struct _OnboardingMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _OnboardingMainWindowPrivate {
	gchar** _viewed;
	gint _viewed_length1;
	gint __viewed_size_;
	AdwNavigationView* navigation_view;
	OnboardingFinishView* finish_view;
};

static gint OnboardingMainWindow_private_offset;
static gpointer onboarding_main_window_parent_class = NULL;
VALA_EXTERN GSettings* onboarding_main_window_settings;
GSettings* onboarding_main_window_settings = NULL;
VALA_EXTERN GListStore* onboarding_main_window_pages;
GListStore* onboarding_main_window_pages = NULL;
static PantheonWaylandExtendedBehaviorIface * onboarding_main_window_pantheon_wayland_extended_behavior_parent_iface = NULL;

VALA_EXTERN GType onboarding_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingMainWindow, g_object_unref)
VALA_EXTERN GType onboarding_abstract_onboarding_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingAbstractOnboardingView, g_object_unref)
VALA_EXTERN GType onboarding_finish_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingFinishView, g_object_unref)
VALA_EXTERN OnboardingMainWindow* onboarding_main_window_new (void);
VALA_EXTERN OnboardingMainWindow* onboarding_main_window_construct (GType object_type);
VALA_EXTERN const gchar* utils_get_os_name (void);
static void onboarding_main_window_action_next (OnboardingMainWindow* self);
static AdwNavigationPage* onboarding_main_window_get_next_page (OnboardingMainWindow* self);
static void onboarding_main_window_action_skip (OnboardingMainWindow* self);
VALA_EXTERN void onboarding_abstract_onboarding_view_mark_viewed (OnboardingAbstractOnboardingView* self);
VALA_EXTERN gchar** onboarding_main_window_get_viewed (OnboardingMainWindow* self,
                                           gint* result_length1);
VALA_EXTERN void onboarding_main_window_set_viewed (OnboardingMainWindow* self,
                                        gchar** value,
                                        gint value_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static GObject * onboarding_main_window_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN GType onboarding_welcome_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingWelcomeView, g_object_unref)
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN OnboardingWelcomeView* onboarding_welcome_view_new (gboolean updates);
VALA_EXTERN OnboardingWelcomeView* onboarding_welcome_view_construct (GType object_type,
                                                          gboolean updates);
VALA_EXTERN GType onboarding_guest_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingGuestView, g_object_unref)
VALA_EXTERN OnboardingGuestView* onboarding_guest_view_new (void);
VALA_EXTERN OnboardingGuestView* onboarding_guest_view_construct (GType object_type);
VALA_EXTERN GType onboarding_early_access_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingEarlyAccessView, g_object_unref)
VALA_EXTERN OnboardingEarlyAccessView* onboarding_early_access_view_new (void);
VALA_EXTERN OnboardingEarlyAccessView* onboarding_early_access_view_construct (GType object_type);
VALA_EXTERN GType onboarding_style_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingStyleView, g_object_unref)
VALA_EXTERN OnboardingStyleView* onboarding_style_view_new (void);
VALA_EXTERN OnboardingStyleView* onboarding_style_view_construct (GType object_type);
VALA_EXTERN GType onboarding_night_light_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingNightLightView, g_object_unref)
VALA_EXTERN OnboardingNightLightView* onboarding_night_light_view_new (void);
VALA_EXTERN OnboardingNightLightView* onboarding_night_light_view_construct (GType object_type);
VALA_EXTERN GType onboarding_house_keeping_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingHouseKeepingView, g_object_unref)
VALA_EXTERN OnboardingHouseKeepingView* onboarding_house_keeping_view_new (void);
VALA_EXTERN OnboardingHouseKeepingView* onboarding_house_keeping_view_construct (GType object_type);
VALA_EXTERN GType onboarding_online_accounts_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingOnlineAccountsView, g_object_unref)
VALA_EXTERN OnboardingOnlineAccountsView* onboarding_online_accounts_view_new (void);
VALA_EXTERN OnboardingOnlineAccountsView* onboarding_online_accounts_view_construct (GType object_type);
VALA_EXTERN GType onboarding_app_center_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingAppCenterView, g_object_unref)
VALA_EXTERN OnboardingAppCenterView* onboarding_app_center_view_new (void);
VALA_EXTERN OnboardingAppCenterView* onboarding_app_center_view_construct (GType object_type);
VALA_EXTERN GType onboarding_updates_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OnboardingUpdatesView, g_object_unref)
VALA_EXTERN OnboardingUpdatesView* onboarding_updates_view_new (void);
VALA_EXTERN OnboardingUpdatesView* onboarding_updates_view_construct (GType object_type);
VALA_EXTERN OnboardingFinishView* onboarding_finish_view_new (void);
VALA_EXTERN OnboardingFinishView* onboarding_finish_view_construct (GType object_type);
static AdwNavigationPage* _onboarding_main_window_get_next_page_adw_navigation_view_get_next_page (AdwNavigationView* _sender,
                                                                                            gpointer self);
static void _onboarding_main_window___lambda15_ (OnboardingMainWindow* self);
static void __onboarding_main_window___lambda15__g_simple_action_activate (GSimpleAction* _sender,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void _onboarding_main_window_action_next_g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _onboarding_main_window_action_skip_g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _onboarding_main_window___lambda16_ (OnboardingMainWindow* self);
static void __onboarding_main_window___lambda16__gtk_widget_realize (GtkWidget* _sender,
                                                              gpointer self);
static void onboarding_main_window_finalize (GObject * obj);
static GType onboarding_main_window_get_type_once (void);
static void _vala_onboarding_main_window_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_onboarding_main_window_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
onboarding_main_window_get_instance_private (OnboardingMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, OnboardingMainWindow_private_offset);
}

OnboardingMainWindow*
onboarding_main_window_construct (GType object_type)
{
	OnboardingMainWindow * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = utils_get_os_name ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Set up %s"), _tmp1_);
	_tmp3_ = _tmp2_;
	self = (OnboardingMainWindow*) g_object_new (object_type, "deletable", FALSE, "icon-name", "io.elementary.onboarding", "title", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	return self;
}

OnboardingMainWindow*
onboarding_main_window_new (void)
{
	return onboarding_main_window_construct (ONBOARDING_TYPE_MAIN_WINDOW);
}

static void
onboarding_main_window_action_next (OnboardingMainWindow* self)
{
	AdwNavigationPage* next_page = NULL;
	AdwNavigationPage* _tmp0_;
	AdwNavigationPage* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = onboarding_main_window_get_next_page (self);
	next_page = _tmp0_;
	_tmp1_ = next_page;
	if (_tmp1_ != NULL) {
		AdwNavigationView* _tmp2_;
		AdwNavigationPage* _tmp3_;
		_tmp2_ = self->priv->navigation_view;
		_tmp3_ = next_page;
		adw_navigation_view_push (_tmp2_, _tmp3_);
	} else {
		gtk_window_close ((GtkWindow*) self);
	}
	_g_object_unref0 (next_page);
}

static AdwNavigationPage*
onboarding_main_window_get_next_page (OnboardingMainWindow* self)
{
	guint pos = 0U;
	GListStore* _tmp0_;
	AdwNavigationView* _tmp1_;
	AdwNavigationPage* _tmp2_;
	AdwNavigationPage* _tmp3_;
	guint _tmp4_ = 0U;
	GListStore* _tmp5_;
	GObject* _tmp6_;
	AdwNavigationPage* result;
	g_return_val_if_fail (self != NULL, NULL);
	pos = (guint) -1;
	_tmp0_ = onboarding_main_window_pages;
	_tmp1_ = self->priv->navigation_view;
	_tmp2_ = adw_navigation_view_get_visible_page (_tmp1_);
	_tmp3_ = _tmp2_;
	g_list_store_find (_tmp0_, (GObject*) _tmp3_, &_tmp4_);
	pos = _tmp4_;
	_tmp5_ = onboarding_main_window_pages;
	_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, pos + 1);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, adw_navigation_page_get_type (), AdwNavigationPage);
	return result;
}

static void
onboarding_main_window_action_skip (OnboardingMainWindow* self)
{
	AdwNavigationView* _tmp6_;
	OnboardingFinishView* _tmp7_;
	g_return_if_fail (self != NULL);
	{
		gint view_count = 0;
		view_count = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				OnboardingAbstractOnboardingView* view = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				OnboardingAbstractOnboardingView* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = view_count;
					view_count = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = onboarding_main_window_pages;
				if (!(((guint) view_count) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = onboarding_main_window_pages;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) view_count);
				view = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ONBOARDING_TYPE_ABSTRACT_ONBOARDING_VIEW, OnboardingAbstractOnboardingView);
				_tmp5_ = view;
				onboarding_abstract_onboarding_view_mark_viewed (_tmp5_);
				_g_object_unref0 (view);
			}
		}
	}
	_tmp6_ = self->priv->navigation_view;
	_tmp7_ = self->priv->finish_view;
	adw_navigation_view_push (_tmp6_, (AdwNavigationPage*) _tmp7_);
}

gchar**
onboarding_main_window_get_viewed (OnboardingMainWindow* self,
                                   gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_viewed;
	_tmp0__length1 = self->priv->_viewed_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
onboarding_main_window_set_viewed (OnboardingMainWindow* self,
                                   gchar** value,
                                   gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = onboarding_main_window_get_viewed (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_viewed = (_vala_array_free (self->priv->_viewed, self->priv->_viewed_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_viewed = _tmp0_;
		self->priv->_viewed_length1 = _tmp0__length1;
		self->priv->__viewed_size_ = self->priv->_viewed_length1;
		g_object_notify_by_pspec ((GObject *) self, onboarding_main_window_properties[ONBOARDING_MAIN_WINDOW_VIEWED_PROPERTY]);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static AdwNavigationPage*
_onboarding_main_window_get_next_page_adw_navigation_view_get_next_page (AdwNavigationView* _sender,
                                                                         gpointer self)
{
	AdwNavigationPage* result;
	result = onboarding_main_window_get_next_page ((OnboardingMainWindow*) self);
	return result;
}

static void
_onboarding_main_window___lambda15_ (OnboardingMainWindow* self)
{
	AdwNavigationView* _tmp0_;
	_tmp0_ = self->priv->navigation_view;
	adw_navigation_view_pop (_tmp0_);
}

static void
__onboarding_main_window___lambda15__g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	_onboarding_main_window___lambda15_ ((OnboardingMainWindow*) self);
}

static void
_onboarding_main_window_action_next_g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	onboarding_main_window_action_next ((OnboardingMainWindow*) self);
}

static void
_onboarding_main_window_action_skip_g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	onboarding_main_window_action_skip ((OnboardingMainWindow*) self);
}

static void
_onboarding_main_window___lambda16_ (OnboardingMainWindow* self)
{
	pantheon_wayland_extended_behavior_connect_to_shell ((PantheonWaylandExtendedBehavior*) self);
	pantheon_wayland_extended_behavior_make_centered ((PantheonWaylandExtendedBehavior*) self);
}

static void
__onboarding_main_window___lambda16__gtk_widget_realize (GtkWidget* _sender,
                                                         gpointer self)
{
	_onboarding_main_window___lambda16_ ((OnboardingMainWindow*) self);
}

static GObject *
onboarding_main_window_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	OnboardingMainWindow * self;
	AdwNavigationView* _tmp0_;
	OnboardingWelcomeView* welcome_view = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	OnboardingWelcomeView* _tmp8_;
	AdwNavigationView* _tmp9_;
	OnboardingWelcomeView* _tmp10_;
	GListStore* _tmp11_;
	OnboardingWelcomeView* _tmp12_;
	gboolean early_access = FALSE;
	GFile* apt_sources = NULL;
	GFile* _tmp13_;
	gboolean guest_session = FALSE;
	const gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gint _tmp32_ = 0;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gint _tmp43_ = 0;
	gchar** _tmp44_;
	gint _tmp44__length1;
	gboolean _tmp48_ = FALSE;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gint _tmp50_ = 0;
	gchar** _tmp51_;
	gint _tmp51__length1;
	gboolean _tmp55_ = FALSE;
	gchar** _tmp56_;
	gint _tmp56__length1;
	gint _tmp57_ = 0;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp71_ = FALSE;
	gchar** _tmp72_;
	gint _tmp72__length1;
	gint _tmp73_ = 0;
	gchar** _tmp74_;
	gint _tmp74__length1;
	GListStore* _tmp78_;
	guint _tmp79_;
	guint _tmp80_;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	OnboardingFinishView* _tmp93_;
	GListStore* _tmp94_;
	OnboardingFinishView* _tmp95_;
	AdwNavigationView* _tmp96_;
	GtkGrid* _tmp97_ = NULL;
	GtkGrid* _tmp98_;
	AdwNavigationView* _tmp99_;
	GSimpleAction* back_action = NULL;
	GSimpleAction* _tmp100_;
	GSimpleAction* _tmp101_;
	GSimpleAction* next_action = NULL;
	GSimpleAction* _tmp102_;
	GSimpleAction* _tmp103_;
	GSimpleAction* skip_action = NULL;
	GSimpleAction* _tmp104_;
	GSimpleAction* _tmp105_;
	GSimpleAction* _tmp106_;
	GSimpleAction* _tmp107_;
	GSimpleAction* _tmp108_;
	GtkWidget* _tmp109_;
	GtkWidget* _tmp110_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (onboarding_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ONBOARDING_TYPE_MAIN_WINDOW, OnboardingMainWindow);
	_tmp0_ = (AdwNavigationView*) adw_navigation_view_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->navigation_view);
	self->priv->navigation_view = _tmp0_;
	if (isatty (STDIN_FILENO) == FALSE) {
		GSettings* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = onboarding_main_window_settings;
		_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "viewed");
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _vala_array_length (_tmp2_);
		onboarding_main_window_set_viewed (self, _tmp4_, _vala_array_length (_tmp2_));
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = onboarding_main_window_get_viewed (self, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	_tmp8_ = onboarding_welcome_view_new (_vala_string_array_contains (_tmp7_, _tmp7__length1, "finish"));
	g_object_ref_sink (_tmp8_);
	welcome_view = _tmp8_;
	_tmp9_ = self->priv->navigation_view;
	_tmp10_ = welcome_view;
	adw_navigation_view_add (_tmp9_, (AdwNavigationPage*) _tmp10_);
	_tmp11_ = onboarding_main_window_pages;
	_tmp12_ = welcome_view;
	g_list_store_append (_tmp11_, (GObject*) _tmp12_);
	early_access = FALSE;
	_tmp13_ = g_file_new_for_path ("/etc/apt/sources.list.d/elementary.list");
	apt_sources = _tmp13_;
	{
		GFileInputStream* is = NULL;
		GFile* _tmp14_;
		GFileInputStream* _tmp15_;
		GDataInputStream* dis = NULL;
		GFileInputStream* _tmp16_;
		GDataInputStream* _tmp17_;
		gchar* _tmp18_ = NULL;
		GDataInputStream* _tmp19_;
		gchar* _tmp20_;
		_tmp14_ = apt_sources;
		_tmp15_ = g_file_read (_tmp14_, NULL, &_inner_error0_);
		is = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp16_ = is;
		_tmp17_ = g_data_input_stream_new ((GInputStream*) _tmp16_);
		dis = _tmp17_;
		_tmp19_ = dis;
		_tmp20_ = g_data_input_stream_read_line (_tmp19_, NULL, NULL, &_inner_error0_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dis);
			_g_object_unref0 (is);
			goto __catch0_g_error;
		}
		if (string_contains (_tmp18_, "daily")) {
			early_access = TRUE;
		}
		_g_free0 (_tmp18_);
		_g_object_unref0 (dis);
		_g_object_unref0 (is);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_critical ("MainWindow.vala:63: Couldn't read apt sources: %s", _tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (apt_sources);
		_g_object_unref0 (welcome_view);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp23_ = g_get_user_name ();
	guest_session = g_str_has_prefix (_tmp23_, "guest-");
	if (guest_session) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = isatty (STDIN_FILENO);
	}
	if (_tmp24_) {
		OnboardingGuestView* guest_view = NULL;
		OnboardingGuestView* _tmp25_;
		GListStore* _tmp26_;
		OnboardingGuestView* _tmp27_;
		_tmp25_ = onboarding_guest_view_new ();
		g_object_ref_sink (_tmp25_);
		guest_view = _tmp25_;
		_tmp26_ = onboarding_main_window_pages;
		_tmp27_ = guest_view;
		g_list_store_append (_tmp26_, (GObject*) _tmp27_);
		_g_object_unref0 (guest_view);
	}
	if (early_access) {
		OnboardingEarlyAccessView* early_access_view = NULL;
		OnboardingEarlyAccessView* _tmp28_;
		GListStore* _tmp29_;
		OnboardingEarlyAccessView* _tmp30_;
		_tmp28_ = onboarding_early_access_view_new ();
		g_object_ref_sink (_tmp28_);
		early_access_view = _tmp28_;
		_tmp29_ = onboarding_main_window_pages;
		_tmp30_ = early_access_view;
		g_list_store_append (_tmp29_, (GObject*) _tmp30_);
		_g_object_unref0 (early_access_view);
	}
	_tmp31_ = onboarding_main_window_get_viewed (self, &_tmp32_);
	_tmp31__length1 = _tmp32_;
	_tmp33_ = _tmp31_;
	_tmp33__length1 = _tmp31__length1;
	if (!_vala_string_array_contains (_tmp33_, _tmp33__length1, "style")) {
		GSettings* interface_settings = NULL;
		GSettings* _tmp34_;
		GSettings* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gboolean _tmp38_;
		_tmp34_ = g_settings_new ("org.gnome.desktop.interface");
		interface_settings = _tmp34_;
		_tmp35_ = interface_settings;
		_tmp36_ = g_settings_get_string (_tmp35_, "gtk-theme");
		_tmp37_ = _tmp36_;
		_tmp38_ = g_str_has_prefix (_tmp37_, "io.elementary.stylesheet.");
		_g_free0 (_tmp37_);
		if (_tmp38_) {
			OnboardingStyleView* style_view = NULL;
			OnboardingStyleView* _tmp39_;
			GListStore* _tmp40_;
			OnboardingStyleView* _tmp41_;
			_tmp39_ = onboarding_style_view_new ();
			g_object_ref_sink (_tmp39_);
			style_view = _tmp39_;
			_tmp40_ = onboarding_main_window_pages;
			_tmp41_ = style_view;
			g_list_store_append (_tmp40_, (GObject*) _tmp41_);
			_g_object_unref0 (style_view);
		}
		_g_object_unref0 (interface_settings);
	}
	_tmp42_ = onboarding_main_window_get_viewed (self, &_tmp43_);
	_tmp42__length1 = _tmp43_;
	_tmp44_ = _tmp42_;
	_tmp44__length1 = _tmp42__length1;
	if (!_vala_string_array_contains (_tmp44_, _tmp44__length1, "night-light")) {
		OnboardingNightLightView* night_light_view = NULL;
		OnboardingNightLightView* _tmp45_;
		GListStore* _tmp46_;
		OnboardingNightLightView* _tmp47_;
		_tmp45_ = onboarding_night_light_view_new ();
		g_object_ref_sink (_tmp45_);
		night_light_view = _tmp45_;
		_tmp46_ = onboarding_main_window_pages;
		_tmp47_ = night_light_view;
		g_list_store_append (_tmp46_, (GObject*) _tmp47_);
		_g_object_unref0 (night_light_view);
	}
	_tmp49_ = onboarding_main_window_get_viewed (self, &_tmp50_);
	_tmp49__length1 = _tmp50_;
	_tmp51_ = _tmp49_;
	_tmp51__length1 = _tmp49__length1;
	if (_vala_string_array_contains (_tmp51_, _tmp51__length1, "housekeeping")) {
		_tmp48_ = TRUE;
	} else {
		_tmp48_ = guest_session;
	}
	if (!_tmp48_) {
		OnboardingHouseKeepingView* housekeeping_view = NULL;
		OnboardingHouseKeepingView* _tmp52_;
		GListStore* _tmp53_;
		OnboardingHouseKeepingView* _tmp54_;
		_tmp52_ = onboarding_house_keeping_view_new ();
		g_object_ref_sink (_tmp52_);
		housekeeping_view = _tmp52_;
		_tmp53_ = onboarding_main_window_pages;
		_tmp54_ = housekeeping_view;
		g_list_store_append (_tmp53_, (GObject*) _tmp54_);
		_g_object_unref0 (housekeeping_view);
	}
	_tmp56_ = onboarding_main_window_get_viewed (self, &_tmp57_);
	_tmp56__length1 = _tmp57_;
	_tmp58_ = _tmp56_;
	_tmp58__length1 = _tmp56__length1;
	if (_vala_string_array_contains (_tmp58_, _tmp58__length1, "onlineaccounts")) {
		_tmp55_ = TRUE;
	} else {
		_tmp55_ = guest_session;
	}
	if (!_tmp55_) {
		OnboardingOnlineAccountsView* onlineaccounts_view = NULL;
		OnboardingOnlineAccountsView* _tmp59_;
		GListStore* _tmp60_;
		OnboardingOnlineAccountsView* _tmp61_;
		_tmp59_ = onboarding_online_accounts_view_new ();
		g_object_ref_sink (_tmp59_);
		onlineaccounts_view = _tmp59_;
		_tmp60_ = onboarding_main_window_pages;
		_tmp61_ = onlineaccounts_view;
		g_list_store_append (_tmp60_, (GObject*) _tmp61_);
		_g_object_unref0 (onlineaccounts_view);
	}
	_tmp62_ = g_find_program_in_path ("io.elementary.appcenter");
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp63_ != NULL;
	_g_free0 (_tmp63_);
	if (_tmp64_) {
		gchar** _tmp65_;
		gint _tmp65__length1;
		gint _tmp66_ = 0;
		gchar** _tmp67_;
		gint _tmp67__length1;
		_tmp65_ = onboarding_main_window_get_viewed (self, &_tmp66_);
		_tmp65__length1 = _tmp66_;
		_tmp67_ = _tmp65_;
		_tmp67__length1 = _tmp65__length1;
		if (!_vala_string_array_contains (_tmp67_, _tmp67__length1, "appcenter")) {
			OnboardingAppCenterView* appcenter_view = NULL;
			OnboardingAppCenterView* _tmp68_;
			GListStore* _tmp69_;
			OnboardingAppCenterView* _tmp70_;
			_tmp68_ = onboarding_app_center_view_new ();
			g_object_ref_sink (_tmp68_);
			appcenter_view = _tmp68_;
			_tmp69_ = onboarding_main_window_pages;
			_tmp70_ = appcenter_view;
			g_list_store_append (_tmp69_, (GObject*) _tmp70_);
			_g_object_unref0 (appcenter_view);
		}
	}
	_tmp72_ = onboarding_main_window_get_viewed (self, &_tmp73_);
	_tmp72__length1 = _tmp73_;
	_tmp74_ = _tmp72_;
	_tmp74__length1 = _tmp72__length1;
	if (_vala_string_array_contains (_tmp74_, _tmp74__length1, "updates")) {
		_tmp71_ = TRUE;
	} else {
		_tmp71_ = guest_session;
	}
	if (!_tmp71_) {
		OnboardingUpdatesView* updates_view = NULL;
		OnboardingUpdatesView* _tmp75_;
		GListStore* _tmp76_;
		OnboardingUpdatesView* _tmp77_;
		_tmp75_ = onboarding_updates_view_new ();
		g_object_ref_sink (_tmp75_);
		updates_view = _tmp75_;
		_tmp76_ = onboarding_main_window_pages;
		_tmp77_ = updates_view;
		g_list_store_append (_tmp76_, (GObject*) _tmp77_);
		_g_object_unref0 (updates_view);
	}
	_tmp78_ = onboarding_main_window_pages;
	g_object_get (_tmp78_, "n-items", &_tmp79_, NULL);
	_tmp80_ = _tmp79_;
	if (_tmp80_ == ((guint) 1)) {
		GApplication* _tmp81_;
		_tmp81_ = g_application_get_default ();
		g_application_quit (_tmp81_);
	}
	if (early_access) {
		gchar** _tmp84_;
		gint _tmp84__length1;
		gint _tmp85_ = 0;
		gchar** _tmp86_;
		gint _tmp86__length1;
		_tmp84_ = onboarding_main_window_get_viewed (self, &_tmp85_);
		_tmp84__length1 = _tmp85_;
		_tmp86_ = _tmp84_;
		_tmp86__length1 = _tmp84__length1;
		_tmp83_ = _vala_string_array_contains (_tmp86_, _tmp86__length1, "welcome");
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		AdwNavigationView* _tmp87_;
		GListModel* _tmp88_;
		GListModel* _tmp89_;
		GListModel* _tmp90_;
		_tmp87_ = self->priv->navigation_view;
		_tmp88_ = adw_navigation_view_get_navigation_stack (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = _tmp89_;
		_tmp82_ = g_list_model_get_n_items (_tmp90_) == ((guint) 2);
		_g_object_unref0 (_tmp90_);
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		AdwNavigationView* _tmp91_;
		OnboardingWelcomeView* _tmp92_;
		_tmp91_ = self->priv->navigation_view;
		_tmp92_ = welcome_view;
		adw_navigation_view_remove (_tmp91_, (AdwNavigationPage*) _tmp92_);
	}
	_tmp93_ = onboarding_finish_view_new ();
	g_object_ref_sink (_tmp93_);
	_g_object_unref0 (self->priv->finish_view);
	self->priv->finish_view = _tmp93_;
	_tmp94_ = onboarding_main_window_pages;
	_tmp95_ = self->priv->finish_view;
	g_list_store_append (_tmp94_, (GObject*) _tmp95_);
	_tmp96_ = self->priv->navigation_view;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp96_);
	_tmp97_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp97_, FALSE);
	g_object_ref_sink (_tmp97_);
	_tmp98_ = _tmp97_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp98_);
	_g_object_unref0 (_tmp98_);
	gtk_widget_add_css_class ((GtkWidget*) self, "dialog");
	_tmp99_ = self->priv->navigation_view;
	g_signal_connect_object (_tmp99_, "get-next-page", (GCallback) _onboarding_main_window_get_next_page_adw_navigation_view_get_next_page, self, 0);
	_tmp100_ = g_simple_action_new ("back", NULL);
	back_action = _tmp100_;
	_tmp101_ = back_action;
	g_signal_connect_object (_tmp101_, "activate", (GCallback) __onboarding_main_window___lambda15__g_simple_action_activate, self, 0);
	_tmp102_ = g_simple_action_new ("next", NULL);
	next_action = _tmp102_;
	_tmp103_ = next_action;
	g_signal_connect_object (_tmp103_, "activate", (GCallback) _onboarding_main_window_action_next_g_simple_action_activate, self, 0);
	_tmp104_ = g_simple_action_new ("skip", NULL);
	skip_action = _tmp104_;
	_tmp105_ = skip_action;
	g_signal_connect_object (_tmp105_, "activate", (GCallback) _onboarding_main_window_action_skip_g_simple_action_activate, self, 0);
	_tmp106_ = back_action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp106_);
	_tmp107_ = next_action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp107_);
	_tmp108_ = skip_action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp108_);
	_tmp109_ = gtk_window_get_child ((GtkWindow*) self);
	_tmp110_ = _tmp109_;
	g_signal_connect_object (_tmp110_, "realize", (GCallback) __onboarding_main_window___lambda16__gtk_widget_realize, self, 0);
	_g_object_unref0 (skip_action);
	_g_object_unref0 (next_action);
	_g_object_unref0 (back_action);
	_g_object_unref0 (apt_sources);
	_g_object_unref0 (welcome_view);
	return obj;
}

static void
onboarding_main_window_class_init (OnboardingMainWindowClass * klass,
                                   gpointer klass_data)
{
	GListStore* _tmp0_;
	GSettings* _tmp1_;
	onboarding_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OnboardingMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_onboarding_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_onboarding_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = onboarding_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = onboarding_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ONBOARDING_MAIN_WINDOW_VIEWED_PROPERTY, onboarding_main_window_properties[ONBOARDING_MAIN_WINDOW_VIEWED_PROPERTY] = g_param_spec_boxed ("viewed", "viewed", "viewed", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_list_store_new (adw_navigation_page_get_type ());
	_g_object_unref0 (onboarding_main_window_pages);
	onboarding_main_window_pages = _tmp0_;
	_tmp1_ = g_settings_new ("io.elementary.onboarding");
	_g_object_unref0 (onboarding_main_window_settings);
	onboarding_main_window_settings = _tmp1_;
}

static void
onboarding_main_window_pantheon_wayland_extended_behavior_interface_init (PantheonWaylandExtendedBehaviorIface * iface,
                                                                          gpointer iface_data)
{
	onboarding_main_window_pantheon_wayland_extended_behavior_parent_iface = g_type_interface_peek_parent (iface);
}

static void
onboarding_main_window_instance_init (OnboardingMainWindow * self,
                                      gpointer klass)
{
	self->priv = onboarding_main_window_get_instance_private (self);
}

static void
onboarding_main_window_finalize (GObject * obj)
{
	OnboardingMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ONBOARDING_TYPE_MAIN_WINDOW, OnboardingMainWindow);
	self->priv->_viewed = (_vala_array_free (self->priv->_viewed, self->priv->_viewed_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->navigation_view);
	_g_object_unref0 (self->priv->finish_view);
	G_OBJECT_CLASS (onboarding_main_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
onboarding_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OnboardingMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) onboarding_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OnboardingMainWindow), 0, (GInstanceInitFunc) onboarding_main_window_instance_init, NULL };
	static const GInterfaceInfo pantheon_wayland_extended_behavior_info = { (GInterfaceInitFunc) onboarding_main_window_pantheon_wayland_extended_behavior_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType onboarding_main_window_type_id;
	onboarding_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "OnboardingMainWindow", &g_define_type_info, 0);
	g_type_add_interface_static (onboarding_main_window_type_id, PANTHEON_WAYLAND_TYPE_EXTENDED_BEHAVIOR, &pantheon_wayland_extended_behavior_info);
	OnboardingMainWindow_private_offset = g_type_add_instance_private (onboarding_main_window_type_id, sizeof (OnboardingMainWindowPrivate));
	return onboarding_main_window_type_id;
}

GType
onboarding_main_window_get_type (void)
{
	static volatile gsize onboarding_main_window_type_id__once = 0;
	if (g_once_init_enter (&onboarding_main_window_type_id__once)) {
		GType onboarding_main_window_type_id;
		onboarding_main_window_type_id = onboarding_main_window_get_type_once ();
		g_once_init_leave (&onboarding_main_window_type_id__once, onboarding_main_window_type_id);
	}
	return onboarding_main_window_type_id__once;
}

static void
_vala_onboarding_main_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	OnboardingMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ONBOARDING_TYPE_MAIN_WINDOW, OnboardingMainWindow);
	switch (property_id) {
		case ONBOARDING_MAIN_WINDOW_VIEWED_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, onboarding_main_window_get_viewed (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_onboarding_main_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	OnboardingMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ONBOARDING_TYPE_MAIN_WINDOW, OnboardingMainWindow);
	switch (property_id) {
		case ONBOARDING_MAIN_WINDOW_VIEWED_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			onboarding_main_window_set_viewed (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

