/* WebView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WebView.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <webkit2/webkit2.h>
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define MAIL_WEB_VIEW_INTERNAL_URL_BODY "elementary-mail:body"
#define MAIL_WEB_VIEW_SERVER_BUS_NAME "io.elementary.mail.WebViewServer"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_WEB_VIEW (mail_web_view_get_type ())
#define MAIL_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_WEB_VIEW, MailWebView))
#define MAIL_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_WEB_VIEW, MailWebViewClass))
#define MAIL_IS_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_WEB_VIEW))
#define MAIL_IS_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_WEB_VIEW))
#define MAIL_WEB_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_WEB_VIEW, MailWebViewClass))

typedef struct _MailWebView MailWebView;
typedef struct _MailWebViewClass MailWebViewClass;
typedef struct _MailWebViewPrivate MailWebViewPrivate;
enum  {
	MAIL_WEB_VIEW_0_PROPERTY,
	MAIL_WEB_VIEW_BIND_HEIGHT_TO_PAGE_HEIGHT_PROPERTY,
	MAIL_WEB_VIEW_BODY_HTML_CHANGED_PROPERTY,
	MAIL_WEB_VIEW_NUM_PROPERTIES
};
static GParamSpec* mail_web_view_properties[MAIL_WEB_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _MailWebViewGetSelectedTextData MailWebViewGetSelectedTextData;
typedef struct _MailWebViewQueryCommandStateData MailWebViewQueryCommandStateData;
typedef struct _Block23Data Block23Data;
typedef struct _MailWebViewGetBodyHtmlData MailWebViewGetBodyHtmlData;
enum  {
	MAIL_WEB_VIEW_IMAGE_LOAD_BLOCKED_SIGNAL,
	MAIL_WEB_VIEW_IMAGE_REMOVED_SIGNAL,
	MAIL_WEB_VIEW_LINK_ACTIVATED_SIGNAL,
	MAIL_WEB_VIEW_SELECTION_CHANGED_SIGNAL,
	MAIL_WEB_VIEW_LOAD_FINISHED_SIGNAL,
	MAIL_WEB_VIEW_NUM_SIGNALS
};
static guint mail_web_view_signals[MAIL_WEB_VIEW_NUM_SIGNALS] = {0};

struct _MailWebView {
	WebKitWebView parent_instance;
	MailWebViewPrivate * priv;
};

struct _MailWebViewClass {
	WebKitWebViewClass parent_class;
};

struct _MailWebViewPrivate {
	gboolean _bind_height_to_page_height;
	gboolean _body_html_changed;
	GeeMap* internal_resources;
	gboolean loaded;
	gboolean queued_load_images;
	GeeHashMap* queued_elements;
	GCancellable* cancellable;
};

struct _MailWebViewGetSelectedTextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailWebView* self;
	gchar* result;
	WebKitUserMessage* message;
	WebKitUserMessage* _tmp0_;
	WebKitUserMessage* response;
	GCancellable* _tmp1_;
	WebKitUserMessage* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError* e;
	GError* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

struct _MailWebViewQueryCommandStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailWebView* self;
	gchar* command;
	gboolean result;
	WebKitUserMessage* message;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	WebKitUserMessage* _tmp2_;
	WebKitUserMessage* _tmp3_;
	WebKitUserMessage* response;
	GCancellable* _tmp4_;
	WebKitUserMessage* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GError* e;
	GError* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _Block23Data {
	int _ref_count_;
	MailWebView* self;
	gchar* body_html;
	gboolean clean_for_sending;
	gpointer _async_data_;
};

struct _MailWebViewGetBodyHtmlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailWebView* self;
	gboolean clean_for_sending;
	gchar* result;
	Block23Data* _data23_;
	gboolean _tmp0_;
	GCancellable* _tmp1_;
	WebKitUserMessage* message;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	WebKitUserMessage* _tmp4_;
	WebKitUserMessage* _tmp5_;
	WebKitUserMessage* response;
	WebKitUserMessage* _tmp6_;
	GCancellable* _tmp7_;
	WebKitUserMessage* _tmp8_;
	WebKitUserMessage* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GError* e;
	GError* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_;
};

static gint MailWebView_private_offset;
static gpointer mail_web_view_parent_class = NULL;

VALA_EXTERN GType mail_web_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailWebView, g_object_unref)
VALA_EXTERN MailWebView* mail_web_view_new (void);
VALA_EXTERN MailWebView* mail_web_view_construct (GType object_type);
static void mail_web_view_on_load_changed (MailWebView* self,
                                    WebKitLoadEvent event);
static void mail_web_view_update_height (MailWebView* self);
VALA_EXTERN void mail_web_view_set_content_of_element (MailWebView* self,
                                           const gchar* element,
                                           const gchar* content);
VALA_EXTERN void mail_web_view_load_images (MailWebView* self);
VALA_EXTERN gboolean mail_web_view_get_bind_height_to_page_height (MailWebView* self);
static void __lambda58_ (MailWebView* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda58__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void mail_web_view_load_html (MailWebView* self,
                              const gchar* body);
static void mail_web_view_get_selected_text_data_free (gpointer _data);
VALA_EXTERN void mail_web_view_get_selected_text (MailWebView* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN gchar* mail_web_view_get_selected_text_finish (MailWebView* self,
                                               GAsyncResult* _res_);
static gboolean mail_web_view_get_selected_text_co (MailWebViewGetSelectedTextData* _data_);
static void mail_web_view_get_selected_text_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gboolean mail_web_view_on_decide_policy (MailWebView* self,
                                         WebKitWebView* view,
                                         WebKitPolicyDecision* policy,
                                         WebKitPolicyDecisionType type);
VALA_EXTERN void mail_web_view_add_internal_resource (MailWebView* self,
                                          const gchar* uri,
                                          GInputStream* data);
VALA_EXTERN void mail_web_view_execute_editor_command (MailWebView* self,
                                           const gchar* command,
                                           const gchar* argument);
static void mail_web_view_set_body_html_changed (MailWebView* self,
                                          gboolean value);
static void mail_web_view_query_command_state_data_free (gpointer _data);
VALA_EXTERN void mail_web_view_query_command_state (MailWebView* self,
                                        const gchar* command,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN gboolean mail_web_view_query_command_state_finish (MailWebView* self,
                                                   GAsyncResult* _res_);
static gboolean mail_web_view_query_command_state_co (MailWebViewQueryCommandStateData* _data_);
static void mail_web_view_query_command_state_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void mail_web_view_get_body_html_data_free (gpointer _data);
VALA_EXTERN void mail_web_view_get_body_html (MailWebView* self,
                                  gboolean clean_for_sending,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN gchar* mail_web_view_get_body_html_finish (MailWebView* self,
                                           GAsyncResult* _res_);
static gboolean mail_web_view_get_body_html_co (MailWebViewGetBodyHtmlData* _data_);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void ___lambda59_ (Block23Data* _data23_);
static void __lambda60_ (Block23Data* _data23_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda60__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ____lambda59__mail_web_view_load_finished (MailWebView* _sender,
                                                gpointer self);
static void mail_web_view_get_body_html_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void mail_web_view_handle_cid_request (MailWebView* self,
                                       WebKitURISchemeRequest* request);
static gboolean mail_web_view_handle_internal_response (MailWebView* self,
                                                 WebKitURISchemeRequest* request);
static gboolean mail_web_view_real_user_message_received (WebKitWebView* base,
                                                   WebKitUserMessage* message);
VALA_EXTERN void mail_web_view_set_bind_height_to_page_height (MailWebView* self,
                                                   gboolean value);
VALA_EXTERN gboolean mail_web_view_get_body_html_changed (MailWebView* self);
static GObject * mail_web_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static gboolean _mail_web_view_on_decide_policy_webkit_web_view_decide_policy (WebKitWebView* _sender,
                                                                        WebKitPolicyDecision* decision,
                                                                        WebKitPolicyDecisionType type,
                                                                        gpointer self);
static void _mail_web_view_on_load_changed_webkit_web_view_load_changed (WebKitWebView* _sender,
                                                                  WebKitLoadEvent load_event,
                                                                  gpointer self);
static void _mail_web_view___lambda61_ (MailWebView* self,
                                 WebKitWebResource* resource);
static void __lambda62_ (MailWebView* self);
static void ___lambda62__webkit_web_resource_finished (WebKitWebResource* _sender,
                                                gpointer self);
static void __mail_web_view___lambda61__webkit_web_view_resource_load_started (WebKitWebView* _sender,
                                                                        WebKitWebResource* resource,
                                                                        WebKitURIRequest* request,
                                                                        gpointer self);
static gboolean _mail_web_view___lambda63_ (MailWebView* self);
static gboolean __mail_web_view___lambda63__gtk_widget_key_release_event (GtkWidget* _sender,
                                                                   GdkEventKey* event,
                                                                   gpointer self);
static void _mail_web_view___lambda64_ (WebKitURISchemeRequest* req);
static void __mail_web_view___lambda64__web_kit_uri_scheme_request_callback (WebKitURISchemeRequest* request,
                                                                      gpointer self);
static void mail_web_view_finalize (GObject * obj);
static GType mail_web_view_get_type_once (void);
static void _vala_mail_web_view_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_mail_web_view_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
mail_web_view_get_instance_private (MailWebView* self)
{
	return G_STRUCT_MEMBER_P (self, MailWebView_private_offset);
}

MailWebView*
mail_web_view_construct (GType object_type)
{
	MailWebView * self = NULL;
	WebKitSettings* setts = NULL;
	WebKitSettings* _tmp0_;
	_tmp0_ = webkit_settings_new ();
	setts = _tmp0_;
	webkit_settings_set_allow_modal_dialogs (setts, FALSE);
	webkit_settings_set_enable_fullscreen (setts, FALSE);
	webkit_settings_set_enable_html5_database (setts, FALSE);
	webkit_settings_set_enable_html5_local_storage (setts, FALSE);
	webkit_settings_set_enable_java (setts, FALSE);
	webkit_settings_set_enable_javascript (setts, FALSE);
	webkit_settings_set_enable_media_stream (setts, FALSE);
	webkit_settings_set_enable_offline_web_application_cache (setts, FALSE);
	webkit_settings_set_enable_page_cache (setts, FALSE);
	webkit_settings_set_enable_plugins (setts, FALSE);
	self = (MailWebView*) g_object_new (object_type, "settings", setts, NULL);
	_g_object_unref0 (setts);
	return self;
}

MailWebView*
mail_web_view_new (void)
{
	return mail_web_view_construct (MAIL_TYPE_WEB_VIEW);
}

static void
mail_web_view_on_load_changed (MailWebView* self,
                               WebKitLoadEvent event)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (event == WEBKIT_LOAD_FINISHED) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event == WEBKIT_LOAD_COMMITTED;
	}
	if (_tmp0_) {
		mail_web_view_update_height (self);
	}
	if (event == WEBKIT_LOAD_FINISHED) {
		GeeHashMap* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		self->priv->loaded = TRUE;
		_tmp1_ = self->priv->queued_elements;
		_tmp2_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ > 0) {
			{
				GeeIterator* _element_it = NULL;
				GeeHashMap* _tmp4_;
				GeeSet* _tmp5_;
				GeeSet* _tmp6_;
				GeeSet* _tmp7_;
				GeeIterator* _tmp8_;
				GeeIterator* _tmp9_;
				_tmp4_ = self->priv->queued_elements;
				_tmp5_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = _tmp6_;
				_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp7_);
				_element_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_;
					gchar* element = NULL;
					GeeIterator* _tmp11_;
					gpointer _tmp12_;
					const gchar* _tmp13_;
					GeeHashMap* _tmp14_;
					const gchar* _tmp15_;
					gpointer _tmp16_;
					gchar* _tmp17_;
					_tmp10_ = _element_it;
					if (!gee_iterator_next (_tmp10_)) {
						break;
					}
					_tmp11_ = _element_it;
					_tmp12_ = gee_iterator_get (_tmp11_);
					element = (gchar*) _tmp12_;
					_tmp13_ = element;
					_tmp14_ = self->priv->queued_elements;
					_tmp15_ = element;
					_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
					_tmp17_ = (gchar*) _tmp16_;
					mail_web_view_set_content_of_element (self, _tmp13_, _tmp17_);
					_g_free0 (_tmp17_);
					_g_free0 (element);
				}
				_g_object_unref0 (_element_it);
			}
		}
		if (self->priv->queued_load_images) {
			mail_web_view_load_images (self);
		}
		g_signal_emit (self, mail_web_view_signals[MAIL_WEB_VIEW_LOAD_FINISHED_SIGNAL], 0);
	}
}

static void
__lambda58_ (MailWebView* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		WebKitUserMessage* response = NULL;
		WebKitUserMessage* _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		_tmp0_ = webkit_web_view_send_message_to_page_finish ((WebKitWebView*) self, res, &_inner_error0_);
		response = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = webkit_user_message_get_parameters (response);
		_tmp2_ = _tmp1_;
		g_object_set ((GtkWidget*) self, "height-request", (gint) g_variant_get_int32 (_tmp2_), NULL);
		_g_object_unref0 (response);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		if (!g_error_matches (_tmp3_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_critical ("WebView.vala:131: %s", _tmp5_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda58__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda58_ ((MailWebView*) self, source_object, res);
	g_object_unref (self);
}

static void
mail_web_view_update_height (MailWebView* self)
{
	gboolean _tmp0_;
	WebKitUserMessage* message = NULL;
	WebKitUserMessage* _tmp1_;
	WebKitUserMessage* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_bind_height_to_page_height;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = webkit_user_message_new ("get-page-height", NULL);
	g_object_ref_sink (_tmp1_);
	message = _tmp1_;
	_tmp2_ = message;
	_tmp3_ = self->priv->cancellable;
	webkit_web_view_send_message_to_page ((WebKitWebView*) self, _tmp2_, _tmp3_, ___lambda58__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (message);
}

void
mail_web_view_load_html (MailWebView* self,
                         const gchar* body)
{
	g_return_if_fail (self != NULL);
	webkit_web_view_load_html (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), body, MAIL_WEB_VIEW_INTERNAL_URL_BODY);
}

void
mail_web_view_set_content_of_element (MailWebView* self,
                                      const gchar* element,
                                      const gchar* content)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	g_return_if_fail (content != NULL);
	if (self->priv->loaded) {
		WebKitUserMessage* message = NULL;
		GVariant* _tmp0_;
		GVariant* _tmp1_;
		WebKitUserMessage* _tmp2_;
		WebKitUserMessage* _tmp3_;
		WebKitUserMessage* _tmp4_;
		GCancellable* _tmp5_;
		_tmp0_ = g_variant_new ("(ss)", element, content, NULL);
		g_variant_ref_sink (_tmp0_);
		_tmp1_ = _tmp0_;
		_tmp2_ = webkit_user_message_new ("set-content-of-element", _tmp1_);
		g_object_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		_g_variant_unref0 (_tmp1_);
		message = _tmp3_;
		_tmp4_ = message;
		_tmp5_ = self->priv->cancellable;
		webkit_web_view_send_message_to_page ((WebKitWebView*) self, _tmp4_, _tmp5_, NULL, NULL);
		_g_object_unref0 (message);
	} else {
		GeeHashMap* _tmp6_;
		_tmp6_ = self->priv->queued_elements;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, element, content);
	}
}

static void
mail_web_view_get_selected_text_data_free (gpointer _data)
{
	MailWebViewGetSelectedTextData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailWebViewGetSelectedTextData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
mail_web_view_get_selected_text (MailWebView* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	MailWebViewGetSelectedTextData* _data_;
	MailWebView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailWebViewGetSelectedTextData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_web_view_get_selected_text_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_web_view_get_selected_text_co (_data_);
}

gchar*
mail_web_view_get_selected_text_finish (MailWebView* self,
                                        GAsyncResult* _res_)
{
	gchar* result;
	MailWebViewGetSelectedTextData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
mail_web_view_get_selected_text_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	MailWebViewGetSelectedTextData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_web_view_get_selected_text_co (_data_);
}

static gboolean
mail_web_view_get_selected_text_co (MailWebViewGetSelectedTextData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = webkit_user_message_new ("get-selected-text", NULL);
		g_object_ref_sink (_data_->_tmp0_);
		_data_->message = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		webkit_web_view_send_message_to_page ((WebKitWebView*) _data_->self, _data_->message, _data_->_tmp1_, mail_web_view_get_selected_text_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = webkit_web_view_send_message_to_page_finish ((WebKitWebView*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->response = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->message);
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = webkit_user_message_get_parameters (_data_->response);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = g_variant_get_string (_data_->_tmp4_, NULL);
		_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
		_data_->result = _data_->_tmp6_;
		_g_object_unref0 (_data_->response);
		_g_object_unref0 (_data_->message);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->e;
		if (!g_error_matches (_data_->_tmp7_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			g_critical ("WebView.vala:158: %s", _data_->_tmp9_);
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
mail_web_view_on_decide_policy (MailWebView* self,
                                WebKitWebView* view,
                                WebKitPolicyDecision* policy,
                                WebKitPolicyDecisionType type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	g_return_val_if_fail (policy != NULL, FALSE);
	if (type == WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION;
	}
	if (_tmp0_) {
		WebKitNavigationPolicyDecision* nav_policy = NULL;
		WebKitNavigationPolicyDecision* _tmp1_;
		WebKitNavigationPolicyDecision* _tmp2_;
		WebKitNavigationAction* _tmp3_;
		WebKitNavigationAction* _tmp4_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (policy, webkit_navigation_policy_decision_get_type (), WebKitNavigationPolicyDecision));
		nav_policy = _tmp1_;
		_tmp2_ = nav_policy;
		_tmp3_ = webkit_navigation_policy_decision_get_navigation_action (_tmp2_);
		_tmp4_ = _tmp3_;
		if (webkit_navigation_action_get_navigation_type (_tmp4_) == WEBKIT_NAVIGATION_TYPE_LINK_CLICKED) {
			WebKitNavigationPolicyDecision* _tmp5_;
			WebKitNavigationAction* _tmp6_;
			WebKitNavigationAction* _tmp7_;
			WebKitURIRequest* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = nav_policy;
			_tmp6_ = webkit_navigation_policy_decision_get_navigation_action (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = webkit_navigation_action_get_request (_tmp7_);
			_tmp9_ = webkit_uri_request_get_uri (_tmp8_);
			_tmp10_ = _tmp9_;
			g_signal_emit (self, mail_web_view_signals[MAIL_WEB_VIEW_LINK_ACTIVATED_SIGNAL], 0, _tmp10_);
		} else {
			WebKitNavigationPolicyDecision* _tmp11_;
			WebKitNavigationAction* _tmp12_;
			WebKitNavigationAction* _tmp13_;
			_tmp11_ = nav_policy;
			_tmp12_ = webkit_navigation_policy_decision_get_navigation_action (_tmp11_);
			_tmp13_ = _tmp12_;
			if (webkit_navigation_action_get_navigation_type (_tmp13_) == WEBKIT_NAVIGATION_TYPE_OTHER) {
				WebKitNavigationPolicyDecision* _tmp14_;
				WebKitNavigationAction* _tmp15_;
				WebKitNavigationAction* _tmp16_;
				WebKitURIRequest* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				_tmp14_ = nav_policy;
				_tmp15_ = webkit_navigation_policy_decision_get_navigation_action (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = webkit_navigation_action_get_request (_tmp16_);
				_tmp18_ = webkit_uri_request_get_uri (_tmp17_);
				_tmp19_ = _tmp18_;
				if (g_strcmp0 (_tmp19_, MAIL_WEB_VIEW_INTERNAL_URL_BODY) == 0) {
					webkit_policy_decision_use (policy);
					result = GDK_EVENT_STOP;
					_g_object_unref0 (nav_policy);
					return result;
				}
			}
		}
		_g_object_unref0 (nav_policy);
	}
	webkit_policy_decision_ignore (policy);
	result = GDK_EVENT_STOP;
	return result;
}

void
mail_web_view_add_internal_resource (MailWebView* self,
                                     const gchar* uri,
                                     GInputStream* data)
{
	GeeMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->internal_resources;
	gee_map_set (_tmp0_, uri, data);
}

void
mail_web_view_load_images (MailWebView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->loaded) {
		WebKitUserMessage* message = NULL;
		GVariant* _tmp0_;
		GVariant* _tmp1_;
		WebKitUserMessage* _tmp2_;
		WebKitUserMessage* _tmp3_;
		WebKitUserMessage* _tmp4_;
		GCancellable* _tmp5_;
		_tmp0_ = g_variant_new_boolean (TRUE);
		g_variant_ref_sink (_tmp0_);
		_tmp1_ = _tmp0_;
		_tmp2_ = webkit_user_message_new ("set-image-loading-enabled", _tmp1_);
		g_object_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		_g_variant_unref0 (_tmp1_);
		message = _tmp3_;
		_tmp4_ = message;
		_tmp5_ = self->priv->cancellable;
		webkit_web_view_send_message_to_page ((WebKitWebView*) self, _tmp4_, _tmp5_, NULL, NULL);
		_g_object_unref0 (message);
	} else {
		self->priv->queued_load_images = TRUE;
	}
}

void
mail_web_view_execute_editor_command (MailWebView* self,
                                      const gchar* command,
                                      const gchar* argument)
{
	WebKitUserMessage* message = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	WebKitUserMessage* _tmp2_;
	WebKitUserMessage* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = g_variant_new ("(ss)", command, argument, NULL);
	g_variant_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = webkit_user_message_new ("execute-editor-command", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_variant_unref0 (_tmp1_);
	message = _tmp3_;
	_tmp4_ = self->priv->cancellable;
	webkit_web_view_send_message_to_page ((WebKitWebView*) self, message, _tmp4_, NULL, NULL);
	mail_web_view_set_body_html_changed (self, TRUE);
	_g_object_unref0 (message);
}

static void
mail_web_view_query_command_state_data_free (gpointer _data)
{
	MailWebViewQueryCommandStateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailWebViewQueryCommandStateData, _data_);
}

void
mail_web_view_query_command_state (MailWebView* self,
                                   const gchar* command,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	MailWebViewQueryCommandStateData* _data_;
	MailWebView* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_data_ = g_slice_new0 (MailWebViewQueryCommandStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_web_view_query_command_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (command);
	_g_free0 (_data_->command);
	_data_->command = _tmp1_;
	mail_web_view_query_command_state_co (_data_);
}

gboolean
mail_web_view_query_command_state_finish (MailWebView* self,
                                          GAsyncResult* _res_)
{
	gboolean result;
	MailWebViewQueryCommandStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
mail_web_view_query_command_state_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	MailWebViewQueryCommandStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_web_view_query_command_state_co (_data_);
}

static gboolean
mail_web_view_query_command_state_co (MailWebViewQueryCommandStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_variant_new_string (_data_->command);
		g_variant_ref_sink (_data_->_tmp0_);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_tmp2_ = webkit_user_message_new ("query-command-state", _data_->_tmp1_);
		g_object_ref_sink (_data_->_tmp2_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_g_variant_unref0 (_data_->_tmp1_);
		_data_->message = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		webkit_web_view_send_message_to_page ((WebKitWebView*) _data_->self, _data_->message, _data_->_tmp4_, mail_web_view_query_command_state_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = webkit_web_view_send_message_to_page_finish ((WebKitWebView*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->response = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->message);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = webkit_user_message_get_parameters (_data_->response);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->result = g_variant_get_boolean (_data_->_tmp7_);
		_g_object_unref0 (_data_->response);
		_g_object_unref0 (_data_->message);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		if (!g_error_matches (_data_->_tmp8_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			g_critical ("WebView.vala:210: %s", _data_->_tmp10_);
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_web_view_get_body_html_data_free (gpointer _data)
{
	MailWebViewGetBodyHtmlData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailWebViewGetBodyHtmlData, _data_);
}

void
mail_web_view_get_body_html (MailWebView* self,
                             gboolean clean_for_sending,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	MailWebViewGetBodyHtmlData* _data_;
	MailWebView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailWebViewGetBodyHtmlData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_web_view_get_body_html_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->clean_for_sending = clean_for_sending;
	mail_web_view_get_body_html_co (_data_);
}

gchar*
mail_web_view_get_body_html_finish (MailWebView* self,
                                    GAsyncResult* _res_)
{
	gchar* result;
	MailWebViewGetBodyHtmlData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		MailWebView* self;
		self = _data23_->self;
		_g_free0 (_data23_->body_html);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
__lambda60_ (Block23Data* _data23_,
             GObject* obj,
             GAsyncResult* res)
{
	MailWebView* self;
	gchar* _tmp0_;
	self = _data23_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = mail_web_view_get_body_html_finish (self, res);
	_g_free0 (_data23_->body_html);
	_data23_->body_html = _tmp0_;
	mail_web_view_get_body_html_co (_data23_->_async_data_);
}

static void
___lambda60__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda60_ (self, source_object, res);
	block23_data_unref (self);
}

static void
___lambda59_ (Block23Data* _data23_)
{
	MailWebView* self;
	self = _data23_->self;
	mail_web_view_get_body_html (self, _data23_->clean_for_sending, ___lambda60__gasync_ready_callback, block23_data_ref (_data23_));
}

static void
____lambda59__mail_web_view_load_finished (MailWebView* _sender,
                                           gpointer self)
{
	___lambda59_ (self);
}

static void
mail_web_view_get_body_html_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	MailWebViewGetBodyHtmlData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_web_view_get_body_html_co (_data_);
}

static gboolean
mail_web_view_get_body_html_co (MailWebViewGetBodyHtmlData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data23_ = g_slice_new0 (Block23Data);
	_data_->_data23_->_ref_count_ = 1;
	_data_->_data23_->self = g_object_ref (_data_->self);
	_data_->_data23_->clean_for_sending = _data_->clean_for_sending;
	_data_->_data23_->_async_data_ = _data_;
	_data_->_data23_->body_html = NULL;
	if (!_data_->self->priv->loaded) {
		_data_->_tmp1_ = _data_->self->priv->cancellable;
		_data_->_tmp0_ = !g_cancellable_is_cancelled (_data_->_tmp1_);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		g_signal_connect_data (_data_->self, "load-finished", (GCallback) ____lambda59__mail_web_view_load_finished, block23_data_ref (_data_->_data23_), (GClosureNotify) block23_data_unref, 0);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	} else {
		{
			_data_->_tmp2_ = g_variant_new_boolean (_data_->_data23_->clean_for_sending);
			g_variant_ref_sink (_data_->_tmp2_);
			_data_->_tmp3_ = _data_->_tmp2_;
			_data_->_tmp4_ = webkit_user_message_new ("get-body-html", _data_->_tmp3_);
			g_object_ref_sink (_data_->_tmp4_);
			_data_->_tmp5_ = _data_->_tmp4_;
			_g_variant_unref0 (_data_->_tmp3_);
			_data_->message = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->message;
			_data_->_tmp7_ = _data_->self->priv->cancellable;
			_data_->_state_ = 2;
			webkit_web_view_send_message_to_page ((WebKitWebView*) _data_->self, _data_->_tmp6_, _data_->_tmp7_, mail_web_view_get_body_html_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp8_ = webkit_web_view_send_message_to_page_finish ((WebKitWebView*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->response = _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->message);
				goto __catch0_g_error;
			}
			_data_->_tmp9_ = _data_->response;
			_data_->_tmp10_ = webkit_user_message_get_parameters (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = g_variant_get_string (_data_->_tmp11_, NULL);
			_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
			_g_free0 (_data_->_data23_->body_html);
			_data_->_data23_->body_html = _data_->_tmp13_;
			_g_object_unref0 (_data_->response);
			_g_object_unref0 (_data_->message);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp14_ = _data_->e;
			if (!g_error_matches (_data_->_tmp14_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				_data_->_tmp15_ = _data_->e;
				_data_->_tmp16_ = _data_->_tmp15_->message;
				g_critical ("WebView.vala:246: %s", _data_->_tmp16_);
			}
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block23_data_unref (_data_->_data23_);
			_data_->_data23_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp17_ = _data_->_data23_->body_html;
	_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
	_data_->result = _data_->_tmp18_;
	block23_data_unref (_data_->_data23_);
	_data_->_data23_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_web_view_handle_cid_request (MailWebView* self,
                                  WebKitURISchemeRequest* request)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	if (!mail_web_view_handle_internal_response (self, request)) {
		GError* _tmp0_;
		GError* _tmp1_;
		_tmp0_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_NOENT, "Unknown CID");
		_tmp1_ = _tmp0_;
		webkit_uri_scheme_request_finish_error (request, _tmp1_);
		_g_error_free0 (_tmp1_);
	}
}

static gboolean
mail_web_view_handle_internal_response (MailWebView* self,
                                        WebKitURISchemeRequest* request)
{
	gchar* uri = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GInputStream* buf = NULL;
	GeeMap* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	GInputStream* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = webkit_uri_scheme_request_get_uri (request);
	_tmp1_ = g_uri_unescape_string (_tmp0_, NULL);
	uri = _tmp1_;
	_tmp2_ = self->priv->internal_resources;
	_tmp3_ = uri;
	_tmp4_ = gee_map_get (_tmp2_, _tmp3_);
	buf = (GInputStream*) _tmp4_;
	_tmp5_ = buf;
	if (_tmp5_ != NULL) {
		GInputStream* _tmp6_;
		_tmp6_ = buf;
		webkit_uri_scheme_request_finish (request, _tmp6_, (gint64) -1, NULL);
		result = TRUE;
		_g_object_unref0 (buf);
		_g_free0 (uri);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (buf);
	_g_free0 (uri);
	return result;
}

static gboolean
mail_web_view_real_user_message_received (WebKitWebView* base,
                                          WebKitUserMessage* message)
{
	MailWebView * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	gboolean result;
	self = (MailWebView*) base;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = webkit_user_message_get_name (message);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("image-load-blocked")))) {
		switch (0) {
			default:
			{
				if (!self->priv->queued_load_images) {
					g_signal_emit (self, mail_web_view_signals[MAIL_WEB_VIEW_IMAGE_LOAD_BLOCKED_SIGNAL], 0);
				}
				result = TRUE;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("image-removed")))) {
		switch (0) {
			default:
			{
				const gchar* uri = NULL;
				GVariant* _tmp5_;
				GVariant* _tmp6_;
				const gchar* _tmp7_;
				GeeMap* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp5_ = webkit_user_message_get_parameters (message);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_variant_get_string (_tmp6_, NULL);
				uri = _tmp7_;
				_tmp8_ = self->priv->internal_resources;
				_tmp9_ = uri;
				gee_map_unset (_tmp8_, _tmp9_, NULL);
				_tmp10_ = uri;
				g_signal_emit (self, mail_web_view_signals[MAIL_WEB_VIEW_IMAGE_REMOVED_SIGNAL], 0, _tmp10_);
				result = TRUE;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("selection-changed")))) {
		switch (0) {
			default:
			{
				g_signal_emit (self, mail_web_view_signals[MAIL_WEB_VIEW_SELECTION_CHANGED_SIGNAL], 0);
				result = TRUE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = webkit_user_message_get_name (message);
				_tmp12_ = _tmp11_;
				g_critical ("WebView.vala:292: Unhandled message: %s", _tmp12_);
				break;
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
mail_web_view_get_bind_height_to_page_height (MailWebView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_bind_height_to_page_height;
	return result;
}

void
mail_web_view_set_bind_height_to_page_height (MailWebView* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_web_view_get_bind_height_to_page_height (self);
	if (old_value != value) {
		self->priv->_bind_height_to_page_height = value;
		g_object_notify_by_pspec ((GObject *) self, mail_web_view_properties[MAIL_WEB_VIEW_BIND_HEIGHT_TO_PAGE_HEIGHT_PROPERTY]);
	}
}

gboolean
mail_web_view_get_body_html_changed (MailWebView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_body_html_changed;
	return result;
}

static void
mail_web_view_set_body_html_changed (MailWebView* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_web_view_get_body_html_changed (self);
	if (old_value != value) {
		self->priv->_body_html_changed = value;
		g_object_notify_by_pspec ((GObject *) self, mail_web_view_properties[MAIL_WEB_VIEW_BODY_HTML_CHANGED_PROPERTY]);
	}
}

static gboolean
_mail_web_view_on_decide_policy_webkit_web_view_decide_policy (WebKitWebView* _sender,
                                                               WebKitPolicyDecision* decision,
                                                               WebKitPolicyDecisionType type,
                                                               gpointer self)
{
	gboolean result;
	result = mail_web_view_on_decide_policy ((MailWebView*) self, _sender, decision, type);
	return result;
}

static void
_mail_web_view_on_load_changed_webkit_web_view_load_changed (WebKitWebView* _sender,
                                                             WebKitLoadEvent load_event,
                                                             gpointer self)
{
	mail_web_view_on_load_changed ((MailWebView*) self, load_event);
}

static void
__lambda62_ (MailWebView* self)
{
	mail_web_view_update_height (self);
}

static void
___lambda62__webkit_web_resource_finished (WebKitWebResource* _sender,
                                           gpointer self)
{
	__lambda62_ ((MailWebView*) self);
}

static void
_mail_web_view___lambda61_ (MailWebView* self,
                            WebKitWebResource* resource)
{
	g_return_if_fail (resource != NULL);
	g_signal_connect_object (resource, "finished", (GCallback) ___lambda62__webkit_web_resource_finished, self, 0);
}

static void
__mail_web_view___lambda61__webkit_web_view_resource_load_started (WebKitWebView* _sender,
                                                                   WebKitWebResource* resource,
                                                                   WebKitURIRequest* request,
                                                                   gpointer self)
{
	_mail_web_view___lambda61_ ((MailWebView*) self, resource);
}

static gboolean
_mail_web_view___lambda63_ (MailWebView* self)
{
	mail_web_view_set_body_html_changed (self, TRUE);
}

static gboolean
__mail_web_view___lambda63__gtk_widget_key_release_event (GtkWidget* _sender,
                                                          GdkEventKey* event,
                                                          gpointer self)
{
	gboolean result;
	result = _mail_web_view___lambda63_ ((MailWebView*) self);
	return result;
}

static GObject *
mail_web_view_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailWebView * self;
	GCancellable* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	parent_class = G_OBJECT_CLASS (mail_web_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_WEB_VIEW, MailWebView);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_input_stream_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->internal_resources);
	self->priv->internal_resources = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->queued_elements);
	self->priv->queued_elements = _tmp2_;
	g_signal_connect_object ((WebKitWebView*) self, "decide-policy", (GCallback) _mail_web_view_on_decide_policy_webkit_web_view_decide_policy, self, 0);
	g_signal_connect_object ((WebKitWebView*) self, "load-changed", (GCallback) _mail_web_view_on_load_changed_webkit_web_view_load_changed, self, 0);
	g_signal_connect_object ((WebKitWebView*) self, "resource-load-started", (GCallback) __mail_web_view___lambda61__webkit_web_view_resource_load_started, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) __mail_web_view___lambda63__gtk_widget_key_release_event, self, 0);
	return obj;
}

static void
_mail_web_view___lambda64_ (WebKitURISchemeRequest* req)
{
	MailWebView* view = NULL;
	WebKitWebView* _tmp0_;
	MailWebView* _tmp1_;
	MailWebView* _tmp2_;
	g_return_if_fail (req != NULL);
	_tmp0_ = webkit_uri_scheme_request_get_web_view (req);
	_tmp1_ = _g_object_ref0 (MAIL_IS_WEB_VIEW (_tmp0_) ? ((MailWebView*) _tmp0_) : NULL);
	view = _tmp1_;
	_tmp2_ = view;
	if (_tmp2_ != NULL) {
		MailWebView* _tmp3_;
		_tmp3_ = view;
		mail_web_view_handle_cid_request (_tmp3_, req);
	}
	_g_object_unref0 (view);
}

static void
__mail_web_view___lambda64__web_kit_uri_scheme_request_callback (WebKitURISchemeRequest* request,
                                                                 gpointer self)
{
	_mail_web_view___lambda64_ (request);
}

static void
mail_web_view_class_init (MailWebViewClass * klass,
                          gpointer klass_data)
{
	WebKitWebContext* context = NULL;
	WebKitWebContext* _tmp0_;
	const gchar* webkit_extension_path_env = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	WebKitWebContext* _tmp4_;
	WebKitWebContext* _tmp5_;
	WebKitWebContext* _tmp6_;
	mail_web_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailWebView_private_offset);
	((WebKitWebViewClass *) klass)->user_message_received = (gboolean (*) (WebKitWebView*, WebKitUserMessage*)) mail_web_view_real_user_message_received;
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_web_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_web_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_web_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_web_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_WEB_VIEW_BIND_HEIGHT_TO_PAGE_HEIGHT_PROPERTY, mail_web_view_properties[MAIL_WEB_VIEW_BIND_HEIGHT_TO_PAGE_HEIGHT_PROPERTY] = g_param_spec_boolean ("bind-height-to-page-height", "bind-height-to-page-height", "bind-height-to-page-height", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_WEB_VIEW_BODY_HTML_CHANGED_PROPERTY, mail_web_view_properties[MAIL_WEB_VIEW_BODY_HTML_CHANGED_PROPERTY] = g_param_spec_boolean ("body-html-changed", "body-html-changed", "body-html-changed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	mail_web_view_signals[MAIL_WEB_VIEW_IMAGE_LOAD_BLOCKED_SIGNAL] = g_signal_new ("image-load-blocked", MAIL_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	mail_web_view_signals[MAIL_WEB_VIEW_IMAGE_REMOVED_SIGNAL] = g_signal_new ("image-removed", MAIL_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	mail_web_view_signals[MAIL_WEB_VIEW_LINK_ACTIVATED_SIGNAL] = g_signal_new ("link-activated", MAIL_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	mail_web_view_signals[MAIL_WEB_VIEW_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", MAIL_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	mail_web_view_signals[MAIL_WEB_VIEW_LOAD_FINISHED_SIGNAL] = g_signal_new ("load-finished", MAIL_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = webkit_web_context_get_default ();
	context = _tmp0_;
	_tmp1_ = g_getenv ("WEBKIT_EXTENSION_PATH");
	webkit_extension_path_env = _tmp1_;
	_tmp3_ = webkit_extension_path_env;
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		_tmp2_ = WEBKIT_EXTENSION_PATH;
	}
	_tmp4_ = context;
	webkit_web_context_set_web_extensions_directory (_tmp4_, _tmp2_);
	_tmp5_ = context;
	webkit_web_context_set_sandbox_enabled (_tmp5_, TRUE);
	_tmp6_ = context;
	webkit_web_context_register_uri_scheme (_tmp6_, "cid", __mail_web_view___lambda64__web_kit_uri_scheme_request_callback, NULL, NULL);
}

static void
mail_web_view_instance_init (MailWebView * self,
                             gpointer klass)
{
	self->priv = mail_web_view_get_instance_private (self);
	self->priv->_bind_height_to_page_height = FALSE;
	self->priv->_body_html_changed = FALSE;
	self->priv->loaded = FALSE;
	self->priv->queued_load_images = FALSE;
}

static void
mail_web_view_finalize (GObject * obj)
{
	MailWebView * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_WEB_VIEW, MailWebView);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	_g_object_unref0 (self->priv->internal_resources);
	_g_object_unref0 (self->priv->queued_elements);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (mail_web_view_parent_class)->finalize (obj);
}

static GType
mail_web_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailWebViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_web_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailWebView), 0, (GInstanceInitFunc) mail_web_view_instance_init, NULL };
	GType mail_web_view_type_id;
	mail_web_view_type_id = g_type_register_static (webkit_web_view_get_type (), "MailWebView", &g_define_type_info, 0);
	MailWebView_private_offset = g_type_add_instance_private (mail_web_view_type_id, sizeof (MailWebViewPrivate));
	return mail_web_view_type_id;
}

GType
mail_web_view_get_type (void)
{
	static volatile gsize mail_web_view_type_id__once = 0;
	if (g_once_init_enter (&mail_web_view_type_id__once)) {
		GType mail_web_view_type_id;
		mail_web_view_type_id = mail_web_view_get_type_once ();
		g_once_init_leave (&mail_web_view_type_id__once, mail_web_view_type_id);
	}
	return mail_web_view_type_id__once;
}

static void
_vala_mail_web_view_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	MailWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_WEB_VIEW, MailWebView);
	switch (property_id) {
		case MAIL_WEB_VIEW_BIND_HEIGHT_TO_PAGE_HEIGHT_PROPERTY:
		g_value_set_boolean (value, mail_web_view_get_bind_height_to_page_height (self));
		break;
		case MAIL_WEB_VIEW_BODY_HTML_CHANGED_PROPERTY:
		g_value_set_boolean (value, mail_web_view_get_body_html_changed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_web_view_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	MailWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_WEB_VIEW, MailWebView);
	switch (property_id) {
		case MAIL_WEB_VIEW_BIND_HEIGHT_TO_PAGE_HEIGHT_PROPERTY:
		mail_web_view_set_bind_height_to_page_height (self, g_value_get_boolean (value));
		break;
		case MAIL_WEB_VIEW_BODY_HTML_CHANGED_PROPERTY:
		mail_web_view_set_body_html_changed (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

