/* MessageList.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MessageList.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <camel/camel.h>
#include <gio/gio.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define MAIL_MAIN_WINDOW_ACTION_FORWARD "forward"
#define MAIL_MAIN_WINDOW_ACTION_REPLY_ALL "reply-all"
#define MAIL_MAIN_WINDOW_ACTION_REPLY "reply"
#define MAIL_MAIN_WINDOW_ACTION_MODIFY "modify"
#define MAIL_MAIN_WINDOW_ACTION_ARCHIVE "archive"
#define MAIL_MAIN_WINDOW_ACTION_MOVE "move"
#define MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH "trash"
#define MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "."
#define MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD "mark-unread"
#define MAIL_MAIN_WINDOW_ACTION_MARK_READ "mark-read"
#define MAIL_MAIN_WINDOW_ACTION_MARK_STAR "mark-star"
#define MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR "mark-unstar"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_MESSAGE_LIST (mail_message_list_get_type ())
#define MAIL_MESSAGE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MESSAGE_LIST, MailMessageList))
#define MAIL_MESSAGE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MESSAGE_LIST, MailMessageListClass))
#define MAIL_IS_MESSAGE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MESSAGE_LIST))
#define MAIL_IS_MESSAGE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MESSAGE_LIST))
#define MAIL_MESSAGE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MESSAGE_LIST, MailMessageListClass))

typedef struct _MailMessageList MailMessageList;
typedef struct _MailMessageListClass MailMessageListClass;
typedef struct _MailMessageListPrivate MailMessageListPrivate;

#define MAIL_TYPE_FOLDER_POPOVER (mail_folder_popover_get_type ())
#define MAIL_FOLDER_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_FOLDER_POPOVER, MailFolderPopover))
#define MAIL_FOLDER_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_FOLDER_POPOVER, MailFolderPopoverClass))
#define MAIL_IS_FOLDER_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_FOLDER_POPOVER))
#define MAIL_IS_FOLDER_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_FOLDER_POPOVER))
#define MAIL_FOLDER_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_FOLDER_POPOVER, MailFolderPopoverClass))

typedef struct _MailFolderPopover MailFolderPopover;
typedef struct _MailFolderPopoverClass MailFolderPopoverClass;

#define MAIL_TYPE_MESSAGE_LIST_ITEM (mail_message_list_item_get_type ())
#define MAIL_MESSAGE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem))
#define MAIL_MESSAGE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItemClass))
#define MAIL_IS_MESSAGE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MESSAGE_LIST_ITEM))
#define MAIL_IS_MESSAGE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MESSAGE_LIST_ITEM))
#define MAIL_MESSAGE_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItemClass))

typedef struct _MailMessageListItem MailMessageListItem;
typedef struct _MailMessageListItemClass MailMessageListItemClass;
enum  {
	MAIL_MESSAGE_LIST_0_PROPERTY,
	MAIL_MESSAGE_LIST_HEADERBAR_PROPERTY,
	MAIL_MESSAGE_LIST_NUM_PROPERTIES
};
static GParamSpec* mail_message_list_properties[MAIL_MESSAGE_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block47Data Block47Data;
typedef enum  {
	MAIL_COMPOSER_TYPE_REPLY,
	MAIL_COMPOSER_TYPE_REPLY_ALL,
	MAIL_COMPOSER_TYPE_FORWARD,
	MAIL_COMPOSER_TYPE_DRAFT
} MailComposerType;

#define MAIL_COMPOSER_TYPE_TYPE (mail_composer_type_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAIL_TYPE_COMPOSER (mail_composer_get_type ())
#define MAIL_COMPOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_COMPOSER, MailComposer))
#define MAIL_COMPOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_COMPOSER, MailComposerClass))
#define MAIL_IS_COMPOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_COMPOSER))
#define MAIL_IS_COMPOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_COMPOSER))
#define MAIL_COMPOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_COMPOSER, MailComposerClass))

typedef struct _MailComposer MailComposer;
typedef struct _MailComposerClass MailComposerClass;
typedef struct _MailMessageListComposeData MailMessageListComposeData;
enum  {
	MAIL_MESSAGE_LIST_HOVERING_OVER_LINK_SIGNAL,
	MAIL_MESSAGE_LIST_NUM_SIGNALS
};
static guint mail_message_list_signals[MAIL_MESSAGE_LIST_NUM_SIGNALS] = {0};

struct _MailMessageList {
	GtkBox parent_instance;
	MailMessageListPrivate * priv;
};

struct _MailMessageListClass {
	GtkBoxClass parent_class;
};

struct _MailMessageListPrivate {
	HdyHeaderBar* _headerbar;
	MailFolderPopover* folder_popover;
	GtkListBox* list_box;
	GtkScrolledWindow* scrolled_window;
	GeeHashMap* messages;
};

struct _Block47Data {
	int _ref_count_;
	MailMessageList* self;
	MailMessageListItem* list_item;
};

struct _MailMessageListComposeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageList* self;
	MailComposerType type;
	GVariant* uid;
	GtkListBoxRow* last_child;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBoxRow* _tmp6_;
	GtkListBoxRow* _tmp7_;
	MailMessageListItem* message_item;
	const gchar* _tmp8_;
	GtkListBoxRow* _tmp9_;
	MailMessageListItem* _tmp10_;
	GeeHashMap* _tmp11_;
	const gchar* _tmp12_;
	gpointer _tmp13_;
	gchar* content_to_quote;
	gchar* _tmp14_;
	CamelMimeMessage* mime_message;
	CamelMessageInfo* message_info;
	MailMessageListItem* _tmp15_;
	gchar* _tmp16_;
	MailMessageListItem* _tmp17_;
	CamelMimeMessage* _tmp18_;
	CamelMimeMessage* _tmp19_;
	CamelMimeMessage* _tmp20_;
	MailMessageListItem* _tmp21_;
	CamelMessageInfo* _tmp22_;
	CamelMessageInfo* _tmp23_;
	CamelMessageInfo* _tmp24_;
	MailComposer* composer;
	CamelMessageInfo* _tmp25_;
	CamelMimeMessage* _tmp26_;
	const gchar* _tmp27_;
	MailComposer* _tmp28_;
	MailComposer* _tmp29_;
	MailComposer* _tmp30_;
};

static gint MailMessageList_private_offset;
static gpointer mail_message_list_parent_class = NULL;

VALA_EXTERN GType mail_message_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMessageList, g_object_unref)
VALA_EXTERN GType mail_folder_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailFolderPopover, g_object_unref)
VALA_EXTERN GType mail_message_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMessageListItem, g_object_unref)
VALA_EXTERN void mail_message_list_set_conversation (MailMessageList* self,
                                         CamelFolderThreadNode* node);
static void mail_message_list_can_reply (MailMessageList* self,
                                  gboolean enabled);
static void mail_message_list_can_move_thread (MailMessageList* self,
                                        gboolean enabled);
static void __lambda84_ (MailMessageList* self,
                  GtkWidget* child);
static void ___lambda84__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void mail_folder_popover_set_store (MailFolderPopover* self,
                                    CamelStore* store);
VALA_EXTERN MailMessageListItem* mail_message_list_item_new (CamelMessageInfo* message_info);
VALA_EXTERN MailMessageListItem* mail_message_list_item_construct (GType object_type,
                                                       CamelMessageInfo* message_info);
static void mail_message_list_go_down (MailMessageList* self,
                                CamelFolderThreadNode* node);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
VALA_EXTERN void mail_message_list_item_set_expanded (MailMessageListItem* self,
                                          gboolean value);
VALA_EXTERN gboolean mail_message_list_item_get_loaded (MailMessageListItem* self);
static void ____lambda85_ (Block47Data* _data47_);
static void _____lambda85__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
VALA_EXTERN GType mail_composer_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void mail_message_list_compose (MailMessageList* self,
                                MailComposerType type,
                                GVariant* uid,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN void mail_message_list_compose_finish (MailMessageList* self,
                                       GAsyncResult* _res_);
static GVariant* _variant_new20 (const gchar* value);
static void mail_message_list_compose_data_free (gpointer _data);
static gboolean mail_message_list_compose_co (MailMessageListComposeData* _data_);
VALA_EXTERN void mail_message_list_item_get_message_body_html (MailMessageListItem* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN gchar* mail_message_list_item_get_message_body_html_finish (MailMessageListItem* self,
                                                            GAsyncResult* _res_);
static void mail_message_list_compose_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
VALA_EXTERN CamelMimeMessage* mail_message_list_item_get_mime_message (MailMessageListItem* self);
VALA_EXTERN CamelMessageInfo* mail_message_list_item_get_message_info (MailMessageListItem* self);
VALA_EXTERN GType mail_composer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailComposer, g_object_unref)
VALA_EXTERN MailComposer* mail_composer_new_with_quote (MailComposerType type,
                                            CamelMessageInfo* info,
                                            CamelMimeMessage* message,
                                            const gchar* content);
VALA_EXTERN MailComposer* mail_composer_construct_with_quote (GType object_type,
                                                  MailComposerType type,
                                                  CamelMessageInfo* info,
                                                  CamelMimeMessage* message,
                                                  const gchar* content);
static void __lambda123_ (MailMessageList* self);
static void ___lambda123__mail_composer_finished (MailComposer* _sender,
                                           gpointer self);
VALA_EXTERN void mail_message_list_print (MailMessageList* self,
                              GVariant* uid);
VALA_EXTERN void mail_message_list_item_print (MailMessageListItem* self);
static gint mail_message_list_message_sort_function (GtkListBoxRow* item1,
                                              GtkListBoxRow* item2);
VALA_EXTERN MailMessageList* mail_message_list_new (void);
VALA_EXTERN MailMessageList* mail_message_list_construct (GType object_type);
VALA_EXTERN HdyHeaderBar* mail_message_list_get_headerbar (MailMessageList* self);
static void mail_message_list_set_headerbar (MailMessageList* self,
                                      HdyHeaderBar* value);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * mail_message_list_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static GVariant* _variant_new21 (const gchar* value);
static GVariant* _variant_new22 (const gchar* value);
static GVariant* _variant_new23 (const gchar* value);
VALA_EXTERN MailFolderPopover* mail_folder_popover_new (void);
VALA_EXTERN MailFolderPopover* mail_folder_popover_construct (GType object_type);
static gint _mail_message_list_message_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                      GtkListBoxRow* row2,
                                                                      gpointer self);
static void mail_message_list_finalize (GObject * obj);
static GType mail_message_list_get_type_once (void);
static void _vala_mail_message_list_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_mail_message_list_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mail_message_list_get_instance_private (MailMessageList* self)
{
	return G_STRUCT_MEMBER_P (self, MailMessageList_private_offset);
}

static void
__lambda84_ (MailMessageList* self,
             GtkWidget* child)
{
	g_return_if_fail (child != NULL);
	gtk_widget_destroy (child);
}

static void
___lambda84__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda84_ ((MailMessageList*) self, (GtkWidget*) data);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		MailMessageList* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->list_item);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static void
____lambda85_ (Block47Data* _data47_)
{
	MailMessageList* self;
	MailMessageListItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data47_->self;
	_tmp0_ = _data47_->list_item;
	_tmp1_ = mail_message_list_item_get_loaded (_tmp0_);
	_tmp2_ = _tmp1_;
	mail_message_list_can_reply (self, _tmp2_);
}

static void
_____lambda85__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	____lambda85_ (self);
}

static GVariant*
_variant_new20 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

void
mail_message_list_set_conversation (MailMessageList* self,
                                    CamelFolderThreadNode* node)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GeeHashMap* _tmp3_;
	CamelStore* store = NULL;
	void* _tmp4_;
	CamelFolderSummary* _tmp5_;
	CamelFolderSummary* _tmp6_;
	CamelFolderSummary* _tmp7_;
	CamelFolder* _tmp8_;
	CamelFolder* _tmp9_;
	CamelStore* _tmp10_;
	CamelStore* _tmp11_;
	CamelStore* _tmp12_;
	CamelStore* _tmp13_;
	MailFolderPopover* _tmp14_;
	CamelStore* _tmp15_;
	MailMessageListItem* item = NULL;
	void* _tmp16_;
	MailMessageListItem* _tmp17_;
	GtkListBox* _tmp18_;
	MailMessageListItem* _tmp19_;
	GeeHashMap* _tmp20_;
	void* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	MailMessageListItem* _tmp24_;
	CamelFolderThreadNode* _tmp25_;
	GList* children = NULL;
	GtkListBox* _tmp27_;
	GList* _tmp28_;
	guint num_children = 0U;
	GList* _tmp29_;
	gboolean _tmp43_ = FALSE;
	void* _tmp44_;
	g_return_if_fail (self != NULL);
	mail_message_list_can_reply (self, FALSE);
	mail_message_list_can_move_thread (self, FALSE);
	_tmp0_ = self->priv->list_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda84__gfunc, self);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, MAIL_TYPE_MESSAGE_LIST_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->messages);
	self->priv->messages = _tmp3_;
	if (node == NULL) {
		return;
	}
	mail_message_list_can_move_thread (self, TRUE);
	_tmp4_ = camel_folder_thread_node_get_item (node);
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, camel_message_info_get_type (), CamelMessageInfo), "summary", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = camel_folder_summary_get_folder (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = camel_folder_get_parent_store (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp7_);
	store = _tmp13_;
	_tmp14_ = self->priv->folder_popover;
	_tmp15_ = store;
	mail_folder_popover_set_store (_tmp14_, _tmp15_);
	_tmp16_ = camel_folder_thread_node_get_item (node);
	_tmp17_ = mail_message_list_item_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, camel_message_info_get_type (), CamelMessageInfo));
	g_object_ref_sink (_tmp17_);
	item = _tmp17_;
	_tmp18_ = self->priv->list_box;
	_tmp19_ = item;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->messages;
	_tmp21_ = camel_folder_thread_node_get_item (node);
	_tmp22_ = camel_message_info_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, camel_message_info_get_type (), CamelMessageInfo));
	_tmp23_ = _tmp22_;
	_tmp24_ = item;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp23_, _tmp24_);
	_tmp25_ = camel_folder_thread_node_get_child (node);
	if (_tmp25_ != NULL) {
		CamelFolderThreadNode* _tmp26_;
		_tmp26_ = camel_folder_thread_node_get_child (node);
		mail_message_list_go_down (self, (CamelFolderThreadNode*) _tmp26_);
	}
	_tmp27_ = self->priv->list_box;
	_tmp28_ = gtk_container_get_children ((GtkContainer*) _tmp27_);
	children = _tmp28_;
	_tmp29_ = children;
	num_children = g_list_length (_tmp29_);
	if (num_children > ((guint) 0)) {
		GtkListBoxRow* child = NULL;
		GtkListBox* _tmp30_;
		GtkListBoxRow* _tmp31_;
		GtkListBoxRow* _tmp32_;
		gboolean _tmp33_ = FALSE;
		GtkListBoxRow* _tmp34_;
		_tmp30_ = self->priv->list_box;
		_tmp31_ = gtk_list_box_get_row_at_index (_tmp30_, ((gint) num_children) - 1);
		_tmp32_ = _g_object_ref0 (_tmp31_);
		child = _tmp32_;
		_tmp34_ = child;
		if (_tmp34_ != NULL) {
			GtkListBoxRow* _tmp35_;
			_tmp35_ = child;
			_tmp33_ = MAIL_IS_MESSAGE_LIST_ITEM (_tmp35_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			Block47Data* _data47_;
			GtkListBoxRow* _tmp36_;
			MailMessageListItem* _tmp37_;
			MailMessageListItem* _tmp38_;
			MailMessageListItem* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			MailMessageListItem* _tmp42_;
			_data47_ = g_slice_new0 (Block47Data);
			_data47_->_ref_count_ = 1;
			_data47_->self = g_object_ref (self);
			_tmp36_ = child;
			_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem));
			_data47_->list_item = _tmp37_;
			_tmp38_ = _data47_->list_item;
			mail_message_list_item_set_expanded (_tmp38_, TRUE);
			_tmp39_ = _data47_->list_item;
			_tmp40_ = mail_message_list_item_get_loaded (_tmp39_);
			_tmp41_ = _tmp40_;
			mail_message_list_can_reply (self, _tmp41_);
			_tmp42_ = _data47_->list_item;
			g_signal_connect_data ((GObject*) _tmp42_, "notify::loaded", (GCallback) _____lambda85__g_object_notify, block47_data_ref (_data47_), (GClosureNotify) block47_data_unref, 0);
			block47_data_unref (_data47_);
			_data47_ = NULL;
		}
		_g_object_unref0 (child);
	}
	_tmp44_ = camel_folder_thread_node_get_item (node);
	if (_tmp44_ != NULL) {
		void* _tmp45_;
		CamelMessageFlags _tmp46_;
		CamelMessageFlags _tmp47_;
		_tmp45_ = camel_folder_thread_node_get_item (node);
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, camel_message_info_get_type (), CamelMessageInfo), "flags", &_tmp46_, NULL);
		_tmp47_ = _tmp46_;
		_tmp43_ = (((gint) _tmp47_) & CAMEL_MESSAGE_DRAFT) == CAMEL_MESSAGE_DRAFT;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		GVariant* _tmp48_;
		_tmp48_ = _variant_new20 ("");
		mail_message_list_compose (self, MAIL_COMPOSER_TYPE_DRAFT, _tmp48_, NULL, NULL);
		_g_variant_unref0 (_tmp48_);
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	_g_object_unref0 (item);
	_g_object_unref0 (store);
}

static void
mail_message_list_go_down (MailMessageList* self,
                           CamelFolderThreadNode* node)
{
	CamelFolderThreadNode* current_node = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	current_node = node;
	while (TRUE) {
		CamelFolderThreadNode* _tmp0_;
		MailMessageListItem* item = NULL;
		CamelFolderThreadNode* _tmp1_;
		void* _tmp2_;
		MailMessageListItem* _tmp3_;
		GtkListBox* _tmp4_;
		MailMessageListItem* _tmp5_;
		GeeHashMap* _tmp6_;
		CamelFolderThreadNode* _tmp7_;
		void* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		MailMessageListItem* _tmp11_;
		CamelFolderThreadNode* _tmp12_;
		CamelFolderThreadNode* _tmp13_;
		CamelFolderThreadNode* _tmp16_;
		CamelFolderThreadNode* _tmp17_;
		_tmp0_ = current_node;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = current_node;
		_tmp2_ = camel_folder_thread_node_get_item (_tmp1_);
		_tmp3_ = mail_message_list_item_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, camel_message_info_get_type (), CamelMessageInfo));
		g_object_ref_sink (_tmp3_);
		item = _tmp3_;
		_tmp4_ = self->priv->list_box;
		_tmp5_ = item;
		gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->messages;
		_tmp7_ = current_node;
		_tmp8_ = camel_folder_thread_node_get_item (_tmp7_);
		_tmp9_ = camel_message_info_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, camel_message_info_get_type (), CamelMessageInfo));
		_tmp10_ = _tmp9_;
		_tmp11_ = item;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp10_, _tmp11_);
		_tmp12_ = current_node;
		_tmp13_ = camel_folder_thread_node_get_next (_tmp12_);
		if (_tmp13_ != NULL) {
			CamelFolderThreadNode* _tmp14_;
			CamelFolderThreadNode* _tmp15_;
			_tmp14_ = current_node;
			_tmp15_ = camel_folder_thread_node_get_next (_tmp14_);
			mail_message_list_go_down (self, (CamelFolderThreadNode*) _tmp15_);
		}
		_tmp16_ = current_node;
		_tmp17_ = camel_folder_thread_node_get_child (_tmp16_);
		current_node = (CamelFolderThreadNode*) _tmp17_;
		_g_object_unref0 (item);
	}
}

static void
mail_message_list_compose_data_free (gpointer _data)
{
	MailMessageListComposeData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->uid);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListComposeData, _data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
mail_message_list_compose (MailMessageList* self,
                           MailComposerType type,
                           GVariant* uid,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	MailMessageListComposeData* _data_;
	MailMessageList* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_data_ = g_slice_new0 (MailMessageListComposeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_compose_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->type = type;
	_tmp1_ = _g_variant_ref0 (uid);
	_g_variant_unref0 (_data_->uid);
	_data_->uid = _tmp1_;
	mail_message_list_compose_co (_data_);
}

void
mail_message_list_compose_finish (MailMessageList* self,
                                  GAsyncResult* _res_)
{
	MailMessageListComposeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_message_list_compose_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	MailMessageListComposeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_compose_co (_data_);
}

static void
__lambda123_ (MailMessageList* self)
{
	mail_message_list_can_reply (self, TRUE);
	mail_message_list_can_move_thread (self, TRUE);
}

static void
___lambda123__mail_composer_finished (MailComposer* _sender,
                                      gpointer self)
{
	__lambda123_ ((MailMessageList*) self);
}

static gboolean
mail_message_list_compose_co (MailMessageListComposeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->list_box;
	_data_->_tmp1_ = _data_->self->priv->list_box;
	_data_->_tmp2_ = gtk_container_get_children ((GtkContainer*) _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = gtk_list_box_get_row_at_index (_data_->_tmp0_, ((gint) g_list_length (_data_->_tmp3_)) - 1);
	_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	(_data_->_tmp3_ == NULL) ? NULL : (_data_->_tmp3_ = (g_list_free (_data_->_tmp3_), NULL));
	_data_->last_child = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->last_child;
	if (_data_->_tmp7_ == NULL) {
		_g_object_unref0 (_data_->last_child);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->message_item = NULL;
	_data_->_tmp8_ = g_variant_get_string (_data_->uid, NULL);
	if (g_strcmp0 (_data_->_tmp8_, "") == 0) {
		_data_->_tmp9_ = _data_->last_child;
		_data_->_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem));
		_g_object_unref0 (_data_->message_item);
		_data_->message_item = _data_->_tmp10_;
	} else {
		_data_->_tmp11_ = _data_->self->priv->messages;
		_data_->_tmp12_ = g_variant_get_string (_data_->uid, NULL);
		_data_->_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp11_, _data_->_tmp12_);
		_g_object_unref0 (_data_->message_item);
		_data_->message_item = (MailMessageListItem*) _data_->_tmp13_;
	}
	_data_->_tmp14_ = g_strdup ("");
	_data_->content_to_quote = _data_->_tmp14_;
	_data_->mime_message = NULL;
	_data_->message_info = NULL;
	_data_->_tmp15_ = _data_->message_item;
	_data_->_state_ = 1;
	mail_message_list_item_get_message_body_html (_data_->_tmp15_, mail_message_list_compose_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp16_ = mail_message_list_item_get_message_body_html_finish (_data_->_tmp15_, _data_->_res_);
	_g_free0 (_data_->content_to_quote);
	_data_->content_to_quote = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->message_item;
	_data_->_tmp18_ = mail_message_list_item_get_mime_message (_data_->_tmp17_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
	_g_object_unref0 (_data_->mime_message);
	_data_->mime_message = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->message_item;
	_data_->_tmp22_ = mail_message_list_item_get_message_info (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
	_g_object_unref0 (_data_->message_info);
	_data_->message_info = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->message_info;
	_data_->_tmp26_ = _data_->mime_message;
	_data_->_tmp27_ = _data_->content_to_quote;
	_data_->_tmp28_ = mail_composer_new_with_quote (_data_->type, _data_->_tmp25_, _data_->_tmp26_, _data_->_tmp27_);
	g_object_ref_sink (_data_->_tmp28_);
	_data_->composer = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->composer;
	gtk_window_present ((GtkWindow*) _data_->_tmp29_);
	_data_->_tmp30_ = _data_->composer;
	g_signal_connect_object (_data_->_tmp30_, "finished", (GCallback) ___lambda123__mail_composer_finished, _data_->self, 0);
	mail_message_list_can_reply (_data_->self, FALSE);
	mail_message_list_can_move_thread (_data_->self, TRUE);
	_g_object_unref0 (_data_->composer);
	_g_object_unref0 (_data_->message_info);
	_g_object_unref0 (_data_->mime_message);
	_g_free0 (_data_->content_to_quote);
	_g_object_unref0 (_data_->message_item);
	_g_object_unref0 (_data_->last_child);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
mail_message_list_print (MailMessageList* self,
                         GVariant* uid)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	MailMessageListItem* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_tmp0_ = self->priv->messages;
	_tmp1_ = g_variant_get_string (uid, NULL);
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	_tmp3_ = (MailMessageListItem*) _tmp2_;
	mail_message_list_item_print (_tmp3_);
	_g_object_unref0 (_tmp3_);
}

static void
mail_message_list_can_reply (MailMessageList* self,
                             gboolean enabled)
{
	GtkApplicationWindow* main_window = NULL;
	GtkWidget* _tmp0_;
	GAction* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	main_window = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_window_get_type (), GtkApplicationWindow);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) main_window, MAIL_MAIN_WINDOW_ACTION_FORWARD);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), enabled);
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) main_window, MAIL_MAIN_WINDOW_ACTION_REPLY_ALL);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), enabled);
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) main_window, MAIL_MAIN_WINDOW_ACTION_REPLY);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_simple_action_get_type (), GSimpleAction), enabled);
}

static void
mail_message_list_can_move_thread (MailMessageList* self,
                                   gboolean enabled)
{
	GtkApplicationWindow* main_window = NULL;
	GtkWidget* _tmp0_;
	GAction* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	GAction* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	main_window = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_window_get_type (), GtkApplicationWindow);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) main_window, MAIL_MAIN_WINDOW_ACTION_MODIFY);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), enabled);
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) main_window, MAIL_MAIN_WINDOW_ACTION_ARCHIVE);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), enabled);
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) main_window, MAIL_MAIN_WINDOW_ACTION_MOVE);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_simple_action_get_type (), GSimpleAction), enabled);
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) main_window, MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction), enabled);
}

static gint
mail_message_list_message_sort_function (GtkListBoxRow* item1,
                                         GtkListBoxRow* item2)
{
	MailMessageListItem* message1 = NULL;
	MailMessageListItem* message2 = NULL;
	gint64 timestamp1 = 0LL;
	MailMessageListItem* _tmp0_;
	CamelMessageInfo* _tmp1_;
	CamelMessageInfo* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 timestamp2 = 0LL;
	MailMessageListItem* _tmp10_;
	CamelMessageInfo* _tmp11_;
	CamelMessageInfo* _tmp12_;
	gint64 _tmp13_;
	gint64 _tmp14_;
	gint result;
	g_return_val_if_fail (item1 != NULL, 0);
	g_return_val_if_fail (item2 != NULL, 0);
	message1 = G_TYPE_CHECK_INSTANCE_CAST (item1, MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem);
	message2 = G_TYPE_CHECK_INSTANCE_CAST (item2, MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem);
	_tmp0_ = message1;
	_tmp1_ = mail_message_list_item_get_message_info (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = camel_message_info_get_date_received (_tmp2_);
	_tmp4_ = _tmp3_;
	timestamp1 = _tmp4_;
	if (timestamp1 == ((gint64) 0)) {
		MailMessageListItem* _tmp5_;
		CamelMessageInfo* _tmp6_;
		CamelMessageInfo* _tmp7_;
		gint64 _tmp8_;
		gint64 _tmp9_;
		_tmp5_ = message1;
		_tmp6_ = mail_message_list_item_get_message_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = camel_message_info_get_date_sent (_tmp7_);
		_tmp9_ = _tmp8_;
		timestamp1 = _tmp9_;
	}
	_tmp10_ = message2;
	_tmp11_ = mail_message_list_item_get_message_info (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = camel_message_info_get_date_received (_tmp12_);
	_tmp14_ = _tmp13_;
	timestamp2 = _tmp14_;
	if (timestamp2 == ((gint64) 0)) {
		MailMessageListItem* _tmp15_;
		CamelMessageInfo* _tmp16_;
		CamelMessageInfo* _tmp17_;
		gint64 _tmp18_;
		gint64 _tmp19_;
		_tmp15_ = message2;
		_tmp16_ = mail_message_list_item_get_message_info (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = camel_message_info_get_date_sent (_tmp17_);
		_tmp19_ = _tmp18_;
		timestamp2 = _tmp19_;
	}
	result = (gint) (timestamp1 - timestamp2);
	return result;
}

MailMessageList*
mail_message_list_construct (GType object_type)
{
	MailMessageList * self = NULL;
	self = (MailMessageList*) g_object_new (object_type, NULL);
	return self;
}

MailMessageList*
mail_message_list_new (void)
{
	return mail_message_list_construct (MAIL_TYPE_MESSAGE_LIST);
}

HdyHeaderBar*
mail_message_list_get_headerbar (MailMessageList* self)
{
	HdyHeaderBar* result;
	HdyHeaderBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_headerbar;
	result = _tmp0_;
	return result;
}

static void
mail_message_list_set_headerbar (MailMessageList* self,
                                 HdyHeaderBar* value)
{
	HdyHeaderBar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_message_list_get_headerbar (self);
	if (old_value != value) {
		HdyHeaderBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_headerbar);
		self->priv->_headerbar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_message_list_properties[MAIL_MESSAGE_LIST_HEADERBAR_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static GVariant*
_variant_new21 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new22 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new23 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gint
_mail_message_list_message_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                 GtkListBoxRow* row2,
                                                                 gpointer self)
{
	gint result;
	result = mail_message_list_message_sort_function (row1, row2);
	return result;
}

static GObject *
mail_message_list_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailMessageList * self;
	GtkStyleContext* _tmp0_;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp1_;
	GtkApplication* _tmp2_;
	GtkButton* reply_button = NULL;
	gchar* _tmp3_;
	GVariant* _tmp4_;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_;
	GtkApplication* _tmp7_;
	GtkButton* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GtkButton* reply_all_button = NULL;
	gchar* _tmp18_;
	GVariant* _tmp19_;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_;
	GtkApplication* _tmp22_;
	GtkButton* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GtkButton* forward_button = NULL;
	gchar* _tmp33_;
	GVariant* _tmp34_;
	GtkButton* _tmp35_ = NULL;
	GtkButton* _tmp36_;
	GtkApplication* _tmp37_;
	GtkButton* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar** _tmp43_;
	gchar** _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GtkMenuItem* mark_unread_item = NULL;
	gchar* _tmp48_;
	GtkMenuItem* _tmp49_ = NULL;
	GtkMenuItem* _tmp50_;
	GtkMenuItem* _tmp51_;
	GtkMenuItem* _tmp52_;
	GtkMenuItem* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	GraniteAccelLabel* _tmp56_;
	GraniteAccelLabel* _tmp57_;
	GtkMenuItem* mark_read_item = NULL;
	gchar* _tmp58_;
	GtkMenuItem* _tmp59_ = NULL;
	GtkMenuItem* _tmp60_;
	GtkMenuItem* _tmp61_;
	GtkMenuItem* _tmp62_;
	GtkMenuItem* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	GraniteAccelLabel* _tmp66_;
	GraniteAccelLabel* _tmp67_;
	GtkMenuItem* mark_star_item = NULL;
	gchar* _tmp68_;
	GtkMenuItem* _tmp69_ = NULL;
	GtkMenuItem* _tmp70_;
	GtkMenuItem* _tmp71_;
	GtkMenuItem* _tmp72_;
	GtkMenuItem* _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	GraniteAccelLabel* _tmp76_;
	GraniteAccelLabel* _tmp77_;
	GtkMenuItem* mark_unstar_item = NULL;
	gchar* _tmp78_;
	GtkMenuItem* _tmp79_ = NULL;
	GtkMenuItem* _tmp80_;
	GtkMenuItem* _tmp81_;
	GtkMenuItem* _tmp82_;
	GtkMenuItem* _tmp83_;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	GraniteAccelLabel* _tmp86_;
	GraniteAccelLabel* _tmp87_;
	GtkMenu* mark_menu = NULL;
	GtkMenu* _tmp88_;
	GtkMenu* _tmp89_;
	GtkMenuItem* _tmp90_;
	GtkMenu* _tmp91_;
	GtkMenuItem* _tmp92_;
	GtkMenu* _tmp93_;
	GtkMenuItem* _tmp94_;
	GtkMenu* _tmp95_;
	GtkMenuItem* _tmp96_;
	GtkMenu* _tmp97_;
	GtkMenuButton* mark_button = NULL;
	gchar* _tmp98_;
	GtkImage* _tmp99_;
	GtkMenu* _tmp100_;
	GtkMenu* _tmp101_;
	gchar* _tmp102_;
	GtkMenuButton* _tmp103_ = NULL;
	MailFolderPopover* _tmp104_;
	GtkMenuButton* move_button = NULL;
	gchar* _tmp105_;
	GtkImage* _tmp106_;
	gchar* _tmp107_;
	MailFolderPopover* _tmp108_;
	GtkPopover* _tmp109_;
	GtkMenuButton* _tmp110_ = NULL;
	GtkButton* archive_button = NULL;
	gchar* _tmp111_;
	GtkButton* _tmp112_ = NULL;
	GtkButton* _tmp113_;
	GtkApplication* _tmp114_;
	GtkButton* _tmp115_;
	const gchar* _tmp116_;
	const gchar* _tmp117_;
	gchar** _tmp118_;
	gchar** _tmp119_;
	gchar** _tmp120_;
	gint _tmp120__length1;
	gchar* _tmp121_;
	gchar* _tmp122_;
	GtkButton* trash_button = NULL;
	gchar* _tmp123_;
	GtkButton* _tmp124_ = NULL;
	GtkButton* _tmp125_;
	GtkApplication* _tmp126_;
	GtkButton* _tmp127_;
	const gchar* _tmp128_;
	const gchar* _tmp129_;
	gchar** _tmp130_;
	gchar** _tmp131_;
	gchar** _tmp132_;
	gint _tmp132__length1;
	gchar* _tmp133_;
	gchar* _tmp134_;
	HdyHeaderBar* _tmp135_ = NULL;
	HdyHeaderBar* _tmp136_;
	HdyHeaderBar* _tmp137_;
	GtkStyleContext* _tmp138_;
	HdyHeaderBar* _tmp139_;
	GtkButton* _tmp140_;
	HdyHeaderBar* _tmp141_;
	GtkButton* _tmp142_;
	HdyHeaderBar* _tmp143_;
	GtkButton* _tmp144_;
	HdyHeaderBar* _tmp145_;
	GtkButton* _tmp146_;
	HdyHeaderBar* _tmp147_;
	GtkButton* _tmp148_;
	HdyHeaderBar* _tmp149_;
	GtkMenuButton* _tmp150_;
	HdyHeaderBar* _tmp151_;
	GtkMenuButton* _tmp152_;
	GtkLabel* placeholder = NULL;
	GtkLabel* _tmp153_ = NULL;
	GtkStyleContext* placeholder_style_context = NULL;
	GtkLabel* _tmp154_;
	GtkStyleContext* _tmp155_;
	GtkStyleContext* _tmp156_;
	GtkStyleContext* _tmp157_;
	GtkStyleContext* _tmp158_;
	GtkListBox* _tmp159_ = NULL;
	GtkListBox* _tmp160_;
	GtkStyleContext* _tmp161_;
	GtkListBox* _tmp162_;
	GtkLabel* _tmp163_;
	GtkListBox* _tmp164_;
	GtkScrolledWindow* _tmp165_ = NULL;
	GtkScrolledWindow* _tmp166_;
	GtkListBox* _tmp167_;
	GtkWidget* scrolled_child = NULL;
	GtkScrolledWindow* _tmp168_;
	GtkWidget* _tmp169_;
	GtkWidget* _tmp170_;
	GtkWidget* _tmp171_;
	HdyHeaderBar* _tmp175_;
	GtkScrolledWindow* _tmp176_;
	parent_class = G_OBJECT_CLASS (mail_message_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_MESSAGE_LIST, MailMessageList);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, GTK_STYLE_CLASS_BACKGROUND);
	_tmp1_ = g_application_get_default ();
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp2_;
	_tmp3_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_REPLY);
	_tmp4_ = _variant_new21 ("");
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("mail-reply-sender", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp5_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_set ((GtkActionable*) _tmp5_, "action-target", _tmp4_, NULL);
	_g_variant_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	reply_button = _tmp5_;
	_tmp6_ = reply_button;
	_tmp7_ = application_instance;
	_tmp8_ = reply_button;
	_tmp9_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, "::", NULL);
	_tmp12_ = _tmp11_;
	_tmp14_ = _tmp13_ = gtk_application_get_accels_for_action (_tmp7_, _tmp12_);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _vala_array_length (_tmp13_);
	_tmp16_ = granite_markup_accel_tooltip (_tmp15_, (gint) _vala_array_length (_tmp13_), _ ("Reply"));
	_tmp17_ = _tmp16_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp6_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp12_);
	_tmp18_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_REPLY_ALL);
	_tmp19_ = _variant_new22 ("");
	_tmp20_ = (GtkButton*) gtk_button_new_from_icon_name ("mail-reply-all", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp20_, _tmp18_);
	_g_free0 (_tmp18_);
	g_object_set ((GtkActionable*) _tmp20_, "action-target", _tmp19_, NULL);
	_g_variant_unref0 (_tmp19_);
	g_object_ref_sink (_tmp20_);
	reply_all_button = _tmp20_;
	_tmp21_ = reply_all_button;
	_tmp22_ = application_instance;
	_tmp23_ = reply_all_button;
	_tmp24_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp25_, "::", NULL);
	_tmp27_ = _tmp26_;
	_tmp29_ = _tmp28_ = gtk_application_get_accels_for_action (_tmp22_, _tmp27_);
	_tmp30_ = _tmp29_;
	_tmp30__length1 = _vala_array_length (_tmp28_);
	_tmp31_ = granite_markup_accel_tooltip (_tmp30_, (gint) _vala_array_length (_tmp28_), _ ("Reply All"));
	_tmp32_ = _tmp31_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp21_, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp27_);
	_tmp33_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_FORWARD);
	_tmp34_ = _variant_new23 ("");
	_tmp35_ = (GtkButton*) gtk_button_new_from_icon_name ("mail-forward", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp35_, _tmp33_);
	_g_free0 (_tmp33_);
	g_object_set ((GtkActionable*) _tmp35_, "action-target", _tmp34_, NULL);
	_g_variant_unref0 (_tmp34_);
	g_object_ref_sink (_tmp35_);
	forward_button = _tmp35_;
	_tmp36_ = forward_button;
	_tmp37_ = application_instance;
	_tmp38_ = forward_button;
	_tmp39_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_strconcat (_tmp40_, "::", NULL);
	_tmp42_ = _tmp41_;
	_tmp44_ = _tmp43_ = gtk_application_get_accels_for_action (_tmp37_, _tmp42_);
	_tmp45_ = _tmp44_;
	_tmp45__length1 = _vala_array_length (_tmp43_);
	_tmp46_ = granite_markup_accel_tooltip (_tmp45_, (gint) _vala_array_length (_tmp43_), _ ("Forward"));
	_tmp47_ = _tmp46_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp36_, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp42_);
	_tmp48_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD);
	_tmp49_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp49_, _tmp48_);
	_g_free0 (_tmp48_);
	g_object_ref_sink (_tmp49_);
	mark_unread_item = _tmp49_;
	_tmp50_ = mark_unread_item;
	_tmp51_ = mark_unread_item;
	g_object_bind_property_with_closures ((GObject*) _tmp50_, "sensitive", (GObject*) _tmp51_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp52_ = mark_unread_item;
	_tmp53_ = mark_unread_item;
	_tmp54_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = granite_accel_label_new_from_action_name (_ ("Mark as Unread"), _tmp55_);
	g_object_ref_sink (_tmp56_);
	_tmp57_ = _tmp56_;
	gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp57_);
	_g_object_unref0 (_tmp57_);
	_tmp58_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_READ);
	_tmp59_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp59_, _tmp58_);
	_g_free0 (_tmp58_);
	g_object_ref_sink (_tmp59_);
	mark_read_item = _tmp59_;
	_tmp60_ = mark_read_item;
	_tmp61_ = mark_read_item;
	g_object_bind_property_with_closures ((GObject*) _tmp60_, "sensitive", (GObject*) _tmp61_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp62_ = mark_read_item;
	_tmp63_ = mark_read_item;
	_tmp64_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = granite_accel_label_new_from_action_name (_ ("Mark as Read"), _tmp65_);
	g_object_ref_sink (_tmp66_);
	_tmp67_ = _tmp66_;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp67_);
	_g_object_unref0 (_tmp67_);
	_tmp68_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_STAR);
	_tmp69_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp69_, _tmp68_);
	_g_free0 (_tmp68_);
	g_object_ref_sink (_tmp69_);
	mark_star_item = _tmp69_;
	_tmp70_ = mark_star_item;
	_tmp71_ = mark_star_item;
	g_object_bind_property_with_closures ((GObject*) _tmp70_, "sensitive", (GObject*) _tmp71_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp72_ = mark_star_item;
	_tmp73_ = mark_star_item;
	_tmp74_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = granite_accel_label_new_from_action_name (_ ("Star"), _tmp75_);
	g_object_ref_sink (_tmp76_);
	_tmp77_ = _tmp76_;
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp77_);
	_g_object_unref0 (_tmp77_);
	_tmp78_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR);
	_tmp79_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp79_, _tmp78_);
	_g_free0 (_tmp78_);
	g_object_ref_sink (_tmp79_);
	mark_unstar_item = _tmp79_;
	_tmp80_ = mark_unstar_item;
	_tmp81_ = mark_unstar_item;
	g_object_bind_property_with_closures ((GObject*) _tmp80_, "sensitive", (GObject*) _tmp81_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp82_ = mark_unstar_item;
	_tmp83_ = mark_unstar_item;
	_tmp84_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp83_);
	_tmp85_ = _tmp84_;
	_tmp86_ = granite_accel_label_new_from_action_name (_ ("Unstar"), _tmp85_);
	g_object_ref_sink (_tmp86_);
	_tmp87_ = _tmp86_;
	gtk_container_add ((GtkContainer*) _tmp82_, (GtkWidget*) _tmp87_);
	_g_object_unref0 (_tmp87_);
	_tmp88_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp88_);
	mark_menu = _tmp88_;
	_tmp89_ = mark_menu;
	_tmp90_ = mark_unread_item;
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = mark_menu;
	_tmp92_ = mark_read_item;
	gtk_container_add ((GtkContainer*) _tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = mark_menu;
	_tmp94_ = mark_star_item;
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = mark_menu;
	_tmp96_ = mark_unstar_item;
	gtk_container_add ((GtkContainer*) _tmp95_, (GtkWidget*) _tmp96_);
	_tmp97_ = mark_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp97_);
	_tmp98_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MODIFY);
	_tmp99_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-mark", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp99_);
	_tmp100_ = mark_menu;
	_tmp101_ = _g_object_ref0 (_tmp100_);
	_tmp102_ = g_strdup (_ ("Mark Conversation"));
	_tmp103_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp103_, _tmp98_);
	_g_free0 (_tmp98_);
	gtk_button_set_image ((GtkButton*) _tmp103_, (GtkWidget*) _tmp99_);
	_g_object_unref0 (_tmp99_);
	gtk_menu_button_set_popup (_tmp103_, _tmp101_);
	_g_object_unref0 (_tmp101_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp103_, _tmp102_);
	_g_free0 (_tmp102_);
	g_object_ref_sink (_tmp103_);
	mark_button = _tmp103_;
	_tmp104_ = mail_folder_popover_new ();
	g_object_ref_sink (_tmp104_);
	_g_object_unref0 (self->priv->folder_popover);
	self->priv->folder_popover = _tmp104_;
	_tmp105_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MODIFY);
	_tmp106_ = (GtkImage*) gtk_image_new_from_icon_name ("mail-move", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp106_);
	_tmp107_ = g_strdup (_ ("Move Conversation to…"));
	_tmp108_ = self->priv->folder_popover;
	_tmp109_ = _g_object_ref0 ((GtkPopover*) _tmp108_);
	_tmp110_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp110_, _tmp105_);
	_g_free0 (_tmp105_);
	gtk_button_set_image ((GtkButton*) _tmp110_, (GtkWidget*) _tmp106_);
	_g_object_unref0 (_tmp106_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp110_, _tmp107_);
	_g_free0 (_tmp107_);
	gtk_menu_button_set_popover (_tmp110_, _tmp109_);
	_g_object_unref0 (_tmp109_);
	g_object_ref_sink (_tmp110_);
	move_button = _tmp110_;
	_tmp111_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_ARCHIVE);
	_tmp112_ = (GtkButton*) gtk_button_new_from_icon_name ("mail-archive", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp112_, _tmp111_);
	_g_free0 (_tmp111_);
	g_object_ref_sink (_tmp112_);
	archive_button = _tmp112_;
	_tmp113_ = archive_button;
	_tmp114_ = application_instance;
	_tmp115_ = archive_button;
	_tmp116_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp115_);
	_tmp117_ = _tmp116_;
	_tmp119_ = _tmp118_ = gtk_application_get_accels_for_action (_tmp114_, _tmp117_);
	_tmp120_ = _tmp119_;
	_tmp120__length1 = _vala_array_length (_tmp118_);
	_tmp121_ = granite_markup_accel_tooltip (_tmp120_, (gint) _vala_array_length (_tmp118_), _ ("Move conversations to archive"));
	_tmp122_ = _tmp121_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp113_, _tmp122_);
	_g_free0 (_tmp122_);
	_tmp120_ = (_vala_array_free (_tmp120_, _tmp120__length1, (GDestroyNotify) g_free), NULL);
	_tmp123_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH);
	_tmp124_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp124_, _tmp123_);
	_g_free0 (_tmp123_);
	g_object_ref_sink (_tmp124_);
	trash_button = _tmp124_;
	_tmp125_ = trash_button;
	_tmp126_ = application_instance;
	_tmp127_ = trash_button;
	_tmp128_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp127_);
	_tmp129_ = _tmp128_;
	_tmp131_ = _tmp130_ = gtk_application_get_accels_for_action (_tmp126_, _tmp129_);
	_tmp132_ = _tmp131_;
	_tmp132__length1 = _vala_array_length (_tmp130_);
	_tmp133_ = granite_markup_accel_tooltip (_tmp132_, (gint) _vala_array_length (_tmp130_), _ ("Move conversations to Trash"));
	_tmp134_ = _tmp133_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp125_, _tmp134_);
	_g_free0 (_tmp134_);
	_tmp132_ = (_vala_array_free (_tmp132_, _tmp132__length1, (GDestroyNotify) g_free), NULL);
	_tmp135_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp135_, TRUE);
	g_object_ref_sink (_tmp135_);
	_tmp136_ = _tmp135_;
	mail_message_list_set_headerbar (self, _tmp136_);
	_g_object_unref0 (_tmp136_);
	_tmp137_ = self->priv->_headerbar;
	_tmp138_ = gtk_widget_get_style_context ((GtkWidget*) _tmp137_);
	gtk_style_context_add_class (_tmp138_, GTK_STYLE_CLASS_FLAT);
	_tmp139_ = self->priv->_headerbar;
	_tmp140_ = reply_button;
	hdy_header_bar_pack_start (_tmp139_, (GtkWidget*) _tmp140_);
	_tmp141_ = self->priv->_headerbar;
	_tmp142_ = reply_all_button;
	hdy_header_bar_pack_start (_tmp141_, (GtkWidget*) _tmp142_);
	_tmp143_ = self->priv->_headerbar;
	_tmp144_ = forward_button;
	hdy_header_bar_pack_start (_tmp143_, (GtkWidget*) _tmp144_);
	_tmp145_ = self->priv->_headerbar;
	_tmp146_ = trash_button;
	hdy_header_bar_pack_end (_tmp145_, (GtkWidget*) _tmp146_);
	_tmp147_ = self->priv->_headerbar;
	_tmp148_ = archive_button;
	hdy_header_bar_pack_end (_tmp147_, (GtkWidget*) _tmp148_);
	_tmp149_ = self->priv->_headerbar;
	_tmp150_ = move_button;
	hdy_header_bar_pack_end (_tmp149_, (GtkWidget*) _tmp150_);
	_tmp151_ = self->priv->_headerbar;
	_tmp152_ = mark_button;
	hdy_header_bar_pack_end (_tmp151_, (GtkWidget*) _tmp152_);
	_tmp153_ = (GtkLabel*) gtk_label_new (_ ("No Message Selected"));
	gtk_widget_set_visible ((GtkWidget*) _tmp153_, TRUE);
	g_object_ref_sink (_tmp153_);
	placeholder = _tmp153_;
	_tmp154_ = placeholder;
	_tmp155_ = gtk_widget_get_style_context ((GtkWidget*) _tmp154_);
	_tmp156_ = _g_object_ref0 (_tmp155_);
	placeholder_style_context = _tmp156_;
	_tmp157_ = placeholder_style_context;
	gtk_style_context_add_class (_tmp157_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp158_ = placeholder_style_context;
	gtk_style_context_add_class (_tmp158_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp159_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp159_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp159_, TRUE);
	gtk_list_box_set_selection_mode (_tmp159_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp159_);
	_g_object_unref0 (self->priv->list_box);
	self->priv->list_box = _tmp159_;
	_tmp160_ = self->priv->list_box;
	_tmp161_ = gtk_widget_get_style_context ((GtkWidget*) _tmp160_);
	gtk_style_context_add_class (_tmp161_, GTK_STYLE_CLASS_BACKGROUND);
	_tmp162_ = self->priv->list_box;
	_tmp163_ = placeholder;
	gtk_list_box_set_placeholder (_tmp162_, (GtkWidget*) _tmp163_);
	_tmp164_ = self->priv->list_box;
	gtk_list_box_set_sort_func (_tmp164_, _mail_message_list_message_sort_function_gtk_list_box_sort_func, NULL, NULL);
	_tmp165_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp165_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp165_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp165_;
	_tmp166_ = self->priv->scrolled_window;
	_tmp167_ = self->priv->list_box;
	gtk_container_add ((GtkContainer*) _tmp166_, (GtkWidget*) _tmp167_);
	_tmp168_ = self->priv->scrolled_window;
	_tmp169_ = gtk_bin_get_child ((GtkBin*) _tmp168_);
	_tmp170_ = _g_object_ref0 (_tmp169_);
	scrolled_child = _tmp170_;
	_tmp171_ = scrolled_child;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp171_, gtk_container_get_type ())) {
		GtkWidget* _tmp172_;
		GtkAdjustment* _tmp173_;
		GtkAdjustment* _tmp174_;
		_tmp172_ = scrolled_child;
		_tmp173_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
		g_object_ref_sink (_tmp173_);
		_tmp174_ = _tmp173_;
		gtk_container_set_focus_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp172_, gtk_container_get_type (), GtkContainer), _tmp174_);
		_g_object_unref0 (_tmp174_);
	}
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp175_ = self->priv->_headerbar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp175_);
	_tmp176_ = self->priv->scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp176_);
	_g_object_unref0 (scrolled_child);
	_g_object_unref0 (placeholder_style_context);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (trash_button);
	_g_object_unref0 (archive_button);
	_g_object_unref0 (move_button);
	_g_object_unref0 (mark_button);
	_g_object_unref0 (mark_menu);
	_g_object_unref0 (mark_unstar_item);
	_g_object_unref0 (mark_star_item);
	_g_object_unref0 (mark_read_item);
	_g_object_unref0 (mark_unread_item);
	_g_object_unref0 (forward_button);
	_g_object_unref0 (reply_all_button);
	_g_object_unref0 (reply_button);
	_g_object_unref0 (application_instance);
	return obj;
}

static void
mail_message_list_class_init (MailMessageListClass * klass,
                              gpointer klass_data)
{
	mail_message_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailMessageList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_message_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_message_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_message_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_message_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MESSAGE_LIST_HEADERBAR_PROPERTY, mail_message_list_properties[MAIL_MESSAGE_LIST_HEADERBAR_PROPERTY] = g_param_spec_object ("headerbar", "headerbar", "headerbar", hdy_header_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	mail_message_list_signals[MAIL_MESSAGE_LIST_HOVERING_OVER_LINK_SIGNAL] = g_signal_new ("hovering-over-link", MAIL_TYPE_MESSAGE_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}

static void
mail_message_list_instance_init (MailMessageList * self,
                                 gpointer klass)
{
	self->priv = mail_message_list_get_instance_private (self);
}

static void
mail_message_list_finalize (GObject * obj)
{
	MailMessageList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_MESSAGE_LIST, MailMessageList);
	_g_object_unref0 (self->priv->_headerbar);
	_g_object_unref0 (self->priv->folder_popover);
	_g_object_unref0 (self->priv->list_box);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->messages);
	G_OBJECT_CLASS (mail_message_list_parent_class)->finalize (obj);
}

static GType
mail_message_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailMessageListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_message_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailMessageList), 0, (GInstanceInitFunc) mail_message_list_instance_init, NULL };
	GType mail_message_list_type_id;
	mail_message_list_type_id = g_type_register_static (gtk_box_get_type (), "MailMessageList", &g_define_type_info, 0);
	MailMessageList_private_offset = g_type_add_instance_private (mail_message_list_type_id, sizeof (MailMessageListPrivate));
	return mail_message_list_type_id;
}

GType
mail_message_list_get_type (void)
{
	static volatile gsize mail_message_list_type_id__once = 0;
	if (g_once_init_enter (&mail_message_list_type_id__once)) {
		GType mail_message_list_type_id;
		mail_message_list_type_id = mail_message_list_get_type_once ();
		g_once_init_leave (&mail_message_list_type_id__once, mail_message_list_type_id);
	}
	return mail_message_list_type_id__once;
}

static void
_vala_mail_message_list_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	MailMessageList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_MESSAGE_LIST, MailMessageList);
	switch (property_id) {
		case MAIL_MESSAGE_LIST_HEADERBAR_PROPERTY:
		g_value_set_object (value, mail_message_list_get_headerbar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_message_list_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	MailMessageList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_MESSAGE_LIST, MailMessageList);
	switch (property_id) {
		case MAIL_MESSAGE_LIST_HEADERBAR_PROPERTY:
		mail_message_list_set_headerbar (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

