/* Application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Application.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <handy.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <libportal/portal.h>
#include <libportal-gtk3/portal-gtk3.h>
#include <glib/gi18n-lib.h>
#include <locale.h>

#define MAIL_APPLICATION_ACTION_GROUP_PREFIX "app"
#define MAIL_APPLICATION_ACTION_PREFIX MAIL_APPLICATION_ACTION_GROUP_PREFIX "."
#define MAIL_APPLICATION_ACTION_MANAGE_SIGNATURES "manage-signatures"
#define MAIL_GETTEXT_PACKAGE "io.elementary.mail"
#define MAIL_LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_APPLICATION (mail_application_get_type ())
#define MAIL_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_APPLICATION, MailApplication))
#define MAIL_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_APPLICATION, MailApplicationClass))
#define MAIL_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_APPLICATION))
#define MAIL_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_APPLICATION))
#define MAIL_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_APPLICATION, MailApplicationClass))

typedef struct _MailApplication MailApplication;
typedef struct _MailApplicationClass MailApplicationClass;
typedef struct _MailApplicationPrivate MailApplicationPrivate;
enum  {
	MAIL_APPLICATION_0_PROPERTY,
	MAIL_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* mail_application_properties[MAIL_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MAIL_TYPE_MAIN_WINDOW (mail_main_window_get_type ())
#define MAIL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MAIN_WINDOW, MailMainWindow))
#define MAIL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MAIN_WINDOW, MailMainWindowClass))
#define MAIL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MAIN_WINDOW))
#define MAIL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MAIN_WINDOW))
#define MAIL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MAIN_WINDOW, MailMainWindowClass))

typedef struct _MailMainWindow MailMainWindow;
typedef struct _MailMainWindowClass MailMainWindowClass;
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))

#define MAIL_TYPE_COMPOSER (mail_composer_get_type ())
#define MAIL_COMPOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_COMPOSER, MailComposer))
#define MAIL_COMPOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_COMPOSER, MailComposerClass))
#define MAIL_IS_COMPOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_COMPOSER))
#define MAIL_IS_COMPOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_COMPOSER))
#define MAIL_COMPOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_COMPOSER, MailComposerClass))

typedef struct _MailComposer MailComposer;
typedef struct _MailComposerClass MailComposerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

#define MAIL_TYPE_SIGNATURE_DIALOG (mail_signature_dialog_get_type ())
#define MAIL_SIGNATURE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_SIGNATURE_DIALOG, MailSignatureDialog))
#define MAIL_SIGNATURE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_SIGNATURE_DIALOG, MailSignatureDialogClass))
#define MAIL_IS_SIGNATURE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_SIGNATURE_DIALOG))
#define MAIL_IS_SIGNATURE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_SIGNATURE_DIALOG))
#define MAIL_SIGNATURE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_SIGNATURE_DIALOG, MailSignatureDialogClass))

typedef struct _MailSignatureDialog MailSignatureDialog;
typedef struct _MailSignatureDialogClass MailSignatureDialogClass;

#define MAIL_TYPE_INBOX_MONITOR (mail_inbox_monitor_get_type ())
#define MAIL_INBOX_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_INBOX_MONITOR, MailInboxMonitor))
#define MAIL_INBOX_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_INBOX_MONITOR, MailInboxMonitorClass))
#define MAIL_IS_INBOX_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_INBOX_MONITOR))
#define MAIL_IS_INBOX_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_INBOX_MONITOR))
#define MAIL_INBOX_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_INBOX_MONITOR, MailInboxMonitorClass))

typedef struct _MailInboxMonitor MailInboxMonitor;
typedef struct _MailInboxMonitorClass MailInboxMonitorClass;
#define __vala_XdpParent_free0(var) ((var == NULL) ? NULL : (var = (_vala_XdpParent_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _MailApplicationRequestBackgroundData MailApplicationRequestBackgroundData;

struct _MailApplication {
	GtkApplication parent_instance;
	MailApplicationPrivate * priv;
};

struct _MailApplicationClass {
	GtkApplicationClass parent_class;
};

struct _MailApplicationPrivate {
	GtkSettings* gtk_settings;
	gboolean first_activation;
};

struct _Block1Data {
	int _ref_count_;
	MailApplication* self;
	gchar* to;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GUri* mailto;
};

struct _Block3Data {
	int _ref_count_;
	MailApplication* self;
	GraniteSettings* granite_settings;
};

struct _MailApplicationRequestBackgroundData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailApplication* self;
	XdpPortal* portal;
	XdpPortal* _tmp0_;
	XdpParent* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
	XdpParent* _tmp6_;
	XdpParent* parent;
	XdpParent* _tmp7_;
	GPtrArray* command;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	gboolean _tmp11_;
	XdpPortal* _tmp12_;
	GPtrArray* _tmp13_;
	GError* e;
	GError* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

static gint MailApplication_private_offset;
static gpointer mail_application_parent_class = NULL;
VALA_EXTERN gboolean mail_application_run_in_background;
VALA_EXTERN GSettings* mail_application_settings;
GSettings* mail_application_settings = NULL;
gboolean mail_application_run_in_background = FALSE;

VALA_EXTERN GType mail_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailApplication, g_object_unref)
VALA_EXTERN MailApplication* mail_application_new (void);
VALA_EXTERN MailApplication* mail_application_construct (GType object_type);
static gint mail_application_real_command_line (GApplication* base,
                                         GApplicationCommandLine* command_line);
VALA_EXTERN GType mail_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMainWindow, g_object_unref)
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN gboolean mail_main_window_get_is_session_started (MailMainWindow* self);
VALA_EXTERN MailComposer* mail_composer_new (const gchar* to,
                                 const gchar* mailto_query);
VALA_EXTERN MailComposer* mail_composer_construct (GType object_type,
                                       const gchar* to,
                                       const gchar* mailto_query);
VALA_EXTERN GType mail_composer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailComposer, g_object_unref)
static void ______lambda137_ (Block2Data* _data2_);
static void _______lambda137__mail_main_window_session_started (MailMainWindow* _sender,
                                                         gpointer self);
static void mail_application_real_startup (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void mail_application_check_theme (MailApplication* self);
static void _mail_application_check_theme_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void __lambda138_ (Block3Data* _data3_);
static void ___lambda138__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda139_ (MailApplication* self);
static void ___lambda139__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static void __lambda140_ (MailApplication* self);
VALA_EXTERN GType mail_signature_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSignatureDialog, g_object_unref)
VALA_EXTERN MailSignatureDialog* mail_signature_dialog_new (void);
VALA_EXTERN MailSignatureDialog* mail_signature_dialog_construct (GType object_type);
static void ___lambda140__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
VALA_EXTERN MailInboxMonitor* mail_inbox_monitor_new (void);
VALA_EXTERN MailInboxMonitor* mail_inbox_monitor_construct (GType object_type);
VALA_EXTERN GType mail_inbox_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailInboxMonitor, g_object_unref)
VALA_EXTERN void mail_inbox_monitor_start (MailInboxMonitor* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void mail_inbox_monitor_start_finish (MailInboxMonitor* self,
                                      GAsyncResult* _res_);
static void mail_application_real_activate (GApplication* base);
VALA_EXTERN void mail_application_request_background (MailApplication* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void mail_application_request_background_finish (MailApplication* self,
                                                 GAsyncResult* _res_);
VALA_EXTERN MailMainWindow* mail_main_window_new (GtkApplication* application);
VALA_EXTERN MailMainWindow* mail_main_window_construct (GType object_type,
                                            GtkApplication* application);
static void mail_application_request_background_data_free (gpointer _data);
static gboolean mail_application_request_background_co (MailApplicationRequestBackgroundData* _data_);
static void _vala_XdpParent_free (XdpParent* self);
static XdpParent* _vala_XdpParent_copy (XdpParent* self);
static void mail_application_request_background_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static GObject * mail_application_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void mail_application_finalize (GObject * obj);
static GType mail_application_get_type_once (void);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry MAIL_APPLICATION_OPTIONS[2] = {{"background", 'b', (gint) 0, G_OPTION_ARG_NONE, &mail_application_run_in_background, "Run the Application in background", NULL}, {NULL}};

static inline gpointer
mail_application_get_instance_private (MailApplication* self)
{
	return G_STRUCT_MEMBER_P (self, MailApplication_private_offset);
}

MailApplication*
mail_application_construct (GType object_type)
{
	MailApplication * self = NULL;
	self = (MailApplication*) g_object_new (object_type, "application-id", "io.elementary.mail", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	return self;
}

MailApplication*
mail_application_new (void)
{
	return mail_application_construct (MAIL_TYPE_APPLICATION);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MailApplication* self;
		self = _data1_->self;
		_g_free0 (_data1_->to);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MailApplication* self;
		self = _data2_->_data1_->self;
		_g_uri_unref0 (_data2_->mailto);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
______lambda137_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	MailApplication* self;
	const gchar* _tmp0_;
	GUri* _tmp1_;
	const gchar* _tmp2_;
	MailComposer* _tmp3_;
	MailComposer* _tmp4_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data1_->to;
	_tmp1_ = _data2_->mailto;
	_tmp2_ = g_uri_get_query (_tmp1_);
	_tmp3_ = mail_composer_new (_tmp0_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	gtk_window_present ((GtkWindow*) _tmp4_);
	_g_object_unref0 (_tmp4_);
}

static void
_______lambda137__mail_main_window_session_started (MailMainWindow* _sender,
                                                    gpointer self)
{
	______lambda137_ (self);
}

static gint
mail_application_real_command_line (GApplication* base,
                                    GApplicationCommandLine* command_line)
{
	MailApplication * self;
	gchar** argv = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint argv_length1;
	gint _argv_size_;
	MailMainWindow* main_window = NULL;
	GList* _tmp2_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (MailApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	g_application_activate ((GApplication*) self);
	_tmp1_ = g_application_command_line_get_arguments (command_line, &_tmp0_);
	argv = _tmp1_;
	argv_length1 = _tmp0_;
	_argv_size_ = argv_length1;
	main_window = NULL;
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* window = NULL;
			window = (GtkWindow*) window_it->data;
			{
				GtkWindow* _tmp3_;
				_tmp3_ = window;
				if (MAIL_IS_MAIN_WINDOW (_tmp3_)) {
					GtkWindow* _tmp4_;
					MailMainWindow* _tmp5_;
					_tmp4_ = window;
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, MAIL_TYPE_MAIN_WINDOW, MailMainWindow));
					_g_object_unref0 (main_window);
					main_window = _tmp5_;
					break;
				}
			}
		}
	}
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	_tmp7_ = argv;
	_tmp7__length1 = argv_length1;
	{
		gchar** mailto_uri_collection = NULL;
		gint mailto_uri_collection_length1 = 0;
		gint _mailto_uri_collection_size_ = 0;
		gint mailto_uri_it = 0;
		mailto_uri_collection = _tmp6_ + 1;
		mailto_uri_collection_length1 = _tmp7__length1 - 1;
		for (mailto_uri_it = 0; mailto_uri_it < mailto_uri_collection_length1; mailto_uri_it = mailto_uri_it + 1) {
			gchar* _tmp8_;
			gchar* mailto_uri = NULL;
			_tmp8_ = g_strdup (mailto_uri_collection[mailto_uri_it]);
			mailto_uri = _tmp8_;
			{
				Block1Data* _data1_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				_data1_->to = NULL;
				{
					Block2Data* _data2_;
					GUri* _tmp15_;
					GUri* _tmp18_;
					const gchar* _tmp19_;
					GUri* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					MailMainWindow* _tmp25_;
					gboolean _tmp26_;
					gboolean _tmp27_;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->_data1_ = block1_data_ref (_data1_);
					_data2_->mailto = NULL;
					{
						GUri* _tmp9_ = NULL;
						const gchar* _tmp10_;
						GUri* _tmp11_;
						GUri* _tmp12_;
						_tmp10_ = mailto_uri;
						_tmp11_ = g_uri_parse (_tmp10_, G_URI_FLAGS_NONE, &_inner_error0_);
						_tmp9_ = _tmp11_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp12_ = _tmp9_;
						_tmp9_ = NULL;
						_g_uri_unref0 (_data2_->mailto);
						_data2_->mailto = _tmp12_;
						_g_uri_unref0 (_tmp9_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* _tmp13_;
						g_clear_error (&_inner_error0_);
						_tmp13_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "Argument is not a URL.");
						_inner_error0_ = _tmp13_;
						goto __finally1;
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gint _tmp14_ = -1;
						block2_data_unref (_data2_);
						_data2_ = NULL;
						if (_inner_error0_->domain == G_OPTION_ERROR) {
							goto __catch0_g_option_error;
						}
						_g_free0 (mailto_uri);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						_g_object_unref0 (main_window);
						argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp14_;
					}
					_tmp15_ = _data2_->mailto;
					if (_tmp15_ == NULL) {
						GError* _tmp16_;
						gint _tmp17_ = -1;
						_tmp16_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "Argument is not a URL.");
						_inner_error0_ = _tmp16_;
						block2_data_unref (_data2_);
						_data2_ = NULL;
						if (_inner_error0_->domain == G_OPTION_ERROR) {
							goto __catch0_g_option_error;
						}
						_g_free0 (mailto_uri);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						_g_object_unref0 (main_window);
						argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp17_;
					}
					_tmp18_ = _data2_->mailto;
					_tmp19_ = g_uri_get_scheme (_tmp18_);
					if (g_strcmp0 (_tmp19_, "mailto") != 0) {
						GError* _tmp20_;
						gint _tmp21_ = -1;
						_tmp20_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "Cannot open non-mailto: URL");
						_inner_error0_ = _tmp20_;
						block2_data_unref (_data2_);
						_data2_ = NULL;
						if (_inner_error0_->domain == G_OPTION_ERROR) {
							goto __catch0_g_option_error;
						}
						_g_free0 (mailto_uri);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						_g_object_unref0 (main_window);
						argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp21_;
					}
					_tmp22_ = _data2_->mailto;
					_tmp23_ = g_uri_get_path (_tmp22_);
					_tmp24_ = g_uri_unescape_string (_tmp23_, NULL);
					_g_free0 (_data1_->to);
					_data1_->to = _tmp24_;
					_tmp25_ = main_window;
					_tmp26_ = mail_main_window_get_is_session_started (_tmp25_);
					_tmp27_ = _tmp26_;
					if (_tmp27_) {
						const gchar* _tmp28_;
						GUri* _tmp29_;
						const gchar* _tmp30_;
						MailComposer* _tmp31_;
						MailComposer* _tmp32_;
						_tmp28_ = _data1_->to;
						_tmp29_ = _data2_->mailto;
						_tmp30_ = g_uri_get_query (_tmp29_);
						_tmp31_ = mail_composer_new (_tmp28_, _tmp30_);
						g_object_ref_sink (_tmp31_);
						_tmp32_ = _tmp31_;
						gtk_window_present ((GtkWindow*) _tmp32_);
						_g_object_unref0 (_tmp32_);
					} else {
						MailMainWindow* _tmp33_;
						_tmp33_ = main_window;
						g_signal_connect_data (_tmp33_, "session-started", (GCallback) _______lambda137__mail_main_window_session_started, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					}
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
				goto __finally0;
				__catch0_g_option_error:
				{
					GError* e = NULL;
					GError* _tmp34_;
					const gchar* _tmp35_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp34_ = e;
					_tmp35_ = _tmp34_->message;
					g_warning ("Application.vala:110: Argument parsing error. %s", _tmp35_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gint _tmp36_ = -1;
					_g_free0 (mailto_uri);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					_g_object_unref0 (main_window);
					argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp36_;
				}
				_g_free0 (mailto_uri);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
	}
	result = 0;
	_g_object_unref0 (main_window);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		MailApplication* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->granite_settings);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_mail_application_check_theme_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	mail_application_check_theme ((MailApplication*) self);
}

static void
__lambda138_ (Block3Data* _data3_)
{
	MailApplication* self;
	GtkSettings* _tmp0_;
	GraniteSettingsColorScheme _tmp1_;
	GraniteSettingsColorScheme _tmp2_;
	self = _data3_->self;
	_tmp0_ = self->priv->gtk_settings;
	_tmp1_ = granite_settings_get_prefers_color_scheme (_data3_->granite_settings);
	_tmp2_ = _tmp1_;
	g_object_set (_tmp0_, "gtk-application-prefer-dark-theme", _tmp2_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
}

static void
___lambda138__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda138_ (self);
}

static void
__lambda139_ (MailApplication* self)
{
	GList* _tmp0_;
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* window = NULL;
			window = (GtkWindow*) window_it->data;
			{
				GtkWindow* _tmp1_;
				_tmp1_ = window;
				if (MAIL_IS_MAIN_WINDOW (_tmp1_)) {
					GtkWindow* _tmp2_;
					_tmp2_ = window;
					gtk_widget_destroy ((GtkWidget*) _tmp2_);
					break;
				}
			}
		}
	}
}

static void
___lambda139__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda139_ ((MailApplication*) self);
}

static void
__lambda140_ (MailApplication* self)
{
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	MailSignatureDialog* _tmp3_ = NULL;
	MailSignatureDialog* _tmp4_;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp3_ = mail_signature_dialog_new ();
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
}

static void
___lambda140__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda140_ ((MailApplication*) self);
}

static void
mail_application_real_startup (GApplication* base)
{
	MailApplication * self;
	Block3Data* _data3_;
	GraniteSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GtkSettings* _tmp3_;
	GtkSettings* _tmp4_;
	GtkSettings* _tmp5_;
	GtkSettings* _tmp6_;
	GraniteSettingsColorScheme _tmp7_;
	GraniteSettingsColorScheme _tmp8_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp9_;
	GdkScreen* _tmp10_;
	GSimpleAction* quit_action = NULL;
	GSimpleAction* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GSimpleAction* manage_signatures_action = NULL;
	GSimpleAction* _tmp15_;
	MailInboxMonitor* _tmp16_;
	MailInboxMonitor* _tmp17_;
	self = (MailApplication*) base;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	G_APPLICATION_CLASS (mail_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	hdy_init ();
	_tmp0_ = granite_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data3_->granite_settings = _tmp1_;
	_tmp2_ = gtk_settings_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->gtk_settings);
	self->priv->gtk_settings = _tmp3_;
	_tmp4_ = self->priv->gtk_settings;
	g_object_set (_tmp4_, "gtk-icon-theme-name", "elementary", NULL);
	mail_application_check_theme (self);
	_tmp5_ = self->priv->gtk_settings;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::gtk-theme-name", (GCallback) _mail_application_check_theme_g_object_notify, self, 0);
	_tmp6_ = self->priv->gtk_settings;
	_tmp7_ = granite_settings_get_prefers_color_scheme (_data3_->granite_settings);
	_tmp8_ = _tmp7_;
	g_object_set (_tmp6_, "gtk-application-prefer-dark-theme", _tmp8_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	g_signal_connect_data ((GObject*) _data3_->granite_settings, "notify::prefers-color-scheme", (GCallback) ___lambda138__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp9_ = gtk_css_provider_new ();
	css_provider = _tmp9_;
	gtk_css_provider_load_from_resource (css_provider, "io/elementary/mail/application.css");
	_tmp10_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp10_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp11_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp11_;
	g_signal_connect_object (quit_action, "activate", (GCallback) ___lambda139__g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) quit_action);
	_tmp12_ = g_strdup ("<Control>q");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_simple_action_new (MAIL_APPLICATION_ACTION_MANAGE_SIGNATURES, NULL);
	manage_signatures_action = _tmp15_;
	g_signal_connect_object (manage_signatures_action, "activate", (GCallback) ___lambda140__g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) manage_signatures_action);
	_tmp16_ = mail_inbox_monitor_new ();
	_tmp17_ = _tmp16_;
	mail_inbox_monitor_start (_tmp17_, NULL, NULL);
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (manage_signatures_action);
	_g_object_unref0 (quit_action);
	_g_object_unref0 (css_provider);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
mail_application_real_activate (GApplication* base)
{
	MailApplication * self;
	MailMainWindow* main_window = NULL;
	GList* _tmp0_;
	MailMainWindow* _tmp4_;
	MailMainWindow* _tmp15_;
	self = (MailApplication*) base;
	if (self->priv->first_activation) {
		self->priv->first_activation = FALSE;
		g_application_hold ((GApplication*) self);
	}
	if (mail_application_run_in_background) {
		mail_application_request_background (self, NULL, NULL);
		mail_application_run_in_background = FALSE;
		return;
	}
	main_window = NULL;
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* window = NULL;
			window = (GtkWindow*) window_it->data;
			{
				GtkWindow* _tmp1_;
				_tmp1_ = window;
				if (MAIL_IS_MAIN_WINDOW (_tmp1_)) {
					GtkWindow* _tmp2_;
					MailMainWindow* _tmp3_;
					_tmp2_ = window;
					_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, MAIL_TYPE_MAIN_WINDOW, MailMainWindow));
					_g_object_unref0 (main_window);
					main_window = _tmp3_;
					break;
				}
			}
		}
	}
	_tmp4_ = main_window;
	if (_tmp4_ == NULL) {
		MailMainWindow* _tmp5_;
		MailMainWindow* _tmp6_;
		GtkAllocation rect = {0};
		GSettings* _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		MailMainWindow* _tmp10_;
		GtkAllocation _tmp11_;
		GSettings* _tmp12_;
		MailMainWindow* _tmp14_;
		_tmp5_ = mail_main_window_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (main_window);
		main_window = _tmp5_;
		_tmp6_ = main_window;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp6_);
		memset (&rect, 0, sizeof (GtkAllocation));
		_tmp7_ = mail_application_settings;
		g_settings_get (_tmp7_, "window-size", "(ii)", &_tmp8_, &_tmp9_);
		rect.width = _tmp8_;
		rect.height = _tmp9_;
		_tmp10_ = main_window;
		_tmp11_ = rect;
		gtk_widget_set_allocation ((GtkWidget*) _tmp10_, &_tmp11_);
		_tmp12_ = mail_application_settings;
		if (g_settings_get_boolean (_tmp12_, "window-maximized")) {
			MailMainWindow* _tmp13_;
			_tmp13_ = main_window;
			gtk_window_maximize ((GtkWindow*) _tmp13_);
		}
		_tmp14_ = main_window;
		gtk_widget_show_all ((GtkWidget*) _tmp14_);
	}
	_tmp15_ = main_window;
	gtk_window_present ((GtkWindow*) _tmp15_);
	_g_object_unref0 (main_window);
}

static void
mail_application_request_background_data_free (gpointer _data)
{
	MailApplicationRequestBackgroundData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailApplicationRequestBackgroundData, _data_);
}

void
mail_application_request_background (MailApplication* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	MailApplicationRequestBackgroundData* _data_;
	MailApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailApplicationRequestBackgroundData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_application_request_background_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_application_request_background_co (_data_);
}

void
mail_application_request_background_finish (MailApplication* self,
                                            GAsyncResult* _res_)
{
	MailApplicationRequestBackgroundData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_vala_XdpParent_free (XdpParent* self)
{
	g_boxed_free (xdp_parent_get_type (), self);
}

static XdpParent*
_vala_XdpParent_copy (XdpParent* self)
{
	return g_boxed_copy (xdp_parent_get_type (), self);
}

static gpointer
__vala_XdpParent_copy0 (gpointer self)
{
	return self ? _vala_XdpParent_copy (self) : NULL;
}

static void
mail_application_request_background_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	MailApplicationRequestBackgroundData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_application_request_background_co (_data_);
}

static gboolean
mail_application_request_background_co (MailApplicationRequestBackgroundData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = xdp_portal_new ();
	_data_->portal = _data_->_tmp0_;
	_data_->_tmp2_ = gtk_application_get_active_window ((GtkApplication*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = gtk_application_get_active_window ((GtkApplication*) _data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = xdp_parent_new_gtk (_data_->_tmp5_);
		__vala_XdpParent_free0 (_data_->_tmp1_);
		_data_->_tmp1_ = _data_->_tmp6_;
	} else {
		__vala_XdpParent_free0 (_data_->_tmp1_);
		_data_->_tmp1_ = NULL;
	}
	_data_->_tmp7_ = __vala_XdpParent_copy0 (_data_->_tmp1_);
	_data_->parent = _data_->_tmp7_;
	_data_->_tmp8_ = g_ptr_array_new_full ((guint) 0, NULL);
	_data_->command = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->command;
	g_ptr_array_add (_data_->_tmp9_, "io.elementary.mail");
	_data_->_tmp10_ = _data_->command;
	g_ptr_array_add (_data_->_tmp10_, "--background");
	{
		_data_->_tmp12_ = _data_->portal;
		_data_->_tmp13_ = _data_->command;
		_data_->command = NULL;
		_data_->_state_ = 1;
		xdp_portal_request_background (_data_->_tmp12_, _data_->parent, _ ("Mail will automatically start when this device turns on and run when i" \
"ts window is closed so that it can send notifications when new mail ar" \
"rives."), _data_->_tmp13_, XDP_BACKGROUND_FLAG_AUTOSTART, NULL, mail_application_request_background_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = xdp_portal_request_background_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_data_->_tmp11_) {
			g_application_release ((GApplication*) _data_->self);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->e;
		if (g_error_matches (_data_->_tmp14_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp15_ = _data_->e;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			g_debug ("Application.vala:221: Request for autostart and background permissions" \
" denied: %s", _data_->_tmp16_);
			g_application_release ((GApplication*) _data_->self);
		} else {
			_data_->_tmp17_ = _data_->e;
			_data_->_tmp18_ = _data_->_tmp17_->message;
			g_warning ("Application.vala:224: Failed to request autostart and background permi" \
"ssions: %s", _data_->_tmp18_);
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (_data_->command);
		__vala_XdpParent_free0 (_data_->parent);
		__vala_XdpParent_free0 (_data_->_tmp1_);
		_g_object_unref0 (_data_->portal);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_ptr_array_unref0 (_data_->command);
	__vala_XdpParent_free0 (_data_->parent);
	__vala_XdpParent_free0 (_data_->_tmp1_);
	_g_object_unref0 (_data_->portal);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_application_check_theme (MailApplication* self)
{
	GtkSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gtk_settings;
	g_object_get (_tmp0_, "gtk-theme-name", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = !g_str_has_prefix (_tmp3_, "io.elementary");
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GtkSettings* _tmp5_;
		_tmp5_ = self->priv->gtk_settings;
		g_object_set (_tmp5_, "gtk-theme-name", "io.elementary.stylesheet.blueberry", NULL);
	}
}

static GObject *
mail_application_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailApplication * self;
	parent_class = G_OBJECT_CLASS (mail_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_APPLICATION, MailApplication);
	g_setenv ("GTK_USE_PORTAL", "1", TRUE);
	setlocale (LC_ALL, "");
	bindtextdomain (MAIL_GETTEXT_PACKAGE, MAIL_LOCALEDIR);
	bind_textdomain_codeset (MAIL_GETTEXT_PACKAGE, "UTF-8");
	textdomain (MAIL_GETTEXT_PACKAGE);
	g_application_add_main_option_entries ((GApplication*) self, MAIL_APPLICATION_OPTIONS);
	return obj;
}

static void
mail_application_class_init (MailApplicationClass * klass,
                             gpointer klass_data)
{
	GSettings* _tmp0_;
	mail_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailApplication_private_offset);
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) mail_application_real_command_line;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) mail_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) mail_application_real_activate;
	G_OBJECT_CLASS (klass)->constructor = mail_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_application_finalize;
	_tmp0_ = g_settings_new ("io.elementary.mail");
	_g_object_unref0 (mail_application_settings);
	mail_application_settings = _tmp0_;
}

static void
mail_application_instance_init (MailApplication * self,
                                gpointer klass)
{
	self->priv = mail_application_get_instance_private (self);
	self->priv->first_activation = TRUE;
}

static void
mail_application_finalize (GObject * obj)
{
	MailApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_APPLICATION, MailApplication);
	_g_object_unref0 (self->priv->gtk_settings);
	G_OBJECT_CLASS (mail_application_parent_class)->finalize (obj);
}

static GType
mail_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailApplication), 0, (GInstanceInitFunc) mail_application_instance_init, NULL };
	GType mail_application_type_id;
	mail_application_type_id = g_type_register_static (gtk_application_get_type (), "MailApplication", &g_define_type_info, 0);
	MailApplication_private_offset = g_type_add_instance_private (mail_application_type_id, sizeof (MailApplicationPrivate));
	return mail_application_type_id;
}

GType
mail_application_get_type (void)
{
	static volatile gsize mail_application_type_id__once = 0;
	if (g_once_init_enter (&mail_application_type_id__once)) {
		GType mail_application_type_id;
		mail_application_type_id = mail_application_get_type_once ();
		g_once_init_leave (&mail_application_type_id__once, mail_application_type_id);
	}
	return mail_application_type_id__once;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	MailApplication* application = NULL;
	MailApplication* _tmp0_;
	gint result;
	g_setenv ("WEBKIT_DISABLE_COMPOSITING_MODE", "1", TRUE);
	_tmp0_ = mail_application_new ();
	application = _tmp0_;
	result = g_application_run ((GApplication*) application, (gint) args_length1, args);
	_g_object_unref0 (application);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

