/* Agent.c generated by valac 0.56.17, the Vala compiler
 * generated from Agent.vala, do not modify */

/*-
 * Copyright (c) 2017-2019 elementary, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gclue-enums.h>
#include <gio/gdesktopappinfo.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AG_TYPE_GEO_CLUE2_AGENT (ag_geo_clue2_agent_get_type ())
#define AG_GEO_CLUE2_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_GEO_CLUE2_AGENT, AgGeoClue2Agent))
#define AG_IS_GEO_CLUE2_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_GEO_CLUE2_AGENT))
#define AG_GEO_CLUE2_AGENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), AG_TYPE_GEO_CLUE2_AGENT, AgGeoClue2AgentIface))

typedef struct _AgGeoClue2Agent AgGeoClue2Agent;
typedef struct _AgGeoClue2AgentIface AgGeoClue2AgentIface;

#define AG_TYPE_GEO_CLUE2_AGENT_PROXY (ag_geo_clue2_agent_proxy_get_type ())

#define AG_TYPE_AGENT (ag_agent_get_type ())
#define AG_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_AGENT, AgAgent))
#define AG_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AG_TYPE_AGENT, AgAgentClass))
#define AG_IS_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_AGENT))
#define AG_IS_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AG_TYPE_AGENT))
#define AG_AGENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AG_TYPE_AGENT, AgAgentClass))

typedef struct _AgAgent AgAgent;
typedef struct _AgAgentClass AgAgentClass;
typedef struct _AgAgentPrivate AgAgentPrivate;

#define AG_TYPE_GEO_CLUE2_CLIENT (ag_geo_clue2_client_get_type ())
#define AG_GEO_CLUE2_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_GEO_CLUE2_CLIENT, AgGeoClue2Client))
#define AG_IS_GEO_CLUE2_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_GEO_CLUE2_CLIENT))
#define AG_GEO_CLUE2_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), AG_TYPE_GEO_CLUE2_CLIENT, AgGeoClue2ClientIface))

typedef struct _AgGeoClue2Client AgGeoClue2Client;
typedef struct _AgGeoClue2ClientIface AgGeoClue2ClientIface;

#define AG_TYPE_GEO_CLUE2_CLIENT_PROXY (ag_geo_clue2_client_proxy_get_type ())
enum  {
	AG_AGENT_0_PROPERTY,
	AG_AGENT_NUM_PROPERTIES
};
static GParamSpec* ag_agent_properties[AG_AGENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))

#define AG_WIDGETS_TYPE_GEOCLUE2_DIALOG (ag_widgets_geoclue2_dialog_get_type ())
#define AG_WIDGETS_GEOCLUE2_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_WIDGETS_TYPE_GEOCLUE2_DIALOG, AgWidgetsGeoclue2Dialog))
#define AG_WIDGETS_GEOCLUE2_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AG_WIDGETS_TYPE_GEOCLUE2_DIALOG, AgWidgetsGeoclue2DialogClass))
#define AG_WIDGETS_IS_GEOCLUE2_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_WIDGETS_TYPE_GEOCLUE2_DIALOG))
#define AG_WIDGETS_IS_GEOCLUE2_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AG_WIDGETS_TYPE_GEOCLUE2_DIALOG))
#define AG_WIDGETS_GEOCLUE2_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AG_WIDGETS_TYPE_GEOCLUE2_DIALOG, AgWidgetsGeoclue2DialogClass))

typedef struct _AgWidgetsGeoclue2Dialog AgWidgetsGeoclue2Dialog;
typedef struct _AgWidgetsGeoclue2DialogClass AgWidgetsGeoclue2DialogClass;
typedef struct _AgAgentAuthorizeAppData AgAgentAuthorizeAppData;

struct _AgGeoClue2AgentIface {
	GTypeInterface parent_iface;
	void (*authorize_app) (AgGeoClue2Agent* self, const gchar* desktop_id, GClueAccuracyLevel req_accuracy_level, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*authorize_app_finish) (AgGeoClue2Agent* self, GAsyncResult* _res_, gboolean* authorized, GClueAccuracyLevel* allowed_accuracy_level, GError** error);
	GClueAccuracyLevel (*get_max_accuracy_level) (AgGeoClue2Agent* self);
};

struct _AgAgent {
	GtkApplication parent_instance;
	AgAgentPrivate * priv;
};

struct _AgAgentClass {
	GtkApplicationClass parent_class;
};

struct _AgGeoClue2ClientIface {
	GTypeInterface parent_iface;
	void (*start) (AgGeoClue2Client* self, GError** error);
	void (*stop) (AgGeoClue2Client* self, GError** error);
	gchar* (*get_desktop_id) (AgGeoClue2Client* self);
	void (*set_desktop_id) (AgGeoClue2Client* self, const gchar* value);
};

struct _AgAgentPrivate {
	guint object_id;
	gboolean bus_registered;
	AgGeoClue2Client* client;
	GSettings* settings;
};

struct _AgAgentAuthorizeAppData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AgAgent* self;
	gchar* id;
	GClueAccuracyLevel req_accuracy;
	gboolean authorized;
	GClueAccuracyLevel allowed_accuracy;
	GDesktopAppInfo* app_info;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	GVariant* remembered_apps;
	GSettings* _tmp5_;
	GVariant* _tmp6_;
	GVariantDict* remembered_apps_dict;
	GVariant* _tmp7_;
	GVariantDict* _tmp8_;
	GVariant* remembered_accuracy;
	GVariantDict* _tmp9_;
	const GVariantType* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	gboolean stored_auth;
	GClueAccuracyLevel stored_accuracy;
	GVariant* _tmp13_;
	gboolean _tmp14_;
	GClueAccuracyLevel _tmp15_;
	gboolean _tmp16_;
	const gchar* app_name;
	GDesktopAppInfo* _tmp17_;
	const gchar* _tmp18_;
	gchar* accuracy_string;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	AgGeoClue2Client* _tmp21_;
	AgGeoClue2Client* _tmp22_;
	AgGeoClue2Client* _tmp23_;
	GError* e;
	const gchar* _tmp24_;
	AgWidgetsGeoclue2Dialog* dialog;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GDesktopAppInfo* _tmp27_;
	GIcon* _tmp28_;
	AgWidgetsGeoclue2Dialog* _tmp29_;
	AgWidgetsGeoclue2Dialog* _tmp30_;
	gint _result_;
	AgWidgetsGeoclue2Dialog* _tmp31_;
	AgWidgetsGeoclue2Dialog* _tmp32_;
	AgGeoClue2Client* _tmp33_;
	AgGeoClue2Client* _tmp34_;
	GError* _vala1_e;
	const gchar* _tmp35_;
	GError* _inner_error0_;
};

static gint AgAgent_private_offset;
static gpointer ag_agent_parent_class = NULL;
static AgGeoClue2AgentIface * ag_agent_ag_geo_clue2_agent_parent_iface = NULL;

VALA_EXTERN GType ag_geo_clue2_agent_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint ag_geo_clue2_agent_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType ag_geo_clue2_agent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgGeoClue2Agent, g_object_unref)
VALA_EXTERN GType ag_agent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgAgent, g_object_unref)
VALA_EXTERN GType ag_geo_clue2_client_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint ag_geo_clue2_client_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN GType ag_geo_clue2_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgGeoClue2Client, g_object_unref)
static void ag_agent_real_activate (GApplication* base);
static void ag_agent_on_name (AgAgent* self,
                       GDBusConnection* conn);
VALA_EXTERN void ag_utils_register_with_geoclue (GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void ag_utils_register_with_geoclue_finish (GAsyncResult* _res_);
static gboolean ag_agent_real_dbus_register (GApplication* base,
                                      GDBusConnection* connection,
                                      const gchar* object_path,
                                      GError** error);
static void _ag_agent_on_name_gbus_name_appeared_callback (GDBusConnection* connection,
                                                    const gchar* name,
                                                    const gchar* name_owner,
                                                    gpointer self);
static void ag_agent_real_dbus_unregister (GApplication* base,
                                    GDBusConnection* connection,
                                    const gchar* object_path);
static void ag_agent_real_authorize_app_data_free (gpointer _data);
static void ag_agent_real_authorize_app (AgGeoClue2Agent* base,
                                  const gchar* id,
                                  GClueAccuracyLevel req_accuracy,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static gboolean ag_agent_real_authorize_app_co (AgAgentAuthorizeAppData* _data_);
static gchar* ag_agent_accuracy_to_string (AgAgent* self,
                                    const gchar* app_name,
                                    guint accuracy);
VALA_EXTERN void ag_utils_get_geoclue2_client (GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN AgGeoClue2Client* ag_utils_get_geoclue2_client_finish (GAsyncResult* _res_);
static void ag_agent_authorize_app_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
VALA_EXTERN void ag_geo_clue2_client_start (AgGeoClue2Client* self,
                                GError** error);
VALA_EXTERN GType ag_widgets_geoclue2_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgWidgetsGeoclue2Dialog, g_object_unref)
VALA_EXTERN AgWidgetsGeoclue2Dialog* ag_widgets_geoclue2_dialog_new (const gchar* message,
                                                         const gchar* app_name,
                                                         GIcon* icon);
VALA_EXTERN AgWidgetsGeoclue2Dialog* ag_widgets_geoclue2_dialog_construct (GType object_type,
                                                               const gchar* message,
                                                               const gchar* app_name,
                                                               GIcon* icon);
VALA_EXTERN void ag_agent_remember_app (AgAgent* self,
                            const gchar* desktop_id,
                            gboolean authorized,
                            GClueAccuracyLevel accuracy_level);
VALA_EXTERN void ag_geo_clue2_client_stop (AgGeoClue2Client* self,
                               GError** error);
VALA_EXTERN AgAgent* ag_agent_new (void);
VALA_EXTERN AgAgent* ag_agent_construct (GType object_type);
static GObject * ag_agent_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties);
static void _ag_agent___lambda4_ (AgAgent* self,
                           const gchar* key);
static void __ag_agent___lambda4__g_settings_changed (GSettings* _sender,
                                               const gchar* key,
                                               gpointer self);
VALA_EXTERN void ag_geo_clue2_agent_authorize_app (AgGeoClue2Agent* self,
                                       const gchar* desktop_id,
                                       GClueAccuracyLevel req_accuracy_level,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void ag_geo_clue2_agent_authorize_app_finish (AgGeoClue2Agent* self,
                                              GAsyncResult* _res_,
                                              gboolean* authorized,
                                              GClueAccuracyLevel* allowed_accuracy_level,
                                              GError** error);
VALA_EXTERN GClueAccuracyLevel ag_geo_clue2_agent_get_max_accuracy_level (AgGeoClue2Agent* self);
static void ag_agent_finalize (GObject * obj);
static GType ag_agent_get_type_once (void);
static void _vala_ag_agent_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static gint ag_main (gchar** args,
              gint args_length1);

static inline gpointer
ag_agent_get_instance_private (AgAgent* self)
{
	return G_STRUCT_MEMBER_P (self, AgAgent_private_offset);
}

static void
ag_agent_real_activate (GApplication* base)
{
	AgAgent * self;
	self = (AgAgent*) base;
	g_application_hold ((GApplication*) self);
}

static void
ag_agent_on_name (AgAgent* self,
                  GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		guint _tmp0_ = 0U;
		guint _tmp1_;
		if (self->priv->bus_registered) {
			g_dbus_connection_unregister_object (conn, self->priv->object_id);
			self->priv->bus_registered = FALSE;
		}
		g_debug ("Agent.vala:61: Adding agent…");
		_tmp1_ = ag_geo_clue2_agent_register_object (G_TYPE_CHECK_INSTANCE_CAST (self, AG_TYPE_GEO_CLUE2_AGENT, AgGeoClue2Agent), conn, "/org/freedesktop/GeoClue2/Agent", &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->object_id = _tmp0_;
		self->priv->bus_registered = TRUE;
		ag_utils_register_with_geoclue (NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e->message;
		g_error ("Agent.vala:66: Error while registering the agent: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_ag_agent_on_name_gbus_name_appeared_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               const gchar* name_owner,
                                               gpointer self)
{
	ag_agent_on_name ((AgAgent*) self, connection);
}

static gboolean
ag_agent_real_dbus_register (GApplication* base,
                             GDBusConnection* connection,
                             const gchar* object_path,
                             GError** error)
{
	AgAgent * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (AgAgent*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	G_APPLICATION_CLASS (ag_agent_parent_class)->dbus_register ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), connection, object_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp0_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp0_;
	}
	g_bus_watch_name_with_closures (G_BUS_TYPE_SYSTEM, "org.freedesktop.GeoClue2", G_BUS_NAME_WATCHER_FLAGS_AUTO_START, (GClosure*) ((_ag_agent_on_name_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _ag_agent_on_name_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = TRUE;
	return result;
}

static void
ag_agent_real_dbus_unregister (GApplication* base,
                               GDBusConnection* connection,
                               const gchar* object_path)
{
	AgAgent * self;
	self = (AgAgent*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	if (self->priv->bus_registered) {
		g_dbus_connection_unregister_object (connection, self->priv->object_id);
	}
	G_APPLICATION_CLASS (ag_agent_parent_class)->dbus_unregister ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), connection, object_path);
}

static void
ag_agent_real_authorize_app_data_free (gpointer _data)
{
	AgAgentAuthorizeAppData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (AgAgentAuthorizeAppData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
ag_agent_real_authorize_app (AgGeoClue2Agent* base,
                             const gchar* id,
                             GClueAccuracyLevel req_accuracy,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	AgAgent * self;
	AgAgentAuthorizeAppData* _data_;
	AgAgent* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (id != NULL);
	self = (AgAgent*) base;
	_data_ = g_slice_new0 (AgAgentAuthorizeAppData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, ag_agent_real_authorize_app_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_data_->req_accuracy = req_accuracy;
	ag_agent_real_authorize_app_co (_data_);
}

static void
ag_agent_authorize_app_finish (AgGeoClue2Agent* base,
                               GAsyncResult* _res_,
                               gboolean* authorized,
                               GClueAccuracyLevel* allowed_accuracy,
                               GError** error)
{
	AgAgentAuthorizeAppData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (authorized) {
		*authorized = _data_->authorized;
	}
	if (allowed_accuracy) {
		*allowed_accuracy = _data_->allowed_accuracy;
	}
}

static void
ag_agent_authorize_app_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	AgAgentAuthorizeAppData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	ag_agent_real_authorize_app_co (_data_);
}

static gboolean
ag_agent_real_authorize_app_co (AgAgentAuthorizeAppData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("Agent.vala:86: Request for '%s' at level '%u'", _data_->id, (guint) _data_->req_accuracy);
	_data_->_tmp0_ = g_strconcat (_data_->id, ".desktop", NULL);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_desktop_app_info_new (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_free0 (_data_->_tmp1_);
	_data_->app_info = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->app_info;
	if (_data_->_tmp4_ == NULL) {
		g_debug ("Agent.vala:90: Rejecting for invalid desktop file");
		_data_->authorized = FALSE;
		_data_->allowed_accuracy = _data_->req_accuracy;
		_g_object_unref0 (_data_->app_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->settings;
	_data_->_tmp6_ = g_settings_get_value (_data_->_tmp5_, "remembered-apps");
	_data_->remembered_apps = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->remembered_apps;
	_data_->_tmp8_ = g_variant_dict_new (_data_->_tmp7_);
	_data_->remembered_apps_dict = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->remembered_apps_dict;
	_data_->_tmp10_ = G_VARIANT_TYPE_TUPLE;
	_data_->_tmp11_ = g_variant_dict_lookup_value (_data_->_tmp9_, _data_->id, _data_->_tmp10_);
	_data_->remembered_accuracy = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->remembered_accuracy;
	if (_data_->_tmp12_ != NULL) {
		_data_->_tmp13_ = _data_->remembered_accuracy;
		_data_->_tmp14_ = FALSE;
		_data_->_tmp15_ = 0;
		g_variant_get (_data_->_tmp13_, "(bu)", &_data_->_tmp14_, &_data_->_tmp15_, NULL);
		_data_->stored_auth = _data_->_tmp14_;
		_data_->stored_accuracy = _data_->_tmp15_;
		if (_data_->stored_auth) {
			_data_->_tmp16_ = _data_->req_accuracy <= _data_->stored_accuracy;
		} else {
			_data_->_tmp16_ = FALSE;
		}
		if (_data_->_tmp16_) {
			_data_->authorized = TRUE;
			_data_->allowed_accuracy = _data_->req_accuracy;
			_g_variant_unref0 (_data_->remembered_accuracy);
			_g_variant_dict_unref0 (_data_->remembered_apps_dict);
			_g_variant_unref0 (_data_->remembered_apps);
			_g_object_unref0 (_data_->app_info);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp17_ = _data_->app_info;
	_data_->_tmp18_ = g_app_info_get_display_name ((GAppInfo*) _data_->_tmp17_);
	_data_->app_name = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->app_name;
	_data_->_tmp20_ = ag_agent_accuracy_to_string (_data_->self, _data_->_tmp19_, (guint) _data_->req_accuracy);
	_data_->accuracy_string = _data_->_tmp20_;
	_data_->_state_ = 1;
	ag_utils_get_geoclue2_client (ag_agent_authorize_app_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp21_ = ag_utils_get_geoclue2_client_finish (_data_->_res_);
	_g_object_unref0 (_data_->self->priv->client);
	_data_->self->priv->client = _data_->_tmp21_;
	g_debug ("Agent.vala:114: Starting client…");
	_data_->_tmp22_ = _data_->self->priv->client;
	if (_data_->_tmp22_ != NULL) {
		{
			_data_->_tmp23_ = _data_->self->priv->client;
			ag_geo_clue2_client_start (_data_->_tmp23_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp24_ = _data_->e->message;
			g_error ("Agent.vala:119: Could not start client: %s", _data_->_tmp24_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->accuracy_string);
			_g_variant_unref0 (_data_->remembered_accuracy);
			_g_variant_dict_unref0 (_data_->remembered_apps_dict);
			_g_variant_unref0 (_data_->remembered_apps);
			_g_object_unref0 (_data_->app_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp25_ = _data_->accuracy_string;
	_data_->_tmp26_ = _data_->app_name;
	_data_->_tmp27_ = _data_->app_info;
	_data_->_tmp28_ = g_app_info_get_icon ((GAppInfo*) _data_->_tmp27_);
	_data_->_tmp29_ = ag_widgets_geoclue2_dialog_new (_data_->_tmp25_, _data_->_tmp26_, _data_->_tmp28_);
	g_object_ref_sink (_data_->_tmp29_);
	_data_->dialog = _data_->_tmp29_;
	_data_->_tmp30_ = _data_->dialog;
	gtk_widget_show_all ((GtkWidget*) _data_->_tmp30_);
	_data_->_tmp31_ = _data_->dialog;
	_data_->_result_ = gtk_dialog_run ((GtkDialog*) _data_->_tmp31_);
	if (_data_->_result_ == ((gint) GTK_RESPONSE_YES)) {
		_data_->authorized = TRUE;
	} else {
		_data_->authorized = FALSE;
	}
	_data_->_tmp32_ = _data_->dialog;
	gtk_widget_destroy ((GtkWidget*) _data_->_tmp32_);
	_data_->allowed_accuracy = _data_->req_accuracy;
	ag_agent_remember_app (_data_->self, _data_->id, _data_->authorized, _data_->req_accuracy);
	g_debug ("Agent.vala:138: Stopping client…");
	_data_->_tmp33_ = _data_->self->priv->client;
	if (_data_->_tmp33_ != NULL) {
		{
			_data_->_tmp34_ = _data_->self->priv->client;
			ag_geo_clue2_client_stop (_data_->_tmp34_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp35_ = _data_->_vala1_e->message;
			g_error ("Agent.vala:143: Could not stop client: %s", _data_->_tmp35_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->dialog);
			_g_free0 (_data_->accuracy_string);
			_g_variant_unref0 (_data_->remembered_accuracy);
			_g_variant_dict_unref0 (_data_->remembered_apps_dict);
			_g_variant_unref0 (_data_->remembered_apps);
			_g_object_unref0 (_data_->app_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->dialog);
	_g_free0 (_data_->accuracy_string);
	_g_variant_unref0 (_data_->remembered_accuracy);
	_g_variant_dict_unref0 (_data_->remembered_apps_dict);
	_g_variant_unref0 (_data_->remembered_apps);
	_g_object_unref0 (_data_->app_info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
ag_agent_accuracy_to_string (AgAgent* self,
                             const gchar* app_name,
                             guint accuracy)
{
	const gchar* message = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (app_name != NULL, NULL);
	switch (accuracy) {
		case GCLUE_ACCURACY_LEVEL_COUNTRY:
		{
			message = _ ("the current country");
			break;
		}
		case GCLUE_ACCURACY_LEVEL_CITY:
		{
			message = _ ("the nearest city or town");
			break;
		}
		case GCLUE_ACCURACY_LEVEL_NEIGHBORHOOD:
		{
			message = _ ("the nearest neighborhood");
			break;
		}
		case GCLUE_ACCURACY_LEVEL_STREET:
		{
			message = _ ("the nearest street");
			break;
		}
		case GCLUE_ACCURACY_LEVEL_EXACT:
		{
			message = _ ("your exact location");
			break;
		}
		default:
		{
			message = _ ("your location");
			break;
		}
	}
	_tmp0_ = message;
	_tmp1_ = g_strdup_printf (_ ("%s will be able to detect %s. Permissions can be changed in <a href='s" \
"ettings://security/privacy/location'>Location Settings…</a>"), app_name, _tmp0_);
	result = _tmp1_;
	return result;
}

void
ag_agent_remember_app (AgAgent* self,
                       const gchar* desktop_id,
                       gboolean authorized,
                       GClueAccuracyLevel accuracy_level)
{
	GVariant* remembered_apps = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariantDict* remembered_apps_dict = NULL;
	GVariantDict* _tmp2_;
	GVariant* val = NULL;
	GVariant* _tmp3_;
	GSettings* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (desktop_id != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "remembered-apps");
	remembered_apps = _tmp1_;
	_tmp2_ = g_variant_dict_new (remembered_apps);
	remembered_apps_dict = _tmp2_;
	_tmp3_ = g_variant_new ("(bu)", authorized, accuracy_level, NULL);
	g_variant_ref_sink (_tmp3_);
	val = _tmp3_;
	g_variant_dict_insert_value (remembered_apps_dict, desktop_id, val);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_variant_dict_end (remembered_apps_dict);
	g_variant_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	g_settings_set_value (_tmp4_, "remembered-apps", _tmp6_);
	_g_variant_unref0 (_tmp6_);
	_g_variant_unref0 (val);
	_g_variant_dict_unref0 (remembered_apps_dict);
	_g_variant_unref0 (remembered_apps);
}

AgAgent*
ag_agent_construct (GType object_type)
{
	AgAgent * self = NULL;
	self = (AgAgent*) g_object_new (object_type, NULL);
	return self;
}

AgAgent*
ag_agent_new (void)
{
	return ag_agent_construct (AG_TYPE_AGENT);
}

static GClueAccuracyLevel
ag_agent_real_get_max_accuracy_level (AgGeoClue2Agent* base)
{
	GClueAccuracyLevel result;
	AgAgent* self;
	gboolean enabled = FALSE;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	self = (AgAgent*) base;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "location-enabled");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_boolean (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	enabled = _tmp3_;
	if (enabled) {
		result = GCLUE_ACCURACY_LEVEL_EXACT;
		return result;
	} else {
		result = GCLUE_ACCURACY_LEVEL_NONE;
		return result;
	}
}

static void
_ag_agent___lambda4_ (AgAgent* self,
                      const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "location-enabled") == 0) {
		g_object_notify ((GObject*) self, "max-accuracy-level");
	}
}

static void
__ag_agent___lambda4__g_settings_changed (GSettings* _sender,
                                          const gchar* key,
                                          gpointer self)
{
	_ag_agent___lambda4_ ((AgAgent*) self, key);
}

static GObject *
ag_agent_constructor (GType type,
                      guint n_construct_properties,
                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AgAgent * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	parent_class = G_OBJECT_CLASS (ag_agent_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AG_TYPE_AGENT, AgAgent);
	g_application_set_application_id ((GApplication*) self, "io.elementary.desktop.agent-geoclue2");
	_tmp0_ = g_application_get_application_id ((GApplication*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new (_tmp1_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = self->priv->settings;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) __ag_agent___lambda4__g_settings_changed, self, 0);
	return obj;
}

static void
ag_agent_class_init (AgAgentClass * klass,
                     gpointer klass_data)
{
	ag_agent_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AgAgent_private_offset);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) ag_agent_real_activate;
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) ag_agent_real_dbus_register;
	((GApplicationClass *) klass)->dbus_unregister = (void (*) (GApplication*, GDBusConnection*, const gchar*)) ag_agent_real_dbus_unregister;
	G_OBJECT_CLASS (klass)->get_property = _vala_ag_agent_get_property;
	G_OBJECT_CLASS (klass)->constructor = ag_agent_constructor;
	G_OBJECT_CLASS (klass)->finalize = ag_agent_finalize;
}

static void
ag_agent_ag_geo_clue2_agent_interface_init (AgGeoClue2AgentIface * iface,
                                            gpointer iface_data)
{
	ag_agent_ag_geo_clue2_agent_parent_iface = g_type_interface_peek_parent (iface);
	iface->authorize_app = (void (*) (AgGeoClue2Agent*, const gchar*, GClueAccuracyLevel, GAsyncReadyCallback, gpointer)) ag_agent_real_authorize_app;
	iface->authorize_app_finish = (void (*) (AgGeoClue2Agent*, GAsyncResult*, gboolean*, GClueAccuracyLevel*, GError**)) ag_agent_authorize_app_finish;
	iface->get_max_accuracy_level = ag_agent_real_get_max_accuracy_level;
}

static void
ag_agent_instance_init (AgAgent * self,
                        gpointer klass)
{
	self->priv = ag_agent_get_instance_private (self);
	self->priv->bus_registered = FALSE;
	self->priv->client = NULL;
}

static void
ag_agent_finalize (GObject * obj)
{
	AgAgent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AG_TYPE_AGENT, AgAgent);
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (ag_agent_parent_class)->finalize (obj);
}

static GType
ag_agent_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AgAgentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ag_agent_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AgAgent), 0, (GInstanceInitFunc) ag_agent_instance_init, NULL };
	static const GInterfaceInfo ag_geo_clue2_agent_info = { (GInterfaceInitFunc) ag_agent_ag_geo_clue2_agent_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType ag_agent_type_id;
	ag_agent_type_id = g_type_register_static (gtk_application_get_type (), "AgAgent", &g_define_type_info, 0);
	g_type_add_interface_static (ag_agent_type_id, AG_TYPE_GEO_CLUE2_AGENT, &ag_geo_clue2_agent_info);
	AgAgent_private_offset = g_type_add_instance_private (ag_agent_type_id, sizeof (AgAgentPrivate));
	return ag_agent_type_id;
}

GType
ag_agent_get_type (void)
{
	static volatile gsize ag_agent_type_id__once = 0;
	if (g_once_init_enter (&ag_agent_type_id__once)) {
		GType ag_agent_type_id;
		ag_agent_type_id = ag_agent_get_type_once ();
		g_once_init_leave (&ag_agent_type_id__once, ag_agent_type_id);
	}
	return ag_agent_type_id__once;
}

static void
_vala_ag_agent_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	AgAgent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AG_TYPE_AGENT, AgAgent);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gint
ag_main (gchar** args,
         gint args_length1)
{
	AgAgent* agent = NULL;
	AgAgent* _tmp0_;
	gint result;
	_tmp0_ = ag_agent_new ();
	agent = _tmp0_;
	result = g_application_run ((GApplication*) agent, (gint) args_length1, args);
	_g_object_unref0 (agent);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return ag_main (argv, argc);
}

